/* picoTab.c
 * 29dec90abu
 */

#include "pico.h"

symInit picoSyms[] = {
	{"ABS",			Abs},
	{"ACCESS",		Access},
	{"ADD",			Add},
	{"ADD1",		Add1},
	{"ADD2",		Add2},
	{"ALL",			All},
	{"ALLOC",		Alloc},
	{"AND",			And},
	{"APPEND",		Append},
	{"APPLY",		Apply},
	{"ARRAY",		Array},
	{"ASCII",		Ascii},
	{"ASSOC",		Assoc},
	{"ATOM",		Atom},
	{"AVAIL",		Avail},
	{"BACKSP",		Backsp},
	{"BAUD",		Baud},
	{"BELL",		Bell},
	{"BENCH",		pBench},
	{"BEST",		Best},
	{"BIT",			pBit},
	{"BITL",		Bitl},
	{"BITR",		Bitr},
	{"BITAND",		pBitAnd},
	{"BITNOT",		pBitNot},
	{"BITOFF",		pBitOff},
	{"BITON",		pBitOn},
	{"BITOR",		pBitOr},
	{"BITXOR",		pBitXor},
	{"BLOCK",		Block},
	{"BOUNDP",		Boundp},
	{"BOUNDS",		Bounds},
	{"BOTTOM",		Cddr},
	{"BREAK$",		BreakFun},
	{"BYTE",		AccByte},
	{"CAMERA",		Camera},
	{"CAR",			Car},
	{"CDR",			Cdr},
	{"CAAR",		Caar},
	{"CADR",		Cadr},
	{"CDAR",		Cdar},
	{"CDDR",		Cddr},
	{"CAAAR",		Caaar},
	{"CAADR",		Caadr},
	{"CADAR",		Cadar},
	{"CADDR",		Caddr},
	{"CDAAR",		Cdaar},
	{"CDADR",		Cdadr},
	{"CDDAR",		Cddar},
	{"CDDDR",		Cdddr},
	{"CADDDR",		Cadddr},
	{"CDDDDR",		Cddddr},
	{"CASE",		Case},
	{"CATCH",		Catch},
	{"CHECK",		Check},
	{"CHOP",		Chop},
	{"CLASS",		Class},
	{"CLOSE",		Close},
	{"COMMENT",		Comment},
	{"COND",		Cond},
	{"CONS",		Cons},
	{"CONS2",		Cons2},
	{"COPY",		Copy},
	{"COS",			Cos},
	{"CRASH",		Crash},
	{"CREATE",		Creat},
	{"CUT",			Cut},
	{"CUTPR",		CutPr},
	{"DATE",		pDate},
	{"DE",			De},
	{"DEC",			Dec},
	{"DEFAULT",		Default},
	{"DEFINE",		Define},
	{"DEGRAF",		DeGraf},
	{"DELAY",		DelayTicks},
	{"DELETE",		Delete},
	{"DELIM",		Delim},
	{"DEMON",		Demon},
	{"DEPTH",		Depth},
	{"DIFF",		Diff},
	{"DIGIT",		Digit},
	{"DIR",			Dir},
	{"DISTPT",		DistPt},
	{"DIV",			Div},
	{"DIV2",		Div2},
	{"DO",			Do},
	{"DRAW",		Draw},
	{"DUMP",		Dump},
	{"DYNAMO",		Dynamo},
	{"ENUM",		Enum},
	{"EQ",			Eq},
	{"EQUAL",		Equal},
	{"ERASE",		Erase},
	{"ERROR",		Error},
	{"EVAL",		Eval},
	{"FILTER",		Filter},
	{"FIND",		Find},
	{"FLAG",		Flag},
	{"FLAGP",		Flagp},
	{"FLAGS",		Flags},
	{"FOR",			For},
	{"FORMAT",		Format},
	{"FREE",		Free},
	{"FREEZE",		Freeze},
	{"FROM",		From},
	{"FTYPE",		FType},
	{"FUNP",		Funp},
	{"GC",			Gc},
	{"GENSYM",		Gensym},
	{"GET",			Get},
	{"GETC",		Getc},
	{"GETD",		Getd},
	{"GETFILE",		GetFile},
	{"GETLINE",		GetLine},
	{"GETVOL",		pGetVol},
	{"GRAF",		Graf},
	{"GRAFPT",		GrafPt},
	{"HIGH",		High},
	{"HITKEY",		HitKey},
	{"HOW",			How},
	{"IF",			If},
	{"INC",			Inc},
	{"INDEX",		Index},
	{"INGRAF",		InGraf},
	{"INSERT",		Insert},
	{"INTSEC",		Intsec},
	{"KEY",			Key},
	{"LAST",		Last},
	{"LAST2",		Last2},
	{"LEFT",		Caar},
	{"LENGTH",		Length},
	{"LEQ",			Leq},
	{"LESSP",		Lessp},
	{"LETTER",		Letter},
	{"LIMIT",		Limit},
	{"LIST",		List},
	{"LISTP",		Listp},
	{"LOAD",		Load},
	{"LOC",			Loc},
	{"LOCAL",		Local},
	{"LOOP",		Loop},
	{"LOW",			Low},
	{"LOWC",		Lowc},
	{"MAP",			Map},
	{"MAP2",		Map2},
	{"MAPC",		Mapc},
	{"MAPC2",		Mapc2},
	{"MAPCAN",		Mapcan},
	{"MAPCAN2",		Mapcan2},
	{"MAPCAR",		Mapcar},
	{"MAPCAR2",		Mapcar2},
	{"MAPCON",		Mapcon},
	{"MAPCON2",		Mapcon2},
	{"MAPLIST",		Maplist},
	{"MAPLIST2",	Maplist2},
	{"MATCH",		Match},
	{"MAX",			Max},
	{"MAY",			May},
	{"MEMBER",		Member},
	{"MEMQ",		Memq},
	{"METHOD",		Method},
	{"MIDDLE",		Middle},
	{"MIN",			Min},
	{"MINUS",		Minus},
	{"MINUSP",		Minusp},
	{"MOD",			Mod},
	{"MUL",			Mul},
	{"MUL2",		Mul2},
	{"MULDIV",		Muldiv},
	{"MVGRAF",		MvGraf},
	{"NAND",		Nand},
	{"NCONC",		Nconc},
	{"NCONC1",		Nconc1},
	{"NEQ",			Neq},
	{"NEW",			New},
	{"NEXTPT",		NextPt},
	{"NOOP",		evalBody},
	{"NOR",			Nor},
	{"NOT",			Not},
	{"NTH",			Nth},
	{"NTHCDR",		Nthcdr},
	{"NULL",		Not},
	{"NUMBER",		Number},
	{"NUMBERP",		Numberp},
	{"OBLIST",		Oblist},
	{"OFF",			Off},
	{"ON",			On},
	{"ONGRAF",		OnGraf},
	{"ONLINE",		OnLine},
	{"OPEN",		Open},
	{"OR",			Or},
	{"PACK",		Pack},
	{"PATH",		Path},
	{"PAINT",		Paint},
	{"PAIRP",		Pairp},
	{"PARALL",		Parall},
	{"PIPE",		Pipe},
	{"PLIST",		Plist},
	{"PLOT",		Plot},
	{"PLUSP",		Plusp},
	{"PNAME",		Pname},
	{"POINT",		AccPoint},
	{"POINTP",		Pointp},
	{"POP",			Pop},
	{"PRHEX",		PrHex},
	{"PRINT",		Print},
	{"PRIN1",		Prin1},
	{"PRIN2",		Prin2},
	{"PRLINE",		PrLine},
	{"PROGN",		evalBody},
	{"PROG1",		Prog1},
	{"PROG2",		Prog2},
	{"PTR",			AccPtr},
	{"PUSH",		Push},
	{"PUSH1",		Push1},
	{"PUT",			Put},
	{"PUTC",		Putc},
	{"PUTD",		Putd},
	{"PUTFILE",		PutFile},
	{"QUIT",		Quit},
	{"RANDOM",		pRandom},
	{"RASTER",		Raster},
	{"READ",		Read},
	{"READBLOCK",	ReadBlock},
	{"RECT",		AccRect},
	{"RECTP",		Rectp},
	{"REF",			Ref},
	{"REF2",		Ref2},
	{"REMOB",		Remob},
	{"REMOVE",		Remove},
	{"RENAME",		fRename},
	{"REPEAT",		Repeat},
	{"REPTN",		Reptn},
	{"REVALO",		Revalo},
	{"REVERSE",		Reverse},
	{"RIGHT",		Cadr},
	{"RPLACA",		Rplaca},
	{"RPLACD",		Rplacd},
	{"SCAN",		Scan},
	{"SECT",		Sect},
	{"SEEK",		Seek},
	{"SERIAL",		Serial},
	{"SET",			Set},
	{"SETFLAGS",	SetFlags},
	{"SETPLIST",	Setplist},
	{"SETQ",		Setq},
	{"SETVOL",		pSetVol},
	{"SHIFT",		Shift},
	{"SIN",			Sin},
	{"SIZE",		pSize},
	{"SLOT",		Slot},
	{"SLOT*",		SlotStar},
	{"SORT",		Sort},
	{"SPACE",		Space},
	{"SQR",			Square},
	{"SQRT",		Sqrt},
	{"STORE",		Store},
	{"STRING",		AccString},
	{"STRINGP",		Stringp},
	{"STRLEN",		StrLen},
	{"STUFF",		Stuff},
	{"SUB",			Sub},
	{"SUB1",		Sub1},
	{"SUB2",		Sub2},
	{"SUBST",		Subst},
	{"SUPER",		Super},
	{"SWAP",		Swap},
	{"SYMBOL",		Symbol},
	{"SYMBOLP",		Symbolp},
	{"SYSP",		Sysp},
	{"TAB",			Tab},
	{"TAIL",		Tail},
	{"TAN",			Tan},
	{"TERPRI",		Terpri},
	{"THROW",		Throw},
	{"TIME",		pTime},
	{"TO",			To},
	{"TOGGLE",		Toggle},
	{"TOP",			Cdar},
	{"TRACK",		Track},
	{"TRAIL",		Trail},
	{"TRACE$",		TraceFun},
	{"TTY",			Tty},
	{"UNLESS",		Unless},
	{"UNPACK",		UnPack},
	{"UNTIL",		Until},
	{"UPC",			Upc},
	{"VALUE",		Value},
	{"VARP",		Varp},
	{"WHEN",		When},
	{"WHERE",		Where},
	{"WHILE",		While},
	{"WHO",			Who},
	{"WILD",		Wild},
	{"WITH",		With},
	{"WORST",		Worst},
	{"WRITEBLOCK",	WriteBlock},
	{"WORD",		AccWord},
	{"XCHG",		Xchg},
	{"ZAP",			Zap},
	{"ZERO",		Zero},
	{"ZEROP",		Zerop},
#if 0
	{"QUOTE",		Quote},	/* Created below */
	{"LAMBDA",		Lambda},
	{"OBJECT",		Object},
#endif
	NULL
};

pico init1Sym(s,f,v)
char *s;
bool f;
pico v;
{
	register pico x,name;

	if (!(x = find(name = compressName(s))))
		x = intern(newSym(name, voidSym));
	if (f)
		setVal(x, v);
	return x;
}

void initSymTab(s)
register symInit *s;
{
	if (fresh)
		while (s->nameInit) {
			init1Sym(s->nameInit, YES, boxFun(s->funInit));
			++s;
		}
}

void initSymbols()
{
	register pico x;
	register int i;

	if (fresh) {
		mapCell = newCell(mapSym = newSym(compressName("$VOID$"),NULL),NULL); /* Dummy arglist */
		mapCell2 = newCell(mapSym2 = newSym(compressName("$VOID$"),NULL), mapCell);
		x = mapCell3 = newCell(mapSym3 = newSym(compressName("$VOID$"),NULL), mapCell2);
		i = APPLYMAX-3;
		do
			x = newCell(newSym(compressName("$VOID$"),NULL),x);
		while (--i);
		applyList = x;
		nilSym = newSym(compressName("NIL"), NULL); /* NIL object itself */
		newCell(nilSym,nilSym); /* Dummy cell as CDR of nilSym */
		setCdr(mapCell, nilSym);
		setVal(nilSym, nilSym);
		for (i=0; i<=THREADS; ++i)
			env.threads[i] = nilSym;
		intern(nilSym);
	}
	else {
		mapSym = mkSym(heap);
		mapCell = heap + 1;
		mapSym2 = mkSym(heap + 2);
		mapCell2 = heap + 3;
		mapSym3 = mkSym(heap + 4);
		mapCell3 = heap + 5;
		applyList = heap  + 2*APPLYMAX - 1;
		nilSym = mkSym(heap  + 2*APPLYMAX);
	}
	*markPtr(mkCell(nilSym)+1) &= ~1;
	voidSym = init1Sym("VOID",NO,NULL), setVal(voidSym, voidSym);
	tSym = init1Sym("T",NO,NULL), setVal(tSym, tSym); /* Last protected symbol */
	init1Sym("*MAX",fresh,boxNum(MAXNUM));
	init1Sym("*MIN",fresh,boxNum(MAXNEG));
	quoteSym = init1Sym("QUOTE", YES, boxFun(Quote));
	lambdaSym = init1Sym("LAMBDA", YES, boxFun(Lambda));
	shareFlg = init1Sym("*SHARE",fresh,nilSym);
	objectSym = init1Sym("OBJECT", YES, boxFun(Object));
	classSym = init1Sym("*CLASS",fresh,nilSym);
	taskSym = init1Sym("*TASK",fresh,nilSym);
	quitSym = init1Sym("*QUIT",fresh,nilSym);
	fileSym = init1Sym("*FILES",fresh,nilSym);
	loadSym = init1Sym("*LOAD",fresh,nilSym);
	editSym = init1Sym("*EDIT",fresh,nilSym);
	echoFlg = init1Sym("*ECHO",fresh,nilSym);
	srcFlg = init1Sym("*SRC",fresh,tSym);
	logFlg = init1Sym("*LOG",fresh,nilSym);
	macFlg = init1Sym("*MACRO",fresh,nilSym);
	againSym = init1Sym("*AGAIN",fresh,tSym);
	fkeySym = init1Sym("*FKEY",fresh,nilSym);
	star6Sym = init1Sym("******",YES,nilSym);
	star5Sym = init1Sym("*****",YES,nilSym);
	star4Sym = init1Sym("****",YES,nilSym);
	star3Sym = init1Sym("***",YES,nilSym);
	star2Sym = init1Sym("**",YES,nilSym);
	star1Sym = init1Sym("*",YES,nilSym);
	initSysVars();
	initAppVars();
	dolSym = init1Sym("$",fresh,nilSym); /* Last un-REMOB-able symbol */

	initSymTab(picoSyms);
	initSysSyms();
	initApplication();
}
