[sample.l 22may90]

[+++ Initialize everything +++]
<de init ()
   (OpenResFile "Rsrc")
   (SetMenuBar
      (setq *mBar (GetNewMBar mBar)) )
   (AddResMenu (GetMenu appleM) "DRVR")
   (DrawMenuBar)
   (setq *event (alloc 16))
   (go) >


[+++ Extend PICAPP +++]
[+ Standard Menu commands +]
<to #(cmd fileM newCmd) picApp ()
   (new 'sample) >

<to #(cmd fileM openCmd) picApp ()
   (print 'open) >

<to #(cmd fileM closeCmd) picApp (obj)
   (do close obj) >

<to #(cmd fileM quitCmd) picApp ()
   (do quit 'boss) >


[+++ The IDLE Application +++]
(object idle)

[+ Command keyDown +]
<to keyDown (obj c m)
   (unless (zerop (bitand cmdKey m))
      (when (setq m (method (MenuKey c) obj))
         (m obj)
         (HiliteMenu 0) >

[+ Inherit standard menu commands from PICAPP +]
<to #(cmd fileM newCmd) ()
   (from picApp #(cmd fileM newCmd)) >

<to #(cmd fileM openCmd) ()
   (from picApp #(cmd fileM openCmd)) >

<to #(cmd fileM quitCmd) ()
   (from picApp #(cmd fileM quitCmd)) >

[+ Maintain Menus +]
<to able ()
   (doMenu fileM
      t nil
      t nil
      nil nil
      nil nil
      nil nil
      nil nil
      nil nil
      nil nil
      nil nil
      nil nil
      t nil )
   (doMenu editM >


[+++ A Sample Application +++]
(object sample edApp)

<to t (obj)
   (from edApp t obj (100.100) 400 200 (pname obj))
   [+ (with obj
      (slot teRec
         (TENew
            '#(cons2 4 4 396 196)
            (InsetRect (viewRect (slot winPtr)) 4 4) ) ) ) +]
   (do start 'boss obj) >

<to close (obj)
   [+ (with obj
      (TEDispose (slot teRec)) ) +]
   (from picApp close obj) >

[++++++
<to begin (obj)
   (TEActivate (get obj 'teRec)) >

<to end (obj)
   (TEDeactivate (get obj 'teRec)) >
++++++]

[+ KeyDown events +]
<to keyDown (obj c m)
   (if (zerop (bitand cmdKey m))
      (do type obj c)
      (when (setq m (method (MenuKey c) obj))
         (m obj)
         (HiliteMenu 0) >

<to autoKey (obj c m)
   (do keyDown obj c m) >

[++++++
<to #(cmd editM cutCmd) (obj)
   (TECut (get obj 'teRec)) >

<to #(cmd editM copyCmd) (obj)
   (TECopy (get obj 'teRec)) >

<to #(cmd editM pasteCmd) (obj)
   (TEPaste (get obj 'teRec)) >

<to #(cmd editM clearCmd) (obj)
   (TEDelete (get obj 'teRec)) >
++++++]


[+ Maintain Menus +]
<to able (obj)
   (local (s)
      (with obj
         (setq s
            (nand
               (eq (slot lin1) (slot lin2))
               (eq (slot col1) (slot col2)) ) )
         (doMenu fileM
            t nil
            t nil
            nil nil
            t nil
            nil nil
            nil nil
            nil nil
            nil nil
            nil nil
            nil nil
            t nil )
         (doMenu editM
            nil nil
            nil nil
            s nil
            s nil
            t nil
            s nil >

t [sample.l]
