[txtApp.l 21jun90]


(object txtApp txtWin)

<to close (obj)
   (from txtWin close obj)
   (do stop 'boss obj) >

<to content (obj pt $foo $bar)
   (from picApp content obj pt $foo $bar) >

[+ Set the mouse cursor +]
<to setCursor (obj pt)
   (localPort (get obj 'winPtr)
      (when (eq *port (FrontWindow))
         (GlobalToLocal pt)
         (SetCursor
            (if (inView pt *port)
               (ptr (GetCursor iBeamCursor))
               *arrow >

<to type (obj c)
   (TEKey c (get obj 'teRec))
   (do touch obj)
   (teProp obj)
   (do adjust obj) >

<to delete (obj)
   (do touch obj)
   (TEDelete (get obj 'teRec)) >

<to insert (obj s)
   (local (n buf)
      (setq
         n (length s)
         buf (alloc (add1 n)) )
      (string buf s)
      (do touch obj)
      (TEInsert (add1 buf) n nil (get obj 'teRec))
      (do adjust obj)
      (free buf) >

<to append (obj s)
   (with obj
      (TESetSelect 32767 32767 (slot teRec))
      (do insert obj (nconc1 s \^M)) >

<to hiLines (obj n1 n2)
   (default n2 n1)
   (local (r s)
      (with obj
         (TEActivate (slot teRec))
         (TESetSelect
            (word (add 96 (mul2 n1) (ptr (slot teRec))))
            (word (add 96 (mul2 n2) (ptr (slot teRec))))
            (slot teRec) )
         (setq
            r (te-viewRect (ptr (slot teRec)))
            s (sub (bottom r) (top r))
            n1 (mul n1 (slot height))
            n2 (minus (mul n2 (slot height))) )
         (if (lessp (sub s (slot pos-v)) n1)
            (txPos 0 (min 0 (sub s n1 (mul2 (slot height)))))
            (if (lessp (slot pos-v) n2)
               (txPos 0 (add n2 (slot height))) ) )
         (do adjSBars obj) >

<to getLine (obj n)
   (local (teH tx ty p buf s)
      (with obj
         (setq teH (slot teRec))
         (when (lessp n (te-nlines (ptr teH)))
            (setq
               tx (HLock (TEGetText teH))
               ty (add tx (te-teLength (ptr teH)))
               p (add tx (word (add 96 (mul2 n) (ptr teH))))
               buf (alloc 256)
               s buf )
            (byte s 0)
            (while
               (and
                  (neq \^M (byte p))
                  (lessp p ty)
                  (lessp (byte buf) 256))
               (byte buf (add1 (byte buf)))
               (byte (inc s) (byte p))
               (inc p) )
            (HUnlock tx)
            (prog1
               (or (string buf) (-1))
               (free buf) >

[++++++
<to getText (obj)
   (local (n txt)
      (setq
         n (te-nlines (ptr (get obj 'teRec)))
         txt )
      (while (plusp n)
         (push
            (do getLine obj (dec n))
            txt ) )
      txt >
++++++]

t
