/*
	File: AcquireInterface.h

	Copyright 1990 by Thomas Knoll.

	This file describes version 3 of Photoshop's Acquisition module interface.
*/

/* Operation selectors */

#define acquireSelectorAbout	0
#define acquireSelectorStart	1
#define acquireSelectorContinue 2
#define acquireSelectorFinish	3
#define acquireSelectorPrepare	4

/* Image modes */

#define acquireModeBitmap		0
#define acquireModeGrayScale	1
#define acquireModeIndexedColor 2
#define acquireModeRGBColor 	3
#define acquireModeCMYKColor	4
#define acquireModeHSLColor 	5
#define acquireModeHSBColor 	6
#define acquireModeMultichannel 7

/*	Error return values. The plug-in module may also return standard Macintosh
	operating system error codes, or report its own errors, in which case it
	can return any positive integer. */

#define acquireBadParameters	-30000	/* "a problem with the acquisition module interface" */
#define acquireNoScanner		-30001	/* "there is no scanner installed" */
#define acquireScannerProblem	-30002	/* "a problem with the scanner" */

typedef unsigned char AcquireLUT [256];

typedef struct AcquireRecord {

	long		serialNumber;		/* Photoshop's serial number, to allow
									   copy protected plug-in modules. */
	ProcPtr 	abortProc;			/* The plug-in module may call this no-argument
									   BOOLEAN function (using Pascal calling
									   conventions) several times a second during long
									   operations to allow the user to abort the operation.
									   If it returns TRUE, the operation should be aborted
									   (and a positive error code returned). */
	ProcPtr 	progressProc;		/* The plug-in module may call this two-argument
									   procedure (using Pascal calling conventions)
									   periodically to update a progress indicator.
									   The first parameter (type LONGINT) is the number
									   of operations completed; the second (type LONGINT)
									   is the total number of operations. */

	long		maxData;			/* Maximum number of bytes that should be
									   passed back at once, plus the size of any
									   interal buffers. The plug-in may reduce this
									   value in the acquireSelectorPrepare routine. */

	short		imageMode;			/* Image mode */
	Point		imageSize;			/* Size of image */
	short		depth;				/* Bits per sample, currently must be 1 or 8 */
	short		planes; 			/* Samples per pixel */
	Fixed		imageHRes;			/* Pixels per inch */
	Fixed		imageVRes;			/* Pixels per inch */
	AcquireLUT	redLUT; 			/* Red LUT, only used for Indexed Color images */
	AcquireLUT	greenLUT;			/* Green LUT, only used for Indexed Color images */
	AcquireLUT	blueLUT;			/* Blue LUT, only used for Indexed Color images */

	Ptr 		data;				/* A pointer to the returned image data. The
									   plug-in module is now responsible for freeing
									   this buffer (this is a change from previous
									   versions). Should be set to NIL when
									   all the image data has been returned. */
	Rect		theRect;			/* Rectangle being returned */
	short		loPlane;			/* First plane being returned */
	short		hiPlane;			/* Last plane being returned */
	short		colBytes;			/* Spacing between columns */
	long		rowBytes;			/* Spacing between rows */
	long		planeBytes; 		/* Spacing between planes (ignored if only one
									   plane is returned at a time) */

	Str255		filename;			/* Document file name */
	short		vRefNum;			/* Volume reference number, or zero if none */
	Boolean 	dirty;				/* Changes since last saved flag. The plug-in may clear
									   this field to prevent prompting the user when
									   closing the document. */

	} AcquireRecord, *AcquireRecordPtr;
