/* retch.h
 * 29aug92abu
 */

#include ":src:pico.h"
#include ":src:mac.h"

#define TFHEAD		266							/* TileFileHeader Size */
#define TILE		32								/* Tile: 32*32 pixels */
#define TILE2		1024
#define NTILES		20								/* 20*20 tiles per retouch window */
#define WINSIZE	((long)(TILE*NTILES))	/* 640*640 pixel per retouch window */
#define TILEBUFF	(4*TILE*TILE)				/* Size of one tile */
#define MAXBLOT	16
#define PEEP		256							/* Max size of peep window */

#define inCmyk(x)		(0<=x && x<640)
#define blend(x,y,w)	((x*w + y*(255-w))/255)

extern OSType creator;
extern integer binVol;

/* Prototypes */
extern void memFill(void*,int,int);
extern void cmykRGB(uchar*,uchar*,int,int,int);
extern void move1Plane(uchar*,uchar*);
extern void move3Planes(uchar*,uchar*);
extern void move4Planes(pixel*,pixel*);
extern void move1to4Planes(uchar*,uchar*);
