/* rtMPS.c
 * 28jan92abu
 */

#pragma segment rtMPS

#include "retch.h"
#include	"imageFile.h"

/* Prototypes */
static void DeleteAll(void);
static pico OpenMPS(pico);
static pico ReadMPS(pico);
static pico CloseMPS(void);

static integer diskNo;
static TImageDisk	*gImageDisk = nil;
static TImageFile	*gImageFile = nil;
static TImageFork	*gImageFork = nil;

symInit rtMPSSyms[] = {
	{"OPENMPS",		(fooPtr)OpenMPS},
	{"READMPS",		(fooPtr)ReadMPS},
	{"CLOSEMPS",	(fooPtr)CloseMPS},
	NULL
};

pico OpenMPS(pico x)
{
	Str255 fileName;
	OSErr err;

	diskNo = (integer)nextNum(&x);
	nextCntString(&x,fileName);
	if ((err = NewImageDisk(&gImageDisk)) == noErr) {
		if ((gImageFile = new TImageFile(gImageDisk))
		 && (gImageFork = new TImageFork)) {
			gImageFile->SpecifyByPName(diskNo, fileName);
			gImageDisk->InspectLink(0, linkCyclic);
			if ((err = gImageDisk->LinkDisk(diskNo)) == noErr
			 && (err = gImageFile->OpenImageFile()) == noErr
			 && (err = gImageFile->FindImageFork(gImageFork, forkRaster)) == noErr)
				return nilSym;
			gImageDisk->UnlinkDisk(diskNo);
		}
		DeleteAll();
	}
	return boxNum(err);
}

pico ReadMPS(pico x)
{
	Ptr p;
	long v,h1,h2;
	VRect	theVRect;

	p = (Ptr)nextPtr(&x);
	v = nextNum(&x);
	h1 = nextNum(&x);
	h2 = nextNum(&x);

	gImageFork->SetAccessFormat(4, h2 - h1, 1);

	theVRect.top	= v;
	theVRect.bottom = v + 1;
	theVRect.left	= h1;
	theVRect.right	= h2;
	return boxBool(!gImageFork->LineRead(4, 0, theVRect, p));
}

pico CloseMPS()
{
	gImageDisk->UnlinkDisk(diskNo);
	DeleteAll();
	return tSym;
}

void DeleteAll()
{
	if (gImageFork) {
		delete gImageFork;
		gImageFork = nil;	
	}
	if (gImageFile) {
		delete gImageFile;
		gImageFile = nil;	
	}
	if (gImageDisk) {
		delete gImageDisk;
		gImageDisk = nil;	
	}
}
