/* jnlDrvr.c
 * 02aug91abu
 */

#define YES				-1					/* Boolean values */
#define NO				0
#define jPlayCtl		16
#define jRecordCtl	17
#define setRefNum		18
#define app2Evt		13

typedef int bool;
typedef enum {jcTickCount, jcGetMouse, jcButton, jcGetKeys, jcEvent};

/* Undocumented low-memory Mouse variables */
#define mouseH (*(int*)2090)
#define mouseV (*(int*)2088)
#define magic1 (*(char*)2254)
#define magic2 (*(char*)2255)

static int refNum;
static bool done;

/* Prototypes */
int main(cntrlParam*,DCtlPtr,int);
void mouse(int,int);
OSErr doPlay(cntrlParam*);
OSErr doRecord(cntrlParam*);

int main(paramBlock,devCtlEnt,n)
cntrlParam *paramBlock;
DCtlPtr devCtlEnt;
int n;
{
	switch (n) {
		case 0: /* Open */
			done = NO;
			return devCtlEnt->dCtlStorage? 0 : -1;
		case 1: /* Prime */
			return -1;
		case 2: /* Control */
			switch (paramBlock->csCode) {
				case jPlayCtl:
					return doPlay(paramBlock);
				case jRecordCtl:
					return doRecord(paramBlock);
				case setRefNum:
					refNum = *(long*)paramBlock->csParam;
					return done = NO;
			}
			break;
		case 3: /* Status */
			return -1;
		case 4: /* Close */
			return 0;
	}
}

void mouse(h,v)
int h,v;
{
	long n;

	while (mouseH != h  ||  mouseV != v) {
		if (mouseH < h)
			++mouseH;
		else if (mouseH > h)
			--mouseH;
		if (mouseV < v)
			++mouseV;
		else if (mouseV > v)
			--mouseV;
		magic1 = magic2;
		Delay(1,&n);
	}
}

OSErr doPlay(paramBlock)
cntrlParam *paramBlock;
{
	int sav;
	bool brkFlg;
	long count;
	char jCode[4];
	OSErr res;

	sav = *(int*)0x08DE;
	*(int*)0x08DE = 0;
	brkFlg = Button();
	*(int*)0x08DE = sav;
	for (;;) {
		count = 1;
		FSRead(refNum,&count,jCode);
		if (brkFlg || !count) {
			if (done) {
				done = NO;
				*(int*)0x08DE = 0; /* JournalFlag off */
			}
			else {
				done = YES;
				(*(EventRecord**)paramBlock->csParam)->what = app2Evt;
			}
			return noErr;
		}
		switch (jCode[0]) {
			case jcTickCount:
				count = sizeof(long);
				break;
			case jcGetMouse:
				count = sizeof(Point);
				break;
			case jcButton:
				count = sizeof(bool);
				break;
			case jcGetKeys:
				count = sizeof(KeyMap);
				break;
			case jcEvent:
				count = sizeof(EventRecord);
				break;
			default:
				SysBeep(22);
				count = 2;
		}
		if ((int)jCode[0] == paramBlock->csParam[2])
			break;
		SetFPos(refNum, 3, count);
	}
	res = FSRead(refNum, &count, *(Ptr*)paramBlock->csParam);
	switch (jCode[0]) {
		case jcGetMouse:
			mouse((*(Point**)paramBlock->csParam)->h, (*(Point**)paramBlock->csParam)->v);
			break;
		case jcEvent:
			mouse((*(EventRecord**)paramBlock->csParam)->where.h,
				  (*(EventRecord**)paramBlock->csParam)->where.v);
			break;
	}
	return res;
}

OSErr doRecord(paramBlock)
cntrlParam *paramBlock;
{
	long count;
	char jCode[4];

	count = 1;
	jCode[0] = (char)paramBlock->csParam[2];
	FSWrite(refNum, &count, jCode);
	switch (jCode[0]) {
		case jcTickCount:
			count = sizeof(long);
			break;
		case jcGetMouse:
			count = sizeof(Point);
			break;
		case jcButton:
			count = sizeof(bool);
			break;
		case jcGetKeys:
			count = sizeof(KeyMap);
			break;
		case jcEvent:
			count = sizeof(EventRecord);
			break;
		default:
			SysBeep(22);
			count = 2;
	}
	return FSWrite(refNum, &count, *(Ptr*)paramBlock->csParam);
}
