[click.l 07jan93]

(off :clk)
(setq :pos '(:h . :v))

[+++ Default functions +++]
<de grid-h (h)
   (local (g)
      (if (and (is grid App) (setq g (get App 'grid-h)))
         (round h g)
         h >

<de grid-v (v)
   (local (g)
      (if (and (is grid App) (setq g (get App 'grid-v)))
         (round v g)
         v >

<de hvSpot (pt)
   (do print 'spot
      (append
         "H:"
         (format (car pt))
         "  V:"
         (format (cdr pt)) >

<de stiff (pt1 pt2)
   (local (dh dv)
      (when (and pt1 (s-key))
         (setq
            dh (sub (car pt2) (car pt1))
            dv (sub (cdr pt2) (cdr pt1)) )
         (if (lessp (abs dh) (abs dv))
            (rplaca pt2
               (if (lessp (mul 3 (abs dh)) (abs dv))
                  (car pt1)
                  (add
                     (car pt1)
                     (if (minusp dh)
                        (minus (abs dv))
                        (abs dv) ) ) ) )
            (rplacd pt2
               (if (lessp (mul 3 (abs dv)) (abs dh))
                  (cdr pt1)
                  (add
                     (cdr pt1)
                     (if (minusp dv)
                        (minus (abs dh))
                        (abs dh) ) ) ) ) ) )
      pt2 >

[+++ Click routines +++]
<de dMouse (dh dv)
   (word 2090 (add dh (word 2090)))
   (word 2088 (add dv (word 2088)))
   (byte 2254 (byte 2255)) >

<de clkPos ()
   (SetCursor
      (if (inView (GetMouse :pos))
         (ptr (GetCursor #crossCursor))
         Arrow ) )
   (:stiff :pt (:trans (GetMouse :pos))) >

<de clkRubber (pt weg)
   (when :draw
      (localClip (get App 'view)
         (PenNormal)
         (PenMode #patXor)
         (:draw :pt pt weg) >

<de clkYes ()
   (clkIdle)
   (clkRubber :clk T)
   (on Done) >

<de clkNo ()
   (clkRubber :clk T)
   (off :clk)
   (on Done) >

<de clkIdle ()
   (local (pt)
      (unless (equal :clk (setq pt (clkPos)))
         (clkRubber :clk T)
         (clkRubber pt)
         (rplaca :clk (car pt))
         (rplacd :clk (cdr pt))
         (and :spot (:spot :clk :pt)) >

<de clkMouse ()
   (local (pt f w part cntl)
      (setq pt (ev-where Event))
      (case (setq f (FindWindow pt w))
         (#inMenuBar
            (clkNo) )
         (#inSysWindow
            (clkNo) )
         (#inContent
            (unless (may click App w pt)
               (if (neq w (get App 'winPtr))
                  (clkNo)
                  (progn
                     (GlobalToLocal pt)
                     (setq part (FindControl pt Port cntl))
                     (if cntl
                        (do scroll App cntl part pt)
                        (clkYes) ) ) ) ) )
         (#inDrag
            (if (neq w (get App 'winPtr))
               (clkNo)
               (DragWindow w pt (rect (add 6 ScreenBits))) ) )
         (#inGrow
            (may grow (GetWRefCon w) pt) )
         (#inGoAway (clkNo))
         ((#inZoomIn #inZoomOut)
            (when (TrackBox w pt f)
               (may zoom (GetWRefCon w) f) ) )
         (T (clkNo)) >

<de clkUp ()
   (if (inView (GlobalToLocal (ev-where Event)))
      (clkYes)
      (clkNo) >

<de clkKey ()
   (local (c)
      (if (zerop (bitAnd #cmdKey (ev-modifiers Event)))
         (case (setq c (bitAnd #charCodeMask (ev-message Event)))
            ((^M ^C) (clkYes))
            (27 (clkNo))
            (28 (dMouse -1 0))
            (29 (dMouse 1 0))
            (30 (dMouse 0 -1))
            (31 (dMouse 0 1)) )
         (clkNo) >

<de clkAuto ()
   (case (bitAnd #charCodeMask (ev-message Event))
      (28 (dMouse -4 0))
      (29 (dMouse 4 0))
      (30 (dMouse 0 -4))
      (31 (dMouse 0 4)) >

<de clkUpdate ()
   (clkRubber :clk T)
   (do update (GetWRefCon (ev-message Event)))
   (clkRubber :clk) >

<de click (:trans :stiff :spot :pt :draw :bye f)
   (local
      (doIdle doMouseDown doMouseUp doDouble doKeyDown doAutoKey doUpdate)
      (setq
         doIdle clkIdle
         doMouseDown clkMouse
         doMouseUp (if f clkUp noop)
         doDouble clkNo
         doKeyDown clkKey
         doAutoKey clkAuto
         doUpdate clkUpdate )
      (default
         :trans noop
         :stiff noop )
      (setq :clk (copy (clkPos)))
      (clkRubber :clk)
      (and :spot (:spot :clk :pt))
      (run)
      (and :bye (:bye :clk))
      (do hide 'spot)
      :clk >

<de drag (:oldPt drgSpot drgDraw)
   (PenNormal)
   (PenMode #patXor)
   (setq :newPt1 :oldPt)
   (and drgSpot (drgSpot :oldPt :newPt1))
   (and drgDraw (drgDraw :oldPt :newPt1))
   (while (StillDown)
      (setq :newPt2 (GetMouse))
      (delay 2)
      (unless (equal :newPt1 :newPt2)
         (setq :newPt1 :newPt2)
         (and drgSpot (drgSpot :oldPt :newPt1))
         (and drgDraw (drgDraw :oldPt :newPt1)) ) )
   :newPt1 >

T
