[palette.l 25dec92]

<de mkPict (r :x)
   (PenNormal)
   (ClipRect (portRect Port)) [For OpenPicture]
   (if (numberp :x)
      (dynamo ReleaseResource (GetResource "PICT" :x))
      (prog1
         (dynamo KillPicture (OpenPicture r))
         (eval :x)
         (ClosePicture) >


(object palette passive window)

<to T (obj ttl cols pos dh dv . :lst)
   (local (rows r)
      (setq
         rows (div (length :lst) cols 2)
         r (cons2 0 0 dh dv) )
      (with obj
         (localPort
            (slot winPtr
               (NewWindow NIL
                  (cons pos
                     (cons
                        (add (car pos) (mul cols dh))
                        (add (cdr pos) (mul rows dv)) ) )
                  ttl NIL #paletteProc -1 NIL obj ) )
            [+ Tool: (RECT PICT EXPR) +]
            (for (v 0 rows)
               (for (h 0 cols)
                  (slot tools
                     (nconc1 (slot tools)
                        (list
                           (mvRect r (mul h dh) (mul v dv))
                           (mkPict r (pop :lst))
                           (pop :lst) ) ) ) ) )
            (slot mark (car (slot tools)))
            (InvertRect (car (slot mark))) >

<to update (obj)
   (from window update obj
      '((obj)
         (with obj
            (mapc (slot tools)
               '((tl)
                  (EraseRect (car tl))
                  (FrameRect (car tl))
                  (DrawPicture (ref (cadr tl)) (car tl))
                  (when (eq tl (slot mark))
                     (InvertRect (car tl)) >

<to mark (obj n)
   (local (tl)
      (with obj
         (setq tl
            (if n
               (nth n (slot tools))
               (slot last) ) )
         (slot last (slot mark))
         (unless (eq tl (slot mark))
            (localPort (slot winPtr)
               (InvalRect (car (slot mark)))
               (InvalRect (car (slot mark tl))) >

<to content (obj pt)
   (local (App tl)
      (with obj
         (do select
            (setq App (slot app)) )
         (localPort (slot winPtr)
            (GlobalToLocal pt)
            (setq tl
               (find (slot tools)
                  '((tl) (inRect pt (car tl))) ) )
            (slot last (slot mark))
            (unless (eq tl (slot mark))
               (InvertRect (car (slot mark)))
               (InvertRect (car (slot mark tl))) ) )
         (localPort (get App 'winPtr)
            (eval (caddr tl)) >

T
