[eprom.l 10oct92]

<de iniRom ()
   (for (i 0 RomSize)
      (byte (add i Rom) 0FF) >

<de waitSerial ()
   (local (c)
      (until (setq c (serial))
         (check) )
      c >

<de init ()
   (tty "B")
   (serial \I) (delay 2)
   (serial \T) (delay 2)
   (serial RomType) (delay 2)
   RomType >

<de status ()
   (serial \S) (delay 2)
   (and
      (eq \0 (waitSerial))
      (eq 13 (waitSerial))
      (eq 10 (waitSerial)) >

<de eraTest ()
   (init)
   (serial \L) (delay 2)
   (status) >

<de program ()
   (init)
   (serial \P) (delay 2)
   (serial Alg) (delay 2)
   (local (c n)
      (for (i 0 RomSize)
         (setq
            c (byte (add i Rom))
            n (bitAnd 0F (bitr 4 c)) )
         (putc (serial (add n (if (leq n 9) \0 \7))))
         (setq n (bitAnd 0F c))
         (putc (serial (add n (if (leq n 9) \0 \7)))) ) )
   (status) >

<de rdHex ()
   (local (n)
      (setq n (sub (waitSerial) \0))
      (if (leq n 9) n (sub n 7)) >

<de rdByte ()
   (bitOr
      (bitl 4 (rdHex))
      (rdHex) >

<de verify ()
   (init)
   (serial \R) (delay 2)
   (for (i 0 RomSize)
      (unless (eq (rdByte) (bitAnd 0FF (byte (add i Rom))))
         (putc \!) ) )
   (and
      (eq 13 (waitSerial))
      (eq 10 (waitSerial))
      (status) >

<de readEprom ()
   (init)
   (serial \R) (delay 2)
   (reptn RomSize
      (putc (waitSerial))
      (putc (waitSerial)) )
   (terpri)
   (and
      (eq 13 (waitSerial))
      (eq 10 (waitSerial))
      (status) >

<de testEprom ()
   (init)
   (mapc "X00000Y00000" serial)
   (mapc "P008" serial)
   (status) >

T
