[intelHex.l 10oct92]

(off :fd)
(enum :data :eof)

(zero :chk)

<de sHex1 (c)
   (if :fd
      (putc c :fd)
      (serial c) >

<de sHexNibble (c)
   (setq c (bitAnd 0F c))
   (when (lessp \9 (inc c \0))
      (inc c 7) )
   (sHex1 c) >

<de sHexByte (b)
   (dec :chk b)
   (sHexNibble (bitr 4 b))
   (sHexNibble b) >

<de sHexRecord (n a f)
   (zero :chk)
   (sHex1 \:)
   (sHexByte n) [Count]
   (sHexByte (bitr 8 a)) [Address]
   (sHexByte a)
   (sHexByte f) [Flag]
   (reptn n
      (sHexByte (byte (add Rom (sub a RomStart))))
      (inc a) )
   (sHexByte :chk)
   (sHex1 ^M)
   (or :fd (echoSerial)) >

<de sendHex (a1 a2 :fd)
   (local (n)
      (while (plusp (setq n (min 16 (sub a2 a1))))
         (sHexRecord n a1 #:data)
         (inc a1 n) )
      (sHexRecord 0 0 #:eof) >

<de sendAsm (nm)
   (setq :fd (and nm (create nm)))
   (local (Range)
      (while Range
         (sendHex (pop Range) (pop Range) :fd) ) )
   (and :fd (close :fd)) >

T
