/* rcPrim.c
 * 11feb92abu
 */

#pragma segment rcPrim

#include "rcSim.h"

void disposPlaneRec(x)
pico x;
{
	DisposHandle((Handle)nextNum(&x));
}

pico boxVector(v,scl)
register vector *v;
register double scl;
{
   return newCell(boxDouble(v->x / scl),
               newCell(boxDouble(v->y / scl),
                  newCell(boxDouble(v->z / scl), nilSym) ) );
}

void unBoxVector(x,v,scl)
register pico x;
register vector *v;
register double scl;
{
   NEEDCELL(x);
   v->x = (double)unBox(car(x)) * scl;
   x = cdr(x);
   v->y = (double)unBox(car(x)) * scl;
   x = cdr(x);
   v->z = (double)unBox(car(x)) * scl;
}

double nextDouble(p,scl)
register pico *p;
double scl;
{
	register pico x;

	x = EVAL1(*p);
	*p = cdr(*p);
	NEEDNUM(x);
	return (double)unBox(x) * scl;
}

double nextAngle(p)
register pico *p;
{
	register pico x;

	x = EVAL1(*p);
	*p = cdr(*p);
	NEEDNUM(x);
	return ((double)unBox(x) * PI / 18000.0);
}

void nextVector(p,v,scl)
register pico *p;
vector *v;
double scl;
{
	unBoxVector(EVAL1(*p),v,scl);
	*p = cdr(*p);
}

planeHandle nextPlane(p)
register pico *p;
{
	register pico x;

	x = EVAL1(*p);
	*p = cdr(*p);
	NEEDDYNAMO(x);
	return (planeHandle)unBox(cdr(val(x)));
}

double magnitude(v)
register vector *v;
{
	return sqrt(v->x*v->x + v->y*v->y + v->z*v->z);
}

void transform(x,y,z,m,dst)
register double x,y,z;
register matrix *m;
register vector *dst;
{
   dst->x  =  x * m->a.x + y * m->b.x + z * m->c.x;
   dst->y  =  x * m->a.y + y * m->b.y + z * m->c.y;
   dst->z  =  x * m->a.z + y * m->b.z + z * m->c.z;
}

void antiTrans(x,y,z,m,dst)
register double x,y,z;
register matrix *m;
register vector *dst;
{
	dst->x  =  x * m->a.x + y * m->a.y + z * m->a.z;
	dst->y  =  x * m->b.x + y * m->b.y + z * m->b.z;
	dst->z  =  x * m->c.x + y * m->c.y + z * m->c.z;
}

void identity(p)
matrix *p;
{
	p->a.x = p->b.y = p->c.z = 1.0;
	p->a.y = p->a.z = 0.0;
	p->b.x = p->b.z = 0.0;
	p->c.x = p->c.y = 0.0;
}

double sign(x)
register double x;
{
	if (x > 0.0)
		return +1.0;
	if (x < 0.0)
		return -1.0;
	return 0.0;
}
