[*retch.l 14aug92abu]

(setq Env "HD2:Pico:")

[++ Pico Environment ++]
(load (append Env "tools:lib.l"))
(load (append Env "tools:mac.l"))
<if -debug
   (progn
      (load (append Env "tools:too.l"))
      (load (append Env "tools:ledit.l"))
      (load (append Env "tools:lint.l"))
      (load (append Env "tools:dZone.l"))
      (when Src
         (load (append Env "src:src.l"))
         (load (append Env "Rt.src:src.l")) ) )
   (progn
      (on Share)
      (off Src Again) >

[++ Function keys ++]
<when -debug
   (defKey \e (print (eval -t)))
   (defKey \d (debug -t))
   (defKey \u (unbug -t))
   (defKey \s (system))
   (defKey \1 (system "Control Panel"))
   (defKey \2 (system "MockWrite"))
   (defKey \r (print '(run)) (run) (putc \*)) >

[++ PicApp ++]
(load (append Env "picApp:defs.l"))
(load (append Env "picApp:boss.l"))
(load (append Env "picApp:strings.l"))
(load (append Env "picApp:menu.l"))
(load (append Env "picApp:dialog.l"))
(load (append Env "picApp:click.l"))
(load (append Env "picApp:spot.l"))
(load (append Env "picApp:window.l"))
(load (append Env "picApp:palette.l"))
(load (append Env "picApp:docWin.l"))
(load (append Env "picApp:picApp.l"))

[++ Globals ++]
(off Undo Redo JFile Drvr Batch Poly CmykClip BitsClip BlotClip)
(off Mark Plane UseDisk)
(on Fats MsrWin ShowTools)

[++ Sources ++]
<mapc
   (quote
      "defs.l" "idle.l" "main.l" "blotter.l" "prim.l" "file.l"
      "dialog.l" "peep.l" "cmyk.l" "cmyk1.l" "fatPix.l" "palettes.l"
      "cmykPrim.l" "cmykModi.l" "retouch.l" "pxCopy.l" "draw.l" "blot.l"
      "msrWin.l" "brushDialog.l" "plugin.l" "help.l" "putHelp.l" )
   '((nm) (load (append Env "rtApp:" nm))) >

<if -debug
   (load "debug.l")
   (off Share) >

T
