[blotter.l 14aug92]

(off EditBlot)

(setq
   :blotPix 8
   :blotSize (mul 32 32) )

<de :blotRect
   (60 . 20)
   #(add 60 1 (mul 32 :blotPix)) . #(add 20 1 (mul 32 :blotPix)) >

(setq :blotFrame (szRect :blotRect -1 -1))

(de :viewRect (330 . 10) 800 . 350)

(setq :viewFrame (szRect :viewRect -1 -1))

<de newBlotCmd ()
   (local (obj)
      (setq obj (new 'blotter))
      [(zapUndo)]
      (setBlotBits obj) >

<de doOpenBlot (nm)
   (readBlot (new 'blotter nm (GetVol))) >

<de openBlotCmd ()
   (local (nm)
      (when
         (and
            (needMem #(mul 40 1024))
            (setq nm
               (getFile1 #(str "Open Blot") #(str "Open") "blot") ) )
         [(zapUndo)]
         (doOpenBlot nm) >

<de saveBlotCmd ()
   (with App
      (saveBlot (slot name) (slot vol)) >

<de revertBlotCmd ()
   (zapUndo)
   (readBlot App)
   (do inval App) >

<de readBlot (App)
   (local (fd)
      (with App
         (localVol (slot vol)
            (when (setq fd (open (slot name)))
               (readBlock fd (ref (slot blot)) #:blotSize)
               (close fd)
               (remove App 'dirty)
               (setBlotBits App) >

<de saveBlot (nm vol)
   (local (fd)
      (with App
         (when
            (or
               nm
               (setq nm
                  (putFile1 #(str "Save Blot")
                     #(str "Save") (slot name) ) ) )
            (localVol (slot vol (or vol (GetVol)))
               (when (needVol 0 #:blotSize)
                  (setq fd (create nm))
                  (SetWTitle (slot winPtr) (slot name nm))
                  (writeBlock fd (ref (slot blot)) #:blotSize)
                  (close fd)
                  (fType nm "blot")
                  (remove App 'dirty) >

<de dynBlot (b)
   (if b
      (local (d)
         (prog1
            (setq d (dynamo free (alloc #:blotSize)))
            (block b (ref d) #:blotSize) ) )
      (dynamo free (alloc #:blotSize 0)) >

<de updtBlotBits (obj)
   (with obj
      (block (ptr (slot bits)) (ptr (slot bits1)) 128) >

<de setBlotBits (obj)
   (with obj
      (blotBt (slot level) (ref (slot blot)) (ptr (slot bits)))
      (updtBlotBits obj) >

<de setBitsBlot (obj)
   (with obj
      (btBlot (slot level) (ptr (slot bits)) (ref (slot blot))) >

<de showBlotBits ()
   (CopyBits
      (get App 'bits) (portMap Port)
      '((0.0) 32.32) '#:blotRect
      #srcCopy >

<de doViewBlot ()
   (EraseRect '#:viewRect)
   (with App
      (local (v)
         (setq v
            (sub
               (GetCtlMax (slot vSBar))
               (GetCtlValue (slot vSBar)) ) )
         (viewBlot (ref (slot blot))
            #(add 8 (div2 (add (left :viewRect) (right :viewRect))))
            220 800 v (add 400 (div v 4)) >

[++++++
<de blotLocal (pt)
   (cons
      (div
         (add (car pt) #(sub (div2 :blotPix) (left :blotRect)))
         #:blotPix )
      (div
         (add (cdr pt) #(sub (div2 :blotPix) (top :blotRect)))
         #:blotPix >
++++++]

<de blotLocal (pt)
   (cons
      (div
         (sub (car pt) #(left :blotRect))
         #:blotPix )
      (div
         (sub (cdr pt) #(top :blotRect))
         #:blotPix >

<de editBlot (f . :body)
   (with App
      (block (ptr (slot bits1)) (ptr (slot bits2)) 128)
      (block (portMap (slot winPtr)) (slot savMap) 14)
      (SetPortBits (slot bits2))
      (ForeColor (if f #blackColor #whiteColor))
      (eval :body)
      (ForeColor #blackColor)
      (SetPortBits (slot savMap))
      (block (ptr (slot bits2)) (ptr (slot bits)) 128)
      (showBlotBits) >


(object blotter modeless)

<to classify () 'blotter>

<to T (obj nm vol)
   (with obj
      (slot home obj)
      (slot name nm)
      (slot vol vol)
      (from modeless T obj
         (dialog #rDocProc (or nm #(str "Untitled"))
            T (winLoc 5 22 (80.120)) 880 360
            #resCtrl (88.310) 200 20 #hSBarId [1]
            #statText (177.330) 48 16 "25" [2]
            #resCtrl (830.60) 20 200 #vSBarId [3] ) )
      (slot blot (dynBlot))
      (slot bits (newBitMap 32 32))
      (slot bits1 (newBitMap 32 32))
      (slot bits2 (newBitMap 32 32))
      (slot savMap (alloc 14))
      (slot hSBar (d-item (slot winPtr) 1))
      (slot txt (d-item (slot winPtr) 2))
      (slot vSBar (d-item (slot winPtr) 3))
      (slot level #(muldiv 25 255 100))
      (SetCtlMin (slot hSBar) 1)
      (SetCtlMax (slot hSBar) 100)
      (SetCtlValue (slot hSBar) 25)
      (ShowControl (slot hSBar))
      (SetCtlMax (slot vSBar) 2000)
      (SetCtlValue (slot vSBar) #(sub 2000 300))
      (ShowControl (slot vSBar))
      (start obj) >

<to close (obj)
   (with obj
      (when
         (or
            (not (is dirty obj))
            (confirm
               (append
                  #(str "Save changes to: ")
                  (or (slot name) "Untitled")
                  "?" )
               saveBlot (slot name) (slot vol) ) )
         (do hide 'spot)
         [(zapUndo)]
         (zapBitMap (slot bits))
         (zapBitMap (slot bits1))
         (zapBitMap (slot bits2))
         (free (slot savMap))
         (from modeless close obj)
         (stop obj)
         T >

<to setUp (App)
   (setMenu BMBar)
   (do show Blotter) >

<to cleanUp (App)
   (do hide Blotter) >

<to begin (App)
   (put Blotter 'app App)
   (with App
      (setq
         Undo (slot undo)
         Redo (slot redo) ) )
   (setUndo)
   (setRedo)
   (local (dlg itemHit)
      (DialogSelect Event dlg itemHit) >

<to end (App)
   (with App
      (slot undo Undo)
      (slot redo Redo) >

<to setCursor (App pt)
   (with App
      (localPort (slot winPtr)
         (and
            (eq Port (FrontWindow))
            (GlobalToLocal pt)
            (inRect pt '#:blotRect)
            (SetCursor (ptr (GetCursor #crossCursor))) >

<to update (App)
   (InvalRect '#:blotFrame)
   (InvalRect '#:viewFrame)
   (from modeless update App
      '(()
         (FrameRect '#:blotFrame)
         (showBlotBits)
         (FrameRect '#:viewFrame)
         (doViewBlot) >

<de setBlotText ()
   (local (v)
      (with App
         (setq v (GetCtlValue (slot hSBar)))
         (SetIText (slot txt) (format v))
         (slot level (muldiv v 255 100)) >

<de setBlotHS (v)
   (when v
      (SetCtlValue (get App 'hSBar) v) )
   (setBlotText)
   (setBlotBits App)
   (showBlotBits) >

<de makeBlotHS (v cntl)
   (make #(str "Change Blot Level") NIL
      (list v)
      setBlotHS
      (list (GetCtlValue cntl))
      setBlotHS >

<de blotCtl (pt part cntl)
   (local (v1 v)
      (setq v1 (GetCtlValue cntl))
      (if (eq part #inThumb)
         (unless (zerop (TrackControl cntl pt))
            (makeBlotHS v1 cntl) )
         (progn
            (TrackControl cntl pt
               '((cntl part)
                  (setq v (GetCtlValue cntl))
                  (case part
                     (#inUpButton
                        (SetCtlValue cntl (dec v)) )
                     (#inDownButton
                        (SetCtlValue cntl (inc v)) )
                     (#inPageUp
                        (SetCtlValue cntl (dec v #(div 100 4))) )
                     (#inPageDown
                        (SetCtlValue cntl
                           (inc v
                              (if (onep v)
                                 #(sub1 (div 100 4))
                                 #(div 100 4) ) ) ) ) )
                  (setBlotHS) ) )
            (makeBlotHS v1 cntl) >

<de viewCtl (pt part cntl)
   (scroll pt part cntl)
   (doViewBlot) >

<de setBlot (b)
   (put App 'blot b)
   (setBlotBits App)
   (showBlotBits)
   (doViewBlot) >

<to content (App pt)
   (from modeless content App pt
      '((pt part cntl)
         (with App
            (cond
               ((eq cntl (slot hSBar))
                  (blotCtl pt part cntl) )
               ((eq cntl (slot vSBar))
                  (viewCtl pt part cntl) )
               ((inRect pt '#:blotRect)
                  (local (pt1 pt2 f)
                     (setq
                        pt (blotLocal pt)
                        pt1 pt
                        f (not
                           (bitmap (slot bits) (car pt) (cdr pt)) ) )
                     [(editBlot f plot (car pt) (cdr pt))]
                     (while (StillDown)
                        (hintBlot (car pt1) (cdr pt1) (slot level))
                        (EditBlot
                           pt
                           (setq pt2 (blotLocal (GetMouse)))
                           f )
                        (hintBlot (car pt1) (cdr pt1) (slot level))
                        (hvSpot (setq pt1 pt2)) )
                     (make #(str "Edit Blot") T
                        (list (get App 'blot))
                        setBlot
                        (list
                           (prog1
                              (with App
                                 (slot blot
                                    (dynBlot (ref (slot blot))) ) )
                              (setBitsBlot App) ) )
                        setBlot >

(setq :pt '(:h . :v))

<to idle (App)
   (if (inRect (GetMouse :pt) '#:blotRect)
      (with App
         (setq :pt (blotLocal :pt))
         (hintBlot (car :pt) (cdr :pt) (slot level))
         (hvSpot :pt)
         (hintBlot (car :pt) (cdr :pt) (slot level)) )
      (do hide 'spot) >

<de blotMBar ()
   (mkMBar
      (d  is dirty App)
      ((#appleMark)
         ("" #(str "About Retouch ..") T (aboutDialog))
         ("-") )
      (#(str "File")
         ("/O" #(str "Open ..") T (openCmd))
         ("" #(str "Erase File ..") T (eraCmd))
         (T #(str "Acquire"))
         ("" #(str "New Blot") T (newBlotCmd))
         ("" #(str "Open Blot ..") T (openBlotCmd))
         ("-")
         ("/W" #(str "Close") T (do close App))
         ("/S" #(str "Save") d (saveBlotCmd))
         ("" #(str "Save as ..") T (saveBlot))
         ("" #(str "Revert") (and d (get App 'vol)) (revertBlotCmd))
         ("-")
         ("" #(str "Go to MPS") T (launchMPS))
       ("-")
         ("/Q" #(str "Quit") T (on Done)) )
      (#(str "Edit")
         ("/Z" #(str "Undo") Undo (doUndo))
         ("/R" #(str "Redo") Redo (doRedo))
         ("-")
         ("/X" #(str "Cut") T (blotCutCmd))
         ("/C" #(str "Copy") T (blotCopyCmd))
         ("/V" #(str "Paste") BlotClip (blotPasteCmd))
         ("" #(str "Clear") T (blotClearCmd))
         ("/D" #(str "Duplicate"))
         ("/A" #(str "Select All"))
         ("-")
         ("/I" #(str "Interpolate") T (interBlotCmd)) >

<de blotCutCmd ()
   (make #(str "Cut") T
      (list BlotClip)
      '((b)
         (setBlot BlotClip)
         (setq BlotClip b) )
      (list (dynBlot))
      '((b)
         (setq BlotClip (get App 'blot))
         (setBlot b) >

<de blotCopyCmd ()
   (make #(str "Copy") NIL
      (list BlotClip)
      '((b) (setq BlotClip b))
      (list (dynBlot (ref (get App 'blot))))
      '((b) (setq BlotClip b)) >

<de blotPasteCmd ()
   (make #(str "Paste") T
      (list (get App 'blot))
      setBlot
      NIL
      '(() (setBlot BlotClip)) >

<de blotClearCmd ()
   (make #(str "Clear") T
      (list (get App 'blot))
      setBlot
      (list (dynBlot))
      setBlot >


<de interBlotCmd ()
   (make #(str "Interpolate Blot") T
      (list (get App 'blot))
      setBlot
      (list
         (with App
            (prog1
               (slot blot
                  (dynBlot (ref (slot blot))) )
               (interBlot (ref (slot blot))) ) ) )
      setBlot >

T
