[fixMenu.l 22oct91]

[++ FixMenu dimensions ++]
<setq
   fmTop       (add 58 (word MBarHeight))
   fmLeft      2
   fmRows      7
   fmCols      1
   fmRowSize   30
   fmColSize   50
   fmHeight   (mul fmRows fmRowSize)
   fmWidth    (mul fmCols fmColSize)
>

[FixMenu commands]
(de *fixCmds
   fix-pix fix-line
   fix-rect1 fix-rect2
   fix-oval1 fix-oval2
   fix-eraser )

(de *pictRect (0.0) #fmColSize . #fmRowSize)
(de fixRect (0 . 0) #fmColSize . #fmRowSize)

[FixWindow rectangle]
(de *fixWinRect
   (#fmLeft . #fmTop) #(add fmLeft fmWidth) . #(add fmTop fmHeight) )

[Put the *fixCmds RECT-properties]
<local (*fixCmds)
   (for (row 0 fmRows)
      (for (col 0 fmCols)
         (put
            (pop *fixCmds)
            'rect
            (mvRect fixRect (mul col fmColSize) (mul row fmRowSize)) >

[Put the *fixCmds PICT-properties]
<de putPict $x
   (PenNormal)
   (ClipRect (portRect *port))  [For OpenPicture]
   (put (pop $x) 'pict (OpenPicture *pictRect))
   (mapc $x eval)
   (ClosePicture) >

<de initFixMenu ()
   (putPict fix-pix
      (PaintRect '((23.13) 27.17)) )
   (putPict fix-line
      (Pensize 2 2)
      (line2 (5.25) (45.5)) )
   (putPict fix-rect1
      (FrameRect '((10.7) 40.23)) )
   (putPict fix-rect2
      (PaintRect '((10.7) 40.23)) )
   (putPict fix-oval1
      (FrameOval '((7.5) 43.25)) )
   (putPict fix-oval2
      (PaintOval '((7.5) 43.25)) )
   (putPict fix-eraser
      (FrameRect '((10.15) 26.26))
      (line2 (25.15) (40.5))
      (MoveTo 10 15)
      (LineTo 25 5)
      (LineTo 40 5)
      (LineTo 40 14)
      (LineTo 25 25) )
   (InvertRect (get (setq *lastFix 'fix-pix) 'rect))
   (fix-pix) >

[++ FixMenu commands ++]
<de fix-pix ()
   (setq *editBlot
      (lambda (pt1 pt2 f)
         (editBlot f plot (car pt2) (cdr pt2))
         (updtBlotBits *app) >

<de fix-line ()
   (setq *editBlot
      (lambda (pt1 pt2 f)
         (editBlot f line2 pt1 pt2) >

<de fix-rect1 ()
   (setq *editBlot
      (lambda (pt1 pt2 f)
         (editBlot f FrameRect (bounds pt1 pt2)) >

<de fix-rect2 ()
   (setq *editBlot
      (lambda (pt1 pt2 f)
         (editBlot f PaintRect (bounds pt1 pt2)) >

<de fix-oval1 ()
   (setq *editBlot
      (lambda (pt1 pt2 f)
         (editBlot f FrameOval (bounds pt1 pt2)) >

<de fix-oval2 ()
   (setq *editBlot
      (lambda (pt1 pt2 f)
         (editBlot f PaintOval (bounds pt1 pt2)) >

<de fix-eraser ()
   (setq *editBlot
      (lambda (pt1 pt2 f)
         (editBlot nil PaintRect
            (cons2
               (sub2 (car pt2))
               (sub2 (cdr pt2))
               (add2 (car pt2))
               (add2 (cdr pt2)) ) )
         (updtBlotBits *app) >


(object fixMenu window)

<to init (obj)
   (localPort
      (put obj 'winPtr
         (NewWindow nil *fixWinRect nil nil #noGrowDocProc -1 nil obj) )
      (initFixMenu)
      [#(not -debug) (off initFixMenu) ]
      >

<to update (obj)
   (from window update obj
      (lambda ()
         (mapc *fixCmds
            (lambda (x)
               (with x
                  (FrameRect (slot rect))
                  (DrawPicture (slot pict) (slot rect))
                  (when (eq x *lastFix)
                     (InvertRect (slot rect)) >

<to content (obj pt)
   (local (*app cmd)
      (with obj
         (do select
            (setq *app (slot app)) )
         (localPort (slot winPtr)
            (GlobalToLocal pt)
            (setq cmd
               (find *fixCmds
                  (lambda (x) (inRect pt (get x 'rect))) ) )
            (unless (eq cmd *lastFix)
               (InvertRect (get *lastFix 'rect))
               (InvertRect (get (setq *lastFix cmd) 'rect)) ) )
         (localPort (get *app 'winPtr)
            ((value 'cmd)) >

t
