[main.l 14aug92]

[++ Init Application Environment ++]
<de init ()
   (reptn 16 (MoreMasters))
   [+ (SetGrowZone tryGrow) +]
   (localVol Bin
      (readStrings)
      (setq
         Event (alloc 16)
         IMBar (idleMBar)
         RMBar (rtchMBar)
         BMBar (blotMBar) )
      (addPlugins) )
   [Set BlotMenu Icons]
   (for (i 1 10)
      (SetItemIcon (blotM) (add2 i) i) )
   (do init 'spot)
   (do init 'fatPix)
   (do init 'msrWin)
   (doBlot 6)
   (setq
      Tools (toolPalette)
      Blotter (blotterPalette) )
   [# (not -debug)
   ]
   (do setUp (setq App 'idle))
   (cmykRange #dotMin #dotMax)
   (localVol Bin
      (when (open #mpsParam)
         (close (caar Files))
         (doAcquire #mpsPlugin)
         (erase #mpsParam) ) )
   (while (and Argv (lessp 2000000 (MaxMem)))
      (cond
         ((equal "CMYK" (fType (car Argv)))
            (doOpen (pop Argv)) )
         ((equal "blot" (fType (car Argv)))
            (doOpenBlot (pop Argv)) )
         (T (pop Argv)) ) )
   (run) >

<de cleanUp ()
   (off BitsClip Undo Redo)
   (gc) >

<de tryGrow (n)
   [# -debug
   (print (GZSaveHnd))
   (prin1 n) (prLine " bytes needed")
   ]
   (or (GZSaveHnd) (gc))
   1 >

<de blotM ()
   (cadr (assoc #(str "Blot") RMBar)) >

<de rtchMBar ()
   (mkMBar
      (msk with App (slot- mask))
      (d   is dirty (get App 'home))
      (th  is there (get App 'home))
      (era get App 'home 'erase)
      (s   is showMask (get App 'home))
      (bl  index Blot Blots)
      (cc  getMode)
      (rw  not (is rdOnly (get App 'home)))
      (hm  hasMask Mark)
      (sm  and Mark (sameShape Mark (cdr BitsClip)))
      ((#appleMark)
         ("" #(str "About Retouch ..") T (aboutDialog))
         ("-") )
      (#(str "File")
         ("/O" #(str "Open ..") T (openCmd))
         ("" #(str "Erase File ..") T (eraCmd))
         (T #(str "Acquire"))
         (T #(str "Export"))
         ("" #(str "New Blot") T (newBlotCmd))
         ("" #(str "Open Blot ..") T (openBlotCmd))
         ("-")
         ("/W" #(str "Close") T (do close App))
         ("/S" #(str "Save") (and th d rw) (saveCmd))
         ("" #(str "Save as ..") rw (saveCmyk))
         ("" #(str "Temporary File") (not era) (MkRevFile))
         [("" #(str "Revert") (and (or th era) d rw) (revertCmd))]
         ("" #(str "Restore ..") (and (or th era) d rw) (restoreCmd))
         ("-")
         ("" #(str "Load Mask ..") T (loadMaskCmd))
         ("" #(str "Save Mask ..") msk (saveMaskCmd))
         ("-")
         ("" #(str "Use Disk") T (toggle UseDisk) UseDisk)
         ("-")
         ("" #(str "Go to MPS") T (launchMPS))
         [# -debug
         ("-")
         ("" "Test" Test (Test))
         ("/Q" #(str "Quit") T (on Done))
         ] )
      (#(str "Edit")
         ("/Z" #(str "Undo") Undo (doUndo))
         ("/R" #(str "Redo") Redo (doRedo))
         ("-")
         ("/X" #(str "Cut") (and Mark s) (cutCmd))
         ("/C" #(str "Copy") (and Mark s) (copyCmd))
         ("/V" #(str "Paste") (and CmykClip s) (pasteCmd))
         ("" #(str "Clear") (and Mark s) (clearCmd))
         ("/D" #(str "Duplicate") (and Mark s) (dupCmd))
         ("/A" #(str "Select All") (and msk s) (allCmd))
         ("-")
         ("" #(str "Mirror") (and Mark s) (mirrorCmd))
         ("" #(str "Invert") (and Mark s) (invertCmd)) )
      (#(str "Retouch")
         ("" #(str "Mask") T (maskCmd) (eq cc 'mask))
         ("" #(str "Measure") T (msrCmd) (eq cc 'measure))
         ("" #(str "Spuit") rw (spuitCmd) (eq cc 'spuit))
         ("" #(str "PixelCopy") T (pxlCopyCmd) (eq cc 'pixelCopy))
         ("" #(str "Brush") T (brushCmd) (eq cc 'brush))
         ("" #(str "Soften") rw (softenCmd) (eq cc 'soften))
         ("" #(str "Sharpen") rw (sharpenCmd) (eq cc 'sharpen))
         ("-")
         ("" #(str "Copy") Mark (cBitsCmd))
         [+ ("" #(str "Paste") (and rw sm) (pBitsCmd)) +]
         ("" #(str "Blend ..") (and rw sm) (blendCmd))
         ("-")
         ("" #(str "Local Tone Change ..") (and Mark rw) (lToneCmd))
         ("" #(str "Global Tone Change ..") rw (gToneCmd))
         ("" #(str "Low Pass Filter") (and rw hm) (loCmd))
         ("" #(str "High Pass Filter") (and rw hm) (hiCmd))
         ("-")
         (T #(str "Blot")
            ("/B" #(str "User Blot ..") T (doBlot) (not bl))
            ("-")
            ("" "1" T (doBlot 0) (eq 0 bl))
            ("" "2a" T (doBlot 1) (eq 1 bl))
            ("" "2b" T (doBlot 2) (eq 2 bl))
            ("" "3a" T (doBlot 3) (eq 3 bl))
            ("" "3b" T (doBlot 4) (eq 4 bl))
            ("" "4a" T (doBlot 5) (eq 5 bl))
            ("" "4b" T (doBlot 6) (eq 6 bl))
            ("" "5a" T (doBlot 7) (eq 7 bl))
            ("" "5b" T (doBlot 8) (eq 8 bl)) )
         ("-")
         ("" #(str "Optimize") (and hm s) (optimCmd)) )
      (#(str "Display")
         ("" "CMYK" T (planeCmd) (not Plane))
         ("" "CMY" T (planeCmd T) (eq T Plane))
         ("" "C" T (planeCmd 1) (onep Plane))
         ("" "M" T (planeCmd 2) (eq 2 Plane))
         ("" "Y" T (planeCmd 3) (eq 3 Plane))
         ("" "K" T (planeCmd 0) (zerop Plane))
         ("-")
         ("" #(str "Show Masks") (eq cc 'mask) (showMaskCmd) s)
         ("" #(str "Show Cut") msk
            (showCutCmd) (get App 'home 'showCut) ) )
      (#(str "Window")
         ("" #(str "New Window") T (newCmd))
         ("-")
         ("/L" #(str "Lupe") T (fatPixCmd) Fats)
         ("/M" #(str "Measure Window") T (msrWinCmd) MsrWin)
         ("/T" #(str "Tool Palette") T (showToolsCmd) ShowTools)
         ("" #(str "New Brush Palette") T (new 'brushDialog Brush))
         ("-")
         ("" #(str "Zoom") T (zoomCmd)) >


(setq Class 'picApp)

<to app2Evt (App msg)
   (local (l)
      (when JFile
         (close JFile)
         (off JFile)
         (word 08DE 0) )
      (when Batch
         (if
            (and
               (not (Button))
               (setq l (getLine (cdr Batch))) )
            (localVol (car Batch)
               (when (equal l "*")
                  (seek 0 (cdr Batch))
                  (setq l (getLine (cdr Batch))) )
               (prLine l)
               (setq JFile (open l))
               (Control Drvr 18 JFile)
               (word 08DE -1) )
            (progn
               (close (cdr Batch))
               (off Batch)
               (word 08DE 0) >

[++ Undo/Redo Management ++]
<de doUndo ()
   (local (x)
      [(localPort (get App 'winPtr)]
         (push (GetItem (editM) #redoItem) Redo)
         (push (setq x (pop Undo)) Redo)
         (setRedo)
         (apply (cadddr x) (caddr x))
         (SetItem (editM) #undoItem (pop Undo))
         ((if (pop Undo) flag remove) (get App 'home) 'dirty) >

[============================================================
<de doRedo ()
   [(localPort (get App 'winPtr)]
      (apply make1 (pop Redo))
      (SetItem (editM) #redoItem (pop Redo)) >

[++++++
<de setUndoMax ()
   (local (s)
      (when
         (setq s
            (dialog1 #(str "Undo/Redo Maximum") (format UndoMax)) )
         (setq UndoMax (number s)) >
++++++]

<de make (s d l1 foo1 l2 foo2)
   (zapRedo)
   (make1 s d l1 foo1 l2 foo2) >
============================================================]

<de make1 (s d l1 foo1 l2 foo2)
   (push (is dirty (get App 'home)) Undo)
   (and d (flag (get App 'home) 'dirty))
   (push (GetItem (editM) #undoItem) Undo)
   (push (list s d l1 foo1 l2 foo2) Undo)
   (setUndo)
   (apply foo2 l2) >

[============================================================
<de setUndo ()
   (SetItem (editM) #undoItem
      (append #(str "Undo ") (caar Undo)) >

<de setRedo ()
   (SetItem (editM) #redoItem
      (append #(str "Redo ") (caar Redo)) >

<de zapUndo ()
   (zapRedo)
   (off Undo)
   (setUndo) >

<de zapRedo ()
   (off Redo)
   (setRedo) >
============================================================]

<de zap1undo ()
   (or
      (find Apps   [Try the other jobs]
         '((obj)
            (and
               (neq obj App)
               (with obj
                  (when (or (slot undo) (slot redo))
                     (slot undo NIL)
                     (slot redo NIL)
                     (gc) ) ) ) ) )
      (when Redo (zapRedo) (gc))   [Then current Redo]
      (when Undo   [And Undo]
         (if (cdddr Undo)
            (reptn (mul (div (length Undo) 6) 3)
               (shift Undo) )
            (zapUndo) )
         (gc) >

<de zapAllUndo ()
   (zapUndo)
   (mapc Apps
      '((App)
         (with App
            (slot undo NIL)
            (slot redo NIL) >

<de planeCmd (c)
   (unless (eq c Plane)
      (zapAllUndo)
      (do inval 'msrWin)
      (mapc Apps
         '((App)
            (when (eq 'cmyk (may classify App))
               (flushTiles) ) ) )
      (cmykRange #dotMin #dotMax (setq Plane c))
      (mapc Apps readTiles)
      (mapc Apps invalCmyks) >

T
