[msrWin.l 14aug92]

<de msrWinCmd ()
   (if (toggle MsrWin)
      (do show 'msrWin)
      (do hide 'msrWin) >

(object msrWin passive window)

<to init (obj)
   (with obj
      (slot winPtr
         (NewCWindow
            NIL
            '#(mvRect
               '((0 .  0) 128 . 128)
               (add 4 128 4) (add 20 (word MBarHeight)))
            #(str "Measure")
            NIL #noGrowDocProc [#altDBoxProc] -1 NIL obj ) )
      (slot pt1 "0,0")
      (slot pt2 "0,0")
      (slot dist "0,0")
      (slot angle "0") >

<to update (obj)
   (from window update obj
      '(()
         (EraseRect (portRect Port))
         (with obj
            (drawMsrWin1)
            (MoveTo 0 60) (LineTo 128 60)
            (drawMsrWin2)
            (MoveTo 0 82) (LineTo 128 82)
            (MoveTo 24 110)
            (DrawString
               (cdr
                  (assoc Plane
                     (quote
                        (NIL . "CMYK")
                        (T . "CMY")
                        (1 . "C")
                        (2 . "M")
                        (3 . "Y")
                        (0 . "K") ) ) ) )
            (MoveTo 81 82) (LineTo 81 128)
            (drawBlot 105 105 Blot) >

<de drawMsrWin1 ()
   (localPort (get 'msrWin 'winPtr)
      (EraseRect '((0.0) 128.60))
      (MoveTo 4 14)
      (DrawString "PT1:   ")
      (DrawString (slot pt1))
      (MoveTo 4 28)
      (DrawString "PT2:   ")
      (DrawString (slot pt2))
      (MoveTo 4 42)
      (DrawString "Dist:  ")
      (DrawString (slot dist))
      (MoveTo 4 56)
      (DrawString "Angle: ")
      (DrawString (slot angle))
      (DrawString " deg") >

<de drawMsrWin2 ()
   (localPort (get 'msrWin 'winPtr)
      (EraseRect '((0.61) 128.82))
      (MoveTo 16 76)
      (DrawString (slot kByte))
      (DrawString " kByte") >

<de distSpot (pt1 pt2)
   (setq
      pt1 (rtGlobal pt1)
      pt2 (rtGlobal pt2) )
   (with 'msrWin
      (slot pt1 (append (format (car pt1)) "," (format (cdr pt1))))
      (slot pt2 (append (format (car pt2)) "," (format (cdr pt2))))
      (slot dist
         (append
            (format (sub (car pt2) (car pt1)))
            ","
            (format (sub (cdr pt2) (cdr pt1))) ) )
      (slot angle
         (if (equal pt1 pt2)
            "?"
            (format
               (angle
                  (sub (car pt2) (car pt1))
                  (sub (cdr pt1) (cdr pt2))
                  10 )
               1 ) ) )
      (drawMsrWin1) >

<de msrMem ()
   (when MsrWin
      (local (n)
         (setq n (sub (div (MaxMem) 1024) #safety))
         (with 'msrWin
            (unless (eq n (slot mem))
               (slot kByte (format (slot mem n)))
               (drawMsrWin2) >

T
