[plugin.l 14aug92]

(setq
   acqType "8BAM"
   expType "8BEM"
   mixType "8BPI" )

[+ Operation selectors +]
(enum
   acquireSelectorAbout
   acquireSelectorStart
   acquireSelectorContinue
   acquireSelectorFinish
   acquireSelectorPrepare )

(enum
   exportSelectorAbout
   exportSelectorStart
   exportSelectorContinue
   exportSelectorFinish
   exportSelectorPrepare )

<de plugFiles (typ)
   (filter (dir)
      '((s) (equal typ (fType s))) >

<de addPlugins ()
   (mapc
      (setq PlugFiles
         (nconc
            (plugFiles #acqType)
            (plugFiles #expType)
            (plugFiles #mixType) ) )
      '((nm)
         (local (fd s)
            (localVol Bin
               (setq fd (OpenResFile nm))
               (when (plusp (Count1Resources #acqType))
                  (setq s (GetResInfo (Get1IndResource #acqType 1)))
                  (adMenu IMBar #(str "Acquire") T
                     (list 'doAcquire nm) NIL s )
                  (adMenu RMBar #(str "Acquire") T
                     (list 'doAcquire nm) NIL s )
                  (adMenu BMBar #(str "Acquire") T
                     (list 'doAcquire nm) NIL s ) )
               (when (plusp (Count1Resources #expType))
                  (adMenu RMBar #(str "Export")
                     '(not (is rdOnly (get App 'home)))
                     (list 'doExport 'App nm) NIL
                     (GetResInfo (Get1IndResource #expType 1)) ) )
               (CloseResFile fd) >

<de plugAbout (s)
   (local (n)
      (localVol Bin
         (zero n)
         (plugin s #acqType #acquireSelectorAbout NIL n)
         (zero n)
         (plugin s #expType #acquireSelectorAbout NIL n) >

<de doAcquire (s)
   (local (fd nm tmp b sc h v)
      (localVol Bin
         (and
            (needMem #(add (mul 4 640 640) (mul 4 256 256)))
            (setq fd (create (setq tmp (genTmp))))
            (if
               (setq nm
                  (acqCMYK s #acqType
                     progress #(str "Acquire Image") fd b sc h v ) )
               (new '(mask cmyk1) (GetVol) nm tmp fd b sc h v)
               (progn (close fd) (erase tmp)) >

<de doExport (App s)
   (with App
      (when (needMem (mul #(mul 4 4 tile2) (slot- cols)))
         (flushTiles)
         (localVol Bin
            (expCMYK s #expType
               progress
               (append #(str "Export ") (slot- name) " to " s)
               (slot- fd) (slot- vol) (slot- name) )
            (zapUndo)
            (remove (slot home) 'dirty) >

T
