[retouch.l 14aug92]

(off PxSrc PxSrcPt PxSrcRgn)
(de Brush 225 225 225 225 225)

<de rtSpot (pt)
   (fatSpot)
   (hvSpot pt) >

<de chgMask (z pt ptx)
   (local (z1 a b c i)
      (localClip (get App 'view)
         (setq
            z1 (copy z)
            i (index ptx z1)
            a (rtLocal
               (if (zerop i)
                  (last2 z1)
                  (nth (sub1 i) z1) ) )
            b (rtLocal ptx)
            c (rtLocal (nth (add1 i) z1)) )
         (PenNormal)
         (PenMode #patXor)
         (maskDot ptx)
         (PenSize 1 1)
         (line2 a b)
         (line2 b c)
         (while (StillDown)
            (fatSpot)
            (line2 a pt)
            (line2 pt c)
            (delay 2)
            (setq b (GetMouse))
            (rplaca b
               (limit (car b) 0
                  (mul #tile (slot zoom)
                     (sub (slot- cols) (slot- pos-h)) ) ) )
            (rplacd b
               (limit (cdr b) 0
                  (mul #tile (slot zoom)
                     (sub (slot- rows) (slot- pos-v)) ) ) )
            (line2 a pt)
            (line2 pt c)
            (setq pt b) )
         (setq
            pt (rtGlobal pt)
            b (rtLocal pt) ) [Align to pixel boundary]
         (line2 a b)
         (line2 b c)
         (maskDot pt)
         (subst pt ptx z1)
         (if (zerop i)
            (rplaca (tail z1) pt) ) )
      (make #(str "Change mask") NIL
         (list Mark (slot- mask))
         undoMask
         (list (cons z1 (delete z Mark)))
         makeMask >

<de mvMask (pt)
   (local (r h1 h2 v1 v2 dh dv g ptx)
      (mapc (setq g Mark) hiZug)
      (setq
         r (bounds Mark)
         h1 (left r)
         h2 (right r)
         v1 (top r)
         v2 (bottom r) )
      (with App
         (while (StillDown)
            (fatSpot)
            (setq
               ptx (GetMouse)
               dh (limit
                  (div (sub (car ptx) (car pt)) (slot zoom))
                  (minus h1)
                  (sub (mul #tile (slot- cols)) h2) )
               dv (limit
                  (div (sub (cdr ptx) (cdr pt)) (slot zoom))
                  (minus v1)
                  (sub (mul #tile (slot- rows)) v2) ) )
            (unless (and (zerop dh) (zerop dv))
               (mapc g drawMask)
               (mapc (setq g (mvGraf g dh dv)) drawMask)
               (inc h1 dh)
               (inc h2 dh)
               (inc v1 dv)
               (inc v2 dv)
               (setq pt ptx) ) )
         (mapc g hiZug)
         (make #(str "Drag mask") NIL
            (list Mark (slot- mask))
            undoMask
            (list g)
            makeMask >

<de doMask (pt)
   (when (is showMask (get App 'home))
      (local (z ptx)
         (with App
            (cond
               ((not (setq z (find (slot- mask)
                           '((z)
                              (onSide (rtGlobal pt) (list z) 4)) ) ) )
                  (newMask pt) )
               ((bit #shiftBit (ev-modifiers Event))
                  (doSelMask z
                     '((z)
                        ((if (memq z Mark) unHiMask hiMask) z)
                        (invalOthers) ) ) )
               ((not (memq z Mark))
                  (doSelMask z
                     '((z)
                        (mapc Mark unHiMask)
                        (hiMask z)
                        (invalOthers) ) ) )
               ((or
                     (bit #cmdBit (ev-modifiers Event))
                     (not
                        (setq ptx
                           (find z
                              '((x)
                                 (lessp
                                    (dist (rtLocal x) pt)
                                    #dotSiz ) ) ) ) ) )
                  (mvMask pt) )
               (T (chgMask z pt ptx)) >

<de hiMask (z)
   (unless (memq z Mark)
      (setq Mark (append Mark (list z)))
      (hiZug z) >

<de unHiMask (z)
   (when (memq z Mark)
      (setq Mark (delete z Mark))
      (hiZug z) >

<de doSelMask (z foo)
   (make #(str "Select Mask") NIL
      (list Mark)
      '((x)
         (mapc Mark unHiMask)
         (mapc x hiMask)
         (invalOthers) )
      (list z)
      foo >

<de newMask (pt)
   (when (fitPoint (setq pt (rtGlobal pt)))
      (local (Poly z)
         (setq Poly (list pt))
         (PenMode #patXor)
         (while
            (or
               (setq pt (click rtGlobal stiff rtSpot (car Poly) rtLine2))
               (c-key) )
            (if (c-key)
               (when (cdr Poly)
                  (rtLine2 (pop Poly) (car Poly)) )
               (when (fitPoint pt)
                  (rtLine2 (car Poly) pt)
                  (push pt Poly) )  ) )
         (rtMoveTo (caar Poly) (cdar Poly))
         (rtLineTo (car (last Poly)) (cdr (last Poly)))
         (drawMask
            (setq z
               (cons (last Poly) Poly) ) )
         (when (lessp 2 (length Poly))
            (make #(str "Mask") NIL
               (list Mark)
               '((x)
                  (removeMask Mark)
                  (mapc x hiMask)
                  (invalOthers) )
               (list z)
               '((z)
                  (mapc Mark unHiMask)
                  (put (get App 'home) 'mask
                     (cons z (get (get App 'home) 'mask)) )
                  (drawMask z)
                  (hiMask z)
                  (invalOthers) >

<de pixPercent (n)
   (append
      (format
         (cond
            ((leq n 25) 0)
            ((leq 225 n) 100)
            (T (muldiv (sub n 25) 100 #(sub 225 25))) ) )
      "%" >

<de getPix (pt)
   (local (p)
      (with App
         (localLock (slot- base)
            (when
               (setq p
                  (pixPtr
                     (slot- base)
                     (div (car pt) (slot zoom))
                     (div (cdr pt) (slot zoom)) ) )
               (list
                  (bitAnd (byte (add1 p)) 255)
                  (bitAnd (byte (add2 p)) 255)
                  (bitAnd (byte (add 3 p)) 255)
                  (bitAnd (byte p) 255) >

<de measureSpot (pt)
   (local (c)
      (when (setq c (getPix pt))
         (and Brushes
            (do set (car Brushes) (nconc1 c (last Brush))) )
         (do print 'spot
            (append
               (when (or (not (numberp Plane)) (onep Plane))
                  (append " C " (pixPercent (car c))" ") )
               (when (or (not (numberp Plane)) (eq 2 Plane))
                  (append " M " (pixPercent (cadr c)) " ") )
               (when (or (not (numberp Plane)) (eq 3 Plane))
                  (append " Y " (pixPercent (caddr c)) " ") )
               (when (or (not Plane) (zerop Plane))
                  (append " K " (pixPercent (cadddr c)) " ") >

<de doMeasure (pt)
   (measureSpot pt)
   (delay (ptr #DoubleTime))
   (when (StillDown)
      (PenNormal)
      (PenMode #patXor)
      (local (pt1 pt2)
         (line2 pt (setq pt1 (GetMouse)))
         (while (StillDown)
            (unless (equal pt1 (setq pt2 (GetMouse)))
               (fatSpot)
               (localClip (get App 'view)
                  (line2 pt pt1)
                  (line2 pt pt2) )
               (distSpot pt (setq pt1 pt2)) ) )
         (line2 pt pt2)
         (measureSpot pt2) >

<de copy1px (pt s)
   (when (needMem #(mul tile2 4 2))
      (local (z1 h1 v1 z2 h2 v2 b sav)
         (with App
            (setq
               z1 (get PxSrc 'zoom)
               h1 (div (car PxSrcPt) z1)
               v1 (div (cdr PxSrcPt) z1)
               z2 (slot zoom)
               h2 (div (car pt) z2)
               v2 (div (cdr pt) z2)
               b (slot- base)
               sav (pxSave b h2 v2 Blot) )
            (make s T
               (list h2 v2 sav b Blot)
               '((h2 v2 sav b Blot)
                  (pxUndo b h2 v2 sav Blot)
                  (touchBlot h2 v2)
                  (showBlot h2 v2)
                  (invalOthers) )
               (list (get PxSrc 'home 'base) h1 v1 b h2 v2
                  (last Brush) Blot )
               '((b1 h1 v1 b2 h2 v2 i Blot)
                  (pxCopy b1 h1 v1 b2 h2 v2 i Blot)
                  (touchBlot h2 v2)
                  (showBlot h2 v2)
                  (invalOthers) >

<de fill1px (pt s l)
   (when (needMem #(mul tile2 4 2))
      (local (z2 h2 v2 b sav)
         (with App
            (setq
               z2 (slot zoom)
               h2 (div (car pt) z2)
               v2 (div (cdr pt) z2)
               b (slot- base)
               sav (pxSave b h2 v2 Blot) )
            (make s T
               (list h2 v2 sav b Blot)
               '((h2 v2 sav b Blot)
                  (pxUndo b h2 v2 sav Blot)
                  (touchBlot h2 v2)
                  (showBlot h2 v2)
                  (invalOthers) )
               (list l b h2 v2 Blot)
               '((l b2 h2 v2 Blot)
                  (pxFill (pop l) (pop l) (pop l) (pop l)
                     b2 h2 v2 (pop l) Blot )
                  (touchBlot h2 v2)
                  (showBlot h2 v2)
                  (invalOthers) >

<de offPxSrc ()
   (when PxSrc
      (when PxSrcRgn
         (localPort (get PxSrc 'winPtr)
            (FrameRgn PxSrcRgn) )
         (DisposeRgn PxSrcRgn)
         (off PxSrcRgn) )
      (off PxSrc) >

<de doSpuit (pt)
   (setq  PxSrc App  PxSrcPt pt)
   (measureSpot pt) [(enterdst)]
   (setq pt (drag pt fatSpot))
   (if
      (and
         (not (is rdOnly (get App 'home)))
         (drin Blot pt 0) )
      (copy1px pt #(str "Spuit"))
      (SysBeep 8) )
   (enterSrc)
   (offPxSrc) >

<de doPxCopy (pt)
   (if PxSrc
      (if (is rdOnly (get App 'home))
         (SysBeep 8)
         (local (z1 z2 pt1 dh dv)
            (setq
               z1 (get PxSrc 'zoom)
               z2 (get App 'zoom) )
            (while (StillDown)
               (msrMem)
               (fatSpot)
               (localPort (get PxSrc 'winPtr)
                  (PenNormal)
                  (PenMode #patXor)
                  (FrameRgn PxSrcRgn) )
               (if (drin Blot pt 0)
                  (copy1px pt #(str "Copy Step"))
                  (SysBeep 8) )
               (setq
                  pt1 (GetMouse)
                  dh (muldiv (sub (car pt1) (car pt)) z1 z2)
                  dv (muldiv (sub (cdr pt1) (cdr pt)) z1 z2)
                  PxSrcPt (cons
                     (add dh (car PxSrcPt))
                     (add dv (cdr PxSrcPt)) ) )
               (localPort (get PxSrc 'winPtr)
                  (OffsetRgn PxSrcRgn dh dv)
                  (FrameRgn PxSrcRgn) )
               (setq pt pt1) )
            (offPxSrc)
            (enterSrc) ) )
      (progn
         (setq  PxSrc App  PxSrcPt pt)
         (PenNormal)
         (PenMode #patXor)
         (FrameRgn
            (setq PxSrcRgn (blotRgn pt Blot)) )
         (enterDst) >

<de doBrush (pt)
   (if (bit #cmdBit (ev-modifiers Event))
      (if Brushes
         (do set (car Brushes) (nconc1 (getPix pt) (last Brush)))
         (new 'brushDialog (nconc1 (getPix pt) (last Brush))) )
      (if (is rdOnly (get App 'home))
         (SysBeep 8)
         (while (StillDown)
            (msrMem)
            (fatSpot)
            (if (drin Blot pt 0)
               (fill1px pt #(str "Brush Step") Brush)
               (SysBeep 8) )
            (setq pt (GetMouse)) >

<de doSoften ()
   [+ (while (StillDown) +]
      (fatSpot)
      (blotWisch (GetMouse) wixLo #(str "Soften")) >

<de doSharpen ()
   [+ (while (StillDown) +]
      (fatSpot)
      (blotWisch (GetMouse) wixHi #(str "Sharpen")) >

<de blotWisch (pt foo s)
   (when (needMem #(mul tile2 4 2))
      (local (res b h v sav lft h1 v1)
         (with App
            (setq
               b (slot- base)
               h (div (car pt) (slot zoom))
               v (div (cdr pt) (slot zoom))
               sav (pxSave b h v Blot)
               res (dynamo DisposHandle (NewHandle 0)) ) )
         (if
            (and
               (not (is rdOnly (get App 'home)))
               (drin Blot pt 1) )
            (progn
               (for (w 0 256 (add w 64))
                  (SetHandleSize (ref res) 0)
                  (localLock b
                     (mapc Blot
                        '((x)
                           (setq
                              lft (pop x)         [blot left distance]
                              v1 (add v (pop x))
                              h1 (add h lft) )
                           (foo (pixPtr b h1 v1) (ref res) x w) ) ) )
                  (blotPx b h v res Blot) )
               (make s T
                  (list h v sav b Blot)
                  '((h v sav b Blot)
                     (pxUndo b h v sav Blot)
                     (touchBlot h v)
                     (showBlot h v)
                     (invalOthers) )
                  (list b h v res Blot)
                  '((b h v res Blot)
                     (blotPx b h v res Blot)
                     (touchBlot h v)
                     (showBlot h v)
                     (invalOthers) ) ) )
            (SysBeep 8) >

[blot in 640*640 pixmap,n=1 for softening]
[for softening, blotsize + 1 for filter]
[++++++
<de drin (blot pt n)
   (local (c m dh dv)
      (with App
         (setq
            c (car (worst blot car))
            m (cadr (worst blot cadr))
            dh (div (car pt) (slot zoom))
            dv (div (cdr pt) (slot zoom)) )
         (and
            (leq n (add dv m) (add (sub dv m) n)
               (min 640 (mul #tile (sub (slot- rows) (slot- pos-v)))) )
            (leq n (add dh c) (add (sub dh c) n)
               (min 640 (mul #tile (sub (slot- cols) (slot- pos-h)))) >
++++++]

<de drin (blot pt n)
   (local (h1 v1 h2 v2 dh dv)
      (setq  h1 Max  v1 Max  h2 Min)
      (mapc blot
         '((l)
            (setq
               h1 (min h1 (car l))
               v1 (min v1 (cadr l))
               h2 (max h2 (add (car l) (sub2 (length l)))) ) ) )
      (with App
         (setq
            v2 (add v1 (length blot))
            dh (div (car pt) (slot zoom))
            dv (div (cdr pt) (slot zoom)) )
         (and
            (leq n (add dv v1) (add (add dv v2) n)
               (min 640 (mul #tile (sub (slot- rows) (slot- pos-v)))) )
            (leq n (add dh h1) (add (add dh h2) n)
               (min 640 (mul #tile (sub (slot- cols) (slot- pos-h)))) >

<de pixFilter (foo s)
   (local (u cnt)
      (and
         (setq u
            (storage
               (mul #(mul 4 tile2) (get App 'home 'cols))
               (mul 4 (scan Mark 2)) ) )
         (needMem (mul 4 (scan Mark 2)))
         (setq cnt (dialog1 #(str "Number of Passes") "1" 2))
         (make s T
            (list (saveColor Mark u) Mark)
            undoColor
            (list foo (number cnt))
            '((foo cnt)
               (local (b dh dv buf p)
                  (with App
                     (setq
                        b (slot- base)
                        dh (mul #tile (slot- pos-h))
                        dv (mul #tile (slot- pos-v))
                        buf (alloc (mul 4 (scan Mark 2))) ) )
                  (progress
                     (mul 2 cnt (scanLines Mark))
                     #(str "Filtering Image") )
                  (touchMask Mark)
                  (localLock b
                     (catch T
                        (reptn cnt
                           (setq p buf)
                           (scan Mark 2
                              '((v h1 h2)
                                 (setq p
                                    (foo
                                       (pixPtr b (sub h1 dh) (sub v dv))
                                       p
                                       (sub h2 h1) ) )
                                 (unless (progress) (throw T)) ) )
                           (setq p buf)
                           (scan Mark 2
                              '((v h1 h2)
                                 (inc p
                                    (block p
                                       (pixPtr b (sub h1 dh) (sub v dv))
                                       (mul 4 (sub h2 h1)) ) )
                                 (unless (progress) (throw T)) ) ) ) ) )
                  (free buf)
                  (invalCmyks App) >

<de blotPx (b h v hnd bl)
   (local (i p lft len)
      (zero i)
      (setq p (HLock (ref hnd)))
      (localLock b
         (mapc bl
            '((x)
               (setq
                  lft (pop x)  [blot left distance]
                  len (mul #(mul 4 2) (abs lft)) )
               (block
                  (add i p)
                  (pixPtr b (add h lft) (add v (pop x)))
                  len )
               (inc i len) ) ) )
      (HUnlock (ref hnd)) >

<de calcZoom (h v)
   (mul
      (get App 'zoom)
      (abs
         (min
            (div 640 h)
            (div 640 v) >

T
