/* macColor.c
 * 07dec92abu
 */

#include "pico.h"
#include "mac.h"

/* Prototypes */
static pico pOpenCPort(pico);
static pico pRGBForeColor(pico);
static pico pRGBBackColor(pico);
static pico pNewPixMap(void);
static pico pDisposPixMap(pico);
static pico pCopyPixMap(pico);
static pico pSetPortPix(pico);
static pico pGetGDevice(void);
static pico pSetGDevice(pico);
static pico pGetMaxDevice(pico);
static pico pGetColor(pico);
static pico pNewCWindow(pico);

symInit colorSyms[] = {
   {"OpenCPort",     pOpenCPort},   /* Color QuickDraw */
   {"RGBForeColor",  pRGBForeColor},
   {"RGBBackColor",  pRGBBackColor},
   {"NewPixMap",     pNewPixMap},
   {"DisposPixMap",  pDisposPixMap},
   {"CopyPixMap",    pCopyPixMap},
   {"SetPortPix",    pSetPortPix},
   {"GetGDevice",    pGetGDevice},   /* Device Manager */
   {"SetGDevice",    pSetGDevice},
   {"GetMaxDevice",  pGetMaxDevice},
   {"GetColor",      pGetColor},      /* Color Picker */
   {"NewCWindow",    pNewCWindow},   /* Window Manager */
   NULL
};


pico pOpenCPort(x)
pico x;
{
   OpenCPort((CGrafPtr)nextPtr(&x));
   return tSym;
}

pico pRGBForeColor(x)
pico x;
{
   RGBColor c;

   nextColor(&x,&c);
   RGBForeColor(&c);
   return tSym;
}

pico pRGBBackColor(x)
pico x;
{
   RGBColor c;

   nextColor(&x,&c);
   RGBBackColor(&c);
   return tSym;
}

pico pNewPixMap()
{
   return chkPtr(NewPixMap());
}

pico pDisposPixMap(x)
pico x;
{
   DisposPixMap(nextPtr(&x));
   return tSym;
}

pico pCopyPixMap(x)
pico x;
{
   PixMapHandle srcPM;

   srcPM = nextPtr(&x);
   CopyPixMap(srcPM, nextPtr(&x));
   return tSym;
}

pico pSetPortPix(x)
pico x;
{
   SetPortPix((PixMapHandle)nextNum(&x));
   return tSym;
}

pico pGetGDevice()
{
   return chkPtr(GetGDevice());
}

pico pSetGDevice(x)
pico x;
{
   SetGDevice((GDHandle)nextNum(&x));
   return tSym;
}

pico pGetMaxDevice(x)
pico x;
{
   Rect r;

   nextQdRect(&x,&r);
   return chkPtr(GetMaxDevice(&r));
}

pico pGetColor(x)
pico x;
{
   Point where;
   Str255 prompt;
   RGBColor in, out;

   where.h = 0;
   where.v = 0;
   nextCntString(&x,prompt);
   nextColor(&x,&in);
   if (!GetColor(where, prompt, &in, &out))
      return nilSym;
   return boxColor(out.red, out.green, out.blue);
}

pico pNewCWindow(x)
pico x;
{
   Ptr wStorage;
   Rect boundsRect;
   Str255 title;
   bool visible;
   integer procID;
   WindowPtr behind;
   bool goAwayFlag;

   wStorage = nextPtr(&x);
   nextQdRect(&x,&boundsRect);
   nextCntString(&x,title);
   visible = nextBool(&x);
   procID = (integer)nextNum(&x);
   behind = (WindowPtr)nextNum(&x);
   goAwayFlag = nextBool(&x);
   return chkPtr(NewCWindow(wStorage, &boundsRect, title, visible,
                           procID, behind, goAwayFlag, (long)EVAL1(x)));
}
