/* macLib.c
 * 19dec92abu
 */

#pragma segment macLib

#include "pico.h"
#include "mac.h"

pico portSym;							/* thePort */
OSType creator = 'PICO';			/* File creator */
integer binVol;						/* Application's home volume */
static integer saveMask;			/* Keep SysEvtMask */
integer inAux=0, outAux=0;			/* Serial channel */

/* Console */
#define COLS      80
#define ROWS      25
#define WINDIST    2
#define WIDTH      6
#define HEIGTH    11
WindowPtr console = NULL;
static int col,row;
static char txtBuf[ROWS][COLS];

SerShk serShake = {
	YES,			/* fXOn */
	YES,			/* fCTS */
	ctrl('Q'),	/* xOn */
	ctrl('S'),	/* xOff */
	0,				/* errs */
	0,				/* evts */
	YES,			/* fInX */
	YES			/* fDTR */
};

#define LOADMAX 6
static char loadBuff[LOADMAX][FILENAME];

/* Prototypes */
static pico dir1(HFileInfo*);
static void ttyCR(int);
static void ttyNL(int);

void libStartUp()
{
#if 0
	Handle h;
	long nStack;
#endif
	integer message,count;
	AppFile file;
	Str255 apName;
	integer apRefNum;
	Handle apParam;
	integer refNum;
	long logEOF;

#if 0
	nStack = 16*1024;
	if (h = GetResource('pirm',1)) {
		nStack = (*(long*)(*h));	/* Stack size */
		ReleaseResource(h);
	}
	SetApplLimit(GetApplLimit() - nStack);
	if (MemError())
		giveup("Memory Limit");
	MaxApplZone();
#endif
	GetVol(apName, &binVol);
	GetAppParms(apName,&apRefNum,&apParam);
	FSOpen(apName, 0, &refNum);
	GetEOF(refNum, &logEOF);
	if (logEOF)
   	frzFd = (int)refNum;
	else
		FSClose(refNum);
	CountAppFiles(&message, &count); /* All files should be in same folder */
	while (count > 0) {
		GetAppFiles(count,&file);
		SetVol((StringPtr)NULL, file.vRefNum);
		if (file.fType=='FREZ') {
			if (frzFd)
				giveup("More than 1 Freeze");
			if (FSOpen(file.fName, 0, &refNum))
				giveup("Freeze Open Error");
   		frzFd = (int)refNum;
		}
		else if (loadCnt < LOADMAX) {
			cString(file.fName, fileNames[loadCnt] = loadBuff[loadCnt]);
			++loadCnt;
		}
		ClrAppFiles(count);
		--count;
	}
}

void libExit()
{
	*(integer*)SysEvtMask = saveMask;
	if (frzFd)
		FSClose((integer)frzFd);
	if (inAux)
		CloseDriver(inAux);
	if (outAux)
		CloseDriver(outAux);
	ExitToShell();
}

void libError(s)
uchar *s;
{
	if (console) {
   	prString(s);
		crlf();
		while (!Button());
	}
}

char *libAlloc(size)
unsigned long size;
{
   return (char*)NewPtr(size);
}

void libFree(ptr)
char *ptr;
{
   DisposPtr(ptr);
}

char *libRealloc(ptr,size)
char *ptr;
unsigned long size;
{
   register char *p;

   SetPtrSize(ptr,size);
	if (!MemError())
      return ptr;
   if (p = (char*)NewPtr(size)) {
   	BlockMove(ptr,p,size);
   	DisposPtr(ptr);
   	return p;
	}
   return NULL;
}

void libBlock(src,dst,size)
char *src,*dst;
unsigned long size;
{
   BlockMove((Ptr)src,(Ptr)dst,size);
}

long libTick()
{
	return *(long*)Ticks;
}

void libDate(y,m,d)
number *y,*m,*d;
{
	DateTimeRec t;

	GetTime(&t);
	*y = t.year % 100;
	*m = t.month;
	*d = t.day;
}

void libTime(h,m,s)
number *h,*m,*s;
{
	DateTimeRec t;

	GetTime(&t);
	*h = t.hour;
	*m = t.minute;
	*s = t.second;
}

int libRdOpen(s)
uchar *s;
{
	Str255 fName;
	integer refNum;

	macString(s,fName);
	if (FSOpen(fName, 0, &refNum))
		return -1;
	return refNum;
}

int libWrOpen(s,flgs)
uchar *s;
long flgs;
{
	Str255 fName;
	integer refNum;
	extern OSType creator;

	macString(s,fName);
	if (FSOpen(fName, 0, &refNum) == noErr) {
		if (SetEOF(refNum,0))
			return -1;
	}
	else if (Create(fName,0,creator, flgs? 'FREZ':'TEXT') ||
													FSOpen(fName,0,&refNum))
		return -1;
	return refNum;
}

int libRdWrOpen(s)
uchar *s;
{
	Str255 fName;
	integer refNum;

	macString(s,fName);
	if (FSOpen(fName, 0, &refNum))
		return -1;
	return refNum;
}

int libRead(fd,buf,cnt)
int fd;
char *buf;
long cnt;
{
	OSErr e;

	if ((e = FSRead((integer)fd, &cnt, buf)) && e != eofErr)
		return -1;
	return cnt;
}

int libWrite(fd,buf,cnt)
int fd;
char *buf;
long cnt;
{
	if (FSWrite(fd, &cnt, buf))
		return -1;
	return cnt;
}

bool libSeek(fd,pos)
int fd;
long pos;
{
	return !SetFPos(fd, fsFromStart, pos);
}

long libFPos(fd)
int fd;
{
	long pos;

	if (GetFPos(fd, &pos))
		return -1;
	return pos;
}

long libFSize(fd)
int fd;
{
	long pos;

	if (GetEOF(fd,&pos))
		return -1;
	return pos;
}

bool libClose(fd)
int fd;
{
	return !FSClose(fd) && !FlushVol((StringPtr)NULL,0);
}

pico dir1(cir)
register HFileInfo *cir;
{
	pico x;

	if (PBGetCatInfo((CInfoPBPtr)cir,NO) != noErr)
		return NULL;
	x = unBufCntString((cir->ioNamePtr)[0], cir->ioNamePtr+1);
	if (cir->ioFlAttrib & 0x10)
		nconc(x, newCell(boxNum(':'), nilSym));
	++cir->ioFDirIndex;
	return x;
}

pico libDir(s)
uchar *s;
{
	pico x,y;
	Str255 fName;
	HFileInfo cir;
	long id;
	cell c1;

	cir.ioNamePtr = (StringPtr)fName;
	cir.ioCompletion = NULL;
	if (*s) {
		macString(s,fName);
		cir.ioVRefNum = 0;
		cir.ioFDirIndex = 0;
		cir.ioDirID = 0;
		if (PBGetCatInfo((CInfoPBPtr)&cir,NO))
			return nilSym;
		id = cir.ioDirID;
		/* cir.ioVRefNum = 0; */
		cir.ioFDirIndex = -1; /* = ioVolIndex */
		if (PBGetVInfo((ParmBlkPtr)&cir,NO))
			return nilSym;
	}
	else {
		id = 0;
		if (GetVol(fName, &cir.ioVRefNum))
			return nilSym;
	}
	cir.ioFDirIndex = 1;
	if (cir.ioDirID = id, !(x = dir1(&cir)))
		return nilSym;
	push(y = newCell(x,nilSym),c1);
	while (cir.ioDirID = id, x = dir1(&cir)) {
		cdr(y) = newCell(x,nilSym);
		y = cdr(y);
	}
	return pop(c1);
}

bool libLink(old,new)
uchar *old,*new;
{
	Str255 oldBuf;
	Str255 newBuf;
	IOParam pb;

	macString(old,oldBuf);
	macString(new,newBuf);
	pb.ioNamePtr = oldBuf;
	pb.ioVRefNum = 0;
	pb.ioVersNum = 0;
	pb.ioMisc = newBuf; 
	return !PBRename((ParmBlkPtr)&pb, NO);
}

bool libUnlink(s)
uchar *s;
{
	Str255 buf;
	IOParam pb;

	macString(s,buf);
	pb.ioNamePtr = buf;
	pb.ioVRefNum = 0;
	pb.ioVersNum = 0;
	return !PBDelete((ParmBlkPtr)&pb, NO);
}

void initConsole()
{
	KeyMap map;
   Rect r;

	/* Init Mac Toolbox */
	MoreMasters(), MoreMasters(), MoreMasters(), MoreMasters();
	InitGraf(&qd.thePort);
	InitFonts();
	InitWindows();
	InitMenus();
	TEInit();
	InitDialogs(NULL);
	InitCursor();
	saveMask = *(integer*)SysEvtMask;
	SetEventMask(everyEvent);

	/* Init Console only if Control-Key is pressed */
	GetKeys(&map);
	if (map[1] & 8) {
      r.left = WINDIST;
      r.bottom = qd.screenBits.bounds.bottom - WINDIST;
      r.right = r.left + (WIDTH*COLS + 4+4);
      r.top = r.bottom - (HEIGTH*ROWS + 4);
      console = NewWindow(NULL, &r, "\pPico Console", YES,
                                   rDocProc, (WindowPtr)-1, YES, NULL );
      SetPort(console);
      TextFont(monaco);
      TextSize(9);
      MoveTo(4,HEIGTH);
      for (row = 0; row < ROWS; ++row)
         for (col = 0; col < COLS; ++col)
            txtBuf[row][col] = ' ';
      col = row = 0;
	}
}

bool initSerial(s)
uchar *s;
{
	static uchar in[] = "\p.AIn";
	static uchar out[] = "\p.AOut";

	if (inAux)
		CloseDriver(inAux);
	if (outAux)
		CloseDriver(outAux);
	in[2] = *s; /* "A" or "B" */
	out[2] = *s;
	if (OpenDriver(in, &inAux) || OpenDriver(out, &outAux))
		return NO;
	SerHShake(outAux, &serShake);
	SerReset(inAux, baud9600+data8+stop10+noParity);
	SerReset(outAux, baud9600+data8+stop10+noParity);
	return YES;
}

void initSysSyms()
{
	extern symInit grafSyms[], macSyms[];
	extern symInit rsrcSyms[], memSyms[], qdSyms[], fontSyms[], eventSyms[], winSyms[];
	extern symInit menuSyms[], textSyms[], dlgSyms[], deskSyms[], toolSyms[], printSyms[];
	extern symInit osSyms[], macioSyms[], ctlSyms[], colorSyms[], soundSyms[], listSyms[];

	initSymTab(grafSyms);
	initSymTab(macSyms);
	initSymTab(rsrcSyms);
	initSymTab(memSyms);
	initSymTab(qdSyms);
	initSymTab(fontSyms);
	initSymTab(eventSyms);
	initSymTab(winSyms);
	initSymTab(menuSyms);
	initSymTab(textSyms);
	initSymTab(dlgSyms);
	initSymTab(deskSyms);
	initSymTab(toolSyms);
	initSymTab(printSyms);
	initSymTab(osSyms);
	initSymTab(macioSyms);
	initSymTab(ctlSyms);
	initSymTab(colorSyms);
	initSymTab(soundSyms);
	initSymTab(listSyms);
}

void initSysVars()
{
	init1Sym("Console", YES, chkPtr(console));
	portSym = init1Sym("Port", YES, boxNum(qd.thePort));
	init1Sym("White", YES, boxNum(&qd.white));
	init1Sym("Black", YES, boxNum(&qd.black));
	init1Sym("Gray", YES, boxNum(&qd.gray));
	init1Sym("LtGray", YES, boxNum(&qd.ltGray));
	init1Sym("DkGray", YES, boxNum(&qd.dkGray));
	init1Sym("Arrow", YES, boxNum(&qd.arrow));
	init1Sym("ScreenBits", YES, boxNum(&qd.screenBits));
}

bool serialReady()
{
	long count = 1;
	
	SerGetBuf(inAux, &count);
	return (bool)count;
}

int serialIn()
{
	long count = 1;
	char buff[4];
	
	if (FSRead(inAux, &count, buff))
		err("Serial input error");
	return buff[0];
}

void serialOut(c)
int c;
{
	long count = 1;
	char buff[4];
	
	buff[0] = c;
	if (FSWrite(outAux, &count, buff))
		err("Serial output error");
}

void ttyCR(v)
int v;
{
   col = 0;
   MoveTo(4,v);
}

void ttyNL(v)
int v;
{
	register int i;
   RgnHandle updtRgn;

   if (v < qd.thePort->portRect.bottom-4) {
      ++row;
      Move(0, HEIGTH);
   }
   else {
      BlockMove((Ptr)&txtBuf[1], (Ptr)&txtBuf[0], COLS*(ROWS-1));
      for (i = 0; i < COLS; ++i)
         txtBuf[ROWS-1][i] = ' ';
      updtRgn = NewRgn();
      ScrollRect(&qd.thePort->portRect, 0, -HEIGTH, updtRgn);
      DisposeRgn(updtRgn);
   }
}

void ttyOut(c)
int c;
{
   GrafPtr oldPort;
   Point pos;
   Rect r;

	if (console) {
      if (FrontWindow() == console)
         while (Button()) /* Scroll stop */
            SystemTask();
      GetPort(&oldPort);
      SetPort(console);
      GetPen(&pos);
      switch (c) {
         case ctrl('G'):
            SysBeep(6);
            break;
         case BS:
            if (pos.h > 4) {
               --col;
               Move(-WIDTH, 0);
            }
            else if (pos.v > HEIGTH) {
               --row;
               col = COLS-1;
               MoveTo(qd.thePort->portRect.right-4-WIDTH, pos.v-HEIGTH);
            }
            break;
         case CR:
            ttyCR(pos.v);
            break;
         case NL:
            ttyNL(pos.v);
            break;
         default:
            if (pos.h >= qd.thePort->portRect.right-4) {
               ttyCR(pos.v);
               ttyNL(pos.v);
               GetPen(&pos);
            }
            if (txtBuf[row][col] != ' ') {
               r.top = pos.v - HEIGTH + 2;
               r.left = pos.h;
               r.bottom = pos.v + 2;
               r.right = pos.h + WIDTH;
               EraseRect(&r);
            }
            DrawChar(txtBuf[row][col++] = c);
      }
      SetPort(oldPort);
	}
}

bool ttyAvail()
{
   EventRecord ev;

	if (!console)
      return NO;
   return EventAvail(keyDownMask, &ev);
}

void drawConsole()
{
   GrafPtr oldPort;
   int i;
   Point oldPos;

   GetPort(&oldPort);
   SetPort(console);
   GetPen(&oldPos);
   BeginUpdate(console);
   for (i = 0; i < ROWS; ++i) {
      MoveTo(4, HEIGTH*(i+1));
      DrawText(txtBuf[i],0,COLS);
   }
   EndUpdate(console);
   MoveTo(oldPos.h, oldPos.v);
   SetPort(oldPort);
}

int waitTTY()
{
   EventRecord ev;
	WindowPtr win;
   Rect r;

   if (!console)
		Quit(nilSym);
   ttyOut(0xC9);
   ttyOut(BS);
   loop {
      SystemTask();
      if (GetNextEvent(everyEvent, &ev))
         switch (ev.what) {
            case mouseDown:
					switch (FindWindow(ev.where,&win)) {
						case inSysWindow:
							SystemClick(&ev,win);
							break;
						case inMenuBar:
							MenuSelect(ev.where);
							break;
						case inDrag:
                     r = qd.screenBits.bounds;
                     InsetRect(&r,4,4);
							DragWindow(win, ev.where, &r);
							break;
						case inGoAway:
							if (win==console && TrackGoAway(win,ev.where))
								Quit(nilSym);
							break;
					}
               break;
            case keyDown:
            case autoKey:
               ttyOut(' ');
               ttyOut(BS);
               return ev.message & charCodeMask;
            case updateEvt:
               if (ev.message == console)
                  drawConsole();
               break;
         }
   }
}

void deLocate(adr1,adr2)
pico *adr1, *adr2;
{
	register pico x;
	register heap *h;
	register long offs;

   do {
      if (isNum(x = *adr1)) {
         if (num(x) & 1)
            *adr1 = boxSubr(unBoxSubr(x) - *(number*)CurrentA5);
      }
      else {
			h = heaps;
			offs = 0;
			while (x < h->cells  ||  x >= h->cells+CELLS) {
				offs += CELLS*sizeof(cell);
				h = h->next;
			}
         *adr1 = (pico)(num(x) - num(h->cells) + offs);
		}
   } while (++adr1 < adr2);
}

void reLocate(adr1,adr2)
pico *adr1, *adr2;
{
	register pico x;
	register heap *h;

   do {
      if (isNum(x = *adr1)) {
         if (num(x) & 1)
            *adr1 = boxSubr(unBoxSubr(x) + *(number*)CurrentA5);
      }
      else {
			h = heaps;
			while (num(x) >= CELLS*sizeof(cell)) {
				x = (pico)(num(x) - CELLS*sizeof(cell));
				h = h->next;
			}
         *adr1 = (pico)(num(x) + num(h->cells));
		}
   } while (++adr1 < adr2);
}

number libSystem(s)
register uchar *s;
{
	register char *p;
	Str255 buf;

	if (*s) {
		buf[0] = 1;
		buf[1] = '\0';
		p = buf+2;
		do {
			*p++ = *s++;
			++buf[0];
		} while (*s);
   	OpenDeskAcc(buf);
	}
	return 0;
}
