/* macList.c
 * 03nov92abu
 */

#include "pico.h"
#include "mac.h"
#include <Lists.h>

/* Prototypes */
static pascal integer hitCell(Ptr,Ptr,integer,integer);
static pico HitCell(pico);
static pico CellText(pico);
static pico pLNew(pico);
static pico pLDispose(pico);
static pico pLGetCell(pico);
static pico pLSetCell(pico);
static pico pLGetSelect(pico);
static pico pLSetSelect(pico);
static pico pLClick(pico);
static pico pLUpdate(pico);
static pico pLActivate(pico);

symInit listSyms[] = {
   {"hitCell",    HitCell},
   {"cellText",   CellText},
   {"LNew",       pLNew},
   {"LDispose",   pLDispose},
   {"LGetCell",   pLGetCell},
   {"LSetCell",   pLSetCell},
   {"LGetSelect", pLGetSelect},
   {"LSetSelect", pLSetSelect},
   {"LClick",     pLClick},
   {"LUpdate",    pLUpdate},
   {"LActivate",  pLActivate},
   NULL
};

pascal integer hitCell(aPtr,bPtr,aLen,bLen)
register Ptr aPtr,bPtr;
integer aLen,bLen;
{
   if (bLen > aLen)
      return 1;
   while (--bLen >= 0) {
      if (IUMagIDString(aPtr,bPtr,1,1))
         return 1;
      ++aPtr;
      ++bPtr;
   }
   return 0;
}

pico HitCell(x)
pico x;
{
   Str255 text;
   ListHandle lHandle;
   Cell theCell, newCell;

   lHandle = (ListHandle)nextNum(&x);
   theCell.h = theCell.v = 0;
   newCell.h = -1;
   while (LGetSelect(YES, &theCell, lHandle))
      LSetSelect(NO, newCell = theCell, lHandle);
   x = EVAL1(x);
   if (isNum(x)) {
      if (newCell.h >= 0) {
         theCell = newCell;
         switch (unBox(x)) {
            case 'L': /* Left */
               if (newCell.h > 0)
                  theCell.h = newCell.h-1;
               break;
            case 'U': /* Up */
               if (newCell.v > 0)
                  theCell.v = newCell.v-1;
               break;
            case 'R': /* Right */
               if (LNextCell(YES,NO,&newCell,lHandle))
                  theCell.h = newCell.h;
               break;
            case 'D': /* Down */
               if (LNextCell(NO,YES,&newCell,lHandle))
                  theCell.v = newCell.v;
               break;
            case 'N': /* Next */
               if (LNextCell(YES,YES,&newCell,lHandle))
                  theCell.v = newCell.v;
               break;
         }
         LSetSelect(YES, theCell, lHandle);
         LAutoScroll(lHandle);
         return tSym;
      }
   }
   else if (isCell(x)) {
      bufCntString(x, text);
      theCell.h = theCell.v = 0;
      if (LSearch(text+1, (integer)text[0],
                     (SearchProcPtr)hitCell, &theCell, lHandle)) {
         LSetSelect(YES, theCell, lHandle);
         LAutoScroll(lHandle);
         return tSym;
      }
   }
   return nilSym;
}

pico CellText(x)
pico x;
{
   Cell theCell;
   ListHandle lHandle;
   integer dataLen;
   Str255 text;

   lHandle = (ListHandle)nextNum(&x);
   theCell.h = (integer)nextNum(&x);
   theCell.v = (integer)nextNum(&x);
   if (isCell(x)) {
      bufCntString(EVAL1(x), text);
      LSetCell(text+1, (integer)text[0], theCell, lHandle);
   }
   dataLen = 255;
   LGetCell(text, &dataLen, theCell, lHandle);
   return unBufCntString(dataLen, text);
}

pico pLNew(x)
pico x;
{
   Rect rView, dataBounds;
   Point cSize;
   integer theProc;
   WindowPtr theWindow;
   bool drawIt, hasGrow, scrollHoriz;

   nextQdRect(&x, &rView);
   nextQdRect(&x, &dataBounds);
   nextQdPoint(&x, &cSize);
   theProc = (integer)nextNum(&x);
   theWindow = (WindowPtr)nextNum(&x);
   drawIt = nextBool(&x);
   hasGrow = nextBool(&x);
   scrollHoriz = nextBool(&x);
   return chkPtr(LNew(&rView, &dataBounds, cSize, theProc, theWindow,
                      drawIt, hasGrow, scrollHoriz, nextBool(&x) ) );
}

pico pLDispose(x)
pico x;
{
   LDispose((ListHandle)nextNum(&x));
   return tSym;
}

pico pLGetCell(x)
pico x;
{
   Ptr dataPtr;
   integer dataLen;
   Cell theCell;

   dataPtr = (Ptr)nextNum(&x);
   dataLen = (integer)nextNum(&x);
   nextQdPoint(&x,&theCell);
   LGetCell(dataPtr, &dataLen, theCell, (ListHandle)nextNum(&x));
   return boxNum(dataLen);
}

pico pLSetCell(x)
pico x;
{
   Ptr dataPtr;
   integer dataLen;
   Cell theCell;

   dataPtr = (Ptr)nextNum(&x);
   dataLen = (integer)nextNum(&x);
   nextQdPoint(&x,&theCell);
   LSetCell(dataPtr, dataLen, theCell, (ListHandle)nextNum(&x));
   return tSym;
}

pico pLGetSelect(x)
pico x;
{
   bool next;
   Cell theCell;

   next = nextBool(&x);
   nextQdPoint(&x,&theCell);
   if (LGetSelect(next, &theCell, (ListHandle)nextNum(&x)))
      return boxQdPoint(theCell);
   return nilSym;
}

pico pLSetSelect(x)
pico x;
{
   bool setIt;
   Cell theCell;

   setIt = nextBool(&x);
   nextQdPoint(&x,&theCell);
   LSetSelect(setIt, theCell, (ListHandle)nextNum(&x));
   return tSym;
}

pico pLClick(x)
pico x;
{
   Point pt;
   integer modifiers;

   nextQdPoint(&x,&pt);
   modifiers = (integer)nextNum(&x);
   return boxBool(LClick(pt, modifiers, (ListHandle)nextNum(&x)));
}

pico pLUpdate(x)
pico x;
{
   RgnHandle theRgn;

   theRgn = (RgnHandle)nextNum(&x);
   LUpdate(theRgn, (ListHandle)nextNum(&x));
   return tSym;
}

pico pLActivate(x)
pico x;
{
   bool act;

   act = nextBool(&x);
   LActivate(act, (ListHandle)nextNum(&x));
   return tSym;
}
