/* macPrim.c
 * 25dec92abu
 */

#pragma segment macPrim

#include "pico.h"
#include "graf.h"
#include "mac.h"

typedef struct {
   char *pfName;
   short param;
   char LC[2];
   long extBlockLen;
   short fFlags;
   long launchFlags;
} LaunchStruct;

extern integer binVol;
pascal OSErr LaunchIt(LaunchStruct*) = {0x205F, 0xA9F2, 0x3E80};

/* Prototypes */
static pico pStack(pico);
static pico AccPoint(pico);
static pico AccRect(pico);
static pico AccPixel(pico);
static pico pGetVol(pico);
static pico pSetVol(pico);
static pico pDialog(pico);
static pico dItem(pico);
static pico dEdit(pico);
static pico BoldItem(pico);
static pico InEdit(pico);
static pico pPutFile(pico);
static pico pGetFile(pico);
static pico VolBytes(pico);
static pico ChDir(pico);
static pico pLaunch(pico);
static pico pFType(pico);
static pico Able(pico);
static pico DoMenu(pico);
static pico PuSel(pico);
static pico DoKey(pico);
static pico InPort(pico);
static pico InView(pico);
static pico LocalClip(pico);
static pico LocalLock(pico);
static pico LocalPort(pico);
static pico LocalVol(pico);
static pico Pustel(pico);
static pico GetSelText(pico);
static pico Console(pico);
#if PXMD
static pico pXcmd(pico);
#endif

symInit macSyms[] = {
   {"stack",      pStack},
   {"point",      AccPoint},
   {"rect",       AccRect},
   {"pixel",      AccPixel},
   {"GetVol",     pGetVol},
   {"SetVol",     pSetVol},
   {"dialog",     pDialog},
   {"d-item",     dItem},
   {"d-edit",     dEdit},
   {"boldItem",   BoldItem},
   {"inEdit",     InEdit},
   {"putFile",    pPutFile},
   {"getFile",    pGetFile},
   {"volBytes",   VolBytes},
   {"chDir",      ChDir},
   {"launch",     pLaunch},
   {"fType",      pFType},
   {"able",       Able},
   {"doMenu",     DoMenu},
   {"puSel",      PuSel},
   {"doKey",      DoKey},
   {"inPort",     InPort},
   {"inView",     InView},
   {"localClip",  LocalClip},
   {"localLock",  LocalLock},
   {"localPort",  LocalPort},
   {"localVol",   LocalVol},
   {"pustel",     Pustel},
   {"getSelText", GetSelText},
   {"console",    Console},
#if PXMD
   {"xcmd",       pXcmd},
#endif
   NULL
};

/* Prototypes */
pico menuCmd(pico,long);


long nextPLong(p)
register pico *p;
{
	register pico x;
	register long retVal = 0;
	register int c;

	x = EVAL1(*p);
	*p = cdr(*p);
	while (isCell(x)) {
		c = (int)unBox(car(x));
		if (c >= 0)
			retVal  =  retVal << 8  |  c & 0xFF;
		else do
			retVal  =  retVal << 8  |  ' ';
		while (++c);
		x = cdr(x);
	}
	return retVal;
}

pico bufPLong(n)
long n;
{
	return
		newCell(boxNum(n >> 24 & 0xFF),
			newCell(boxNum(n >> 16 & 0xFF),
				newCell(boxNum(n >> 8 & 0xFF),
					newCell(boxNum(n & 0xFF), nilSym) ) ) );
}

pico pStack(x)
register pico x;
{
	x = EVAL1(x);
	NEEDNUM(x);
	SetApplLimit(*(Ptr*)CurStackBase - unBox(x)*1024);
	if (MemError())
		return nilSym;
	MaxApplZone();
	return tSym;
}

void macString(s,buf)
register uchar *s;
StringPtr buf;
{
   register StringPtr p = buf+1;

   buf[0] = 0;
   while (*s) {
      *p++ = *s++;
      ++buf[0];
   }
}

void cString(p,s)
register StringPtr p;
register uchar *s;
{
   register int cnt;

   cnt = *p++;
   while (--cnt >= 0)
      *s++ = *p++;
   *s = '\0';
}

void unBoxQdPoint(x,pt)
register pico x;
register Point *pt;
{
   needPoint(x);
   pt->h = unBox(car(x));
   pt->v = unBox(cdr(x));
}

void nextQdPoint(p,pt)
register pico *p;
register Point *pt;
{
   unBoxQdPoint(EVAL1(*p),pt);
   *p = cdr(*p);
}

pico boxQdRect(r)
register Rect *r;
{
   return newCell2(boxNum(r->left), boxNum(r->top),
                  boxNum(r->right), boxNum(r->bottom));
}

void unBoxQdRect(x,r)
register pico x;
register Rect *r;
{
   register pico y;

   needRect(x);
   y = car(x);
   x = cdr(x);
   r->left = (integer)unBox(car(y));
   r->top = (integer)unBox(cdr(y));
   r->right = (integer)unBox(car(x));
   r->bottom = (integer)unBox(cdr(x));
}

void nextQdRect(p,r)
register pico *p;
Rect *r;
{
   unBoxQdRect(EVAL1(*p),r);
   *p = cdr(*p);
}

pico AccPoint(x)
pico x;
{
   register Point *adr;

   adr = (Point*)EVAL1(x);
   NEEDNUM(adr);
   adr = (Point*)unBox(adr);
   if (isNil(x = EVAL1((cdr(x)))))
      return newCell(boxNum(adr->h), boxNum(adr->v));
   unBoxQdPoint(x,(Point*)adr);
   return x;
}

pico AccRect(x)
pico x;
{
   register Rect *adr;

   adr = (Rect*)EVAL1(x);
   NEEDNUM(adr);
   adr = (Rect*)unBox(adr);
   if (isNil(x = EVAL1((cdr(x)))))
      return boxQdRect(adr);
   unBoxQdRect(x,(Rect*)adr);
   return x;
}

pico AccPixel(x)
pico x;
{
   integer h,v;
   RGBColor cPix;

   h = (integer)nextNum(&x);
   v = (integer)nextNum(&x);
   if (!isCell(x)) {
      GetCPixel(h,v,&cPix);
      return boxColor(cPix.red, cPix.green, cPix.blue);
   }
   x = EVAL1(x);
   unBoxColor(x,&cPix);
   SetCPixel(h,v,&cPix);
   return x;
}

pico pGetVol()
{
   Str255 volName;
   integer vRefNum;

   if (GetVol(volName, &vRefNum))
      return nilSym;
   return boxNum(vRefNum);
}

pico pSetVol(x)
register pico x;
{
   Str255 volName;

   if (isNum(x = EVAL1(x)))
      return SetVol((StringPtr)NULL, unBox(x))? nilSym:tSym;
   bufCntString(x, volName);
   return boxNum(SetVol(volName, 0));
}

pico pDialog(x)
pico x;
{
   register pico y;
   number winTyp;
   Str255 title;
   bool goAwayFlag;
   register Handle items;
   register int offs;
   integer h,v;
   Rect rct;

   winTyp = nextNum(&x);
   nextCntString(&x,title);
   goAwayFlag = nextBool(&x);
   nextQdPoint(&x,(Point*)&rct); /* TopLeft */
   h = (integer)nextNum(&x); /* Size-h */
   v = (integer)nextNum(&x); /* Size-v */
   if (rct.left == 0  &&  rct.top == 0) {
      rct.left = (qd.screenBits.bounds.right - h) / 2;
      rct.top = *(integer*)MBarHeight + (qd.screenBits.bounds.bottom - v) / 3;
	}
   rct.right = rct.left + h;
   rct.bottom = rct.top + v;
   items = NewHandle(offs = 2);
   *(integer*)*items = -1;
   while (isCell(x)) {
      SetHandleSize(items, offs+256);
      *(long*)(*items+offs) = NULL;
      *(*items+offs+12) = (uchar)nextNum(&x); /* Type */
      nextQdPoint(&x, (Point*)(*items+offs+4)); /* TopLeft */
      *(integer*)(*items+offs+10) =
            *(integer*)(*items+offs+6)+(integer)nextNum(&x); /* Size-h */
      *(integer*)(*items+offs+8) =
            *(integer*)(*items+offs+4)+(integer)nextNum(&x); /* Size-v */
      y = EVAL1(x);
      x = cdr(x);
      if (isNum(y)) {
         *(*items+offs+13) = 2;
         *(integer*)(*items+offs+14) = (integer)unBox(y);
         offs += 14+2;
      }
      else {
         bufCntString(y, *items+offs+13);
         offs += 14 + (*(*items+offs+13)+1 & ~1);
      }
      ++*(integer*)*items;
   }
   SetHandleSize(items,offs);
   return chkPtr((winTyp & 0x10000)?
         NewCDialog(NULL, &rct, title, YES, (integer)winTyp,
               (WindowPtr)-1, goAwayFlag, NULL, items ) :
         NewDialog(NULL, &rct, title, YES, (integer)winTyp,
               (WindowPtr)-1, goAwayFlag, NULL, items ) );
}

pico dItem(x)
pico x;
{
   DialogPtr theDialog;
   integer itemType;
   Handle item;
   Rect box;

   theDialog = (DialogPtr)nextNum(&x);
   GetDItem(theDialog, (integer)nextNum(&x), &itemType, &item, &box);
   return chkPtr(item);
}

pico dEdit(x)
pico x;
{
   return boxNum(((DialogPeek)nextNum(&x))->editField + 1);
}

pico BoldItem(x)
pico x;
{
   DialogPtr theDialog;
   integer itemType;
   Handle item;
   Rect box;
   GrafPtr savePort;

   theDialog = (DialogPtr)nextNum(&x);
   GetDItem(theDialog, (integer)nextNum(&x), &itemType, &item, &box);
   GetPort(&savePort);
   SetPort((GrafPtr)theDialog);
   PenNormal();
   PenSize(3,3);
   InsetRect(&box, -4, -4);
   FrameRoundRect(&box, 16, 16);
   PenNormal();
   SetPort(savePort);
   return chkPtr(item);
}

pico InEdit(x)
pico x;
{
   DialogPeek dlg;
   GrafPtr savePort;
   integer i, itemType;
   Handle item;
   Rect box;
   Point pt;

   dlg = (DialogPeek)nextNum(&x);
   GetPort(&savePort);
   SetPort((WindowPtr)dlg);
   GetMouse(&pt);
   for (i = 1; i <= *(integer*)*dlg->items + 1; ++i) {
      GetDItem((DialogPtr)dlg, i, &itemType, &item, &box);
      if (itemType==editText && PtInRect(pt,&box)) {
         SetPort(savePort);
         return tSym;
      }
   }
   SetPort(savePort);
   return nilSym;
}

pico pPutFile(x)
pico x;
{
   Str255 prompt;
   Str255 origName;
   Point where;
   SFReply reply;

   where.h = 100;
   where.v = 100;
   bufCntString(EVAL1(x),prompt);
   x = cdr(x);
   bufCntString(EVAL1(x),origName);
   SFPutFile(where, (Ptr)prompt, (Ptr)origName,
                     (DlgHookProcPtr)NULL, &reply);
   if (!reply.good  ||  SetVol((StringPtr)NULL, reply.vRefNum))
      return nilSym;
   return unBufCntString(reply.fName[0],reply.fName+1);
}

pico pGetFile(x)
pico x;
{
   integer types;
   Point where;
   SFReply reply;
   SFTypeList typeList;

   where.h = 100;
   where.v = 100;
   types = 0;
   while (isCell(x) && types < 4)
      typeList[types++] = nextPLong(&x);
   if (!types)
      types = -1;
   SFGetFile(where, (Ptr)NULL,
            (FileFilterProcPtr)NULL, types, &typeList,
                           (DlgHookProcPtr)NULL, &reply );
   if (!reply.good  ||  SetVol((StringPtr)NULL, reply.vRefNum))
      return nilSym;
   return unBufCntString(reply.fName[0],reply.fName+1);
}

pico VolBytes(x)
pico x;
{
   VolumeParam vp;

   vp.ioCompletion = NULL;
   vp.ioNamePtr = NULL;
   vp.ioVRefNum = nextNum(&x);
   vp.ioVolIndex = -1;
   PBGetVInfo((ParmBlkPtr)&vp,NO);
   return boxNum(vp.ioVFrBlk * vp.ioVAlBlkSiz);
}

pico ChDir(x)
pico x;
{
   Str255 path;
   CInfoPBRec crec;
   WDPBRec wrec;

   wrec.ioNamePtr = crec.dirInfo.ioNamePtr = nextCntString(&x,path);
   wrec.ioVRefNum = crec.dirInfo.ioVRefNum = binVol;
   crec.dirInfo.ioCompletion = NULL;
   crec.dirInfo.ioFDirIndex = 0;
   crec.dirInfo.ioDrDirID = 0;
   if (PBGetCatInfo(&crec,NO))
      return nilSym;
   wrec.ioCompletion = NULL;
   wrec.ioWDProcID = 'ERIK';
   wrec.ioWDDirID = crec.dirInfo.ioDrDirID;
   if (PBOpenWD(&wrec,NO)  ||
            SetVol((StringPtr)NULL, wrec.ioVRefNum))
      return nilSym;
   return boxNum(wrec.ioVRefNum);
}

pico pLaunch(x)
pico x;
{
   Str255 fName;
   bool subLaunch;
   HFileInfo myPB;
   LaunchStruct myLaunch;

   myPB.ioNamePtr = nextCntString(&x,fName);
   subLaunch = nextBool(&x);
   myPB.ioVRefNum = 0;
   myPB.ioFDirIndex = 0;
   myPB.ioDirID = 0;
   if (PBGetCatInfo((CInfoPBPtr)&myPB,NO))
      return nilSym;
   myLaunch.pfName = fName;
   myLaunch.param = 0;
   myLaunch.LC[0] = 'L';
   myLaunch.LC[1] = 'C';
   myLaunch.extBlockLen = 6;
   myLaunch.fFlags = myPB.ioFlFndrInfo.fdFlags;
   myLaunch.launchFlags = subLaunch? 0xC0000000 : 0x00000000;
   return boxBool(LaunchIt(&myLaunch) >= 0);
}

pico pFType(x)
pico x;
{
   Str255 fName;
   FInfo info;
	cell c1;

   bufCntString(EVAL1(x), fName);
   if (GetFInfo(fName,0,&info) != noErr)
      return nilSym;
   push(bufPLong(info.fdType),c1);
   if (isCell(x = cdr(x))) {
      info.fdType = (OSType)nextPLong(&x);
      SetFInfo(fName,0,&info);
   }
   return pop(c1);
}

/* Menu management */
pico Able(x)
register pico x;
{
   register pico y, z;
   register int cnt;
   MenuHandle mh;
	cell c1;

   push(x = EVAL1(x),c1);
   while (isCell(x)) {
      mh = (MenuHandle)unBox(car(y = cdr(car(x))));
      cnt = 0;
      while (isCell(y = cdr(y))) {
         ++cnt;
         z = car(y);
         if (isNil(EVAL(car(z))))
            DisableItem(mh,cnt);
         else
            EnableItem(mh,cnt);
         if (isCell(z = cdr(z)))
            CheckItem(mh, cnt, !isNil(EVAL(cdr(z))));
      }
      x = cdr(x);
   }
   drop(c1);
   return tSym;
}

pico menuCmd(x,n)
register pico x;
register long n;
{
   register integer id, it, i;
   MenuHandle mh;
   Str255 buf;

   if (!(id = n>>16 & 0xFFFF))
      return nilSym;
   it = n & 0xFFFF;
   x = cdr(cdr(cdr(x))); /* Skip handle, symbol- and expr-lists */
   i = id;
   while (--i > 0)
      x = cdr(x);
   x = cdr(car(x));
   mh = (MenuHandle)unBox(car(x));
   x = cdr(x);
   i = it;
   while (--i > 0)
      x = cdr(x);
   if (id == 1  &&  isNil(x)) {
      GetItem(mh,it,buf);
      x = boxNum(OpenDeskAcc(buf));
   }
   else {
      x = cdr(car(x));
      x = EVAL1(x);
   }
   HiliteMenu(0);
   return x;
}

pico DoMenu(x)
register pico x;
{
   Point pt;
	cell c1;

   push(EVAL1(x),c1);
   x = cdr(x);
   unBoxQdPoint(EVAL1(x), &pt);
   x = menuCmd(pop(c1), MenuSelect(pt));
   HiliteMenu(0);
   return x;
}

pico PuSel(x)
pico x;
{
   MenuHandle mh;
   integer h, v;
	cell c1;

   push(EVAL1(x),c1);
   x = cdr(x);
   mh = (MenuHandle)nextNum(&x);
   h = (integer)nextNum(&x);
   v = (integer)nextNum(&x);
   return menuCmd(pop(c1), PopUpMenuSelect(mh, v, h, (integer)nextNum(&x)));
}

pico DoKey(x)
register pico x;
{
	cell c1;

   push(EVAL1(x),c1);
   x = EVAL1(cdr(x));
   NEEDNUM(x);
   x = menuCmd(pop(c1), MenuKey((char)unBox(x)));
   HiliteMenu(0);
   return x;
}

/* Test if point is in window's portRect */
pico InPort(x)
pico x;
{
   point pt;

   nextPoint(&x,&pt);
   return boxBool(
      pt.h >= qd.thePort->portRect.left &&
      pt.h < qd.thePort->portRect.right &&
      pt.v >= qd.thePort->portRect.top &&
      pt.v < qd.thePort->portRect.bottom );
}

/* Test if point is in window's viewRect */
pico InView(x)
pico x;
{
   point pt;
   Rect r;

   nextPoint(&x,&pt);
   r = qd.thePort->portRect;
   r.right -= 15;
   r.bottom -= 15;
   return boxBool(
      pt.h >= r.left &&
      pt.h < r.right &&
      pt.v >= r.top &&
      pt.v < r.bottom );
}

pico LocalClip(x)
register pico x;
{
   register pico y;
   RgnHandle rgn;
   Rect r;

   y = EVAL1(x);
   x = cdr(x);
   GetClip(rgn = NewRgn());
   if (isNum(y))
      SetClip((RgnHandle)unBox(y));
   else if (isRect(y)) {
      unBoxQdRect(y,&r);
      ClipRect(&r);
   }
   else
      errObj(y, "Rect or Rgn expected");
   x = evalBody(x);
   SetClip(rgn);
   DisposeRgn(rgn);
   return x;
}

pico LocalLock(x)
pico x;
{
   Handle h;

   HLock(h = (Handle)nextNum(&x));
   x = evalBody(x);
   HUnlock(h);
   return x;
}

pico LocalPort(x)
pico x;
{
   GrafPtr savePort;

   GetPort(&savePort);
   SetPort((GrafPtr)nextNum(&x));
   val(portSym) = boxNum(qd.thePort);
   x = evalBody(x);
   SetPort(savePort);
   val(portSym) = boxNum(qd.thePort);
   return x;
}

pico LocalVol(x)
pico x;
{
   Str255 volName;
   integer vRefNum;

   GetVol(volName, &vRefNum);
   SetVol((StringPtr)NULL, (integer)nextNum(&x));
   x = evalBody(x);
   SetVol((StringPtr)NULL, vRefNum);
   return x;
}

pico Pustel(x)
pico x;
{
   register short c;
   register Ptr p;
   register number h,v,dh,dv;
   register unsigned long bytes;
   CGrafPtr port;
   PixMapPtr pm;
   Point pt;
   rect rct;
   RGBColor col;
   Byte mode;

   nextColor(&x,&col);                  /* Pustel color */
   c = Color2Index(&col) & 0xFF;
   port = (CGrafPtr)nextNum(&x);
   nextRect(&x,&rct);
   dv = dh = nextNum(&x);
   if (isCell(x))
      dv = nextNum(&x);
   pm = *port->portPixMap;
   if (pm->pixelSize != 8)
      return nilSym;
   p = pm->baseAddr;
   bytes = pm->rowBytes & 0x1FFF;
   HideCursor();
   for (v = rct.top; v < rct.bottom; v += dv) {
      for (h = rct.left; h < rct.right; h += dh) {
         pt.h = h;
         pt.v = v;
         if (PtInRgn(pt,port->visRgn)) {
            LocalToGlobal(&pt);
            mode = true32b, SwapMMUMode(&mode);
            *(p + (long)pt.h + (long)pt.v*bytes) = c;
            SwapMMUMode(&mode);
         }
      }
   }
   ShowCursor();
   return tSym;
}

pico GetSelText(x)
pico x;
{
   register TEHandle t;
   register number s;
   Handle h;
	cell c1;

   t = (TEHandle)nextNum(&x);
   s = (*t)->selStart;
   if (PtrToHand(*(*t)->hText + s, &h, (*t)->selEnd-s) != noErr)
      return nilSym;
   push(dynHandle(h),c1);
   tos(c1) = newCell(tos(c1), dynHandle((Handle)GetStylScrap(t)));
   return pop(c1);
}

pico Console(x)
pico x;
{
   EventRecord *ev;

	if (console) {
   	ev = (EventRecord*)nextNum(&x);
   	if (ev->what==activateEvt && ev->message==console)
      	return boxNum(activateEvt);
   	if (ev->what==updateEvt && ev->message==console) {
      	drawConsole();
      	return boxNum(updateEvt);
		}
   }
   return nilSym;
}

/* Arguments and results */
pico boxColor(red,green,blue)
integer red,green,blue;
{
   return packNum(red >> 6, green >> 6, blue >> 6);
}

void unBoxColor(x,col)
register pico x;
register RGBColor *col;
{
   register number n;

   NEEDNUM(x);
   n = unBox(x);
   col->red   = n >> 14 & 0xFFC0;
   col->green = n >>  4 & 0xFFC0;
   col->blue  = n <<  6 & 0xFFC0;
}

void nextColor(p,col)
register pico *p;
RGBColor *col;
{
   unBoxColor(EVAL1(*p),col);
   *p = cdr(*p);
}

pico boxStyle(s)
register TextStyle *s;
{
   return
      newCell(boxNum(s->tsFont),
         newCell(boxNum(s->tsFace),
            newCell(boxNum(s->tsSize),
               newCell(boxColor(s->tsColor.red,s->tsColor.green,s->tsColor.blue),
                  nilSym ) ) ) );
}

void unBoxStyle(x,s)
register pico x;
register TextStyle *s;
{
   NEEDLIST(x);
   s->tsFont = (integer)unBox(car(x));
   x = cdr(x);
   s->tsFace = (Style)unBox(car(x));
   x = cdr(x);
   s->tsSize = (integer)unBox(car(x));
   x = cdr(x);
   unBoxColor(car(x),(RGBColor*)&s->tsColor); /* Cast: Stupid TextEdit.h of LSC */
}

void nextStyle(p,s)
register pico *p;
TextStyle *s;
{
   unBoxStyle(EVAL1(*p),s);
   *p = cdr(*p);
}

pico checkMemErr()
{
   return  MemError() ? nilSym : tSym;
}

pico checkResErr()
{
   return  ResError() ? nilSym : tSym;
}

StringPtr bufCntString(x,p)
register pico x;
register StringPtr p;
{
   register StringPtr s;
   register int c;

   *p = 0;
   s = p + 1;
   while (isCell(x)) {
      c = unBox(car(x));
      if (c >= 0) {
         *s++ = c;
         if (++*p == 255)
            return p;
      }
      else do {
         *s++ = ' ';
         if (++*p == 255)
            return p;
      }
      while (++c);
      x = cdr(x);
   }
   return p;
}

StringPtr nextCntString(p,buf)
register pico *p;
StringPtr buf;
{
   pico x;

   x = EVAL1(*p);
   *p = cdr(*p);
   NEEDSTRING(x);
   return bufCntString(x,buf);
}

ProcPtr nextProc(p, def, foo)
register pico *p, *def;
ProcPtr foo;
{
   register pico x;

   x = EVAL1(*p);
   *p = cdr(*p);
   if (isNum(x))
      return (ProcPtr)unBox(x);
   if (!isCell(x))
      return (ProcPtr)NULL;
   *def = x;
   return foo;
}

pico fetchB(x,offs)
pico x;
integer offs;
{
   register char *adr;
   char old;

   adr = (char*)nextNum(&x) + offs;
   if (isNil(x = EVAL1(x)))
      return boxNum(*adr);
   NEEDNUM(x);
   old = *adr;
   *adr = unBox(x);
   return boxNum(old);
}

pico fetchW(x,offs)
pico x;
int offs;
{
   register integer *adr;
   integer old;

   adr = (integer*)((char*)nextNum(&x) + offs);
   if (isNil(x = EVAL1(x)))
      return boxNum(*adr);
   NEEDNUM(x);
   old = *adr;
   *adr = unBox(x);
   return boxNum(old);
}

pico fetchL(x,offs)
pico x;
int offs;
{
   register long *adr;
   long old;

   adr = (long*)((char*)nextNum(&x) + offs);
   if (isNil(x = EVAL1(x)))
      return boxNum(*adr);
   NEEDNUM(x);
   old = *adr;
   *adr = unBox(x);
   return boxNum(old);
}

pico fetchPoint(x,offs)
pico x;
int offs;
{
   register Point *adr;
   Point old;
   point pt;

   adr = (Point*)((char*)nextNum(&x) + offs);
   if (!isCell(x))
      return newCell(boxNum(adr->h), boxNum(adr->v));
   old = *adr;
   nextPoint(&x,&pt);
   adr->h = pt.h, adr->v = pt.v;
   return newCell(boxNum(old.h), boxNum(old.v));
}

pico fetchRect(x,offs)
pico x;
int offs;
{
   register Rect *adr;
   Rect old;

   adr = (Rect*)((char*)nextNum(&x) + offs);
   if (!isCell(x))
      return boxQdRect(adr);
   old = *adr;
   nextQdRect(&x,adr);
   return boxQdRect(&old);
}

#if PXMD
/* Interface to HyperCard XCMDs and XFCNs */

static XCmdBlock blk;

static pascal void hyperEntry(void);
pascal void hyperEntry()
{
   register Ptr p, q;
   long n;

   switch(blk.request) {
      case xreqZeroToPas:
         for (p = (Ptr)blk.inArgs[0], q = (Ptr)blk.inArgs[1]; *q++ = *p++;)
            ;
         CtoPstr((Ptr)blk.inArgs[1]);
         break;
      case xreqStrToNum:
         StringToNum((StringPtr)blk.inArgs[0], &n);
         blk.outArgs[0] = n;
         break;
      case xreqScanToReturn:
         p = *(Handle)(blk.inArgs[0]);
         while (*p)
            p++;
         *(Handle)(blk.inArgs[0]) = p;
         break;
      case xreqScanToZero:
         p = *(Handle)(blk.inArgs[0]);
         while (*p && *p!=CR)
            p++;
         *(Handle)(blk.inArgs[0]) = p;
         break;
      default:
         errObj(boxNum(blk.request), "Request from XCMD");
   }
}

pico pXcmd(x)
pico x;
{
   Str255 str;
   Handle h,theCode;
   register int nh;

   nextCntString(&x,str);
   if (!(theCode = GetNamedResource('XCMD',str)))
      err("Can't XCMD");
   nh = 0;
   while (isCell(x)) {
      nextCntString(&x,str);
      PtrToHand(str,&h, (long)pstrlen(str));
      HLock(h);
      PtoCstr(*h);
      HUnlock(h);
      blk.params[nh++] = h;
   }
   blk.paramCount = nh;
   blk.entryPoint = hyperEntry;
   HLock(theCode);
/* ((pascal void (*)())*theCode)(&blk); */
   asm {
      pea blk
      movea.l theCode,a0
      move.l (a0),a0
      jsr (a0)
   }
   HUnlock(theCode);
   while (--nh >= 0)
      DisposHandle((Handle)blk.params[nh]);
   return chkPtr(blk.returnValue);
}
#endif
