/* macPrint.c
 * 30jan93abu
 */

#include "pico.h"
#include "mac.h"
#include <Printing.h>

/* Prototypes */
static pico prRsl(pico);
static pico pPaper(pico);
static pico pPrOpen(void);
static pico pPrClose(void);
static pico pPrintDefault(pico);
static pico pPrStlDialog(pico);
static pico pPrJobDialog(pico);
static pico pPrOpenDoc(pico);
static pico pPrOpenPage(pico);
static pico pPrClosePage(pico);
static pico pPrCloseDoc(pico);
static pico mayPrPic(pico);
static pico pPrError(void);

symInit printSyms[] = {
   {"prRsl",          prRsl},
   {"paper",          pPaper},
   {"PrOpen",         pPrOpen},
   {"PrClose",        pPrClose},
   {"PrintDefault",   pPrintDefault},
   {"PrStlDialog",    pPrStlDialog},
   {"PrJobDialog",    pPrJobDialog},
   {"PrOpenDoc",      pPrOpenDoc},
   {"PrOpenPage",     pPrOpenPage},
   {"PrClosePage",    pPrClosePage},
   {"PrCloseDoc",     pPrCloseDoc},
   {"mayPrPic",       mayPrPic},
   {"PrError",        pPrError},
   NULL
};


pico prRsl(x)
pico x;
{
	if (isCell(x)) {
		TSetRslBlk blk;

		blk.iOpCode = setRslOp;
		blk.hPrint = (THPrint)nextNum(&x);
		blk.iXRsl = nextNum(&x);
		blk.iYRsl = nextNum(&x);
		PrGeneral((Ptr)&blk);
		return boxBool(!(PrError() || blk.iError));
	}
	else {
		TGetRslBlk blk;
		int i;
		cell c;

		blk.iOpCode = getRslDataOp;
		PrGeneral((Ptr)&blk);
		if (PrError() || blk.iError)
			return nilSym;
		i = blk.iRslRecCnt;
		push(nilSym,c);
		while (--i >= 0)
			tos(c) = newCell(
							newCell(boxNum(blk.rgRslRec[i].iXRsl),
										boxNum(blk.rgRslRec[i].iYRsl) ),
							tos(c) );
		return pop(c);
	}
}

pico pPaper(x)
pico x;
{
   register THPrint h;
   integer dh,dv;
   cell c;

   h = (THPrint)nextNum(&x);
   dh = -(*h)->rPaper.left;
   dv = -(*h)->rPaper.top;
   push(
      newCell2(
         boxNum(dh),
         boxNum(dv),
         boxNum((*h)->prInfo.rPage.right + dh),
         boxNum((*h)->prInfo.rPage.bottom + dv) ),
      c );
   tos(c) =
      newCell(
         tos(c),
         newCell(
            boxNum((*h)->rPaper.right + dh),
            boxNum((*h)->rPaper.bottom + dv) ) );
   return pop(c);
}

pico pPrOpen()
{
   PrOpen();
   return boxBool(!PrError());
}

pico pPrClose()
{
   PrClose();
   return boxBool(!PrError());
}

pico pPrintDefault(x)
pico x;
{
   PrintDefault((THPrint)nextNum(&x));
   return boxBool(!PrError());
}

pico pPrStlDialog(x)
pico x;
{
   return boxBool(PrStlDialog((THPrint)nextNum(&x)));
}

pico pPrJobDialog(x)
pico x;
{
   return boxBool(PrJobDialog((THPrint)nextNum(&x)));
}

pico pPrOpenDoc(x)
pico x;
{
   THPrint hPrint;
   TPPrPort pPrPort;

   hPrint = (THPrint)nextNum(&x);
   pPrPort = (TPPrPort)nextPtr(&x);
   return chkPtr(PrOpenDoc(hPrint, pPrPort, (Ptr)nextPtr(&x)));
}

pico pPrOpenPage(x)
pico x;
{
   TPPrPort pPrPort;

   pPrPort = (TPPrPort)nextNum(&x);
   PrOpenPage(pPrPort, (TPRect)nextPtr(&x));
   return boxBool(!PrError());
}

pico pPrClosePage(x)
pico x;
{
   PrClosePage((TPPrPort)nextNum(&x));
   return boxBool(!PrError());
}

pico pPrCloseDoc(x)
pico x;
{
   PrCloseDoc((TPPrPort)nextNum(&x));
   return boxBool(!PrError());
}

pico mayPrPic(x)
pico x;
{
   THPrint hPrint;
   TPrStatus prStat;

   hPrint = (THPrint)nextNum(&x);
   if ((*hPrint)->prJob.bJDocLoop == bSpoolLoop) {
      PrPicFile(hPrint, (TPPrPort)NULL, (Ptr)NULL, (Ptr)NULL, &prStat);
      return tSym;
   }
   return nilSym;
}

pico pPrError()
{
   integer err;

   err = PrError();
   return err? boxNum(err):nilSym;
}
