/* macQd.c
 * 21dec92abu
 */

#include "pico.h"
#include "mac.h"

pico portSym;

/* Prototypes */
static pico qdPortMap(pico);
static pico qdPortRect(pico);
static pico qdVisRgn(pico);
static pico qdClipRgn(pico);
static pico qdRgnBBox(pico);
static pico pSetPort(pico);
static pico pGetPort(pico);
static pico pSetPortBits(pico);
static pico pSetOrigin(pico);
static pico pSetClip(pico);
static pico pGetClip(pico);
static pico pClipRect(pico);
static pico pBackPat(pico);
static pico pSetCursor(pico);
static pico pHideCursor(void);
static pico pShowCursor(void);
static pico pObscureCursor(void);
static pico pHidePen(void);
static pico pShowPen(void);
static pico pGetPen(void);
static pico pPenSize(pico);
static pico pPenMode(pico);
static pico pPenPat(pico);
static pico pPenNormal(void);
static pico pMoveTo(pico);
static pico pMove(pico);
static pico pLineTo(pico);
static pico pLine(pico);
static pico pTextFont(pico);
static pico pTextFace(pico);
static pico pTextSize(pico);
static pico pDrawChar(pico);
static pico pDrawString(pico);
static pico pCharWidth(pico);
static pico pStringWidth(pico);
static pico pGetFontInfo(void);
static pico pForeColor(pico);
static pico pBackColor(pico);
static pico pPtToAngle(pico);
static pico pFrameRect(pico);
static pico pPaintRect(pico);
static pico pEraseRect(pico);
static pico pInvertRect(pico);
static pico pFrameOval(pico);
static pico pPaintOval(pico);
static pico pEraseOval(pico);
static pico pFrameRoundRect(pico);
static pico pPaintRoundRect(pico);
static pico pEraseRoundRect(pico);
static pico pFrameArc(pico);
static pico pPaintArc(pico);
static pico pEraseArc(pico);
static pico pNewRgn(void);
static pico pOpenRgn(void);
static pico pCloseRgn(pico);
static pico pDisposeRgn(pico);
static pico pCopyRgn(pico);
static pico pSetEmptyRgn(pico);
static pico pSetRectRgn(pico);
static pico pRectRgn(pico);
static pico pOffsetRgn(pico);
static pico pInsetRgn(pico);
static pico pSectRgn(pico);
static pico pUnionRgn(pico);
static pico pDiffRgn(pico);
static pico pXorRgn(pico);
static pico pPtInRgn(pico);
static pico pRectInRgn(pico);
static pico pEqualRgn(pico);
static pico pEmptyRgn(pico);
static pico pFrameRgn(pico);
static pico pPaintRgn(pico);
static pico pEraseRgn(pico);
static pico pInvertRgn(pico);
static pico pScrollRect(pico);
static pico pCopyBits(pico);
static pico pOpenPicture(pico);
static pico pClosePicture(void);
static pico pDrawPicture(pico);
static pico pKillPicture(pico);
static pico pOpenPoly(void);
static pico pClosePoly(void);
static pico pKillPoly(pico);
static pico pFramePoly(pico);
static pico pPaintPoly(pico);
static pico pLocalToGlobal(pico);
static pico pGlobalToLocal(pico);

symInit qdSyms[] = {
   {"portMap",         qdPortMap},
   {"portRect",        qdPortRect},
   {"visRgn",          qdVisRgn},
   {"clipRgn",         qdClipRgn},
   {"rgnBBox",         qdRgnBBox},
   {"SetPort",         pSetPort},
   {"GetPort",         pGetPort},
   {"SetPortBits",     pSetPortBits},
   {"SetOrigin",       pSetOrigin},
   {"SetClip",         pSetClip},
   {"GetClip",         pGetClip},
   {"ClipRect",        pClipRect},
   {"BackPat",         pBackPat},
   {"SetCursor",       pSetCursor},
   {"HideCursor",      pHideCursor},
   {"ShowCursor",      pShowCursor},
   {"ObscureCursor",   pObscureCursor},
   {"HidePen",         pHidePen},
   {"ShowPen",         pShowPen},
   {"GetPen",          pGetPen},
   {"PenSize",         pPenSize},
   {"PenMode",         pPenMode},
   {"PenPat",          pPenPat},
   {"PenNormal",       pPenNormal},
   {"MoveTo",          pMoveTo},
   {"Move",            pMove},
   {"LineTo",          pLineTo},
   {"Line",            pLine},
   {"TextFont",        pTextFont},
   {"TextFace",        pTextFace},
   {"TextSize",        pTextSize},
   {"DrawChar",        pDrawChar},
   {"DrawString",      pDrawString},
   {"CharWidth",       pCharWidth},
   {"StringWidth",     pStringWidth},
   {"GetFontInfo",     pGetFontInfo},
   {"ForeColor",       pForeColor},
   {"BackColor",       pBackColor},
   {"PtToAngle",       pPtToAngle},
   {"FrameRect",       pFrameRect},
   {"PaintRect",       pPaintRect},
   {"EraseRect",       pEraseRect},
   {"InvertRect",      pInvertRect},
   {"FrameOval",       pFrameOval},
   {"PaintOval",       pPaintOval},
   {"EraseOval",       pEraseOval},
   {"FrameRoundRect",  pFrameRoundRect},
   {"PaintRoundRect",  pPaintRoundRect},
   {"EraseRoundRect",  pEraseRoundRect},
   {"FrameArc",        pFrameArc},
   {"PaintArc",        pPaintArc},
   {"EraseArc",        pEraseArc},
   {"NewRgn",          pNewRgn},
   {"OpenRgn",         pOpenRgn},
   {"CloseRgn",        pCloseRgn},
   {"DisposeRgn",      pDisposeRgn},
   {"CopyRgn",         pCopyRgn},
   {"SetEmptyRgn",     pSetEmptyRgn},
   {"SetRectRgn",      pSetRectRgn},
   {"RectRgn",         pRectRgn},
   {"OffsetRgn",       pOffsetRgn},
   {"InsetRgn",        pInsetRgn},
   {"SectRgn",         pSectRgn},
   {"UnionRgn",        pUnionRgn},
   {"DiffRgn",         pDiffRgn},
   {"XorRgn",          pXorRgn},
   {"PtInRgn",         pPtInRgn},
   {"RectInRgn",       pRectInRgn},
   {"EqualRgn",        pEqualRgn},
   {"EmptyRgn",        pEmptyRgn},
   {"FrameRgn",        pFrameRgn},
   {"PaintRgn",        pPaintRgn},
   {"EraseRgn",        pEraseRgn},
   {"InvertRgn",       pInvertRgn},
   {"ScrollRect",      pScrollRect},
   {"CopyBits",        pCopyBits},
   {"OpenPicture",     pOpenPicture},
   {"ClosePicture",    pClosePicture},
   {"DrawPicture",     pDrawPicture},
   {"KillPicture",     pKillPicture},
   {"OpenPoly",        pOpenPoly},
   {"ClosePoly",       pClosePoly},
   {"KillPoly",        pKillPoly},
   {"FramePoly",       pFramePoly},
   {"PaintPoly",       pPaintPoly},
   {"LocalToGlobal",   pLocalToGlobal},
   {"GlobalToLocal",   pGlobalToLocal},
   NULL
};

/* Return pointer to port's BitMap or PixelMap */
pico qdPortMap(x)
pico x;
{
   register long *p;

   p = (long*)(unBox(EVAL1(x)) + 2);
   if (*(p+1) < 0) {
      return boxNum(*(long*)*p);
   }
   return boxNum(p);
}

pico qdPortRect(x)
pico x;
{
   return fetchRect(x,16);
}

pico qdVisRgn(x)
pico x;
{
   return fetchL(x,24);
}

pico qdClipRgn(x)
pico x;
{
   return fetchL(x,28);
}

pico qdRgnBBox(x)
pico x;
{
   return boxQdRect(&(*((RgnHandle)nextNum(&x)))->rgnBBox);
}

pico pSetPort(x)
pico x;
{
   SetPort((GrafPtr)nextNum(&x));
   return val(portSym) = boxNum(qd.thePort);
}

pico pGetPort(x)
pico x;
{
   GrafPtr port;

   GetPort(&port);
   return val(nextVar(&x)) = boxNum(port);
}

pico pSetPortBits(x)
pico x;
{
   SetPortBits((BitMap*)nextPtr(&x));
   return tSym;
}

pico pSetOrigin(x)
pico x;
{
   integer h;

   h = (integer)nextNum(&x);
   SetOrigin(h, (integer)nextNum(&x));
   return tSym;
}

pico pSetClip(x)
pico x;
{
   SetClip((RgnHandle)nextNum(&x));
   return tSym;
}

pico pGetClip(x)
pico x;
{
   GetClip((RgnHandle)nextNum(&x));
   return tSym;
}

pico pClipRect(x)
pico x;
{
   Rect rect;

   nextQdRect(&x,&rect);
   ClipRect(&rect);
   return tSym;
}

pico pBackPat(x)
pico x;
{
   BackPat((Pattern*)nextNum(&x));
   return tSym;
}

pico pSetCursor(x)
pico x;
{
   SetCursor((CursPtr)nextNum(&x));
   return tSym;
}

pico pHideCursor()
{
   HideCursor();
   return tSym;
}

pico pShowCursor()
{
   ShowCursor();
   return tSym;
}

pico pObscureCursor()
{
   ObscureCursor();
   return tSym;
}

pico pHidePen()
{
   HidePen();
   return tSym;
}

pico pShowPen()
{
   ShowPen();
   return tSym;
}

pico pGetPen()
{
   Point pt;

   GetPen(&pt);
   return newCell(boxNum(pt.h),boxNum(pt.v));
}

pico pPenSize(x)
pico x;
{
   integer width;

   width = (integer)nextNum(&x);
   PenSize(width, (integer)nextNum(&x));
   return tSym;
}

pico pPenMode(x)
pico x;
{
   PenMode((integer)nextNum(&x));
   return tSym;
}

pico pPenPat(x)
pico x;
{
   PenPat((Pattern*)nextNum(&x));
   return tSym;
}

pico pPenNormal()
{
   PenNormal();
   return tSym;
}


pico pMoveTo(x)
pico x;
{
   integer h;

   h = (integer)nextNum(&x);
   MoveTo(h, (integer)nextNum(&x));
   return tSym;
}

pico pMove(x)
pico x;
{
   integer dh;

   dh = (integer)nextNum(&x);
   Move(dh, (integer)nextNum(&x));
   return tSym;
}

pico pLineTo(x)
pico x;
{
   integer h;

   h = (integer)nextNum(&x);
   LineTo(h, (integer)nextNum(&x));
   return tSym;
}

pico pLine(x)
pico x;
{
   integer dh;

   dh = (integer)nextNum(&x);
   Line(dh, (integer)nextNum(&x));
   return tSym;
}

pico pTextFont(x)
register pico x;
{
   x = EVAL1(x);
   NEEDNUM(x);
   TextFont((integer)unBox(x));
   return x;
}

pico pTextFace(x)
register pico x;
{
   x = EVAL1(x);
   NEEDNUM(x);
   TextFace((Style)unBox(x));
   return x;
}

pico pTextSize(x)
register pico x;
{
   x = EVAL1(x);
   NEEDNUM(x);
   TextSize((integer)unBox(x));
   return x;
}

pico pDrawChar(x)
pico x;
{
   DrawChar((char)nextNum(&x));
   return tSym;
}

pico pDrawString(x)
pico x;
{
   Str255 s;

   nextCntString(&x,s);
   DrawString(s);
   return tSym;
}

pico pCharWidth(x)
pico x;
{
   return boxNum(CharWidth((char)nextNum(&x)));
}

pico pStringWidth(x)
pico x;
{
   Str255 s;

   nextCntString(&x,s);
   return boxNum(StringWidth(s));
}

pico pGetFontInfo()
{
   FontInfo f;
	cell c1;

   GetFontInfo(&f);
   push(newCell(boxNum(f.leading),nilSym),c1);
   tos(c1) = newCell(boxNum(f.widMax),tos(c1));
   tos(c1) = newCell(boxNum(f.descent),tos(c1));
   return newCell(boxNum(f.ascent),pop(c1));
}

pico pForeColor(x)
pico x;
{
   ForeColor((long)nextNum(&x));
   return tSym;
}

pico pBackColor(x)
pico x;
{
   BackColor((long)nextNum(&x));
   return tSym;
}

pico pPtToAngle(x)
pico x;
{
   Rect r;
   Point pt;
   integer angle;

   nextQdRect(&x,&r);
   nextQdPoint(&x,&pt);
   PtToAngle(&r,pt,&angle);
   return boxNum(angle);
}

pico pFrameRect(x)
pico x;
{
   Rect rect;

   nextQdRect(&x,&rect);
   FrameRect(&rect);
   return tSym;
}

pico pPaintRect(x)
pico x;
{
   Rect rect;

   nextQdRect(&x,&rect);
   PaintRect(&rect);
   return tSym;
}

pico pEraseRect(x)
pico x;
{
   Rect rect;

   nextQdRect(&x,&rect);
   EraseRect(&rect);
   return tSym;
}

pico pInvertRect(x)
pico x;
{
   Rect rect;

   nextQdRect(&x,&rect);
   InvertRect(&rect);
   return tSym;
}

pico pFrameOval(x)
pico x;
{
   Rect rect;

   nextQdRect(&x,&rect);
   FrameOval(&rect);
   return tSym;
}

pico pPaintOval(x)
pico x;
{
   Rect rect;

   nextQdRect(&x,&rect);
   PaintOval(&rect);
   return tSym;
}

pico pEraseOval(x)
pico x;
{
   Rect rect;

   nextQdRect(&x,&rect);
   EraseOval(&rect);
   return tSym;
}

pico pFrameRoundRect(x)
pico x;
{
   Rect rect;
   integer ovalWidth;

   nextQdRect(&x,&rect);
   ovalWidth = (integer)nextNum(&x);
   FrameRoundRect(&rect,ovalWidth, (integer)nextNum(&x));
   return tSym;
}

pico pPaintRoundRect(x)
pico x;
{
   Rect rect;
   integer ovalWidth;

   nextQdRect(&x,&rect);
   ovalWidth = (integer)nextNum(&x);
   PaintRoundRect(&rect,ovalWidth, (integer)nextNum(&x));
   return tSym;
}

pico pEraseRoundRect(x)
pico x;
{
   Rect rect;
   integer ovalWidth;

   nextQdRect(&x,&rect);
   ovalWidth = (integer)nextNum(&x);
   EraseRoundRect(&rect,ovalWidth, (integer)nextNum(&x));
   return tSym;
}

pico pFrameArc(x)
pico x;
{
   Rect rect;
   integer startAngle;

   nextQdRect(&x,&rect);
   startAngle = (integer)nextNum(&x);
   FrameArc(&rect,startAngle, (integer)nextNum(&x));
   return tSym;
}

pico pPaintArc(x)
pico x;
{
   Rect rect;
   integer startAngle;

   nextQdRect(&x,&rect);
   startAngle = (integer)nextNum(&x);
   PaintArc(&rect,startAngle, (integer)nextNum(&x));
   return tSym;
}

pico pEraseArc(x)
pico x;
{
   Rect rect;
   integer startAngle;

   nextQdRect(&x,&rect);
   startAngle = (integer)nextNum(&x);
   EraseArc(&rect,startAngle, (integer)nextNum(&x));
   return tSym;
}

pico pNewRgn()
{
   return chkPtr(NewRgn());
}

pico pOpenRgn()
{
   OpenRgn();
   return tSym;
}

pico pCloseRgn(x)
pico x;
{
   RgnHandle rgn;

   CloseRgn(rgn = (RgnHandle)nextNum(&x));
   return boxNum(rgn);
}

pico pDisposeRgn(x)
pico x;
{
   DisposeRgn((RgnHandle)nextNum(&x));
   return tSym;
}

pico pCopyRgn(x)
pico x;
{
   RgnHandle srcRgn, dstRgn;

   srcRgn = (RgnHandle)nextNum(&x);
   CopyRgn(srcRgn, dstRgn = (RgnHandle)nextNum(&x));
   return chkPtr(dstRgn);
}

pico pSetEmptyRgn(x)
pico x;
{
   SetEmptyRgn((RgnHandle)nextNum(&x));
   return tSym;
}

pico pSetRectRgn(x)
pico x;
{
   RgnHandle rgn;
   integer left, top, right;

   rgn = (RgnHandle)nextNum(&x);
   left = (integer)nextNum(&x);
   top = (integer)nextNum(&x);
   right = (integer)nextNum(&x);
   SetRectRgn(rgn, left, top, right, (integer)nextNum(&x));
   return tSym;
}

pico pRectRgn(x)
pico x;
{
   RgnHandle rgn;
   Rect r;

   rgn = (RgnHandle)nextNum(&x);
   nextQdRect(&x,&r);
   RectRgn(rgn, &r);
   return tSym;
}

pico pOffsetRgn(x)
pico x;
{
   RgnHandle rgn;
   integer dh;

   rgn = (RgnHandle)nextNum(&x);
   dh = (integer)nextNum(&x);
   OffsetRgn(rgn, dh, (integer)nextNum(&x));
   return tSym;
}

pico pInsetRgn(x)
pico x;
{
   RgnHandle rgn;
   integer dh;

   rgn = (RgnHandle)nextNum(&x);
   dh = (integer)nextNum(&x);
   InsetRgn(rgn, dh, (integer)nextNum(&x));
   return tSym;
}

pico pSectRgn(x)
pico x;
{
   RgnHandle srcRgnA, srcRgnB;

   srcRgnA = (RgnHandle)nextNum(&x);
   srcRgnB = (RgnHandle)nextNum(&x);
   SectRgn(srcRgnA, srcRgnB, (RgnHandle)nextNum(&x));
   return tSym;
}

pico pUnionRgn(x)
pico x;
{
   RgnHandle srcRgnA, srcRgnB;

   srcRgnA = (RgnHandle)nextNum(&x);
   srcRgnB = (RgnHandle)nextNum(&x);
   UnionRgn(srcRgnA, srcRgnB, (RgnHandle)nextNum(&x));
   return tSym;
}

pico pDiffRgn(x)
pico x;
{
   RgnHandle srcRgnA, srcRgnB;

   srcRgnA = (RgnHandle)nextNum(&x);
   srcRgnB = (RgnHandle)nextNum(&x);
   DiffRgn(srcRgnA, srcRgnB, (RgnHandle)nextNum(&x));
   return tSym;
}

pico pXorRgn(x)
pico x;
{
   RgnHandle srcRgnA, srcRgnB;

   srcRgnA = (RgnHandle)nextNum(&x);
   srcRgnB = (RgnHandle)nextNum(&x);
   XorRgn(srcRgnA, srcRgnB, (RgnHandle)nextNum(&x));
   return tSym;
}

pico pPtInRgn(x)
pico x;
{
   Point pt;

   nextQdPoint(&x,&pt);
   return boxBool(PtInRgn(pt, (RgnHandle)nextNum(&x)));
}

pico pRectInRgn(x)
pico x;
{
   Rect r;

   nextQdRect(&x,&r);
   return boxBool(RectInRgn(&r, (RgnHandle)nextNum(&x)));
}

pico pEqualRgn(x)
pico x;
{
   RgnHandle rgn;

   rgn = (RgnHandle)nextNum(&x);
   return boxBool(EqualRgn(rgn, (RgnHandle)nextNum(&x)));
}

pico pEmptyRgn(x)
pico x;
{
   return boxBool(EmptyRgn((RgnHandle)nextNum(&x)));
}

pico pFrameRgn(x)
pico x;
{
   FrameRgn((RgnHandle)nextNum(&x));
   return tSym;
}

pico pPaintRgn(x)
pico x;
{
   PaintRgn((RgnHandle)nextNum(&x));
   return tSym;
}

pico pEraseRgn(x)
pico x;
{
   EraseRgn((RgnHandle)nextNum(&x));
   return tSym;
}

pico pInvertRgn(x)
pico x;
{
   InvertRgn((RgnHandle)nextNum(&x));
   return tSym;
}

pico pScrollRect(x)
pico x;
{
   Rect r;
   integer dh, dv;

   nextQdRect(&x,&r);
   dh = (integer)nextNum(&x);
   dv = (integer)nextNum(&x);
   ScrollRect(&r, dh, dv, (RgnHandle)nextNum(&x));
   return tSym;
}

pico pCopyBits(x)
pico x;
{
   BitMap *srcBits, *dstBits;
   Rect srcRect, dstRect;
   integer mode;

   srcBits = (BitMap*)nextNum(&x);
   dstBits = (BitMap*)nextNum(&x);
   nextQdRect(&x,&srcRect);
   nextQdRect(&x,&dstRect);
   mode = (integer)nextNum(&x);
   CopyBits(srcBits,dstBits,&srcRect,&dstRect,mode,(RgnHandle)nextPtr(&x));
   return tSym;
}


pico pOpenPicture(x)
pico x;
{
   Rect picFrame;

   nextQdRect(&x,&picFrame);
   return chkPtr(OpenPicture(&picFrame));
}

pico pClosePicture()
{
   ClosePicture();
   return tSym;
}

pico pDrawPicture(x)
pico x;
{
   PicHandle myPicture;
   Rect dstRect;

   myPicture = (PicHandle)nextNum(&x);
   nextQdRect(&x,&dstRect);
   DrawPicture(myPicture, &dstRect);
   return tSym;
}

pico pKillPicture(x)
pico x;
{
   KillPicture((PicHandle)nextNum(&x));
   return tSym;
}

pico pOpenPoly()
{
   return chkPtr(OpenPoly());
}

pico pClosePoly()
{
   ClosePoly();
   return tSym;
}

pico pKillPoly(x)
pico x;
{
   KillPoly((PolyHandle)nextNum(&x));
   return tSym;
}

pico pFramePoly(x)
pico x;
{
   FramePoly((PolyHandle)nextNum(&x));
   return tSym;
}

pico pPaintPoly(x)
pico x;
{
   PaintPoly((PolyHandle)nextNum(&x));
   return tSym;
}

pico pLocalToGlobal(x)
register pico x;
{
   Point pt;

   x = EVAL1(x);
   unBoxQdPoint(x,&pt);
   LocalToGlobal(&pt);
   car(x) = boxNum(pt.h);
   cdr(x) = boxNum(pt.v);
   return x;
}

pico pGlobalToLocal(x)
register pico x;
{
   Point pt;

   x = EVAL1(x);
   unBoxQdPoint(x,&pt);
   GlobalToLocal(&pt);
   car(x) = boxNum(pt.h);
   cdr(x) = boxNum(pt.v);
   return x;
}
