/* macSound.c
 * 07may93abu
 */

#include "pico.h"
#include "mac.h"
#include <Sound.h>
#include <SoundInput.h>
#include <Retrace.h>

/* Prototypes */
static pascal void doSoundTask(void);
static pico Sound(pico);
static pico SoundRate(pico);
static pico pStartSound(pico);
static pico pStopSound(void);
static pico pSoundDone(void);
static pico pGetSoundVol(void);
static pico pSetSoundVol(pico);
static pico pSndPlay(pico);
static pico pSndRecord(pico);

symInit soundSyms[] = {
   {"sound",         Sound},
   {"soundRate",     SoundRate},
   {"StartSound",    pStartSound},
   {"StopSound",     pStopSound},
   {"SoundDone",     pSoundDone},
   {"GetSoundVol",   pGetSoundVol},
   {"SetSoundVol",   pSetSoundVol},
   {"SndPlay",       pSndPlay},
   {"SndRecord",     pSndRecord},
   NULL
};

static VBLTask soundTask = {NULL, vType, (ProcPtr)doSoundTask, 1, 0};
static IOParam soundBlock;
static long ioActLimit;

pascal void doSoundTask()
{
   SetUpA5();
   if (soundBlock.ioActCount >= ioActLimit)
      soundBlock.ioActCount = 0;
   soundTask.vblCount = 1;
   RestoreA5();
}

pico Sound(x)
register pico x;
{
   if (isNil(x = EVAL1(x))) {
      VRemove((QElemPtr)&soundTask);
      StopSound();
   }
   else {
      NEEDNUM(x);
      soundBlock.ioBuffer = (Ptr)unBox(x);
      soundBlock.ioCompletion = NULL; /* No completion routine */
      soundBlock.ioRefNum = -4; /* Sound Driver's refNum */
      soundBlock.ioReqCount = GetPtrSize(soundBlock.ioBuffer);
      PBWrite((ParmBlkPtr)&soundBlock,YES); /* Write asynchronously */
      ioActLimit = soundBlock.ioReqCount - 6 -
               370 * ((FFSynthPtr)(soundBlock.ioBuffer))->count / 0x10000;
      VInstall((QElemPtr)&soundTask);
   }
   return tSym;
}

pico SoundRate(x)
pico x;
{
   x = EVAL1(x);
   NEEDNUM(x);
   soundBlock.ioActCount = 0;
   if ((((FFSynthPtr)(soundBlock.ioBuffer))->count = unBox(x)) <= 177)
      ioActLimit = 0;
   else
      ioActLimit = soundBlock.ioReqCount - 6 -
               370 * ((FFSynthPtr)(soundBlock.ioBuffer))->count / 0x10000;
   return x;
}

pico pStartSound(x)
pico x;
{
   Ptr synthRec;
   long numBytes;

   synthRec = (Ptr)nextNum(&x);
   numBytes = nextNum(&x);
   StartSound(synthRec, numBytes, (SndCompletionProcPtr)nextPtr(&x));
   return tSym;
}

pico pStopSound()
{
   StopSound();
   return tSym;
}

pico pSoundDone()
{
   return boxBool(SoundDone());
}

pico pGetSoundVol()
{
   integer level;

   GetSoundVol(&level);
   return boxNum(level);
}

pico pSetSoundVol(x)
pico x;
{
   SetSoundVol((integer)nextNum(&x));
   return tSym;
}

pico pSndPlay(x)
pico x;
{
	SndChannelPtr chan;
	Handle sndHdl;

	chan = (SndChannelPtr)nextPtr(&x);
	sndHdl = (Handle)nextNum(&x);
	return boxNum(SndPlay(chan, sndHdl, nextBool(&x)));
}

pico sndProcDef;

pascal bool sndProc(theDialog, theEvent, itemHit)
DialogPtr theDialog;
EventRecord *theEvent;
integer *itemHit;
{
   return isNil(apply3(sndProcDef,
            boxNum(theDialog), boxNum(theEvent), boxNum(itemHit))) ?
         NO : YES;
}

pico pSndRecord(x)
pico x;
{
	ModalFilterProcPtr filterProc;
	Point corner;
	OSType quality;
	Handle sndHandle;

	filterProc = (ModalFilterProcPtr)nextProc(&x, &sndProcDef, (ProcPtr)sndProc);
   nextQdPoint(&x,&corner);
	quality = nextPLong(&x);
	sndHandle = nextPtr(&x);
   if (SndRecord(filterProc, corner, quality, &sndHandle) != noErr)
		return nilSym;
   return chkPtr(sndHandle);
}
