/* macText.c
 * 03nov92abu
 */

#include "pico.h"
#include "mac.h"

/* Prototypes */
static pascal bool clikProc(void);

static pico txLine(pico);
static pico teDestRect(pico);
static pico teViewRect(pico);
static pico teLineHeight(pico);
static pico teSelStart(pico);
static pico teSelEnd(pico);
static pico teClikLoop(pico);
static pico teTeLength(pico);
static pico teHText(pico);
static pico teNLines(pico);
static pico pTEStylNew(pico);
static pico pTEDispose(pico);
static pico pTESetText(pico);
static pico pTEGetText(pico);
static pico pTEIdle(pico);
static pico pTEClick(pico);
static pico pTESetSelect(pico);
static pico pTEActivate(pico);
static pico pTEDeactivate(pico);
static pico pTEKey(pico);
static pico pTECut(pico);
static pico pTECopy(pico);
static pico pTEStylPaste(pico);
static pico pTEDelete(pico);
static pico pTEStylInsert(pico);
static pico pTESetJust(pico);
static pico pTEUpdate(pico);
static pico pTEScroll(pico);
static pico pTECalText(pico);
static pico pTESelView(pico);
static pico pTEPinScroll(pico);
static pico pTEAutoView(pico);
static pico pSetStylHandle(pico);
static pico pGetStylHandle(pico);
static pico pGetStylScrap(pico);
static pico pTEGetOffset(pico);
static pico pTEGetPoint(pico);
static pico pTEGetHeight(pico);
static pico pTEGetStyle(pico);
static pico pTESetStyle(pico);
static pico pTEReplaceStyle(pico);

symInit textSyms[] = {
   {"txLine",           txLine},
   {"te-destRect",      teDestRect},
   {"te-viewRect",      teViewRect},
   {"te-lineHeight",    teLineHeight},
   {"te-selStart",      teSelStart},
   {"te-selEnd",        teSelEnd},
   {"te-clikLoop",      teClikLoop},
   {"te-teLength",      teTeLength},
   {"te-hText",         teHText},
   {"te-nLines",        teNLines},
   {"TENew",            pTEStylNew},
   {"TEDispose",        pTEDispose},
   {"TESetText",        pTESetText},
   {"TEGetText",        pTEGetText},
   {"TEIdle",           pTEIdle},
   {"TEClick",          pTEClick},
   {"TESetSelect",      pTESetSelect},
   {"TEActivate",       pTEActivate},
   {"TEDeactivate",     pTEDeactivate},
   {"TEKey",            pTEKey},
   {"TECut",            pTECut},
   {"TECopy",           pTECopy},
   {"TEPaste",          pTEStylPaste},
   {"TEDelete",         pTEDelete},
   {"TEInsert",         pTEStylInsert},
   {"TESetJust",        pTESetJust},
   {"TEUpdate",         pTEUpdate},
   {"TEScroll",         pTEScroll},
   {"TECalText",        pTECalText},
   {"TESelView",        pTESelView},
   {"TEPinScroll",      pTEPinScroll},
   {"TEAutoView",       pTEAutoView},
   {"SetStylHandle",    pSetStylHandle},
   {"GetStylHandle",    pGetStylHandle},
   {"GetStylScrap",     pGetStylScrap},
   {"TEGetOffset",      pTEGetOffset},
   {"TEGetPoint",       pTEGetPoint},
   {"TEGetHeight",      pTEGetHeight},
   {"TEGetStyle",       pTEGetStyle},
   {"TESetStyle",       pTESetStyle},
   {"TEReplaceStyle",   pTEReplaceStyle},
   NULL
};

pico txLine(x)
pico x;
{
   TEHandle teH;
   register number n,i;
   register Ptr p;

   teH = (TEHandle)nextNum(&x);
   n = nextNum(&x);
   i = 0;
   HLock((Handle)TEGetText(teH));
   p = (Ptr)*TEGetText(teH);
   while (--n >= 0)
      if (*p++ == '\r')
         ++i;
   HUnlock((Handle)TEGetText(teH));
   return boxNum(i);
}

pico teDestRect(x)
pico x;
{
   return fetchRect(x,0);
}

pico teViewRect(x)
pico x;
{
   return fetchRect(x,8);
}

pico teLineHeight(x)
pico x;
{
   return fetchW(x,24);
}

pico teSelStart(x)
pico x;
{
   return fetchW(x,32);
}

pico teSelEnd(x)
pico x;
{
   return fetchW(x,34);
}

pico clikDef;

pascal bool clikProc()
{
   return isNil(apply1(clikDef,nilSym)) ?  NO : YES;
}

pico teClikLoop(x)
pico x;
{
   TERec *te;

   te = (TERec*)nextNum(&x);
   te->clikLoop = (ClikLoopProcPtr)nextProc(&x, &clikDef, (ProcPtr)clikProc);
   return clikDef;
}

pico teTeLength(x)
pico x;
{
   return fetchW(x,60);
}

pico teHText(x)
pico x;
{
   return fetchL(x,62);
}

pico teNLines(x)
pico x;
{
   return fetchW(x,94);
}

pico pTEStylNew(x)
pico x;
{
   Rect destRect,viewRect;

   nextQdRect(&x,&destRect);
   nextQdRect(&x,&viewRect);
   return chkPtr(TEStylNew(&destRect,&viewRect));
}

pico pTEDispose(x)
pico x;
{
   TEDispose((TEHandle)nextNum(&x));
   return tSym;
}

pico pTESetText(x)
pico x;
{
   Ptr text;
   long length;

   text = (Ptr)nextNum(&x);
   length = nextNum(&x);
   TESetText(text,length,(TEHandle)nextNum(&x));
   return tSym;
}

pico pTEGetText(x)
pico x;
{
   return chkPtr(TEGetText((TEHandle)nextNum(&x)));
}

pico pTEIdle(x)
pico x;
{
   TEIdle((TEHandle)nextNum(&x));
   return tSym;
}

pico pTEClick(x)
pico x;
{
   Point pt;
   bool fExtend;

   nextQdPoint(&x,&pt);
   fExtend = nextBool(&x);
   TEClick(pt,fExtend,(TEHandle)nextNum(&x));
   return tSym;
}

pico pTESetSelect(x)
pico x;
{
   long selStart,selEnd;

   selStart = nextNum(&x);
   selEnd = nextNum(&x);
   TESetSelect(selStart,selEnd,(TEHandle)nextNum(&x));
   return tSym;
}

pico pTEActivate(x)
pico x;
{
   TEActivate((TEHandle)nextNum(&x));
   return tSym;
}

pico pTEDeactivate(x)
pico x;
{
   TEDeactivate((TEHandle)nextNum(&x));
   return tSym;
}

pico pTEKey(x)
pico x;
{
   char key;

   key = (char)nextNum(&x);
   TEKey(key,(TEHandle)nextNum(&x));
   return tSym;
}

pico pTECut(x)
pico x;
{
   TECut((TEHandle)nextNum(&x));
   return tSym;
}

pico pTECopy(x)
pico x;
{
   TECopy((TEHandle)nextNum(&x));
   return tSym;
}

pico pTEStylPaste(x)
pico x;
{
   TEStylPaste((TEHandle)nextNum(&x));
   return tSym;
}

pico pTEDelete(x)
pico x;
{
   TEDelete((TEHandle)nextNum(&x));
   return tSym;
}

pico pTEStylInsert(x)
pico x;
{
   Ptr text;
   long length;
   StScrpHandle hST;

   text = (Ptr)nextNum(&x);
   length = nextNum(&x);
   hST = (StScrpHandle)nextPtr(&x);
   TEStylInsert(text,length,hST,(TEHandle)nextNum(&x));
   return tSym;
}

pico pTESetJust(x)
pico x;
{
   integer just;

   just = (integer)nextNum(&x);
   TESetJust(just,(TEHandle)nextNum(&x));
   return tSym;
}

pico pTEUpdate(x)
pico x;
{
   Rect rUpdate;

   nextQdRect(&x,&rUpdate);
   TEUpdate(&rUpdate,(TEHandle)nextNum(&x));
   return tSym;
}

pico pTEScroll(x)
pico x;
{
   integer dh,dv;

   dh = (integer)nextNum(&x);
   dv = (integer)nextNum(&x);
   TEScroll(dh,dv,(TEHandle)nextNum(&x));
   return tSym;
}

pico pTECalText(x)
pico x;
{
   TECalText((TEHandle)nextNum(&x));
   return tSym;
}

pico pTESelView(x)
pico x;
{
   TESelView((TEHandle)nextNum(&x));
   return tSym;
}

pico pTEPinScroll(x)
pico x;
{
   integer dh,dv;

   dh = (integer)nextNum(&x);
   dv = (integer)nextNum(&x);
   TEPinScroll(dh,dv,(TEHandle)nextNum(&x));
   return tSym;
}

pico pTEAutoView(x)
pico x;
{
   bool f;

   f = nextBool(&x);
   TEAutoView(f, (TEHandle)nextNum(&x));
   return tSym;
}

pico pSetStylHandle(x)
pico x;
{
   TEStyleHandle h;

   h = (TEStyleHandle)nextNum(&x);
   SetStylHandle(h, (TEHandle)nextNum(&x));
   return tSym;
}

pico pGetStylHandle(x)
pico x;
{
   return chkPtr(GetStylHandle((TEHandle)nextNum(&x)));
}

pico pGetStylScrap(x)
pico x;
{
   return chkPtr(GetStylScrap((TEHandle)nextNum(&x)));
}

pico pTEGetOffset(x)
pico x;
{
   Point pt;

   nextQdPoint(&x,&pt);
   return boxNum(TEGetOffset(pt,(TEHandle)nextNum(&x)));
}

pico pTEGetPoint(x)
pico x;
{
   integer offset;
   Point pt;

   offset = (integer)nextNum(&x);
   pt = TEGetPoint(offset,(TEHandle)nextNum(&x));
   return boxQdPoint(pt);
}

pico pTEGetHeight(x)
pico x;
{
   long endLine,startLine;

   endLine = nextNum(&x);
   startLine = nextNum(&x);
   return boxNum(TEGetHeight(endLine,startLine,(TEHandle)nextNum(&x)));
}

pico pTEGetStyle(x)
pico x;
{
   integer offset;
   TextStyle theStyle;
   integer lineHeight, fontAscent;

   offset = (integer)nextNum(&x);
   TEGetStyle(offset,&theStyle,&lineHeight,&fontAscent,(TEHandle)nextNum(&x));
   return
      newCell(boxNum(lineHeight),
         newCell(boxNum(fontAscent),
            boxStyle(&theStyle) ) );
}

pico pTESetStyle(x)
pico x;
{
   integer mode;
   TextStyle newStyle;
   bool redraw;

   mode = (integer)nextNum(&x);
   nextStyle(&x,&newStyle);
   redraw = nextBool(&x);
   TESetStyle(mode,&newStyle,redraw,(TEHandle)nextNum(&x));
   return tSym;
}

pico pTEReplaceStyle(x)
pico x;
{
   integer mode;
   TextStyle oldStyle,newStyle;
   bool redraw;

   mode = (integer)nextNum(&x);
   nextStyle(&x,&oldStyle);
   nextStyle(&x,&newStyle);
   redraw = nextBool(&x);
   TEReplaceStyle(mode,&oldStyle,&newStyle,redraw,(TEHandle)nextNum(&x));
   return tSym;
}
