/* picoGC.c
 * 22oct93abu
 */

#pragma segment picoGC

#include "pico.h"

typedef struct {
	bits16 ver;
	bits16 cnt;
	pico lim;
} frzHead;

/* Prototypes */
static void adjust(pico*);
static void allFree(void);
static void compact(void);
static pico doShare(pico,pico);
static void freezErr(void);
static long gc(long);
static void mark(pico);
static pico share1(pico);
static pico share1List(pico);

static pico shareX,shareY;
static pico adjLimit;
static heap *adjHeap;


void dynFree(x)
register pico x;
{
   libFree((void*)unBox(x));
}

pico dynamo(foo,x)
register pico foo,x;
{
	cell c1;

   NEEDFUN(foo);
   push(newSym(DYNAMO, newCell(foo,x)), c1);
   if (!avail)
      gc(CELLS);
   x = avail;
   avail = x->link;
   x->data = tos(c1);
   x->link = dynamos;
   dynamos = x;
   return pop(c1);
}

pico Dynamo(x)
register pico x;
{
	cell c1;

   push(EVAL1(x),c1);   /* DisposeFun */
   x = EVAL1(cdr(x));   /* Object */
   return dynamo(pop(c1),x);
}

pico newCell(x,y)
register pico x,y;
{
   register pico p;
	cell c1,c2;

   if (!avail) {
      push(x,c1), push(y,c2);
      gc(CELLS);
      y = tos(c2), x = pop(c1);
   }
   p = avail;
   avail = p->link;
   car(p) = x;
   cdr(p) = y;
   return p;
}

pico newCell2(a,b,c,d)
pico a,b,c,d;
{
	cell c1;

   push(newCell(a,b),c1);
   a = newCell(c,d);
   return newCell(pop(c1), a);
}

/* Share common subexpressions */
pico share1(x)
register pico x;
{
   pico p;

   while (isCell(x)) {
      if (cdr(x)==shareY && car(x)==shareX)
         return x;
      if (p = share1(car(x)))
         return p;
      x = cdr(x);
   }
   return NULL;
}

pico doShare(x,y)
pico x,y;
{
   register pico z,p,ptr;
   register int i;

   shareX = x;
   shareY = y;
   ptr = stkPtr;               /* Search stack */
   while (ptr) {
      if (p = share1(car(ptr)))
         return p;
		ptr = cdr(ptr);
	}
   for (i=0; i<=THREADS; ++i) {   /* Search oblist */
      z = env.threads[i];
      while (isCell(z)) {
         if (p = share1(mkCell(car(z))))
            return p;
         z = cdr(z);
      }
   }
   return newCell(x,y);
}

pico share(x,y)
pico x,y;
{
   if (!isNil(val(shareFlg)))
      return doShare(x,y);
   return newCell(x,y);
}

pico share1List(x)
register pico x;
{
   if (!isCell(x))
      return x;
   return doShare(share1List(car(x)),share1List(cdr(x)));
}

pico shareList(x)
register pico x;
{
   if (!isNil(val(shareFlg)))
      return share1List(x);
   return x;
}

void mark(x)
register pico x;
{
   while (!isNum(x) && isFree(x = cellPtr(x))) {
      *markPtr(x) &= ~1;
      mark(x->data);
      x = x->link;
   }
}

void allFree()
{
   register char *p;
	register heap *h;
   register long n;

	h = heaps;
	do {
		p = markPtr(h->cells);
		n = CELLS;
		do {
			*p |= 1;
			p += 8;
		} while (--n);
	} while (h = h->next);
}

long gc(need)
long need;
{
   register pico *ptr,p,q;
	register heap *h;
   register long i;

   ttyOut('{');
   allFree();
   i = THREADS;                 /* Mark oblist */
   do
      mark(env.threads[i]);
   while (--i >= 0);
   mark(env.run);               /* Mark initial runtime expression */
   mark(applyList);             /* Mark apply list */
   p = stkPtr;                  /* Mark stack */
   while (p) {
      mark(car(p));
		p = cdr(p);
	}
	p = (pico)bindPtr;
	while (p) {
      i = ((bindFrame*)p)->cnt;
      while (--i >= 0)
			mark(((bindFrame*)p)->bnd[i].val);
		p = (pico)((bindFrame*)p)->link;
	}
   ptr = &dynamos;              /* Dispose of dynamos */
   while (p = *ptr) {
      if (isFree(cellPtr(q = clr(car(p))))) {
         mark(q = val(q));
         apply1(car(q),cdr(q));
         *ptr = p->link;
      }
      else {
         *markPtr(p) &= ~1;
         ptr = &p->link;
      }
   }
   ptr = NULL;                  /* Collect free cells */
	i = 0;
	h = heaps;
   p = h->cells + CELLS-1;
   do {
      if (isFree(p)) {
			++i;
         p->link = (pico)ptr;
         ptr = (pico*)p;
      }
   } while (--p > topSym);
	while (h->next) {
   	p = (h=h->next)->cells + CELLS-1;
   	do {
      	if (isFree(p)) {
				++i;
         	p->link = (pico)ptr;
         	ptr = (pico*)p;
      	}
   	} while (--p >= h->cells);
	}
   *markPtr(mkCell(nilSym)+1) &= ~1;
	while (i < need  &&  (h->next = heapAlloc(h))) {
		h = h->next;
      p = h->cells + CELLS-1;
      do {
         p->link = (pico)ptr;
         ptr = (pico*)p;
      } while (--p >= h->cells);
		i += CELLS;
	}
   if (!(avail = (pico)ptr))
      err("Out of cell space");
   keyBreak();
   ttyOut('}');
	return i;
}

pico Gc(x)
register pico x;
{
   register number m,n;

   if (!isCell(x))
   	return boxNum(gc(CELLS));
   x = EVAL1(x);
   NEEDNUM(x);
   m = n = unBox(x);
   x = avail;
   while (x) {
      if (--n == 0)
         return tSym;
      x = x->link;
   }
	return  gc(m) >= m? tSym:nilSym;
}

/* Collect and compact cell Space */
void adjust(p)
register pico *p;
{
   register pico x;
	register heap *h;

   if (!isNum(x = *p)) {
		for (h = heaps; h != adjHeap; h = h->next)
			if (x >= h->cells  &&  x < h->cells+CELLS)
				return;
		if (x >= h->cells  &&  x < adjLimit)
			return;
      *p = isSym(x)? mkSym(tail(x)) : car(x);
	}
}

void compact()
{
   register pico p, q;
	heap *h1, *h2;
   register long n;

   allFree();
   n = THREADS;
   do
      mark(env.threads[n]);
   while (--n >= 0);
   mark(env.run);
   mark(applyList);
   p = mkCell(topSym+1);
	h1 = h2 = heaps;
	while (h2->next)
		h2 = h2->next;
   q = h2->cells+CELLS;
   do {
      while (!isFree(p)) {
			if (++p == h1->cells+CELLS)
				p = (h1=h1->next)->cells;
         if (p == q)
            goto adjPtr;
		}
      do {
			if (q == h2->cells)
				q = (h2=h2->prev)->cells+CELLS;
         if (--q == p)
            goto adjPtr;
      } while (isFree(q));
      *p = *q;
      q->data = p;
		if (++p == h1->cells+CELLS)
			p = (h1=h1->next)->cells;
   } while (p != q);
adjPtr:                       /* Adjust pointers */
   adjLimit = p;
	adjHeap = h1;
   n = THREADS;
   do
      adjust(env.threads+n);
   while (--n >= 0);
   adjust(&env.run);
   loop {
		if (q == h1->cells) {
			if (!(h1 = h1->prev))
				break;
			q = h1->cells+CELLS;
		}
      --q;
      adjust(&q->link);
      adjust(&q->data);
   }
   *markPtr(mkCell(nilSym)+1) &= ~1;
   avail = NULL;               /* Build new avail list */
	while (h2->next)
		h2 = h2->next;
   q = h2->cells+CELLS;
   while (--q != p) {
      q->link = avail;
      avail = q;
		if (q == h2->cells)
			q = (h2=h2->prev)->cells+CELLS;
   }
   q->link = avail;
   avail = q;
}

void freezErr()
{
   err("Freeze error");
}

/* Generate freeze file */
void Freeze(x)
register pico x;
{
   uchar fName[FILENAME];
   int fd;
	register heap *h;
	register long cnt;
   frzHead hd;
   long e;

   bufString(EVAL1(x), fName, (long)FILENAME);
   closeAll();
   val(loadSym) = nilSym;
   if ((fd = libWrOpen(fName,1)) < 0)
      err("Can't create Freeze");
   env.run = cdr(x);
   reset();
   unwind();
   compact();
	cnt = 1; /* Count heaps */
	for (h = heaps; h != adjHeap; h = h->next)
		++cnt;

   /* Write header */
   hd.ver = VERSION;
   hd.cnt = cnt;
	hd.lim = adjLimit;
	deLocate((pico*)&hd.lim, (pico*)&hd.lim+1);
   if (libWrite(fd, (char*)&hd, (long)sizeof(frzHead)) < 0)
      freezErr();

   /* Write environment */
   deLocate(env.threads, &env.run+1);
   e = libWrite(fd, (char*)&env, (long)sizeof(env));
   reLocate(env.threads, &env.run+1);
   if (e < 0)
      freezErr();

   /* Write heaps */
	h = heaps;
	while (--cnt >= 0) {
		deLocate((pico*)h->cells,
				cnt?  (pico*)(h->cells+CELLS) : (pico*)adjLimit );
		e = libWrite(fd, (char*)h->cells, (long)(CELLS*sizeof(cell)));
		reLocate((pico*)h->cells,
				cnt?  (pico*)(h->cells+CELLS) : (pico*)adjLimit );
		if (e < 0)
			freezErr();
		h = h->next;
	}

   libClose(fd);
   longjmp(errRst,-1);
}

bool unFreeze(fd)
int fd;
{
   register pico q;
	register heap *h;
	register long cnt;
   frzHead hd;

   /* Read header */
   if (libRead(fd, (char*)&hd, (long)sizeof(frzHead)) < 0  ||
														hd.ver != VERSION) {
      libClose(fd);
      return NO;
   }
	cnt = hd.cnt;
	h = heaps;
	while (--cnt) {
		if (!h->next && !(h->next = heapAlloc(h)))
			return NO;
		h = h->next;
	}
	reLocate((pico*)&hd.lim, (pico*)&hd.lim+1);

   /* Read environment */
   if (libRead(fd, (char*)&env, (long)sizeof(env)) < 0) {
      libClose(fd);
      return NO;
   }
   reLocate(env.threads, &env.run+1);

   /* Read heaps */
	cnt = hd.cnt;
	h = heaps;
	while (--cnt >= 0) {
   	if (libRead(fd, (char*)h->cells, (long)(CELLS*sizeof(cell))) < 0) {
      	libClose(fd);
      	return NO;
   	}
		reLocate((pico*)h->cells,
				cnt?  (pico*)(h->cells+CELLS) : (pico*)hd.lim );
		h = h->next;
	}

   libClose(fd);

	/* Build avail list */
   avail = NULL;
	h = heaps;
	while (h->next)
		h = h->next;
   q = h->cells+CELLS;
   while (--q != (pico)hd.lim) {
      q->link = avail;
      avail = q;
		if (q == h->cells)
			q = (h=h->prev)->cells+CELLS;
   }
   q->link = avail;
   avail = q;
   return YES;
}

/* Cut long symbol names to 6 chars */
void doZap(x)
pico x;
{
   register pico y;

   if (!isNum(y = tail(x))) {
      if (isNum(car(y)))
         tail(x) = car(y);
      else {
         while (!isNum(cdr(y)) && !isNum(car(cdr(y))))
            y = cdr(y);
         if (!isNum(cdr(y)))
            cdr(y) = car(cdr(y));
      }
   }
}
