/* picoMap.c
 * 30sep92abu
 */

#pragma segment picoMap

#include "pico.h"

pico Map(x)
register pico x;
{
   register pico y;
	cell c1,c2;

   push(y = EVAL1(x), c1);
   push(EVAL1(cdr(x)), c2);
   x = nilSym;
   while (isCell(y)) {
      x = apply1(tos(c2),y);
      y = cdr(y);
   }
   drop(c1);
   return x;
}

pico Map2(x)
register pico x;
{
   register pico y,z;
	cell c1,c2,c3;

   push(y = EVAL1(x), c1);
   x = cdr(x);
   push(z = EVAL1(x), c2);
   push(EVAL1(cdr(x)), c3);
   x = nilSym;
   while (isCell(y)) {
      x = apply2(tos(c3),y,z);
      y = cdr(y);
      if (!isCell(z = cdr(z)))
         z = tos(c2);
   }
   drop(c1);
   return x;
}

pico Mapc(x)
register pico x;
{
   register pico y;
	cell c1,c2;

   push(y = EVAL1(x), c1);
   push(EVAL1(cdr(x)), c2);
   x = nilSym;
   while (isCell(y)) {
      x = apply1(tos(c2),car(y));
      y = cdr(y);
   }
   drop(c1);
   return x;
}

pico Mapc2(x)
register pico x;
{
   register pico y,z;
	cell c1,c2,c3;

   push(y = EVAL1(x), c1);
   x = cdr(x);
   push(z = EVAL1(x), c2);
   push(EVAL1(cdr(x)), c3);
   x = nilSym;
   while (isCell(y)) {
      x = apply2(tos(c3),car(y),car(z));
      y = cdr(y);
      if (!isCell(z = cdr(z)))
         z = tos(c2);
   }
   drop(c1);
   return x;
}

pico Mapcan(x)
register pico x;
{
   register pico y;
	cell c1,c2,c3;

   if (!isCell(y = EVAL1(x)))
      return y;
   push(y,c1);
   push(EVAL1(cdr(x)),c2);
   while (!isCell(x = apply1(tos(c2),car(y))))
      if (!isCell(y = cdr(y))) {
         drop(c1);
         return y;
      }
   push(x,c3);
   while (isCell(y = cdr(y)))
      nconc(x,apply1(tos(c2),car(y)));
   drop(c1);
   return x;
}

pico Mapcan2(x)
register pico x;
{
   register pico y,z;
	cell c1,c2,c3,c4;

   if (!isCell(y = EVAL1(x)))
      return y;
   push(y,c1);
   x = cdr(x);
   if (!isCell(z = EVAL1(x))) {
		drop(c1);
      return z;
	}
   push(z,c2);
   push(EVAL1(cdr(x)),c3);
   while (!isCell(x = apply2(tos(c3),car(y),car(z)))) {
      if (!isCell(y = cdr(y))) {
         drop(c1);
         return y;
      }
      if (!isCell(z = cdr(z)))
         z = tos(c2);
   }
   push(x,c4);
   while (isCell(y = cdr(y))) {
      if (!isCell(z = cdr(z)))
         z = tos(c2);
      nconc(x,apply2(tos(c3),car(y),car(z)));
   }
   drop(c1);
   return x;
}

pico Mapcar(x)
register pico x;
{
   register pico y;
	cell c1,c2,c3;

   if (!isCell(y = EVAL1(x)))
      return y;
   push(y,c1);
   push(EVAL1(cdr(x)),c2);
   push(x = newCell(apply1(tos(c2),car(y)),nilSym),c3);
   while (isCell(y = cdr(y))) {
      cdr(x) = newCell(apply1(tos(c2),car(y)),nilSym);
      x = cdr(x);
   }
   drop(c1);
   return tos(c3);
}

pico Mapcar2(x)
register pico x;
{
   register pico y,z;
	cell c1,c2,c3,c4;

   if (!isCell(y = EVAL1(x)))
      return y;
   push(y,c1);
   x = cdr(x);
   if (!isCell(z = EVAL1(x))) {
		drop(c1);
      return z;
	}
   push(z,c2);
   push(EVAL1(cdr(x)),c3);
   push(x = newCell(apply2(tos(c3),car(y),car(z)),nilSym),c4);
   while (isCell(y = cdr(y))) {
      if (!isCell(z = cdr(z)))
         z = tos(c2);
      cdr(x) = newCell(apply2(tos(c3),car(y),car(z)),nilSym);
      x = cdr(x);
   }
   drop(c1);
   return tos(c4);
}

pico Mapcon(x)
register pico x;
{
   register pico y;
	cell c1,c2,c3;

   if (!isCell(y = EVAL1(x)))
      return y;
   push(y,c1);
   push(EVAL1(cdr(x)),c2);
   while (!isCell(x = apply1(tos(c2),y)))
      if (!isCell(y = cdr(y))) {
         drop(c1);
         return y;
      }
   push(x,c3);
   while (isCell(y = cdr(y)))
      nconc(x,apply1(tos(c2),y));
   drop(c1);
   return x;
}

pico Mapcon2(x)
register pico x;
{
   register pico y,z;
	cell c1,c2,c3,c4;

   if (!isCell(y = EVAL1(x)))
      return y;
   push(y,c1);
   x = cdr(x);
   if (!isCell(z = EVAL1(x))) {
		drop(c1);
      return z;
	}
   push(z,c2);
   push(EVAL1(cdr(x)),c3);
   while (!isCell(x = apply2(tos(c3),y,z))) {
      if (!isCell(y = cdr(y))) {
         drop(c1);
         return y;
      }
      if (!isCell(z = cdr(z)))
         z = tos(c2);
   }
   push(x,c4);
   while (isCell(y = cdr(y))) {
      if (!isCell(z = cdr(z)))
         z = tos(c2);
      nconc(x,apply2(tos(c3),y,z));
   }
   drop(c1);
   return x;
}

pico Maplist(x)
register pico x;
{
   register pico y;
	cell c1,c2,c3;

   if (!isCell(y = EVAL1(x)))
      return y;
   push(y,c1);
   push(EVAL1(cdr(x)),c2);
   push(x = newCell(apply1(tos(c2),y),nilSym),c3);
   while (isCell(y = cdr(y))) {
      cdr(x) = newCell(apply1(tos(c2),y),nilSym);
      x = cdr(x);
   }
   drop(c1);
   return tos(c3);
}

pico Maplist2(x)
register pico x;
{
   register pico y,z;
	cell c1,c2,c3,c4;

   if (!isCell(y = EVAL1(x)))
      return y;
   push(y,c1);
   x = cdr(x);
   if (!isCell(z = EVAL1(x))) {
		drop(c1);
      return z;
	}
   push(z,c2);
   push(EVAL1(cdr(x)),c3);
   push(x = newCell(apply2(tos(c3),y,z),nilSym),c4);
   while (isCell(y = cdr(y))) {
      if (!isCell(z = cdr(z)))
         z = tos(c2);
      cdr(x) = newCell(apply2(tos(c3),y,z),nilSym);
      x = cdr(x);
   }
   drop(c1);
   return tos(c4);
}

pico Filter(x)
register pico x;
{
   register pico y;
	cell c1,c2,c3;

   if (!isCell(y = EVAL1(x)))
      return y;
   push(y,c1); /* List */
   push(EVAL1(cdr(x)),c2); /* Foo */
   while (isNil(apply1(tos(c2),car(y))))
      if (!isCell(y = cdr(y))) {
         drop(c1);
         return y;
      }
   push(x = newCell(car(y),nilSym),c3);
   while (isCell(y = cdr(y)))
      if (!isNil(apply1(tos(c2),car(y)))) {
         cdr(x) = newCell(car(y),nilSym);
         x = cdr(x);
      }
   drop(c1);
   return tos(c3);
}

pico Split(x)
register pico x;
{
   register pico y,z;
	cell c1,c2,c3,c4;

   if (!isCell(z = EVAL1(x)))
      return z;
   push(z, c1); /* List */
   push(EVAL1(cdr(x)), c2); /* Foo */
   push(x = nilSym, c3); /* Result */
   push(y = nilSym, c4); /* Sublist */
   while (isCell(z)) {
      if (!isNil(apply1(tos(c2),car(z)))) {
         if (isNil(x))
            x = tos(c3) = newCell(tos(c4),nilSym);
         else {
            cdr(x) = newCell(tos(c4),nilSym);
            x = cdr(x);
         }
         y = tos(c4) = nilSym;
      }
      else if (isNil(y))
         y = tos(c4) = newCell(car(z),nilSym);
      else {
         cdr(y) = newCell(car(z),nilSym);
         y = cdr(y);
      }
      z = cdr(z);
   }
   y = newCell(tos(c4),nilSym);
   drop(c1);
   if (isNil(x))
      return y;
   cdr(x) = y;
   return tos(c3);
}

pico Find(x)
register pico x;
{
   register pico y;
	cell c1,c2;

   push(y = EVAL1(x), c1);
   push(EVAL1(cdr(x)),c2);
   while (isCell(y)) {
      if (!isNil(apply1(tos(c2),car(y)))) {
         drop(c1);
         return car(y);
      }
      y = cdr(y);
   }
   drop(c1);
   return nilSym;
}

pico Amount(x)
register pico x;
{
   register pico y;
   register number n;
	cell c1,c2;

   push(EVAL1(x),c1);
   push(EVAL1(cdr(x)),c2);
   n = 0;
   x = tos(c1);
   while (isCell(x)) {
      if (isNum(y = apply1(tos(c2),car(x)))) {
         n += unBox(y);
      }
      x = cdr(x);
   }
   drop(c1);
   return boxNum(n);
}

pico Best(x)
register pico x;
{
   register pico y;
   register number n,m;
	cell c1,c2;

   push(y = EVAL1(x), c1);
   push(EVAL1(cdr(x)),c2);
   n = MAXNEG;
   x = nilSym;
   while (isCell(y)) {
      if (isNum(m = (number)(apply1(tos(c2),car(y))))  &&  unBox(m) > n) {
         n = unBox(m);
         x = car(y);
      }
      y = cdr(y);
   }
   drop(c1);
   return x;
}

pico Worst(x)
register pico x;
{
   register pico y;
   register number n,m;
	cell c1,c2;

   push(y = EVAL1(x), c1);
   push(EVAL1(cdr(x)),c2);
   n = MAXNUM;
   x = nilSym;
   while (isCell(y)) {
      if (isNum(m = (number)(apply1(tos(c2),car(y))))  &&  unBox(m) < n) {
         n = unBox(m);
         x = car(y);
      }
      y = cdr(y);
   }
   drop(c1);
   return x;
}
