/* picoTab.c
 * 27jan93abu
 */

#pragma segment picoTab

#include "pico.h"

symInit picoSyms[] = {
   {"abs",          Abs},
   {"access",       Access},
   {"add",          Add},
   {"add1",         Add1},
   {"add2",         Add2},
   {"align",        Align},
   {"all",          All},
   {"alloc",        Alloc},
   {"amount",       Amount},
   {"and",          And},
   {"append",       Append},
   {"apply",        Apply},
   {"array",        Array},
   {"ascii",        Ascii},
   {"assoc",        Assoc},
   {"atom",         ATom},
   {"backsp",       Backsp},
   {"bell",         Bell},
   {"bench",        pBench},
   {"best",         Best},
   {"big",          Big},
   {"bigAdd",       BigAdd},
   {"bigDiv",       BigDiv},
   {"bigLeq",       BigLeq},
   {"bigMul",       BigMul},
   {"bigSub",       BigSub},
   {"bigSqrt",      BigSqrt},
   {"bind",         Bind},
   {"bit",          pBit},
   {"bitl",         Bitl},
   {"bitr",         Bitr},
   {"bitAnd",       pBitAnd},
   {"bitNot",       pBitNot},
   {"bitOff",       pBitOff},
   {"bitOn",        pBitOn},
   {"bitOr",        pBitOr},
   {"bitXor",       pBitXor},
   {"block",        Block},
   {"boundp",       Boundp},
   {"BREAK",        BreakFun},
   {"byte",         AccByte},
   {"car",          Car},
   {"cdr",          Cdr},
   {"caar",         Caar},
   {"cadr",         Cadr},
   {"cdar",         Cdar},
   {"cddr",         Cddr},
   {"caaar",        Caaar},
   {"caadr",        Caadr},
   {"cadar",        Cadar},
   {"caddr",        Caddr},
   {"cdaar",        Cdaar},
   {"cdadr",        Cdadr},
   {"cddar",        Cddar},
   {"cdddr",        Cdddr},
   {"cadddr",       Cadddr},
   {"cddddr",       Cddddr},
   {"case",         Case},
   {"catch",        Catch},
   {"char",         AccChar},
   {"check",        Check},
   {"chop",         Chop},
   {"class",        Class},
   {"close",        Close},
   {"comment",      Comment},
   {"cond",         Cond},
   {"cons",         Cons},
   {"cons2",        Cons2},
   {"copy",         Copy},
   {"cos",          Cos},
   {"create",       Creat},
   {"cut",          Cut},
   {"cutPr",        CutPr},
   {"dashp",        Dashp},
   {"date",         pDate},
   {"de",           De},
   {"dec",          Dec},
   {"default",      Default},
   {"define",       Define},
   {"delete",       Delete},
   {"demon",        Demon},
   {"depth",        DEpth},
   {"diff",         Diff},
   {"digit",        Digit},
   {"dir",          Dir},
   {"div",          Div},
   {"div2",         Div2},
   {"do",           Do},
   {"dump",         Dump},
   {"dynamo",       Dynamo},
   {"enum",         Enum},
   {"eq",           Eq},
   {"equal",        Equal},
   {"erase",        Erase},
   {"error",        Error},
   {"eval",         Eval},
   {"evenp",        Evenp},
   {"filter",       Filter},
   {"find",         Find},
   {"flag",         Flag},
   {"flagp",        Flagp},
   {"flags",        Flags},
   {"for",          For},
   {"format",       Format},
   {"free",         Free},
   {"freeze",       Freeze},
   {"from",         From},
   {"fSize",        FSize},
   {"funp",         Funp},
   {"gc",           Gc},
   {"gensym",       Gensym},
   {"get",          Get},
   {"getc",         Getc},
   {"getd",         Getd},
   {"getLine",      GetLine},
   {"has",          Has},
   {"hidden",       Hidden},
   {"high",         High},
   {"hitKey",       HitKey},
   {"how",          How},
   {"if",           If},
   {"inc",          Inc},
   {"index",        Index},
   {"insert",       Insert},
   {"is",           Is},
   {"key",          Key},
   {"last",         Last},
   {"last2",        Last2},
   {"left",         Caar},
   {"length",       Length},
   {"leq",          Leq},
   {"lessp",        Lessp},
   {"letter",       Letter},
   {"limit",        Limit},
   {"link",         Link},
   {"list",         List},
   {"listp",        Listp},
   {"load",         Load},
   {"loc",          Loc},
   {"local",        Local},
   {"look",         Look},
   {"loop",         Loop},
   {"low",          Low},
   {"lowc",         Lowc},
   {"map",          Map},
   {"map2",         Map2},
   {"mapc",         Mapc},
   {"mapc2",        Mapc2},
   {"mapcan",       Mapcan},
   {"mapcan2",      Mapcan2},
   {"mapcar",       Mapcar},
   {"mapcar2",      Mapcar2},
   {"mapcon",       Mapcon},
   {"mapcon2",      Mapcon2},
   {"maplist",      Maplist},
   {"maplist2",     Maplist2},
   {"match",        Match},
   {"math",         Math},
   {"max",          Max},
   {"may",          May},
   {"member",       Member},
   {"memq",         Memq},
   {"method",       Method},
   {"middle",       Middle},
   {"min",          Min},
   {"minus",        Minus},
   {"minusp",       Minusp},
   {"mod",          Mod},
   {"mul",          Mul},
   {"mul2",         Mul2},
   {"muldiv",       Muldiv},
   {"nand",         Nand},
   {"nconc",        Nconc},
   {"nconc1",       Nconc1},
   {"neq",          Neq},
   {"neuro",        Neuro},
   {"new",          New},
   {"nextc",        Nextc},
   {"noop",         evalBody},
   {"nor",          Nor},
   {"not",          Not},
   {"nth",          Nth},
   {"nthcdr",       Nthcdr},
   {"null",         Not},
   {"number",       Number},
   {"numberp",      Numberp},
   {"oblist",       Oblist},
   {"oddp",         Oddp},
   {"off",          Off},
   {"on",           On},
   {"one",          One},
   {"onep",         Onep},
   {"open",         Open},
   {"or",           Or},
   {"order",        Order},
   {"pack",         Pack},
   {"pairp",        Pairp},
   {"pipe",         Pipe},
   {"plist",        Plist},
   {"plusp",        Plusp},
   {"pname",        Pname},
   {"pop",          Pop},
   {"prHex",        PrHex},
   {"print",        Print},
   {"prin1",        Prin1},
   {"prin2",        Prin2},
   {"prLine",       PrLine},
   {"PROF",         ProfFun},
   {"progn",        evalBody},
   {"prog1",        Prog1},
   {"prog2",        Prog2},
   {"ptr",          AccPtr},
   {"push",         Push},
   {"push1",        Push1},
   {"put",          Put},
   {"putc",         Putc},
   {"putd",         Putd},
   {"quit",         Quit},
   {"random",       pRandom},
   {"raw",          Raw},
   {"read",         Read},
   {"record",       Record},
   {"ref",          Ref},
   {"ref2",         Ref2},
   {"rem",          Rem},
   {"remob",        Remob},
   {"remove",       Remove},
   {"rename",       fRename},
   {"repeat",       Repeat},
   {"reptn",        Reptn},
   {"revalo",       Revalo},
   {"reverse",      Reverse},
   {"ring",         Ring},
   {"round",        Round},
   {"rplaca",       Rplaca},
   {"rplacd",       Rplacd},
   {"sect",         Sect},
   {"seek",         Seek},
   {"serial",       Serial},
   {"set",          Set},
   {"setFlags",     SetFlags},
   {"setPlist",     SetPlist},
   {"setq",         Setq},
   {"shift",        Shift},
   {"sift",         Sift},
   {"sign",         Sign},
   {"sin",          Sin},
   {"size",         pSize},
   {"slot",         Slot},
   {"slot-",        SlotDash},
   {"solve",        Solve},
   {"sort",         Sort},
   {"space",        Space},
   {"splay",        Splay},
   {"split",        Split},
   {"sqr",          Square},
   {"sqrt",         Sqrt},
   {"store",        Store},
   {"string",       AccString},
   {"stringp",      Stringp},
   {"strLen",       StrLen},
   {"stuff",        Stuff},
   {"sub",          Sub},
   {"sub1",         Sub1},
   {"sub2",         Sub2},
   {"subst",        Subst},
   {"super",        Super},
   {"swap",         Swap},
   {"symbol",       Symbol},
   {"symbolp",      Symbolp},
   {"system",       System},
   {"tab",          Tab},
   {"tail",         Tail},
   {"tan",          Tan},
   {"terpri",       Terpri},
   {"throw",        Throw},
   {"time",         pTime},
   {"to",           To},
   {"toggle",       Toggle},
   {"TRACE",        TraceFun},
   {"track",        Track},
   {"trail",        Trail},
   {"train",        Train},
   {"unify",        Unify},
   {"unique",       Unique},
   {"unless",       Unless},
   {"unpack",       UnPack},
   {"until",        Until},
   {"upc",          Upc},
   {"value",        Value},
   {"varp",         Varp},
   {"when",         When},
   {"where",        Where},
   {"while",        While},
   {"who",          Who},
   {"wild",         Wild},
   {"with",         With},
   {"worst",        Worst},
   {"word",         AccWord},
   {"xchg",         Xchg},
   {"xor",          Xor},
   {"zero",         Zero},
   {"zerop",        Zerop},
#if 0
   {"quote",        Quote},   /* Created below */
   {"object",       OBject},  /* These entries are for mkSrc */
#endif
   NULL
};

pico init1Sym(s,f,v)
uchar *s;
bool f;
pico v;
{
   register pico x,name;

   if (!(x = find(name = compressName(s), YES)))
      x = intern(newSym(name, voidSym), YES);
   if (f)
      val(x) = v;
   return x;
}

void initSymTab(s)
register symInit *s;
{
   if (fresh)
      while (s->nameInit) {
         init1Sym(s->nameInit, YES, boxSubr(num(s->funInit)));
         ++s;
      }
}

void initSymbols()
{
   register pico x;
   register int i;
   static uchar vName[] = "void";

   if (fresh) {
      mapCell = newCell(mapSym = newSym(compressName(vName),NULL),NULL);
      mapCell2 = newCell(mapSym2 = newSym(compressName(vName),NULL), mapCell);
      mapCell3 = newCell(mapSym3 = newSym(compressName(vName),NULL), mapCell2);
      x = mapCell4 =
            newCell(mapSym4 = newSym(compressName(vName),NULL), mapCell3);
      i = APPLYMAX-4;
      do
         x = newCell(newSym(compressName(vName),NULL),x);
      while (--i);
      applyList = x;
      nilSym = newSym(compressName("NIL"), NULL); /* NIL object itself */
      val(nilSym) = nilSym;
      newCell(nilSym,nilSym); /* Dummy cell as CDR of nilSym */
      cdr(mapCell) = nilSym;
      do
         val(car(x)) = nilSym;
      while isCell(x = cdr(x));
      for (i=0; i<=THREADS; ++i)
         env.threads[i] = nilSym;
      intern(nilSym,YES);
   }
   else {
		x = heaps->cells;
      mapSym = mkSym(x);
      mapCell = x + 1;
      mapSym2 = mkSym(x + 2);
      mapCell2 = x + 3;
      mapSym3 = mkSym(x + 4);
      mapCell3 = x + 5;
      applyList = x  + 2*APPLYMAX - 1;
      nilSym = mkSym(x  + 2*APPLYMAX);
   }
   *markPtr(mkCell(nilSym)+1) &= ~1;
   voidSym = init1Sym("VOID",NO,NULL), val(voidSym) = voidSym;
   tSym = init1Sym("T",NO,NULL), val(tSym) = tSym; /* Last protected symbol */
   init1Sym("Max",fresh,boxNum(MAXNUM));
   init1Sym("Min",fresh,boxNum(MAXNEG));
	itSym = init1Sym("it",YES,nilSym);
   quoteSym = init1Sym("quote", YES, boxSubr(num(Quote)));
   shareFlg = init1Sym("Share",fresh,nilSym);
   objectSym = init1Sym("object", YES, boxSubr(num(OBject)));
   classSym = init1Sym("Class",fresh,nilSym);
   metaSym = init1Sym("Meta",fresh,nilSym);
   quitSym = init1Sym("Quit",fresh,nilSym);
   fileSym = init1Sym("Files",fresh,nilSym);
   argvSym = init1Sym("Argv",YES,nilSym);
   loadSym = init1Sym("Load",fresh,nilSym);
   editSym = init1Sym("Edit",fresh,nilSym);
   queueSym = init1Sym("Queue",fresh,nilSym);
   srcFlg = init1Sym("Src",fresh,tSym);
   logFlg = init1Sym("Log",fresh,nilSym);
   printFlg = init1Sym("Print",fresh,nilSym);
   againSym = init1Sym("Again",fresh,tSym);
   fkeySym = init1Sym("FKey",fresh,nilSym);
   dash5Sym = init1Sym("-----",YES,nilSym);
   dash4Sym = init1Sym("----",YES,nilSym);
   dash3Sym = init1Sym("---",YES,nilSym);
   dash2Sym = init1Sym("--",YES,nilSym);
   dashSym = init1Sym("-",YES,nilSym);
   initSysVars();
   initAppVars();
   topSym = init1Sym("-t",fresh,nilSym); /* Last un-REMOB-able symbol */

   initSymTab(picoSyms);
   initSysSyms();
   initApplication();
}
