/* scoLib.c
 * 14jan93abu
 */

#include "pico.h"
#include <fcntl.h>
#include <malloc.h>
#include <sys/types.h>
#include <memory.h>
/* #include <sys/ndir.h> */
#include <sgtty.h>
#include <time.h>
#include <sys/times.h>


int ttyDev;                /* Serial channels */
int auxDev = 0;
struct sgttyb ttyOld,ttyNew,auxOld,auxNew;
char *lName = "/dev/tty";	/* Line I/O device name */


void libStartUp(argc,argv)
int argc;
char *argv[];
{
   while (--argc > 0) {
      if (**++argv == '-') {
         switch(argv[0][1]) {
         	case 'f':
            	if (argv[0][2] == '\0') {
               	--argc, ++argv;
               	frzFd = open(argv[0], O_RDONLY);
            	}
            	else
               	frzFd = open(argv[0] + 2, O_RDONLY);
					if (frzFd < 0)
						giveup("Can't open FREEZE file");
            	break;
         case 'l':
            if (argv[0][2] == '\0') {
               --argc, ++argv;
               lName = argv[0];
            }
            else
               lName = argv[0] + 2;
				initConsole();
            break;
         default:
   			giveup("Usage: pico [-m<size>] [-l<ttyDev>] [-f<file>] [+any <any>] [<files>]");
            break;
         }
      }
      else {
         if (loadCnt >= ARGMAX-1)
            giveup("Too many source files");
         else
            fileNames[loadCnt++] = (uchar)argv[0];
      }
   }
}

void libExit(f)
bool f;
{
   stty(ttyDev,&ttyOld);
   if (auxDev)
      stty(auxDev,&auxOld);
   exit(f? 0:1);
}

void libError(s)
uchar *s;
{
   fprintf(stderr,"%s\n",s);
}

char *libAlloc(size)
unsigned long size;
{
   return (char*)malloc(size);
}

void libFree(ptr)
char *ptr;
{
   free(ptr);
}

char *libRealloc(ptr,size)
char *ptr;
unsigned long size;
{
   return (char*)realloc(ptr, size);
}

void libBlock(src,dst,size)
char *src,*dst;
unsigned long size;
{
   memcpy(dst,src,size);
}

long libTick()
{
   struct tms tim;

   times(&tim);
	return tim.tms_utime;
}

void libDate(y,m,d)
number *y,*m,*d;
{
   struct tm *p;
   long clock;

   time(&clock);
   p = localtime(&clock);
   *y = (number)p->tm_year;
	*m = (number)(p->tm_mon+1);
	*d =(number)p->tm_mday;
}

void libTime(h,m,s)
number *h,*m,*s;
{
   struct tm *p;
   long clock;

   time(&clock);
   p = localtime(&clock);
   *h = (number)p->tm_hour;
	*m = (number)p->tm_min;
	*s = (number)p->tm_sec;
}

int libRdOpen(fName)
uchar *fName;
{
   return open(fName, O_RDONLY);
}

int libWrOpen(fName,flgs)
uchar *fName;
long flgs;
{
   return open(fName, O_CREAT|O_TRUNC|O_RDWR, 0666);
}

int libRdWrOpen(fName)
uchar *fName;
{
   return open(fName, O_RDWR);
}

long libRead(fd,buf,cnt)
int fd;
char *buf;
long cnt;
{
	return read(fd,buf,cnt);
}

long libWrite(fd,buf,cnt)
int fd;
char *buf;
long cnt;
{
	return write(fd,buf,cnt);
}

bool libSeek(fd,pos)
int fd;
long pos;
{
	return lseek(fd,pos,0) >= 0;
}

long libFPos(fd)
int fd;
{
	return lseek(fd,0,1);
}

long libFSize(fd)
int fd;
{
	long oldPos,pos;

	if ((oldPos = lseek(fd,0,1)) < 0  ||
			(pos = lseek(fd,0,2)) < 0  ||
			lseek(fd, oldPos, 0) < 0)
		return -1;
	return pos;
}

bool libClose(fd)
int fd;
{
	return close(fd) >= 0;
}

pico libDir(fName)
uchar *fName;
{
   DIR *dp;
   struct direct *d;

   if (!(dp = opendir(*fName? fName : ".")))
      return nilSym;
   push(nilSym);
   while (d = readdir(dp)) {
      tos = newCell(unBufString(d->d_name),tos);
#if 0
		if (isDirectory)
			nconc(car(tos), newCell(boxNum('/'), nilSym));
#endif
	}
	closedir(dp);
	return pop();
}

bool libLink(old,new)
uchar *old,*new;
{
	return link(old,new) >= 0 && unlink(old) >= 0;
}

bool libUnlink(s)
uchar *s;
{
	return unlink(s) >= 0;
}

void initConsole()
{
   if ((ttyDev = open(lName, O_RDWR)) == -1)
      giveup("Can't open serial device");

   gtty(ttyDev,&ttyOld);
   gtty(ttyDev,&ttyNew);
   ttyNew.sg_flags |= RAW;
   ttyNew.sg_flags &= ~(ECHO | CRMOD | ODDP);
   stty(ttyDev,&ttyNew);
}

bool initSerial(s)
uchar *s;
{
   if (auxDev) {
      stty(auxDev,&auxOld);
      close(auxDev);
   }
   if ((auxDev = open(s, O_RDWR)) == -1)
      return NO;
   gtty(auxDev,&auxOld);
   gtty(auxDev,&auxNew);
   auxNew.sg_flags |= RAW;
   auxNew.sg_flags &= ~(ECHO | CRMOD | ODDP);
   stty(auxDev,&auxNew);
   return YES;
}

void initSysSyms()
{
}

void initSysVars()
{
}

bool serialStat()
{
   return  auxDev && rdchk(auxDev) > 0;
}

int serialIn()
{
   char buff[4];

   if (!auxDev || read(auxDev, buff, 1) < 0)
      err("Serial input error");
   return buff[0];
}

void serialOut(c)
int c;
{
   char buff[4];

   buff[0] = c;
   if (!auxDev || write(auxDev, buff, 1) < 0)
      err("Serial output error");
}

void ttyOut(c)
char c;
{
   char buf[1];

   if (qFull && charQueue == ctrl('S')) {
      read(ttyDev, buf, 1);
		charQueue = buf[0];
      qFull = NO;
   }
   buf[0] = c;
   if (write(ttyDev, buf, 1) < 0)
      err("TTY output error");
}

bool ttyAvail()
{
   return rdchk(ttyDev);
}

int waitTTY()
{
	char buf[1];

   if (read(ttyDev, buf, 1) <  0)
      err("TTY input error");
	return buf[0];
}

void deLocate(adr1,adr2)
pico *adr1, *adr2;
{
}

void reLocate(adr1,adr2)
pico *adr1, *adr2;
{
}

number libSystem(s)
uchar *s;
{
   number n;

   stty(ttyDev,&ttyOld);
   n = system(s);
   stty(ttyDev,&ttyNew);
   return n;
}
