[about.l 27jan93]

(off HVol)
(setq PumId 201)
(setq :point (0.0))
(de :rect (0 . 22) 480 . 340)

<de mapDir (d :foo p)
   (mapc (cdr d)
      '((x)
         (if (dirp x)
            (:foo p (car x) T)
            (:foo p x) ) ) )
   (mapc (filter (cdr d) dirp)
      '((x)
         (mapDir
            x
            :foo
            (append p (cons \: (car x))) >

<de dirp (l)
   (pairp (car l)) >

<de pumSel (l)
   (local (mh)
      (setq mh (GetMenu PumId))
      (while l
         (InsMenuItem mh (pop l) 99) )
      (InsertMenu mh -1)
      (LocalToGlobal :point)
      (prog1
         (GetItem
            mh
            (low
               (PopUpMenuSelect mh
                  (add (cdr :point) 12)
                  (sub (car :point) 20)
                  1 ) ) )
         (DeleteMenu PumId)
         (ReleaseResource mh) >

<de findPath (s d p)
   (local (a)
      (if
         (find (cdr d)
            '((x)
               (or
                  (wild s (setq a x))
                  (wild s (setq a (car x))) ) ) )
         (setq
            :path (cons a p)
            :also d )
         (find (filter (cdr d) dirp)
            '((x) (findPath s x (cons (car x) p))) >

<de setPath (p)
   (setq :path p)
   (local (l)
      (setq
         l (reverse :path)
         :also :dir )
      (until
         (find (cdr :also)
            '((x)
               (or
                  (equal (car :path) x)
                  (equal (car :path) (car x)) ) ) )
         (setq :also (assoc (pop l) :also) >

<de mkPath ()
   (local (l)
      (setq l
         (when (assoc (car :path) (cdr :also))
            (cons \: (car :path)) ) )
      (mapc :path
         '((x) (setq l (append (cons \: x) l))) )
      l >

<de rdSel ()
   (zero :pos)
   (local (fd p)
      (setq :text)
      (when (setq fd (open (mkPath)))
         (while (getLine fd)
            (link :text p it) )
         (close fd) >

<de prSel ()
   (local (l n)
      (setq
         n 3
         l (nthcdr (sub1 :pos) :text) )
      (EraseRect '#:rect)
      (TextFont 4)
      (TextSize 9)
      (when (zerop :pos)
         (inc n)
         (MoveTo 12 36)
         (reptn 8 (DrawChar \=))
         (DrawChar 32)
         (DrawString (car :path))
         (DrawChar 32)
         (reptn (sub 64 (strLen (car :path)))
            (DrawChar \=) ) )
      (reptn 25
         (when l
            (MoveTo 12 (mul 12 (inc n)))
            (DrawString (pop l)) ) )
      (unless l
         (MoveTo 12 (mul 12 (inc n)))
         (reptn 74 (DrawChar \=)) )
      (TextFont 0)
      (TextSize 0) >

<de mkAlso (x)
   (when (dirp x)
      (setq x (car x)) )
   (unless (member x :path)
      (list x) >

<de infoDialog (s)
   (local (itemHit v)
      (when (or (not s) (findPath s :dir))
         (rdSel)
         (prSel)
         (while
            (lessp 1
               (ModalDialog
                  '((:dlg ev itemHit)
                     (case (ev-what ev)
                        (#mouseDown
                           (when (inRect (GetMouse :point) '#:rect)
                              (word itemHit 9) ) )
                        (#keyDown
                           (when
                              (memq
                                 (bitAnd
                                    #charCodeMask
                                    (ev-message ev) )
                                 (3 13) )
                              (word itemHit 1) ) ) ) )
                  itemHit ) )
            (case itemHit
               (2 [HERE]
                  (when (setq s (pumSel :path))
                     (unless (equal s (car :path))
                        (push :path :recent)
                        (setPath (member s :path))
                        (rdSel)
                        (prSel) ) ) )
               (3 [WHAT]
                  (when
                     (setq s
                        (pumSel
                           (mapcan
                              (cdr (assoc (car :path) :also))
                              mkAlso ) ) )
                     (push :path :recent)
                     (setPath (cons s :path))
                     (rdSel)
                     (prSel) ) )
               (4 [ALSO]
                  (when (setq s (pumSel (mapcan (cdr :also) mkAlso)))
                     (push :path :recent)
                     (setPath (cons s (cdr :path)))
                     (rdSel)
                     (prSel) ) )
               (5 [JUMP]
                  (when (setq s (pumSel :jump))
                     (push :path :recent)
                     (findPath s :dir)
                     (rdSel)
                     (prSel) ) )
               (6 [BACK]
                  (when :recent
                     (setPath (pop :recent))
                     (rdSel)
                     (prSel) ) )
               (T
                  (setq v (cdr :point))
                  (SetCursor (ptr (GetCursor #plusCursor)))
                  (while (StillDown)
                     (GetMouse :point) )
                  (SetCursor Arrow)
                  (cond
                     ((lessp (add v 12) (cdr :point))
                        (setq :pos
                           (max 0
                              (sub :pos
                                 (div
                                    (sub (cdr :point) v)
                                    12 ) ) ) )
                        (prSel) )
                     ((lessp (cdr :point) (sub v 12))
                        (setq :pos
                           (add :pos
                              (div (sub v (cdr :point)) 12) ) )
                        (prSel) >

<de hDir (d)
   (cons (last2 (split d '((c) (eq c \:))))
      (mapcar (dir d)
         '((nm)
            (if (eq \: (last nm)) (hDir (append d nm)) nm) >

<de about (s)
   (local (dlg v nm)
      (when (and s (symbolp s))
         (setq s (pname s)) )
      (setq v (GetVol))
      (when (or HVol (setq nm (getFile "HDoc")))
         (if HVol
            (SetVol HVol)
            (progn
               (OpenResFile nm)
               (SetCursor (ptr (GetCursor #watchCursor)))
               (setq
                  HVol (GetVol)
                  :dir (hDir ":") )
               (setq :jump (read1 "*jump"))
               (SetCursor Arrow) ) )
         (setq :recent)
         (localPort (setq dlg (GetNewDialog 200 NIL -1))
            (infoDialog s) )
         (DisposDialog dlg)
         (if (a-key)
            (edit (mkPath))
            (SetVol v) >

T
