[cmd.l 14feb93]

[+ File Menu +]
<de openCmd ()
   (when (getFile FType)
      (doOpen it) >

<de newCmd ()
   (when (calDialog)
      (local (h p obj)
         (PrOpen)
         (PrintDefault (setq h (NewHandle #TPSize)))
         (PrClose)
         (setq p (paper h))
         (with
            (setq obj
               (new 'viewPoint (cons 90 (add 30 (word MBarHeight)))
                  (right p) (bottom p)
                  "ViewPoint" NIL T ) )
            (slot hPrint (dynamo DisposHandle h))
            (slot paper p)
            (slot org-h (div2 (p-mm (right p) 10000)))
            (slot org-v (div2 (p-mm (bottom p) 10000)))
            (slot angle Angle)
            (slot tilt Tilt)
            (slot delta Delta)
            (slot focLen FocLen)
            (slot scale 10000)
            (slot style (pack 0 0 30)) [FillPat/Color PenPat PenSize]
            (setVanish obj) >

<de saveCmd ()
   (with App
      (doSave App (slot name) (slot vol)) >

<de revertCmd ()
   (zapUndo)
   (local (fd r scl p)
      (with App
         (localVol (slot vol)
            (when (setq fd (open (slot name)))
               (setq  r (read fd)  scl (read fd)  p (read fd))
               (do change App
                  (fdiv (right p) scl)
                  (fdiv (bottom p) scl)
                  r )
               (doRead fd scl p)
               (close fd)
               (remove App 'dirty)
               (setVanish App)
               (slot mark (off Mark))
               (do inval App) >

[+ Edit Menu +]
<de cutCmd ()
   (with App
      (make #(str "Cut") T
         (list Mark Clip)
         '((m c)
            (putData m)
            (setq Clip c) )
         (list Mark)
         '((l)
            (setq Clip l)
            (removeData Mark) >

<de copyCmd ()
   (with App
      (make #(str "Copy") NIL
         (list Clip)
         '((l) (setq Clip l))
         (list Mark)
         '((l) (setq Clip l) >

<de pasteCmd ()
   (make #(str "Paste") T
      (list Mark)
      '((l)
         (removeData Mark)
         (mapc l mark) )
      (list Clip)
      putData >

<de clearCmd ()
   (make #(str "Clear") T
      (list Mark)
      putData
      NIL
      '(() (removeData Mark) (setq Mark)) >

<de dupCmd ()
   (make #(str "Duplicate") T
      (list Mark)
      '((l)
         (removeData Mark)
         (mapc l mark) )
      (local (dx dy)
         (setq
            dx (if (zerop VP) 0 -100000)
            dy (if (eq VP 9000) 0 100000) )
         (list
            (dMove Mark
               (x-rot dx dy)
               (y-rot dx dy)
               (if VP 100000 0) ) ) )
      putData >

<de allCmd ()
   (make #(str "Select All") NIL
      (list Mark)
      '((l)
         (mapc Mark
            '((sg)
               (or
                  (memq sg l)
                  (unMark sg) ) ) ) )
      (with App (list (slot data)))
      '((l) (mapc l mark)) >

[+ ViewPoint Menu +]
<de setAng (a)
   (put App 'angle a)
   (plane a VP)
   (do inval App) >

<de setAngle (obj)
   (with obj
      (when (dialog1 #(str "Angle") (format (slot angle) 2))
         (make #(str "Change Angle") T
            (list (slot angle))
            setAng
            (list (number it 2))
            setAng >

<de setATFD (a t f d)
   (with App
      (slot angle a)
      (slot tilt t)
      (slot focLen f)
      (slot delta d)
      (setVanish App)
      (mapc (slot data)
         '((w)
            (mapc (cdr w)
               '((z)
                  (mapc z
                     '((l)
                        (if (pointp (car l))
                           (rplaca l
                              (xyz-hv (w-x l) (w-y l) (w-z l)) )
                           (progn
                              (rplaca (car l)
                                 (xyz-hv
                                    (w-x (car l))
                                    (w-y (car l))
                                    (w-z (car l)) ) )
                              (rplaca (cdr l)
                                 (xyz-hv
                                    (w-x (cdr l))
                                    (w-y (cdr l))
                                    (w-z (cdr l)) >

<de setPerspective (obj)
   (with obj
      (setq
         Angle (slot angle)
         Tilt (slot tilt)
         Delta (slot delta)
         FocLen (slot focLen) )
      (when (calDialog)
         (busy #(div cells 4)
            (make #(str "Change Perspective") T
               (list (slot angle) (slot tilt) (slot focLen) (slot delta))
               setATFD
               (list Angle Tilt FocLen Delta)
               setATFD >

<de widthCmd ()
   (local (s)
      (with App
         (when
            (setq s
               (dialog1 #(str "Line Width [mm]")
                  (format (low (slot style)) 2) ) )
            (make #(str "Line Width") T
               (list (slot style) Mark (slot data))
               '((s m d)
                  (put App 'style s)
                  (undoList m d) )
               (list
                  (pack
                     (high (slot style))
                     (middle (slot style))
                     (number s 2) ) )
               '((s)
                  (with App
                     (slot style s)
                     (makeList
                        (mapcar Mark
                           '((w) (cons s (cdr w))) >

<de crossCmd ()
   (local (wp1 wp2)
      (off Snap Snap1)
      (and
         (setq wp1 (click vpGlobal vpSnap vpSpot NIL hiDot1 snapOk))
         (setq wp2 (click vpGlobal vpStiff vpSpot wp1 line1 snapOk))
         (busy #(div cells 4)
            (with App
               (makeSnap #(str "Crosspoints")
                  (mapcan Mark
                     '((w)
                        (mapcar (secGraf (cdr w) (w-hv wp1) (w-hv wp2))
                           '((pt) (pt-wp pt Snap)) >

<de midCmd ()
   (local (wp1 wp2)
      (off Snap Snap1)
      (and
         (setq wp1 (click vpGlobal vpSnap vpSpot NIL hiDot1 snapOk))
         (setq wp2 (click vpGlobal vpStiff vpSpot wp1 line1 snapOk))
         (busy #(div cells 4)
            (makeSnap #(str "Midpoint")
               (list
                  (xyz-wp
                     (div2 (add (w-x wp1) (w-x wp2)))
                     (div2 (add (w-y wp1) (w-y wp2)))
                     (div2 (add (w-z wp1) (w-z wp2))) >

(setq DivN 3)

<de divCmd ()
   (local (s wp1 wp2 lst)
      (off Snap Snap1)
      (and
         (setq s (dialog1 #(str "Divide by") (format DivN)))
         (lessp 1 (setq DivN (number s)))
         (setq wp1 (click vpGlobal vpSnap vpSpot NIL hiDot1 snapOk))
         (setq wp2 (click vpGlobal vpStiff vpSpot wp1 line1 snapOk))
         (busy #(div cells 4)
            (off lst)
            (for (i 1 DivN)
               (push
                  (xyz-wp
                     (add (w-x wp1)
                        (muldiv (sub (w-x wp2) (w-x wp1)) i DivN) )
                     (add (w-y wp1)
                        (muldiv (sub (w-y wp2) (w-y wp1)) i DivN) )
                     (add (w-z wp1)
                        (muldiv (sub (w-z wp2) (w-z wp1)) i DivN) ) )
                  lst ) )
            (makeSnap #(str "Division") lst) >

<de clearSnapCmd ()
   (local (pt r lst)
      (with App
         (and
            (setq pt (click ptGlobal))
            (setq r (dragSelect pt))
            (setq lst
               (filter (slot snap)
                  '((wp) (inRect (w-hv wp) r)) ) )
            (busy #(div cells 4)
               (make #(str "Clear Points") NIL
                  (list (slot snap))
                  '((l)
                     (with App
                        (mapc (slot snap) invalPt)
                        (mapc (slot snap l) invalPt) ) )
                  (list (diff lst (slot snap)))
                  '((l)
                     (with App
                        (mapc (slot snap) invalPt)
                        (slot snap l) >

<de centerCmd ()
   (local (pt r)
      (with App
         (when (click ptGlobal)
            (setq
               pt (ptLocal it)
               r (slot view) )
            (do change App
               (slot size-h)
               (slot size-v)
               (mvRect r
                  #(fix (car pt) - ((left r) + (right r))/2)
                  #(fix (cdr pt) - ((top r) + (bottom r))/2) ) )
            (do inval App) >

<de upCmd ()
   (local (pt r)
      (with App
         (when (click ptGlobal)
            (setq
               pt (ptLocal it)
               r (slot view) )
            (slot scale (div2 (slot scale)))
            (do change App
               (fdiv (right (slot paper)) (slot scale))
               (fdiv (bottom (slot paper)) (slot scale))
               (mvRect r
                  #(fix 2*(car pt) - ((left r) + (right r))/2)
                  #(fix 2*(cdr pt) - ((top r) + (bottom r))/2) ) )
            (do inval App) >

<de dnCmd ()
   (local (r)
      (with App
         (setq r (slot view))
         (slot scale (mul2 (slot scale)))
         (do change App
            (fdiv (right (slot paper)) (slot scale))
            (fdiv (bottom (slot paper)) (slot scale))
            (mvRect (slot view)
               #(fix ((left r)+(right r)) / -4)
               #(fix ((top r)+(bottom r)) / -4) ) )
         (do inval App) >

[+ Modify Menu +]
<de moveCmd ()
   (local (wp1 wp2)
      (off Snap Snap1)
      (and
         (setq wp1 (click vpGlobal vpSnap vpSpot NIL hiDot1 snapOk))
         (setq wp2
            (click vpGlobal vpStiff vpSpot wp1
               '((wp1 wp2)
                  (mapc (vpMove Mark wp1 wp2)
                     '((w) (doDraw (cdr w))) ) )
               snapOk ) )
         (busy #(div cells 4)
            (makeModify #(str "Move") (vpMove Mark wp1 wp2)) >

<de groupCmd ()
   (makeModify #(str "Group")
      (list
         (cons
            (car (last Mark))
            (mapcan Mark '((w) (append (cdr w)))) >

<de ungroupCmd ()
   (makeModify #(str "Ungroup")
      (mapcan Mark
         '((w)
            (mapcar (cdr w)
               '((z) (list (car w) z)) >

<de mirrorCmd ()
   (off Snap Snap1)
   (when (click vpGlobal vpSnap vpSpot NIL hiDot1 snapOk)
      (busy #(div cells 4)
         (makeModify #(str "Mirror") (vpMirror Mark it)) >

<de resizeCmd ()
   (local (wp0 wp1 wp2)
      (off Snap Snap1)
      (and
         (setq wp0 (click vpGlobal vpSnap vpSpot NIL hiDot1 snapOk))
         (setq wp1
            (click vpGlobal vpStiff vpSpot wp0
               '((wp1 wp2) (doDraw (vpRect wp1 wp2)))
               snapOk ) )
         (setq wp2
            (click vpGlobal vpStiff vpSpot wp0
               '((wp1 wp2) (doDraw (vpRect wp1 wp2)))
               snapOk ) )
         (busy #(div cells 4)
            (makeModify #(str "Resize") (vpResize Mark wp0 wp1 wp2)) >

<de rotateCmd ()
   (local (wp0 wp1 wp2)
      (off Snap Snap1)
      (and
         (setq wp0 (click vpGlobal vpSnap vpSpot NIL hiDot1 snapOk))
         (setq wp1 (click vpGlobal vpStiff vpSpot wp0 line1 snapOk))
         (setq wp2 (click vpGlobal vpStiff vpSpot wp0 line1 snapOk))
         (busy #(div cells 4)
            (makeModify #(str "Rotation") (vpRotate Mark wp0 wp1 wp2)) >

T
