[dialog.l 25jan93]

(setq
   Unit "m"
   :Size 1000000
   Angle 3000
   Tilt -3500
   FocLen 2000000
   Delta 4000000 )

(de Units "nm" "mm" "cm" "m" "km" "inch" "mile")
(de :U-Box (97.39) 149.57)
(de :Box (200.10) 520.330)
(setq
   :Org-h (div2 (add (left :Box) (right :Box)))
   :Org-v (div2 (add (top :Box) (bottom :Box))) )
(off :Scale :Paper :Bits :Save :Rgn)

<de :LeftView DkGray
   ((-1.-1).-1) ((+1.-1).-1) ((+1.-1).+1) ((-1.-1).+1) ((-1.-1).-1) >
<de :TopView LtGray
   ((-1.-1).+1) ((+1.-1).+1) ((+1.+1).+1) ((-1.+1).+1) ((-1.-1).+1) >
<de :FrontView Gray
   ((-1.-1).-1) ((-1.-1).+1) ((-1.+1).+1) ((-1.+1).-1) ((-1.-1).-1) >
<de :BottomView Black
   ((-1.-1).-1) ((+1.-1).-1) ((+1.+1).-1) ((-1.+1).-1) ((-1.-1).-1) >

<de popupBox (r s)
   (EraseRect r)
   (FrameRect r)
   (MoveTo (add2 (left r)) (bottom r))
   (LineTo (right r) (bottom r))
   (MoveTo (right r) (add1 (top r)))
   (LineTo (right r) (bottom r))
   (MoveTo (add 14 (left r)) (sub (bottom r) 5))
   (DrawString s) >

<de popup (pt l i)
   (local (mh)
      (setq i (or (index i l) 0))
      (setq mh (NewMenu 4711))
      (while l
         (InsMenuItem mh (pop l) 999) )
      (InsertMenu mh -1)
      (setq pt (LocalToGlobal (copy pt)))
      (prog1
         (GetItem mh
            (low (PopUpMenuSelect mh (cdr pt) (car pt) (add1 i))) )
         (DeleteMenu 4711)
         (DisposeMenu mh) >

<de cal-h (h)
   (add #:Org-h (div h :Scale)) >

<de cal-v (v)
   (add #:Org-v (div v :Scale)) >

<de calPt (pt)
   (local (x y)
      (setq
         x (mul (div2 :Size) (caar pt))
         y (mul (div2 :Size) (cdar pt)) )
      (xyz-hv (x-rot x y) (y-rot x y) (mul (div2 :Size) (cdr pt))) >

<de calMoveTo (pt)
   (setq pt (calPt pt))
   (MoveTo (cal-h (car pt)) (cal-v (cdr pt))) >

<de calLineTo (pt)
   (setq pt (calPt pt))
   (LineTo (cal-h (car pt)) (cal-v (cdr pt))) >

<de calRgn (lst)
   (mapc lst
      '((l)
         (OpenRgn)
         (calMoveTo (cadr l))
         (mapc (cddr l) calLineTo)
         (CloseRgn :Rgn)
         (PenPat (value (car l)))
         (PaintRgn :Rgn) >

<de calView ()
   (camera FocLen Delta Tilt)
   (plane Angle)
   (SetPortBits :Bits)
   (EraseRect '#:Box)
   (localClip :Paper
      (FrameRect :Paper)
      (if (minusp Tilt)
         (if (lessp Angle 4500)
            (if (lessp (abs Tilt) Angle)
               (calRgn '(#:TopView #:LeftView #:FrontView))
               (calRgn '(#:LeftView #:TopView #:FrontView)) )
            (if (lessp (abs Tilt) (sub 9000 Angle))
               (calRgn '(#:TopView #:FrontView #:LeftView))
               (calRgn '(#:FrontView #:TopView #:LeftView)) ) )
         (if (lessp Angle 4500)
            (if (lessp Tilt Angle)
               (calRgn '(#:BottomView #:LeftView #:FrontView))
               (calRgn '(#:LeftView #:BottomView #:FrontView)) )
            (if (lessp Tilt (sub 9000 Angle))
               (calRgn '(#:BottomView #:FrontView #:LeftView))
               (calRgn '(#:FrontView #:BottomView #:LeftView)) ) ) )
      (SetPortBits :Save)
      (CopyBits :Bits (portMap Port) '#:Box '#:Box #srcCopy)
      (PenNormal) >

<de calGet (dlg)
   (setq
      :Size (mul 1000 (number (GetIText (d-item dlg 3)) 1))
      Angle (mul 10 (number (GetIText (d-item dlg 4)) 1))
      Tilt (mul 10 (number (GetIText (d-item dlg 5)) 1))
      FocLen (mul 40000 (number (GetIText (d-item dlg 6))))
      Delta (mul 1000 (number (GetIText (d-item dlg 8)) 1)) >

<de calPut (dlg)
   (SetIText (d-item dlg 4) (format (div Angle 10) 1))
   (SetIText (d-item dlg 5) (format (div Tilt 10) 1))
   (SetIText (d-item dlg 6) (format (div FocLen 40000)))
   (SetCtlValue (d-item dlg 7) (div FocLen 40000))
   (SetIText (d-item dlg 8) (format (div Delta 10000)))
   (SetCtlValue (d-item dlg 9) (div Delta 10000)) >

<de calFilter (dlg ev itemHit)
   (local (pt u pt2 part cntl)
      (SetCursor
         (if (inEdit dlg)
            (ptr (GetCursor #iBeamCursor))
            Arrow ) )
      (case (ev-what ev)
         (#mouseDown
            (setq
               pt (GlobalToLocal (ev-where ev))
               part (FindControl pt dlg cntl) )
            (cond
               ((inRect pt '#:U-Box)
                  (setq u (popup #(car :U-Box) Units Unit))
                  (popupBox '#:U-Box (setq Unit u)) )
               ((inRect pt :Paper)
                  (while (StillDown)
                     (setq
                        pt2 (GetMouse)
                        Angle (limit
                           (add Angle (mul 99 (sub (car pt2) (car pt))))
                           0 9000 )
                        Tilt (limit
                           (add Tilt (mul 99 (sub (cdr pt) (cdr pt2))))
                           -9000 +9000 ) )
                     (setq pt pt2)
                     (calView)
                     (calPut dlg) ) )
               ((eq cntl (d-item dlg 7))
                  (scroll pt part cntl
                     SetIText (d-item dlg 6)
                     (format (GetCtlValue cntl)) )
                  (calGet dlg)
                  (calView) )
               ((eq cntl (d-item dlg 9))
                  (scroll pt part cntl
                     SetIText (d-item dlg 8)
                     (format (GetCtlValue cntl)) )
                  (calGet dlg)
                  (calView) ) )
            NIL )
         ((#keyDown #autoKey)
            (case (bitAnd #charCodeMask (ev-message ev))
               ((3 13) (hiCtl dlg 1) (word itemHit 1))
               (27 (hiCtl dlg 2) (word itemHit 2))
               (#helpKey
                  (when Help
                     (Help)
                     (boldItem dlg 1)
                     (word itemHit 9999) ) )
               (^I (calGet dlg) (calView) NIL)
               ("^H.0123456789")
               (\-
                  (unless (eq (d-item dlg 6) (d-item dlg (d-edit dlg)))
                     (word itemHit 9999) ) )
               ((28 29 30 31)) [Cursor Keys]
               (32 (calGet dlg) (calView) (word itemHit 9999))
               (T (word itemHit 9999)) ) )
         (#updateEvt
            (popupBox '#:U-Box Unit)
            (MoveTo 10 30) (Line 180 0)
            (MoveTo 10 160) (Line 180 0)
            (MoveTo 10 296) (Line 180 0)
            (MoveTo 150 106) (DrawChar \o)
            (MoveTo 150 176) (DrawChar \o)
            (MoveTo 145 212) (DrawString "mm")
            [(FrameRect '#:Box)]
            (calView)
            NIL >

<de calDialog ()
   (local (r h v dlg itemHit)
      (setq
         r (car (currPaper))
         h (p-mm (sub (right r) (left r)) 10000)
         v (p-mm (sub (bottom r) (top r)) 10000)
         :Scale (max 1
            (div h #(sub (right :Box) (left :Box)))
            (div v #(sub (bottom :Box) (top :Box))) )
         h (div h :Scale)
         v (div v :Scale)
         :Paper (cons2
            (sub #:Org-h (div2 h))
            (sub #:Org-v (div2 v))
            (add #:Org-h (div2 h))
            (add #:Org-v (div2 v)) )
         :Bits (newBitMap '#:Box)
         :Save (alloc 14)
         :Rgn (NewRgn) )
      (localPort
         (setq dlg
            (dialog #dBoxProc NIL NIL (0.0) 530 340
               #btnCtrl (110.310) 70 20 #(str "Ok")
               #btnCtrl (15.310) 70 20 #(str "Cancel")
               #editText (100.70) 48 16 (format (div :Size 1000) 1)
               #editText (100.100) 40 16 (format (div Angle 10) 1)
               #editText (100.170) 40 16 (format (div Tilt 10) 1)
               #editText (100.200) 36 16 (format (div FocLen 40000))
               #resCtrl (10.220) 180 20 #focLenBar
               #editText (100.250) 36 16 (format (div Delta 10000))
               #resCtrl (10.270) 180 20 #deltaBar
               #statText (22.10) 170 16 #(str "View calibration box:")
               #statText (20.40) 50 16 #(str "Unit")
               #statText (20.70) 70 16 #(str "Cube Size")
               #statText (20.100) 50 16 #(str "Angle")
               #statText (20.140) 60 16 #(str "Camera:")
               #statText (20.170) 50 16 #(str "Tilt")
               #statText (20.200) 50 16 #(str "FocLen")
               #statText (20.250) 60 16 #(str "Distance")
               ) )
         (block (portMap dlg) :Save 14)
         (SelIText dlg 3 0 9999)
         (boldItem dlg 1)
         (while (lessp 2 (ModalDialog calFilter itemHit))) )
      (prog1
         (when (onep itemHit)
            (calGet dlg)
            T )
         (DisposDialog dlg)
         (DisposeRgn :Rgn)
         (free :Save)
         (zapBitMap :Bits) >

<de aboutDialog ()
   (local (dlg itemHit)
      (setq dlg
         (dialog #dBoxProc NIL NIL (0.0) 240 150
            #btnCtrl (40.110) 50 20 #(str "Ok")
            #statText (70.30) 160 20 "ViewPoint 1.0"
            #statText (60.60) 160 20 "BUG Europe 1993" ) )
      (boldItem dlg 1)
      (until (onep (ModalDialog doDlg itemHit)))
      (DisposDialog dlg) >

T
