[draw.l 30jan93]

<de line1 (wp1 wp2)
   (MoveTo (hLocal (w-h wp1)) (vLocal (w-v wp1)))
   (LineTo (hLocal (w-h wp2)) (vLocal (w-v wp2))) >

<de line2 (h1 v1 h2 v2)
   (MoveTo (hLocal h1) (vLocal v1))
   (LineTo (hLocal h2) (vLocal v2)) >

<de drawPoly ()
   (mapc2 (cdr Poly) Poly line1) >

<de drawPaper ()
   (local (r h1 v1 h2 v2)
      (with App
         (PenNormal)
         (PenSize 2 2)
         (PenPat LtGray)
         (setq
            r (car (slot paper))
            h1 (fdiv (left r) (slot scale))
            v1 (fdiv (top r) (slot scale))
            h2 (fdiv (right r) (slot scale))
            v2 (fdiv (bottom r) (slot scale)) )
         (MoveTo h1 v1)
         (LineTo h2 v1)
         (LineTo h2 v2)
         (LineTo h1 v2)
         (LineTo h1 v1) >

<de drawGrid ()
   (PenNormal)
   (PenSize 2 2)
   (PenPat LtGray)
   (line2 0 0 (vp1-h) (vp-v))
   (line2 0 0 (vp2-h) (vp-v))
   (line2 0 0 0 (nadir)) >

[++++++
<de drawGrid ()
   (with App
      (PenNormal)
      (PenSize 2 2)
      (mapc (slot grid)
         '((pt)
            (MoveTo
               (sub1 (hLocal (car pt)))
               (sub1 (vLocal (cdr pt))) )
            (Line 0 0) >
++++++]

<de drawPage (obj rsl sh sv)
   (local (h v)
      (PenNormal)
      (with obj
         (setq
            h (slot org-h)
            v (slot org-v) )
         (mapc (slot data)
            '((w)
               [(ForeColor (high (car w)))]
               (PenPat (nth (middle (car w)) Patterns))
               (PenSize
                  (max 1 (muldiv 100 (low (car w)) sh))
                  (max 1 (muldiv 100 (low (car w)) sv)) )
               (draw (cdr w) rsl
                  '((h1 v1 h2 v2)
                     (MoveTo
                        (div (add h1 h) sh) [Inline 'hLocal']
                        (div (add v1 v) sv) )
                     (LineTo
                        (div (add h2 h) sh)
                        (div (add v2 v) sv) >

[+++++
<de drawPage (obj scl dpi)
   (PenNormal)
   (with obj
      (all draw (slot data)
         (slot org-h) (slot org-v)
         scl (p-mm 60 (div scl dpi)) >
++++++]

[+ Drag to select a rectangular area +]
<de dragSelect (pt)
   (local (pt2)
      (and
         (setq pt2
            (click ptGlobal NIL NIL pt
               '((oPt nPt)
                  (PenPat Gray)
                  (FrameRect
                     (bounds (ptLocal oPt) (ptLocal nPt)) ) )
               NIL T ) )
         (bounds pt pt2) >

[+ Create a bitmap +]
<de newBitMap (r)
   (local (h v b n)
      (setq
         h (sub (right r) (left r))
         v (sub (bottom r) (top r))
         b (alloc 14)
         n (mul2 (div (add h 15) 16)) )
      (ptr b (alloc (mul v n))) [baseAdr]
      (word (add 4 b) n) [rowBytes]
      (rect (add 6 b) r) [bounds]
      b >

<de zapBitMap (b)
   (free (ptr b))
   (free b) >

T
