[dxf.l 24jan93]

      '(SECTION ENDSEC HEADER TABLES BLOCKS ENTITIES)
      '(TABLE LTYPE ENDTAB BLOCK ENDBLK SOLID SEQEND)
      '(LINE CIRCLE ARC POLYLINE VERTEX)

<de dxfGroup (fd)
   (local (l n)
      (and
         (setq l (getLine fd))
         (setq n (number l))
         (setq l (getLine fd))
         (if (zerop n)
            (unless (equal l "EOF")
               (symbol l) )
            (cons n
               (cond
                  ((or (leq 10 n 58) (leq 210 n 230) (leq 1010 n 1058))
                     (number l 4) )
                  ((leq 62 n 78) [Integer]
                     (number l) )
                  (T l) > [String]

<de dxfSection (fd)
   (local (l p x)
      (when
         (loop
            (NIL (setq x (dxfGroup fd)))
            (T (equal x 'SECTION)
               (eq 2 (car (setq x (dxfGroup fd)))) ) )
         (setq l (setq p (list (symbol (cdr x)))))
         (while
            (and
               (setq x (dxfGroup fd))
               (not (equal x 'ENDSEC)) )
            (link l p x) )
         l >

<de dxfHeader (x)
   x >

<de dxfTables (x)
   x >

<de dxfBlocks (x)
   (local (l1 p1 l2 p2)
      (off l1)
      (while x
         (off l2)
         (while (and x (neq 'BLOCK (car x)))
            (pop x) )
         (while (and x (neq 'ENDBLK (car x)))
            (link l2 p2 (pop x)) )
         (when l2
            (link l1 p1 l2) ) )
      l1 >

<de dxfEntities (x)
   (local (l1 p1 l2 p2)
      (off l1)
      (while x
         (while (and x (not (symbolp (car x))))
            (pop x) )
         (setq l2 (setq p2 (list (pop x))))
         (while (and x (not (symbolp (car x))))
            (link l2 p2 (pop x)) )
         (link l1 p1 l2) )
      l1 >

<de dxf (nm)
   (local (fd l p x)
      (when (setq fd (open nm))
         (off l)
         (while (setq x (dxfSection fd))
            (case (car x)
               (HEADER
                  (link l p
                     (cons 'HEADER
                        (dxfHeader (cdr x)) ) ) )
               (TABLES
                  (link l p
                     (cons 'TABLES
                        (dxfTables (cdr x)) ) ) )
               (BLOCKS
                  (link l p
                     (cons 'BLOCKS
                        (dxfBlocks (cdr x)) ) ) )
               (ENTITIES
                  (link l p
                     (cons 'ENTITIES
                        (dxfEntities (cdr x)) ) ) ) ) )
         (close fd)
         l >

<de arcPt (h v r a)
   (cons
      (add h (fmul r (cos a 10000)))
      (sub (fmul r (sin (minus a) 10000)) v) >

<de rdDxf (nm)
   (local (g p l x)
      (off g)
      (setq l (cdr (assoc 'ENTITIES (dxf nm))))
      (while (setq x (pop l))
         (case (pop x)
            (LINE
               (local (h1 v1 h2 v2)
                  (and
                     (setq h1 (cdr (assoc 10 x)))
                     (setq v1 (cdr (assoc 20 x)))
                     (setq h2 (cdr (assoc 11 x)))
                     (setq v2 (cdr (assoc 21 x)))
                     (link g p
                        (list
                           (cons h1 (minus v1))
                           (cons h2 (minus v2)) ) ) ) ) )
            (ARC
               (local (h v r a e)
                  (and
                     (setq h (cdr (assoc 10 x)))
                     (setq v (cdr (assoc 20 x)))
                     (setq r (cdr (assoc 40 x)))
                     (setq a (cdr (assoc 50 x)))
                     (setq e (cdr (assoc 51 x)))
                     (setq x
                        (arcBez
                           (arcPt h v r a)
                           (cons h (minus v))
                           (arcPt h v r e)
                           T ) )
                     (link g p x) ) ) )
            (CIRCLE
               (local (h v r)
                  (and
                     (setq h (cdr (assoc 10 x)))
                     (setq v (cdr (assoc 20 x)))
                     (setq r (cdr (assoc 40 x)))
                     (setq x
                        (arcBez
                           (cons h (sub r v))
                           (cons h (minus v))
                           (cons h (sub r v))
                           T ) )
                     (link g p x) ) ) )
            (POLYLINE
               (local (z q f h v)
                  (off z)
                  (setq f (and (setq x (cdr (assoc 70 x))) (bit 0 x)))
                  (while (and (setq x (pop l)) (eq 'VERTEX (pop x)))
                     (and
                        (setq h (cdr (assoc 10 x)))
                        (setq v (cdr (assoc 20 x)))
                        (link z q (cons h (minus v))) ) )
                  (when f
                     (link z q (car z)) )
                  (link g p z) ) ) ) )
      g >

<de dxfCmd ()
   (local (nm g)
      (and
         (setq nm (getFile "TEXT"))
         (busy #(div2 cells)
            (setq g (rdDxf nm))
            (makeWire #(str "Import")
               (mapcar g
                  '((z)
                     (zGraf z
                        (if VP
                           '((y z)
                              (xyz-wp (x-rot 0 y) (y-rot 0 y) z) )
                           '((y x)
                              (xyz-wp (x-rot x y) (y-rot x y) 0) >

T
