[file.l 08jan93]

<de openJournal ()
   (unless (boundp 'Drvr)
      (OpenDriver ".auto" Drvr)
      (word 08E8 Drvr) [JournalRef] >

<de jnlCmd ()
   (local (s)
      (when (setq s (putFile "Journal File"))
         (openJournal)
         (setq JFile (create s))
         (fType s "auto")
         (Control Drvr 18 JFile) [+ Set refNum +]
         (word 08DE 1) >

<de stopJnlCmd ()
   (word 08DE 0) [+ JournalFlag off +]
   (close JFile)
   (off JFile) >

<de doPlay ()
   (openJournal)
   (local (nm)
      (when JFile
         (close JFile)
         (off JFile) )
      (localVol (GetVol)
         (when (setq nm (getFile "auto" ["TEXT"]))
            (if (equal "auto" (fType nm))
               (setq
                  JFile (open nm)
                  Batch )
               (setq
                  Batch (cons (GetVol) (open nm))
                  JFile (open (getLine (cdr Batch))) ) )
            (Control Drvr 18 JFile)
            (word 08DE -1) >

<de doSave (obj nm vol)
   (local (fd)
      (with obj
         (when
            (or
               nm
               (setq nm (putFile #(str "Save") (slot name))) )
            (busy #(div2 cells)
               (localVol (slot vol (or vol (GetVol)))
                  (when (setq fd (create nm))
                     (SetWTitle (slot winPtr) (slot name nm))
                     (print (slot view) fd)
                     (print (slot scale) fd)
                     (print (slot paper) fd)
                     (print (slot org-h) fd)
                     (print (slot org-v) fd)
                     (print (slot angle) fd)
                     (print (slot tilt) fd)
                     (print (slot focLen) fd)
                     (print (slot delta) fd)
                     (print (slot style) fd)
                     (print (length (slot data)) fd)
                     (mapc (slot data) '((w) (print w fd)))
                     (print
                        (stuff (ptr (ref (slot hPrint))) #TPSize)
                        fd )
                     (close fd)
                     (fType nm FType)
                     (remove obj 'dirty) >

<de doRead (fd scl p)
   (busy #(div2 cells)
      (slot scale scl)
      (slot paper p)
      (slot org-h (read fd))
      (slot org-v (read fd))
      (slot angle (read fd))
      (slot tilt (read fd))
      (slot focLen (read fd))
      (slot delta (read fd))
      (slot style (read fd))
      (local (l p)
         (off l)
         (reptn (read fd)
            (link l p (read fd)) )
         (slot data l) )
      (slot hPrint (dynamo DisposHandle (NewHandle #TPSize)))
      (stuff (ptr (ref (slot hPrint))) (read fd)) >

<de doOpen (nm)
   (local (fd r scl p obj)
      (when (setq fd (open nm))
         (setq  r (read fd)  scl (read fd)  p (read fd))
         (with
            (setq obj
               (new 'viewPoint (cons 90 (add 30 (word MBarHeight)))
                  (fdiv (right p) scl)
                  (fdiv (bottom p) scl)
                  nm r ) )
            (slot name nm)
            (slot vol (GetVol))
            (doRead fd scl p)
            (close fd)
            (setVanish obj) >

T
