[graf.l 27jan93]

<de zGraf (:z :foo)
   (mapcar :z
      '((:x)
         (if (pointp :x)
            (:foo (car :x) (cdr :x))
            (cons
               (:foo (caar :x) (cdar :x))
               (:foo (cadr :x) (cddr :x)) >

[+ Convert circle to graf +]
<de span (ph pv sh sv m f)
   (unless f
      (xchg ph sh)
      (xchg pv sv) )
   (local (h v n)
      (setq
         h (sub sh ph)
         v (sub sv pv)
         n (pythag (sub ph (car m)) (sub pv (cdr m))) )
      (if (and (zerop h) (zerop v))
         (if f 100 -100)
         (muldiv
            (mul
               (sign
                  (add
                     (muldiv h (sub pv (cdr m)) n)
                     (muldiv v (sub (car m) ph) n) ) )
               (sub (pythag h v) (mul2 n)) )
            100
            (mul2 n) >

<de arcb2 (ph pv sh sv h v d m r)
   (local (uv uh h1 v1 h2 v2 d1 d2)
      (setq
         uh (add (car m) (muldiv (sub h (car m)) r d))
         uv (add (cdr m) (muldiv (sub v (cdr m)) r d))
         h1 (div2 (add ph uh))
         v1 (div2 (add pv uv))
         h2 (div2 (add uh sh))
         v2 (div2 (add uv sv))
         d1 (pythag (sub h1 (car m)) (sub v1 (cdr m)))
         d2 (pythag (sub h2 (car m)) (sub v2 (cdr m))) )
      (if (lessp (dist (cons ph pv) (cons sh sv)) r)
         (list
            (bezier
               ph pv
               (add (car m) (muldiv (sub h1 (car m)) r d1))
               (add (cdr m) (muldiv (sub v1 (cdr m)) r d1))
               (add (car m) (muldiv (sub h2 (car m)) r d2))
               (add (cdr m) (muldiv (sub v2 (cdr m)) r d2))
               sh sv )
            (cons sh sv) )
         (nconc
            (arcb2 ph pv uh uv h1 v1 d1 m r)
            (arcb2 uh uv sh sv h2 v2 d2 m r) >

<de arcb1 (ph pv sh sv m r)
   (local (h v)
      (setq
         h (div2 (add ph sh))
         v (div2 (add pv sv)) )
      (arcb2 ph pv sh sv h v
         (pythag (sub h (car m)) (sub v (cdr m)))
         m r) >

<de arcBez (pa m pe f)
   (local (ph pv sh sv r res h v)
      (setq
         ph (car pa)
         pv (cdr pa)
         sh (car pe)
         sv (cdr pe)
         r (min
            (pythag (sub ph (car m)) (sub pv (cdr m)))
            (pythag (sub sh (car m)) (sub sv (cdr m))) ) )
      (unless (zerop r)
         (setq res (list pa))
         (while (lessp -10 (span ph pv sh sv m f))
            (if f
               (setq
                  h (add (car m) pv (minus (cdr m)))
                  v (add (cdr m) (car m) (minus ph)) )
               (setq
                  h (add (car m) (cdr m) (minus pv))
                  v (add (cdr m) ph (minus (car m))) ) )
            (nconc res (arcb1 ph pv h v m r))
            (setq  ph h  pv v) )
         (nconc res (arcb1 ph pv sh sv m r)) >

<de secBez (n p q r s)
   (if (minusp (dec n))
      (sift
         (intsec :pt1 :pt2 p q)
         (intsec :pt1 :pt2 q r)
         (intsec :pt1 :pt2 r s) )
      (local (a b c d e f)
         (setq
            a (midPt p q)
            b (midPt q r)
            c (midPt r s)
            d (midPt a b)
            e (midPt b c)
            f (midPt d e) )
         (nconc
            (secBez n p a d f)
            (secBez n f e c s) >

[+ Intersect graf with a line +]
<de secGraf (g :pt1 :pt2)
   (mapcan g
      '((z)
         (local (l pt p)
            (setq l)
            (when (setq pt (pop z))
               (while z
                  (setq l
                     (nconc l
                        (if (pointp (caar z))
                           (when
                              (setq p
                                 (intsec :pt1 :pt2 (w-hv pt)
                                    (w-hv (setq pt (pop z))) ) )
                              (list p) )
                           (secBez 5
                              (w-hv pt)
                              (w-hv (caar z))
                              (w-hv (cdr (pop z)))
                              (w-hv (setq pt (pop z))) ) ) ) ) ) )
            l >

[+ Construct Unity Circle +]
(setq UCirc (arcBez (0 . -5000000) (0 . 0) (0 . -5000000) T))

[+ Highlighting +]
<de hiDot (h v)
   (PenSize #dotSiz #dotSiz)
   (MoveTo
      (sub (hLocal h) #(div2 dotSiz))
      (sub (vLocal v) #(div2 dotSiz)) )
   (Line 0 0) >

<de hiDot1 (:wp1 wp2)
   (hiDot (w-h wp2) (w-v wp2)) >

<de wpDot (wp)
   (when (pointp (car wp))
      (hiDot (w-h wp) (w-v wp)) >

[+ Mark/Select - Unmark/Deselect +]
<de mark (w)
   (unless (memq w Mark)
      (push w Mark)
      (inval w) >

<de unMark (w)
   (when (memq w Mark)
      (inval w)
      (setq Mark (delete w Mark)) >

<de selGrafs (lst foo)
   (when (or lst Mark)
      (make #(str "Selection") NIL
         (list Mark)
         '((l)
            (mapc Mark unMark)
            (mapc l mark) )
         (list lst)
         foo >

[+ Drawing +]
<de doDraw (g)
   (with App
      (localClip (slot view)
         (draw g (p-mm 1 (slot scale)) line2) >

[+ Install a list of grafs +]
<de putData (lst)
   (mapc Mark unMark)
   [(mapc lst inval)]
   (with App
      (slot data (append (slot data) lst))
      (mapc lst mark) >

[+ Remove a list of grafs +]
<de removeData (lst)
   (with App
      (mapc lst
         '((w)
            (inval w)
            (slot data (delete w (slot data)))
            (setq Mark (delete w Mark)) >

<de undoList (m d)
   (mapc Mark inval)
   (mapc (setq Mark m) inval)
   (with App (slot data d)) >

<de makeList (lst)
   (with App
      (mapc Mark inval)
      (mapc Mark
         '((w) (slot data (delete w (slot data)))) )
      (mapc lst inval)
      (mapc (setq Mark lst)
         '((w) (slot data (cons w (slot data)))) >

<de mvGraf (g dh dv)
   (graf g
      '((pt)
         (cons
            (add dh (car pt))
            (add dv (cdr pt)) >

[++++++ ?
<de msrPt (vp1 vp2)
   (local (d1 d2)
      (setq
         d1 (pythag (car vp1) (cdr vp1))
         d2 (distPt vp1 vp2) )
      (cons
         (add (car vp1)
            (muldiv (sub (car vp2) (car vp1)) d1 d2) )
         (add (cdr vp1)
            (muldiv (sub (cdr vp2) (cdr vp1)) d1 d2) >
++++++]

<de vpMove (lst wp1 wp2)
   (dMove lst
      (sub (w-x wp2) (w-x wp1))
      (sub (w-y wp2) (w-y wp1))
      (sub (w-z wp2) (w-z wp1)) >

<de dMove (lst dx dy dz)
   (mapcar lst
      '((w)
         (cons
            (car w)
            (graf (cdr w)
               '((wp)
                  (xyz-wp
                     (add dx (w-x wp))
                     (add dy (w-y wp))
                     (add dz (w-z wp)) >

<de vpMirror (lst wp0)
   (mapcar lst
      '((w)
         (cons
            (car w)
            (graf (cdr w) '((wp) (mirror wp wp0))) >

<de vpResize (lst wp0 wp1 wp2)
   (local (x0 y0 dx1 dy1 dz1 dx2 dy2 dz2 x y)
      (setq
         x0 (rot-x wp0)
         y0 (rot-y wp0)
         dx1 (sub (rot-x wp1) x0)
         dy1 (sub (rot-y wp1) y0)
         dz1 (sub (w-z wp1) (w-z wp0))
         dx2 (sub (rot-x wp2) x0)
         dy2 (sub (rot-y wp2) y0)
         dz2 (sub (w-z wp2) (w-z wp0)) )
      (mapcar lst
         '((w)
            (cons
               (car w)
               (graf (cdr w)
                  '((wp)
                     (setq
                        x (rot-x wp)
                        y (rot-y wp) )
                     (when (mdchk (sub x x0) dx2 dx1)
                        (setq x (add it x0)) )
                     (when (mdchk (sub y y0) dy2 dy1)
                        (setq y (add it y0)) )
                     (xyz-wp
                        (x-rot x y)
                        (y-rot x y)
                        (if (mdchk (sub (w-z wp) (w-z wp0)) dz2 dz1)
                           (add it (w-z wp0))
                           (w-z wp) >

<de vpRotate (lst wp0 wp1 wp2)
   (if VP
      <local (x y z c ang)
         (setq
            c (cons (rot-y wp0) (w-z wp0))
            ang (winkel
               (cons (rot-y wp1) (w-z wp1))
               c
               (cons (rot-y wp2) (w-z wp2)) ) )
         (mapcar lst
            '((w)
               (cons
                  (car w)
                  (graf (cdr w)
                     '((wp)
                        (setq
                           x (rot-x wp)
                           y (rot-h (rot-y wp) (w-z wp) c ang)
                           z (rot-v (rot-y wp) (w-z wp) c ang) )
                        (xyz-wp (x-rot x y) (y-rot x y) z) >
      <local (c ang)
         (setq
            c (w-xy wp0)
            ang (winkel (w-xy wp1) c (w-xy wp2)) )
         (mapcar lst
            '((w)
               (cons
                  (car w)
                  (graf (cdr w)
                     '((wp)
                        (xyz-wp
                           (rot-h (w-x wp) (w-y wp) c ang)
                           (rot-v (w-x wp) (w-y wp) c ang)
                           (w-z wp) > >

T
