[main.l 30jan93]

<de init ()
   (stack 60)
   (reptn 6 (MoreMasters))
   (when (gc #cells)
      (readStrings)
      (setq
         Event (alloc 16)
         Patterns (list Black)
         IMBar (idleMBar)
         VpMBar (vpMBar)
         CalMBar (calMBar)
         VpPal (vpPalette)
         Tools (toolPalette) )
      (do init 'spot)
      (do setUp (setq App 'idle))
      (while Argv
         (cond
            ((equal FType (fType (car Argv)))
               (doOpen (pop Argv)) )
            (T (pop Argv)) ) )
      (run) >

<de cleanUp ()
>

<de vpMBar ()
   (mkMBar
      (d  is dirty App)
      (nm get App 'name)
      (s get App 'scale)
      ((#appleMark)
         ("" #(str "About ViewPoint ..") T (aboutDialog))
         [("-")] )
      (#(str "File")
         ("/O" #(str "Open ..") T (openCmd))
         ("/N" #(str "New") T (newCmd))
         ("-")
         ("" #(str "Import Illustrator ..") T (adobeCmd))
         ("" #(str "Import DXF ..") T (dxfCmd))
         ("-")
         ("/W" #(str "Close") T (do close App))
         ("/S" #(str "Save") d (saveCmd))
         ("" #(str "Save as ..") T (doSave App))
         ("" #(str "Revert") (and d nm) (revertCmd))
         ("-")
         ("" #(str "Page Setup ..") T (prSetup App))
         ("/P" #(str "Print ..") T (doPrint App))
         ("-")
         [# -debug
         ("" "Refresh" T (do inval App))
         ]
         ("/Q" #(str "Quit") T (on Done)) )
      (#(str "Edit")
         ("/Z" #(str "Undo") Undo (doUndo))
         ("/R" #(str "Redo") Redo (doRedo))
         ("-")
         ("/X" #(str "Cut") Mark (cutCmd))
         ("/C" #(str "Copy") Mark (copyCmd))
         ("/V" #(str "Paste") Clip (pasteCmd))
         ("" #(str "Clear") Mark (clearCmd))
         ("/D" #(str "Duplicate") Mark (dupCmd))
         ("/A" #(str "Select All") (get App 'data) (allCmd)) )
      (#(str "Viewpoint")
         ("" #(str "Angle ..") T (setAngle App))
         ("" #(str "Perspective ..") T (setPerspective App))
         ("-")
         ("" #(str "Line Width ..") T (widthCmd))
         ("-")
         ("" #(str "Crosspoints") Mark (crossCmd))
         ("" #(str "Midpoint") d (midCmd))
         ("" #(str "Divide ..") d (divCmd))
         ("" #(str "Clear Points") (get App 'snap) (clearSnapCmd))
         ("-")
         ("/." #(str "Center") T (centerCmd))
         ("/+" #(str "Zoom Up") (lessp 625 s) (upCmd))
         ("/-" #(str "Zoom Down") (lessp s 40000) (dnCmd))
         )
      (#(str "Modify")
         ("" #(str "Move") Mark (moveCmd))
         [("" #(str "Move along Plane") Mark (moveCmd 'vp3))]
         [("" #(str "Move along Elevation") Mark (moveCmd 'vp2))]
         [("" #(str "Move along Side") Mark (moveCmd 'vp1))]
         [("-")]
         ("" #(str "Group") (lessp 1 (length Mark)) (groupCmd))
         ("" #(str "Ungroup")
            (find Mark '((w) (lessp 2 (length w))))
            (ungroupCmd) )
         ("" #(str "Mirror") Mark (mirrorCmd))
         ("" #(str "Resize") Mark (resizeCmd))
         ("" #(str "Rotate") Mark (rotateCmd))
         >

<de calMBar ()
   (mkMBar
      ("Cal"
         ("" "m" T (SysBeep 0))
         ("" "cm" T (SysBeep 0))
         ("" "inch" T (SysBeep 0))
         >

(object viewPoint picApp)

<to classify () 'viewPoint>

<to close (obj)
   (with obj
      (when
         (or
            (not (is dirty obj))
            (confirm
               (append
                  #(str "Save changes to: ")
                  (or (slot name) "Untitled")
                  "?" )
               doSave obj (slot name) (slot vol) ) )
         (from picApp close obj) >

<to setUp (App)
   (setMenu VpMBar)
   (do show VpPal)
   (do show Tools) >

<to begin (App)
   (put VpPal 'app App)
   (put Tools 'app App)
   (with App
      (camera (slot focLen) (slot delta) (slot tilt))
      (plane (slot angle) VP)
      (setq
         Undo (slot undo)
         Redo (slot redo)
         Mark (slot mark) ) )
   (setUndo)
   (setRedo) >

<to end (App)
   (with App
      (do hide 'spot)
      (slot undo Undo)
      (slot redo Redo)
      (slot mark Mark) >

<to cleanUp (App)
   (do hide VpPal)
   (do hide Tools) >

<to click (App win pt)
   (cond
      ((and SpaceBar [(a-key)] (eq win (get App 'winPtr)))
         (vpSlide (GlobalToLocal pt))
         T )
      ((eq win (get VpPal 'winPtr))
         (do inval App)
         (do content VpPal pt)
         T >

<to keyDown (App c)
   (case c
      (32 (on SpaceBar))
      >

<to keyUp (App c)
   (case c
      (32 (off SpaceBar))
      >

<to content (App pt)
   (from picApp content App pt (if SpaceBar vpSlide VpFoo)) >

<to update (App)
   (from docWin update App
      '(()
         (busy #(div cells 8)
            (with App
               (EraseRect (portRect Port))
               (drawPaper)
               (drawGrid)
               (drawPage App
                  (div (slot scale) 4)
                  (dpiScale 72 (slot scale))
                  (dpiScale 72 (slot scale)) )
               (drawPoly)
               (mapc (slot snap) wpDot)
               (mapc (if (eq Port (FrontWindow)) Mark (slot mark))
                  hilite >

<to setCursor (App pt)
   (with App
      (localPort (slot winPtr)
         (and
            SpaceBar [(a-key)]
            (eq Port (FrontWindow))
            (GlobalToLocal pt)
            (inView pt)
            (SetCursor (ptr (GetCursor #plusCursor))) >

T
