[prim.l 14feb93]

[++++++
<de hvSpot (pt)
   (do print 'spot
      (append
         "H: " (format (div (car pt) 1000) 1)
         " mm  V: " (format (div (cdr pt) 1000) 1) " mm" >
++++++]

<de vpSpot (wp wp0)
   (local (x y)
      (setq
         x (rot-x wp)
         y (rot-y wp) )
      (do print 'spot
         (append
            (format (div x 1000) 1)
            ", "
            (format (div y 1000) 1)
            ", "
            (format (div (w-z wp) 1000) 1)
            (when wp0
               (append
                  " : "
                  (format
                     (div
                        (math
                           (sub (w-x wp) (w-x wp0)) "#*"
                           (sub (w-y wp) (w-y wp0)) "#*+"
                           (sub (w-z wp) (w-z wp0)) "#*+q." )
                        1000)
                     1 >

<de setVanish (obj)
   (with obj
      (camera (slot focLen) (slot delta) (slot tilt))
      (plane (slot angle) VP)
      (do inval obj) >

<de currPaper ()
   (if (eq 'viewPoint (may classify App))
      (get App 'paper)
      (local (h)
         (when (PrOpen)
            (PrintDefault (setq h (NewHandle #TPSize)))
            (PrClose)
            (prog1
               (paper h)
               (DisposHandle h) >

<de makeWire (s l)
   (make s T
      (list Mark)
      '((l)
         (removeData Mark)
         (mapc l mark) )
      (list
         (with App
            (cons (slot style) l)) )
      '((w)
         (mapc Mark unMark)
         (with App
            (slot data (cons w (slot data))) )
         (mark w) >

<de makeModify (s l)
   (make s T
      (list Mark (get App 'data))
      undoList
      (list l)
      makeList >

<de makeSnap (s lst)
   (when lst
      (make s NIL
         (list (get App 'snap))
         '((l)
            (with App
               (mapc (slot snap) invalPt)
               (mapc (slot snap l) invalPt) ) )
         (list lst)
         '((l)
            (with App
               (mapc l invalPt)
               (slot snap (append l (slot snap))) >

<de vpSlide (pt)
   (with App
      (make #(str "Slide") T
         (list (slot org-h) (slot org-v))
         '((h v)
            (with App
               (slot org-h h)
               (slot org-v v) )
            (do inval App) )
         (list (do slide App pt))
         '((pt)
            (with App
               (slot org-h
                  (add (slot org-h) (p-mm (car pt) (slot scale))) )
               (slot org-v
                  (add (slot org-v) (p-mm (cdr pt) (slot scale))) )
               (do inval App) >

<de snap1 (x)
   (and
      (pointp (car x))
      (lessp (dist (w-hv :wp2) (w-hv x)) (dist (w-hv :wp2) (w-hv Snap1)))
      (setq Snap1 x) >

<de vpSnap (:wp1 :wp2)
   (off Snap1)
   (if (o-key)
      (with App
         (setq Snap1 '((0 . 0) (0 . 0) . 0))
         (mapc (slot snap) snap1)
         (mapc Poly snap1)
         (mapc (slot data)
            '((w)
               (mapc (cdr w) '((z) (mapc z snap1))) ) )
         Snap1 )
      :wp2 >

<de snapOk (pt)
   (when pt
      (setq Snap (or Snap Snap1 pt)) >

<de secZug (z)
   (mapcan z
      '((x)
         (and
            (atom (car x))
            (setq x (intsec :a :b (w-hv x) :p T))
            (list x) >

<de secPoints (:a :b :p)
   (with App
      (nconc
         (secZug Poly)
         (mapcan (slot data)
            '((w)
               (mapcan (cdr w) secZug) >

[++++++
<de vpStiff1 (pt1 pt2 vp1 vp2)
   (local (d1 d2 a b)
      (setq
         d2 (distPt pt1 vp1)
         d1 [(min d2] (distPt pt1 pt2)[)]
         a (if (zerop d2)
            vp1
            (cons
               #(fix (car pt1) + ((car vp1)-(car pt1))*d1/d2)
               #(fix (cdr pt1) + ((cdr vp1)-(cdr pt1))*d1/d2) ) )
         b (cons
            #(fix 2*(car pt1) - (car a))
            #(fix 2*(cdr pt1) - (cdr a)) ) )
      (when (lessp (dist pt2 b) (dist pt2 a))
         (xchg a b) )
      (if (o-key)
         (worst
            [(nconc]
               [(secPoints a b vp1)]
               (secPoints a b vp2) [)]
            '((p) (dist p pt2)) )
         a >
++++++]

<de vpStiff (wp1 wp2)
   (cond
      ((not wp1) wp2)
      ((s-key)
         (local (x y dx dy dz)
            (setq
               x (rot-x wp1)
               y (rot-y wp1)
               dy (sub (rot-y wp2) y) )
            (if VP
               (progn
                  (zero dx)
                  (setq dz (sub (w-z wp2) (w-z wp1)))
                  (if (lessp (abs dy) (abs dz))
                     (if (lessp (mul 3 (abs dy)) (abs dz))
                        (zero dy)
                        (setq dy (mul (sign dy) (abs dz))) )
                     (if (lessp (mul 3 (abs dz)) (abs dy))
                        (zero dz)
                        (setq dz (mul (sign dz) (abs dy))) ) ) )
               (progn
                  (zero dz)
                  (setq dx (sub (rot-x wp2) x))
                  (if (lessp (abs dy) (abs dx))
                     (if (lessp (mul 3 (abs dy)) (abs dx))
                        (zero dy)
                        (setq dy (mul (sign dy) (abs dx))) )
                     (if (lessp (mul 3 (abs dx)) (abs dy))
                        (zero dx)
                        (setq dx (mul (sign dx) (abs dy))) ) ) ) )
            (xyz-wp
               (x-rot (add x dx) (add y dy))
               (y-rot (add x dx) (add y dy))
               (add (w-z wp1) dz) ) ) )
      (T (vpSnap wp1 wp2)) >

[++++++
<de vpStiffRect (pt1 pt2)
   (cond
      ((not pt1) pt2)
      <(s-key)
         (when (o-key)
            (setq pt2
               (worst
                  (nconc
                     (secPoints pt1 pt2 (get App VP1))
                     (secPoints pt1 pt2 (get App VP2)) )
                  '((p) (dist p pt2)) ) ) )
         (local (a t f xy dx dy dz d)
            (with App
               (setq
                  a (vpAngle)
                  t (slot tilt)
                  f (slot focLen)
                  pt1 (hv-xyz (car pt1) (cdr pt1) a t f)
                  pt2 (hv-xyz (car pt2) (cdr pt2) a t f)
                  xy (rotate (cdr pt2) (cdr pt1) (slot angle))
                  dx (sub (car xy) (cadr pt1))
                  dy (sub (cdr xy) (cddr pt1))
                  dz (sub (car pt2) (car pt1))
                  d (max (abs dx) (abs dy) (abs dz))
                  dx (mul d (sign (div2 dx)))
                  dy (mul d (sign (div2 dy)))
                  dz (mul d (sign (div2 dz)))
                  xy (rotate
                     (cons (add dx (cadr pt1)) (add dy (cddr pt1)))
                     (cdr pt1)
                     (minus (slot angle)) ) )
               (xyz-hv (car xy) (cdr xy) (add dz (car pt1)) t f) >
      (T (vpSnap pt1 pt2)) >

<de vpStiffRect (pt1 pt2)
   (cond
      ((not pt1) pt2)
      <(s-key)
         (when (o-key)
            (setq pt2
               (worst
                  (nconc
                     (secPoints pt1 pt2 (get App VP1))
                     (secPoints pt1 pt2 (get App VP2)) )
                  '((p) (dist p pt2)) ) ) )
         (local (a t f xy dx dy dz d)
            (with App
               (setq
                  a (slot angle)
                  t (slot tilt)
                  f (slot focLen) )
               (case VP1
                  (vp1
                     (setq
                        pt1 (hv-xyz (car pt1) (cdr pt1))
                        pt2 (hv-xyz (car pt2) (cdr pt2))
                        xy (rotate (cdr pt2) (cdr pt1) a)
                        dx (sub (car xy) (cadr pt1))
                        dy (sub (cdr xy) (cddr pt1))
                        d (max (abs dx) (abs dy))
                        dx (mul d (sign dx))
                        dy (mul d (sign dy))
                        xy
                        (rotate
                           (cons (add dx (cadr pt1)) (add dy (cddr pt1)))
                           (cdr pt1)
                           (minus a) ) )
                     (xyz-hv (car xy) (cdr xy) (car pt1)) )
                  (vp2
                     (setq
                        pt1 (hv-xyz (car pt1) (cdr pt1))
                        pt2 (hv-xyz (car pt2) (cdr pt2))
                        xy (rotate (cdr pt2) (cdr pt1) a)
                        dx (sub (car xy) (cadr pt1))
                        dz (sub (car pt2) (car pt1))
                        d (max (abs dx) (abs dz))
                        dx (mul d (sign dx))
                        dz (mul d (sign dz))
                        xy
                        (rotate
                           (cons (add dx (cadr pt1)) (cddr pt1))
                           (cdr pt1)
                           (minus a) ) )
                     (xyz-hv (car xy) (cdr xy) (add dz (car pt1))) )
                  (T
                     (setq
                        pt1 (hv-xyz (car pt1) (cdr pt1))
                        pt2 (hv-xyz (car pt2) (cdr pt2))
                        xy (rotate (cdr pt2) (cdr pt1) a)
                        dy (sub (cdr xy) (cddr pt1))
                        dz (sub (car pt2) (car pt1))
                        d (max (abs dy) (abs dz))
                        dy (mul d (sign dy))
                        dz (mul d (sign dz))
                        xy
                        (rotate
                           (cons (cadr pt1) (add dy (cddr pt1)))
                           (cdr pt1)
                           (minus a) ) )
                     (xyz-hv (car xy) (cdr xy) (add dz (car pt1))) >
      (T (vpSnap pt1 pt2)) >
++++++]

<de vpRect (wp1 wp2)
   (local (x1 y1 x2 y2)
      (setq
         x1 (rot-x wp1)
         y1 (rot-y wp1)
         x2 (rot-x wp2)
         y2 (rot-y wp2) )
      (list
         (list
            wp1
            (xyz-wp (x-rot x1 y2) (y-rot x1 y2) (w-z wp1))
            wp2
            (xyz-wp (x-rot x2 y1) (y-rot x2 y1) (w-z wp2))
            wp1 >

<de vpElli (wp1 wp2)
   (if VP
      (local (x y1 y2 cy cz dy dz)
         (setq
            x (rot-x wp1)
            y1 (rot-y wp1)
            y2 (rot-y wp2)
            cy (div2 (add y1 y2))
            cz (div2 (add (w-z wp1) (w-z wp2)))
            dy (abs (sub y2 y1))
            dz (abs (sub (w-z wp2) (w-z wp1))) )
         (list
            (zGraf UCirc
               '((y z)
                  (setq
                     y (add cy (muldiv y dy 10000000))
                     z (add cz (muldiv z dz 10000000)) )
                  (xyz-wp (x-rot x y) (y-rot x y) z) ) ) ) )
      (local (x1 y1 x2 y2 cx cy dx dy)
         (setq
            x1 (rot-x wp1)
            y1 (rot-y wp1)
            x2 (rot-x wp2)
            y2 (rot-y wp2)
            cx (div2 (add x1 x2))
            cy (div2 (add y1 y2))
            dx (abs (sub x2 x1))
            dy (abs (sub y2 y1)) )
         (list
            (zGraf UCirc
               '((x y)
                  (setq
                     x (add cx (muldiv x dx 10000000))
                     y (add cy (muldiv y dy 10000000)) )
                  (xyz-wp (x-rot x y) (y-rot x y) (w-z wp1)) >

<de vpArc (pa p pe)
   (with App
      (if VP
         (local (x)
            (setq
               x (rot-x pa)
               pa (cons (rot-y pa) (w-z pa))
               p (cons (rot-y p) (w-z p))
               pe (cons (rot-y pe) (w-z pe)) )
            (when (center pa p pe)
               (list
                  (zGraf (arcBez pa it pe (rSyst pa p pe))
                     '((y z) (xyz-wp (x-rot x y) (y-rot x y) z)) ) ) ) )
         (local (z)
            (setq
               z (w-z pa)
               pa (w-xy pa)
               p (w-xy p)
               pe (w-xy pe) )
            (when (center pa p pe)
               (list
                  (zGraf (arcBez pa it pe (rSyst pa p pe))
                     '((x y) (xyz-wp x y z)) >

<de mkPoly (len)
   (local (wp Poly)
      (off Snap Snap1)
      (when (setq wp (click vpGlobal vpSnap vpSpot NIL hiDot1 snapOk))
         (setq Poly (list wp))
         (while
            (and
               (or (not len) (lessp (length Poly) len))
               (or
                  (setq wp
                     (click vpGlobal vpStiff vpSpot
                        (car Poly) line1 snapOk ) )
                  (c-key) ) )
            (if (c-key)
               (when (cdr Poly)
                  (line1 (pop Poly) (car Poly)) )
               (progn
                  (line1 (car Poly) wp)
                  (push wp Poly) ) ) )
         (and
            (leq 2 (length Poly))
            (or
               (not len)
               (eq len (length Poly))
               (progn (drawPoly) NIL) )
            Poly >

[++++++
<de mkGrid (obj dz dx)
   (with obj
      (cons
         (xyz-hv dx 0 dz)
         (cons (cons dx 0) dz) >

<de mkGrid (obj dz dx)
   (local (c f t ca sa res)
      (with obj
         (setq
            c (cons dx 0)
            f (slot focLen)
            t (slot tilt)
            ca (cos (slot angle) 100)
            sa (minus (sin (slot angle) 100))
            res ) )
      (for (x (add dx 100) (sub dx 120) (sub x 20))
         (for (y -100 120 (add y 20))
            (push
               (xyz-hv
                  (rot-h x y c ca sa)
                  (rot-v x y c ca sa)
                  dz f t )
               res >
++++++]

T
