;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: (*SIM-I :use (LISP)); Base: 10; Muser: Yes -*-

#+allegro
(in-package :user)
(defpackage :*sim-i (:use :lisp))
(in-package :*sim-i)

;;; 
;;; #-:ccl-2 (in-package '*sim-i :use '(lisp))
;;; #+:ccl-2 (defpackage :*sim-i 
;;;            (:use :common-lisp)
;;;            (:nicknames :*lisp-i))
;;; #+:ccl-2 (in-package :*sim-i)


;;;> *+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+
;;;> 
;;;> The Thinking Machines *Lisp Simulator is in the public domain.
;;;> You are free to do whatever you like with it, including but
;;;> not limited to distributing, modifying, and copying.

;;;> Bugs, comments and revisions due to porting can be sent to:
;;;> bug-starlisp@think.com.  Other than to Thinking Machines'
;;;> customers, no promise of support is intended or implied.
;;;>
;;;> *+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+

;;; Author:  JP Massar.

;;;>
;;;> The Starlisp language was originally designed by Cliff Lasser and Steve
;;;> Omohundro, with help from many others at Thinking Machines.
;;;> 
;;;> The original Starlisp Interpreter was written by Cliff Lasser, with help
;;;> from George Robertson.
;;;> 
;;;> The Starlisp Simulator was written by JP Massar.
;;;> 
;;;> The Starlisp Compiler was designed and written by Jeff Mincy.
;;;> 
;;;> The Release 5 extensions to the Starlisp language were
;;;> designed by Cliff Lasser, JP Massar and Jeff Mincy, with help
;;;> and ideas from many others at Thinking Machines.
;;;>
;;;> The Release 5 Starlisp Interpreter was written by Cliff Lasser
;;;> and JP Massar, with help from Jeff Mincy.

;;;> Many of the ideas behind the Release 5 extensions to Starlisp,
;;;> including arrays, structures and vp sets, had their origin
;;;> in Jim Salem's New Types extensions to Starlisp.
;;;>


(eval-when (compile load eval)
  (defvar *starlisp-package-name* "*SIM")
  (defvar *starlisp-internal-package-name* '*SIM-I)
  (defvar *starlisp-compiler-package-name* '*SIM-COMPILER)
  (defvar *starlisp-compiler-package-nicknames* '(:*lisp-compiler slc))
  )

(eval-when (compile load eval)
  (unless (find-package *starlisp-package-name*)
    (make-package *starlisp-package-name* 
                  :use `(,*starlisp-internal-package-name* 
                         :common-lisp)
                  :nicknames '(:*lisp)))
  (unless (find-package *starlisp-compiler-package-name*)
    #-symbolics
    (make-package :slc :use `(,*starlisp-package-name* 
                              :common-lisp) 
                  :nicknames `(,*starlisp-compiler-package-name*))
    #+symbolics
    (make-package *starlisp-compiler-package-name*
		  :use `(,*starlisp-package-name* lisp) 
                  :nicknames *starlisp-compiler-package-nicknames*)
    ))
    
#+symbolics
(eval-when (load eval compile)
  (if (not (member (find-package 'cl)
		   (package-use-list (find-package *starlisp-package-name*))))
      (error "The ~S package was incorrectly created.~@
              You will lose horribly if you continue - you MUST boot this Lisp Machine."
	     *starlisp-package-name*))
  (if (not (member (find-package 'cl)
		   (package-use-list (find-package (symbol-name *starlisp-internal-package-name*)))))
      (error "The ~S package was incorrectly created.~@
              You will lose horribly if you continue - you MUST boot this Lisp Machine."
	     *starlisp-internal-package-name*))
  (if (not (member (find-package 'cl)
		   (package-use-list (find-package (symbol-name *starlisp-compiler-package-name*)))))
      (error "The ~S package was incorrectly created.~@
              You will lose horribly if you continue - you MUST boot this Lisp Machine."
	     *starlisp-compiler-package-name*
	     )))

