;;; -*- Mode: LISP;  Syntax: COMMON-LISP; Package: (*SIM-I COMMON-LISP-GLOBAL); Base: 10; Muser: yes -*-

(in-package :*sim-i)

;;;> *+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+
;;;> 
;;;> The Thinking Machines *Lisp Simulator is in the public domain.
;;;> You are free to do whatever you like with it, including but
;;;> not limited to distributing, modifying, and copying.

;;;> Bugs, comments and revisions due to porting can be sent to:
;;;> bug-starlisp@think.com.  Other than to Thinking Machines'
;;;> customers, no promise of support is intended or implied.
;;;>
;;;> *+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+

;;; Author:  JP Massar.


;;;; A FEW MISCELLANEOUS ITEMS


;;;; To conditionalize code, we put the symbols *LISP-SIMULATOR or *LISP-HARDWARE
;;;; onto the *FEATURES* list.  Unfortunately, various implementations have
;;;; decided to do things a bit differently, some using keywords and some not.
;;;; This defines a portable mechanism for adding new features.

(eval-when (compile load eval)
  (defun proper-symbol-for-*features* (x)
    #+(OR SYMBOLICS LUCID EXCL CMU :CCL ALLEGRO)
    (intern (symbol-name x) (find-package "KEYWORD"))
    #+(OR KCL VAXLISP)
    x
    #+(AND VMS DEC COMMON VAX)
    x
   )
  (defun add-new-feature-to-*features* (x)
    (pushnew (proper-symbol-for-*features* x) *features*)
   ))


(eval-when (compile)
  (when (member (proper-symbol-for-*features* *starlisp-hardware-features-symbol*) *features*)
    (error "~S is on the features list.  You must take it off ~@
            while compiling the Simulator."
	   *starlisp-hardware-features-symbol*
	   )))

(eval-when (load eval)
  (when (member (proper-symbol-for-*features* *starlisp-hardware-features-symbol*) *features*)
    (warn "~S is on the features list.  You are presumably loading~@
           the Starlisp Simulator on top of the Starlisp Interpreter.~@
           This will work, but the Simulator will live in the ~S package,~@
           and will not be accessible via the *Lisp package.  Your files will~@
           have to have (in-package '~S)."
	  *starlisp-hardware-features-symbol*
	  *starlisp-package-name*
	  *starlisp-package-name*
	  )))

;;;; Put *LISP-SIMULATOR on *FEATURES* list so users can conditionize
;;;; code between hardware and simulator.

(eval-when (compile load eval)
  (add-new-feature-to-*features* *starlisp-simulator-features-symbol*)
  (add-new-feature-to-*features* '*LISP-SIMULATOR-f19)
  (add-new-feature-to-*features* 'CM-6-1)
  #+:CCL (add-new-feature-to-*features*
	   (intern (symbol-name *starlisp-simulator-features-symbol*)
		   (find-package "*SIM")))
  #+:CCL (add-new-feature-to-*features*
	   (intern (symbol-name *starlisp-simulator-features-symbol*)
		   (find-package "*SIM-I")))
  #+:CCL (add-new-feature-to-*features*
	   (intern (symbol-name *starlisp-simulator-features-symbol*)
		   (find-package "*KEYWORD"))))

;;;; Certain exportable functions and variables are specific to the Simulator.
;;;; They are defined and exported here.

(eval-when (compile load eval)
  (defvar *simulator-exported-functions*)
  (setq *simulator-exported-functions* '(
	RESET-*LISP-FUNCTION-USE-STATISTICS DISPLAY-*LISP-FUNCTION-USE-STATISTICS
   ))
  (eval
    '(progn
       (import *simulator-exported-functions* :*SIM)
       (export *simulator-exported-functions* :*SIM)
       )))

#|
(eval-when (load eval)
  (when (and (not (member (proper-symbol-for-*features* '*LISP-HARDWARE) *features*))
	     (not (find-package "*LISP"))
	     )
    (eval '(in-package :*sim :nicknames '("*LISP")))
    (eval '(in-package :*sim-i :nicknames '("*LISP-I")))
    (eval '(in-package :*sim-compiler :nicknames '("*LISP-COMPILER SLC")))
    ))
|#
;;;; Variables identifying this version of the *LISP Simulator


;;; OLD VERSION.  WILL NOT WORK UNDER LUCID 3.0

;(eval-when (compile load eval)
;  (defvar *starlisp-simulator-header* "Thinking Machines Starlisp Simulator")
;  (defvar *starlisp-simulator-version* 19.0)
;  (defvar *expiration-date* '(1992 12 31) "(year month day)")
;  )

;;; TRY THIS.
;;; NOPE.  DOESN'T WORK.

(eval-when (compile load eval)
  (defvar *starlisp-simulator-header*)
  (setq *starlisp-simulator-header* "Thinking Machines Starlisp Simulator")
  (defvar *starlisp-simulator-version*)
  (setq *starlisp-simulator-version* 19.0)
  (defvar *expiration-date*)
  (setq *expiration-date* '(1992 12 31))
  )


(eval-when (compile load eval)
  (setq *minimum-size-for-vp-set* 1)
  )

;;; A quicker, more mnemonic function for jumping immediately
;;; into or out of the *Lisp package:  (W.R.S. -- 8/11/89)

;;; A non-NIL argument puts you in the *Lisp package, a NIL argument puts you
;;; in the User package, and no argument toggles you between the two.

(defun *lisp (&optional (select-*lisp :toggle))
  (eval `(in-package
          ,(if (eq select-*lisp :toggle)
             (if (eq *package* (find-package :*lisp))
               :common-lisp-user
               :*lisp)
             (if select-*lisp :*lisp :common-lisp-user))))
  (format t "Default package is now ~A.~%" (package-name *package*))
  (values))

(defun common-lisp-user::*lisp (&optional (select-*lisp :toggle))
  (*lisp select-*lisp))

