;; -*- SYNTAX: COMMON-LISP; MODE: LISP; BASE: 10; PACKAGE: *SIM-i; MUSER: YES-*-

(in-package :*sim-i)

;;;> *+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+
;;;> 
;;;> The Thinking Machines *Lisp Simulator is in the public domain.
;;;> You are free to do whatever you like with it, including but
;;;> not limited to distributing, modifying, and copying.

;;;> Bugs, comments and revisions due to porting can be sent to:
;;;> bug-starlisp@think.com.  Other than to Thinking Machines'
;;;> customers, no promise of support is intended or implied.
;;;>
;;;> *+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+

;;; Author:  JP Massar.


(defstruct (vp-set (:print-function print-vp-set))
  name 
  geometry-allocation-form
  geometry
  internal-id 
  (nesting-level 0)
  t!!
  nil!!
  border-bits
  allocated
  instantiated
  voidable
  deallocated
  #+*LISP-SIMULATOR
  self-address!!
  #+*LISP-SIMULATOR
  constants-hash-table
  #+*LISP-SIMULATOR
  array-of-grid-addresses
  #+*LISP-SIMULATOR
  context-stack
  #+*LISP-SIMULATOR
  pvar-array-pool
  #+*LISP-SIMULATOR
  (context-level 0 :type fixnum)
  #+*LISP-SIMULATOR
  array-of-cube-addresses
  #+*LISP-SIMULATOR
  (heap-pvar-arrays nil)
  spare2
  )


(defun print-vp-set (vp-set stream depth)
  (declare (ignore depth))
  (format stream "#<VP-SET Name: ~A~@[, Dimensions ~A~]~@[, Geometry-id: ~A~]>"
	  (vp-set-name vp-set)
	  (if (vp-set-geometry vp-set) (geometry-dimensions (vp-set-geometry vp-set)) nil)
	  (if (vp-set-geometry vp-set) (geometry-id (vp-set-geometry vp-set)) nil)
	  ))


;;; We store *DEFVAR definitions in a *DEFVAR-SPECIFICATION
;;; structure.


(defstruct *defvar-specification
  name
  (initial-value-form nil)
  (vp-set-name nil)
  (in-vp-set-definition-p nil)
  (initial-value-function nil)
  (proclaimed-type nil))

;;;; Create the default VP-SET at Starlisp load time so it will always exist.

(eval-when (load)
  (when (null *default-vp-set*)
    (setq *default-vp-set*
	  (make-vp-set
	    :name '*default-vp-set*
	    ))))

