;;; List operations for the testing of the YAQ83 Common LISP version.
;;;
;;; Antti Ylikoski 12-16-2010.

(in-package yaq)

;;; DEFINE-PREDICATE must be defined at compile time

(define-predicate last
    ((last ?x (?x)))
    ((last ?x (?ignore . ?y))
     (last ?x ?y)))

(define-predicate delete
  ((delete ?x (?x . ?l) ?l))
  ((delete ?x (?y . ?l1) (?y . ?l2))
   (delete ?x ?l1 ?l2)))

(define-predicate append
  ((append nil ?x ?x))
  ((append (?x . ?y) ?z (?x . ?u))
   (append ?y ?z ?u)))

(define-predicate member
  ((member ?x (?x . ?y)))
  ((member ?x (?a . ?y))
   (member ?x ?y)))

(define-predicate rev
  ((rev ?l1 ?l2)
   (rev0 ?l1 () ?l2)))

(define-predicate rev0
  ((rev0 (?x . ?l) ?l2 ?l3)
   (rev0 ?l (?x . ?l2) ?l3))
  ((rev0 () ?l ?l)))

(define-predicate naive-reverse
  ((naive-reverse () ()))
  ((naive-reverse (?h . ?t) ?l)
   (naive-reverse ?t ?z)
   (append ?z (?h) ?l)))
