/* xlisp - a small subset of lisp */

/* useful definitions */
#define TRUE	1
#define FALSE	0
#define NULL	0

/* program limits */
#define STRMAX	100	/* maximum length of a string constant */
#define NNODES	2000	/* number of nodes to allocate in each request */

/* node types */
#define FREE	0
#define SUBR	1
#define LIST	2
#define MSG	2
#define BND	2
#define SYM	3
#define INT	4
#define STR	5
#define DBPTR	6
#define KMAP	7
#define FUN	8
#define OBJ	9

/* node flags */
#define MARK	1
#define LEFT	2

/* string types */
#define DYNAMIC	0
#define STATIC	1

/* symbol structure */
struct xsym {
    char *xsy_name;		/* symbol name */
    struct node *xsy_value;	/* the current value */
};

/* subr node structure */
struct xsubr {
    int (*xsu_subr)();		/* pointer to an internal routine */
};

/* list node structure */
struct xlist {
    struct node *xl_value;	/* value at this node */
    struct node *xl_next;	/* next node */
};

/* integer node structure */
struct xint {
    int xi_int;			/* integer value */
};

/* string node structure */
struct xstr {
    int xst_type;		/* string type */
    char *xst_str;		/* string pointer */
};

/* database pointer structure */
struct xdbptr {
    char *xdb_sptr;		/* selection pointer */
    int xdb_flags;		/* flag bits */
};

/* keymap structure */
struct xkmap {
    struct node *(*xkm_map)[];	/* selection pointer */
};

/* function node structure */
struct xfun {
    struct node *xf_funargs;	/* list of formal arguments */
    struct node *xf_funcode;	/* function code */
};

/* object node structure */
struct xobj {
    struct node *xo_obclass;	/* class of object */
    struct node *xo_obdata;	/* instance data */
};

/* shorthand macros for accessing node substructures */

/* symbol node */
#define n_symname	n_info.n_xsym.xsy_name
#define n_symvalue	n_info.n_xsym.xsy_value

/* subr node */
#define n_subr		n_info.n_xsubr.xsu_subr

/* list node (and message node and binding node) */
#define n_listvalue	n_info.n_xlist.xl_value
#define n_listnext	n_info.n_xlist.xl_next
#define n_msg		n_info.n_xlist.xl_value
#define n_msgcode	n_info.n_xlist.xl_next
#define n_bndsym	n_info.n_xlist.xl_value
#define n_bndvalue	n_info.n_xlist.xl_next
#define n_left		n_info.n_xlist.xl_value
#define n_right		n_info.n_xlist.xl_next
#define n_ptr		n_info.n_xlist.xl_value

/* integer node */
#define n_int		n_info.n_xint.xi_int

/* string node */
#define n_str		n_info.n_xstr.xst_str
#define n_strtype	n_info.n_xstr.xst_type

/* database pointer node */
#define n_dbsptr	n_info.n_xdbptr.xdb_sptr
#define n_dbflags	n_info.n_xdbptr.xdb_flags

/* key map node */
#define n_kmap		n_info.n_xkmap.xkm_map

/* function node */
#define n_funargs	n_info.n_xfun.xf_funargs
#define n_funcode	n_info.n_xfun.xf_funcode

/* object node */
#define n_obclass	n_info.n_xobj.xo_obclass
#define n_obdata	n_info.n_xobj.xo_obdata

/* node structure */
struct node {
    char n_type;		/* type of node */
    char n_flags;		/* flag bits */
    union {			/* value */
	struct xsym n_xsym;	/*     symbol node */
	struct xsubr n_xsubr;	/*     subr node */
	struct xlist n_xlist;	/*     list node */
	struct xint n_xint;	/*     integer node */
	struct xstr n_xstr;	/*     string node */
	struct xdbptr n_xdbptr;	/*     database pointer node */
	struct xkmap n_xkmap;	/*     key map node */
	struct xfun n_xfun;	/*     function node */
	struct xobj n_xobj;	/*     object node */
    } n_info;
};
