/* separate.c - separate a combined file into individual files */

#include <stdio.h>

#define LINEMAX	500

/* main - the main routine */
main(argc,argv)
  int argc; char *argv[];
{
    FILE *ifp,*ofp = NULL;
    char line[LINEMAX],ofname[100];

    /* make sure there is a file to separate */
    if (argc != 2) {
	printf("incorrect number of arguments\n");
	exit(1);
    }

    /* open the input file */
    if ((ifp = fopen(argv[1],"r")) == NULL) {
	printf("can't open: %s\n",argv[1]);
	exit(1);
    }

    /* process each file */
    while (fgets(line,LINEMAX,ifp) != NULL) {

	/* look for a header line */
	if (sscanf(line,"<<<<<<<<<< %s >>>>>>>>>>",ofname) == 1) {

	    /* close the current output file */
	    if (ofp != NULL)
		fclose(ofp);

	    /* open the new output file */
	    if ((ofp = fopen(ofname,"w")) == NULL)
		printf("can't create: %s\n",ofname);
	    else
		printf("creating: %s\n",ofname);
	}

	/* output a line to the current output file */
	else if (ofp != NULL)
	    fputs(line,ofp);

	/* no current output file, print the line */
	else
	    fputs(line,stdout);
    }

    /* close the last output file */
    if (ofp != NULL)
	fclose(ofp);

    /* close the input file */
    fclose(ifp);
}
