/* xlftab.c - xlisp function table */

#ifdef AZTEC
#include "stdio.h"
#else
#include <stdio.h>
#endif

#include "xlisp.h"

/* external functions */
extern struct node
    *xeval(),*xapply(),*xfuncall(),*xquote(),
    *xset(),*xsetq(),*xdefun(),*xndefun(),
    *xgensym(),*xintern(),*xsymname(),*xsymplist(),
    *xget(),*xputprop(),*xremprop(),
    *xcar(),*xcaar(),*xcadr(),*xcdr(),*xcdar(),*xcddr(),
    *xcons(),*xlist(),*xappend(),*xreverse(),*xlast(),*xnth(),*xnthcdr(),
    *xmember(),*xmemq(),*xassoc(),*xassq(),*xsubst(),*xsublis(),*xlength(),
    *xmapcar(),*xmaplist(),
    *xrplca(),*xrplcd(),*xnconc(),*xdelete(),*xdelq(),
    *xatom(),*xsymbolp(),*xnumberp(),*xboundp(),*xnull(),*xlistp(),*xconsp(),
    *xeq(),*xequal(),
    *xcond(),*xand(),*xor(),*xlet(),*xif(),*xprogn(),
    *xwhile(),*xrepeat(),
    *xadd(),*xsub(),*xmul(),*xdiv(),*xrem(),*xminus(),*xmin(),*xmax(),*xabs(),
    *xadd1(),*xsub1(),*xbitand(),*xbitior(),*xbitxor(),*xbitnot(),
    *xlss(),*xleq(),*xeql(),*xneq(),*xgeq(),*xgtr(),
    *xstrlen(),*xstrcat(),*xsubstr(),*xascii(),*xchr(),*xatoi(),*xitoa(),
    *xread(),*xprint(),*xprin1(),*xprinc(),*xterpri(),
    *xflatsize(),*xflatc(),*xexplode(),*xexplc(),*ximplode(),*xmaknam(),
    *xopeni(),*xopeno(),*xclose(),*xrdchar(),*xpkchar(),*xwrchar(),*xreadline(),
    *xload(),*xgc(),*xexpand(),*xalloc(),*xmem(),*xtype(),*xexit();

struct fdef ftab[] = {

	/* evaluator functions */
	"eval",		SUBR,	xeval,
	"apply",	SUBR,	xapply,
	"funcall",	SUBR,	xfuncall,
	"quote",	FSUBR,	xquote,

	/* symbol functions */
	"set",		SUBR,	xset,
	"setq",		FSUBR,	xsetq,
	"defun",	FSUBR,	xdefun,
	"ndefun",	FSUBR,	xndefun,
	"gensym",	SUBR,	xgensym,
	"intern",	SUBR,	xintern,
	"symbol-name",	SUBR,	xsymname,
	"symbol-plist",	SUBR,	xsymplist,
	"get",		SUBR,	xget,
	"putprop",	SUBR,	xputprop,
	"remprop",	SUBR,	xremprop,

	/* list functions */
	"car",		SUBR,	xcar,
	"caar",		SUBR,	xcaar,
	"cadr",		SUBR,	xcadr,
	"cdr",		SUBR,	xcdr,
	"cdar",		SUBR,	xcdar,
	"cddr",		SUBR,	xcddr,
	"cons",		SUBR,	xcons,
	"list",		SUBR,	xlist,
	"append",	SUBR,	xappend,
	"reverse",	SUBR,	xreverse,
	"last",		SUBR,	xlast,
	"nth",		SUBR,	xnth,
	"nthcdr",	SUBR,	xnthcdr,
	"member",	SUBR,	xmember,
	"memq",		SUBR,	xmemq,
	"assoc",	SUBR,	xassoc,
	"assq",		SUBR,	xassq,
	"subst",	SUBR,	xsubst,
	"sublis",	SUBR,	xsublis,
	"length",	SUBR,	xlength,
	"mapcar",	SUBR,	xmapcar,
	"maplist",	SUBR,	xmaplist,

	/* destructive list functions */
	"rplaca",	SUBR,	xrplca,
	"rplacd",	SUBR,	xrplcd,
	"nconc",	SUBR,	xnconc,
	"delete",	SUBR,	xdelete,
	"delq",		SUBR,	xdelq,

	/* predicate functions */
	"atom",		SUBR,	xatom,
	"symbolp",	SUBR,	xsymbolp,
	"numberp",	SUBR,	xnumberp,
	"boundp",	SUBR,	xboundp,
	"null",		SUBR,	xnull,
	"not",		SUBR,	xnull,
	"listp",	SUBR,	xlistp,
	"consp",	SUBR,	xconsp,
	"eq",		SUBR,	xeq,
	"equal",	SUBR,	xequal,

	/* control functions */
	"cond",		FSUBR,	xcond,
	"and",		FSUBR,	xand,
	"or",		FSUBR,	xor,
	"let",		FSUBR,	xlet,
	"if",		FSUBR,	xif,
	"progn",	FSUBR,	xprogn,
	"while",	FSUBR,	xwhile,
	"repeat",	FSUBR,	xrepeat,

	/* arithmetic functions */
	"+",		SUBR,	xadd,
	"-",		SUBR,	xsub,
	"*",		SUBR,	xmul,
	"/",		SUBR,	xdiv,
	"1+",		SUBR,	xadd1,
	"1-",		SUBR,	xsub1,
	"rem",		SUBR,	xrem,
	"minus",	SUBR,	xminus,
	"min",		SUBR,	xmin,
	"max",		SUBR,	xmax,
	"abs",		SUBR,	xabs,

	/* bitwise logical functions */
	"bit-and",	SUBR,	xbitand,
	"bit-ior",	SUBR,	xbitior,
	"bit-xor",	SUBR,	xbitxor,
	"bit-not",	SUBR,	xbitnot,

	/* numeric comparison functions */
	"<",		SUBR,	xlss,
	"<=",		SUBR,	xleq,
	"=",		SUBR,	xeql,
	"/=",		SUBR,	xneq,
	">=",		SUBR,	xgeq,
	">",		SUBR,	xgtr,

	/* string functions */
	"strlen",	SUBR,	xstrlen,
	"strcat",	SUBR,	xstrcat,
	"substr",	SUBR,	xsubstr,
	"ascii",	SUBR,	xascii,
	"chr",		SUBR,	xchr,
	"atoi",		SUBR,	xatoi,
	"itoa",		SUBR,	xitoa,

	/* I/O functions */
	"read",		SUBR,	xread,
	"print",	SUBR,	xprint,
	"prin1",	SUBR,	xprin1,
	"princ",	SUBR,	xprinc,
	"terpri",	SUBR,	xterpri,
	"flatsize",	SUBR,	xflatsize,
	"flatc",	SUBR,	xflatc,
	"explode",	SUBR,	xexplode,
	"explodec",	SUBR,	xexplc,
	"implode",	SUBR,	ximplode,
	"maknam",	SUBR,	xmaknam,

	/* file I/O functions */
	"openi",	SUBR,	xopeni,
	"openo",	SUBR,	xopeno,
	"close",	SUBR,	xclose,
	"read-char",	SUBR,	xrdchar,
	"peek-char",	SUBR,	xpkchar,
	"write-char",	SUBR,	xwrchar,
	"readline",	SUBR,	xreadline,

	/* system functions */
	"load",		SUBR,	xload,
	"gc",		SUBR,	xgc,
	"expand",	SUBR,	xexpand,
	"alloc",	SUBR,	xalloc,
	"mem",		SUBR,	xmem,
	"type",		SUBR,	xtype,
	"exit",		SUBR,	xexit,

	0
};
