/* xlisp - a small subset of lisp */

#ifdef AZTEC
#include "stdio.h"
#include "setjmp.h"
#else
#include <stdio.h>
#include <setjmp.h>
#endif

#include "xlisp.h"

/* global variables */
jmp_buf *xljmpbuf;
jmp_buf topjmpbuf;

/* external variables */
extern struct node *xlenv;
extern struct node *xlstack;
extern struct node *s_stdin,*s_stdout;

/* main - the main routine */
main(argc,argv)
  int argc; char *argv[];
{
    struct node expr;
    int i;

    /* print the banner line */
    printf("XLISP version 1.2\n");

    /* setup the error handler context buffer */
    xljmpbuf = topjmpbuf;

    /* setup initialization error handler */
    if (setjmp(xljmpbuf)) {
	printf("fatal initialization error\n");
	exit();
    }

    /* initialize xlisp */
    xlinit();

    /* load "init.lsp" */
    if (setjmp(xljmpbuf) == 0)
	xlload("init");

    /* load any files mentioned on the command line */
    if (setjmp(xljmpbuf) == 0)
	for (i = 1; i < argc; i++) {
	    printf("[ loading \"%s\" ]\n",argv[i]);
	    if (!xlload(argv[i]))
		xlfail("can't load file");
	}

    /* main command processing loop */
    while (TRUE) {

	/* setup the error return */
	setjmp(xljmpbuf);

	/* free any previous expression and leftover context */
	xlstack = xlenv = NULL;

	/* create a new stack frame */
	xlsave(&expr,NULL);

	/* read an expression */
	if (!xlread(s_stdin->n_symvalue,&expr.n_ptr))
	    break;

	/* evaluate the expression */
	expr.n_ptr = xleval(expr.n_ptr);

	/* print it */
	xlprint(s_stdout->n_symvalue,expr.n_ptr,TRUE);
	xlterpri(s_stdout->n_symvalue);
    }
}
