Fundamental axioms and methods of definition: 

(1) Set Booleans and other decidable stuff, including Singleton: {x} and conditional expressions
'if e1 then a1 elseif e2 then a2 ... end if'

(2) Axiom of choice:  (S = 0 and arb(S) = 0) or (arb(S) in S & arb(S) * S = 0)

(3) Axiom of infinity: s_inf /= 0 and (FORALL x in s_inf | {x} in s_inf)

(4) Algebraic definition, in the ordinary way, including setformers

(5) Recursive definition of f(S,A1,..,An) using predefined h(S,A1,..,An) and g(S,A1,..,An)

      f(S,A1,..,An) = g({h(f(t,A1,..,An),A1..,An): t in S},A1..,An)
      f(S,A1,A2,An) = g({h(f(t,A1,A2,An),A1,A2,An): t in S},A1,A2,An)

(6) Definition of groups of symbols by theory application.

    THEORY theory_name(list_of_assumed_symbols);
      assumptions...
    ==>
      conclusions ...
    END theory_name;

    APPLY(new_symbol:defined_symbol_of_theory,...)   
          theory_name(list_of_replacements_for_assumed_symbols)

    new_theory_name := Combine(theory_name(list_of_replacements_for_assumed_symbols),...)    


    sets_of_groups := Combine_all(theory_name,s)

A remark concerning the 'Axiom of Replacement'. One formulation of this axiom is: if P(x,y) is a predicate such that (FORALL x in s | (FORALL y | (FORALL z | ((P(x,y) & P(x,z)) imp (y = z))))) then there is a set t such that (FORALL y | (y in t eq (EXISTS x in s | P(x,y)))). This may be subsumed by the very general way in which we Skolemize and allow setformers to be written. I will try to think through this point.


-----------------------------------------------------------------------------
            Catalog of Theorems and Definitions
-----------------------------------------------------------------------------

Def 1: Ordered pair: [x,y] := {{x},{{x},{{y},y}}}

* Theorem 1: arb({X}) = X 
* Theorem 1a: arb({{X},X}) = X 
* Theorem 2: arb([X,Y]) = {X} 
* Theorem 3: arb(arb([X,Y])) = X 
* Theorem 4: arb(arb(arb([X,Y] - {arb([X,Y])}) - {arb([X,Y])})) = Y 

Def 2: car(x) := arb(arb(x))
Def 3: cdr(x) := arb(arb(arb(x - {arb(x)}) - {arb(x)}))

* Theorem 5: car([X,Y]) = X 
* Theorem 6: cdr([X,Y]) = Y 
* Theorem 7: [X,Y] = [car([X,Y]),cdr([X,Y])] 
    
THEORY transfinite_induction(n,P)
    P(n)
==>(m)
    P(m) & (FORALL k in m | not P(k))
END transfinite_induction;

Def 4: is_map(f) := f = {[car(x),cdr(x)]: x in f}
Def 5: domain(f) := {car(x): x in f}
Def 6: range(f) := {cdr(x): x in f}
Def 7: Svm(f) := is_map(f) & (FORALL x in f | (FORALL y in f | (car(x) = car(y)) imp (x = y)))
Def 8: one_1_map(f) := Svm(f) & (FORALL x in f | (FORALL y in f | (cdr(x) = cdr(y)) imp (x = y)))
Def 9: [The enumeration of a set] 
    enum(X,S) := if S incin {enum(y,S): y in X} then S else arb(S - {enum(y,S): y in X}) end if
Def 10: Ord(s) := (FORALL x in s | x incin s) & (FORALL x in s | (FORALL y in s | (x in y or y in x or x = y)))
Def 11: next(s) := s + {s}

* Theorem 8: (Ord(S) & Ord(T) & T incin S) imp (T = S or T = arb(S - T)) 
* Theorem 9: (Ord(S) & Ord(T)) imp Ord(S * T)   
* Theorem 10: (Ord(S) & Ord(T)) imp (S incin T or T incin S)   
* Theorem 11: (Ord(S) & Ord(T) ) imp (S in T or T in S or S = T) 
* Theorem 12: (Ord(S) & T in S) imp Ord(T) 
* Theorem 13: [The class of all sets is not a set] not(EXISTS x | (FORALL y | y in x))
* Theorem 14: [The class of ordinals is not a set] 
          not(EXISTS ordinals | (FORALL x | (x in ordinals eq Ord(x))))
* Theorem 15: Ord(S) imp Ord(next(S)) 
* Theorem 16: (Ord(S) & Ord(T)) imp (T incin S eq T in S or T = S) 
* Theorem 17: (Ord(X) & S in {enum(y,S): y in X}) imp (S incin {enum(y,S): y in X})
* Theorem 18: enum(X,S) = S or enum(X,S) in S
* Theorem 19: (enum(X,S) = S & Y incs X) imp (enum(Y,S) = S)
* Theorem 20: [The enumeration of a set is 1-1]
    (Ord(X) & Ord(W) & X /= W) imp 
      (s in {enum(y,s): y in X} or s in {enum(y,s): y in W} or enum(X,s) /= enum(W,s))
* Theorem 21: [Enumeration Lemma] (FORALL s | (EXISTS x | (Ord(x) & s in {enum(y,s): y in x})))
* Theorem 22: [Enumeration theorem] 
    (FORALL s | (EXISTS x | (Ord(x) & s = {enum(y,s): y in x})) & 
                (FORALL y in x | (FORALL z in x | (y /= z) imp (enum(y,s) /= enum(z,s)))))

Def 12: [Map Restriction] Def(f ON a) := {p in f | car(p) in a}
Def 13: [Value of single-valued function] Def(f~[x]) := cdr(arb(f ON {x}))
Def 14: [Map Product] Def(F @ G) := {[car(x),cdr(y)]: x in G, y in F | cdr(x) = car(y)}
Def 14a: [Inverse Map] inv(F) := {[cdr(x),car(x)]: x in F}
Def 14b: [Identity Map] ident(s) := {[x,x]: x in s}
Def 14c: Ord(enum_Ord(s)) & s = {enum(y,s): y in enum_Ord(s)} & 
              (FORALL y in enum_Ord(s) | (FORALL z in enum_Ord(s) | (y /= z) imp (enum(y,s) /= enum(z,s))))
Def 15: [Cardinality] 
    Def(#s) := arb({x: x in next(enum_Ord(s)) | (EXISTS f in OM | (one_1_map(f) & domain(f) = x & range(f) = s))}) 
Def 16: [Cardinal] 
 Card(s) := Ord(s) & 
      (FORALL y in s | (FORALL f in OM | (not(domain(f) = y) or not(range(f) = s) or not(Svm(f)))))

* Theorem 23: F ON A incin F
* Theorem 24: S * T = {x in S | x in T}
* Theorem 25: S - T = {x in S | x notin T}
* Theorem 26: is_map(F) eq (FORALL x in F | x = [car(x),cdr(x)])
* Theorem 27: (G incin F & is_map(F)) imp is_map(G)
* Theorem 28: (G incin F & Svm(F)) imp Svm(G)
* Theorem 29: (G incin F & one_1_map(F)) imp one_1_map(G)
* Theorem 30: (X in F) imp (car(X) in domain(F)) 
* Theorem 31: (X in F) imp (cdr(X) in range(F)) 
* Theorem 33: (is_map(F) & is_map(G)) imp is_map(F + G) 
* Theorem 34: F ON (A + B) = (F ON A) + (F ON B) 
* Theorem 35: [Associativity of map multiplication] F @ (G @ H) = (F @ G) @ H
* Theorem 36: (F + G) ON A = (F ON A) + (G ON A)
* Theorem 37: F ON domain(F) = F 
* Theorem 38: (X in domain(F)) imp (F~[X] in range(F))
* Theorem 39: Svm(F) eq F = {[x,F~[x]]: x in domain(F)}
* Theorem 39a: Svm(F) imp (F = {[x,F~[x]]: x in domain(F)} & range(F) = {F~[x]: x in domain(F)})

THEORY setformer0(e,s,p)      [Elementary properties of setformers]
==>
    (s /= 0) imp ({e(x): x in s} /= 0)
    ({x in s | p(x)} /= 0) imp ({e(x): x in s | p(x)} /= 0)
END setformer0;

THEORY setformer(e,ep,s,p,pp)      [More Elementary properties of setformers]
     (FORALL x in s | e(x) = ep1(x)) & (FORALL x in s | (p(x) eq pp1(x)))
==>
    {e(x): x in s | p(x)} = {ep1(x): x in s | pp1(x)}
END setformer;

THEORY setformer2(e,ep,f,fp,s,p,pp)     [More Elementary properties of setformers]
     (FORALL x in s | f(x) = fp(x)) & 
      (FORALL x in s | (FORALL y in f(x) | e(x,y) = ep2(x,y))) & (FORALL x in s | (FORALL y in f(x) | p(x) eq pp2(x,y)))
==>
    {e(x,y): x in s, y in f(x) | p(x,y)} = {ep2(x,y): x in s, y in fp(x) | pp2(x,y)}
END setformer2;

THEORY fcn_symbol(f,g,s)  [Contains some elementary lemmas about single-valued functions]
     g = {[x,f(x)]: x in s}
==>
    domain(g) = s
    (FORALL x in s | g~[x] = f(x))
    (X notin s) imp (g~[X] = 0)
    range(g) = {f(x): x in s}
    Svm(g)
    (FORALL x in s | (FORALL y in s | (f(x) = f(y)) imp (x = y))) imp one_1_map(g)
END fcn_symbol;

* Theorem 40: (U = [A,B]) imp (U = [car(U),cdr(U)]) 
* Theorem 41: (is_map(F) & U in F) imp (U = [car(U),cdr(U)]) 

THEORY iz_map(f,a,b,s)
     f = {[a(x),b(x)]: x in s}
==>
    is_map(f)
END iz_map;

* Theorem 42: domain(F + G) = domain(F) + domain(G)
* Theorem 43: range(F + G) = range(F) + range(G)
* Theorem 44: domain(F) = 0 eq range(F) = 0
* Theorem 45: (Svm(F) & X in F) imp (F~[car(X)] = cdr(X)) 
* Theorem 46: [Union of single_valued maps] 
    (Svm(F) & Svm(G) & domain(F) * domain(G) = 0) imp Svm(F + G)
* Theorem 47: is_map(F) imp is_map(F ON S)
* Theorem 48: Svm(F) imp Svm(F ON S)
* Theorem 49: one_1_map(F) imp one_1_map(F ON S)
* Theorem 50: range(F ON S) incin range(F) 
* Theorem 50a: domain(F ON S) = domain(F) * S
* Theorem 51: (range(G) incin domain(F)) imp (range(F @ G) = range(F ON range(G)) & domain(F @ G) = domain(G))
* Theorem 51a: (range(G) = domain(F)) imp (range(F @ G) = range(F) & domain(F @ G) = domain(G))
* Theorem 52: [Union of 1-1 maps]
    (one_1_map(F) & one_1_map(G) & range(F) * range(G) = 0 & domain(F) * domain(G) = 0) imp one_1_map(F + G)
* Theorem 53: is_map(inv(F)) & range(inv(F)) = domain(F) & domain(inv(F)) = range(F) 
* Theorem 54: is_map(F) imp (F = inv(inv(F))) 
* Theorem 55: 
    one_1_map(F) imp (one_1_map(inv(F)) & F = inv(inv(F)) & range(inv(F)) = domain(F) & domain(inv(F)) = range(F))
* Theorem 56: one_1_map(F) imp (FORALL x in domain(F) | inv(F)~[F~[x]] = x) 
* Theorem 57: one_1_map(F) imp 
        ((FORALL x in domain(F) | inv(F)~[F~[x]] = x) & (FORALL x in range(F) | F~[inv(F)~[x]] = x)) 
        
* Theorem 58: [Elementary Properties of identity maps]
      one_1_map(ident(S)) & domain(ident(S)) = S & range(ident(S)) = S & inv(ident(S)) = ident(S) &
       (FORALL x in S | ident(S)~[x] = x) & 
          (is_Map(F) imp (((domain(F) incin S) imp (F @ ident(S) = F)) & ((range(F) incin S) imp (ident(S) @ F = F)))). Proof:
* Theorem 59: Svm(F) imp (F @ inv(F) = ident(range(F))) 
* Theorem 60: one_1_map(F) imp (F @ inv(F) = ident(range(F)) & inv(F) @ F = ident(domain(F))) 
* Theorem 61: [An inverse pair of maps must be 1-1 and must be each others inverses]
    (is_map(F) & is_map(G) & domain(F) = range(G) & range(F) = domain(G) & 
        F @ G = ident(range(F)) & G @ F = ident(domain(F))) imp (one_1_map(F) & G = inv(F))
* Theorem 62: is_map(F @ G) 
* Theorem 63: (Svm(F) & Svm(G)) imp Svm(F @ G)
* Theorem 64: (Svm(F) & Svm(G) & X in domain(G) & range(G) incin domain(F)) imp ((F @ G)~[X] = F~[G~[X]])
* Theorem 64a: (Svm(F) & Svm(G) & X in domain(G) & range(G) incin domain(F)) imp (
      ((F @ G)~[X] = F~[G~[X]] & F @ G = {[x,F~[G~[x]]]: x in domain(g)} & range(F @ G) = {F~[G~[x]]: x in domain(G)}). 
* Theorem 65: (one_1_map(F) & one_1_map(G)) imp one_1_map(F @ G)  
* Theorem 66: (F + FF) @ G = (F @ G) + (FF @ G) 
* Theorem 67: G @ (F + FF) = (G @ F) + (G @ FF)

Def 17: [Cartesian Product] Def(s PROD t) := {[x,y]: x in s, y in t}
 
* Theorem 68: (F = {[[[x,y],z],[x,[y,z]]]: x in A, y in B, z in C}) imp 
        (one_1_map(F) & domain(F) = ((A PROD B) PROD C) & range(F) = (A PROD (B PROD C))) 
* Theorem 69: (F = {[[x,y],[y,x]]: x in A, y in B}) imp 
        (one_1_map(F) & domain(F) = (A PROD B) & range(F) = (B PROD A))  
* Theorem 70: (Ord(S) & X in S) imp (enum(X,S) = X)
* Theorem 71: [Cardinality Lemma] Ord(#S) & (EXISTS f in OM | (one_1_map(f) & range(f) = S & domain(f) = #S)) & 
          (not((EXISTS o in #S | (EXISTS g | (Ord(o) & one_1_map(g) & range(g) = S & domain(f) = o)))))
* Theorem 72: [The enumerating ordinal of a set has the same cardinality as the set] 
    (EXISTS o | (Ord(o) & S = {enum(x,S): x in o} & #o = #S))
* Theorem 73: ['arb' is monotone decreasing for non-empty sets of ordinals] 
    (Ord(R) & R incs S & S incs T) imp (arb(S) in arb(T) or arb(S) = arb(T) or T = 0)
* Theorem 74: [Lemma for following theorem] 
    (Ord(S) & T incin S & X in S & Y in X) imp (enum(Y,T) in enum(X,T) or enum(X,T) incs T)
* Theorem 75: [Subsets enumerate at least as rapidly] (ord(S) & T incin S & X in S) imp (enum(X,T) incs X)
* Theorem 76: (Ord(S) & T incin S) imp ({enum(x,T): x in S} incs T)
* Theorem 77: (Ord(S) & T incin S) imp (EXISTS x incin S | (Ord(x) & T = {enum(y,T): y in x}) & 
                (FORALL y in x | (FORALL z in x | (y /= z) imp (enum(y,T) /= enum(z,T)))))
* Theorem 78: [Subsets of an ordinal have a cardinality that is no larger than the ordinal]
    (Ord(S) & T incin S) imp (#T incin S)
* Theorem 79: [Single-valued maps have 1-1 partial inverses]
    Svm(F) imp (EXISTS h | (domain(h) = range(F) & range(h) incin domain(F) & one_1_map(h) &
                (FORALL x in range(F) | F~[h~[x]] = x)))
* Theorem 80: [Cardinality theorem] Card(#S) & (EXISTS f in OM | (one_1_map(f) & range(f) = S & domain(f) = #S))
* Theorem 81: #S = 0 eq S = 0
* Theorem 82: [Uniqueness of Cardinality] 
    (Card(C) & (EXISTS f in OM | (one_1_map(f) & range(f) = S & domain(f) = C))) imp (C = #S)
* Theorem 83: [Subset cardinality theorem] (T incin S) imp (#T incin #S)
* Theorem 84: one_1_map(F) imp (#range(F) = #domain(F))
* Theorem 85: Svm(F) imp (#range(F) incin #domain(F))
* Theorem 85a: (F incin G) imp (range(F) incin range(G) & domain(F) incin domain(G))

Def 18: [Finiteness] 
    Finite(s) :eq not(EXISTS f in OM | (one_1_map(f) & domain(f) = s & range(f) incin s & s /= range(f)))

* Theorem 86: [0 is a finite cardinal] Ord(0) & Finite(0) & Card(0) 
* Theorem 87: #domain(F) incin #F
* Theorem 88: #range(F) incin #F
* Theorem 89: Svm(F) imp (#domain(F) = #F)
* Theorem 90: #S incs #T eq (T = 0 or (EXISTS f in OM | (Svm(f) & domain(f) = S & range(f) = T)))

* Theorem 91: #S = #T eq (EXISTS f in OM | (one_1_map(f) & domain(f) = S & range(f) = T))
* Theorem 92: Card(S) eq S = #S
* Theorem 93: #S = ##S
* Theorem 94: #S in #T or #S = #T or #T in #S
* Theorem 95: (#S in #T & #T in #R) imp (#S in #R)
* Theorem 96: [Associative Law for Cardinals] #((A PROD B) PROD C) = #(A PROD (B PROD C)) 
* Theorem 97: [Commutative Law for Cardinals] #(A PROD B) = #(B PROD A) 

* Theorem 98: [A subset of a finite set is finite] (Finite(S) & S incs T) imp Finite(T) 
* Theorem 99: Svm(F) imp (one_1_map(F) eq (FORALL x in domain(F) | (FORALL y in domain(F) | (F~[x] = F~[y]) imp (x = y))))
* Theorem 100: [A 1-1 map on a set induces a 1-1 map on the power set of its domain]
    (one_1_map(F) & S incin domain(F) & T incin domain(F) & S /= T) imp (range(F ON S) /= range(F ON T))
* Theorem 101: [Map product formula] (Svm(F) & Svm(G) & range(F) incin domain(G)) imp 
    (G @ F = {[x,G~[F~[x]]]: x in domain(F)} & domain(G @ F) = domain(F) & range(G @ F) = {G~[F~[x]]: x in domain(F)})
* Theorem 102: one_1_map(F) imp ((Finite(domain(F))) imp (Finite(range(F))))
* Theorem 103: one_1_map(F) imp ((Finite(domain(F))) eq (Finite(range(F))))
* Theorem 104: [A single_valued map with finite domain has a finite range] 
      (Svm(F) & Finite(domain(F))) imp Finite(range(F))
* Theorem 105: Finite(S) eq Finite(#S)
* Theorem 106: [Proper subsets of a finite set have fewer elements] (Finite(S) & T incin S & T /= S) imp (#T in #S)

* Theorem 107: Finite(S) eq (not(EXISTS f in OM | (Svm(f) & range(f) = S & domain(f) incin S & S /= domain(f))))

* Theorem 108: (Ord(S) & Finite(S) & T in S) imp Finite(T)
* Theorem 109: [Any infinite ordinal is larger than any finite ordinal]
            (Ord(S) & Ord(T) & (not Finite(S)) & Finite(T)) imp (T in S) 
* Theorem 110: [Interchange Lemma] 
    (X in S & Y in S) imp (EXISTS f in OM | (one_1_map(f) & range(f) = S & domain(f) = S & f~[X] = Y & f~[Y] = X))
* Theorem 111: Svm(F) imp (F ON S = {[x,F~[x]]: x in domain(f) | x in S} & domain(F ON S) = {x in domain(F) | x in S} &
              range(F ON S) = {F~[x]: x in domain(f) | x in S})
* Theorem 112: (one_1_map(F) & X in domain(F) & Y in domain(F) & F~[X] = F~[Y]) imp (X = Y)
* Theorem 113: Finite(S) eq Finite(S + {X})
* Theorem 114: Finite(S) imp Finite(next(S)) 
* Theorem 115: not(Finite(s_inf)) 
* Theorem 116: [Infinite cardinality theorem] not(Finite(#s_inf))

* Theorem 117: [All finite ordinals are cardinals] (Ord(X) & Finite(X)) imp Card(X) 
    
Def 18a: [The set of integers] Z := arb({x in next(#s_inf) | not Finite(x)})

* Theorem 118: Ord(Z) & (not Finite(Z)) & (FORALL x in OM | ((Card(x) & Finite(x)) eq x in Z)) 

Def 18b: [Standard definitions of the finite integers] 1 = next(0) & 2 = next(1) & 3 = next(2) & ...  

* Theorem 119: Ord(0) & 0 in Z & 1 in Z & 2 in Z & 3 in Z
* Theorem 120: [The set of integers is a Cardinal] Card(Z) 

* Theorem 121: 0 in Z & 1 in Z & 2 in Z & 3 in Z & 1 /= 0 & 2 /= 0 & 3 /= 0 & 1 /= 2 & 1 /= 3 & 2 /= 3

Def 19: [Cardinal sum] Def(n PLUS m) = #({[x,0]: x in n} + {[x,1]: x in m})
Def 20: [Cardinal product] Def(N TIMES M) := #(N PROD M)
Def 21: pow(s) := {x: x incin s}
Def 22: [Cardinal Difference] Def(N MINUS M) := #(N - M)
Def 23: [Integer Quotient] Def(M OVER N) := Un({k in Z | k TIMES N incin M})
    [Note that x/0 = Z for x in Z]
Def 24: [Integer Remainder] Def(M MOD N) := M MINUS ((M OVER N) TIMES N)

* Theorem 122: {[x,0]: x in N} * {[x,1]: x in M} = 0
* Theorem 123: is_map(0) & Svm(0) & one_1_map(0) & range(0) = 0 & domain(0) = 0
* Theorem 124: Svm({[X,Y]}) & one_1_map({[X,Y]}) & {[X,Y]}~[X] = Y
* Theorem 125: (X /= Z) imp ({[X,Y],[Z,W]}~[X] = Y) 
* Theorem 126: #{[x,0]: x in M} = #M & #{[x,1]: x in N} = #N

* Theorem 127: N PLUS M = #N PLUS #M
* Theorem 128: N PLUS M = N PLUS #M
* Theorem 129: N TIMES M = #N TIMES #M
* Theorem 130: N TIMES M = N TIMES #M
* Theorem 131: (Finite(N) & M incin N & M /= N) imp (#M in #N)

THEORY finite_induction(n,P)
    Finite(n) & P(n)
==>(m)
    m incin n & P(m) & (FORALL k incin m | ((k /= m) imp (not P(k))))
END finite_induction;

* Theorem 132: Finite(N) & Finite(M) eq Finite(N + M) 
* Theorem 133: Finite(N PLUS M) eq Finite(N + M)
* Theorem 134: Finite(N) & Finite(M) eq Finite(N PLUS M)
* Theorem 135: N PROD 0 = 0 & 0 PROD N = 0
* Theorem 136: N TIMES 0 = 0
* Theorem 137: 0 TIMES N = 0
* Theorem 138: #N PLUS 0 = #N
* Theorem 139: #({C} PROD N) = #N
* Theorem 140: #(N PROD {C}) = #N
* Theorem 141: 1 TIMES N = #N
* Theorem 142: N TIMES 1 = #N
* Theorem 143: (M /= 0) imp (#(N PROD M) incs #N)
* Theorem 144: N PLUS M = #((N PROD {0}) + (M PROD {1}))
* Theorem 145: (A * B = 0) imp ((X PROD A) * (Y PROD B) = 0)
* Theorem 146: N PLUS M = M PLUS N
* Theorem 147: N TIMES M = M TIMES N
* Theorem 148: (A PROD X * B PROD X) = (A * B) PROD X & (A PROD X + B PROD X) = (A + B) PROD X & 
            (X PROD A * X PROD B) = X PROD (A * B) & (X PROD A + X PROD B) = X PROD (A + B)
* Theorem 149: N PLUS (M PLUS K) = (N PLUS M) PLUS K
* Theorem 150: N TIMES (M TIMES K) = (N TIMES M) TIMES K
* Theorem 151: N TIMES (M PLUS K) = (N TIMES M) PLUS (N TIMES K)
* Theorem 152: (Finite(N) & Finite(M)) imp Finite(N TIMES M)
* Theorem 153: ((Finite(N) & Finite(M)) or (N = 0 or M = 0)) eq Finite(N TIMES M)
* Theorem 154: pow(0) = {0}
* Theorem 155: Finite(N) eq Finite(pow(N))
* Theorem 156: [Cantor's Theorem] #N in #pow(N)

* Theorem 157: N MINUS N = 0
* Theorem 158: N MINUS 0 = #N 
* Theorem 159: [Disjoint sum Lemma] (N * M = 0) imp (N PLUS M = #(N + M))
* Theorem 160: (N * M = 0 & N2 * M2 = 0 & #N = #N2 & #M = #M2) imp (#(N + M) = #(N2 + M2))
* Theorem 161: [Subtraction Lemma] (M incin N) imp (#N = #M PLUS (N MINUS M))
* Theorem 162: [Subtraction Lemma] (#M in #N or #M = #N) imp (#N = #M PLUS (#N MINUS #M)) 

Def 25: [Union Set]: Un(S) := {x: x in y, y in S}

* Theorem 163: [Union set as an upper bound] 
    (FORALL x in S | x incin Un(S)) & ((FORALL x in S | x incin T) imp (Un(S) incin T))
* Theorem 164: [The union of a set of ordinals is an ordinal] (FORALL x in S | Ord(x)) imp Ord(Un(S))
* Theorem 165: (M /= 0) imp (N OVER M incin N)
* Theorem 166: (M /= 0 & N in Z) imp (N OVER M in Z & N OVER M incin N)
* Theorem 167: (N in Z & M in Z) imp (N PLUS M in Z & N TIMES M in Z & N MINUS M in Z)
* Theorem 169: [Strict monotonicity of addition] (M in Z & N in Z & N /= 0) imp (M in M PLUS N)
* Theorem 170: [Strict monotonicity of addition] (M in Z & N in Z & K in N) imp (M PLUS K in M PLUS N)
* Theorem 171: [Cancellation] (M in Z & N in Z & K in Z & M PLUS K = N PLUS K) imp (M = N)
* Theorem 172: [Monotonicity of Addition] (M incin N) imp (M PLUS K incin N PLUS K)
* Theorem 173: [Monotonicity of Multiplication] (M incin N) imp (M TIMES K incin N TIMES K)
* Theorem 174: [Monotonicity of Addition] (M in Z & N in Z & K in Z) imp (M PLUS K incin N PLUS K eq M incin N)
* Theorem 175: [Strict monotonicity of subtraction] (N in Z & K in N & M incs N) imp (M MINUS N in M MINUS K)
* Theorem 176: (M in Z & N in Z & K in Z & N incs M & N MINUS M incs K) imp 
                (N incs M PLUS K & N MINUS (M PLUS K) = (N MINUS M) MINUS K)
* Theorem 177: (M in Z & N in Z) imp ((M PLUS N) MINUS N = M)
* Theorem 178: [Integer Division with Remainder] (M in Z & N in Z & N /= 0) imp 
            (M OVER N in Z & M incs ((M OVER N) TIMES N) & M MOD N in N)
* Theorem 179: #{S} = {{}}
* Theorem 180: (#N = 0) imp (N = 0)
* Theorem 181: #N TIMES #M = 0 eq N = 0 or M = 0
* Theorem 182: (N incs M) imp ((N MINUS K) incs (M MINUS K))
* Theorem 183: (Finite(N) & N incs M) imp (#(N - M) = #(#N - #M))
* Theorem 184: (N in Z & M in Z) imp ((N PLUS M) MINUS M = N)
* Theorem 185: (N in Z & M in Z & K in Z) imp ((N incs M) eq ((N PLUS K) incs (M PLUS K)))
* Theorem 186: (N incs M) imp (#N = #M PLUS #(N - M))
* Theorem 187: (N in Z & M in Z & K in Z & N incs M) imp ((N PLUS K) MINUS (M PLUS K) = N MINUS M)
* Theorem 188: (N in Z & M in Z) imp (N = M PLUS (N MINUS M) or N = M MINUS (M MINUS N))

THEORY ordval_fcn(s,f);         [Elementary functions of ordinal-valued functions]
    s /= 0 & (FORALL x in s | Ord(f(x)))
==>(rng)
    rng = {x: x in s | f(x) = arb({f(y): y in s})} & rng /= 0 & (FORALL x in rng | (FORALL y in s | f(x) incin f(y)))
    rng incin s
END ordval_fcn;

THEORY well_ordered_set(s,Ordrel);
    (FORALL x in s | (FORALL y in s | ((Ordrel(x,y) or Ordrel(y,x) or x = y)) & (not Ordrel(x,x)))) & 
      (FORALL x in s | (FORALL y in s | (FORALL z in s | (Ordrel(x,y) & Ordrel(y,z)) imp Ordrel(x,z)))) &
        (FORALL t incin s | ((t /= 0) imp (EXISTS x in t | (FORALL y in t | (Ordrel(x,y) or x = y)))))
==>(orden)
    s incin {orden(y): y in X} eq orden(X) = s 
    (orden(X) /= s) imp (orden(X) in s)
            [Well-ordering is isomorphic to ordinal enumeration] 
    (Ord(U) & Ord(V) & orden(U) /= s & orden(V) /= s) imp (Ordrel(orden(U),orden(V)) eq U in V) 
    (Ord(U) & orden(U) /= s) imp (orden(U) = {orden(x): x in U})
    (Ord(U) & Ord(V) & orden(U) /= s & orden(V) /= s & U /= V) imp (orden(U) /= orden(V))
    (EXISTS o | Ord(o) & s = {orden(x): x in o} & (FORALL x in o | orden(x) /= s) & one_1_map({[x,orden(x)]: x in o}))
    (Ord(V) & orden(V) /= s) imp (one_1_map({[x,orden(x)]: x in V}) & 
        domain({[x,orden(x)]: x in V}) = V & range({[x,orden(x)]: x in V}) = {u: u in s |  Ordrel(u,orden(V))})
END well_ordered_set;

* Theorem 189: [One-more Lemma] (not Finite(S)) imp (#S = #(S + {C}))
* Theorem 190: [Division-by-2 Lemma] (not Finite(S)) imp (EXISTS T | #(T PROD {0,1}) = #S)
* Theorem 191: [Cardinal Doubling Theorem] (Card(S) & (not Finite(S))) imp (#(S PROD {0,1}) = #S)
* Theorem 192: (not Finite(S)) imp (S PLUS T = #S + #T & #(S + T) = #S + #T)
* Theorem 193: [Cardinal Square-root Lemma] (not Finite(S)) imp (EXISTS T | #(T PROD T) = #S)
* Theorem 194: [Cardinal Square Theorem] (not Finite(S)) imp (#(S PROD S) = #S)
* Theorem 195: (T in S & Card(S) & (not Finite(S))) imp (S TIMES T = S)
    
Def 26: [Signed Integers] Si := {[x,y]: x in Z, y in Z | x = 0 or y = 0}
Def 27: [Signed Integer Reduction to Normal Form] 
    Red(P) := [car(P) MINUS (car(P) * cdr(P)),cdr(P) MINUS (car(P) * cdr(P))]
Def 28: [Signed Sum] 
    Def(MM S_PLUS NN) := Red([car(MM) PLUS car(NN),cdr(MM) PLUS cdr(NN)])
Def 28a: [Absolute value] S_ABS(M) := car(M) + cdr(M)
Def 28b: [Negative] S_Rev(M) := [cdr(M),car(M)]
Def 29: [Signed Product] Def(MM S_TIMES NN) := 
      Red([(car(M) TIMES car(N)) PLUS (cdr(M) TIMES cdr(N)),(car(M) TIMES cdr(N)) PLUS (car(N) TIMES cdr(M))])
Def 32: [Signed Difference] Def(N S_MINUS M) := Red([cdr(M) PLUS car(N),car(M) PLUS cdr(N)])
Def 33: [Sign of a signed integer] is_nonneg(x) := car(x) incs cdr(x)

* Theorem 196: (M in Z & N in Z) imp (Red([M,N]) in Si & M * N in Z)
* Theorem 197: (N in Si) imp (N = [car(N),cdr(N)] & (car(N) = 0 or cdr(N) = 0) & car(N) in Z & cdr(N) in Z & 
                        Red(N) = N & car(N) * cdr(N) in Z)
* Theorem 199: (N in Si & M in Si) imp (N S_PLUS M in Si & N S_TIMES M in Si)
* Theorem 200: (N in Z) imp (Red([N,N]) = [0,0])
* Theorem 201: (J in Z & K in Z & M in Z) imp (Red([J PLUS M,K PLUS M]) = Red([J,K]))
* Theorem 202: (J in Z & K in Z & N in Z & M in Z) imp ([J,K] S_PLUS [N,M] = [J,K] S_PLUS Red([N,M]))
* Theorem 203: (K in Si & N in Z & M in Z) imp (K S_PLUS [N,M] = K S_PLUS Red([N,M]))
* Theorem 204: (K in Si & N in Z & M in Z) imp (K S_TIMES [N,M] = K S_TIMES Red([N,M]))
* Theorem 205: [Commutativity Lemma] (K in Si & N in Z & M in Z) imp (K S_PLUS [N,M] = [N,M] S_PLUS K)
* Theorem 206: [Commutativity Lemma] (J in Z & K in Z & N in Z & M in Z) imp ([J,K] S_PLUS [N,M] = [N,M] S_PLUS [J,K])
* Theorem 207: [Commutative Law for Addition] (N in Si & M in Si) imp (N S_PLUS M = M S_PLUS N)
* Theorem 208: (J in Z & K in Z & N in Z & M in Z) imp ([J,K] S_PLUS [N,M] = Red([J,K]) S_PLUS Red([N,M]))
* Theorem 209: [Commutative Law for Multiplication] (N in Si & M in Si) imp (N S_TIMES M = M S_TIMES N)
* Theorem 210: [Associative Law] (K in Si & N in Si & M in Si) imp (N S_PLUS (M S_PLUS K) = (N S_PLUS M) S_PLUS K)
* Theorem 211: [Distributive Law] 
    (K in Si & N in Si & M in Si) imp (N S_TIMES (M S_PLUS K) = (N S_TIMES M) S_PLUS (N S_TIMES K))
* Theorem 212: (N in Z) imp (Red([N,0]) = [N,0])
* Theorem 213: [Embedding of Integers in Signed Integers]
     (N in Z & M in Z) imp ([N PLUS M,0] = [N,0] S_PLUS [M,0] & [N TIMES M,0] = [N,0] S_TIMES [M,0] & 
                              (N incs M) imp ([N,0] S_MINUS [M,0] = [N MINUS M,0]))
* Theorem 214: (N in Z & M in Z) imp (S_Rev(Red([M,N])) = Red([N,M]))
* Theorem 215: (N in Si & M in Si) imp (N S_TIMES S_Rev(M) = S_Rev(N S_TIMES M))
* Theorem 216: [Inversion Lemma] (N in Si & M in Si) imp 
          (S_Rev(N S_TIMES M) = S_Rev(N) S_TIMES M & S_Rev(N S_TIMES M) = N S_TIMES S_Rev(M))
* Theorem 217: [Double inversion] (K in Si) imp (S_Rev(S_Rev(K)) = K)
* Theorem 218: (N in Si) imp (S_Rev(N) in Si & S_Rev(N) S_PLUS N = [0,0] & S_Rev(S_Rev(N)) = N)
* Theorem 219: [Associativity Lemma] 
    (K in Z & N in Z & M in Z) imp ([N,0] S_TIMES ([M,0] S_TIMES [K,0]) = ([N,0] S_TIMES [M,0]) S_TIMES [K,0])
* Theorem 220: [Associativity Lemma] 
    (K in Si & N in Z & M in Z) imp ([N,0] S_TIMES ([M,0] S_TIMES K) = ([N,0] S_TIMES [M,0]) S_TIMES K)
* Theorem 221: [Associativity Lemma] 
    (K in Si & N in Z & M in Si) imp ([N,0] S_TIMES (M S_TIMES K) = ([N,0] S_TIMES M) S_TIMES K)
* Theorem 222: [Associative Law] (K in Si & N in Si & M in Si) imp (N S_TIMES (M S_TIMES K) = (N S_TIMES M) S_TIMES K)
* Theorem 223: (N in Si & M in Si) imp (N S_MINUS M = N S_PLUS S_Rev(M))
* Theorem 224: (N in Si & M in Si) imp (N = M S_PLUS (N S_MINUS M)) 
* Theorem 225: (N in Si & M in Si) imp (S_Rev(N S_PLUS M) = S_Rev(N) S_PLUS S_Rev(M))
* Theorem 226: [0,1] S_TIMES [0,1] = [1,0]
* Theorem 227: (K in Si) imp (K S_TIMES [1,0] = K)
* Theorem 228: (K in Si & M in Si) imp (K S_MINUS M = K S_PLUS (M S_TIMES [0,1]))
* Theorem 229: (K in Si) imp (K S_MINUS K = [0,0])
* Theorem 230: (K in Si) imp (K S_PLUS [0,0] = K)
* Theorem 231: (K in Si) imp ([0,0] S_PLUS K = K)

* Theorem 232: [Si is an Integral Domain] 
    (FORALL n in Si | (FORALL m in Si | ((m S_TIMES n = [0,0]) imp (m = [0,0] or n = [0,0]))))
* Theorem 233: [Distributivity of Subtraction] 
    (FORALL n in Si | (FORALL m in Si | (FORALL k in Si | ((m S_TIMES n) S_MINUS (k S_TIMES n) = (m S_MINUS k) S_TIMES n))))
* Theorem 234: [Si Cancellation] 
    (FORALL n in Si | (FORALL m in Si | (FORALL k in Si | ((m S_TIMES n = k S_TIMES n & n /= [0,0]) imp (m = k)))))
* Theorem 235: [Multiplication by -1] (FORALL n in Si | S_Rev(n) = [0,1] * S_TIMES N)

THEORY ordinal_induction(o,P)
    Ord(o) & P(o)
==>(t)
    Ord(t) & P(t) & t incin o & (FORALL x in t | (not P(x)))
END ordinal_induction

Def 35a: Ult_membs(s) := s + {y: u in {Ult_membs(x): x in s},y in u} [Transitive membership closure of s]

* Theorem 236: S incin Ult_membs(S)
* Theorem 237: Ult_membs(S) = S + {y: x in S, y in Ult_membs(x)}
* Theorem 238: (X in S & Y in X) imp (Y in Ult_membs(S))
* Theorem 239: (Ord(S)) imp (Ult_membs(S) = S)
* Theorem 240: Ult_membs({S}) = {S} + Ult_membs(S)
* Theorem 241: Ord(S) imp (Ult_membs({S}) = S + {S})
* Theorem 242: (Y in Ult_membs(S) imp (Ult_membs(Y) incin Ult_membs(S))
* Theorem 243: (Y in Ult_membs(S) imp (Y incin Ult_membs(S))

THEORY transfinite_member_induction(n,P)
    P(n)
==>(m)
    m in Ult_membs({n}) & P(m) & (FORALL n in m | (not P(n)))
END transfinite_member_induction;

THEORY double_transfinite_induction(n,k,R)
    R(n,k)
==>(m,j)
    R(m,j) & (FORALL n in m | (not R(n,L))) & (FORALL i in j | (not R(m,i)))
END double_transfinite_induction;

THEORY mathematical_induction(P)
    n in Z & P(n)
==>(m)
    m in Z & P(m) & (FORALL n in m | (not P(n)))
END mathematical_induction;

THEORY double_induction(R)
    n in Z & k in Z & R(n,k)
==>(m,j)
    m in Z & j in Z & P(m,j) & (FORALL n in m | (not R(n,L))) & (FORALL i in j | (not R(m,i)))
END double_induction;

THEORY sigma_theory(s,PLUZ,e)  
    e in s;
    (FORALL x in s | x PLUZ e = x)
    (FORALL x in s | (FORALL y in s | x PLUZ y = y PLUZ x))
    (FORALL x in s | (FORALL y in s | (FORALL z in s | (x PLUZ y) PLUZ z = (x PLUZ y) PLUZ z)))
==>
    (Finite(F) & Svm(F) & range(F) incin s & Y in s) imp 
    (sigma(F) in s & sigma(F) = sigma(F * S) PLUZ sigma(F - S) & sigma(0) = e & sigma({[X,Y]}) = Y)
END sigma_theory;

THEORY equivalence_classes(P)  [Theory of equivalence classes]
    (FORALL x in s | (FORALL y in s | (P(x,y) eq P(y,x)) & P(x,x)))
    (FORALL x in s | (FORALL y in s | (FORALL z in s | ((P(x,y) & P(y,z)) imp P(x,z)))))
==> (Eqc,f)
    (FORALL x in s | f(x) in Eqc) & (FORALL y in Eqc | (arb(y) in s & f(arb(y)) = y))
    (FORALL x in s | (FORALL y in s | P(x,y) eq f(x) = f(y)))
    (FORALL x in s | P(x,arb(f(x))))
END equivalence_classes;

Def 35: Fr := {[x,y]: x in Si, y in Si | y /= [0,0]}
Def 36: Same_frac(P,Q) := car(P) S_TIMES cdr(Q) = cdr(P) S_TIMES car(Q)

* Theorem 245: (FORALL x in Fr | (FORALL y in Fr | ((Same_frac(x,y) eq Same_frac(y,x)) & Same_frac(x,x))))
* Theorem 246: (FORALL x in Fr | (FORALL y in Fr | (FORALL z in Fr | 
            ((Same_frac(x,y) & Same_frac(y,z)) imp Same_frac(x,z)))))

* Theorem 247: (FORALL y in Ra | (arb(y) in Fr & Fr_to_Ra(arb(y)) = y)) & (FORALL x in Fr | Fr_to_Ra(x) in Ra) & 
                (FORALL x in Fr | (FORALL y in Fr | Same_frac(x,y) eq Fr_to_Ra(x) = Fr_to_Ra(y))) &
                  (FORALL x in Fr | Same_frac(x,arb(Fr_to_Ra(x))))

Def 37: Ra_0 := Fr_to_Ra([[0,0],[1,0]]) 
Def 37a: Ra_1 := Fr_to_Ra([[1,0],[1,0]])
Def 38: [Rational Sum] Def(X Ra_PLUS Y) := 
    Fr_to_Ra([(car(arb(X)) S_TIMES cdr(arb(Y))) S_PLUS (car(arb(Y)) S_TIMES cdr(arb(X))),
                                  cdr(arb(X)) S_TIMES cdr(arb(Y))])
Def 38: [Rational product] 
    Def(X Ra_TIMES Y := Fr_to_Ra([car(arb(X)) S_TIMES car(arb(Y)),cdr(arb(X)) S_TIMES cdr(arb(Y))])
Def 40: [Reciprocal] Recip(X) := Fr_to_Ra([cdr(arb(X)),car(arb(X))])
Def 41: [Rational quotient] Def(X Ra_OVER Y) := X Ra_TIMES Recip(Y)
Def 42: [Rational negative] 
    Ra_Rev(X) := Fr_to_Ra([S_Rev(car(arb(X))),cdr(arb(X))])
Def 43: [Nonnegative Rational] Ra_is_nonneg(X) := is_nonneg(car(arb(X)) S_TIMES cdr(arb(X)))
Def 44: [Rational Subtraction] Def(X Ra_MINUS Y) := X Ra_PLUS Ra_Rev(Y)
Def 45: [Rational Comparison] Def(X Ra_GT Y) := Ra_is_nonneg(X Ra_MINUS Y) & X /= Y    [No longer needed]

THEORY Ordered_add(g,e,pluz,minz,rvz,nneg);
    e in g & (FORALL x in g | (x pluz e = x & x pluz rvz(x) = e & rvz(x) in g))
    (FORALL x in g | (FORALL y in g | (x pluz y in g & x pluz y = y pluz x & x pluz rvz(y) = x minz y))) 
    (FORALL x in g | (FORALL y in g | (FORALL z in g | ((x pluz y) pluz z = x pluz (y pluz z)))))
    (FORALL x in g | (FORALL y in g | ((nneg(x) & nneg(y)) imp nneg(x pluz y))))
    (FORALL x in g | ((nneg(x) or nneg(rvz(x))) & (nneg(x) & nneg(rvz(x)))) imp (x = e)))
==>(g_GE,g_LE,g_GT,g_LT)
    X g_GE Y eq nneg(X pluz rvz(Y))
    X g_LE Y eq Y g_GE X
    X g_GT Y eq X g_GE Y & X /= Y
    X g_LT Y eq Y g_GT X
END Ordered_add;

* Theorem 248: (X in Si) imp ((is_nonneg(X) or is_nonneg(S_Rev(X))) & ((is_nonneg(X) & is_nonneg(S_Rev(X))) imp (X = [0,0])))
* Theorem 249: ((X in Si & Y in Si & is_nonneg(X) & is_nonneg(Y))) imp (is_nonneg(X S_PLUS Y) & is_nonneg(X S_TIMES Y))
* Theorem 250: (X in Si) imp is_nonneg(X S_TIMES X)
* Theorem 251: (X in Si & Y in Si & X /= [0,0] & is_nonneg(X)) imp (is_nonneg(X S_TIMES Y) eq is_nonneg(Y))
* Theorem 252: X in Fr eq (X = [car(X),cdr(X)] & car(X) in Si & cdr(X) in Si & cdr(X) /= [0,0])
* Theorem 253: (N in Ra) imp (arb(N) in Fr & arb(N) = [car(arb(N)),cdr(arb(N))] & car(arb(N)) in Si & 
                                cdr(arb(N)) in Si & cdr(arb(N)) /= [0,0])
* Theorem 254: (X in Fr & Y in Fr & Same_frac(X,Y) & W in Fr & Z in Fr & Same_frac(W,Z)) imp 
    Same_frac([(car(X) S_TIMES cdr(W)) S_PLUS (car(W) S_TIMES cdr(X)),cdr(X) S_TIMES cdr(W)],
      [(car(Y) S_TIMES cdr(Z)) S_PLUS (car(Z) S_TIMES cdr(Y)),cdr(Y) S_TIMES cdr(Z)]). 

* Theorem 255: (X in Fr & Y in Fr & Same_frac(X,Y) & W in Fr & Z in Fr & Same_frac(W,Z)) imp 
    Same_frac([car(X) S_TIMES car(W),cdr(X) S_TIMES cdr(W)],[car(Y) S_TIMES car(Z),cdr(Y) S_TIMES cdr(Z)])
* Theorem 256: (X in Ra & Y in Si & Z in Si & Z /= [0,0]) imp (X Ra_PLUS Fr_to_Ra([Y,Z]) = 
    Fr_to_Ra([(car(arb(X)) S_TIMES Z) S_PLUS (cdr(arb(X)) S_TIMES Y),(cdr(arb(X)) S_TIMES Z)]))
* Theorem 257: (X in Ra & Y in Si & Z in Si & Z /= [0,0]) imp (X Ra_TIMES Fr_to_Ra([Y,Z]) = 
                        Fr_to_Ra([car(arb(X)) S_TIMES Y,cdr(arb(X)) S_TIMES Z]))
* Theorem 258: (X in Fr) imp Same_frac(X,[Si_Rev(car(X)),Si_Rev(cdr(X))])
* Theorem 259: (X in Fr & Y in Fr & Same_frac(X,Y) & is_nonneg(cdr(X)) & is_nonneg(cdr(Y))) imp 
              ((is_nonneg(car(X)) or car(X) = [0,0]) eq (is_nonneg(car(Y)) or car(Y) = [0,0]))
* Theorem 261: (X in Fr & Y in Fr & Same_frac(X,Y)) imp (is_nonneg(car(X) S_TIMES cdr(X)) eq is_nonneg(car(Y) S_TIMES cdr(Y)))
* Theorem 262: (X in Fr) imp (Ra_is_nonneg(X) eq Ra_is_nonneg([S_Rev(car(X)),S_Rev(cdr(X))]))
* Theorem 263: (X in Fr & Y in Fr & Same_frac(X,Y)) imp (Ra_is_nonneg(X) eq Ra_is_nonneg(Y))
* Theorem 264: [Commutativity of Addition] (N in Ra & M in Ra) imp (N Ra_PLUS M = M Ra_PLUS N)
* Theorem 265: (X in Ra & Y in Si & Z in Si & Z /= [0,0]) imp (Fr_to_Ra([Y,Z]) Ra_PLUS X = 
    Fr_to_Ra([(car(arb(X)) S_TIMES Z) S_PLUS (cdr(arb(X)) S_TIMES Y),(cdr(arb(X)) S_TIMES Z)]))
* Theorem 266: (X in Si & Y in Si & Z in Si & W in Si & Y /= [0,0] & W /= [0,0]) imp 
        (Fr_to_Ra([X,Y]) Ra_PLUS Fr_to_Ra([Z,W]) = Fr_to_Ra([(X S_TIMES W) S_PLUS (Z S_TIMES Y),Y S_TIMES W]))
* Theorem 267: [Commutativity of Multiplication] (N in Ra & M in Ra) imp (N Ra_TIMES M = M Ra_TIMES N)
* Theorem 268: (X in Ra & Y in Si & Z in Si & Z /= [0,0]) imp (Fr_to_Ra([Y,Z]) Ra_TIMES X = 
                        Fr_to_Ra([car(arb(X)) S_TIMES Y,cdr(arb(X)) S_TIMES Z]))
* Theorem 269: (K in Ra & N in Ra & M in Ra) imp (N Ra_PLUS (M Ra_PLUS K) = (N Ra_PLUS M) Ra_PLUS K)
* Theorem 270: (M in Ra) imp (M = M Ra_PLUS Ra_0) 
* Theorem 271: (M in Ra) imp (M Ra_PLUS Ra_Rev(M) = Ra_0) 
* Theorem 272: (N in Ra & M in Ra)) imp (N = M Ra_PLUS (N Ra_MINUS M))
* Theorem 273: (K in Ra & N in Ra & M in Ra) imp (N Ra_TIMES (M Ra_TIMES K) = (N Ra_TIMES M) Ra_TIMES K)
* Theorem 274: 
    (K in Si & N in Si & M in Si & K /= [0,0] & M /= [0,0]) imp (Fr_to_Ra([N,M]) = Fr_to_Ra([K S_TIMES N,K S_TIMES M]))
* Theorem 275: (K in Ra & N in Ra & M in Ra) imp (N Ra_TIMES (M Ra_PLUS K) = (N Ra_TIMES M) Ra_PLUS (N Ra_TIMES K))
* Theorem 276: (X in Si & Y in Si & Y /= [0,0]) imp (Ra_is_nonneg(Fr_to_Ra([X,Y])) eq is_nonneg(X S_TIMES Y))
* Theorem 277: (M in Ra) imp (M = M Ra_TIMES Ra_1) 
* Theorem 278: (M in Ra & M /= Ra_0)) imp (Recip(M) in Ra & M Ra_TIMES Recip(M) = Ra_1) 
* Theorem 279: (N in Ra & M in Ra & M /= Ra_0) imp (N = M Ra_TIMES (N Ra_OVER M))
* Theorem 280: Ra_is_nonneg(Ra_0) & Ra_is_nonneg(Ra_1)
* Theorem 281: 
 (X in Ra) imp ((Ra_is_nonneg(X) or Ra_is_nonneg(Ra_Rev(X))) & ((Ra_is_nonneg(X) & Ra_is_nonneg(Ra_Rev(X))) imp (X = Ra_0)))
* Theorem 282: (X in Ra) imp (X = X Ra_TIMES Ra_1)
* Theorem 283: (X in Ra) imp (X = Ra_0 eq car(arb(X)) = [0,0])
* Theorem 284: (X in Ra & Y in Ra & Ra_is_nonneg(X) & Ra_is_nonneg(Y)) imp 
          (Ra_is_nonneg(X Ra_PLUS Y) & Ra_is_nonneg(X Ra_TIMES Y))
* Theorem 291: (X in Ra & Y in Ra & X1 in Ra & X Ra_GT Y & X1 Ra_GT Ra_0) imp (X Ra_TIMES X1 Ra_GT Y Ra_TIMES X1) 
* Theorem 292: Ra_1 Ra_GT Ra_0
* Theorem 293: (X in Ra & X Ra_GT Ra_0) imp (Recip(X) Ra_GT Ra_0)
* Theorem 294: (X in Ra & Y in Ra & X Ra_GT Y) imp 
      (X Ra_GT (X Ra_PLUS Y) Ra_OVER (Ra_1 + Ra_1) & (X Ra_PLUS Y) Ra_OVER (Ra_1 + Ra_1) Ra_GT Y)

Def 46: [The Real numbers as the set of Dedekind cuts]
    Re := {s: s incin Ra | s /= 0 & s /= Ra &
      (FORALL x in s | (EXISTS y in s | y Ra_GT x)) & (FORALL x in s | (FORALL y in Ra | (x Ra_GT y) imp (y in s)))}
Def 47: [Real 0 and 1] R_0 := {x in Ra | Ra_0 Ra_GT x} & R_1 := {x in Ra | Ra_1 Ra_GT x}
Def 48: [Real Sum] Def(X R_PLUS Y) := {u Ra_PLUS v: u in X and v in Y}
Def 49: [Real Negative] R_Rev(X) := {Ra_Rev(u) Ra_PLUS v: u in Ra - u, v in R_0}
Def 50: [Real Subtraction] Def(X R_MINUS Y) := X R_PLUS R_Rev(Y)
Def 51: [Absolute value] abs(X) := X + R_Rev(X) 
    [i.e. the larger of X and R_Rev(X); note here and below that '+' designates the set union]
Def 52: [Real Multiplication of Absolute Values] 
    Def(X R_TIMES_ABS Y) := 
      {u Ra_TIMES v: u in abs(X) and v in abs(Y) | not(Ra_0 Ra_GT u or Ra_0 Ra_GT v)} + R_0
Def 53: [Real Multiplication] Def(X R_TIMES Y) := if X incs R_0 eq Y incs R_0 then X R_TIMES_ABS Y 
                            else R_Rev(X R_TIMES_ABS Y) end if
Def 54: [Real Absolute Reciprocal] 
    R_ABS_Recip(X) := Un({y: y in Re | abs(X) R_TIMES y incin ({r in Ra | Fr_to_Ra([1,1]) Ra_GT r})})
Def 55: [Real Reciprocal] 
    R_Recip(X) := if X incs R_0 then R_ABS_Recip(X) else R_Rev(R_ABS_Recip(X)) end if
Def 56: [Real Quotient] Def(X R_OVER Y) := X R_TIMES R_Recip(Y)
Def 56a: [Non-negative Real] R_is_nonneg(X) := R_0 incin X 
Def 56b: [Real Comparison] Def(X R_GT Y) := R_is_nonneg(X R_MINUS Y) & (not (X = Y))
Def 56c: [Real Comparison] Def(X R_GE Y) := R_is_nonneg(X R_MINUS Y)
Def 57: [Real square root] sqrt(x) := Un({y: y in Re | (y R_TIMES y) incin x})

* Theorem 295: (X in Ra) imp ({y: y in Ra | X Ra_GT y} in Re)
* Theorem 296: R_0 in Re & R_1 in Re & R_is_nonneg(R_0) & R_is_nonneg(R_1) & R_1 R_GT R_0
* Theorem 297: (N in Re) imp (N incin Ra)
* Theorem 298: (N in Re) imp (EXISTS m in Ra | (FORALL x in N | m Ra_GT x))
* Theorem 299: (N in Re & M in Re) imp (N R_PLUS M in Re)
* Theorem 300: (N in Re & M in Re) imp (N R_PLUS M = M R_PLUS N)
* Theorem 301: (N in Re) imp (N = N R_PLUS R_0)
* Theorem 302:( N in Re) imp (R_Rev(N) in Re)
Theorem: (N in Si & M in Si & M /= [0,0] & is_nonneg(M)) ==> 
      (EXISTS k in Si | is_nonneg(N S_MINUS (k S_TIMES M)) & is_nonneg(((k S_PLUS [1,0]) S_TIMES M)) S_MINUS N) 
Theorem: (N in Re) imp (N = N R_PLUS R_Rev(N) = R_0)
* Theorem: (N in Re & M in Re) imp (N incin M or M incin N)
* Theorem: (N in Re & M in Re) imp (N + M in Re)
* Theorem: (N in Re) imp (abs(N) in Re & N incin abs(N))
* Theorem: (N in Re & M in Re) imp (N = M R_PLUS (N R_MINUS M))
* Theorem: (N in Re & M in Re) imp (N R_TIMES_ABS M = M R_TIMES_ABS N)
* Theorem: (N in Re & M in Re) imp (N R_TIMES M = M R_TIMES N)
* Theorem: (N in Re) imp (abs(N) = if R_is_nonneg(N) then N else R_Rev(N) end if)
* Theorem: (N in Re) imp (abs(N) in Re & (abs(N) R_GT N or abs(N) = N) & (abs(N) R_GT R_0 or abs(N) = R_0))
* Theorem: (N in Re) imp (abs(N) = abs(R_Rev(N)))
* Theorem: (N in Re & M in Re & R_is_nonneg(R_Rev(M)))) imp (N R_GT N R_PLUS M or N = N R_PLUS M)
* Theorem: (N in Re & M in Re & R_is_nonneg(N) & (not R_is_nonneg(M))) imp 
    (N R_GT abs(N R_PLUS M) or N = abs(N R_PLUS M) or R_Rev(M) R_GT abs(N R_PLUS M) or R_Rev(M) = abs(N R_PLUS M)) 
* Theorem: (N in Re & M in Re) imp (N R_PLUS abs(M) R_GT n or n R_PLUS abs(M) = n)
* Theorem: (N in Re & M in Re) imp (abs(N) R_PLUS abs(M) R_GT abs(N R_PLUS M) or abs(N) R_PLUS abs(M) = abs(N R_PLUS M)) 
* Theorem: (N in Re & M in Re) imp (abs(N) R_PLUS abs(M) R_GT abs(N R_MINUS M) or abs(N) R_PLUS abs(M) = abs(N R_MINUS M)) 
* Theorem: (N in Re & M in Re) imp (abs(N) R_TIMES abs(M) = abs(N R_TIMES M))
Theorem: (N in Re & M in Re & M /= R_0)) imp (abs(N) R_OVER abs(M) = abs(N R_OVER M))
Theorem: (N in Re & M in Re) imp (N R_TIMES_ABS M in Re)
Theorem: (N in Re & M in Re) imp (N R_TIMES M in Re)
* Theorem: (k in Re & n in Re & m in Re) imp (n R_PLUS (m R_PLUS k) = (n R_PLUS m) R_PLUS k)
* Theorem: R_Rev(R_Rev(N)) = N
Theorem: (k in Re & n in Re & m in Re) imp (n R_TIMES (m R_TIMES k) = (n R_TIMES m) R_TIMES k)
Theorem: (k in Re & n in Re & m in Re) imp (n R_TIMES (m R_PLUS k) = (n R_TIMES m) R_PLUS (n R_TIMES k))
Theorem: (x in Re & y in Re & R_is_nonneg(x) & R_is_nonneg(y)) 
          imp (R_is_nonneg(x R_PLUS y) & R_is_nonneg(x R_TIMES y))
Theorem: (M in Re) imp (M = M R_TIMES R_1) 
Theorem: (M in Re & M /= R_0) imp (Recip(M) in Re & M R_TIMES Recip(M) = R_1) 
Theorem: (N in Re & M in Re & M /= R_0) imp (N = M R_TIMES (N R_OVER M))
Theorem: 
 (X in Re) imp ((R_is_nonneg(X) or R_is_nonneg(R_Rev(X))) & ((R_is_nonneg(X) & R_is_nonneg(R_Rev(X))) imp (X = R_0)))
Theorem: (X in Re) imp (X = X R_TIMES R_1)
* Theorem: (X in Re & Y in Re & R_is_nonneg(X) & R_is_nonneg(Y) & X R_PLUS Y = R_0) imp (X = R_0 & Y = R_0) 
* Theorem: (X in Re & Y in Re & X1 in Re & X R_GT Y & X1 R_GT R_0) imp (X R_TIMES X1 R_GT Y R_TIMES X1 
* Theorem: (X in Re & X R_GT R_0) imp (Recip(X) R_GT R_0)
* Theorem: (X in Re & Y in Re & X R_GT Y) imp 
      (X R_GT (X R_PLUS Y) R_OVER (R_1 + R_1) & (X R_PLUS Y) R_OVER (R_1 + R_1) R_GT Y)

* Theorem: [Least Upper Bound] (S /= 0 & S incin R) imp (Un(S) in Re or Un(S) = Ra)
Theorem: (X in Re & R_is_nonneg(X)) imp (sqrt(X) in Re & R_is_nonneg(sqrt(X)) & sqrt(X) R_TIMES sqrt(X) = X)
* Theorem: (X in Re & Y in Re & Y R_TIMES Y = X & R_is_nonneg(Y)) imp (Y = sqrt(X)) 
* Theorem: (X in Re & R_is_nonneg(X) & Y in Re & R_is_nonneg(Y)) imp (sqrt(X R_TIMES Y) = sqrt(X) R_TIMES sqrt(Y))

Def 58: [Complex Numbers] Cm := Re PROD Re
Def 59: [Complex Sum] Def(X C_PLUS Y) := [car(X) R_PLUS car(Y),cdr(X) R_PLUS cdr(Y)] 
Def 60: [Complex Product] 
    Def(X C_TIMES Y) := [(car(X) R_TIMES car(Y)) R_MINUS (cdr(X) R_TIMES cdr(Y)),
              (car(X) R_TIMES cdr(Y)) R_PLUS (cdr(X) R_TIMES car(Y))] 
Def 61: [Complex Norm] C_abs(X) := sqrt((car(X) R_TIMES car(X)) R_PLUS (cdr(X) R_TIMES cdr(X))) 

Def 62: [Complex reciprocal] 
    C_Recip(x) := [car(x) R_OVER (C_abs(x) R_TIMES C_abs(x)),R_Rev(cdr(x) R_OVER (C_abs(x) R_TIMES C_abs(x)))]
Def 63: [Complex Quotient] Def(X C_OVER Y) := X C_TIMES C_Recip(Y)
Def 63a: C_Rev(X) := [R_Rev(car(X)),R_Rev(cdr(X))]
Def 63b: Def(N C_MINUS M) := N C_PLUS C_Rev(M)
Def 63x: C_0 := [R_0,R_0] 
Def 63y: C_1 := [R_1,R_0]

* Theorem: ((X in Re & Y in Re) imp ([X,Y] in Cm)) & ((m in Cm) imp (m = [car(m),cdr(m)] & car(m) in Re & cdr(m) in Re))
* Theorem: (N in Cm & M in Cm) imp (N C_PLUS M in Cm)
* Theorem: (N in Cm & M in Cm) imp (N C_PLUS M = M C_PLUS N)
* Theorem: (N in Cm) imp (N = N C_PLUS C_0)
* Theorem: (N in Cm) imp (C_Rev(N) in Cm & C_Rev(C_Rev(N)) = N)
* Theorem: (N in Cm) imp (N C_PLUS C_Rev(N) = C_0)
* Theorem: (N in Cm & M in Cm) imp (N = M C_PLUS (N C_MINUS M)) 
* Theorem: (N in Cm & M in Cm) imp (N C_TIMES M = M C_TIMES N)
* Theorem: (N in Cm) imp (C_abs(N) in Re & R_is_nonneg(C_abs(N)))
* Theorem: (N in Cm) imp (C_abs(N) = C_abs(C_Rev(N)))
Theorem: (N in Cm & M in Cm) imp 
      ((C_abs(N) C_PLUS C_abs(M)) R_GT C_abs(N C_PLUS M) or (C_abs(N) C_PLUS C_abs(M) = C_abs(N C_PLUS M))) 
Theorem: (N in Cm & M in Cm) imp (C_abs(N) C_TIMES C_abs(M) = C_abs(N C_TIMES M))
Theorem: (N in Cm & M in Cm & M /= C_0) imp (C_abs(N) R_OVER C_abs(M) = C_abs(N C_OVER M))
* Theorem: (N in Cm & M in Cm) imp (N C_TIMES M in Cm)
* Theorem: (k in Cm & n in Cm & m in Cm) imp (n C_PLUS (m C_PLUS k) = (n C_PLUS m) C_PLUS k)
* Theorem: (k in Cm & n in Cm & m in Cm) imp (n C_TIMES (m C_TIMES k) = (n C_TIMES m) C_TIMES k)
Theorem: (k in Cm & n in Cm & m in Cm) imp (n C_TIMES (m C_PLUS k) = (n C_TIMES m) C_PLUS (n C_TIMES k))
* Theorem: (M in Cm) imp (M = M C_TIMES C_1) 
* Theorem: (M in Cm & M /= C_0) imp (C_Recip(M) in Cm & M C_TIMES C_Recip(M) = C_1) 
* Theorem: (N in Cm & M in Cm & M /= C_0) imp (N = M C_TIMES (N C_OVER M)
* Theorem: C_0 in Cm & C_1 in Cm

Theorem: (n in RF & m in RF) imp (n F_PLUS m = m F_PLUS n)
Theorem: (n in RF & m in RF) imp (n F_PLUS m = m F_PLUS n)
Theorem: (n in RF & m in RF) imp (n F_TIMES m = m F_TIMES n)
Theorem: (k in RF & n in RF & m in RF) imp (n F_PLUS (m F_PLUS k) = (n F_PLUS m) F_PLUS k)
Theorem: (k in RF & n in RF & m in RF) imp (n F_TIMES (m F_TIMES k) = (n F_TIMES m) F_TIMES k)
Theorem: (k in RF & n in RF & m in RF) imp (n F_TIMES (m F_PLUS k) = (n F_TIMES m) F_PLUS (n F_TIMES k))

Theorem: [Cauchy integral theorem]
    is_analytic_CF(f) imp (EXISTS ep in R | (ep incs R_0 & ep /= R_0 & 
       (FORALL crv1| (FORALL crv2| ((is_CD_curv(crv1,R_0,R_1) & is_CD_curv(crv1,R_0,R_1) 
        & crv1~[R_0] = crv1~[R_1] & crv2~[R_0] = crv2~[R_1] & 
         (FORALL x in Interval(R_0,R_1) | (ep incs C_abs(crv1~[x] C_MINUS crv2~[x]))) 
          imp Line_Int(f,crv1,R_0,R_1) = Line_Int(f,crv2,R_0,R_1)))))))

Theorem: [Cauchy integral formula] 
    (is_analytic_CF(f) & domain(f) incs {z in C: C_abs(z) incin R_1}) imp
      ((FORALL z in C | (C_abs(z) incin R_1 and C_abs(z) /= R_1) imp 
 f[z] = Line_Int({[x,f~[x] C_OVER (x C_MINUS z)]: x in C -{z}},
            {[x,C_exp_fcn([R_0,x])]: x in R},R_0,pi R_PLUS pi) 
                            C_OVER [R_0,pi R_PLUS pi]))

--BEGIN HERE ----------------------------------------------------------------------------------------------------

Def 1: [Ordered pair] [x,y] := {{x},{{x},{{y},y}}}

Theorem 1: arb({X}) = X. Proof:
    Suppose_not ==> arb({c}) /= c. 
    ELEM ==> false; Discharge ==> QED

Theorem 1a: arb({{X},X}) = X. Proof:
    Suppose_not ==> arb({{c},c}) /= c. 
    ELEM ==> false; Discharge ==> QED

Theorem 2: arb([X,Y]) = {X}. Proof:
    Suppose_not ==> arb([c,d]) /= {c}
    Use_Def(ordered_pair) ==> arb({{c},{{c},{{d},d}}}) /= {c}
    ELEM ==> false; Discharge ==> QED
    
Theorem 3: arb(arb([X,Y])) = X. Proof: 
    Suppose_not ==> arb(arb([c,d])) /= c
    Use_Def(ordered_pair) ==> arb(arb({{c},{{c},{{d},d}}})) /= c
    ELEM ==> false; Discharge ==> QED

Theorem 4: arb(arb(arb([X,Y] - {arb([X,Y])}) - {arb([X,Y])})) = Y. Proof:
    Suppose_not ==> arb(arb(arb([c,d] - {arb([c,d])}) - {arb([c,d])})) /= d
    (c,d) --> T2 ==> arb([c,d]) = {c}
    EQUAL ==> arb(arb(arb([c,d] - {{c}}) - {{c}})) /= d
    Use_Def(ordered_pair) ==> arb(arb(arb({{c},{{c},{{d},d}}} - {{c}}) - {{c}})) /= c
	()ELEM ==> arb({{c},{{c},{{d},d}}} - {{c}}) = {{c},{{d},d}}
    ELEM ==> false; Discharge ==> QED

Def 2: car(x) := arb(arb(x))
Def 3: cdr(x) := arb(arb(arb(x - {arb(x)}) - {arb(x)}))

Theorem 5: car([X,Y]) = X. Proof:
	T3,D2. KBAlgebraic ==> QED

Theorem 6: cdr([X,Y]) = Y. Proof: 
	T4,D3. KBAlgebraic ==> QED

Theorem 7:[Ordered pair Property] [X,Y] = [car([X,Y]),cdr([X,Y])]. Proof: 
	T5,T6. KBAlgebraic ==> QED

THEORY setformer(e,ep,s,p,pp)      [Elementary properties of setformers]
     (FORALL x in s | e(x) = ep1(x)) & (FORALL x in s | p(x) eq pp1(x))
==>
END setformer;

ENTER_THEORY setformer
Theorem: {e(x): x in s | p(x)} = {ep1(x): x in s | pp1(x)}. Proof:
    Suppose_not ==> {e(x): x in s | p(x)} /= {ep1(x): x in s | pp1(x)}
    Memb(c) ==> Stat1: ((c in {e(x): x in s | p(x)} & (not (c in {ep1(x): x in s | pp1(x)}))) or 
        (not(c in {e(x): x in s | p(x)} & c in {ep1(x): x in s | pp1(x)})))
    (a,a,b,b) --> Stat1 ==> ((a in s & c = e(a) & p(a)) & (a in s & (not(c = ep1(a) & pp1(a))))) or 
                ((b in s & (not(c = e(b)) & p(b))) & (b in s & c = ep1(b) & pp1(b)))
    (a,a) --> Assump ==> ((a in s) imp (e(a) = ep1(a))) & ((a in s) imp (p(a) eq pp1(a)))
    (b,b) --> Assump ==> ((b in s) imp (e(b) = ep1(b))) & ((b in s) imp (p(b) eq pp1(b)))
    ELEM ==> false; Discharge ==> QED

ENTER_THEORY set_theory

THEORY setformer0(e,s,p)      [Elementary properties of setformers]
==>
END setformer0;

ENTER_THEORY setformer0

Theorem: (s /= 0) imp ({e(x): x in s} /= 0). Proof:
    Suppose_not ==> s /= 0 & {e(x): x in s} = 0
    Memb(c) ==> c in s
    ELEM ==> Stat1: e(c) notin {e(x): x in s}
    c --> Stat1 ==> not (e(c) = e(c) & c in s)
    ELEM ==> false; Discharge ==> QED

Theorem: ({x in s | P(x)} /= 0) imp ({e(x): x in s | P(x)} /= 0). Proof:
    Suppose_not ==> {x in s | P(x)} /= 0 & {e(x): x in s | P(x)} = 0
    Memb(c) ==> c in {x in s | P(x)}
    Defmemb ==> c in s & P(c) 
    ELEM ==> Stat1: e(c) notin {e(x): x in s | P(x)}
    c --> Stat1 ==> not (e(c) = e(c) & c in s & P(c))
    ELEM ==> false; Discharge ==> QED
    
ENTER_THEORY set_theory

THEORY setformer2(e,ep,f,fp,s,p,pp)     [Elementary properties of setformers]
     (FORALL x in s | f(x) = fp(x)) & 
      (FORALL x in s | (FORALL y in f(x) | e(x,y) = ep2(x,y))) & (FORALL x in s | (FORALL y in f(x) | p(x,y) eq pp2(x,y)))
==>
END setformer2;

ENTER_THEORY setformer2(e,ep,f,fp,s,p,pp)    [More elementary properties of setformers]
    Theorem: {e(x,y): x in s, y in f(x) | p(x,y)} = {ep2(x,y): x in s, y in fp(x) | pp2(x,y)}. Proof:
    Suppose_not ==> {e(x,y): x in s, y in f(x) | p(x,y)} /= {ep2(x,y): x in s, y in fp(x) | pp2(x,y)}
    Memb(c) ==> 
Stat1: (c in {e(x,y): x in s, y in f(x) | p(x,y)} & (not (c in {ep2(x,y): x in s, y in fp(x) | pp2(x,y)}))) or 
        ((not (c in {e(x,y): x in s, y in f(x) | p(x,y)})) & c in {ep2(x,y): x in s, y in fp(x) | pp2(x,y)})
    Defmemb ==> 
    (a,b,a,b,u,v,u,v) --> Stat1 ==> 
         Stat2: (((a in s) & (b in f(a)) & (c = e(a,b)) & p(a,b)) & (not((a in s) & (b in fp(a)) & (c = ep2(a,b)) & pp2(a,b)))) 
                or (not((u in s) & (v in f(u)) & (c = e(u,v)) & p(u,v)) & ((u in s) & (v in fp(u)) & 
                  (c = ep2(u,v)) & pp2(u,v)))
    Suppose ==> (((a in s) & (b in f(a)) & (c = e(a,b)) & p(a,b)) & (not((a in s) & (b in fp(a)) & (c = ep2(a,b)) & pp2(a,b))))
    (a,a,b,a,b) --> Assump ==> 
      ((a in s) imp (f(a) = fp(a))) & 
        (((a in s & b in f(a))) imp (e(a,b) = ep2(a,b))) & ((a in s & b in f(a)) imp (p(a,b) eq pp2(a,b)))
	(Stat2)ELEM ==> false; 
    Discharge ==> Stat3: (not((u in s) & (v in f(u)) & (c = e(u,v)) & p(u,v)) & ((u in s) & (v in fp(u)) & 
                  (c = ep2(u,v)) & pp2(u,v)))
    (u,u,v,u,v) --> Assump ==> 
      ((u in s) imp (f(u) = fp(u))) & ((u in s & v in f(u)) imp (e(u,v) = ep2(u,v))) & 
        ((u in s & v in f(u)) eq (p(u,v) eq pp2(u,v)))

    (Stat3)ELEM ==> false; Discharge ==> QED
    
ENTER_THEORY set_theory
    
THEORY transfinite_induction(n,P)
    P(n)
==>
END transfinite_induction;

ENTER_THEORY transfinite_induction

Theorem transfinite_induction.1: not (FORALL m | (P(m) imp (EXISTS k in m | P(k)))). Proof:
    Suppose_not ==> (FORALL m | (P(m) imp (EXISTS k in m |P(k))))
    Quantif ==> (FORALL m | (P(m) imp (EXISTS k |(k in m & P(k)))))
    Quantif ==> Stat1: (FORALL m | (EXISTS k |(P(m) imp (k in m & P(k)))))
    (X,f) --> Stat1 ==> Stat8: P(X) imp (f(X) in X & P(f(X)))
    Loc_def ==> g1(S) := if S * s_inf = 0 then n else f(arb({g1(x): x in S * s_inf})) end if
    Suppose ==> Stat2: not (FORALL x in s_inf | P(g1(x)))
    c --> Stat2 ==> c in s_inf & (not P(g1(c)))
    Suppose ==> not c in {x in s_inf | not P(g1(x))}
    Defmemb ==> false; Discharge ==> {x in s_inf | not P(g1(x))} /= 0
    Loc_def ==> a:= arb({x in s_inf | not P(g1(x))})
    {x in s_inf | P(g1(x))} --> Ax_ch ==> 
      Stat3: a in {x in s_inf | not P(g1(x))} & a * {x in s_inf | not P(g1(x))} = 0
    a --> Stat3 ==> a in s_inf & (not P(g1(a)))
    Suppose ==> a * s_inf = 0
    Use_Def(g) ==> P(g1(a))
    Defmemb ==> false; Discharge ==> a * s_inf /= 0
    APPLY() setformer0(e(x)->g1(x),s->a * s_inf,p(x)->true) ==> {g1(x): x in a * s_inf} /= 0
    Loc_def ==> gb := arb({g1(x): x in a * s_inf})
    {g1(x): x in a * s_inf} --> Ax_ch ==> Stat4: gb in {g1(x): x in a * s_inf}
    Use_Def(g) ==> g1(a) = f(arb({g1(x): x in a * s_inf}))
    b --> Stat4 ==> gb = g1(b) & b in a * s_inf & g1(a) = f(g1(b))
    Suppose ==> not P(g1(b))
    Suppose ==> Stat5: not (b in {x in s_inf | not P(g1(x))})
    b --> Stat5 ==> not (b in s_inf & (not P(g1(b))))
    ELEM ==> false; Discharge ==> b in {x in s_inf | not P(g1(x))}
    ELEM ==> b in a * {x in s_inf | not P(g1(x))}
    ELEM ==> false; Discharge ==> P(g1(b))
    g1(b) --> Stat8 ==> P(g1(a))
    ELEM ==> false; Discharge ==> Stat6: (FORALL x in s_inf | P(g1(x)))
    APPLY() setformer0(e(x)->g1(x),s->s_inf,p(x)imp true) ==> {g1(x): x in s_inf} /= 0
    Loc_def ==> w := arb({g1(x): s_inf})
    {g1(x): x in s_inf} --> Ax_ch ==> Stat7: w in {g1(x): x in s_inf} & w * {g1(x): x in s_inf} = 0
    z --> Stat7 ==> w = g1(z) & z in s_inf
    z --> Stat6 ==> P(g1(z))
    z --> Ax_infinity ==> {z} in s_inf
    ELEM ==> {z} * s_inf /= 0 & {z} * s_inf = {z}
    Use_Def(g) ==> g1({z}) = f(arb({g1(x): x in {z} * s_inf}))
    EQUAL ==> g1({z}) = f(arb({g1(x): x in {z}}))
    SIMPLF ==> Stat10: {g1(x): x in {z}} = {g1(z)}
    (Stat10)ELEM ==> arb({g1(x): x in {z}}) = g1(z)
    EQUAL ==> g1({z}) = f(g1(z))
    g1(z) --> Stat8 ==> g1({z}) in g1(z)
    ELEM ==> g1({z}) in w
    Suppose ==> Stat9: not (g1({z}) in {g1(x): x in s_inf})
    {z} --> Stat9 ==> not (g1({z}) = g1({z}) & {z} in s_inf)
    ELEM ==> false; Discharge ==> {z} in w * {g1(x): x in s_inf}
    ELEM ==> false; Discharge ==> QED

Theorem transfinite_induction.2: P(m) & (FORALL k in m | not P(k)). Proof:
	m --> transfinite_induction.1 ==> not ((P(m)) imp (EXISTS k in m| P(k)))
    ELEM ==> P(m) & (not (EXISTS k in m | P(k)))
    Quantif ==> QED

ENTER_THEORY set_theory

DISPLAY transfinite_induction

THEORY transfinite_induction(n,P)
    P(n)
==>(m)
    P(m) & (FORALL k in m | not P(k))
END transfinite_induction;

Def 4: is_map(f) := f = {[car(x),cdr(x)]: x in f}
Def 5: domain(f) := {car(x): x in f}
Def 6: range(f) := {cdr(x): x in f}
Def 7: Svm(f) := is_map(f) & (FORALL x in f | (FORALL y in f | (car(x) = car(y)) imp (x = y)))
Def 8: one_1_map(f) := Svm(f) & (FORALL x in f | (FORALL y in f | (cdr(x) = cdr(y)) imp (x = y)))

Def 9: [The enumeration of a set] 
    enum(X,S) := if S incin {enum(y,S): y in X} then S else arb(S - {enum(y,S): y in X}) end if
    
Def 10: Ord(s) := (FORALL x in s | x incin s) & (FORALL x in s | (FORALL y in s | (x in y or y in x or x = y)))
Def 11: next(s) := s + {s}

Theorem 8: (Ord(S) & Ord(T) & T incin S) imp (T = S or T = arb(S - T)). Proof:
    Suppose_not ==> Ord(s) & Ord(t) & t incin s & t /= s & t /= arb(s - t)
    {s - t} --> Ax_ch ==> (s - t = 0 & arb(s - t) = 0) or 
            (arb(s - t) in (s - t) & arb(s - t) * (s - t) = 0)
    ELEM ==> arb(s - t) in s & arb(s - t) * (s - t) = 0
    Use_Def(Ord) ==> 
      (FORALL x in s| x incin s) & (FORALL x in s| (FORALL y in s | (x in y or y in x or x = y)))
    ELEM ==> Stat2: (FORALL x in s | x incin s)
    ELEM ==> Stat3: (FORALL x in s | (FORALL y in s | x in y or y in x or x = y))
    arb(s - t) --> Stat2 ==> (arb(s - t) in s) imp (arb(s - t) incin s)
    ELEM ==> arb(s - t) incin t
    ELEM ==> arb(s - t) in s & arb(s - t) notin t
    Loc_def ==> a := arb(s - t) 
    Use_Def(a) ==> a = arb(s - t) 
    ELEM ==> a incin t
    ELEM ==> a in s & a notin t
    Suppose ==> Stat4: not(a incs t)
    Use_Def(incs) ==> Stat5: not(FORALL x in t | x in a)
    (b) --> Stat5 ==> b in t & (not (b in a))
    ELEM ==> a in s & b in s & (not (b in a))
    (a,b) --> Stat3 ==> (a in s & b in s) imp (a in b or b in a or a = b)
    ELEM ==> a in t or a in b
    Use_Def(Ord) ==> 
      Stat1: (FORALL x in t| x incin t) & (FORALL x in t| (FORALL y in t | (x in y or y in x or x = y)))
	(b) --> Stat1 ==> (b in t) imp (b incin t)
	ELEM ==> a in t
    ELEM ==> false; Discharge ==> a incs t
    ELEM ==> arb(s - t) = t
    ELEM ==> false; Discharge ==> QED

Theorem 9: (Ord(S) & Ord(T)) imp Ord(S * T). Proof:  
    Suppose_not ==> Ord(s) & Ord(t) & (not Ord(s * t))
    ELEM ==> not Ord(s * t)
    Use_Def(Ord) ==> Stat1: not(((FORALL x in s * t | x incin s * t)) & 
              (FORALL x in s * t | (FORALL y in s * t | (x in y or y in x or x = y))))
    (a,b,c) --> Stat1 ==> (a in s * t & (not(a incin s * t))) or
                  (b in s * t & c in s * t & (not(b in c or c in b or c = b)))
	ELEM ==> Ord(s)
    Use_Def(Ord) ==> Stat2: (FORALL x in s | x incin s) & 
              (FORALL x in s | (FORALL y in s | (x in y or y in x or x = y)))
    Suppose ==> ((a in s * t) & (not(a incin s * t)))
    ELEM ==> Stat2: a in s & a in t
    a --> Stat2 ==> Stat3: (a in s) imp (a incin s)
    LIKEWISE(Stat2-Stat3,s->t) ==> (a in t) imp (a incin t)
    ELEM ==> false; Discharge ==> not((a in s * t) & (not(a incin s * t)))
    ELEM ==> b in s & c in s & (not(b in c or c in b or c = b))
    ELEM ==> Stat4: (FORALL x in s | (FORALL y in s | (x in y or y in x or x = y)))
    (b,c) --> Stat4 ==> (b in s & c in s) imp (b in c or c in b or c = b)
    ELEM ==> false; Discharge ==> QED

Theorem 10: (Ord(S) & Ord(T)) imp (S incin T or T incin S). Proof:  
    Suppose_not(s,t) ==> (not((Ord(s) & Ord(t)) imp (s incin t or t incin s)))
    ELEM ==> Ord(s) & Ord(t) & (not(s incin t) & (not(t incin s))) 
    (s,t) --> T9 ==> (Ord(s) & Ord(t)) imp Ord(s * t)
    ELEM ==> Ord(s * t)
    ELEM ==> Ord(s * t) & s * t incin s & s * t incin t 
    (s,s*t) --> T8 ==> (Ord(s) & s * t incin s & Ord(s * t)) imp (s * t = s or s * t = arb(s - (s * t)))
    (t,s*t) --> T8 ==> (Ord(t) & s * t incin t & Ord(s * t)) imp (s * t = t or s * t = arb(t - (s * t)))
    ELEM ==> s * t = arb(s - (s * t)) & s * t = arb(t - (s * t))
    ELEM ==> s - (s * t) /= 0
    ELEM ==> t - (s * t) /= 0
    {s - (s * t)} --> Ax_ch ==> (s - (s * t) = 0 & arb(s - (s * t)) = 0) or 
        (arb(s - (s * t)) in s - (s * t) & arb(s - (s * t)) * (s - (s * t)) = 0)
    ELEM ==> s * t in s
    {t - (s * t)} --> Ax_ch ==> (t - (s * t) = 0 & arb(t - (s * t)) = 0) or 
        (arb(t - (s * t)) in t - (s * t) & arb(t - (s * t)) * (t - (s * t)) = 0)
    ELEM ==> false; Discharge ==> QED
    
Theorem 11: (Ord(S) & Ord(T) ) imp (S in T or T in S or S = T). Proof: 
    Suppose_not(s,t) ==> Ord(s) & Ord(t) & (not(s in t or t in s or s = t)) 
    (s,t) --> T10 ==> (Ord(s) & Ord(t)) imp ((s incin t) or (t incin s))
    ELEM ==> Stat1: (s incin t) or (t incin s)
    (s,t) --> T8 ==> (Ord(s) & Ord(t) & (t incin s)) imp (t = s or t = arb(s - t))
    (t,s) --> T8 ==> (Ord(t) & Ord(s) & (s incin t)) imp (s = t or s = arb(t - s))
    (Stat1)ELEM ==> (t = s or t = arb(s - t) or s = arb(t - s))
    ELEM ==> false; Discharge ==> QED
    
Theorem 12: (Ord(S) & T in S) imp Ord(T). Proof: 
    Suppose_not(s,t) ==> not(((Ord(s)) & t in s) imp Ord(t))
    ELEM ==> Ord(s) & t in s & (not Ord(t))
    ELEM ==> not Ord(t)
    Use_Def(Ord) ==> 
      Stat1: (not(FORALL x in t | x incin t) & (FORALL x in t | (FORALL y in t | (x in y or y in x or x = y))))
    (a,b,c)} --> Stat1 ==> 
      (a in t & (not(a incin t))) or (b in t & c in t & (not(b in c or c in b or b = c))) 
    ELEM ==> Ord(s)
    Use_Def(ord) ==> 
      Stat2: (FORALL x in s | x incin s) & (FORALL x in s | (FORALL y in s | (x in y or y in x or x = y)))
    ELEM ==> Stat3: (FORALL x in s | x incin s)
    ELEM ==> Stat6: (FORALL x in s | (FORALL y in s | (x in y or y in x or x = y)))
    (b,c) --> Stat6 ==> (b in s & c in s) imp (b in c or c in b or b = c)
    t --> Stat3 ==> (t in s) imp (t incin s)
     ELEM ==> Stat7: a in t & (not(a incin t))
     ELEM ==> Stat4: not(a incin t)
     (d)-->Stat4 ==> d in a & (not(d in t))
     a --> Stat3 ==> (a in s) imp (a incin s)
     ELEM ==> d in s
     ELEM ==> Stat4: (FORALL x in s | (FORALL y in s | (x in y or y in x or x = y)))
     (d,t) --> Stat4 ==> d in t or t in d or t = d
     (Stat7)ELEM ==> false; Discharge ==> QED
    
Theorem 13: [The class of all sets is not a set] not(EXISTS x | (FORALL y | y in x)). Proof:
    Suppose_not(u) ==> Stat0: (FORALL y | y in u)
    Loc_def ==> a := {y: y in u | y notin y}
    ELEM ==> Stat1: a notin {y: y in u | y notin y}
    a --> Stat1 ==> not (a in u & a notin a); 
    ELEM ==> a notin u
    a --> Stat0 ==> false; Discharge ==> QED

Theorem 14: [The class of ordinals is not a set] 
    not (EXISTS ordinals | (FORALL x | ((x in ordinals) eq Ord(x)))). Proof:
    Suppose_not(oo) ==> Stat3: (FORALL x | (Ord(x) imp (x in oo)))
    Loc_def ==> o := {x in oo | Ord(x)}
    Suppose ==> Stat0: not (FORALL x | (Ord(x) eq (x in o)))
    x --> Stat0 ==> not (Ord(x) eq (x in o))
    Suppose ==> Ord(x) & (x notin o)
    ELEM ==> x notin {x in oo | Ord(x)}
    Defmemb ==> x notin oo
    x --> Stat3 ==> false; Discharge ==> not Ord(x) & x in {x in oo | Ord(x)}
    Defmemb ==> false; Discharge ==> (FORALL x | Ord(x) eq (x in o))
    Suppose ==> not Ord(o)
    Use_Def ==> Stat2: not((FORALL x in o | (x incin o) & (FORALL x in o | (FORALL y in o | (x in y or y in x or x = y)))))
    (a,b,c) --> Stat2 ==> ((a in o) & (not(a incin o))) or 
          ((b in o) & (c in o) & (not(b in c or c in b or b = c)))
    Suppose ==> (b in o) & (c in o) & (not(b in c or c in b or b = c))
    ELEM ==> b in o
    b --> Stat3 ==> (b in o) eq Ord(b)
    ELEM ==> Ord(b)
    ELEM ==> c in o
    c --> Stat3 ==> (c in o) eq Ord(c)
    ELEM ==> Ord(c)
    (b,c) --> T11 ==> (Ord(b) & Ord(c)) imp (b in c or c in b or b = c)
    ELEM ==> a in o & (not(a incin o))
    a --> Stat3 ==> (a in o) eq Ord(a)
    ELEM ==> Ord(a)
    ELEM ==> Stat3: not(a incin o)
    (d) --> Stat4 ==> (d in a) & (d notin o)
    (a,d) --> T12 ==> (Ord(a) & d in a) imp Ord(d)
    d --> Stat3 ==> (d in o) eq Ord(d)
    ELEM ==> false; Discharge ==> QED
    

Theorem 15: Ord(S) imp Ord(next(S)). Proof:
    Suppose_not(s) ==> Ord(s) & (not(Ord(next(s))))
    Use_Def(next) ==> Ord(s) & (not(Ord(s + {s})))
    Use_Def(Ord) ==> 
      Stat1: (not((FORALL x in s + {s} | x incin s + {s})) & 
          (FORALL x in s + {s} | (FORALL y in s + {s} | (x in y or y in x or x = y))))
    (a,b,c) --> Stat1 ==> (a in s + {s} & (not(a incin (s + {s})))) or 
          (b in s + {s} & c in s + {s} & (not(b in c or c in b or b = c)))
    ELEM ==> ((a in s or a = s) & ((not(a incin (s + {s}))))) or 
          ((b in s or b = s) & (c in s or c = s) & (not(b in c or c in b or b = c)))
    ELEM ==> (a in s & (not(a incin s))) or ((b in s) & (c in s) & (not(b in c or c in b or b = c)))
    Use_Def(ord) ==> 
      Stat2: (FORALL x in s | x incin s) & (FORALL x in s | (FORALL y in s | (x in y or y in x or x = y)))
    (a,b,c) --> Stat2 ==> ((a in s) imp (a incin s)) & (((b in s) & (c in s)) imp (b in c or c in b or b = c))
    ELEM ==> false; Discharge ==> QED

Theorem 16: (Ord(S) & Ord(T)) imp ((T incin S) eq (T in S or T = S)). Proof:
    Suppose_not(s,t) ==> Ord(s) & Ord(t) & 
      ((not(t incin s) & (t in s or t = s)) or ((t incin s) & (not(t in s or t = s))))
    Suppose ==> (not(t incin s)) & (t in s or t = s)
    ELEM ==> not(t incin s)
    Memb(c) ==> c in t & (not(c in s)) & t in s & Ord(s)
    Use_Def(Ord) ==> Stat1: (FORALL x in s | (FORALL y in x | y in s))
    (t,c) --> Stat1 ==> (t in s & c in t) imp (c in s)
    ELEM ==> false; Discharge ==> t incin s & t notin s & t /= s
    (s,t) --> T8 ==> (Ord(s) & Ord(t) & t incin s) imp (t = s or t = arb(s - t))
    ELEM ==> s - t /= 0
    (s - t) --> Ax_ch ==> s - t = 0 or arb(s - t) in s - t
    ELEM ==> arb(s - t) in s
    ELEM ==> t in s
    ELEM ==> false; Discharge ==> QED

Theorem 17: (Ord(X) & S in {enum(y,S): y in X}) imp (S incin {enum(y,S): y in X}). Proof:
    Suppose_not(x,s) ==> Ord(x) & Stat1: s in {enum(y,s): y in x} & (not(s incin {enum(y,s): y in x}))
    y --> Stat1 ==> s = enum(y,s) & y in x
    Use_Def(enum) ==> enum(y,s) = if s incin {enum(z,s): z in y} then s else arb(s - {enum(z,s): z in y}) end if
    Suppose ==> not(s incin {enum(z,s): z in y})
    ELEM ==> not(s incin {enum(z,s): z in y}) & enum(y,s) = arb(s - {enum(u,s): u in y})
    ELEM ==> s - {enum(u,s): u in y} /= 0
    (s - {enum(u,s): u in y}) --> Ax_ch ==> enum(y,s) in s
    ELEM ==> false; Discharge ==> s incin {enum(z,s): z in y}
    (y,x) --> T16 ==> y incin x
    Set_monot ==> s incin {enum(z,s): z in x}
    ELEM ==> false; Discharge ==> QED
    
Theorem 18: enum(X,S) = S or enum(X,S) in S. Proof:
    Suppose_not(x,s) ==> enum(x,s) /= s & enum(x,s) notin s
    Use_Def(enum) ==> enum(x,s) = if s incin {enum(y,s): y in x} then s else arb(s - {enum(y,s): y in x}) end if
    ELEM ==> s - {enum(y,s): y in x} /= 0
    (s - {enum(y,s): y in x}) --> Ax_ch ==> arb(s - {enum(y,s): y in x}) in s - {enum(y,s): y in x}
    ELEM ==> false; Discharge ==> QED 

Theorem 19: (enum(X,S) = S & Y incs X) imp (enum(Y,S) = S). Proof:
    Suppose_not(x,s,y) ==> enum(x,s) = s & y incs x & enum(y,s) /= s
    Use_Def(enum) ==> enum(x,s) = if s incin {enum(u,s): u in x} then s else arb(s - {enum(u): u in x}) end if
    Suppose ==> not (s incin {enum(u,s): u in x})
    ELEM ==> s - {enum(y,s): y in x} /= 0
    (s - {enum(u,s): u in x}) --> Ax_ch ==> arb(s - {enum(u): u in x}) in s - {enum(u,s): u in x}
    ELEM ==> false; Discharge ==> s incin {enum(u,s): u in x}
    Set_monot ==> s incin {enum(u,s): u in y}
    Use_Def(enum) ==> enum(y,s) = if s incin {enum(u,s): u in y} then s else arb(s - {enum(u): u in y}) end if
    ELEM ==> false; Discharge ==> QED
    
Theorem 20: [The enumeration of a set is 1-1]
    (Ord(X) & Ord(W) & X /= W) imp 
      (S in {enum(y,S): y in X} or S in {enum(y,S): y in W} or enum(X,S) /= enum(W,S)). Proof:
    Suppose_not(x,z) ==> 
      Ord(x) & Ord(z) & x /= z & 
          s notin {enum(y,s): y in x} & s notin {enum(y,s): y in z} & enum(x,s) = enum(z,s)
    (x,z) --> T11 ==> x in z or z in x
    Suppose ==> z in x
    ELEM ==> Ord(x) & Stat1: s notin {enum(y,s): y in x} & z in x & enum(x,s) = enum(z,s)
    Use_Def(enum) ==> enum(x,s) = if s incin {enum(y,s): y in x} then s else arb(s - {enum(y,s): y in x}) end if
    Suppose ==> enum(x,s) = s
    z --> Stat1 ==> enum(z,s) /= s
    ELEM ==> false; Discharge ==> not(s incin {enum(y,s): y in x}) & enum(x,s) = arb(s - {enum(y,s): y in x})
    ELEM ==> s - {enum(y,s): y in x} /= 0
    (s - {enum(y,s): y in x}) --> Ax_ch ==> arb(s - {enum(y,s): y in x})
    Suppose ==> Stat2: enum(z,s) notin {enum(y,s): y in x}
    z --> Stat1 ==> false; Discharge ==> enum(z,s) in {enum(y,s): y in x}
    ELEM ==> false; Discharge ==> QED

Theorem 21: [Enumeration Lemma] (FORALL s | (EXISTS x | (Ord(x) & s in {enum(y,s): y in x}))). Proof:
    Suppose_not(s) ==> Stat1: (FORALL x | (not Ord(x)) or s notin {enum(y,s): y in x})
    Suppose ==> Stat2: 
      not((FORALL x | (FORALL y | ((Ord(x) & Ord(y)) imp (enum(x,s) in s & enum(y,s) in s & ((x /= y) imp (enum(x,s) /= enum(y,s))))))))
    (x,y) --> Stat2 ==> 
      Ord(x) & Ord(y) & (not(enum(x,s) in s & enum(y,s) in s & x /= y & enum(x,s) = enum(y,s)))
    x --> Stat1 ==> s notin {enum(u,s): u in x}
    y --> Stat1 ==> s notin {enum(u,s): u in y}
    (x,y,s) --> T20 ==> false 
    Discharge ==> Stat0: 
      (FORALL x | (FORALL y | ((Ord(x) & Ord(y)) imp ((enum(x,s) in s & enum(y,s) in s & (x /= y) imp (enum(x,s) /= enum(y,s)))))))
    Loc_def ==> t := {x in s | (EXISTS o | Ord(o) & enum(o,s) = x)}
    Suppose ==> Stat3: not (FORALL x | ((x in t) imp (EXISTS o | (Ord(o) & enum(o,s) = x))))
    a --> Stat3 ==> a in t & (not(EXISTS o | (Ord(o) & enum(o,s) = a)))
    ELEM ==> a in {x in s | (EXISTS o | Ord(o) & enum(o,s) = x)}
    Defmemb ==> false; Discharge ==> (FORALL x | ((x in t) imp (EXISTS o | Ord(o) & enum(o,s) = x)))
    Quantif ==> Stat4: (FORALL x | EXISTS o | ((x in t) imp (Ord(o) & enum(o,s) = x)))
    (X,the_ord) --> Stat4 ==> Stat6: (X in t) imp (Ord(the_ord(X)) & enum(the_ord(X),s) = X)
    Suppose ==> Stat7: not(FORALL o |(Ord(o) imp (o in {the_ord(x): x in t})))
    o --> Stat7 ==> Ord(o) & Stat8: o notin {the_ord(x): x in t}
    enum(o,s) --> Stat8 ==> o /= the_ord(enum(o,s))
    Suppose ==> enum(o,s) notin t
    ELEM ==> enum(o,s) notin {x in s | (EXISTS o | (Ord(o) & enum(o,s) = x))}
    Defmemb ==> Stat9: (EXISTS oo | (Ord(oo) & enum(oo,s) = enum(o,s)))
    o --> Stat9 ==> false; Discharge ==> enum(o,s) in t
    enum(o,s) --> Stat6 ==> Ord(the_ord(enum(o,s))) & enum(the_ord(enum(o,s)),s) = enum(o,s)
    (the_ord(enum(o,s)),o) --> Stat0 ==> the_ord(enum(o,s)) = o
    ELEM ==> false; Discharge ==> (FORALL o | (Ord(o) imp (o in {the_ord(x): x in t})))
    T14 ==> Stat10: not(EXISTS ordinals | (FORALL x | ((Ord(x) in ordinals) imp (x in ordinals))))
    {the_ord(x): x in t} --> Stat10 ==> false; Discharge ==> QED

Theorem 22: [Enumeration theorem] 
    (FORALL s | (EXISTS x | (Ord(x) & s = {enum(y,s): y in x}) & 
                (FORALL y in x | (FORALL z in x | ((y /= z) imp (enum(y,s) /= enum(z,s))))))). Proof:
    Suppose_not(s) ==> Stat1: (not(EXISTS x | (Ord(x) & s = {enum(y,s): y in x}) & 
                (FORALL y in x | (FORALL z in x | ((y /= z) imp ((enum(y,s) /= enum(z,s))))))))
    (s,x) --> T21 ==> Ord(x) & Stat1: s in {enum(y,s): y in x}
    y --> Stat1 ==> s = enum(y,s) & y in x
    (x,y) --> T12 ==> Ord(y)
    Use_Def(enum) ==> enum(y,s) = if s incin {enum(u,s): u in y} then s else arb(s - {enum(u,s): u in y}) end if
    Suppose ==> not s incin {enum(u,s): u in y}
    ELEM ==> s - {enum(u,s): u in y} /= 0
    (s - {enum(u,s): u in y}) --> Ax_ch ==> enum(y,s) in s - {enum(u,s): u in y}
    ELEM ==> false; Discharge ==> s incin {enum(u,s): u in y}
    APPLY(b) transfinite_induction(p(x)->Ord(x) & s incin {enum(u,s): u in x}) ==>
      Ord(b) & (s incin {enum(y,s): y in b}) & Stat2: (FORALL u in b | (not Ord(u) or not s incin {enum(v,s): v in u}))
    b --> Stat1 ==> s /= {enum(y,s): y in b} or not(FORALL y in b | (FORALL z in b | ((y /= z) imp (enum(y,s) /= enum(z,s)))))
    Suppose ==> s /= {enum(y,s): y in b}
    ELEM ==> not({enum(y,s): y in b} incin s)
    Memb(c) ==> Stat3: c in {enum(y,s): y in b} & c notin s
    c --> Stat3 ==> c = enum(d,s) & d in b & c notin s
    d --> Stat2 ==> (not Ord(d)) or (not s incin {enum(y,s): y in d})
    (b,d) --> T12 ==> (not s incin {enum(y,s): y in d}) & s - {enum(y,s): y in d} /= 0
    Use_Def(enum) ==> enum(d,s) = arb(s - {enum(u,s): u in d})
    (s - {enum(u,s): u in d}) --> Ax_ch ==> enum(d,s) in s
    ELEM ==> false; Discharge ==> s = {enum(y,s): y in b}
    ELEM ==> Stat4: not(FORALL y in b | (FORALL z in b | ((y /= z) imp (enum(y,s) /= enum(z,s)))))
    (v,w) --> Stat4 ==> v in b & w in b & v /= w & enum(v,s) = enum(w,s)
    (b,v) --> T12 ==> Ord(v)
    (b,w) --> T12 ==> Ord(w)
    (v,w,s) --> T20 ==> (Ord(v) & Ord(w) & v /= w) imp 
      (s in {enum(y,s): y in v} or s in {enum(y,s): y in w} or enum(v,s) /= enum(w,s))
    ELEM ==> s in {enum(y,s): y in v} or s in {enum(y,s): y in w}
    v --> Stat2 ==> not (s incin {enum(x,s): x in v})
    w --> Stat2 ==> not (s incin {enum(x,s): x in w})
    (v,s) --> T17 ==> (Ord(v) & s in {enum(y,s): y in v}) imp (s incin {enum(y,s): y in v})
    (w,s) --> T17 ==> (Ord(w) & s in {enum(y,s): y in w}) imp (s incin {enum(y,s): y in w})
    ELEM ==> false; Discharge ==> QED

Def 12: [Map Restriction] Def(f ON a) := {p in f | car(p) in a}
Def 13: [Value of single-valued function] Def(f~[x]) := cdr(arb(f ON {x}))

Def 14: [Map Product] Def(F @ G) := {[car(x),cdr(y)]: x in G, y in F | cdr(x) = car(y)}
Def 14a: [Inverse Map] inv(F) := {[cdr(x),car(x)]: x in F}
Def 14b: [Identity Map] ident(s) := {[x,x]: x in s}

Skolem_def 14c: Ord(enum_Ord(s)) & s = {enum(y,s): y in enum_Ord(s)} & 
              (FORALL y in enum_Ord(s) | (FORALL z in enum_Ord(s) | ((y /= z) imp (enum(y,s) /= enum(z,s)))))

Def 15: [Cardinality] 
    Def(#s) := arb({x: x in next(enum_Ord(s)) | (EXISTS f in OM | (one_1_map(f) & domain(f) = x & range(f) = s))}) 

Def 16: [Cardinal] 
 Card(s) := Ord(s) & 
      (FORALL y in s | (FORALL f in OM | (not(domain(f) = y) or not(range(f) = s) or not(Svm(f)))))

Theorem 23: F ON A incin F. Proof:
    Set_monot ==> {p in F | car(p) in a} incin {p in F}
    SIMPLF ==> {p in F | car(p) in a} incin F 
    Use_Def(ON) ==> QED

Theorem 24: S * T = {x in S | x in T}. Proof:
    Suppose_not(s,t) ==> s * t /= {x in s | x in t}
    Memb(c) ==> (c in s * t & c notin {x in s | x in t}) or (c notin s * t & c in {x in s | x in t})
    Defmemb ==> (c in s * t & (not(c in s & c in t))) or ((not c in s * t) & (c in s & c in t))
    ELEM ==> false; Discharge ==> QED

Theorem 25: S - T = {x in S | x notin T}. Proof:
    Suppose_not(s,t) ==> s - t /= {x in s | x notin t}
    Memb(c) ==> (c in s - t & c notin {x in s | x notin t}) or (c notin s - t & c in {x in s | x notin t})
    Defmemb ==> (c in s - t & (not((c in s) & (c notin t)))) or ((not c in s - t) & ((c in s) & (c notin t)))
    ELEM ==> false; Discharge ==> QED

Theorem 26: is_map(F) eq (FORALL x in F | x = [car(x),cdr(x)]). Proof:
    Suppose_not(f) ==> not(is_map(f) eq (FORALL x in f | x = [car(x),cdr(x)]))
    Suppose ==> is_map(f) & (not(FORALL x in f | x = [car(x),cdr(x)]))
    Use_Def(is_map) ==> f = {[car(x),cdr(x)]: x in f} & (not(FORALL x in f | x = [car(x),cdr(x)]))
    ELEM ==> not(FORALL x in f | x = [car(x),cdr(x)])
    EQUAL ==> not(FORALL x in {[car(x),cdr(x)]: x in f} | x = [car(x),cdr(x)])
    SIMPLF ==> Stat1: not(FORALL x in f | [car(x),cdr(x)] = [car([car(x),cdr(x)]),cdr([car(x),cdr(x)])])
    x --> Stat1 ==> [car(x),cdr(x)] /= [car([car(x),cdr(x)]),cdr([car(x),cdr(x)])]
    Suppose ==> Stat2: not (car(x) = car([car(x),cdr(x)]) & cdr(x) = cdr([car(x),cdr(x)]))
    (Stat2)ELEM ==> false; Discharge ==> car(x) = car([car(x),cdr(x)]) & cdr(x) = cdr([car(x),cdr(x)])
    EQUAL ==> [car(x),cdr(x)] = [car([car(x),cdr(x)]),cdr([car(x),cdr(x)])]
    EQUAL ==> false; Discharge ==> is_map(f) imp (not(FORALL x in f | x = [car(x),cdr(x)]))
    Suppose ==> not is_map(f) & Stat0: (FORALL x in f | x = [car(x),cdr(x)])
    Use_Def(is_map) ==> f /= {[car(x),cdr(x)]: x in f} & (FORALL x in f | (x = [car(x),cdr(x)]))
    Memb(c) ==> 
      Stat2: (c in f & (not(c in {[car(x),cdr(x)]: x in f}))) or (c notin f & c in {[car(x),cdr(x)]: x in f})
    (c,d) --> Stat2 ==> (c in f & c /= [car(c),cdr(c)]) or (c notin f & c = [car(d),cdr(d)] & d in f)
    c --> Stat0 ==> (c in f) imp (c = [car(c),cdr(c)]) 
    Loc_def ==> cc := [car(c),cdr(c)]
    Use_Def(cc) ==> cc = [car(c),cdr(c)]
    EQUAL ==> Stat3: (c in f & c /= cc) or (c notin f & c = [car(d),cdr(d)] & d in f)
    EQUAL ==>(c in f) imp (c = cc)
    (Stat3)ELEM ==> Stat4: c notin f & c = [car(d),cdr(d)] & d in f
    d --> Stat0 ==> (d in f) imp (d = [car(d),cdr(d)])
    (Stat4)ELEM ==> false; Discharge ==> QED
    
Theorem 27: (G incin F & is_map(F)) imp is_map(G). Proof:
    Suppose_not(g,f) ==> g incin f & is_map(f) & (not is_map(g))
    Use_Def(is_map) ==> g incin f & (FORALL x in f | x = [car(x),cdr(x)]) & (not(FORALL x in g | x = [car(x),cdr(x)]))
    Pred_monot ==> (g incin f & (FORALL x in f | x = [car(x),cdr(x)])) imp (FORALL x in g | x = [car(x),cdr(x)])
    ELEM ==> false; Discharge ==> QED
    
Theorem 28: (G incin F & Svm(F)) imp Svm(G). Proof:
    Suppose_not(g,f) ==> g incin f & Svm(f) & (not Svm(g))
    Use_Def(Svm) ==> is_map(f) & (FORALL x in f | (FORALL y in f | ((car(x) = car(y)) imp (x = y)))) & 
            (not(is_map(g) & (FORALL x in g | (FORALL y in g | ((car(x) = car(y)) imp (x = y))))))
    (f,g) --> T27 ==> (FORALL x in f | (FORALL y in f | ((car(x) = car(y)) imp (x = y)))) & 
            (not((FORALL x in g | (FORALL y in g | ((car(x) = car(y)) imp (x = y))))))
    Pred_monot ==> ((FORALL x in f | (FORALL y in f | ((car(x) = car(y)) imp (x = y))))) imp
                (FORALL x in g | (FORALL y in g | ((car(x) = car(y)) imp (x = y))))
    ELEM ==> false; Discharge ==> QED
    
    
Theorem 29: (G incin F & one_1_map(F)) imp one_1_map(G). Proof:
    Suppose_not(g,f) ==> g incin f & one_1_map(f) & (not one_1_map(g))
    Use_Def(one_1_map) ==> Svm(f) & (FORALL x in f | (FORALL y in f | ((cdr(x) = cdr(y)) imp (x = y)))) & 
            (not(Svm(g) & (FORALL x in g | (FORALL y in g | ((cdr(x) = cdr(y)) imp (x = y))))))
    (f,g) --> T28 ==> (FORALL x in f | (FORALL y in f | ((cdr(x) = cdr(y)) imp (x = y)))) & 
            (not(FORALL x in g | (FORALL y in g | ((cdr(x) = cdr(y)) imp (x = y)))))
    Pred_monot ==> (FORALL x in f | (FORALL y in f | ((cdr(x) = cdr(y)) imp (x = y)))) imp
                (FORALL x in g | (FORALL y in g | ((cdr(x) = cdr(y)) imp (x = y))))
    ELEM ==> false; Discharge ==> QED

Theorem 30: (X in F) imp (car(X) in domain(F)). Proof:
    Suppose_not(c,f) ==> c in f & (not car(c) in domain(f))
    Use_Def(domain) ==> Stat1: not car(c) in {car(x): x in f}
    c --> Stat1 ==> not(car(c) = car(c) & c in f)
    ELEM ==> false; Discharge ==> QED

Theorem 31: (X in F) imp (cdr(X) in range(F)). Proof:
    Suppose_not(c,f) ==> c in f & (not cdr(c) in range(f))
    Use_Def(range) ==> Stat1: not cdr(c) in {cdr(x): x in f}
    c --> Stat1 ==> not(cdr(c) = cdr(c) & c in f)
    ELEM ==> false; Discharge ==> QED

Theorem 32: A * B = {x in A | x in B}. Proof: 
		Suppose_not(a,b) ==> a * b /= {x in a | x in b}
    Memb(c) ==> ((c in a * b & (not(c in {x in a | x in b})))) or 
            (not(c in a * b & c in {x in a | x in b}))
    Defmemb ==> (c in a * b and not(c in a & c in b)) or (not(c in a * b) & (c in a & c in b))
    ELEM ==> false; Discharge ==> QED
    
Theorem 33: (is_map(F) & is_map(G)) imp is_map(F + G). Proof: 
		Suppose_not(f,f) ==> is_map(f) & is_map(g) & (not is_map(f + g))
    Use_Def(is_map) ==> f = {[car(x),cdr(x)]: x in f} & g = {[car(x),cdr(x)]: x in g} & 
                f + g = {[car(x),cdr(x)]: x in f + g}
    Set_monot ==> f + g = {[car(x),cdr(x)]: x in f} + {[car(x),cdr(x)]: x in g}
    ELEM ==> false; Discharge ==> QED
    
Theorem 34: F ON (A + B) = (F ON A) + (F ON B). Proof:
    Suppose_not(f,a,b) ==> f ON (a + b) /= (f ON a) + (f ON b)
    Use_Def(ON) ==> 
      {p in f | car(p) in a + b} /= {p in f | car(p) in a} + {p in f | car(p) in b}
    Set_monot ==>
      {p in f | car(p) in a + b} = {p in f | car(p) in a} + {p in f | car(p) in b}
    ELEM ==> false; Discharge ==> QED

Theorem 35: [Associativity of map multiplication] F @ (G @ H) = (F @ G) @ H. Proof:
    Suppose_not(f,g,h) ==> f @ (g @ h) /= (f @ g) @ h
    Use_Def(@) ==> 
      {[car(u),cdr(v)]: u in f, v in {[car(x),cdr(y)]: x in g, y in h | cdr(x) = car(y)} | cdr(u) = car(v)} /= 
        {{[car(x),cdr(y)]: x in {[car(u),cdr(v)]: u in f, v in g | cdr(u) = car(v)}, y in h | cdr(x) = car(y)}}
    SIMPLF ==> 
      {[car(u),cdr([car(x),cdr(y)])]: u in f, x in g, y in h | cdr(x) = car(y) & cdr(u) = car([car(x),cdr(y)])} /= 
    {{[car([car(u),cdr(v)]),cdr(y)]: u in f, v in g , y in h | cdr(u) = car(v) & cdr([car(u),cdr(v)]) = car(y)}}
    ELEM ==> cdr([car(X),cdr(Y)]) = cdr(Y) 
    ELEM ==> car([car(X),cdr(Y)]) = car(X) 
    EQUAL ==>  {[car(u),cdr(y)]: u in f, x in g, y in h | cdr(x) = car(y) & cdr(u) = car(x)} /= 
              {{[car(u),cdr(y)]: u in f, v in g , y in h | cdr(u) = car(v) & cdr(v) = car(y)}}
    ELEM ==> (cdr(X) = car(Y) & cdr(U) = car(X)) eq (cdr(U) = car(X) & cdr(X) = car(Y))
    EQUAL ==>  {[car(u),cdr(y)]: u in f, x in g, y in h | cdr(u) = car(x) & cdr(x) = car(y)} /= 
              {[car(u),cdr(y)]: u in f, v in g , y in h | cdr(u) = car(v) & cdr(v) = car(y)}
    ELEM ==> false; Discharge ==> QED

Theorem 36: (F + G) ON A = (F ON A) + (G ON A). Proof:
    Suppose_not(f,g,a) ==> ((f + g) ON a) /= (f ON a) + (g ON a)
    Use_Def(ON) ==> 
      {p in (f + g) | car(p) in a} /= {p in f | car(p) in a} + {p in g | car(p) in a}
    Set_monot ==>
      {p in (f + g) | car(p) in a} = {p in f | car(p) in a} + {p in g | car(p) in a}
    ELEM ==> false; Discharge ==> QED

Theorem 37: F ON domain(F) = F. Proof:
    Suppose_not(f) ==> not((f ON domain(f)) = f)
    (f,domain(f)) --> T23 ==> (f ON domain(f)) incin f
    ELEM ==> not((f ON domain(f)) incs f)
    Use_Def(ON) ==> Stat1: not({p in f | car(p) in domain(f)} incs f)
    (a) --> Stat1 ==> a in f & (not(a in {p in f | car(p) in domain(f)}))
    Defmemb ==> car(p) notin domain(f)
    (a,f) --> T30 ==> false; Discharge ==> QED

Theorem 38: (X in domain(F)) imp (F~[X] in range(F)). Proof:
    Suppose_not(x,f) ==> x in domain(f) & (not(f~[x] in range(f)))
    Use_Def(range) ==> not(f~[x] in {cdr(y): y in f})
    Use_Def([]) ==> not(cdr(arb(f ON {x}) in {cdr(y): y in f}))
    Use_Def(ON) ==> not(cdr(arb({p in f | car(p) in {x}}) in {cdr(y): y in f}))
    Use_Def(domain) ==> Stat1: x in {car(y): y in f}
    c --> Stat1 ==> x = car(c) & c in f
    ELEM ==> car(c) in {x}
    Suppose ==> not c in {p in f | car(p) in {x}}
    Defmemb ==> Stat2: (FORALL p in f | ((car(p) in {x}) imp (p /= c)))
    c --> Stat2 ==> (car(c) in {x}) imp (c /= c)
    ELEM ==> false; Discharge ==> c in {p in f | car(p) in {x}}
    ELEM ==> {p in f | car(p) in {x}} /= 0
    ({p in f | car(p) in {x}}) --> Ax_ch ==> arb({p in f | car(p) in {x}}) in {p in f | car(p) in {x}}
    Set_monot ==> arb({p in f | car(p) in {x}}) in {p in f}
    SIMPLF ==> arb({p in f | car(p) in {x}}) in f
    Defmemb ==> Stat2: (FORALL y in f | cdr(arb({p in f | car(p) in {x}})) /= cdr(y))
    ({p in f | car(p) in {x}}) --> Stat2 ==> 
        cdr(arb({p in f | car(p) in {x}})) /= cdr(arb({p in f | car(p) in {x}}))
    ELEM ==> false; Discharge ==> QED
    
Theorem 39: Svm(F) eq (F = {[x,F~[x]]: x in domain(F)}). Proof:
    Suppose_not(f) ==> (Svm(f) & f /= {[x,f~[x]]: x in domain(f)}) or 
            ((not Svm(f)) & f = {[x,f~[x]]: x in domain(f)})
    APPLY() fcn_symbol(f(x) -> f~[x], g -> f,s -> domain(f)) ==> Svm(f) & f = {[x,f~[x]]: x in domain(f)}
    ELEM ==> Svm(f) & f /= {[x,f~[x] ]: x in domain(f)}
    Use_Def(domain) ==> f /= {[x,f~[x] ]: x in {car(y): y in f}}
    SIMPLF ==> f /= {[car(y),f~[car(y)]]: y in f}
    Use_Def(Svm) ==> is_map(f) & Stat1: (FORALL x in f | (FORALL y in f | ((car(x) = car(y)) imp (x = y))))
    Use_Def(is_map) ==> {[car(y),cdr(y)]: y in f} /= {[car(y),f~[car (y)]]: y in f}
    SIMPLF ==> {[car(y),cdr(y)]: y in f | true} /= {[car(y),f~[car(y)]]: y in f | true}
    Suppose ==> (FORALL y in f | [car(y),cdr(y)] = [car(y),f~[car(y)]])
    APPLY() setformer(e(x) -> [car(x),cdr(x)],ep1(x) -> [car(x),car(f~[x])],p(x) -> true,pp1(x) -> true,s -> f) ==> 
      {[car(y),cdr(y)]: y in f | true} /= {[car(y),f~[car (y)]]: y in f | true}
    ELEM ==> false; Discharge ==> Stat2: not(FORALL y in f | [car(y),cdr(y)] = [car(y),f~[car(y)]])
    c --> Stat2 ==> c in f & [car(c),cdr(c)] /= [car(c),f~[car(c)]]
    Use_Def([]) ==> f~[car(c)] = cdr(arb(f ON {car(c)}))
    Use_Def(ON) ==> f~[car(c)] = cdr(arb({p in f | car(p) in {car(c)}}))
    Suppose ==> {p in f | car(p) in {car(c)}} /= {c}
    Memb(d) ==> (d in {p in f | car(p) in {car(c)}} & d notin {c}) or 
              (d notin {p in f | car(p) in {car(c)}} & d in {c})
    SIMPLF ==> (d in f & car(d) in {car(c)} & d notin {c}) or (not(d in f & car(d) in {car(c)}) & d in {c})
    ELEM ==> d in f & car(d) = car(c) & d /= c
    (c,d) --> Stat1 ==> (c in f & d in f & car(d) = car(c)) imp (d = c)
    ELEM ==> false; Discharge ==> {p in f | car(p) in {car(c)}} = {c}
    ELEM ==> f~[car (c)] = cdr(arb({c}))
    ELEM ==> f~[car (c)] = cdr(c)
    ELEM ==> false; Discharge ==> QED

Theorem 39a: Svm(F) imp (F = {[x,F~[x]]: x in domain(F)} & range(F) = {F~[x]: x in domain(F)}). Proof:
    Suppose_not(f) ==> Svm(f) & (not(f = {[x,f~[x]]: x in domain(f)}) & range(f) = {f~[x]: x in domain(f)})
    f --> T39 ==> f = {[x,f~[x]]: x in domain(f)}
    Use_Def(range) ==> range(f) = {cdr(x): x in f}
    ELEM ==> range(f) = {cdr(x): x in {[x,f~[x]]: x in domain(f)}}
    SIMPLF ==> range(f) = {cdr([x,f~[x]]): x in domain(f)}
    ELEM ==> cdr([X,f~[X]]) = f~[X]
    EQUAL ==> range(f) = {f~[x]: x in domain(f)}
    ELEM ==> false; Discharge ==> QED

THEORY fcn_symbol(f,g,s)  [Contains some elementary lemmas about single-valued functions]
     g = {[x,f(x)]: x in s}
==>
END fcn_symbol;

ENTER_THEORY fcn_symbol   [Note: till we return from 'fcn_symbol' to set theory, we are
                reasoning within the theory, so g = {[x,f(x)]: x in s} is available
                as an axiom, and all theorems proved are added to the set 
                of conclusions of the theory, rather than to the set of conclusions
                of the top-level set-theory.]

Theorem fcn_symbol.1: domain(g) = s. Proof:
    Suppose_not ==> domain(g) /= s
    Memb(a) ==> ((a in domain(g) & a notin s) or not(a in domain(g))) & a in s
    Use_Def(domain) ==> (a in {car(x): x in g} & a notin s) or (a notin {car(x): x in g} & a in s)
    Suppose ==> Stat1: (a in {car(x): x in g} & a notin s)
    b --> Stat1 ==> b in g & a = car(b) & a notin s
    Assump ==> g = {[x,f(x)]: x in s}
    EQUAL ==> b in {[x,f(x)]: x in s} & a = car(b) & a notin s
    c --> Stat2 ==> c in s & b = [c,f(c)] & a = car(b) & a notin s
    (c,f(c)) --> T5 ==> car([c,f(c)]) = c
    ELEM ==> false; Discharge ==> Stat3: a notin {car(x): x in g} & a in s
    [a,f(a)] --> Stat3 ==> (not([a,f(a)] in g) or a /= car([a,f(a)])) & a in s
    ELEM ==> Stat4: [a,f(a)] notin {[x,f(x)]: x in s} & a in s
    a --> Stat4 ==> false; Discharge ==> QED
    
Theorem fcn_symbol.2: (FORALL x in s | g~[x] = f(x)). Proof:
    Suppose_not(c) ==> c in s & g~[c] /= f(c)
    Use_Def([]) ==> c in s & cdr(arb(g ON {c})) /= f(c)
    Use_Def(ON) ==> Stat3: c in s & cdr(arb({p in g | car(p) in {c}})) /= f(c)
    Suppose ==> not([c,f(c)] in {p in g | car(p) in {c}})
    Defmemb ==> [c,f(c)] notin g or car([c,f(c)]) notin {c}
    (c,f(c)) --> T5 ==> car([c,f(c)]) = c
    ELEM ==> Stat6: [c,f(c)] notin g
    Assump ==> g = {[x,f(x)]: x in s}
    (Stat6)ELEM ==> Stat1: [c,f(c)] notin {[x,f(x)]: x in s}
    c --> Stat1 ==> (c in s) imp ([c,f(c)] /= [c,f(c)])
    (Stat3)ELEM ==> false; Discharge ==> Stat4: ([c,f(c)] in {p in g | car(p) in {c}})
    (Stat4)ELEM ==> Stat5:  {p in g | car(p) in {c}} /= 0;
    {p in g | car(p) in {c}} --> Ax_ch ==> 
      {p in g | car(p) in {c}} = 0 or arb({p in g | car(p) in {c}}) in {p in g | car(p) in {c}}
    (Stat5)ELEM ==> Stat3: arb({p in g | car(p) in {c}}) in {p in g | car(p) in {c}}
    Loc_def ==> a := arb({p in g | car(p) in {c}})
    Use_Def(a) ==> a = arb({p in g | car(p) in {c}})
    (Stat3)ELEM ==> a in {p in g | car(p) in {c}}
    Defmemb ==> Stat4: a in g & car(a) in {c}
    EQUAL ==> cdr(a) /= f(c)
    Assump ==> g = {[x,f(x)]: x in s}
    (Stat4)ELEM ==> Stat2: a in {[x,f(x)] : x in s} & car(a) = c & cdr(a) /= f(c)
    b --> Stat2 ==> b in s & a = [b,f(b)] & car(a) = c & cdr(a) /= f(c)
    (Stat2)ELEM ==> b = c & f(b) /= f(c); 
    EQUAL ==> false; Discharge ==> QED  
    
Theorem fcn_symbol.3: (X notin s) imp (g~[X] = 0). Proof:
    Suppose_not(c) ==> (c notin s & g~[c] /= 0)
    Use_Def([]) ==> c notin s & arb(g ON {c}) /= 0 
    Use_Def(ON) ==> g ON {c} = {p in g | car(p) in {c}}
    ELEM ==> arb({p in g | car(p) in {c}}) /= 0 
    {p in g | car(p) in {c}} --> Ax_ch ==> arb({p in g | car(p) in {c}}) in {p in g | car(p) in {c}}
    ELEM ==> {p in g | car(p) in {c}} /= 0
    Memb(b) ==> b in {p in g | car(p) in {c}}
    Defmemb ==> b in g & car(b) in {c}
    Assump ==> g = {[x,f(x)]: x in s}
    ELEM ==> Stat1: b in {[x,f(x)]: x in s} & car(b) = c
    a --> Stat1 ==> a in s & b = [a,f(a)] & car(b) = c
    (a,f(a)) --> T5 ==> car([a,f(a)]) = a
    ELEM ==> false; Discharge ==> QED  

Theorem fcn_symbol.4: Svm(g). Proof:
    Suppose_not ==> (not is_map(g)) or not(FORALL x in g | (FORALL y in g | ((car(x) = car(y)) imp (x = y))))
    Loc_def ==> aa(x) := x
    EQUAL ==> g = {[aa(x),f(x)]: x in s}
    APPLY() iz_map(f -> g,a -> aa,b -> f,s -> s) ==> is_map(g)   
-- Comment: [Assumption of iz_map is: f = {[a(x),b(x)]: x in s}] ==> true   
    ELEM ==> Stat1: not (FORALL x in g| (FORALL y in g| ((car(x) = car(y)) imp (x = y))))
    (a,b) --> Stat1 ==> a in g & b in g & (not((car(a) = car(b)) imp (a = b)))
    ELEM ==> Stat2: a in g & b in g & car(a) = car(b) & a /= b
    Assump ==> g = {[x,f(x)]: x in s}
    ELEM ==> Stat3: a in {[x,f(x)]: x in s} & Stat5: b in {[x,f(x)]: x in s} & a /= b & car(a) = car(b)
    c --> Stat3 ==> c in s & a = [c,f(c)]
    d --> Stat5 ==> d in s & b = [d,f(d)]
    (Stat3)ELEM ==> Stat5: a = [c,f(c)] & b = [d,f(d)] & a /= b & car(a) = car(b)
    (Stat5)ELEM ==> c = d
    (Stat5)ELEM ==> f(c) /= f(d)
   EQUAL ==> false; Discharge ==> QED  

Theorem fcn_symbol.5: range(g) = {f(x) : x in s}. Proof:
	Suppose_not ==> range(g) /= {f(x) : x in s}
    Use_Def(range) ==> range(g) = {cdr(x): x in g}
    Assump ==> g = {[x,f(x)]: x in s}
    EQUAL ==> {cdr(x): x in g} = {cdr(x): x in {[x,f(x)]: x in s}}
    SIMPLF ==> {cdr(x): x in {[x,f(x)]: x in s}} = {cdr([x,f(x)]): x in s}
    ELEM ==> Stat1: {cdr([x,f(x)]): x in s} /= {f(x) : x in s}
    a --> Stat1 ==> Stat2: (a in {cdr([x,f(x)]): x in s} & a notin {f(x) : x in s}) or 
    					(a notin {cdr([x,f(x)]): x in s} & a in {f(x) : x in s})
    (b,b,c,c) --> Stat2 ==> Stat3: ((b in s & a = cdr([b,f(b)])) & (not (b in s & a = f(b)))) or 
    					((not (c in s & a = cdr([c,f(c)]))) & (c in s & a = f(c)))
    (Stat3)ELEM ==> false; Discharge ==> QED 
    
Theorem fcn_symbol.6: (FORALL x in s | (FORALL y in s | ((f(x) = f(y)) imp (x = y)))) imp one_1_map(g). Proof:
    Suppose_not ==> Stat1: (FORALL x in s | (FORALL y in s | ((f(x) = f(y)) imp (x = y)))) & (not one_1_map(g))
    Use_Def(one_1_map) ==> not(FORALL u in g | (FORALL v in g | ((cdr(u) = cdr(v)) imp (u = v))))
    Assump ==> g = {[x,f(x)]: x in s}
    EQUAL ==> not (FORALL u in {[x,f(x)]: x in s} | (FORALL v in {[y,f(y)]: y in s} | ((cdr(u) = cdr(v)) imp (u = v))))
    SIMPLF ==> Stat2: not (FORALL x in s | (FORALL y in s | ((cdr([x,f(x)]) = cdr([y,f(y)])) imp ([x,f(x)] = [y,f(y)]))))
    (x,y) --> Stat2 ==> x in s & y in s & cdr([x,f(x)]) = cdr([y,f(y)]) & (not [x,f(x)] = [y,f(y)])
    ELEM ==> f(x) = f(y) & (not [x,f(x)] = [y,f(y)])
    (x,y) --> Stat1 ==> false; Discharge ==> QED
    
ENTER_THEORY set_theory   
        [Note: this exits the subtheory 'fcn_symbol', and re-enters the main set_theory]

[Note: if we use 'DISPLAY fcn_symbol' at this point, the result would be as follows:]

THEORY fcn_symbol(f,g)
     g = {[x,f(x)]: x in s}
==>
    domain(g) = s.
    (FORALL x in s | g~[x] = f(x)).
    (X notin s) imp (g~[X] = 0).
    range(g) = {f(x) : x in s}
    (FORALL x in s | (FORALL y in s | ((f(x) = f(y)) imp (x = y)))) imp one_1_map(g)
END fcn_symbol;

Theorem 40:(U = [A,B]) imp (U = [car(U),cdr(U)]). Proof:
    Suppose_not(u,a,b) ==> u = [a,b] & u /= [car(u),cdr(u)]
    (a,b) --> T5 ==> car([a,b]) = a
    (a,b) --> T6 ==> car([a,b]) = b
    ELEM ==> false; Discharge ==> QED  

Theorem 41: (is_map(F) & U in F) imp (U = [car(U),cdr(U)]) . Proof:
    Suppose_not(g,u) ==> is_map(g) & u in g & u /= [car(u),cdr(u)]
    Use_Def(is_map) ==> u in {[car(x),cdr(x)]: x in g}
    a --> Stat1 ==> u in g & u = [car(a),cdr(a)]
    (car(a),cdr(a)) --> T7 ==> (u = [car(a),cdr(a)]) imp (u = [car(u),cdr(u)])
    ELEM ==> false; Discharge ==> QED  

THEORY iz_map(f,a,b,s)
     f = {[a(x),b(x)]: x in s}
==>
END iz_map;

ENTER_THEORY iz_map

Theorem iz_map.1: is_map(f). Proof:
    Suppose_not ==> not(f = {[car(x),cdr(x)]: x in f})
    Memb(c) ==> (c notin f & c in {[car(x),cdr(x)]: x in f})
            or (c in f and not(c in {[car(x),cdr(x)]: x in f}))
    Suppose ==> c in f and Stat1: not(c in {[car(x),cdr(x)]: x in f})
    c --> Stat1 ==> c in f & (c notin f or c /= [car(c),cdr(c)])
    ELEM ==> c /= [car(c),cdr(c)]
    Assump ==> f = {[a(x),b(x)]: x in s}
    ELEM ==> Stat2: c in {[a(x),b(x)]: x in s}
    d --> Stat2 ==> d in s & c = [a(d),b(d)]
    (a(d),b(d)) --> T7 ==> c = [car(c),cdr(c)]
    ELEM ==> false; Discharge ==> c notin f & c in {[car(x),cdr(x)]: x in f}
    Assump ==> f = {[a(x),b(x)]: x in s}
    EQUAL ==> c notin f & c in {[car(x),cdr(x)]: x in {[a(x),b(x)]: x in s}}
    SIMPLF ==> Stat3: c notin f & c in {[car([a(x),b(x)]),cdr([a(x),b(x)])]: x in s}
    e --> Stat3 ==> c notin f & e in s & c = [car([a(e),b(e)]),cdr([a(e),b(e)])]
    (a(e),b(e)) --> T5 ==> car([a(e),b(e)]) = a(e)
    (a(e),b(e)) --> T6 ==> cdr([a(e),b(e)]) = b(e)
    ELEM ==> Stat4: c notin {[a(x),b(x)]: x in s} & e in s & c = [a(e),b(e)]
    e --> Stat4 ==> (e in s) imp ((not(c = [a(e),b(e)])) & e in s & c = [a(e),b(e)])
    ELEM ==> false; Discharge ==> QED

DISPLAY iz_map 

THEORY iz_map(f,a,b,s)
     f = {[a(x),b(x)]: x in s}
==>
    is_map(f)
END iz_map;

ENTER_THEORY fcn_symbol       [Back into this theory to add another little lemma]
    Theorem: Svm(g). Proof:
    Suppose_not ==> is_map(g) & (not(FORALL x in g | (FORALL y in g | ((car(x) = car(y)) imp (x = y)))))
    Loc_def ==> aa(x) := x
    Assump ==> g = {[x,f(x)]: x in s}
    EQUAL ==> g = {[aa(x),f(x)]: x in s}
    APPLY() iz_map(f->g,a->aa,b->f,s->s) ==> is_map(g)   
          Comment: [Assumption of iz_map is: f = {[a(x),b(x)]: x in s}] ==> true
    ELEM ==> Stat1: not(FORALL x in g | (FORALL y in g | ((car(x) = car(y)) imp (x = y))))
    (a,b) --> Stat1 ==> Stat5: a in g & b in g & (not((car(a) = car(b)) imp (a = b)))
    ELEM ==> Stat2: a in {[x,f(x)]: x in s}
    ELEM ==> Stat3: b in {[x,f(x)]: x in s} & (car(a) = car(b)) & (a /= b)
    c --> Stat2 ==> c in s & a = [c,f(c)]
    d --> Stat3 ==> d in s & b = [d,f(d)]
    (Stat3)ELEM ==> c = d & f(c) /= f(d)
    EQUAL ==> false; Discharge ==> QED
    
ENTER_THEORY set_theory
    
DISPLAY fcn_symbol 

THEORY fcn_symbol(f,s)
==>(g)
    g = {[x,f(x)]: x in s}
    domain(g) = s.
    Svm(g).
    (FORALL x in s | g~[x] = f(x)).
    (X notin s) imp (g~[X] = 0)
    (FORALL x in s | (FORALL y in s | ((f(x) = f(y)) imp (x = y)))) imp one_1_map(g)
    #{[x,f(x)]: x in s} = #s
END fcn_symbol;

ENTER_THEORY set_theory

Theorem 42: domain(F + G) = domain(F) + domain(G). Proof:
    Suppose_not(f,g) ==> domain(f + g) /= domain(f) + domain(g)
    Use_Def(domain) ==> {car(x): x in f + g} /= {car(x): x in f} + {car(x): x in g}
    Set_monot ==> false; Discharge ==> QED

Theorem 43: range(F + G) = range(F) + range(G). Proof:
    Suppose_not(f,g) ==> range(f + g) /= range(f) + range(g)
    Use_Def(range) ==> {cdr(x): x in f + g} /= {cdr(x): x in f} + {cdr(x): x in g}
    Set_monot ==> false; Discharge ==> QED

Theorem 44: (domain(F) = 0) eq (range(F) = 0). Proof:
    Suppose_not(f) ==> not((domain(f) = 0) eq (range(f) = 0))
    Use_Def(domain) ==> not({car(x): x in f} = 0 eq range(f) = 0)
    Use_Def(range) ==> not({car(x): x in f} = 0 eq {cdr(x): x in f} = 0)
    Suppose ==> {car(x): x in f} = 0 & {cdr(x): x in f} /= 0
    Memb(c) ==> Stat1: c in {cdr(x): x in f}
    d --> Stat1 ==> c = cdr(d) & d in f & Stat2: car(d) notin {car(x): x in f}
    d --> Stat2 ==> false; Discharge ==> {car(x): x in f} /= 0 & {cdr(x): x in f} = 0
    Memb(a) ==> Stat3: a in {car(x): x in f}
    b --> Stat3 ==> c = car(b) & b in f & Stat2: cdr(b) notin {cdr(x): x in f}
    b --> Stat2 ==> false; Discharge ==> QED
    
Theorem 45: (Svm(F) & X in F) imp (F~[car(X)] = cdr(X)). Proof:
    Suppose_not(f,a) ==> Svm(f) & a in f & f~[car(a)] /= cdr(a)
    f --> T39 ==> a in {[x,f~[x]]: x in domain(f)}
    Use_Def(domain) ==> a in {[x,f~[x]]: x in {car(x): x in f}}
    SIMPLF ==> Stat1: a in {[car(x),f~[car(x)]]: x in f}
    b --> Stat1 ==> a = [car(b),f~[car(b)]] & b in f
    ELEM ==> car(a) = car(b)
    Use_Def(Svm) ==> Stat2: (FORALL x in f | (FORALL y in f | ((car(a) = car(b)) imp (x = y))))
    (a,b) --> Stat2 ==> false; Discharge ==> QED

Theorem 46: [Union of single_valued maps] 
    (Svm(F) & Svm(G) & domain(F) * domain(G) = 0) imp Svm(F + G). Proof:
    Suppose_not(f,g) ==> 
      Svm(f) & Svm(g) & domain(f) * domain(g) = 0 & (not(Svm(f + g)))
    Use_Def(Svm) ==> 
      is_map(f) & Stat1: (FORALL x in f | (FORALL y in f | ((car(x) = car(y)) imp (x = y)))) &
      is_map(g) & Stat2: (FORALL x in f | (FORALL y in f | ((car(x) = car(y)) imp (x = y)))) &
      domain(f) * domain(g) = 0 &
    (not(is_map(f + g)) or not(FORALL x in f + g | ((FORALL y in f + g | ((car(x) = car(y)) imp (x = y))))))
    (f,g) --> T33 ==> (is_map(f) & is_map(g)) imp is_map(f + g)
    ELEM ==> Stat3: not(FORALL x in f + g | (FORALL y in f + g | ((car(x) = car(y)) imp (x = y))))
    a,b --> Stat3 ==> a in f + g & b in f + g & (not(car(a) = car(b)) imp (a = b))
    a,b --> Stat1 ==> (a in f & b in f) imp ((car(a) = car(b)) imp (a = b))
    a,b --> Stat2 ==> (a in g & b in g) imp ((car(a) = car(b)) imp (a = b))
    ELEM ==> car(a) = car(b) & a /= b & ((a in f & b notin f) or (a notin f & b in f))
    Use_Def(domain) ==> domain(f) = {car(x): x in f}
    Suppose ==> Stat4: car(a) notin domain(f)
    ELEM ==> Stat5: car(a) notin {car(x): x in f} & car(b) notin {car(x): x in f}
    (a,b) --> Stat5 ==> (car(a) /= car(a) or a notin f) & (car(b) /= car(b) or b notin f)
    ELEM ==> false; Discharge ==> Stat6: car(a) in domain(f)
    LIKEWISE(Stat4-Stat6,f->g) ==> car(b) in domain(g)
    ELEM ==> false; Discharge ==> QED

Theorem 47: is_map(F) imp is_map(F ON S). Proof:
    (F,S) --> T23 ==> F ON S incin F
    (F ON S,S) --> T27 ==> QED
    
Theorem 48: Svm(F) imp Svm(F ON S) Proof:
    (F,S) --> T23 ==> F ON S incin F
    (F ON S,S) --> T28 ==> QED

Theorem 49: one_1_map(F) imp one_1_map(F ON S) Proof:
    (F,S) --> T23 ==> F ON S incin F
    (F ON S,S) --> T29 ==> QED

Theorem 50: range(F ON S) incin range(F). Proof:
    Suppose_not(f,s) ==> not(range(f ON s) incin range(f))
    Use_Def(range) ==> not({cdr(x): x in (f ON s)} incin {cdr(x): x in f})
    Use_Def(ON) ==> not({cdr(x): x in {x in f | car(x) in s}} incin {cdr(x): x in f})
    SIMPLF ==> not({cdr(x): x in f | car(x) in s} incin {cdr(x): x in f})
    Memb(c) ==> Stat1: c in {cdr(x): x in f | car(x) in s} & Stat2: c notin {cdr(x): x in f}
    d --> Stat1 ==> c = cdr(d) & d in f & car(d) in s
    d --> Stat2 ==> false; Discharge ==> QED

Theorem 50a: domain(F ON S) = domain(F) * S. Proof:
    Suppose_not(f,s) ==> not(domain(f ON s) = domain(f) * s)
    Use_Def(domain) ==> {car(x): x in (f ON s)} /= {car(x): x in f} * s
    Use_Def(ON) ==> {car(x): x in {x in f | car(x) in s}} /= {car(x): x in f} * s
    SIMPLF ==> {car(x): x in f | car(x) in s} /= {car(x): x in f} * s
    Memb(c) ==> (c in {cdr(x): x in f | car(x) in s} & c notin {car(x): x in f} * s) or 
              (c notin {car(x): x in f | car(x) in s} & c in {car(x): x in f} * s)
    Suppose ==> Stat1: c in {car(x): x in f | car(x) in s} & Stat2: (c notin {car(x): x in f} or c notin s)
    d --> Stat1 ==> c = car(d) & d in f & car(d) in s
    d --> Stat2 ==> false 
    Discharge ==> Stat3: c notin {car(x): x in f | car(x) in s} & Stat4: c in {car(x): x in f} & c in s
    e --> Stat4 ==> c = car(e) & e in f
    e --> Stat3 ==> false; Discharge ==> QED

Theorem 51: (range(G) incin domain(F)) imp (range(F @ G) = range(F ON range(G)) & domain(F @ G) = domain(G)). Proof:
    Suppose_not(g,f) ==> 
      range(g) incin domain(f) & (range(f @ g) /= range(f ON range(g)) or domain(f @ g) /= domain(g))
    Use_Def(range) ==> range(f @ g) = {cdr(x): x in f @ g}
    Use_Def(range) ==> range(f ON range(g)) = {cdr(x): x in f ON range(g)}
    Use_Def(ON) ==> {cdr(x): x in f ON range(g)} = {cdr(x): x in {x in f | car(x) in range(g)}}
    SIMPLF ==> {cdr(x): x in f ON range(g)} = {cdr(x): x in f | car(x) in range(g)}
    Use_Def(@) ==> range(f @ g) = {cdr(x): x in {[car(x),cdr(y)]: x in g, y in f | cdr(x) = car(y)}}
    SIMPLF ==> range(f @ g) = {cdr([car(x),cdr(y)]): x in g, y in f | cdr(x) = car(y)}
    (car(X),cdr(Y)) --> T6 ==> cdr([car(X),cdr(Y)]) = cdr(Y)
    EQUAL ==> range(f @ g) = {cdr(y): x in g, y in f | cdr(x) = car(y)}
    Suppose ==> range(f @ g) /= range(f ON range(g))
    ELEM ==> {cdr(y): x in g, y in f | cdr(x) = car(y)} /= {cdr(x): x in f | car(x) in range(g)}
    Memb(c) ==> (c in {cdr(y): x in g, y in f | cdr(x) = car(y)} & c notin {cdr(x): x in f | car(x) in range(g)}) or 
            (c notin {cdr(y): x in g, y in f | cdr(x) = car(y)} & c in {cdr(x): x in f | car(x) in range(g)})
    Suppose ==> Stat1: 
        c in {cdr(y): x in g, y in f | cdr(x) = car(y)} & Stat2: c notin {cdr(x): x in f | car(x) in range(g)}
    (a,b) --> Stat1 ==> c = cdr(b) & a in g & b in f & cdr(a) = car(b)
    b --> Stat2 ==> not(c = cdr(b) & b in f & car(b) in range(g))
    ELEM ==> not (car(b) in range(g))
    Use_Def(range) ==> Stat2a: not car(b) in {cdr(x): x in g}
    b --> Stat2a ==> false; 
    Discharge ==> Stat3: c notin {cdr(y): x in g, y in f | cdr(x) = car(y)} & 
                        Stat4: c in {cdr(x): x in f | car(x) in range(g)} 
    u --> Stat4 ==> c = cdr(u) & u in f & car(u) in range(g)
    Use_Def(range) ==> Stat5: car(u) in {cdr(x): x in g}
    v --> Stat5 ==> car(u) = cdr(v) & v in g
    (u,v) --> Stat3 ==> not(c = cdr(u) & u in f & v in g & cdr(v) = car(u))
    ELEM ==> false; Discharge ==> domain(f @ g) /= domain(g)
    Use_Def(domain) ==> {car(x): x in f @ g} /= {car(x): x in g}
    Use_Def(@) ==> {car(x): x in {[car(x),cdr(y)]: x in g, y in f | cdr(x) = car(y)}} /= {car(x): x in g}
    SIMPLF ==> {car([car(x),cdr(y)]): x in g, y in f | cdr(x) = car(y)} /= {car(x): x in g}
    (car(X),cdr(Y)) --> T6 ==> car([car(X),cdr(Y)]) = car(X)
    EQUAL ==> {car(x): x in g, y in f | cdr(x) = car(y)} /= {car(x): x in g}
    Memb(ca) ==> (ca in {car(x): x in g, y in f | cdr(x) = car(y)} & ca notin {car(x): x in g}) or 
            (ca notin {car(x): x in g, y in f | cdr(x) = car(y)} & ca in {car(x): x in g})
    Suppose ==> Stat11: ca in {car(y): x in g, y in f | cdr(x) = car(y)} & Stat21: ca notin {car(x): x in g}
    (aa,ba) --> Stat11 ==> ca = car(aa) & aa in g & ba in g & cdr(aa) = car(ba)
    aa --> Stat21 ==> false 
    Discharge ==> Stat31: ca notin {car(x): x in g, y in f | cdr(x) = car(y)} & Stat41: ca in {car(x): x in g}
    x --> Stat41 ==> ca = car(x) & x in g
    Suppose ==> Stat51: cdr(x) notin {cdr(x): x in g}
    x --> Stat51 ==> false; Discharge ==> cdr(x) in {cdr(x): x in g}
    Use_Def(range) ==> cdr(x) in range(g)
    ELEM ==> cdr(x) in domain(f)
    Use_Def(range) ==> Stat61: cdr(x) in {car(y): y in f}
    x --> Stat61 ==> cdr(x) = car(y) & y in f
    (x,y) --> Stat31 ==> false; Discharge ==> QED

Theorem 51a: (range(G) = domain(F)) imp (range(F @ G) = range(F) & domain(F @ G) = domain(G)). Proof:
    Suppose_not(g,f) ==> range(g) = domain(f) & (not(range(f @ g) = range(f) & domain(f @ g) = domain(g)))
    (g,f) --> T51 ==> range(f @ g) = range(f ON domain(f)) & domain(f @ g) = domain(g)
    f --> T37 ==> QED

Theorem 52: [Union of 1-1 maps]
    (one_1_map(F) & one_1_map(G) & range(F) * range(G) = 0 & domain(F) * domain(G) = 0) imp one_1_map(F + G). Proof:
    Suppose_not(f,g) ==> 
      (one_1_map(f) & one_1_map(g) & range(f) * range(g) = 0 & domain(f) * domain(g) = 0) & 
            (not(one_1_map(f + g)))
    Use_Def(one_1_map) ==> Svm(f) & Stat1:(FORALL x in f | (FORALL y in f | ((cdr(x) = cdr(y)) imp (x = y)))) &
      Svm(g) & Stat2:(FORALL x in g | (FORALL y in g | ((cdr(x) = cdr(y)) imp (x = y)))) &
      domain(f) * domain(g) = 0 & range(f) * range(g) = 0 &
    (not(Svm(f + g)) or not(FORALL x in f + g | (FORALL y in f + g | ((cdr(x) = cdr(y)) imp (x = y)))))
    (f,g) --> T46 ==> (Svm(f) & Svm(g) & domain(f) * domain(g) = 0) imp Svm(f + g)
    ELEM ==> Stat3: not(FORALL x in f + g | (FORALL y in f + g |((cdr(x) = cdr(y)) imp (x = y))))
    a,b --> Stat3 ==> Stat0: a in f + g & b in f + g & (not((cdr(a) = cdr(b)) imp (a = b)))
    a,b --> Stat1 ==> (a in f & b in f) imp ((cdr(a) = cdr(b)) imp (a = b))
    a,b --> Stat2 ==> (a in g & b in g) imp ((cdr(a) = cdr(b)) imp (a = b))
    (Stat0)ELEM ==> ((a in f & b notin f) or (a in g & b notin g)) & cdr(a) = cdr(b)
     Use_Def(range) ==> range(f) = {cdr(x): x in f}
    Suppose ==> Stat4: cdr(a) notin range(f)
    ELEM ==> Stat5: cdr(a) notin {cdr(x): x in f} & cdr(b) notin {cdr(x): x in f}
    (a,b) --> Stat5 ==> (cdr(a) /= cdr(a) or a notin f) & (cdr(b) /= cdr(b) or b notin f)
    ELEM ==> false; Discharge ==> Stat6: cdr(a) in range(f)
    LIKEWISE(Stat4-Stat6,f->g) ==> cdr(b) in range(g)
    ELEM ==> false; Discharge ==> QED

Theorem 53: is_map(inv(F)) & range(inv(F)) = domain(F) & domain(inv(F)) = range(F). Proof:
    Suppose_not(f) ==> not(is_map(inv(f)) & range(inv(f)) = domain(f) & domain(inv(f)) = range(f))
    Suppose ==> not(is_map(inv(f)))
    Use_Def(is_map) ==> inv(f) /= {[car(x),cdr(x)]: x in inv(f)}
    Use_Def(inv) ==> inv(f) = {[cdr(x),car(x)]: x in f}
    EQUAL ==> inv(f) /= {[car(x),cdr(x)]: x in {[cdr(x),car(x)]: x in f}}
    SIMPLF ==> inv(f) /= {[cdr(x),car(x)]: x in f}
    ELEM ==> false; Discharge ==> not(range(inv(f)) = domain(f) & domain(inv(f)) = range(f))
    Suppose ==> range(inv(f)) /= domain(f)
    Use_Def(range) ==> {cdr(x): x in inv(f)} /= domain(f) 
    Use_Def(domain) ==> {cdr(x): x in inv(f)} /= {car(x): x in f} 
    EQUAL ==> {cdr(x): x in {[cdr(x),car(x)]: x in f}} /= {car(x): x in f}
    SIMPLF ==> {cdr([cdr(x),car(x)]): x in f} /= {car(x): x in f}
    EQUAL ==> {car(x): x in f} /= {car(x): x in f}
    ELEM ==> false; Discharge ==> domain(inv(f)) /= range(f)
    Use_Def(range) ==> domain(inv(f)) /= {cdr(x): x in f}
    Use_Def(domain) ==> {car(x): x in inv(f)} /= {cdr(x): x in f} 
    EQUAL ==> {car(x): x in {[cdr(x),car(x)]: x in f}} /= {cdr(x): x in f}
    SIMPLF ==> {car([cdr(x),car(x)]): x in f} /= {cdr(x): x in f}
    Suppose ==> Stat1: not(FORALL x | car([car(x),cdr(x)]) = car(x))
    u --> Stat1 ==> not(car([car(u),cdr(u)]) = car(u))
    ELEM ==> false; Discharge ==> (FORALL x | car([car(x),cdr(x)]) = car(x))
    EQUAL ==> {cdr(x): x in f} /= {cdr(x): x in f}
    ELEM ==> false; Discharge ==> QED  

Theorem 54: is_map(F) imp (F = inv(inv(F))). Proof:
    Suppose_not(f) ==> is_map(f) & f /= inv(inv(f))
    Use_Def(is_map) ==> f = {[car(x),cdr(x)]: x in f} & f /= inv(inv(f))
    Use_Def(inv) ==> f = {[car(x),cdr(x)]: x in f} & 
              f /= {[cdr(x),car(x)]: x in {[cdr(x),car(x)]: x in f}}
    SIMPLF ==> f /= {[car(x),cdr(x)]: x in f}
    ELEM ==> false; Discharge ==> QED  
    
Theorem 55: 
    one_1_map(F) imp (one_1_map(inv(F)) & F = inv(inv(F)) & range(inv(F)) = domain(F) & domain(inv(F)) = range(F)). Proof:
    Suppose_not(f) ==> 
      Stat0: one_1_map(f) & (not (one_1_map(inv(f)) & f = inv(inv(f))) & range(inv(f)) = domain(f) & domain(inv(f)) = range(f))
    f --> T53 ==> not (one_1_map(inv(f)) & f = inv(inv(f)))
    Use_Def(one_1_map) ==> Svm(f)
    f --> T54 ==> one_1_map(f) & (not (one_1_map(inv(f))))
    Use_Def(one_1_map) ==> one_1_map(f) & (not Svm(inv(f)) or 
        not(FORALL x in inv(f) | (FORALL y in inv(f) | ((cdr(x) = cdr(y)) imp (x = y)))))
    Suppose ==> not(FORALL x in inv(f) | (FORALL y in inv(f) | ((cdr(x) = cdr(y)) imp (x = y))))
    Use_Def(inv) ==> 
      not(FORALL x in {[cdr(x),car(x)]: x in f} | 
           (FORALL y in {[cdr(x),car(x)]: x in f} | ((cdr(x) = cdr(y)) imp (x = y))))
    SIMPLF ==> 
      Stat1: not(FORALL x in f | (FORALL y in f | ((cdr([cdr(x),car(x)]) = cdr([cdr(y),car(y)])) imp (x = y))))
    (x,y) --> Stat1 ==> x in f & y in f & cdr([cdr(x),car(x)]) = cdr([cdr(y),car(y)]) & (not x = y)
    (cdr(x),car(x)) --> T6 ==> x in f & y in f & car(x) = car(y) & x /= y
    Use_Def(one_1_map) ==> Svm(f) & Stat2: (FORALL x in f | (FORALL y in f | ((cdr(x) = cdr(y)) imp (x = y))))
    Use_Def(Svm) ==> Stat3: (FORALL x in f | (FORALL y in f | ((cdr(x) = cdr(y)) imp (x = y))))
    (x,y) --> Stat3 ==> x in f & y in f & (car(x) = car(y)) imp (x = y)
    ELEM ==> false; Discharge ==> not Svm(inv(f))
    ELEM ==> one_1_map(f)
    Use_Def(Svm) ==> (not is_map(inv(f))) or 
        (not(FORALL x in inv(f) | (FORALL y in inv(f) | ((car(x) = car(y)) imp (x = y)))))
    f --> T53 ==> is_map(inv(f))
    ELEM ==> Stat4: not(FORALL x in inv(f) | (FORALL y in inv(f) | ((car(x) = car(y)) imp (x = y))))
    Use_Def(one_1_map) ==> Stat7: (FORALL x in f | (FORALL y in f | ((cdr(x) = cdr(y)) imp (x = y))))
    (u,v) --> Stat4 ==> Stat6: u in inv(f) & v in inv(f) & car(u) = car(v) & u /= v
    Use_Def(inv) ==> Stat5: u in {[cdr(x),car(x)]: x in f} & v in {[cdr(x),car(x)]: x in f}
    (c,d) --> Stat5 ==> Stat9: u = [cdr(c),car(c)] & c in f & v = [cdr(d),car(d)] & d in f
    (Stat9)ELEM ==> Stat91: u = [cdr(c),car(c)] & c in f & d in f
    (Stat91)ELEM ==> Stat92: car(u) = cdr(c) & c in f & d in f
    (Stat9)ELEM ==> Stat93: v = [cdr(d),car(d)]
    (Stat93)ELEM ==> Stat94: car(v) = cdr(d)
    (Stat91)EQUAL ==> car(u) = cdr(c) & c in f & d in f
    (Stat94)ELEM ==> Stat10: car(v) = cdr(d) & car(u) = cdr(c) & c in f & d in f
    (u,v) --> Stat4 ==> u in inv(f) & v in inv(f) & car(u) = car(v) & u /= v
   (Stat10)ELEM ==> car(u) = cdr(c) & car(v) = cdr(d) & car(u) = car(v) & u /= v & c in f & d in f
    (c,d) --> Stat7 ==> Stat8: (c in f & d in f & cdr(c) = cdr(d)) imp (c = d)
    EQUAL ==> cdr(c) = cdr(d) & c /= d & c in f & d in f
    (Stat8)ELEM ==> false; Discharge ==> QED
    
Theorem 56: one_1_map(F) imp (FORALL x in domain(F) | (inv(F)~[F~[x]] = x)). Proof:
    Suppose_not(f) ==> one_1_map(f) & (not(FORALL x in domain(f) | (inv(f)~[f~[x]] = x)))
    Use_Def(one_1_map) ==> Svm(f)
    Use_Def(domain) ==> not(FORALL x in {car(y): y in f}| (inv(f)~[f~[x]] = x))
    SIMPLF ==> Stat1: not(FORALL y in f| inv(f)~[f~[car(y)]] /= car(y))
    c --> Stat1 ==> c in f & inv(f)~[f~[car(c)]] /= car(c)
    (f,c) --> T45 ==> (Svm(f) & c in f) imp (f~[car(c)] = cdr(c))
    ELEM ==> f~[car(c)] = cdr(c)
    EQUAL ==> Stat3: inv(f)~[cdr(c)] /= car(c)
    f --> T55 ==> one_1_map(inv(f))
    Use_Def(one_1_map) ==> Svm(inv(f))
    Suppose ==> [cdr(c),car(c)] notin inv(f)
    Use_Def(inv) ==> Stat2: [cdr(c),car(c)] notin {[cdr(x),car(x)]: x in f}
    c --> Stat2 ==> (not c in f) or [cdr(c),car(c)] /= [cdr(c),car(c)]
    ELEM ==> false; Discharge ==> [cdr(c),car(c)] in inv(f)
    (inv(f),[cdr(c),car(c)]) --> T45 ==> inv(f)~[cdr(c)] = car(c)
    (Stat3)ELEM ==> false; Discharge ==> QED
    
Theorem 57: one_1_map(F) imp 
        ((FORALL x in domain(F) | (inv(F)~[F~[x]] = x)) & (FORALL x in range(F) | (F~[inv(F)~[x]] = x))) . Proof:
    Suppose_not(f) ==> one_1_map(f) &
      Stat1: (not(((FORALL x in domain(f) | inv(f)~[f~[x]] = x) & (FORALL x in range(f) | f~[inv(f)~[x]] = x))))
    (c,d) --> Stat1 ==> 
      (c in domain(f) & (not inv(f)~[f~[c]] = c)) or (d in range(f) & (not f~[inv(f)~[d]] = d))
    (f,c) --> T56 ==> one_1_map(f) imp ((c in domain(f)) imp (inv(f)~[f~[c]] = c))
    (inv(f),d) --> T56 ==> one_1_map(inv(f)) imp ((d in domain(inv(f))) imp (inv(inv(f))~[inv(f)~[d]] = d))
    f --> T55 ==> one_1_map(f) imp (one_1_map(inv(f)) & domain(inv(f)) = range(f))
    f --> T54 ==> inv(inv(f)) = f
    EQUAL ==> one_1_map(inv(f)) imp ((d in range(f)) imp (f~[inv(f)~[d]] = d))
    ELEM ==> false; Discharge ==> QED

Theorem 58: [Elementary Properties of identity maps]
      one_1_map(ident(S)) & domain(ident(S)) = S & range(ident(S)) = S & inv(ident(S)) = ident(S) &
       (FORALL x in S | ((ident(S)~[x]) = x)) & 
          (is_Map(F) imp (((domain(F) incin S) imp ((F @ ident(S)) = F)) & ((range(F) incin S) imp ((ident(S) @ F) = F)))). Proof:
    Suppose_not(s,f) ==> 
(not one_1_map(ident(s))) or (domain(ident(s)) /= s) or (range(ident(s)) /= s) or 
      (inv(ident(s)) /= ident(s)) or (not(FORALL x in s | (ident(s)~[x]) = x)) or 
          (is_Map(f) & (domain(f) incin s) & ((f @ ident(s)) /= f)) or 
            (is_Map(f) & (range(f) incin s) & ((ident(s) @ f) /= f))
    Use_Def(ident) ==> ident(s) = {[x,x]: x in s}
    APPLY() fcn_symbol(f(x)->x,g->ident(s),s->s) ==> 
      Svm(ident(s)) & range(ident(s)) = {x: x in s} & domain(ident(s)) = {x: x in s} &
          (FORALL x in domain(ident(s)) | (ident(s)~[x]) = x) &
          ((FORALL x in domain(ident(s)) | (FORALL y in domain(ident(s)) | ((x = y) imp (x = y)))) imp one_1_map(ident(s)))
    SIMPLF ==> Stat0: Svm(ident(s)) & range(ident(s)) = s & domain(ident(s)) = s &
          (FORALL x in domain(ident(s)) | (ident(s)~[x]) = x) &
          ((FORALL x in domain(ident(s)) | (FORALL y in domain(ident(s)) | ((x = y) imp (x = y)))) imp one_1_map(ident(s)))
    EQUAL ==> Svm(ident(s)) & range(ident(s)) = s & domain(ident(s)) = s &
          (FORALL x in s | (ident(s)~[x]) = x) & 
          ((FORALL x in s | (FORALL y in s | ((x = y) imp (x = y)))) imp one_1_map(ident(s)))
    ELEM ==> Stat10: (not one_1_map(ident(s))) or (inv(ident(s)) /= ident(s)) or 
    	(is_Map(f) & (domain(f) incin s) & ((f @ ident(s)) /= f))
           or (is_Map(f) & (range(f) incin s) & ((ident(s) @ f) /= f))
    Suppose ==> Stat11: inv(ident(s)) /= ident(s)
    Use_Def(ident) ==> inv({[x,x]: x in s}) /= {[x,x]: x in s}
    Use_Def(inv) ==> {[cdr(y),car(y)]: y in {[x,x]: x in s}} /= {[x,x]: x in s}
    SIMPLF ==> {[cdr([x,x]),car([x,x])]: x in s} /= {[x,x]: x in s}
    Memb(d) ==> (d in {[cdr([x,x]),car([x,x])]: x in s} & d notin {[x,x]: x in s}) or
    		(d notin {[cdr([x,x]),car([x,x])]: x in s} & d in {[x,x]: x in s})
    Defmemb(a1,a1,b1,b1) ==> (a1 in s & d = [cdr([a1,a1]),car([a1,a1])] & (not(a1 in s & d = [a1,a1]))) or
    				(not (b1 in s & d = [cdr([b1,b1]),car([b1,b1])]) & (b1 in s & d = [b1,b1]))
	()ELEM ==> cdr([a1,a1]) = a1 
	()ELEM ==> cdr([b1,b1]) = b1 
 	()ELEM ==> car([a1,a1]) = a1 
	()ELEM ==> car([b1,b1]) = b1 
	EQUAL ==> Stat11: (a1 in s & d = [a1,a1] & (not(a1 in s & d = [a1,a1]))) or
    				((not (b1 in s & d = [b1,b1])) & b1 in s & d = [b1,b1])
    (Stat11)ELEM ==> false; Discharge ==> inv(ident(s)) = ident(s)
    Suppose ==> Stat1: not (FORALL x in s | (FORALL y in s | ((x = y) imp (x = y))))
    (x,y) --> Stat1 ==> false; Discharge ==> (FORALL x in s | (FORALL y in s | ((x = y) imp (x = y))))
    (Stat0)ELEM ==> one_1_map(ident(s))
    (Stat10)ELEM ==> Stat11: (is_Map(f) & (domain(f) incin s) & ((f @ ident(s)) /= f))
           or (is_Map(f) & (range(f) incin s) & ((ident(s) @ f) /= f))
    (Stat11)ELEM ==> Stat12: is_Map(f)
    Suppose ==> ((domain(f) incin s) & (f @ ident(s) /= f))
    Use_Def(@) ==> {[car(x),cdr(y)]: x in ident(s), y in f | cdr(x) = car(y)} /= f
    Use_Def(ident) ==> {[car(x),cdr(y)]: x in {[z,z]: z in s}, y in f | cdr(x) = car(y)} /= f
    SIMPLF ==> {[z,cdr(y)]: z in s, y in f | z = car(y)} /= f
    Memb(c) ==> (c in {[z,cdr(y)]: z in s, y in f | z = car(y)} & c notin f) or 
      (c notin {[z,cdr(y)]: z in s, y in f | z = car(y)} & c in f)
    Suppose ==> c in {[z,cdr(y)]: z in s, y in f | z = car(y)} & c notin f
    Defmemb(a,b) ==> Stat9: c = [a,cdr(b)] & a in s & b in f & a = car(b) & c notin f
    b --> T26 ==> b = [car(b),cdr(b)]
    (Stat9)ELEM ==> false; Discharge ==> Stat20: c notin {[z,cdr(y)]: z in s, y in f | z = car(y)} & c in f
    (car(c),c) --> Stat20 ==> 
         Stat11: (not(car(c) in s & c in f & c = [car(c),cdr(c)] & car(c) = car(c))) & c in f 
    c --> T26 ==> c = [car(c),cdr(c)]
    (Stat11)ELEM ==> Stat13: c in f & car(c) notin s
    ELEM ==> car(c) notin domain(f)
    Use_Def(domain) ==> Stat14: car(c) notin {car(x): x in f}
    c --> Stat14 ==> not(c in f & car(c)= car(c))
    ELEM ==> false; Discharge ==> QED
    
Theorem 59: Svm(F) imp (F @ inv(F) = ident(range(F))). Proof:
    Suppose_not(f) ==> Svm(f) & f @ inv(f) /= ident(range(f))
    Use_Def(ident) ==> f @ inv(f) /= {[x,x]: x in range(f)}
    Use_Def(range) ==> f @ inv(f) /= {[x,x]: x in {cdr(y): y in f}}
    SIMPLF ==> f @ inv(f) /= {[cdr(x),cdr(x)]: x in f}
    Use_Def(@) ==> 
      {[car(x),cdr(y)]: x in inv(f), y in f | cdr(x) = car(y)} /= {[cdr(x),cdr(x)]: x in f}
    Use_Def(inv) ==> 
        {[car(x),cdr(y)]: x in {[cdr(x),car(x)]: y in f}, y in f | cdr(x) = car(y)} 
            /= {[cdr(x),cdr(x)]: x in f}
    SIMPLF ==> {[cdr(x),cdr(y)]: x in f, y in f | car(x) = car(y)} /= {[cdr(x),cdr(x)]: x in f}
    Memb(c) ==> Stat3: (c in {[cdr(x),cdr(y)]: x in f, y in f | car(x) = car(y)} & c notin {[cdr(x),cdr(x)]: x in f}) or 
		(c notin {[cdr(x),cdr(y)]: x in f, y in f | car(x) = car(y)} & c in {[cdr(x),cdr(x)]: x in f})
	(a,b,a,d,d,d) --> Stat3 ==> Stat4: (a in f & b in f & c = [cdr(a),cdr(b)] & car(a) = car(b) & (not(a in f & c = [cdr(a),cdr(a)]))) or
		(d in f & c = [cdr(d),cdr(d)] & (not (d in f & d in f & c = [cdr(d),cdr(d)] & car(d) = car(d))))
	Loc_def ==> dd := [cdr(d),cdr(d)]
	Use_Def(dd)  ==> dd = [cdr(d),cdr(d)]
	Loc_def ==> ab := [cdr(a),cdr(b)]
	Use_Def(dd)  ==> ab = [cdr(d),cdr(d)]
	Loc_def ==> aa := [cdr(a),cdr(a)]
	Use_Def(dd)  ==> aa = [cdr(a),cdr(a)]
	(Stat4)EQUAL ==> Stat6: (a in f & b in f & c = ab & car(a) = car(b) & (not(a in f & c = aa))) or
		(d in f & c = dd & (not (d in f & d in f & c = dd & car(d) = car(d))))
	(Stat6)ELEM ==> Stat7: a in f & b in f & car(a) = car(b) & c = ab & c /= aa
	(Stat7)EQUAL ==> Stat5: a in f & b in f & car(a) = car(b) & c = [cdr(a),cdr(b)] & c /= [cdr(a),cdr(a)]
    Use_Def(Svm) ==> Stat2: (FORALL x in f | (FORALL y in f | ((car(x) = car(y)) imp (x = y))))
    (a,b) --> Stat2 ==> (a in f & b in f & car(a) = car(b)) imp (a = b)
    (Stat5)ELEM ==> false; Discharge ==> QED
    
Theorem 60: one_1_map(F) imp (F @ inv(F) = ident(range(F)) & inv(F) @ F = ident(domain(F))). Proof:
    Suppose_not(f) ==> one_1_map(f) & (f @ inv(f) /= ident(range(f)) or inv(f) @ f /= ident(domain(f)))
    Use_Def(one_1_map) ==> Svm(f)
    Use_Def(Svm) ==> is_map(f)
    f --> T59 ==> inv(f) @ f /= ident(domain(f))
    f --> T55 ==> one_1_map(inv(f)) 
    f --> T53 ==> range(inv(f)) = domain(f)
    f --> T54 ==> inv(inv(f)) = f
    Use_Def(one_1_map) ==> Svm(inv(f)) 
    inv(f) --> T59 ==> inv(f) @ inv(inv(f)) = ident(range(inv(f)))
    EQUAL ==> inv(f) @ f = ident(domain(f))
    ELEM ==> false; Discharge ==> QED

Theorem 61: [An inverse pair of maps must be 1-1 and must be each others inverses]
    (is_map(F) & is_map(G) & domain(F) = range(G) & range(F) = domain(G) & 
        F @ G = ident(range(F)) & G @ F = ident(domain(F))) imp (one_1_map(F) & G = inv(F)) Proof:
    Suppose_not(f,g) ==> 
      Stat0: (is_map(f) & is_map(g) & domain(f) = range(g) & range(f) = domain(g) & 
        f @ g = ident(range(f)) & g @ f = ident(domain(f))) & (not(one_1_map(f) & g = inv(f)))
    Suppose ==> Stat1: not Svm(f)
    Use_Def(Svm) ==> Stat2: not(FORALL x in f | (FORALL y in f | ((car(x) = car(y)) imp (x = y))))
    (a,b) --> Stat2 ==> a in f & b in f & car(a) = car(b) & a /= b
    a --> T26 ==> a = [car(a),cdr(a)]
    a --> T26 ==> b = [car(b),cdr(b)]
    EQUAL ==> Stat21: [car(a),cdr(a)] in f & [car(b),cdr(a)] in f & car(a) = car(b) & [car(a),cdr(a)] /= [car(b),cdr(b)]
    (Stat21)ELEM ==> cdr(a) /= cdr(b)
    (a,f) --> T30 ==> car(a) in range(g)
    Use_Def(range) ==> car(a) in {cdr(x): x in g}
    Use_Def(is_map) ==> car(a) in {cdr(x): x in {[car(x),cdr(x)]: x in g}}
    SIMPLF ==> Stat3: car(a) in {cdr([car(x),cdr(x)]): x in g}
    c2 --> Stat3 ==> Stat31: car(a) = cdr([car(c2),cdr(c2)]) & c2 in g
    (Stat31)ELEM ==> Stat34: car(a) = cdr(c2) & c2 in g
    (g,c2) --> T26 ==> [car(c2),cdr(c2)] = c2
    (Stat31)ELEM ==> Stat4: car(a) = cdr(c2) & [car(c2),cdr(c2)] in g
    Suppose ==> not [car(c2),cdr(a)] in f @ g 
    Use_Def(@) ==> Stat5: 
        not [car(c2),cdr(a)] in {[car(x),cdr(y)]: x in g, y in f | cdr(x) = car(y)}
     ([car(c2),cdr(c2)],[car(a),cdr(a)]) --> Stat5 ==> 
      not([car(c2),cdr(a)] = [car([car(c2),cdr(c2)]),cdr([car(a),cdr(a)])] 
        & [car(c2),cdr(c2)] in g & [car(a),cdr(a)] in f & 
          cdr([car(c2),cdr(c2)]) = car([car(a),cdr(a)]))
    ()ELEM ==> car([car(c2),cdr(c2)]) = car(c2) 
    ()ELEM ==> cdr([car(a),cdr(a)]) = cdr(a) 
    ()ELEM ==> car([car(a),cdr(a)]) = car(a) 
    EQUAL ==> Stat33: not([car(c2),cdr(a)] = [car(c2),cdr(a)] 
        & c2 in g & a in f & car(a) = car(a))
    EQUAL ==> a in f & b in f & car(a) = car(b) & a /= b
    EQUAL ==> car(a) = cdr(c2) & c2 in g
    (Stat33)ELEM ==> false; Discharge ==> [car(c2),cdr(a)] in f @ g
    ELEM ==> [car(c2),cdr(a)] in ident(range(f))
    Use_Def(ident) ==> Stat6: [car(c2),cdr(a)] in {[x,x]: x in domain(f)}
    d --> Stat6 ==> Stat36: [car(c2),cdr(a)] = [d,d]
    (Stat36)ELEM ==> Stat7: car(c2) = cdr(a)
    LIKEWISE(Stat2-Stat7,a->b) ==> car(c2) = cdr(b)
    ELEM ==> false; Discharge ==> Stat8: Svm(f)
    LIKEWISE(Stat0-Stat8,f->g) ==> Svm(g)
    f --> T59 ==> f @ inv(f) = ident(range(f))
    EQUAL ==> g @ (f @ inv(f)) = g @ ident(range(f))
    g --> T58 ==> g @ (f @ inv(f)) = g
    (g,f,inv(f)) --> T35 ==> (g @ f) @ inv(f) = g
    EQUAL ==> ident(range(f)) @ inv(f) = g
    f --> T58 ==> inv(f) = g
    Suppose ==> not one_1_map(f)
    Use_Def(one_1_map) ==> not(FORALL x in f | (FORALL x in f | ((cdr(x) = cdr(y)) imp (x = y))))
    	f --> T39 ==> f = {[x,f~[x]]: x in domain(f)}
    EQUAL ==> not(FORALL x in {[x,f~[x]]: x in domain(f)} | (FORALL y in {[y,f~[y]]: y in domain(f)} | 
            ((cdr(x) = cdr(y)) imp (x = y))))
    SIMPLF ==> Stat9: 
      not(FORALL x in domain(f) |(FORALL y in domain(f) |((cdr([x,f~[x]]) = cdr([y,f~[y]])) imp (x = y))))
    (x,y) --> Stat9 ==> cdr([x,f~[x]]) = cdr([y,f~[y]]) & x /= y
    ELEM ==> f~[x] = f~[y] & x /= y
 
Theorem 62: is_map(F @ G). Proof: 
    Suppose_not(f,g) ==> not is_map(f @ g)
    Use_Def(@) ==> not is_map({[car(x),cdr(y)]: x in g, y in f | cdr(x) = car(y)})
    Use_Def(is_map) ==> {[car(x),cdr(y)]: x in g, y in f | cdr(x) = car(y)} /= 
              {[car(u),cdr(u)]: u in {[car(x),cdr(y)]: x in g, y in f | cdr(x) = car(y)}}
    SIMPLF ==> {[car(x),cdr(y)]: x in g, y in f | cdr(x) = car(y)} /=
                  {[car(x),cdr(y)]: x in g, y in f | cdr(x) = car(y)}
    ELEM ==> false; Discharge ==> QED

Theorem 63: (Svm(F) & Svm(G)) imp Svm(F @ G). Proof: 
    Suppose_not(f,g) ==> Svm(f) & Svm(g) & (not Svm(f @ g))
    Use_Def(Svm) ==> is_map(f) & Stat1: (FORALL x in f | (FORALL y in f | ((car(x) = car(y)) imp (x = y)))) & 
            is_map(g) & Stat2: (FORALL x in g | (FORALL y in g | ((car(x) = car(y)) imp (x = y)))) &
          (not(is_map(f @ g) & (FORALL x in (f @ g) | (FORALL y in (f @ g) | ((car(x) = car(y)) imp (x = y))))))
    (f,g) --> T62 ==> is_map(f @ g)
    ELEM ==> Stat3: not((FORALL x in (f @ g)| (FORALL y in (f @ g)| ((car(x) = car(y)) imp (x = y)))))
    (a,b) --> Stat3 ==> a in (f @ g) & b in (f @ g) & (not((car(a) = car(b)) imp (a = b)))
    Use_Def(@) ==> Stat4: a in {[car(x),cdr(y)]: x in g, y in f | cdr(x) = car(y)} & 
            b in {[car(x),cdr(y)]: x in g, y in f | cdr(x) = car(y)} & 
              (not(car(a) = car(b)) imp (a = b))
    (c,d,u,v) --> Stat4 ==> Stat6: c in g & d in f & a = [car(c),cdr(d)] & cdr(c) = car(d) & 
                u in g & v in f & b = [car(u),cdr(v)] & cdr(u) = car(v) &
                  (not((car(a) = car(b)) imp (a = b)))
    (Stat6)ELEM ==> Stat7: car(a) = car(b) & c in g & u in g
    EQUAL ==> Stat5: a = [car(c),cdr(c)]
    (Stat5)ELEM ==> car(a) = car(c)
    EQUAL ==> Stat51: b = [car(u),cdr(v)]
    (Stat51)ELEM ==> car(b) = car(u)
    EQUAL ==> car(c) = car(u)
    (c,u) --> Stat2 ==> (c in g & u in g & car(c) = car(u)) imp (c = u)
    (Stat7)ELEM ==> Stat8: c = u
    EQUAL ==> c in g & d in f & a = [car(c),cdr(d)] & cdr(c) = car(d) & 
                u in g & v in f & b = [car(u),cdr(v)] & cdr(u) = car(v) &
                  (not((car(a) = car(b)) imp (a = b)))
    (Stat8)ELEM ==> Stat9: car(d) = car(v) & d in f & v in f
    (d,v) --> Stat1 ==> (d in f & v in f & car(d) = car(v)) imp (d = v)
    (Stat9)ELEM ==> d = v; 
     EQUAL ==> Stat10: c in g & d in f & a = [car(u),cdr(v)] & cdr(c) = car(d) & 
                u in g & v in f & b = [car(u),cdr(v)] & cdr(u) = car(v) &
                  (not((car(a) = car(b)) imp (a = b)))
    (Stat10)ELEM ==> false; Discharge ==> QED

Theorem 64: (Svm(F) & Svm(G) & X in domain(G) & range(G) incin domain(F)) imp ((F @ G)~[X] = F~[G~[X]]). Proof:
    Suppose_not(f,g,x) ==> 
    Svm(f) & Svm(g) & x in domain(g) & range(g) incin domain(f) & (f @ g)~[x] /= f~[g~[x]]
    Use_Def(@) ==> {[car(u),cdr(v)]: u in g, v in f | cdr(u) = car(v)}~[x] /= f~[g~[x]]
    g --> T39 ==> g = {[u,g~[u]]: u in domain(g)}
    EQUAL ==> range(g) = range({[u,g~[u]]: u in domain(g)})
    Use_Def(range) ==> range(g) = {cdr(u): u in {[u,g~[u]]: u in domain(g)}}
    SIMPLF ==> range(g) = {cdr([u,g~[u]]): u in domain(g)}
    Suppose ==> g~[x] notin range(g)
    ELEM ==> Stat0: g~[x] notin {cdr([u,g~[u]]): u in domain(g)}
    x --> Stat0 ==> not(g~[x] = cdr([x,g~[x]]) & x in domain(g))
    ELEM ==> false; Discharge ==> g~[x] in range(g)
    ELEM ==> x in domain(g) & g~[x] in domain(f)
    f --> T39 ==> f = {[u,f~[u]]: u in domain(f)}
    EQUAL ==> {[car(u),cdr(v)]: u in {[u,g~[u]]: u in domain(g)},v in {[v,f~[v]]: v in domain(f)} 
                    | cdr(u) = car(v)}~[x] /= f~[g~[x]]
    SIMPLF ==> {[u,f~[v]]: u in domain(g), v in domain(f) | cdr([u,g~[u]]) = car([v,f~[v]])}~[x] /= f~[g~[x]] 
    (U,g~[U]) --> T6 ==> cdr([U,g~[U]]) = g~[U]
    (V,f~[V]) --> T6 ==> car([V,f~[V]]) = V
    EQUAL ==> {[u,f~[v]]: u in domain(g), v in domain(f)| g~[u] = v}~[x] /= f~[g~[x]] 
    Use_Def([]) ==> 
      cdr(arb({[u,f~[v]]: u in domain(g), v in domain(f)| g~[u] = v} ON {x})) /= f~[g~[x]]
    Use_Def(ON) ==> 
cdr(arb({[car(w),cdr(w)]: w in {[u,f~[v]]: u in domain(g), v in domain(f) | g~[u] = v} & car(w) = x})) 
              /= f~[g~[x]]
    SIMPLF ==> cdr(arb({[u,f~[v]]: u in domain(g), v in domain(f) | g~[u] = v & u = x})) /= f~[g~[x]]
    Suppose ==> {[u,f~[v]]: u in domain(g), v in domain(f) | g~[u] = v & u = x} /= {[x,f~[g~[x]]]}
    Memb(c) ==> 
       (c in {[u,f~[v]]: u in domain(g), v in domain(f) | g~[u] = v & u = x} & c notin {[x,f~[g~[x]]]}) or 
        (c notin {[u,f~[v]]: u in domain(g), v in domain(f) | g~[u] = v & u = x} & c in {[x,f~[g~[x]]]})
    Suppose ==> 
      Stat1: (c notin {[u,f~[v]]: u in domain(g), v in domain(f) | g~[u] = v & u = x} & c in {[x,f~[g~[x]]]})
    (x,g~[x]) --> Stat1 ==> Stat20: (not(c = [x,f~[g~[x]]] & x in domain(g) 
    									& g~[x] in domain(f) & g~[x] = g~[x] & x = x)) 
    										& c in {[x,f~[g~[x]]]}
    EQUAL ==> x in domain(g) & g~[x] in domain(f)
    (Stat20)ELEM ==> false; Discharge ==> 
          Stat2: c in {[u,f~[v]]: u in domain(g), v in domain(f) | g~[u] = v & u = x} & c notin {[x,f~[g~[x]]]}
    (d,e) --> Stat2 ==> c = [d,f~[e]] & d in domain(g) & e in domain(f) & g~[d] = e & d = x & c /= [x,f~[g~[x]]]
    EQUAL ==> c = [d,f~[e]] & d in domain(g) & e in domain(f) & g~[d] = e & d = e & c /= [e,f~[g~[d]]]
    EQUAL ==> Stat10: c = [d,f~[e]] & d in domain(g) & e in domain(f) & g~[d] = e & d = e & c /= [e,f~[e]]
    (Stat10)ELEM ==> false; Discharge ==> {[u,f~[v]]: u in domain(g), v in domain(f) | g~[u] = v & u = x} = {[x,f~[g~[x]]]}
    EQUAL ==> Stat11: cdr(arb({[x,f~[g~[x]]]})) /= f~[g~[x]]
    (Stat11)ELEM ==> cdr(arb({[x,f~[g~[x]]]})) = f~[g~[x]]
    ELEM ==> false; Discharge ==> QED

Theorem 64a: (Svm(F) & Svm(G) & X in domain(G) & range(G) incin domain(F)) imp 
      ((F @ G)~[X] = F~[G~[X]] & F @ G = {[x,F~[G~[x]]]: x in domain(g)} & range(F @ G) = {F~[G~[x]]: x in domain(G)}). Proof: 
		Suppose_not(f,g,x) ==> Svm(f) & Svm(g) & x in domain(g) & range(g) incin domain(f) & 
      (not((f @ g)~[x] = f~[g~[x]])) & f @ g = {[x,f~[g~[x]]]: x in domain(g)} & range(f @ g) = {f~[g~[x]]: x in domain(g)}
    (F,G) --> T63 ==> Svm(f @ g)
    (f @ g) --> T39a ==> f @ g = {[x,(f @ g)~[x]]: x in domain(g)} & range(f @ g) = {(f @ g)~[x]: x in domain(g)}
    (F,G,X) --> T64 ==> Stat0: (f @ g)~[X] = f~[g~[X]]
    EQUAL ==> (f @ g)~[x] /= f~[g~[x]]
    x --> Stat0 ==> false; Discharge ==> QED
    
Theorem 65: (one_1_map(F) & one_1_map(G)) imp one_1_map(F @ G).   Proof:
    Suppose_not(f,g) ==> one_1_map(f) & one_1_map(g) & (not one_1_map(f @ g))
    Use_Def(Svm) ==> Svm(f) & Stat1: (FORALL x in f | (FORALL y in f | ((cdr(x) = cdr(y)) imp (x = y)))) & 
          Svm(g) & Stat2: (FORALL x in g | (FORALL y in g | ((cdr(x) = cdr(y)) imp (x = y)))) &
        (not(Svm(f @ g) & (FORALL x in (f @ g) | (FORALL y in (f @ g) | ((cdr(x) = cdr(y)) imp (x = y))))))
    (f,g) --> T63 ==> (Svm(f) & Svm(g)) imp Svm(f @ g)
    ELEM ==> Stat3: not((FORALL x in (f @ g) | (FORALL y in (f @ g) | ((cdr(x) = cdr(y)) imp (x = y)))))
    (a,b) --> Stat3 ==> a in (f @ g) & b in (f @ g) & (not(cdr(a) = cdr(b) imp (a = b)))
    Use_Def(@) ==> Stat4: a in {[car(x),cdr(y)]: x in g, y in f | cdr(x) = car(y)} & 
            b in {[car(x),cdr(y)]: x in g, y in f | cdr(x) = car(y)} & 
              (not((cdr(a) = cdr(b)) imp (a = b)))
    (c,d,u,v) --> Stat4 ==> Stat5: c in g & d in f & a = [car(c),cdr(d)] & cdr(c) = car(d) & 
                u in g & v in f & b = [car(u),cdr(v)] & cdr(u) = car(v) &
                  (not((cdr(a) = cdr(b)) imp (a = b)))
    (Stat5)ELEM ==> cdr(a) = cdr(b) & a = [car(c),cdr(d)] & b = [car(u),cdr(v)] & d in f & v in f
    Loc_def ==> cd := [car(c),cdr(d)]
    Use_Def(cd) ==> cd = [car(c),cdr(d)]
    Loc_def ==> uv := [car(u),cdr(u)]
    Use_Def(uv) ==> uv := [car(u),cdr(u)]
    EQUAL ==> Stat51: c in g & d in f & a = cd & cdr(c) = car(d) & 
                u in g & v in f & b = uv & cdr(u) = car(v) &
                  (not((cdr(a) = cdr(b)) imp (a = b)))
    (Stat51)ELEM ==> Stat55: cdr(a) = cdr(b) & a = cd & b = uv & d in f & v in f 
    (Stat55)ELEM ==> Stat51: cdr(a) = cdr(b) & cdr(a) = cdr(cd) & cdr(b) = cdr(uv) & d in f & v in f 
    ()ELEM ==> cdr(v) = cdr([car(u),cdr(v)])      
    ()ELEM ==> cdr(d) = cdr([car(c),cdr(d)])
    EQUAL ==> cdr(v) = cdr(uv)
    EQUAL ==> cdr(d) = cdr(cd)
    EQUAL ==> Stat52: cdr(a) = cdr(b) & cdr(a) = cdr(d) & cdr(b) = cdr(v) & d in f & v in f      
    (Stat52)ELEM ==> Stat6: cdr(d) = cdr(v) & d in f & v in f
    (d,v) --> Stat2 ==> (d in f & v in f & cdr(d) = cdr(v)) imp (d = v)
    (Stat6)ELEM ==> d = v
    EQUAL ==> c in g & d in f & a = [car(c),cdr(d)] & cdr(c) = car(v) & 
                u in g & v in f & b = [car(u),cdr(v)] & cdr(u) = car(v) &
                  (not((cdr(a) = cdr(b)) imp (a = b)))
    EQUAL ==> Stat7: c in g & d in f & a = [car(c),cdr(d)] & cdr(c) = cdr(u) & 
                u in g & v in f & b = [car(u),cdr(v)] & cdr(u) = car(v) &
                  (not((cdr(a) = cdr(b)) imp (a = b)))
    (Stat6)ELEM ==> cdr(c) = cdr(u)
    (c,u) --> Stat1 ==> (c in g & u in g & cdr(c) = cdr(u)) imp (c = u)
    (Stat7)ELEM ==> c = u
    EQUAL ==> c in g & d in f & a = [car(c),cdr(d)] & cdr(c) = cdr(u) & 
                u in g & v in f & b = [car(c),cdr(c)] & cdr(u) = car(v) &
                  (not((cdr(a) = cdr(b)) imp (a = b)))
    EQUAL ==> Stat8: c in g & d in f & a = cd & cdr(c) = cdr(u) & 
                u in g & v in f & b = cd & cdr(u) = car(v) &
                  (not((cdr(a) = cdr(b)) imp (a = b)))
    (Stat8)ELEM ==> false; Discharge ==> QED

Theorem 66: (F + FF) @ G = (F @ G) + (FF @ G). Proof:
    Suppose_not(f,ff,g) ==> (f + ff) @ g /= (f @ g) + (ff @ g)
    Use_Def(@) ==> {[car(x),cdr(y)]: x in g, y in (f + ff) | cdr(x) = car(y)} /= 
          {[car(x),cdr(y)]: x in g, y in f | cdr(x) = car(y)} + 
          {[car(x),cdr(y)]: x in g, y in ff | cdr(x) = car(y)}
    Set_monot ==> false; Discharge ==> QED

Theorem 67: G @ (F + FF) = (G @ F) + (G @ FF). Proof:
    Suppose_not(f,ff,g) ==> g @ (f + ff) /= (g @ f) + (g @ ff)
    Use_Def(@) ==> {[car(x),cdr(y)]: x in (f + ff), y in g | cdr(x) = car(y)} /= 
          {[car(x),cdr(y)]: x in f, y in g | cdr(x) = car(y)} + 
          {[car(x),cdr(y)]: x in ff, y in g | cdr(x) = car(y)}
    Set_monot ==> false; Discharge ==> QED

Def 17: [Cartesian Product] Def(s PROD t) := {[x,y]: x in s, y in t}
 
Theorem 68: (F = {[[[x,y],z],[x,[y,z]]]: x in A, y in B, z in C}) imp 
        (one_1_map(F) & domain(F) = ((A PROD B) PROD C) & range(F) = (A PROD (B PROD C))). Proof:
    Suppose_not(f,a,b,c) ==> f = {[[[x,y],z],[x,[y,z]]]: x in a, y in b, z in c} & 
      (not one_1_map(f) or domain(f) /= ((a PROD b) PROD c) or range(f) /= (a PROD (b PROD c)))
    Suppose ==> domain(f) /= ((a PROD b) PROD c)
    Use_Def(domain) ==> {car(x): x in f} /= ((a PROD b) PROD c)
    EQUAL ==> {car(x): x in {[[[x,y],z],[x,[y,z]]]: x in a, y in b, z in c}} /= ((a PROD b) PROD c)
    SIMPLF ==> {car([[[x,y],z],[x,[y,z]]]): x in a, y in b, z in c} /= ((a PROD b) PROD c)
    SIMPLF ==> {[[x,y],z]: x in a, y in b, z in c} /= ((a PROD b) PROD c)
    Use_Def(PROD) ==> {[[x,y],z]: x in a, y in b, z in c} /= 
            {[u,v]: u in {[x,y]: x in a, y in b}, z in c}
    SIMPLF ==> Stat0: {[[x,y],z]: x in a, y in b, z in c} /= {[[x,y],z]: x in a, y in b, z in c}
    (Stat0)ELEM ==> false; Discharge ==> f = {[[[x,y],z],[x,[y,z]]]: x in a, y in b, z in c} & 
        (not one_1_map(f) or range(f) /= (a PROD (b PROD c)))
    Suppose ==> range(f) /= (a PROD (b PROD c))
    Use_Def(range) ==> {cdr(x): x in f} /= (a PROD (b PROD c))
    EQUAL ==> {cdr(x): x in {[[[x,y],z],[x,[y,z]]]: x in a, y in b, z in c}} /= (a PROD (b PROD c))
    SIMPLF ==> {cdr([[[x,y],z],[x,[y,z]]]): x in a, y in b, z in c} /= (a PROD (b PROD c))
    SIMPLF ==> {[x,[y,z]]: x in a, y in b, z in c} /= (a PROD (b PROD c))
    Use_Def(PROD) ==> {[x,[y,z]]: x in a, y in b, z in c} /= 
            {[x,v]: x in a, v in {[y,z]: y in b, z in c}}
    SIMPLF ==> {[x,[y,z]]: x in a, y in b, z in c} /= {[x,[y,z]]: x in a, y in b, z in c}
    ELEM ==> false; Discharge ==> f = {[[[x,y],z],[x,[y,z]]]: x in a, y in b, z in c} & 
                    (not one_1_map(f))
    Use_Def(one_1_map) ==> (not Svm(f)) or 
          not(FORALL xx in f | (FORALL yy in f | ((cdr(x) = cdr(y)) imp (x = y))))
    Suppose ==> not(FORALL xx in f | (FORALL yy in f | ((cdr(x) = cdr(y)) imp (x = y))))
    EQUAL ==> not(FORALL xx in {[[[x,y],z],[x,[y,z]]]: x in a, y in b, z in c} | 
        (FORALL yy in {[[[x,y],z],[x,[y,z]]]: x in a, y in b, z in c} | ((cdr(x) = cdr(y)) imp (x = y))))
    SIMPLF ==> Stat1: (not(FORALL x in a | (FORALL y in b | (FORALL z in c | (FORALL x2 in a | (FORALL y2 in b | (FORALL z2 in c | 
        ((cdr([[[x,y],z],[x,[y,z]]]) = cdr([[[x2,y2],z2],[x2,[y2,z2]]]) imp 
                [[[x,y],z],[x,[y,z]]] = [[[x2,y2],z2],[x2,[y2,z2]]])))))))))
    (x,y,z,x2,y2,z2) --> Stat1 ==> Stat0: cdr([[[x,y],z],[x,[y,z]]]) = cdr([[[x2,y2],z2],[x2,[y2,z2]]]) &
        (not [[[x,y],z],[x,[y,z]]] = [[[x2,y2],z2],[x2,[y2,z2]]])
    ([x,[y,z]]],[x,[y,z]]) --> T6 ==> cdr([[[x,y],z],[x,[y,z]]]) = [x,[y,z]]
    ([x2,[y2,z2]]],[x2,[y2,z2]]) --> T6 ==> cdr([[[x2,y2],z2],[x2,[y2,z2]]]) = [x2,[y2,z2]]
    (Stat0*)ELEM ==> Stat10: [x,[y,z]] = [x2,[y2,z2]]
    (Stat10+)ELEM ==> x = x2 & y = y2 & z = z2
    EQUAL ==> Stat11: cdr([[[x,y],z],[x,[y,z]]]) = cdr([[[x2,y2],z2],[x2,[y2,z2]]]) &
        (not [[[x,y],z],[x,[y,z]]] = [[[x,y],z],[x,[y,z]]])
    (Stat11*)ELEM ==> false; Discharge ==> not Svm(f)
    Use_Def(Svm) ==> (not is_map(f)) or 
          (not(FORALL xx in f | (FORALL yy in f | ((car(x) = car(y)) imp (x = y)))))
    Suppose ==> not(FORALL xx in f | (FORALL yy in f | ((car(x) = car(y)) imp (x = y))))
    EQUAL ==> not(FORALL xx in {[[[x,y],z],[x,[y,z]]]: x in a, y in b, z in c} | 
        (FORALL yy in {[[[x,y],z],[x,[y,z]]]: x in a, y in b, z in c} | ((car(x) = car(y)) imp (x = y))))
    SIMPLF ==> Stat1: not(FORALL x in a | (FORALL y in b | (FORALL z in c | (FORALL x2 in a | (FORALL y2 in b | (FORALL z2 in c | 
        ((car([[[x,y],z],[x,[y,z]]]) = car([[[x2,y2],z2],[x2,[y2,z2]]])) imp 
                [[[x,y],z],[x,[y,z]]] = [[[x2,y2],z2],[x2,[y2,z2]]])))))))
    (x,y,z,x2,y2,z2) --> Stat1 ==> Stat20: car([[[x,y],z],[x,[y,z]]]) = car([[[x2,y2],z2],[x2,[y2,z2]]]) &
        (not ([[[x,y],z],[x,[y,z]]] = [[[x2,y2],z2],[x2,[y2,z2]]]))
    ([x,[y,z]]],[x,[y,z]]) --> T5 ==> car([[[x,y],z],[x,[y,z]]]) = [x,[y,z]]
    ([x2,[y2,z2]]],[x2,[y2,z2]]) --> T5 ==> car([[[x2,y2],z2],[x2,[y2,z2]]]) = [x2,[y2,z2]]
    (Stat20*)ELEM ==> Stat21: [x,[y,z]] = [x2,[y2,z2]]
    (Stat21+)ELEM ==> x = x2 & y = y2 & z = z2
    EQUAL ==> Stat22: car([[[x,y],z],[x,[y,z]]]) = car([[[x2,y2],z2],[x2,[y2,z2]]]) &
        (not [[[x,y],z],[x,[y,z]]] = [[[x,y],z],[x,[y,z]]])
    (Stat22*)ELEM ==> false; Discharge ==> not is_map(f)
    Use_Def(is_map) ==> f /= {[car(x),cdr(x)]: x in f}
    EQUAL ==> f /= {[car(x),cdr(x)]: x in {[[[x,y],z],[x,[y,z]]]: x in a, y in b, z in c}}
    SIMPLF ==> f /= {[car([[[x,y],z],[x,[y,z]]]),cdr([[[x,y],z],[x,[y,z]]])]: x in a, y in b, z in c}
    SIMPLF ==> f /= {[[[x,y],z],[x,[y,z]]]: x in a, y in b, z in c}
    ELEM ==> false; Discharge ==> QED

Theorem 69: (F = {[[x,y],[y,x]]: x in A, y in B}) imp 
        (one_1_map(F) & domain(F) = (A PROD B) & range(F) = (B PROD A)). Proof:  
    Suppose_not(f,a,b) ==> f = {[[x,y],[y,x]]: x in a, y in b} & 
    (not one_1_map(f) or domain(f) /= (a PROD b) or range(f) /= (b PROD a))
    Suppose ==> domain(f) /= (a PROD b)
    Use_Def(domain) ==> {car(x): x in f} /= (a PROD b)
    EQUAL ==> {car(u): u in {[[x,y],[y,x]]: x in a, y in b}} /= (a PROD b)
    SIMPLF ==> {car([[x,y],[y,x]]): x in a, y in b} /= (a PROD b)
    ELEM ==> car([[X,Y],[Y,X]]) = [X,Y]
    EQUAL ==> {[x,y]: x in a, y in b} /= (a PROD b)
    Use_Def(PROD) ==> {[x,y]: x in a, y in b} /= {[x,y]: x in a, y in b}
    ELEM ==> false; Discharge ==> f = {[[x,y],[y,x]]: x in a, y in b} & 
        (not (one_1_map(f)) or range(f) /= (b PROD a))
    Suppose ==> range(f) /= (b PROD a)
    Use_Def(range) ==> {cdr(x): x in f} /= (b PROD a)
    EQUAL ==> {cdr(u): u in {[[x,y],[y,x]]: x in a, y in b}} /= (b PROD a)
    SIMPLF ==> {cdr([[x,y],[y,x]]): x in a, y in b} /= (b PROD a)
    ELEM ==> cdr([[X,Y],[Y,X]]) = [Y,X]
    EQUAL ==> {[y,x]: x in a, y in b} /= (b PROD a)
    ELEM ==> false; Discharge ==> f = {[[x,y],[y,x]]: x in a, y in b} & (not one_1_map(f))
    Use_Def(one_1_map) ==> (not Svm(f)) or 
          not(FORALL xx in f | (FORALL yy in f | ((cdr(x) = cdr(y)) imp (x = y))))
    Suppose ==> not(FORALL xx in f | (FORALL yy in f | ((cdr(x) = cdr(y)) imp (x = y))))
    EQUAL ==> not(FORALL xx in {[[[x,y],[y,x]]]: x in a, y in b} | 
        (FORALL yy in {[[[x,y],[y,x]]]: x in a, y in b} | ((cdr(x) = cdr(y)) imp (x = y))))
    SIMPLF ==> Stat1: not(FORALL x in a | (FORALL y in b | (FORALL x2 in a | (FORALL y2 in b | 
        ((cdr([[x,y],[y,x]]) = cdr([[x2,y2],[y2,x2]])) imp ([[x,y],[y,x]] = [[x2,y2],[y2,x2]]))))))
    (x,y,x2,y2) --> Stat1 ==>
       (cdr([[x,y],[y,x]]) = cdr([[x2,y2],[y2,x2]])) imp ([[x,y],[y,x]] = [[x2,y2],[y2,x2]])
    ELEM ==> false; Discharge ==> not Svm(f)
    Use_Def(Svm) ==> not is_map(f) or 
          not(FORALL xx in f | (FORALL yy in f | ((car(x) = car(y)) imp (x = y))))
    Suppose ==> not(FORALL xx in f | (FORALL yy in f | ((car(x) = car(y)) imp (x = y))))
    EQUAL ==> not(FORALL xx in {[[[x,y],[y,x]]]: x in a, y in b} | 
        (FORALL yy in {[[[x,y],[y,x]]]: x in a, y in b} | ((car(x) = cdr(a)) imp (x = y))))
    SIMPLF ==> Stat2: not(FORALL x in a | (FORALL y in b | (FORALL x2 in a | (FORALL y2 in b | 
        ((car([[x,y],[y,x]]) = car([[x2,y2],[y2,x2]])) imp ([[x,y],[y,x]] = [[x2,y2],[y2,x2]]))))))
    (x,y,x2,y2) --> Stat2 ==> car([[x,y],[y,x]]) = car([[x2,y2],[y2,x2]]) &
            (not [[x,y],[y,x]] = [[x2,y2],[y2,x2]])
    ELEM ==> false; Discharge ==> not is_map(f)
    Use_Def(is_map) ==> f /= {[car(x),cdr(x)]: x in f}
    EQUAL ==> f /= {[car(x),cdr(x)]: x in {[[x,y],[y,x]]: x in a, y in b}}
    SIMPLF ==> f /= {[car([[x,y],[y,x]]),cdr([[x,y],[y,x]])]: x in a, y in b}
    ELEM ==> Stat3: car([[X,Y],[Y,Z]]) = [X,Y]
    EQUAL ==> f /= {[[x,y],[y,x]]: x in a, y in b}
    ELEM ==> false; Discharge ==> QED

Theorem 70: (ord(S) & X in S) imp (enum(X,S) = X). Proof:
    Suppose_not(s,a) ==> Ord(s) & a in s & enum(a,s) /= a
    APPLY(b) transfinite_induction (p(x)->x in s & enum(x,s) /= x) ==>
      b in s & enum(b,s) /= b & Stat0: (FORALL x in b | (not x in s) or enum(x,s) = x)
    THUS ==> b incin s
    Use_Def(enum) ==> enum(b,s) = if s = {enum(y,s): y in b} then s else arb(s - {enum(y,s): y in b}) end if
    Suppose ==> {enum(y,s): y in b} /= b
    Memb(c) ==> (c in {enum(y,s): y in b} & c notin b) or (c notin {enum(y,s): y in b} & c in b)
    Suppose ==> Stat1: c in {enum(y,s): y in b} & c notin b
    d --> Stat1 ==> c = enum(d,s) & d in b
    (s,b) --> T16 ==> d in s
    d --> Stat0 ==> d notin s or enum(d,s) = d
    ELEM ==> false; Discharge ==> Stat2: c notin {enum(y,s): y in b} & c in b
    c --> Stat2 ==> not(c in b & c = enum(c,s))
    ELEM ==> c in b & c /= enum(c,s)
    c --> Stat0 ==> c notin s
    ELEM ==> false; Discharge ==> {enum(y,s): y in b} = b
    ELEM ==> false; Discharge ==> QED

Theorem 71: [Cardinality Lemma] Ord(#S) & (EXISTS f in OM | (one_1_map(f) & range(f) = S & domain(f) = #S) & 
          (not((EXISTS o in #S | (EXISTS g | one_1_map(g) & range(g) = S & domain(f) = o))))). Proof:
    Suppose_not(s) ==> (not Ord(#s)) or (not(EXISTS f in OM | (one_1_map(f) & range(f) = s & domain(f) = #s))) or
        (EXISTS o in #S | (EXISTS g | Ord(o) & one_1_map(g) & range(g) = s & domain(g) = o))
    Suppose ==> (not Ord(#s)) or (not(EXISTS f in OM | (one_1_map(f) & range(f) = s & domain(f) = #s)))
    Loc_def ==> f := {[x,enum(x,s)]: x in enum_Ord(s)}
    APPLY() fcn_symbol(f(x)->enum(x,s),g->f,s->enum_Ord(s)) ==> 
        Svm(f) & domain(f) = enum_Ord(s) & range(f) = {enum(x,s): x in enum_Ord(s)} &
          (FORALL y in enum_Ord(s) | (FORALL z in enum_Ord(s) | 
                ((enum(y,s) = enum(z,s)) imp (y = z)))) imp (one_1_map(f))
    Use_Def(enum_Ord) ==> Ord(enum_Ord(s)) & s = {enum(y,s): y in enum_Ord(s)} & 
              Stat2: (FORALL y in enum_Ord(s) | (FORALL z in enum_Ord(s) | ((y /= z) imp (enum(y,s) /= enum(z,s)))))
    ELEM ==> Svm(f) & domain(f) = enum_Ord(s) & range(f) = s
    Suppose ==> not one_1_map(f)
    ELEM ==> Stat3: not (FORALL y in enum_Ord(s) | (FORALL z in enum_Ord(s) | ((enum(y,s) = enum(z,s)) imp (y = z))))
    (y,z) --> Stat3 ==> y in enum_Ord(s) & z in enum_Ord(s) & enum(y,s) = enum(z,s) & y /= z
    (y,z) --> Stat2 ==> (y in enum_Ord(s) & z in enum_Ord(s) & y /= z) imp (enum(y,s) = enum(z,s))
    ELEM ==> false; Discharge ==> one_1_map(f)
    Use_Def(next) ==> next(enum_Ord(s)) = enum_Ord(s) + {enum_Ord(s)}
    Suppose ==> 
      enum_Ord(s) notin {x: x in next(enum_Ord(s)) | (EXISTS f in OM | (one_1_map(f) & domain(f) = x & range(f) = s))}
    Defmemb ==> (not (enum_Ord(s) in next(enum_Ord(s))) & 
            (EXISTS f in OM | (one_1_map(f) & domain(f) = enum_Ord(s) & range(f) = s)))
    ELEM ==> Stat4: not (EXISTS f in OM | (one_1_map(f) & domain(f) = enum_Ord(s) & range(f) = s))
    f --> Stat4 ==> false; Discharge ==> 
        {x: x in next(enum_Ord(s)) | (EXISTS ff | (one_1_map(ff) & domain(ff) = x & range(ff) = s))} /= 0
    {x: x in next(enum_Ord(s)) | (EXISTS ff | (one_1_map(ff) & domain(ff) = x & range(ff) = s))} --> Ax_ch ==>
      arb({x: x in next(enum_Ord(s)) | (EXISTS ff | (one_1_map(ff) & domain(ff) = x & range(ff) = s))}) in 
        {x: x in next(enum_Ord(s)) | (EXISTS ff | (one_1_map(ff) & domain(ff) = x & range(ff) = s))} & 
      arb({x: x in next(enum_Ord(s)) | (EXISTS ff | (one_1_map(ff) & domain(ff) = x & range(ff) = s))}) * 
        {x: x in next(enum_Ord(s)) | (EXISTS ff | (one_1_map(ff) & domain(ff) = x & range(ff) = s))} = 0
    Use_Def(#) ==> #s in {x: x in next(enum_Ord(s)) | (EXISTS ff | (one_1_map(ff) & domain(ff) = x & range(ff) = s))} &
         #s * {x: x in next(enum_Ord(s)) | (EXISTS ff | (one_1_map(ff) & domain(ff) = x & range(ff) = s))} = 0
    Defmemb ==> #s in next(enum_Ord(s)) & (EXISTS ff | (one_1_map(ff) & domain(ff) = #s & range(ff) = s))
    (enum_Ord(s)) --> T15 ==> Ord(next(enum_Ord(s)))
    (s,enum_Ord(s)) --> T12 ==> false; 
    Discharge ==> Stat5: (EXISTS o in #S | (EXISTS g | (Ord(o) & one_1_map(g) & range(g) = s & domain(g) = o)))
    o --> Stat5 ==> o in #s & (EXISTS g | (one_1_map(g) & domain(g) = o & range(g) = s))
    ELEM ==> o notin {x: x in next(enum_Ord(s)) | (EXISTS ff | (one_1_map(ff) & domain(ff) = x & range(ff) = s))}
    Defmemb ==> o notin next(enum_Ord(s))
    (#s,next(enum_Ord(s))) --> T10 ==> false; Discharge ==> QED

Theorem 72: [The enumerating ordinal of a set has the same cardinality as the set] 
    (EXISTS o | Ord(o) & S = {enum(x,S): x in o} & #o = #S). Proof:
    Suppose_not(s) ==> Stat0: not(EXISTS o | (Ord(o) & s = {enum(x,s): x in o} & #o = #s))
    s --> T22 ==> Stat1: (EXISTS o | (Ord(o) & s = {enum(x,s): x in o})) 
            & Stat2: (FORALL y in o | (FORALL z in o | ((y /= z) imp (enum(y,s) /= enum(z,s)))))
    o --> Stat1 ==> Ord(o) & s = {enum(x,s): x in o} & (FORALL y in o | (FORALL z in o | ((y /= z) imp (enum(y,s) /= enum(z,s)))))
    APPLY() fcn_symbol(f(x)->enum(x,s),g->f,s->o) ==> 
        Svm(f) & domain(f) = o & range(f) = {enum(x,s): x in o} &
          ((FORALL y in o | (FORALL z in o | ((enum(y,s) = enum(z,s)) imp (y = z)))) imp one_1_map(f))
    Suppose ==> Stat3: not(FORALL y in o | (FORALL z in o | ((enum(y,s) = enum(z,s)) imp (y = z))))
    (a,b) --> Stat3 ==> a in o & b in o & enum(a,s) = enum(b,s) & (not a = b) 
    (a,b) --> Stat2 ==> false; Discharge ==> one_1_map(f)
    ELEM ==> one_1_map(f) & domain(f) = o & range(f) = s
    f --> T55 ==> one_1_map(inv(f)) & range(inv(f)) = #o & domain(inv(f)) = o
    (s,any_g) --> T71 ==> Ord(#s) & Stat4: (EXISTS f in OM | (one_1_map(f) & range(f) = s & domain(f) = #s))
    h --> Stat4 ==> one_1_map(h) & range(h) = s & domain(h) = #s
    h --> T55 ==> one_1_map(inv(h)) & range(inv(h)) = #s & domain(inv(h)) = s
    (o,any_g) --> T71 ==> Ord(#o) & Stat5: (EXISTS f in OM | (one_1_map(f) & range(f) = o & domain(f) = #o))
    g --> Stat5 ==> one_1_map(g) & range(g) = o & domain(g) = #o
    (#s,#o) --> T11 ==> #s in #o or #o in #s or #o = #s
    (s,any_g) --> T71 ==> Stat6: not((EXISTS oo in #s | (EXISTS g | (one_1_map(g) & range(g) = s & domain(f) = oo))))
    (o,any_g) --> T71 ==> Stat7: not((EXISTS oo in #o | (EXISTS g | (one_1_map(g) & range(g) = o & domain(f) = oo))))
    Suppose ==> #o in #s
    (f,g) --> T51a ==> domain(f @ g) = #o & range(f @ g) = s
    (f,g) --> T65 ==> one_1_map(f @ g)
    (#o,f @ g) --> Stat6 ==> false; Discharge ==> #s in #o or #o = #s
    Suppose ==> #s in #o
    (inv(f),h) --> T51a ==> domain(inv(f) @ h) = #s & range(inv(f) @ h) = o
    (inv(f),h) --> T65 ==> one_1_map(inv(f) @ g)
    (#s,inv(f) @ g) --> Stat7 ==> false; Discharge ==> #o = #s
    o --> Stat1 ==> false; Discharge ==> QED

Theorem 73: ['arb' is monotone decreasing for non-empty sets of ordinals] 
    (Ord(R) & R incs S & S incs T) imp (arb(S) in arb(T) or arb(S) = arb(T) or T = 0). Proof:
    Suppose_not(o,s,t) ==> Ord(o) & o incs s & s incs t & arb(s) notin arb(t) & arb(s) /= arb(t)
    s --> Ax_ch ==> (arb(s) in s & arb(s) * s = 0) or (s = 0 & arb(s) = 0)
    t --> Ax_ch ==> arb(t) in t
    Suppose ==> s = 0
    ELEM ==> false; Discharge ==> arb(s) in s & arb(s) * s = 0 & arb(s) in o
    (o,arb(s)) --> T12 ==> Ord(arb(s))
    ELEM ==> arb(t) in o
    (o,arb(t)) --> T12 ==> Ord(arb(t))
    (arb(s),arb(t)) --> T11 ==> arb(t) in arb(s) * s
    ELEM ==> false; Discharge ==> QED

Theorem 74: [Lemma for following theorem] 
      (Ord(S) & T incin S & X in S & Y in X) imp (enum(Y,T) in enum(X,T) or enum(X,T) incs T). Proof:
    Suppose_not(s,t,x,y) ==> 
        Ord(s) & t incin s & x in s & y in x & enum(y,t) notin enum(x,t) & (not(enum(x,t) incs t))
    Use_Def(enum) ==> enum(x,t) = if t incin {enum(u,t): u in x} then t else arb(t - {enum(u,t): u in x}) end if
    ELEM ==> (t - {enum(u,t): u in x}) /= 0 & enum(x,t) = arb(t - {enum(u,t): u in x})
    (t - {enum(u,t): u in x}) --> Ax_ch ==> enum(x,t) in t - {enum(u,t): u in x}
    ELEM ==> enum(x,t) in s
    THUS ==> Ord(enum(x,t)) & Ord(x) & Ord(y) & y incin x
    Set_monot ==> {enum(u,t): u in y} incin {enum(u,t): u in x}
    Use_Def(enum) ==> enum(y,t) = if t incin {enum(u,t): u in y} then t else arb(t - {enum(u,t): u in y}) end if
    ELEM ==> (t - {enum(u,t): u in y}) /= 0 & enum(y,t) = arb(t - {enum(u,t): u in y})
    ELEM ==> t - {enum(u,t): u in y} incs t - {enum(u,t): u in x}
    (s, t - {enum(u,t): u in y},t - {enum(u,t): u in x}) --> T73 ==> enum(y,t) in enum(x,t) or enum(y,t) = enum(x,t)
    ELEM ==> enum(y,t) = enum(x,t) & enum(y,t) in (t - {enum(u,t): u in x})
    ELEM ==> Stat1: enum(y,t) notin {enum(u,t): u in x}
    y --> Stat1 ==> enum(y,t) /= enum(u,t) or y notin x
    ELEM ==> false; Discharge ==> QED
    
Theorem 75: [Subsets enumerate at least as rapidly] 
      (ord(S) & T incin S & X in S) imp (enum(X,T) incs X). Proof:
    Suppose_not(s,t,b) ==> Ord(s) & t incin s & b in s & (not (enum(b,t) incs b or enum(b,t) incs t))
    APPLY(a) transfinite_induction (p(x)->x in s & (not(enum(x,t) incs x or enum(x,t) incs t))) ==>
      a in s & (not (enum(a,t) incs a)) & (not (enum(a,t) incs t)) & 
              Stat0: (FORALL x in a | ((not x in s) or enum(x,t) incs x or enum(x,t) incs t))
    ELEM ==> (t - {enum(y,t): y in a}) /= 0 & enum(a,t) = arb(t - {enum(y,t): y in a})
    enum(a,t) --> Ax_ch ==> enum(a,t) in t - {enum(y,t): y in a}
    THUS ==> Ord(a) & a incin s
    ELEM ==> enum(a,t) in s
    THUS ==> Ord(enum(a,t)) & enum(a,t) in a
    (s,t,a,enum(a,t)) --> T74 ==> enum(enum(a,t),t) in enum(a,t)
    THUS ==> enum(enum(a,t),t) incin enum(a,t)
    (enum(a,t)) --> Stat0 ==> (not (enum(a,t) in s)) or enum(enum(a,t),t) incs enum(a,t) or enum(enum(a,t),t) incs t
    ELEM ==> enum(enum(a,t),t) incs enum(a,t)
    ELEM ==> enum(enum(a,t),t) in enum(enum(a,t),t)
    ELEM ==> false; Discharge ==> QED

Theorem 76: (Ord(S) & T incin S) imp ({enum(x,T): x in S} incs T). Proof:
    Suppose_not(s,t) ==> Ord(s) & t incin s & (not({enum(x,T): x in S} incs T))
    s --> T15 ==> Ord(next(s))
    Use_Def(next) ==> next(s) = s + {s}
    ELEM ==> s in next(s) & t incin next(s)
    (next(s),t,s) --> T75 ==> enum(s,t) incs t
    Use_Def(enum) ==> enum(s,t) = if t incin {enum(y,t): y in s} then t else arb(t - {enum(y,t): y in s}) end if
    Suppose ==> not(t incin {enum(y,t): y in s})
    ELEM ==> t - {enum(y,t): y in s} /= 0
    (t - {enum(y,t): y in s}) --> Ax_ch ==> enum(s,t) in t
    ELEM ==> false; Discharge ==> QED

Theorem 77: (Ord(S) & T incin S) imp (EXISTS x incin S | (Ord(x) & T = {enum(y,T): y in x} & 
                (FORALL y in x | (FORALL z in x | ((y /= z) imp (enum(y,T) /= enum(z,T))))))). Proof:
    Suppose_not(s,t) ==> Ord(s) & t incin s & Stat0: (not(EXISTS x incin s | (Ord(x) & t = {enum(y,t): y in x} & 
                (FORALL y in x | (FORALL z in x | ((y /= z) imp (enum(y,t) /= enum(z,t))))))))
    (s,t) --> T76 ==> s incin t & Ord(s) & {enum(u,t): u in s} incs t
    APPLY(u) transfinite_induction (p(x)->Ord(x) & x incin s & {enum(v,t): v in s} incs t) ==>
      Ord(u) & u incin s & {enum(v,t): v in u} incs t & 
          Stat1: (FORALL x in u | (not(Ord(x) & x incin s & {enum(v,t): v in x} incs t)))
    u --> Stat0 ==> not(t = {enum(y,t): y in u} & (FORALL y in u | (FORALL z in u | ((y /= z) imp (enum(y,t) /= enum(z,t))))))
    Suppose ==> Stat3: not(FORALL y in u | (FORALL z in u | ((y /= z) imp (enum(y,t) /= enum(z,t)))))
    (y,z) --> Stat3 ==> y in u & z in u & y /= z & enum(y,t) = enum(z,t)
    THUS ==> Ord(y) & Ord(z) & y incin u & z incin u
    (y,z,t) --> T20 ==> t in {enum(v,t): v in y} or t in {enum(v,t): v in z}
    Suppose ==> Stat4: t in {enum(v,t): v in y}
    a --> Stat4 ==> t = enum(a,t) & a in y
    ELEM ==> false; Discharge ==> Stat5: t in {enum(v,t): v in z}
    b --> Stat5 ==> false; Discharge ==> t /= {enum(y,t): y in u} & t incin {enum(y,t): y in u}
    ELEM ==> not (t incs {enum(y,t): y in u})
    Memb(c) ==> Stat6: c in {enum(y,t): y in u} & c notin t
    d --> Stat6 ==> c = enum(d,t) & d in u & c notin t
    Use_Def(enum) ==> enum(d,t) = if t incin {enum(y,t): y in d} then t else arb(t - {enum(y,t): y in d}) end if
    THUS ==> Ord(d) & d incin u
    d --> Stat1 ==> not({enum(v,t): v in d} incs t)
    ELEM ==> (t - {enum(y,t): y in d}) /= 0
    (t - {enum(y,t): y in d}) --> Ax_ch ==> enum(d,t) in t
    ELEM ==> false; Discharge ==> QED

Theorem 78: [Subsets of an ordinal have a cardinality that is no larger than the ordinal]
    (Ord(S) & T incin S) imp (#T incin S). Proof:
    Suppose_not(s,t) ==> Ord(s) & t incin s & (not(#t incin s))
    t --> T80 ==> Card(#t)
    THUS ==> Ord(s) & Ord(#t) & s in #t 
    (s,t) --> T22 ==> Stat1: (EXISTS x incin s | Ord(x) & t = {enum(y,t): y in x}) & 
                Stat2: (FORALL y in x | (FORALL z in x | ((y /= z) imp (enum(y,t) /= enum(z,t)))))
    u --> Stat1 ==> u incin s & Ord(u) & t = {enum(y,t): y in u} & 
              (FORALL y in u | (FORALL z in u | ((y /= z) imp (enum(y,t) /= enum(z,t)))))
    APPLY() fcn_symbol(f(x)->enum(x,t),g->g,s->u) ==> 
      Svm(g) & range(g) = t & domain(g) = u &
          Stat3:((FORALL x in u | (FORALL y in u | ((enum(x,t) = enum(y,t)) imp (x = y))) imp (one_1_map(g))))
    Suppose ==> Stat4: not((FORALL x in u | (FORALL y in u | ((enum(x,t) = enum(y,t)) imp (x = y)))))
    (x,y) --> Stat4 ==> x in u & y in u & enum(x,t) = enum(y,t) & x /= y
    (x,y) --> Stat3 ==> false; Discharge ==> one_1_map(g) & range(g) = t & domain(g) = u
    Use_Def(#) ==> #t = arb({x: x in next(enum_Ord(t)) | (EXISTS f in OM | one_1_map(f) & domain(f) = x & range(f) = t)}) 
    Use_Def(enum_Ord) ==> Ord(enum_Ord(t)) & s = {enum(y,t): y in enum_Ord(s)} & 
              Stat5: (FORALL y in enum_Ord(t) | (FORALL z in enum_Ord(t) | ((y /= z) imp (enum(y,t) /= enum(z,t)))))
    APPLY() fcn_symbol(f(x)->enum(x,t),g->h,s->enum_Ord(t)) ==> 
      Svm(h) & range(h) = t & domain(h) = enum_Ord(t) &
          Stat6: ((FORALL x in enum_Ord(t) | (FORALL y in enum_Ord(t) | ((enum(x,t) = enum(y,t)) imp (x = y))) imp one_1_map(g)))
    Suppose ==> Stat6: not(FORALL x in enum_Ord(t) | (FORALL y in enum_Ord(t) | ((enum(x,t) = enum(y,t)) imp (x = y))))
    (x1,y1) --> Stat6 ==> x1 in enum_Ord(t) & y1 in enum_Ord(t) & enum(x1,t) = enum(y1,t) & x1 /= y1
    (x1,y1) --> Stat5 ==> false; Discharge ==> one_1_map(h) & range(h) = t & domain(h) = enum_Ord(t)
    Use_Def(next) ==> next(enum_Ord(t)) = enum_Ord(t) + {enum_Ord(t)}
    ELEM ==> enum_Ord(t) in next(enum_Ord(t))
    Suppose ==> Stat7: 
      not(enum_Ord(t) in {x: x in next(enum_Ord(t)) | (EXISTS f in OM | (one_1_map(f) & domain(f) = x & range(f) = t))})
    (enum_Ord(t)) --> Stat4 ==> Stat8: not(EXISTS f in OM |(one_1_map(f) & domain(f) = enum_Ord(t) & range(f) = t))
    h --> Stat8 ==> false 
    Discharge ==> enum_Ord(t) in {x: x in next(enum_Ord(t)) | (EXISTS f in OM | (one_1_map(f) & domain(f) = x & range(f) = t))}
    ELEM ==> {x: x in next(enum_Ord(t)) | (EXISTS f in OM | one_1_map(f) & domain(f) = x & range(f) = t)} /= 0
    ({x: x in next(enum_Ord(t)) | (EXISTS f in OM | (one_1_map(f) & domain(f) = x & range(f) = t))}) --> Ax_ch ==> 
      Stat8: #t in {x: x in next(enum_Ord(t)) | (EXISTS f in OM | (one_1_map(f) & domain(f) = x & range(f) = t))}
        & #t * {x: x in next(enum_Ord(t)) | (EXISTS f in OM | (one_1_map(f) & domain(f) = x & range(f) = t))} = 0
    ELEM ==> Ord(u) & range(g) = t & domain(g) = u & one_1_map(g) & s in #t & u incin s
    THUS ==> u incin #t
    THUS ==> u in #t
    a --> Stat8 ==> #t in next(enum_Ord(t))
    (enum_Ord(t)) --> T15 ==> Ord(next(enum_Ord(t)))
    (next(enum_Ord(t)),#t) --> T16 ==> u in #t & u in next(enum_Ord(t))
    ELEM ==> Stat9: u notin {x: x in next(enum_Ord(t)) | (EXISTS f in OM | one_1_map(f) & domain(f) = x & range(f) = t)}
    u --> Stat8 ==> Stat10: not(EXISTS f in OM | one_1_map(f) & domain(f) = u & range(f) = t)
    g --> Stat8 ==> false; Discharge ==> QED

Theorem 79: [Single-valued maps have 1-1 partial inverses]
    Svm(F) imp (EXISTS h | (domain(h) = range(F) & range(h) incin domain(F) & one_1_map(h)) &
                (FORALL x in range(F) | (F~[h~[x]] = x))). Proof:
    Suppose_not(f) ==> Svm(f) &
      Stat1: (not(EXISTS h | (domain(h) = range(f) & range(f) incin domain(f) & one_1_map(h) &
                (FORALL x in range(f) | f~[h~[x]] = x))))
    Loc_def ==> g1(v) := arb({car(u): u in f | cdr(u) = v})
    Suppose ==> Stat2: not(FORALL v in range(f) | g1(v) in {car(u): u in f | cdr(u) = v})
    v --> Stat2 ==> v in range(f) & (not(g1(v) in {car(u): u in f | cdr(u) = v}))
    ELEM ==> not(arb({car(u): u in f | cdr(u) = v}) in {car(u): u in f | cdr(u) = v})
    {car(u): u in f | cdr(u) = v} --> Ax_ch ==> {car(u): u in f | cdr(u) = v} = 0
    Use_Def(range) ==> Stat3: v in {cdr(x): u in f}
    c --> Stat3 ==> v = cdr(c) & c in f
    Suppose ==> Stat4: car(c) notin {car(u): u in f | cdr(u) = v}
    c --> Stat4 ==> not(c in f & car(c) = car(c) & cdr(c) = v)
    ELEM ==> false; Discharge ==> car(c) in {car(u): u in f | cdr(u) = v}
    ELEM ==> {car(u): u in f | cdr(u) = v} /= 0
    ELEM ==> false; Discharge ==> Stat6: (FORALL v in range(f) | g1(v) in {car(u): u in f | cdr(u) = v})
    Use_Def(range) ==> (FORALL v in {cdr(x): x in f} | (g1(v) in {car(u): u in f | cdr(u) = v}))
    SIMPLF ==> (FORALL x in f | g1(cdr(x)) in {car(u): u in f | cdr(u) = cdr(x)})
    Set_monot ==> (FORALL x in f | g1(cdr(x)) in {car(u): u in f})
    Use_Def(domain) ==> Stat5: (FORALL x in f | g1(cdr(x)) in domain(f))
    Loc_def ==> h := {[x,g1(x)]: x in range(f)}
    APPLY() fcn_symbol(f(x)->g1(x),g->h,s->range(f)) ==> 
      Svm(h) & domain(h) = range(f) & range(h) = {g1(x): x in range(f)} & (FORALL x in s | h~[x] = g1(x)) &
        ((FORALL x in range(f) | (FORALL y in range(f) | ((g1(x) = g1(y)) imp (x = y)))) imp one_1_map(h))
    Use_Def(range) ==> range(h) = {g1(x): x in {cdr(x): x in f}}
    SIMPLF ==> range(h) = {g1(cdr(x)): x in f}
    Suppose ==> not(range(h) incin domain(f))
    Memb(d) ==> d in range(h) & d notin domain(f)
    ELEM ==> Stat6: d in {g1(cdr(x)): x in f}
    e --> Stat6 ==> d = g1(cdr(e)) & e in f
    e --> Stat5 ==> (e in f) imp (g1(cdr(e)) in domain(f))
    ELEM ==> false; Discharge ==> range(h) incin domain(f)
    Suppose ==> Stat7: not(FORALL v in range(f) | f~[g1(v)] = v)
    v --> Stat7 ==> v in range(f) & f~[g1(v)] /= v
    v --> Stat6 ==> (v in range(f)) imp (g1(v) in {car(u): u in f | cdr(u) = v})
    ELEM ==> Stat8: g1(v) in {car(u): u in f | cdr(u) = v}
    a --> Stat8 ==> g1(v) = car(a) & a in f & cdr(a) = v
    f --> T39 ==> Stat9: a in {[x,f~[x]]: x in domain(f)}
    b --> Stat9 ==> a = [b,f~[b]] & b in domain(f)
    ELEM ==> g1(v) = b & v = f~[b]
    ELEM ==> v = f~[g1(v)]
    ELEM ==> false; Discharge ==> Stat10: (FORALL v in range(f) | f~[g1(v)] = v)
    ELEM ==> (FORALL v in range(f) |f~[h~[v]] = v)
    Suppose ==> not one_1_map(h)
    Use_Def(one_1_map) ==> not Svm(h) or not(FORALL x in h | (FORALL y in h | ((cdr(x) = cdr(y)) imp (x = y))))
    ELEM ==> Stat11:
      not(FORALL x in range(f)| (FORALL y in range(f) | ((g1(x) = g1(y)) imp (x = y))))
    (w,z) --> Stat11 ==> w in range(f) & z in range(f) & g1(w) = g1(z) & w = z
    w --> Stat10 ==> f~[g1(w)] = w
    z --> Stat10 ==> f~[g1(z)] = z
    ELEM ==> false; Discharge ==> one_1_map(h)
    h --> Stat1 ==> 
      not(domain(h) = range(f) & range(f) incin domain(f) & one_1_map(h) & (FORALL x in range(f)| f~[h~[x]] = x))
    ELEM ==> false; Discharge ==> QED
    
Theorem 80: [Cardinality theorem] Card(#S) & (EXISTS f in OM | one_1_map(f) & range(f) = S & domain(f) = #S). Proof:
    Suppose_not(s) ==> (not Card(#s)) or (not (EXISTS f in OM | one_1_map(f) & range(f) = s & domain(f) = #s))
    s --> T71 ==> Ord(#s) & Stat0: (EXISTS f in OM | one_1_map(f) & range(f) = s & domain(f) = #s) &
                  Stat1: (not(EXISTS o in #s | (EXISTS g | one_1_map(g) & range(g) = S & domain(f) = o)))
    ELEM ==> not Card(#s)
    Use_Def(Card) ==> Stat2: not (FORALL y in #s | (FORALL ff | not(domain(ff) = y) or not(range(ff) = #s) or not(Svm(ff))))
    (c,g) --> Stat2 ==> c in #s & domain(g) = c & range(g) = #s & Svm(g)
    g --> T79 ==> Stat3: (EXISTS h | domain(h) = range(g) & range(h) incin domain(g) & one_1_map(h))
    h --> Stat3 ==> domain(h) = #s & range(h) incin c & one_1_map(h)
    h --> T55 ==> range(inv(h)) = #s & domain(inv(h)) incin c & one_1_map(inv(h))
    (domain(inv(h))) --> T74 ==> 
        Stat4: (EXISTS f in OM | one_1_map(f) & Ord(domain(f)) & domain(f) incin c & range(f) = domain(inv(h)))
    f --> Stat4 ==> one_1_map(f) & Ord(domain(f)) & domain(f) incin c & range(f) = domain(inv(h))
    THUS ==> (domain(f) in c or domain(f) = c) & c incin #s
    ELEM ==> domain(f) in #s
    (inv(h),f) --> T51a ==> domain(inv(h) @ f) = domain(f) & range(inv(h) @ f) = #s
    (inv(h),f) --> T65 ==> one_1_map(inv(h) @ f)
    ff --> Stat0 ==> one_1_map(ff) & range(ff) = s & domain(ff) = #s
    (ff,inv(h) @ f) --> T51a ==> domain(ff @ (inv(h) @ f)) = domain(f) & range(inv(h) @ f) = s
    (ff,inv(h) @ f) --> T65 ==> one_1_map(ff @ (inv(h) @ f))
    (domain(f),inv(h) @ f) --> Stat1 ==> false; Discharge ==> QED

Theorem 81: #S = 0 eq S = 0. Proof:
    Suppose_not(s) ==> (#s = 0 & s /= 0) or (#s /= 0 & s = 0)
    (s,f) --> T71 ==> one_1_map(f) & range(f) = s & domain(f) = #s
    Use_Def(one_1_map) ==> Svm(f)
    f --> T39a ==> range(f) = {f~[x]: x in #s}
    Suppose ==> #s = 0 & s /= 0
    ELEM ==> false; Discharge ==> #s /= 0 & s = 0
    Memb(c) ==> c in #s
    Suppose ==> Stat1: f~[c] notin {f~[x]: x in #s}
    c --> Stat1 ==> false; Discharge ==> range(f) /= 0
    ELEM ==> false; Discharge ==> QED

Theorem 82: [Uniqueness of Cardinality] 
        (Card(C) & (EXISTS f in OM | (one_1_map(f) & range(f) = S & domain(f) = C))) imp (C = #S). Proof:
    Suppose_not(c,s,f) ==> Card(c) & one_1_map(f) & range(f) = s & domain(f) = c & c /= #s
    (s,g) --> T80 ==> Card(#s) & one_1_map(g) & range(g) = s & domain(g) = #s
    f --> T53 ==> is_map(inv(f)) & range(inv(f)) = domain(f) & domain(inv(f)) = range(f)
    g --> T53 ==> is_map(inv(g)) & range(inv(g)) = domain(g) & domain(inv(g)) = range(g)
    f --> T55 ==> one_1_map(inv(f))
    g --> T55 ==> one_1_map(inv(g)) & one_1_map(inv(f))
    Use_Def(one_1_map) ==> Svm(f)
    Use_Def(one_1_map) ==> Svm(inv(f)) & Svm(inv(g))
    (f,inv(g)) --> T63 ==> Svm(inv(g) @ f)
    (g,inv(f)) --> T63 ==> Svm(inv(f) @ g)
    (f,inv(g)) --> T51a ==> domain(inv(g) @ f) = c & range(inv(g) @ f) = #s
    (g,inv(f)) --> T51a ==> domain(inv(f) @ g) = #s & range(inv(f) @ g) = c
    Use_Def(Card) ==> Ord(c) & Stat2: (FORALL y in c | (FORALL f IN OM | not(domain(f) = y) or not(range(f) = c) or (not(Svm(f)))))
    Use_Def(Card) ==> 
      Ord(#s) & Stat3: (FORALL y in #s | (FORALL f in OM | not(domain(f) = y) or not(range(f) = #s) or not(Svm(f))))
    (c,#s) --> T16 ==> c in #s or #s in c
    Suppose ==> c in #s
    c --> Stat3 ==> Stat4: (FORALL f in OM | not(domain(f) = c) or not(range(f) = #s) or not(Svm(f)))
    inv(g) @ f --> Stat3 ==> false; Discharge ==> #s in c
    #s --> Stat2 ==> Stat5: (FORALL f in OM | not(domain(f) = y) or not(range(f) = c) or not(Svm(f)))
    inv(f) @ g --> Stat3 ==> false; Discharge ==> QED

Theorem 83: [Subset cardinality theorem] (T incin S) imp (#T incin #S). Proof:
    Suppose_not(t,s) ==> t incin s & (not (#t incin #s))
    (s,f) --> T80 ==> one_1_map(f) & range(f) = s & domain(f) = #s
    f --> T55 ==> one_1_map(inv(f)) & f = inv(inv(f)) & range(inv(f)) = domain(f) & domain(inv(f)) = range(f)
    (inv(f),t) --> T49 ==> one_1_map(inv(f) ON t)
    (inv(f),t) --> T50 ==> range(inv(f) ON t) incin #s
    (s,any_g) --> T71 ==> Ord(#s)
    (range(inv(f) ON t),#s) --> T78 ==> #range(inv(f) ON t) incin #s
    (inv(f),t) --> T50a ==> domain(inv(f) ON t) = t
    (t,g) --> T71 ==> Ord(#t) & one_1_map(g) & range(g) = t & domain(g) = #t & 
          Stat0: (not((EXISTS o in #t | (EXISTS g | one_1_map(g) & range(g) = t & domain(f) = o))))
    THUS ==> #s in #t
    (range(inv(f) ON t),any_g) --> T71 ==> Ord(#range(inv(f) ON t))
    THUS ==> (#range(inv(f) ON t) = #s or #range(inv(f) ON t) in #s) & #s incin #t
    ELEM ==> #range(inv(f) ON t) in #t
    o --> Stat0 ==> false; Discharge ==> QED

Theorem 84: one_1_map(F) imp (#range(F) = #domain(F)). Proof:
    Suppose_not(h) ==> one_1_map(h) & #range(h) /= #domain(h)
    (s,f) --> T71 ==> one_1_map(f) & range(f) = range(h) & domain(f) = #range(h)
    (t,g) --> T71 ==> one_1_map(g) & range(g) = domain(h) & domain(g) = #domain(h)
    f --> T55 ==> one_1_map(inv(f)) & range(inv(f)) = #range(h) & domain(inv(f)) = range(h)
    g --> T55 ==> one_1_map(inv(g)) & range(inv(g)) = #domain(h) & domain(inv(g)) = domain(g)
    h --> T55 ==> one_1_map(inv(h)) & range(inv(h)) = domain(h) & domain(inv(h)) = range(h)
    (domain(h)) --> T80 ==> Card(#domain(h))
    Use_Def(Card) ==> 
      Stat3: (FORALL y in #domain(h) | (FORALL f in OM | not(domain(f) = y)) or not(range(f) = #domain(h)) or not(Svm(f)))
    (range(h)) --> T80 ==> Card(#range(h)) & Card(#domain(h))
    Use_Def(Card) ==> Ord(#range(h)) & Ord(#domain(h))
      Stat4: (FORALL y in #range(h) | (FORALL f in OM | not(domain(f) = y)) or not(range(f) = #range(h)) or not(Svm(f)))
    (h,g) --> T65 ==> one_1_map(h @ f)
    (h,g) --> T51a ==> range(h @ f) = range(h) & domain(h @ f) = #range(h)
    (h @ f,g) --> T65 ==> one_1_map(inv(g) @ (h @ f))
    (h @ f,g) --> T51a ==> range(inv(g) @ (h @ f)) = #domain(h) & domain(inv(g) @ (h @ f)) = #range(h)
    (h,g) --> T65 ==> one_1_map(inv(h) @ g)
    (h,g) --> T51a ==> range(inv(h) @ g) = domain(h) & domain(inv(h) @ g) = #domain(h)
    (inv(h) @ g,inv(f)) --> T65 ==> one_1_map(inv(f) @ (inv(h) @ g))
    (inv(h) @ g,inv(f)) --> T51a ==> 
        range(inv(f) @ (inv(h) @ g)) = #range(h) & domain(inv(f) @ (inv(h) @ g)) = #domain(h)
    Suppose ==> #range(h) in #domain(h)
    (#range(h),inv(g) @ (h @ f)) --> Stat3 ==> not(Svm(inv(g) @ (h @ f)))
    Use_Def(Svm) ==> false; Discharge ==> #range(h) notin #domain(h)
    Suppose ==> #domain(h) in #range(h)
    (#domain(h),inv(f) @ (inv(h) @ g)) --> Stat4 ==> not(Svm(inv(f) @ (inv(h) @ g)))
    Use_Def(Svm) ==> false; Discharge ==> #domain(h) notin #range(h)
    (#range(h),#domain(h)) --> T99999 ==> false; Discharge ==> QED

Theorem 85: Svm(F) imp (#range(F) incin #domain(F)). Proof:
    Suppose_not(f) ==> Svm(f) & (not (#range(f) incin #domain(f)))
    (f,h) --> T79 ==> domain(h) = range(f) & range(h) incin domain(f) & one_1_map(h)
    THUS ==> #range(h) incin #domain(f)
    h --> T84 ==> false; Discharge ==> QED

Theorem 85a: (F incin G) imp (range(F) incin range(G) & domain(F) incin domain(G)). Proof:
    Suppose_not(f,g) ==> f incin g & (not(range(f) incin range(g)) & domain(f) incin domain(g))
    Suppose ==> not range(f) incin range(g)
    Use_Def(range) ==> not {cdr(x): x in f} incin {cdr(x): x in g}
    Set_monot ==> false; Discharge ==> not domain(f) incin domain(g)
    Use_Def(domain) ==> not {car(x): x in f} incin {car(x): x in g}
    Set_monot ==> false; Discharge ==> QED
    
Def 18: [Finiteness] 
    Finite(s) :eq not(EXISTS f in OM | one_1_map(f) & domain(f) = s & range(f) incin s & s /= range(f))

Theorem 86: [0 is a finite cardinal] Ord(0) & Finite(0) & Card(0). Proof: 
    Suppose ==> not Ord(0) 
    Use_Def(Card) ==> Stat1: (not(FORALL x in 0 | x incin 0)) or 
                (not(FORALL x in 0 | (FORALL y in 0 | x in y or y in x or x = y)))
    (c,d,e) --> Stat1 ==> (c in 0 and (not (c incin 0))) or (d in 0 & e in 0 & (not(d in e or e in d or d = e)))
    ELEM ==> false; Discharge ==> Ord(0)
    Suppose ==> not Finite(0)
    Use_Def(Finite) ==> 
      Stat2:(EXISTS f in OM | Svm(f) & range(f) = 0 & domain(f) incin 0 & 0 /= domain(f))
    f --> Stat2 ==> domain(f) incin 0 & 0 /= domain(f)
    ELEM ==> false; Discharge ==> Finite(0)
    Suppose ==> not Card(0)
    Use_Def(Card) ==> (not Ord(0)) or 
      (not(FORALL y in s | (FORALL f in OM | (not(domain(f) = y)) or (not(range(f) = s)) or (not(Svm(f))))))
    ELEM ==> 
      Stat3: not(FORALL y in 0 | (FORALL f in OM | (not(domain(f) = y)) or (not(range(f) = s)) or (not(Svm(f)))))
    (y,f) --> Stat3 ==> y in 0
    ELEM ==> false; Discharge ==> Card(0)
    ELEM ==> QED

Theorem 87: #domain(F) incin #F. Proof:
    Suppose_not(f) ==> not #domain(f) incin #f
    Loc_def ==> g := {[x,car(x)]: x in f}
    APPLY() fcn_symbol(f(x)->car(x),g->g,s->f) ==> Svm(g) & domain(g) = f & range(g) = {car(x): x in f}
    Use_Def(domain) ==> range(g) = domain(f)
    g --> T85 ==> #domain(f) incin #f
    ELEM ==> false; Discharge ==> QED

Theorem 88: #range(F) incin #F. Proof:
    Suppose_not(f) ==> not #range(f) incin #f
    Loc_def ==> g := {[x,cdr(x)]: x in f}
    APPLY() fcn_symbol(f(x)->cdr(x),g->g,s->f) ==> Svm(g) & domain(g) = f & range(g) = {cdr(x): x in f}
    Use_Def(range) ==> range(g) = range(f)
    f --> T85 ==> #range(f) incin #f
    ELEM ==> false; Discharge ==> QED

Theorem 89: Svm(F) imp (#domain(F) = #F). Proof:
    Suppose_not(f) ==> Svm(f) & #domain(f) = #f
    Loc_def ==> g := {[x,car(x)]: x in f}
    APPLY() fcn_symbol(f(x)->car(x),g->g,s->f) ==> 
      Svm(g) & domain(g) = f & range(g) = {car(x): x in f} & 
          (((FORALL x in f | (FORALL x in f | ((car(x) = car(y)) imp (x = y))))) imp one_1_map(g))
    Use_Def(domain) ==> range(g) = domain(f)
    Suppose ==> not one_1_map(g)
    Use_Def(Svm) ==> (FORALL x in f | (FORALL y in f | ((car(x) = car(y)) imp (x = y))))
    ELEM ==> one_1_map(g)
    g --> T84 ==> #domain(f) = #f
    ELEM ==> false; Discharge ==> QED

Theorem 90: #S incs #T eq (T = 0 or (EXISTS f in OM | Svm(f) & domain(f) = S & range(f) = T)). Proof:
    Suppose_not(s,t) ==> (#s incs #t & t /= 0 & (not(EXISTS f in OM | Svm(f) & domain(f) = s & range(f) = t))) or 
                ((not (#s incs #t)) & (t = 0 or (EXISTS f in OM | Svm(f) & domain(f) = s & range(f) = t)))
    Suppose ==> (#s incs #t & t /= 0 & Stat1: (not(EXISTS f in OM | Svm(f) & domain(f) = s & range(f) = t)))
    (s,h) --> T71 ==> one_1_map(h) & range(h) = s & domain(h) = #s
    (t,g) --> T71 ==> one_1_map(g) & range(g) = t & domain(g) = #t
    APPLY() fcn_symbol(f(x)->if x in #t then x else 0 end if,g->f,s->#s) ==> 
        Svm(f) & domain(f) = #s & range(f) = {if x in #t then x else 0 end if: x in #s}
    Suppose ==> range(f) /= #t
    Memb(c) ==> (c in {if x in #t then x else 0 end if: x in #s} & c notin #t) or 
              (c notin {if x in #t then x else 0 end if: x in #s} & c in #t)
    Suppose ==> Stat4: c notin {if x in #t then x else 0 end if: x in #s} & c in #t
    c --> Stat4 ==> c /= if c in #t then c else 0 end if or c notin #s
    ELEM ==> false; Discharge ==> Stat5: c in {if x in #t then x else 0 end if: x in #s} and c notin #t
    d --> Stat5 ==> c = if d in #t then d else 0 end if
    Suppose ==> d in #t
    ELEM ==> false; Discharge ==> c = 0 & c notin #t
    (t,any_g) --> T71 ==> Card(#t)
    Use_Def(Card) ==> Ord(#t)
    T84 ==> Ord(0)
    (#t,0) --> T11 ==> #t = 0
    t --> T81 ==> t = 0
    ELEM ==> false; Discharge ==> Svm(f) & domain(f) = #s & range(f) = #t
    h --> T55 ==> one_1_map(inv(h)) & range(inv(h)) = #s & domain(inv(h)) = s
    Use_Def(one_1_map) ==> Svm(h) & Svm(g) & Svm(inv(h))
    (inv(h),f) --> T63 ==> Svm(f @ inv(h))
    (inv(h),f) --> T51a ==> domain(f @ inv(h)) = s & range(f @ inv(h)) = #t
    (g @ (f @ inv(h)),g) --> T63 ==> Svm(g @ (f @ inv(h)))
    (g @ (f @ inv(h)),g) --> T51a ==> domain(g @ (f @ inv(h))) = s & range(g @ (f @ inv(h))) = t
    (g @ (f @ inv(h))) --> Stat1 ==> false 
    Discharge ==> not #s incs #t & (t = 0 or (EXISTS f in OM | Svm(f) & domain(f) = s & range(f) = t))
    ELEM ==> #t /= 0
    t --> T81 ==> t /= 0
    ELEM ==> Stat6: (EXISTS f in OM | Svm(f) & domain(f) = s & range(f) = t)
    hh --> Stat6 ==> Svm(hh) & domain(hh) = s & range(hh) = t
    hh --> T89 ==> #hh = #s
    hh --> T88 ==> #hh incs #t
    ELEM ==> false; Discharge ==> QED

Theorem 91: #S = #T eq (EXISTS f in OM | one_1_map(f) & domain(f) = S & range(f) = T). Proof:
    Suppose_not(s,t) ==> #s = #t & ((not (EXISTS f in OM | one_1_map(f) & domain(f) = s & range(f) = t)) or #s /= #t) 
      & (EXISTS f in OM | one_1_map(f) & domain(f) = s & range(f) = t)
    (s,f) --> T80 ==> Card(#s) & one_1_map(f) & range(f) = s & domain(f) = #s
    (t,g) --> T80 ==> Card(#t) & one_1_map(g) & range(g) = t & domain(g) = #t
    f --> T55 ==> one_1_map(inv(f)) & range(inv(f)) = #s & domain(inv(f)) = s
    (g,inv(f)) --> T65 ==> one_1_map(g @ inv(f))
    (g,inv(f)) --> T51a ==> domain(g @ inv(f)) = s & range(g @ inv(f)) = t
    Suppose ==> #s = #t & Stat0: (not (EXISTS f in OM | one_1_map(f) & domain(f) = s & range(f) = t))
    g * inv(f) --> Stat0 ==> false; Discharge ==> 
      #s /= #t & Stat3: (EXISTS f in OM | one_1_map(f) & domain(f) = s & range(f) = t)
    h --> Stat3 ==> one_1_map(h) & range(h) = t & domain(g) = s
    (f,h) --> T65 ==> one_1_map(h @ f)
    (f,h) --> T51a ==> domain(h @ f) = #s & range(h @ f) = t
    g --> T55 ==> one_1_map(inv(g)) & range(inv(g)) = #t & domain(inv(g)) = t
    (h * f,inv(g)) --> T65 ==> one_1_map(inv(g) @ (h @ f))
    (h * f,inv(g)) --> T51a ==> domain(inv(g) @ (h @ f)) = #s & range(inv(g) @ (h @ f)) = #t
    Loc_def ==> hh := inv(g) @ (h @ f)
    ELEM ==> one_1_map(hh) & domain(hh) = #s & range(hh) = #t
    hh --> T55 ==> one_1_map(inv(hh)) & domain(inv(hh)) = #t & range(inv(hh)) = #s
    Use_Def(Card) ==> Ord(#s) & 
      Stat4: ((FORALL y in #s | (FORALL f in OM | (not(domain(f) = y)) or (not(range(f) = #s)) or (not(Svm(f))))))
    Use_Def(Card) ==> Ord(#t) & 
      Stat5: ((FORALL y in #t | (FORALL f in OM | (not(domain(f) = y) or (not(range(f) = #t)) or (not(Svm(f)))))))
    (#s,#t) --> T11 ==> #s in #t or #t in #s
    Suppose ==> #s in #t
    (#s,hh) --> Stat5 ==> not Svm(hh) 
    Use_Def(one_1_map) ==> #t in #s
    (#t,inv(hh)) --> Stat4 ==> not Svm(inv(hh)) 
    Use_Def(one_1_map) ==> false; Discharge ==> QED

ENTER_THEORY fcn_symbol   [Add an additional results to the fcn_symbol theory]

Theorem: #{[x,f(x)]: x in s} = #s & #{f(x): x in s} incin #s. Proof:
    fcn_symbol.1 ==> domain(g) = s
    fcn_symbol.4 ==> range(g) = {f(x): x in s}
    fcn_symbol.5 ==> Svm(g)
    Use_Def(g) ==> g = {[x,f(x)]: x in s}
    g --> T89 ==> #{[x,f(x)]: x in s} = #s
    g --> T88 ==> QED

ENTER_THEORY set_theory   [Return to the top-level theory]

Theorem 92: Card(S) eq (S = #S). Proof:
    Suppose_not(s) ==> (Card(s) & (not (s = #s))) or ((not Card(s)) & (s = #s))
    s --> T80 ==> Card(#s)
    ELEM ==> Card(s) & s /= #s
    (s,c) --> T82 ==> Stat1: (not(EXISTS f in OM | one_1_map(f) & range(f) = s & domain(f) = s))
    ident(s) --> Stat1 ==> not(one_1_map(ident(s)) & range(ident(s)) = s & domain(ident(s)) = s)
    (s,any_g) --> T58 ==> false; Discharge ==> QED

Theorem 93: #S = ##S. Proof:
    S --> T80 ==> Card(#S) 
    S --> T92 ==> QED

Theorem 94: #S in #T or #S = #T or #T in #S. Proof:
    S --> T80 ==> Card(#S)
    T --> T80 ==> Card(#T)
    Use_Def(Card) ==> Ord(#S) & Ord(#T)
    (S,T) --> T11 ==> QED

Theorem 95: (#S in #T & #T in #R) imp (#S in #R). Proof:
    S --> T80 ==> Card(#S)
    R --> T80 ==> Card(#R)
    Use_Def(Card) ==> Ord(#S) & Ord(#T) & Ord(#R)
    (S,R) --> T11 ==> #S in #R or #S = #R or #R in #S
    ELEM ==> QED
    
Theorem 96: [Associative Law for Cardinals] #((A PROD B) PROD C) = #(A PROD (B PROD C)). Proof:
    Suppose_not(a,b,c) ==> #((a PROD b) PROD c) /= #(a PROD (b PROD c))
    Loc_def ==> f := {[[[x,y],z],[x,[y,z]]]: x in a, y in b, z in b}
    (f,a,b,c) --> T68 ==> one_1_map(f) & domain(f) = ((a PROD b) PROD c) & range(f) = (a PROD (b PROD c))
    f --> T84 ==> #((a PROD b) PROD c) /= #(a PROD (b PROD c))
    ELEM ==> false; Discharge ==> QED
    
Theorem 97: [Commutative Law for Cardinals] #(A PROD B) = #(B PROD A). Proof:
    Suppose_not(a,b) ==> #(a PROD b) /= #(b PROD a)
    Loc_def ==> f := {[[x,y],[y,x]]: x in a, y in b}
    (f,a,b) --> T69 ==> one_1_map(f) & domain(f) = (a PROD b) & range(f) = (b PROD a)
    f --> T84 ==> #(a PROD b) = #(b PROD a)
    ELEM ==> false; Discharge ==> QED

Theorem 98: [A subset of a finite set is finite] (Finite(S) & S incs T) imp Finite(T). Proof:
    Suppose_not(s,t) ==> Finite(s) & s incs t & (not Finite(t))
    Use_Def(Finite) ==> 
      Stat1: (not(EXISTS g | one_1_map(g) & domain(g) = s & range(g) incin s & s /= range(s))) & 
      Stat2: (EXISTS h | one_1_map(h) & domain(h) = t & range(h) incin t & t /= range(t))
    h --> Stat2 ==> one_1_map(h) & domain(h) = t & range(h) incin t & t /= range(t)
    Loc_def ==> f := {[x,x]: x in s - t}
    APPLY() fcn_symbol(f(x)->x,g->f,s->s - t) ==> 
        Svm(f) & range(f) = {x: x in s - t} & domain(f) = s - t & 
          ((FORALL x in s - t | (FORALL y in s - t | ((x = y) imp (x = y)))) imp one_1_map(f))
    SIMPLF ==> range(f) = s - t
    Suppose ==> Stat3: not((FORALL x in s - t | (FORALL y in s - t | ((x = y) imp (x = y))))) 
    (x,y) --> Stat3 ==> false; Discharge ==> one_1_map(f)
    (f,h) --> T52 ==> one_1_map(f + h)
    Set_monot ==> {car(x): x in f + h} = {car(x): x in f} + {car(x): x in h}
    Use_Def(domain) ==> domain(f + h) = domain(f) + domain(h)
    Set_monot ==> {cdr(x): x in f + h} = {cdr(x): x in f} + {cdr(x): x in h}
    Use_Def(range) ==> range(f + h) = range(f) + range(h)
    (f + h) --> Stat1 ==> one_1_map(f + h) & domain(f + h) = s & range(f + h) incin s & s /= range(f + h)
    ELEM ==> false; Discharge ==> QED

Theorem 99: Svm(F) imp (one_1_map(F) eq (FORALL x in domain(F) | (FORALL y in domain(F) | ((F~[x] = F~[y]) imp (x = y))))). Proof:
    Suppose_not(f) ==> Svm(f) & (not(one_1_map(f) eq (FORALL x in domain(f) | (FORALL y in domain(f) | ((f~[x] = f~[y]) imp (x = y))))))
    Use_Def(one_1_map) ==> not((FORALL x in f | (FORALL y in f | ((cdr(x) = cdr(y)) imp (x = y)))) eq 
                (FORALL x in domain(f) | (FORALL y in domain(f) | ((f~[x] = f~[y]) imp (x = y)))))
    f --> T39 ==> f = {[x,f~[x]]: x in domain(f)}
    Suppose ==> Stat1: (FORALL x in f | (FORALL y in f | ((cdr(x) = cdr(y)) imp (x = y)))) &
              Stat2: (not(FORALL x in domain(f) | (FORALL y in domain(f) | ((f~[x] = f~[y]) imp (x = y)))))
    (a,b) --> Stat2 ==> a in domain(f) & b in domain(f) & f~[a] = f~[b] & a /= b
    Suppose ==> Stat3: [a,f~[a]] notin {[x,f~[x]]: x in domain(f)}
    a --> Stat4 ==> false; Discharge ==> Stat4: [a,f~[a]] in f
    LIKEWISE(Stat3-Stat4,a->b) ==> [b,f~[b]] in f
    ([a,f~[a]],[b,f~[b]]) --> Stat1 ==> false; 
    Discharge ==> Stat5: (not(FORALL x in f | (FORALL y in f | ((cdr(x) = cdr(y)) imp (x = y))))) &
              Stat6: (FORALL x in domain(f) | (FORALL y in domain(f) | ((f~[x] = f~[y]) imp (x = y))))
    (c,d) --> Stat5 ==> c in f & d in f & cdr(c) = cdr(d) & c /= d
    ELEM ==> Stat7: c in {[x,f~[x]]: x in domain(f)} & Stat8: d in {[x,f~[x]]: x in domain(f)}
    c2 --> Stat7 ==> c = [c2,f~[c2]] & c2 in domain(f)
    d2 --> Stat8 ==> d = [d2,f~[d2]] & d2 in domain(f)
    (c2,d2) --> Stat6 ==> false; Discharge ==> QED
    
Theorem 100: [A 1-1 map on a set induces a 1-1 map on the power set of its domain]
    (one_1_map(F) & S incin domain(F) & T incin domain(F) & S /= T) imp (range(F ON S) /= range(F ON T)). Proof:
    Suppose_not(f) ==> one_1_map(f) & s incin domain(f) & t incin domain(f) & s /= t & range(f ON s) = range(f ON t)
    Use_Def(one_1_map) ==> Svm(f)
    Memb(c) ==> (c in s and c notin t) or (c notin s and c in t)
    Suppose ==> c in s and c notin t
    Use_Def(range) ==> Stat0: {cdr(x): x in f ON s} = {cdr(x): x in f ON t}
    Use_Def(ON) ==> {cdr(x): x in {x in f | car(x) in s}} = {cdr(x): x in {x in f | car(x) in s}}
    SIMPLF ==> {cdr(x): x in f | car(x) in s} = {cdr(x): x in f | car(x) in t}
    f --> T39 ==> Stat1: f = {[x,f~[x]]: x in domain(f)}
    ELEM ==> {cdr(x): x in {[x,f~[x]]: x in domain(f)} | car(x) in s} = 
                {cdr(x): x in {[x,f~[x]]: x in domain(f)} | car(x) in t}
    SIMPLF ==> {cdr([x,f~[x]]): x in domain(f) & car([x,f~[x]]) in s} = 
            {cdr([x,f~[x]]): x in domain(f) & car([x,f~[x]]) in t}
    ELEM ==> cdr([X,f~[X]]) = f~[X] & cdr([X,f~[X]]) = X
    EQUAL ==> {f~[x]: x in domain(f) & x in s} = {f~[x]: x in domain(f) & x in t}
    Suppose ==> Stat1: f~[c] notin {f~[x]: x in domain(f) & x in s}
    c --> Stat1 ==> false; Discharge ==> Stat2: f~[c] in {f~[x]: x in domain(f) & x in t}
    d --> Stat2 ==> f~[c] = f~[d] & d in domain(f) & d in t
    ELEM ==> c /= d
    f --> T99 ==> Stat3: (FORALL x in domain(f) | (FORALL y in domain(f) | ((f~[x] = f~[y]) imp (x = y))))
    (c,d) --> Stat3 ==> false; Discharge ==> c notin s & c in t
    LIKEWISE(Stat0-Stat2,s->t,t->s) ==> false; Discharge ==> QED

Theorem 101: [Map product formula] (Svm(F) & Svm(G) & range(F) incin domain(G)) imp 
    (G @ F = {[x,G~[F~[x]]]: x in domain(F)} & domain(G @ F) = domain(F) & range(G @ F) = {G~[F~[x]]: x in domain(F)}). Proof:
		Suppose_not(f,g) ==> Svm(f) & Svm(g) & range(f) incin domain(g) &
      (not(g @ f = {[x,g~[f~[x]]]: x in domain(f)} & domain(g @ f) = domain(f) & range(g @ f) = {g~[f~[x]]: x in domain(f)}))
    (g,f) --> T63 ==> Svm(g @ f)
    (g,f) --> T64a ==> domain(g @ f) = domain(f)
    ELEM ==> not(g @ f = {[x,g~[f~[x]]]: x in domain(f)} & range(g @ f) = {g~[f~[x]]: x in domain(f)})
    (g @ f) --> T39 ==> g @ f = {[x,(g @ f)~[x]]: x in domain(f)}
    (g,f,x) --> T64 ==> (X in domain(f)) imp ((g @ f)~[X] = g~[f~[X]])
    ELEM ==> (FORALL x in domain(f) | (g @ f)~[x] = g~[f~[x]])
    EQUAL ==> g @ f = {[x,g~[f~[x]]]: x in domain(f)}
    ELEM ==> range({[x,g~[f~[x]]]: x in domain(f)}) /= {g~[f~[x]]: x in domain(f)}
    Use_Def(range) ==> {cdr(x): x in {[x,g~[f~[x]]]: x in domain(f)}} /= {g~[f~[x]]: x in domain(f)}
    SIMPLF ==> {cdr([x,g~[f~[x]]]): x in domain(f)} /= {g~[f~[x]]: x in domain(f)}
    ELEM ==> cdr([X,g~[f~[X]]]) = X
    EQUAL ==> false; Discharge ==> QED
    
Theorem 102: one_1_map(F) imp ((Finite(domain(F))) imp (Finite(range(F)))). Proof:
    Suppose_not(f) ==> one_1_map(f) & Finite(domain(f)) & (not Finite(range(f)))
    Use_Def(Finite) ==> 
      Stat0: (not(EXISTS g | one_1_map(g) & domain(g) = range(f) & range(g) incin range(f) & range(g) /= range(f)))
      Stat1: (EXISTS g | one_1_map(g) & domain(g) = range(f) & range(g) incin range(f) & range(g) /= range(f))
    g --> Stat1 ==> one_1_map(g) & domain(g) = range(f) & range(g) incin range(f) & range(g) /= range(f)
    f --> T55 ==> one_1_map(inv(f)) & domain(f) = range(inv(f)) & range(f) = domain(inv(f))
    Use_Def(one_1_map) ==> Svm(f) & Svm(g) & Svm(inv(f)) 
    (g,f) --> T65 ==> one_1_map(g @ f)
    (inv(f),g @ f)-->T65 ==> one_1_map(inv(f) @ (g @ f))
    (f,g) --> T51a ==> domain(g @ f) = domain(f) & range(g @ f) = range(g)
    (inv(f),g @ f) --> T55 ==> domain(inv(f) @ (g @ f)) = domain(f) & range(inv(f) @ (g @ f)) incin domain(f)
    (inv(f),g @ f) --> T51a ==> range(inv(f) @ (g @ f)) = range(inv(f) ON range(g))
    (inv(f),range(g),domain(inv(f))) --> T51a ==> range(inv(f) ON domain(inv(f))) /= range(inv(f) ON range(g))
    (inv(f),g) --> T51 ==> range(inv(f)) /= range(inv(f) ON range(g))
    ELEM ==> range(inv(f) @ (g @ f)) /= domain(f)
    (inv(f) @ (g @ f)) --> Stat0 ==> false; Discharge ==> QED
    
Theorem 103: one_1_map(F) imp (Finite(domain(F)) eq Finite(range(F))). Proof:
    Suppose_not(f) ==> one_1_map(f) & (not(Finite(domain(f)) eq Finite(range(f))))
    f --> T102 ==> Finite(domain(f)) imp Finite(range(f))
    f --> T55 ==> one_1_map(inv(f)) & domain(inv(f)) = range(f) & range(inv(f)) = domain(f)
    (inv(f)) --> T102 ==> Finite(range(f)) imp Finite(domain(f))
    ELEM ==> false; Discharge ==> c notin s and c in t

Theorem 104: [A single_valued map with finite domain has a finite range] 
        (Svm(F) & Finite(domain(F))) imp Finite(range(F)). Proof:
    Suppose_not(f) ==> Svm(f) & Finite(domain(f)) & (not Finite(range(f)))
    (f,invm) --> T79 ==> domain(invm) = range(f) & range(invm) incin domain(f) & one_1_map(invm)
    invm --> T103 ==> not Finite(range(invm))
    (f) --> T103 ==> not Finite(domain(f))
    ELEM ==> false; Discharge ==> QED
    
Theorem 105: Finite(S) eq Finite(#S). Proof: 
    Suppose_not(s) ==> not(Finite(s) eq Finite(#s))
    (s,f) --> T80 ==> one_1_map(f) & domain(f) = s & range(f) = #s
    Use_Def(one_1_map) ==> Svm(f)
    f --> T104 ==> Finite(s) imp Finite(#s)
    f --> T55 ==> one_1_map(inv(f)) & range(inv(f)) = #s & domain(inv(f)) = s
    Use_Def(one_1_map) ==> Svm(inv(f))
    f --> T104 ==> Finite(#s) imp Finite(s)
    ELEM ==> false; Discharge ==> QED

Theorem 106: [Proper subsets of a finite set have fewer elements] (Finite(S) & T incin S & T /= S) imp (#T in #S). Proof:
    Suppose_not(s,t) ==> Finite(s) & t incin s & t /= s & #t notin #s
    (t,f) --> T80 ==> Card(#t) & one_1_map(f) & range(f) = t & domain(f) = #t
    (s,g) --> T80 ==> Card(#s) & one_1_map(inv(g)) & domain(inv(g)) = s & range(inv(g)) = #s
    Use_Def(Card) ==> Ord(#t) & Ord(#s)
    THUS ==> #t = #s
    (f,inv(g)) --> T51a ==> domain(f @ inv(g)) = s & range(f @ inv(g)) = t
    (f,inv(g)) --> T65 ==> one_1_map(f @ inv(g))
    Use_Def(Finite) ==> Stat1: not (EXISTS f in OM | one_1_map(f) & domain(f) = s & range(f) incin s & range(f) /= s)
    (f @ inv(g)) --> Stat1 ==> false; Discharge ==> QED

Theorem 107: Finite(S) eq (not(EXISTS f in OM | Svm(f) & range(f) = S & domain(f) incin S & S /= domain(f))). Proof:
    Suppose_not(s) ==> not(Finite(s) eq (not(EXISTS f in OM | Svm(f) & range(f) = s & domain(f) incin s & s /= domain(f))))
    Suppose ==> Finite(s) & Stat1: (EXISTS f in OM | Svm(f) & range(f) = s & domain(f) incin s & s /= domain(f))
    f --> Stat1 ==> Svm(f) & range(f) = s & domain(f) incin s & s /= domain(f)
    (f,h) --> T79 ==> domain(h) = s & range(f) incin s & s /= range(f) & one_1_map(h)
    Use_Def(Finite) ==> Stat3: not(EXISTS h | one_1_map(h) & domain(h) = s & range(f) incin s & range(f) /= s)
    h --> Stat3 ==> false 
    Discharge ==> (not Finite(s)) & Stat4: (not(EXISTS f in OM | Svm(f) & range(f) = s & domain(f) incin s & s /= domain(f)))
    Use_Def(Finite) ==> Stat5: (EXISTS f in OM | one_1_map(f) & domain(f) = s & range(f) incin s & s /= range(f))
    g --> Stat5 ==> one_1_map(g) & domain(g) = s & range(g) incin s & s /= range(g)
    g --> T55 ==> one_1_map(g) & range(inv(g)) = s & domain(inv(g)) incin s & s /= domain(inv(g))
    Use_Def(one_1_map) ==> Svm(g)
    g --> Stat3 ==> false; Discharge ==> QED

Theorem 108: (Ord(S) & Finite(S) & T in S) imp Finite(T). Proof:
    Suppose_not(s,t) ==> Ord(s) & Finite(s) & t in s & (not Finite(t))
    THUS ==> t incin s
    (s,t) --> T98 ==> false; Discharge ==> QED

Theorem 109: [Any infinite ordinal is larger than any finite ordinal]
            (Ord(S) & Ord(T) & (not Finite(S)) & Finite(T)) imp (T in S). Proof:
    Suppose_not(s,t) ==> Ord(s) & Ord(t) & (not Finite(s)) & Finite(t) & (not(t in s))
    (s,t) --> T11 ==> s in t or t in s or s = t
    ELEM ==> s in t
    THUS ==> s incin t
    T98 ==> false; Discharge ==> QED

Theorem 110: [Interchange Lemma] 
    (X in S & Y in S) imp (EXISTS f in OM | (one_1_map(f) & range(f) = S & domain(f) = S & f~[X] = Y & f~[Y] = X)). Proof:
    Suppose_not(a,b,s) ==> 
      a in s & b in s & Stat1: (not(EXISTS f in OM | one_1_map(f) & range(f) = s & domain(f) = s & f~[a] = b & f~[b] = a))
    APPLY() fcn_symbol(f(x)->if x = a then b elseif x = b then a else x end if,g -->f,s --> S) ==> 
      Svm(f) & range(f) = {if x = a then b elseif x = b then a else x end if: x in s} & domain(f) = s &
          (FORALL x in s | f~[x] = if x = a then b elseif x = b then a else x end if) &
          ((FORALL x in s | (FORALL y in s | ((if x = a then b elseif x = b then a else x end if = 
                  if x = a then b elseif x = b then a else x end if) imp (x = y))))) imp one_1_map(f)
    Suppose ==> s /= {if x = a then b elseif x = b then a else x end if: x in s}
    Memb(c) ==> (c in s & c notin {if x = a then b elseif x = b then a else x end if: x in s}) or
            (c notin s & c in {if x = a then b elseif x = b then a else x end if: x in s}) 
    Suppose ==> c in s & Stat1: c notin {if x = a then b elseif x = b then a else x end if: x in s}
    if c = a then b elseif c = b then a else c end if --> Stat1 ==> 
            not(if c = a then b elseif c = b then a else c end if in s)
    ELEM ==> false; Discharge ==> c notin s & Stat2: c in {if x = a then b elseif x = b then a else x end if: x in s}
    d --> Stat2 ==> c = if d = a then b elseif d = b then a else d end if & d in s
    ELEM ==> false; Discharge ==> QED

Theorem 111: Svm(F) imp (F ON S = {[x,F~[x]]: x in domain(f) | x in S} & domain(F ON S) = {x in domain(F) | x in S} &
              range(F ON S) = {F~[x]: x in domain(f) | x in S}). Proof: 
    Suppose_not(f,s) ==> 
      Svm(f) & f ON s /= {[x,f~[x]]: x in domain(f) | x in s} & domain(f ON s) /= {x in domain(f) | x in s} &
          range(f ON s) /= {f~[x]: x in domain(f) | x in s}
    Suppose ==> f ON s /= {[x,f~[x]]: x in domain(f) | x in s}
    f --> T39 ==> f = {[x,f~[x]]: x in domain(f)}
    Use_Def(ON) ==> f ON s = {x: x in f | car(x) in s}
    ELEM ==> f ON s = {x: x in {[x,f~[x]]: x in domain(f)} | car(x) in s}
    SIMPLF ==> f ON s = {[x,f~[x]]: x in domain(f) | car([x,f~[x]]) in s}
    ELEM ==> car([X,f~[X]]) = X
    EQUAL ==> false; Discharge ==> f ON s = {[x,f~[x]]: x in domain(f) | x in s}
    Use_Def(range) ==> range(f ON s) = {cdr(x): x in (f ON s)}
    ELEM ==> range(f ON s) = {cdr(x): x in {[x,f~[x]]: x in domain(f) | x in s}}
    SIMPLF ==> range(f ON s) = {cdr([x,f~[x]]): x in domain(f) | x in s}
    ELEM ==> cdr([X,f~[X]]) = f~[X]
    EQUAL ==> range(f ON s) = {f~[x]: x in domain(f) | x in s}
    Use_Def(domain) ==> domain(f ON s) = {car(x): x in (f ON s)}
    ELEM ==> domain(f ON s) = {car(x): x in {[x,f~[x]]: x in domain(f) | x in s}}
    SIMPLF ==> range(f ON s) = {car([x,f~[x]]): x in domain(f) | x in s}
    EQUAL ==> false; Discharge ==> QED

Theorem 112: (one_1_map(F) & X in domain(F) & Y in domain(F) & F~[X] = F~[Y]) imp (X = Y). Proof: 
    Suppose_not(f,x,y) ==> one_1_map(f) & x in domain(f) & y in domain(f) & f~[x] = f~[y] & x /= y
    Use_Def(one_1_map) ==> Svm(f) & Stat1: (FORALL x in f | (FORALL y in f | ((cdr(x) = cdr(y)) imp (x = y))))
    f --> T39 ==> f = {[x,f~[x]]: x in domain(f)}
    Suppose ==> Stat2: [x,f~[x]] notin {[x,f~[x]]: x in domain(f)}
    x --> Stat2 ==> false; Discharge ==> [x,f~[x]] in f
    Suppose ==> Stat3: [y,f~[y]] notin {[x,f~[x]]: x in domain(f)}
    y --> Stat3 ==> false; Discharge ==> [y,f~[y]] in f
    ([x,f~[x]],[y,f~[y]]) --> Stat1 ==> (cdr([x,f~[x]]) = cdr([y,f~[y]])) imp (x = y)
    ELEM ==> false; Discharge ==> QED
    
Theorem 113: Finite(S) eq Finite(S + {X}). Proof: 
    Suppose_not(s,a) ==> (Finite(s) & (not Finite(s + {a}))) or ((not Finite(s)) & Finite(s + {a}))
    Suppose ==> (not Finite(s)) & Finite(s + {a})
    ELEM ==> s + {a} incs s
    (s + {a},s) --> T98 ==>false; Discharge ==> Finite(s) & (not Finite(s + {a}))
    Use_Def(Finite) ==> 
      Stat1: (EXISTS f in OM | one_1_map(f) & domain(f) = s + {a} & range(f) incin s + {a} & s + {a} /= range(f)) &
      Stat11: (not(EXISTS f in OM | one_1_map(f) & domain(f) = s & range(f) incin s & s /= range(f)))
    g --> Stat1 ==> one_1_map(g) & domain(g) = s + {a} & range(g) incin s + {a} & s + {a} /= range(g)
    Memb(c) ==> c in s + {a} & c notin range(g)
    ELEM ==> a notin s & a in domain(g) & c in domain(g) & c notin range(g)
    (a,c,domain(g),f) --> T110 ==> one_1_map(f) & range(f) = domain(g) & domain(f) = domain(g) & f~[a] = c & f~[c] = a
    (f,g) --> T51a ==> range(f @ g) = range(f ON range(g)) & domain(f @ g) = domain(g) & domain(f @ g) = s + {a}
    (f,range(g)) --> T50 ==> range(f ON range(g)) incin range(f)
    ELEM ==> range(f ON range(g)) incin s + {a}
    Elem_Props ==> Svm(f)
    Suppose ==> a in range(f ON range(g))
    (f,range(g)) --> T111 ==> Stat0: a in {f~[x]: x in domain(f) | x in range(g)}
    e --> Stat0 ==> a = f~[e] & e in domain(f) & e in range(g)
    (a,f) --> T56 ==> Inv(f)~[f~[c]] = c
    (e,f) --> T56 ==> Inv(f)~[f~[e]] = e
    ELEM ==> c = e & c in range(g)
    ELEM ==> false; Discharge ==> a notin range(f ON range(g))
    ELEM ==> range(f @ g) incin s
    (f,g) --> T65 ==> one_1_map(f @ g)
    Use_Def(one_1_map) ==> Svm(f @ g) & Svm(g)
    (f,g) --> T64a ==> f @ g = {[x,f~[g~[x]]]: x in domain(g)} & range(f @ g) = {f~[g~[x]]: x in domain(g)}
    g --> T39a ==> range(g) = {g~[x]: x in domain(g)}
    Suppose ==> Stat3: a in {f~[g~[x]]: x in domain(g)}
    b --> Stat3 ==> f~[c] = f~[g~[b]] & b in domain(g)
    Suppose ==> Stat4: g~[b] notin {g~[x]: x in domain(g)}
    b --> Stat3 ==> false; Discharge ==> g~[b] in range(g)
    f --> T99 ==> Stat5: (FORALL x in domain(f) | (FORALL y in domain(f) | ((f~[x] = f~[y]) imp (x = y))))
    (c,g~[b]) --> Stat5 ==> c = g~[b]
    ELEM ==> false; Discharge ==> a notin range(f @ g)
    ELEM ==> range(f @ g) incin s
    Suppose ==> Stat6: (f @ g)~[a] notin {f~[g~[x]]: x in domain(g)}
    a --> Stat6 ==> (f @ g)~[a] /= f~[g~[a]]
    (f,g,a) --> T64 ==> false; Discharge ==> (f @ g)~[a] in range(f @ g)
    Suppose ==> (f @ g)~[a] in range((f @ g) ON s)
    ELEM ==> Stat6: (f @ g)~[a] in {(f @ g)~[x]: x in domain(f @ g) | x in s}
    d --> Stat6 ==> (f @ g)~[a] = (f @ g)~[d] & d in domain(f @ g) & d in s
    (a,f @ g) --> T56 ==> Inv(f @ g)~[(f @ g)~[a]] = a
    (d,f @ g) --> T56 ==> Inv(f @ g)~[(f @ g)~[d]] = d
    ELEM ==> false; 
    Discharge ==> (f @ g)~[a] notin range((f @ g) ON s) & (f @ g)~[a] in range(f @ g) & range(f @ g) incin s
    ELEM ==> range((f @ g) ON s) /= s 
    (f @ g,s) --> T49 ==> one_1_map((f @ g) ON s)
    (f @ g,s) --> Stat11 ==> false; Discharge ==> QED
    
Theorem 114: Finite(S) imp Finite(next(S)). Proof: 
    Use_Def(next) ==> next(S) = S + {S}
    (S,S) --> T113 ==> QED

Theorem 115: not(Finite(s_inf)). Proof:
    Loc_def ==> g := {[x,{x}]: x in s_inf}
    APPLY() fcn_symbol(f(x)->{x},g->g,s->s_inf) ==> Svm(g) & range(g) = {{x}: x in s_inf}
    Suppose ==> not (range(g) incin s_inf)
    Memb(c) ==> Stat1: c in {{x}: x in s_inf} & (not c in s_inf)
    d --> Stat1 ==> d in s_inf & c = {d} & (not c in s_inf)
    Ax_infinity ==> Stat2: (FORALL x in s_inf | {x} in s_inf)
    d --> Stat2 ==> (d in s_inf) imp ({d} in s_inf)
    ELEM ==> false; Discharge ==> range(g) incin s_inf
    Ax_infinity ==> s_inf /= 0
    s_inf --> Ax_ch ==> arb(s_inf) in s_inf & arb(s_inf) * s_inf = 0
    Suppose ==> range(g) = s_inf
    ELEM ==> Stat2: arb(s_inf) in {{x}: x in s_inf}
    e --> Stat2 ==> e in s_inf & arb(s_inf) = {e}
    ELEM ==> false; Discharge ==> range(g) /= s_inf
    Use_Def(finite) ==> QED

Theorem 116: [Infinite cardinality theorem] not Finite(#s_inf). Proof:
    s_inf --> T105 ==> Finite(#s_inf) eq Finite(s_inf)
    Ax_infinity ==> not(Finite(s_inf))
    ELEM ==> QED

Theorem 117: [All finite ordinals are cardinals] (Ord(X) & Finite(X)) imp Card(X). Proof: 
    Suppose_not(x) ==> Ord(x) & Finite(x) & (not Card(x))
    Use_Def(Card) ==> 
      Stat1: (not(FORALL y in x | (FORALL f in OM | not(domain(f) = y))) or (not(range(f) = s)) or (not(Svm(f))))
    (y,f) --> Stat1 ==> domain(f) = y & y in x & range(f) = x & Svm(f)
    THUS ==> Ord(y) & y incin x
    ELEM ==> y /= x
    f --> T79 ==> domain(h) = range(f) & range(h) incin domain(f) & one_1_map(h)
    Use_Def(Finite) ==> 
      Stat3: not(EXISTS p | one_1_map(p) & domain(p) = x & range(p) incin x & x /= range(p))
    h --> Stat3 ==> not(one_1_map(h) & domain(h) = x & range(h) incin x & x /= range(h))
    ELEM ==> false; Discharge ==> QED
    
Def 18a: [The set of integers] Z := arb({x in next(#s_inf) | not Finite(x)})

Theorem 118: Ord(Z) & (not Finite(Z)) & (FORALL x in OM | (Card(x) & Finite(x)) eq x in Z). Proof:
    Suppose_not ==> (not Ord(Z)) or Finite(Z) or (not (FORALL x in OM | (Card(x) & Finite(x)) eq x in Z))
    T116 ==> not Finite(#s_inf)
    s_inf --> T117 ==> Card(#s_inf)
    Use_Def(Card) ==> Ord(#s_inf)
    Suppose ==> #s_inf notin next(#s_inf)
    Use_Def(next) ==> #s_inf notin #s_inf + {#s_inf}
    ELEM ==> false; Discharge ==> #s_inf in next(#s_inf)
    Suppose ==> {x in next(#s_inf) | not Finite(x)} = 0
    ELEM ==> #s_inf notin {x in next(#s_inf) | not Finite(x)}
    SIMPLF ==> not(#s_inf in next(#s_inf)) or Finite(#s_inf)
    ELEM ==> false; Discharge ==> Stat1: {x in next(#s_inf) | not Finite(x)} /= 0
    {x in next(#s_inf) | not Finite(x)} --> Ax_ch ==> 
      arb({x in next(#s_inf) | not Finite(x)}) in {x in next(#s_inf) | not Finite(x)}
    Use_Def(Z) ==> Z in {x in next(#s_inf) | not Finite(x)}
    SIMPLF ==> Z in next(#s_inf) & (not Finite(Z))
    #s_inf --> T15 ==> Ord(next(#s_inf))
    (Z,#s_inf) --> T12 ==> Ord(Z)
    ELEM ==> Stat1: not(FORALL x in OM | (Card(x) & Finite(x)) eq x in Z)
    x --> Stat1 ==> not(Card(x) & Finite(x) eq x in Z)
    ELEM ==> (Card(x) & Finite(x) & (not x in Z)) or (((not Card(x)) or (not Finite(x))) & x in Z)
    Suppose ==> Card(x) & Finite(x) & (not x in Z)
    Use_Def(Card) ==> Ord(x) & Finite(x) & (not x in Z)
    (x,z) --> T109 ==> ((Ord(x) & Ord(Z) & (not Finite(Z)) & Finite(x))) imp (x in Z)
    ELEM ==> false; Discharge ==> ((not Card(x)) or (not Finite(x))) & x in Z
    Suppose ==> not Finite(x)
    (Z,next(#s_inf)) --> T16 ==> x in next(#s_inf) & (not Finite(x))
    SIMPLF ==> x in {y: y in next(#s_inf) | not Finite(y)}
    ELEM ==> Z * {y: y in next(#s_inf) | not Finite(y)} /= 0
    Use_Def(Z) ==> arb({x in next(#s_inf) | not Finite(x)}) notin {x in next(#s_inf) | not Finite(x)}
    {x in next(#s_inf) | not Finite(x)} --> Ax_ch ==> {x in next(#s_inf) | not Finite(x)}
    ELEM ==> false; Discharge ==> not Card(x)
    x --> T117 ==> (Ord(x) & Finite(x)) imp Card(x)
    ELEM ==> false; Discharge ==> QED

Def 18b: [Standard definitions of the finite integers, 1 = next(0) & 2 = next(1) & 3 = next(2) & ...  ] one := next(0)  

Theorem 119: Ord(0) & 0 in Z & 1 in Z & 2 in Z & 3 in Z. Proof:
    T86 ==> Finite(0) & Card(0)
    0 --> T118 ==> 0 in Z
    Use_Def(1) ==> 1 = next(0)
    0 --> T15 ==> Ord(1)
    0 --> T114 ==> Finite(1)
    1 --> T117 ==> Card(1)
    1 --> T118 ==> 1 in Z
    Use_Def(2) ==> 2 = next(1)
    1 --> T15 ==> Ord(2)
    1 --> T114 ==> Finite(2)
    2 --> T117 ==> Card(2)
    2 --> T118 ==> 2 in Z
    Use_Def(3) ==> 3 = next(2)
    2 --> T15 ==> Ord(3)
    2 --> T114 ==> Finite(3)
    3 --> T117 ==> Card(3)
    3 --> T118 ==> 3 in Z
    ELEM ==> QED

Theorem 120: [The set of integers is a Cardinal] Card(Z). Proof:
    Suppose_not ==> not Card(Z)
    Use_Def(Card) ==> (not Ord(Z)) or 
      not(FORALL y in Z | (FORALL f in OM | (not(domain(f) = y)) or (not(range(f) = Z)) or (not(Svm(f)))))
    T118 ==> Ord(Z) & (not Finite(Z)) & Stat0: (FORALL x | (Card(x) & Finite(x)) eq x in Z)
    ELEM ==> 
      Stat1: not(FORALL y in Z | (FORALL f in OM | (not(domain(f) = y)) or (not(range(f) = Z)) or (not(Svm(f)))))
    (y,f) --> Stat1 ==> y in Z & domain(f) = y & range(f) = Z & Svm(f)
    y --> Stat0 ==> Finite(y)
    f --> T104 ==> Finite(Z)
    ELEM ==> false; Discharge ==> QED

Theorem 121: 0 in Z & 1 in Z & 2 in Z & 3 in Z & 1 /= 0 & 2 /= 0 & 3 /= 0 & 1 /= 2 & 1 /= 3 & 2 /= 3. Proof:
    T119 ==> 0 in Z & 1 in Z & 2 in Z & 3 in Z
    Use_Def(1) ==> 1 = next(0)
    Use_Def(2) ==> 2 = next(1)
    Use_Def(3) ==> 3 = next(3)
    Use_Def(next) ==> 0 in 1 & 1 in 2 & 2 in 3
    ELEM ==> QED 
     
Def 19: [Cardinal sum] Def(n PLUS m) := #({[x,0]: x in n} + {[x,1]: x in m})
Def 20: [Cardinal product] Def(N TIMES M) := #(N PROD M)
Def 21: pow(s) := {x: x incin s}
Def 22: [Cardinal Difference] Def(N MINUS M) := #(N - M)

Def 25: [Union Set] Un(S) := {x: x in y, y in S}

Def 23: [Integer Quotient; Note that x/0 = Z for x in Z] Def(M OVER N) := Un({k in Z | k TIMES N incin M})
Def 24: [Integer Remainder] Def(M MOD N) := M MINUS ((M OVER N) TIMES N)

Theorem 122: {[x,0]: x in N} * {[x,1]: x in M} = 0. Proof:
    Suppose_not ==> {[x,0]: x in n} * {[x,1]: x in m} /= 0
    Memb(e) ==> Stat1: e in {[x,0]: x in n} & e in {[x,0]: x in n}
    (x,y) --> Stat1 ==> e = [x,0] & e = [y,1]
    ELEM ==> false; Discharge ==> QED

Theorem 123: is_map(0) & Svm(0) & one_1_map(0) & range(0) = 0 & domain(0) = 0. Proof:
    Suppose ==> not is_map(0)
    Use_Def(is_map) ==> Stat1: not (0 = {[car(x),cdr(x)]: x in 0})
    a --> Stat1 ==> false; Discharge ==> is_map(0)
    Suppose ==> not Svm(0)
    Use_Def(Svm) ==> Stat2: not(FORALL x in 0 | (FORALL y in 0 | ((car(x) = car(y)) imp (x = y))))
    b --> Stat2 ==> false; Discharge ==> Svm(0)
    Suppose ==> not one_1_map(0)
    Use_Def(one_1_map ) ==> Stat3: not(FORALL x in 0 | (FORALL y in 0 | ((cdr(x) = cdr(y)) imp (x = y))))
    c --> Stat3 ==> false; Discharge ==> Svm(0)
    Suppose ==> range(0) /= 0
    Use_Def(range) ==> {cdr(x): x in 0} /= 0
    Memb(d) ==> false; Discharge ==> range(0) = 0
    Suppose ==> domain(0) /= 0
    Use_Def(range) ==> {car(x): x in 0} /= 0
    Memb(e) ==> false; Discharge ==> QED

Theorem 124: Svm({[X,Y]}) & one_1_map({[X,Y]}) & {[X,Y]}~[X] = Y. Proof: 
    Suppose_not(x,y) ==> not(Svm({[x,y]}) & one_1_map({[x,y]}) & {[x,y]}~[x] = y)
    Suppose ==> not Svm({[x,y]})
    Use_Def(Svm) ==> Stat1: (EXISTS u in {[x,y]} | (EXISTS v in {[x,y]} | car(u) = car(v) & u /= v))
    (a,b) --> Stat1 ==> a = [x,y] & b = [x,y] & car(a) = car(b) & a /= b
    ELEM ==> false; Discharge ==> Svm({[x,y]})
    Suppose ==> not one_1_map({[x,y]})
    Use_Def(Svm) ==> Stat2: (EXISTS u in {[x,y]} | (EXISTS v in {[x,y]} | cdr(u) = cdr(v) & u /= v))
    (c,d) --> Stat1 ==> c = [x,y] & d = [x,y] & cdr(c) = cdr(d) & c /= d
    ELEM ==> false; Discharge ==> {[x,y]}~[x] /= y
    Use_Def([]) ==> {[x,y]}~[x] = arb(range({[x,y]} ON {x}))
    Use_Def(range) ==> {[x,y]}~[x] = arb({cdr(u): u in ({[x,y]} ON {x})})
    Use_Def(ON) ==> {[x,y]}~[x] = arb({cdr(u): u in {v: v in {[x,y]} | car(v) in {x}}})
    SIMPLF ==> {[x,y]}~[x] = arb({cdr(u): u in {[x,y]} | car(u) in {x}})
    SIMPLF ==> {[x,y]}~[x] = arb(if car([x,y]) in {x} then {cdr([x,y])} else 0 end if)
    ELEM ==> car([x,y]) in {x} & {cdr([x,y])} = {y}
    ELEM ==> {[x,y]}~[x] = arb({y})
    ELEM ==> false; Discharge ==> QED

Theorem 125: (X /= Z) imp ({[X,Y],[Z,W]}~[X] = Y). Proof: 
    Suppose_not(x,y) ==> x /= z & {[x,y],[z,w]}~[x] /= y
    Use_Def([]) ==> {[x,y],[z,w]}~[x] = arb(range({[x,y],[z,w]} ON {x}))
    Use_Def(range) ==> {[x,y],[z,w]}~[x] = arb({cdr(u): u in ({[x,y],[z,w]} ON {x})})
    Use_Def(ON) ==> {[x,y],[z,w]}~[x] = arb({cdr(u): u in {v in {[x,y],[z,w]} | car(v) in {x}}})
    SIMPLF ==> {[x,y],[z,w]}~[x] = arb({cdr(u): u in {[x,y],[z,w]} | car(u) in {x}})
    Set_monot ==> 
      {[x,y],[z,w]}~[x] = arb({cdr(u): u in {[x,y]} | car(u) in {x}} + {cdr(u): u in {[z,w]} | car(u) in {x}})
    SIMPLF ==> {[x,y],[z,w]}~[x] = arb(if car([x,y]) in {x} then {cdr([x,y])} else 0 end if + 
                      if car([z,w]) in {x} then {cdr([z,w])} else 0 end if)
    ELEM ==> car([x,y]) in {x} & cdr([x,y]) = y & car([z,w]) notin {x}
    ELEM ==> {[x,y],[z,w]}~[x] = arb({y} + 0)
    ELEM ==> QED

Theorem 126: #{[x,0]: x in M} = #M & #{[x,1]: x in N} = #N. Proof:
    Suppose_not(n,m) ==> #{[x,0]: x in n} /= #n or #{[x,1]: x in m} /= #m
    APPLY(f) fcn_symbol(f(x)->[x,0],s->n) ==> #{[x,0]: x in n} = #n
    APPLY(g) fcn_symbol(f(x)->[x,1],s->n) ==> #{[x,1]: x in n} = #n
    ELEM ==> false; Discharge ==> QED

Theorem 127: N PLUS M = #N PLUS #M. Proof: 
    Suppose_not(n,m) ==> n PLUS m /= #n PLUS #m
    Use_Def(PLUS) ==> #({[x,0]: x in n} + {[x,1]: x in m}) /= #({[x,0]: x in #n} + {[x,1]: x in #m})
    (n,f) --> T80 ==> one_1_map(f) & domain(f) = #n & range(f) = n
    (m,g) --> T80 ==> one_1_map(g) & domain(g) = #m & range(g) = m
    Use_Def(one_1_map) ==> Svm(f) & Svm(g)
    f --> T39 ==> f = {[x,f~[x]]: x in domain(f)}
    g --> T39 ==> g = {[x,f~[x]]: x in domain(g)}
    APPLY() fcn_symbol(f(x)->if cdr(x) = 1 then [f~[car(x)],0] else [g~[car(x)],1] end if,g->h, s->({[x,0]: x in #n} + {[x,1]: x in #m})) ==> 
      Svm(h) & range(h) = 
        {if cdr(x) = 1 then [f~[car(x)],0] else [g~[car(x)],1] end if: x in {[x,0]: x in #n} + {[x,1]: x in #m}} & 
          domain(h) = {x: x in {[x,0]: x in #n} + {[x,1]: x in #m}} &
          (FORALL x in domain(h) | h~[x] = if cdr(x) = 1 then [f~[car(x)],0] else [g~[car(x)],1] end if) &
          (FORALL x in domain(h) | (FORALL y in domain(h) | 
            ((if cdr(x) = 1 then [f~[car(x)],0] else [g~[car(x)],1] end if) = 
                (if cdr(y) = 1 then [f~[car(y)],0] else [g~[car(y)],1] end if) imp (x = y))) imp one_1_map(h))
    Set_monot ==>
       range(h) = {if cdr(x) = 1 then [f~[car(x)],0] else [g~[car(x)],1] end if: x in {[x,0]: x in #n}} + 
              {if cdr(x) = 1 then [f~[car(x)],0] else [g~[car(x)],1] end if: {[x,1]: x in #m}}
    SIMPLF ==> range(h) = {if cdr([x,0]) = 1 then [f~[car([x,0])],0] else [g~[car([x,0])],1] end if: x in #n}
            + {if cdr([x,1]) = 1 then [f~[car([x,1])],0] else [g~[car([x,1])],1] end if: x in #m}
    ELEM ==> cdr([X,0]) = 0 & car([X,1]) = X & cdr([X,1]) = 1 & car([X,1]) = X
    EQUAL ==> range(h) = {[f~[x],0]: x in #n} + {if 1 = 0 then [f~[x],1] else [g~[x],1] end if: x in #m}
    T121 ==> 0 /= 1
    ELEM ==> if 0 /= 1 then [f~[X],1] else [g~[X],1] end if = [g~[X],1]
    EQUAL ==> range(h) = {[f~[x],0]: x in #n} + {[g~[x],1]: x in #m}
    SIMPLF ==> 
      {[f~[x],0]: x in #n} + {[g~[x],1]: x in #m} = {[x,0]: x in {f~[x]: x in #n}} + {[x,0]: x in {g~[x]: x in #m}}
    f --> T39a ==> range(f) = {f~[x]: x in #n}
    g --> T39a ==> range(g) = {g~[x]: x in #m}
    ELEM ==> range(h) = {[x,0]: x in n} + {[x,1]: x in m}
    Suppose ==> Stat3: not((FORALL x in domain(h) | (FORALL y in domain(h) |
            ((if cdr(x) = 1 then [f~[car(x)],0] else [g~[car(x)],1] end if = 
                if cdr(x) = 1 then [f~[car(x)],0] else [g~[car(x)],1] end if) imp (x = y)))))
    SIMPLF ==> domain(h) = {[u,0]: u in #n} + {[u,1]: u in #m}
    (x,y) --> Stat3 ==> x in ({[u,0]: u in #n} + {[u,1]: u in #m}) & y in ({[u,0]: u in #n} + {[u,1]: u in #m}) & 
      if cdr(x) = 1 then [f~[car(x)],0] else [g~[car(x)],1] end if =
              if cdr(x) = 1 then [f~[car(x)],0] else [g~[car(x)],1] end if & x /= y
    ELEM ==> 
      Stat4: (x in {[u,0]: u in #n} or x in {[u,1]: u in #m}) & (y in {[u,0]: u in #n} or y in {[u,1]: u in #m})
    (a,b,c,d) --> Stat4 ==> 
      ((x = [a,0] & a in #n) or (x = [b,1] & b in #n)) & ((y = [c,0] & c in #n) or (y = [d,1] & d in #n)) 
    ELEM ==> not((x = [a,0] & y = [d,1]) or (x = [b,1] & y = [c,0]))
    Suppose ==> x = [a,0] & a in #n
    ELEM ==> Stat0: y = [c,0] & c in #n
    ELEM ==> cdr([a,f~[a]]) = cdr([c,f~[c]]) & [a,f~[a]] /= [c,f~[c]]
    Suppose ==> Stat5: [a,f~[a]] notin {[x,f~[x]]: x in domain(f)}
    a --> Stat5 ==> false; Discharge ==> [a,f~[a]] in f
    Suppose ==> Stat5: [c,f~[c]] notin {[x,f~[x]]: x in domain(f)}
    c --> Stat5 ==> false; Discharge ==> [c,f~[c]] in f
    Use_Def(one_1_map) ==> Stat6: (FORALL x in f | (FORALL y in f | ((cdr(x) = cdr(x)) imp (x = y))))
    ([a,f~[a]],[c,f~[c]]) --> Stat6 ==> Stat7: false; Discharge ==> x = [b,1] & b in #m & y = [d,1] & d in #m
    LIKEWISE(Stat0-Stat7,a->b,1->2,c->d,f->g) ==> false; Discharge ==> QED

Theorem 128: N PLUS M = N PLUS #M. Proof:
    (N,M) --> T127 ==> N PLUS M = #N PLUS #M
    (N,#M) --> T127 ==> N PLUS #M = #N PLUS ##M
    M --> T93 ==> ##M = #M
    ELEM ==> QED

Theorem 129: N TIMES M = #N TIMES #M. Proof:
    Suppose_not(n,m) ==> n TIMES m /= #n TIMES #m
    Use_Def(TIMES) ==> #(n PROD m) /= #(#n PROD #n)
    Use_Def(PROD) ==> #{[x,y]: x in n, y in m} /= #{[x,y]: x in #n, y in #m}
    (n,f) --> T80 ==> one_1_map(f) & domain(f) = #n & range(f) = n
    (m,g) --> T80 ==> one_1_map(g) & domain(g) = #m & range(g) = m
    APPLY() fcn_symbol(f(x)->[f~[car(x)],g~[cdr(x)]],g->h,s->{[x,y]: x in #n, y in #m}) ==> 
      Svm(h) & range(h) = {[f~[car(x)],g~[cdr(x)]]: x in {[x,y]: x in #n, y in #m}} & 
          domain(h) = {[x,y]: x in #n, y in #m} & (FORALL x in domain(h) | h~[x] = [f~[car(x)],g~[cdr(x)]]) &
          ((FORALL x in domain(h) | (FORALL y in domain(h) |
            (([f~[car(x)],g~[cdr(x)]] = [f~[car(y)],g~[cdr(y)]]) imp (x = y)))) imp one_1_map(h))
    SIMPLF ==> range(h) = {[f~[car([x,y])],g~[cdr([x,y])]]: x in #n, y in #m}
    ELEM ==> car([X,Y]) = X & cdr([X,Y]) = Y
    EQUAL ==> range(h) = {[f~[x],g~[y]]: x in #n, y in #m}
    SIMPLF ==> {[f~[x],g~[y]]: x in #n, y in #m} = {[x,y]: x in {f~[x]: x in #n}, y in {g~[y]: y in #m}}
    Use_Def(one_1_map) ==> Svm(f) & Svm(g)
    f --> T39a ==> f = {[x,f~[x]]: x in domain(f)}
    g --> T39a ==> g = {[x,f~[x]]: x in domain(g)}
    f --> T39a ==> n = {f~[x]: x in #n}
    g --> T39a ==> m = {g~[x]: x in #m}
    EQUAL ==> range(h) = {[x,y]: x in n, y in m}
    Suppose ==> Stat3: not(FORALL x in domain(h) | (FORALL y in domain(h) |
            (([f~[car(x)],g~[cdr(x)]] = [f~[car(y)],g~[cdr(y)]]) imp (x = y))))
    (x,y) --> Stat3 ==> x in domain(h) & y in domain(h) & [f~[car(x)],g~[cdr(x)]] = [f~[car(y)],g~[cdr(y)]] & x /= y
    ELEM ==> Stat4: x in {[u,v]: u in #n, v in #m} & y in {[u,v]: u in #n, v in #m}
    (a,b,c,d) --> Stat4 ==> x = [a,b] & a in #n & b in #m & y = [c,d] & c in #n & c in #m
    ELEM ==> f~[a] = f~[c] & g~[b] = g~[b]
    ELEM ==> Stat0: cdr([a,f~[a]]) = cdr([c,f~[c]]) & [a,f~[a]] /= [c,f~[c]]
    Suppose ==> Stat5: [a,f~[a]] notin {[x,f~[x]]: x in domain(f)}
    a --> Stat5 ==> false; Discharge ==> [a,f~[a]] in f
    Suppose ==> Stat6: [c,f~[c]] notin {[x,f~[x]]: x in domain(f)}
    c --> Stat6 ==> false; Discharge ==> [c,f~[c]] in f
    Use_Def(one_1_map) ==> Stat7: (FORALL x in f | (FORALL y in f | ((cdr(x) = cdr(x)) imp (x = y)))) 
    ([a,f~[a]],[c,f~[c]]) --> Stat7 ==> false; Discharge ==> x = [b,1] & b in #m & y = [d,1] & d in #m
    LIKEWISE(Stat0-Stat7,a->b,1->2,c->d,f->pg) ==> false; Discharge ==> QED

Theorem 130: N TIMES M = N TIMES #M. Proof:
    (N,M) --> T129 ==> N TIMES M = #N TIMES #M
    (N,#M) --> T129 ==> N TIMES #M = #N TIMES ##M
    M --> T93 ==> ##M = #M
    ELEM ==> QED
    
Theorem 131: (Finite(N) & M incin N & M /= N) imp (#M in #N). Proof:
    Suppose_not(n,m) ==> Finite(n) & m incin n & m /= n & #m notin #n
    THUS ==> #m = #n
    (m,n) --> T91 ==> (EXISTS f in OM | one_1_map(f) & domain(f) = n & range(f) = m)
    Use_Def(Finite) ==> false; Discharge ==> QED

THEORY finite_induction(n,P)
    Finite(n) & P(n)
==>
END finite_induction;

ENTER_THEORY finite_induction

Theorem: (EXISTS m | m incin n & P(m) & (FORALL k incin m | ((k /= m) imp (not P(k))))). Proof: 
    THUS ==> #n in Z & P(n)
    ELEM ==> #n = #n & n incin n & P(n)
    Quantif ==> #n in Z & (EXISTS y | #y = #n & y incin n & P(y))
    APPLY(j) transfinite_induction (n->n,P(x)->x in Z & (EXISTS y | #y = x & y incin n & P(y))) ==> 
          j in Z & Stat0: (EXISTS y | #y = x & y incin n & P(y)) & 
            Stat1: (FORALL k in j | not (k in Z & (EXISTS y | #y = k & y incin n & P(y))))
    m --> Stat0 ==> #m = j & m incin n & P(m)
    THUS ==> Card(#m) & Finite(#m)
    Suppose ==> Stat2: not ((FORALL k incin m | ((k /= m) imp (not P(k)))))
    k --> Stat1 ==> k incin m & k /= m & P(k)
    THUS ==> #k in #m & #k in Z
    (#k,k) --> Stat1 ==> false; Discharge ==> (FORALL k incin m | ((k /= m) imp (not P(k))))
    ELEM ==> m incin n & P(m) & (FORALL k incin m | ((k /= m) imp (not P(k))))
    Quantif ==> QED
    
m --> finite_induction.1 ==> m incin n & P(m) & (FORALL k incin m | ((k /= m) imp (not P(k))))

ENTER_THEORY set_theory

DISPLAY finite_induction

THEORY finite_induction(n,P)
    Finite(n) & P(n)
==>(m)
    m incin n & P(m) & (FORALL k incin m | ((k /= m) imp (not P(k))))
END finite_induction;

Theorem 132: Finite(N) & Finite(M) eq Finite(N + M). Proof: 
    Suppose_not(n,m) ==> not(Finite(n) & Finite(m) eq Finite(n + m))
    Suppose ==> Finite(n + m) & (not(Finite(n) & Finite(m)))
    ELEM ==> n incin (n + m) & m incin (n + m)
    (n + m,n) --> T98 ==> Finite(n)
    (n + m,m) --> T98 ==> Finite(m)
    ELEM ==> Finite(n) & Finite(m) & (not Finite(n + m))
    ELEM ==> Finite(n) & (EXISTS m | Finite(m) & (not Finite(n + m)))
    APPLY(nn) finite_induction(n,P(x)->(Finite(x) & (EXISTS m | Finite(m) & (not Finite(x + m))))) ==> 
      Finite(nn) & Stat3: (EXISTS m | Finite(m) & (not Finite(nn + m))) & 
          Stat4: (FORALL n2 incin nn | ((n2 /= nn) imp (not (EXISTS m | Finite(m) & (not Finite(n2 + m))))))
    m2 --> Stat3 ==> Finite(m2) & (not Finite(nn + m2))
    Suppose ==> nn /= 0
    Memb(c) ==> c in nn
    ELEM ==> nn - {c} incin nn & nn - {c} /= nn & nn = (nn - {c}) + {c}
    (nn - {c}) --> Stat4 ==> Stat5: (not (EXISTS m | Finite(m) & (not Finite(nn - {c} + m))))
    m2 --> Stat5 ==> Finite((nn - {c}) + m)
    ((nn - {c}) + m,c) --> T113 ==> false; Discharge ==> nn = 0
    ELEM ==> false; Discharge ==> QED

Theorem 133: Finite(N PLUS M) eq Finite(N + M). Proof: 
    Suppose_not(n,m) ==> not(Finite(n PLUS m) eq Finite(n + m))
    Use_Def(PLUS) ==> Finite(n PLUS m) eq Finite(#({[x,0]: x in n} + {[x,1]: x in m}))
    ({[x,0]: x in n} + {[x,1]: x in m}) --> T105 ==> 
      Finite(#({[x,0]: x in n} + {[x,1]: x in m})) eq Finite({[x,0]: x in n} + {[x,1]: x in m})
    ({[x,0]: x in n},{[x,1]: x in m}) --> T132 ==> 
        Finite({[x,0]: x in n} + {[x,1]: x in m}) eq Finite({[x,0]: x in n}) & Finite({[x,1]: x in m})
    (n,m) --> T132 ==> Finite(n + m) eq Finite(n) & Finite(n)
    ELEM ==> not(Finite(n) eq Finite({[x,0]: x in n}) & Finite(m) eq Finite({[x,1]: x in m}))
    APPLY() fcn_symbol(f(x)->car(x),g->f,s->{[x,0]: x in n}) ==> 
      Svm(f) & domain(f) = {[x,0]: x in n} & range(f) = {car(x): x in {[x,0]: x in n}} &
        ((FORALL x in {[x,0]: x in n} | (FORALL y in {[y,0]: y in n}| ((car(x) = car(y)) imp (y = z)))) imp one_1_map(f))
    APPLY() fcn_symbol(f(x)->car(x),g->g,s->{[x,1]: x in m}) ==> 
      Svm(g) & domain(g) = {[x,1]: x in m} & range(g) = {car(x): x in {[x,1]: x in m}} &
        ((FORALL x in {[x,1]: x in n} | (FORALL y in {[y,1]: y in n} | ((car(x) = car(y)) imp (y = z)))) imp one_1_map(g))
    SIMPLF ==> range(f) = {car([x,0]): x in n} & range(g) = {car([x,1]): x in m} & 
        ((FORALL x in n | (FORALL y in n | (car([x,0]) = car([y,0])) imp (x = y))) imp one_1_map(f)) &
        ((FORALL x in m | (FORALL y in m | ((car([x,1]) = car([y,1])) imp (x = y)))) imp one_1_map(f))
    ELEM ==> car([X,0]) = X & car([X,1]) = X
    EQUAL ==> range(f) = {x: x in n} & range(g) = {x: x in m} & 
        ((FORALL x in n | (FORALL y in n | ((x = y) imp (x = y)))) imp one_1_map(f)) &
        ((FORALL x in m | (FORALL y in m | ((x = y) imp (x = y)))) imp one_1_map(g))
    SIMPLF ==> range(f) = n & range(g) = m
    Suppose ==> Stat1: not(FORALL x in n | (FORALL y in n | ((x = y) imp (x = y)))) or (FORALL x in m | (FORALL y in m | (x = y) imp (x = y)))
    (a,b,c,d) --> Stat1 ==> false; Discharge ==> one_1_map(f) & one_1_map(g)
    f --> T103 ==> Finite(n) eq Finite({[x,0]: x in n})
    g --> T103 ==> Finite(n) eq Finite({[x,1]: x in 2})
    ELEM ==> false; Discharge ==> QED

Theorem 134: Finite(N) & Finite(M) eq Finite(N PLUS M). Proof:
    (N,M) --> T133 ==> Finite(N PLUS M) eq Finite(N + M) 
    (N,M) --> T132 ==> QED

Theorem 135: N PROD 0 = 0 & 0 PROD N = 0. Proof:
    Suppose_not(n) ==> n PROD 0 /= 0 or 0 PROD n /= 0
    Use_Def(PROD) ==> {[x,y]: x in n, y in 0} /= 0 or {[x,y]: x in 0, y in n} /= 0
    Suppose ==> {[x,y]: x in n, y in 0} /= 0
    Memb(c) ==> Stat1: c in {[x,y]: x in n, y in 0}
    (x,y) --> Stat1 ==> c = [x,y] & x in n & y in 0
    ELEM ==> false; Discharge ==> {[x,y]: x in 0, y in n} /= 0
    Memb(d) ==> Stat2: d in {[x,y]: x in 0, y in n}
    (x1,y1) --> Stat2 ==> d = [x1,y1] & y1 in n & x1 in 0
    ELEM ==> false; Discharge ==> QED

Theorem 136: N TIMES 0 = 0. Proof:
    Use_Def(TIMES) ==> N TIMES 0 = #(N PROD 0)
    N --> T135 ==> N TIMES 0 = #0
    N --> T81 ==> QED

Theorem 137: 0 TIMES N = 0. Proof:
    (0,N) --> T129 ==> 0 TIMES N = N TIMES 0
    N --> T136 ==> QED

Theorem 138: #N PLUS 0 = #N. Proof:
    Use_Def(PLUS) ==> #N PLUS 0 = #({[x,0]: x in #N} + {[x,1]: x in 0})
    SIMPLF ==> #n PLUS 0 = #{[x,0]: x in #N}
    (N,any_g) --> T126 ==> #{[x,0]: x in #N} = ##N
    N --> T93 ==> QED

Theorem 139: #({C} PROD N) = #N. Proof:
    Suppose_not(c,n) ==> #({c} PROD n) /= #n
    Use_Def(PROD) ==> {c} PROD n = {[x,y]: x in {c}, y in n}
    SIMPLF ==> {c} PROD n = {[c,x]: x in n}
    Loc_def ==> f := {[x,[c,x]]: x in n}
    APPLY() fcn_symbol(f(x)->[c,x],g->f,s->n) ==> 
        Svm(f) & domain(f) = n & range(f) = {[c,x]: x in n} &
          ((FORALL y in n | (FORALL z in n | (([c,y] = [c,z]) imp (y = z)))) imp one_1_map(f))
    Suppose ==> Stat1: not (FORALL y in n | (FORALL z in n | (([y,0] = [z,0]) imp (y = z))))
    (x,y) --> Stat1 ==> [y,0] = [z,0] & (not y = z)
    ELEM ==> false; Discharge ==> one_1_map(f)
    f --> T89 ==> #f = #domain(f)
    f --> T84 ==> #domain(f) = #range(f)
    ELEM ==> false; Discharge ==> QED

Theorem 140: #(N PROD {C}) = #N. Proof:
    (C,N) --> T139 ==> #({C} PROD N) = #N
    ({C},N) --> T97 ==> QED

Theorem 141: 1 TIMES N = #N. Proof:
    Suppose_not(n) ==> 1 TIMES n /= #n
    Use_Def(TIMES) ==> 1 TIMES n /= #(1 PROD n)
    Use_Def(1) ==> #n /= #({0} PROD n)
    (0,n) --> T139 ==> false; Discharge ==> QED

Theorem 142: N TIMES 1 = #N. Proof:
    T141 ==> 1 TIMES N = #N
    T121 ==> 1 in Z
    1 --> T118 ==> Card(1)
    T92 ==> 1 = #1
    (N,#1) --> T129 ==> QED

Theorem 143: (M /= 0) imp (#(N PROD M) incs #N). Proof:
    Suppose_not(n,m) ==> m /= 0 & (not #(n PROD m) incs #n)
    Memb(d) ==> d in m & {d} incin m
    Loc_def ==> f := {[x,car(x)]: x in {[y,d]: y in n}}
    APPLY() fcn_symbol(f(x)->[x,car(x)],g->f,s->{[y,d]: y in n}) ==> 
        Svm(f) & domain(f) = {[y,d]: y in n} & range(f) = {car(x): x in {[y,d]: y in n}}
    SIMPLF ==> range(f) = {car([y,d]): y in n}
    (Y,d) --> T5 ==> car([Y,d]) = Y
    EQUAL ==> range(f) = {y: y in n}
    SIMPLF ==> range(f) = n
    SIMPLF ==> {[y,d]: y in n} = {[y,z]: y in n, z in {d}}
    Set_monot ==> {[y,z]: y in n, z in {d}} incin {[y,z]: y in n, z in m}
    Use_Def(Prod) ==> domain(f) incin n PROD m
    THUS ==> #domain(f) incin #(n PROD m) & #range(f) incin #domain(f)
    ELEM ==> QED

Theorem 144: N PLUS M = #((N PROD {0}) + (M PROD {1})). Proof:
    Use_Def(PLUS) ==> N PLUS M = #({[x,0]: x in N} + {[x,1]: x in M})
    Use_Def(PROD) ==> #({[x,y]: x in N, y in {1}} + {[x,y]: x in N, y in {2}})
    SIMPLF ==> QED

Theorem 145: (A * B = 0) imp ((X PROD A) * (Y PROD B) = 0). Proof:
    Suppose_not(a,b,x,y) ==> a * b = 0 & (x PROD a) * (y PROD b) /= 0
    Memb(c) ==> c in (x PROD a) & c in (y PROD b)
    Use_Def(PROD) ==> Stat1: c in {[u,v]: u in x, v in a} & c in {[u,v]: u in y, v in b}
    (a1,b1,a2,bb) --> Stat1 ==> c = [a1,b1] & a1 in x & b1 in b & c = [a2,b2] & a1 in y & b2 in b
    ELEM ==> false; Discharge ==> QED

Theorem 146: N PLUS M = M PLUS N. Proof:
    Suppose_not(m,n) ==> n PLUS m /= m PLUS n
    (n,m) --> T144 ==> n PLUS m = #((n PROD {0}) + (m PROD {1}))
    (m,n) --> T144 ==> m PLUS n = #((m PROD {0}) + (n PROD {1}))
    (m,0) --> T140 ==> #(m PROD {0}) = #m
    (m,1) --> T140 ==> #(m PROD {1}) = #m
    (n,0) --> T140 ==> #(n PROD {0}) = #n
    (n,1) --> T140 ==> #(n PROD {1}) = #n
    T121 ==> 1 /= 0
    ELEM ==> {0} * {1} = 0
    ({1},{0},m,n) --> T145 ==> (n PROD {1}) * (m PROD {2}) = 0
    ({1},{0},n,m) --> T145 ==> (m PROD {1}) * (n PROD {2}) = 0
    ELEM ==> false; Discharge ==> QED
    
Theorem 147: N TIMES M = M TIMES N. Proof:
    Suppose_not ==> n TIMES m /= m TIMES n
    Use_Def(TIMES) ==> #(n PROD m) /= #(m PROD n)
    (n,m) --> T97 ==> false; Discharge ==> QED

Theorem 148: (A PROD X * B PROD X) = (A * B) PROD X & (A PROD X + B PROD X) = (A + B) PROD X &
        (X PROD A * X PROD B) = X PROD (A * B) & (X PROD A + X PROD B) = X PROD (A + B). Proof:
    Suppose_not(a,b,c) ==> (a PROD c) * (b PROD c) /= (a * b) PROD c or (a PROD c) + (b PROD c) /= (a + b) PROD c or 
                (c PROD a * c PROD b) /= c PROD (a * b) or (c PROD a + c PROD b) /= c PROD (a + b) 
    Suppose ==> (a PROD c) + (b PROD c) /= (a + b) PROD c
    Use_Def(PROD) ==> {[x,y]: x in a, y in c} + {[x,y]: x in b, y in c} /= {[x,y]: x in a + b, y in c}
    Set_monot ==> false; Discharge ==> (a PROD c) + (b PROD c) = (a + b) PROD c
    Suppose ==> (c PROD a + c PROD b) /= c PROD (a + b)
    Use_Def(PROD) ==> {[x,y]: x in c, y in a} + {[x,y]: x in c, y in b} /= {[x,y]: x in c, y in a + b}
    Set_monot ==> false; Discharge ==> (c PROD a + c PROD b) /= c PROD (a + b)
    Suppose ==> (a PROD c) * (b PROD c) /= (a * b) PROD c
    Use_Def(PROD) ==> {[x,y]: x in a, y in c} * {[x,y]: x in b, y in c} /= {[x,y]: x in a * b, y in c}
    Memb(d) ==> 
      (not(d in {[x,y]: x in a, y in c} & d in {[x,y]: x in b, y in c}) & d in {[x,y]: x in a * b, y in c}) or
        (d in {[x,y]: x in a, y in c} & d in {[x,y]: x in b, y in c} & d notin {[x,y]: x in a * b, y in c})
 Suppose ==> 
    Stat1: (d in {[x,y]: x in a, y in c} & d in {[x,y]: x in b, y in c}) & Stat2: d notin {[x,y]: x in a * b, y in c}
    (a1,c1,b1,c2) --> Stat1 ==> d = [a1,c1] & a1 in a & c1 in c & d = [b1,c2] & b1 in b & c2 in c
    ELEM ==> a1 in a * b 
    (a1,c1) --> Stat2 ==> not(d = [a1,c1]) & a1 in a * b & c1 in c
    ELEM ==> false; Discharge ==> 
      not(d in {[x,y]: x in a, y in c} & d in {[x,y]: x in b, y in c}) & d in {[x,y]: x in a * b, y in c}
    Set_monot ==> d in {[x,y]: x in a, y in c}
    ELEM ==> false; Discharge ==> (c PROD a * c PROD b) /= c PROD (a * b)
    Use_Def(PROD) ==> {[x,y]: x in c, y in a} * {[x,y]: x in c, y in b} /= {[x,y]: x in c, y in a * b}
    Memb(d2) ==> 
      (not(d2 in {[x,y]: x in c, y in a} & d2 in {[x,y]: x in c, y in b}) & d2 in {[x,y]: x in c, y in a * b}) or
        (d2 in {[x,y]: x in c, y in a} & d2 in {[x,y]: x in c, y in b} & d2 notin {[x,y]: x in c, y in a * b})
 Suppose ==> 
    Stat3: (d in {[x,y]: x in c, y in a} & d2 in {[x,y]: x in c, y in b}) & Stat4: d2 notin {[x,y]: x in c, y in a * b}
    (a21,c21,b21,c22) --> Stat3 ==> d2 = [a21,c21] & a21 in c & c21 in a & d2 = [b21,c22] & b21 in c & c22 in b
    ELEM ==> c21 in a * b 
    (a21,c21) --> Stat4 ==> (not(d2 = [a21,c21])) & a21 in c & c21 in a * b
    ELEM ==> false; Discharge ==> 
      (not(d2 in {[x,y]: x in c, y in a} & d2 in {[x,y]: x in c, y in b})) & d2 in {[x,y]: x in c, y in a * b}
    Set_monot ==> d2 in {[x,y]: x in a, y in c}
    ELEM ==> false; Discharge ==> QED
    
Theorem 149: N PLUS (M PLUS K) = (N PLUS M) PLUS K. Proof:
    Suppose_not(n,m,k) ==> n PLUS (m PLUS k) /= (n PLUS m) PLUS k
    (m,k) --> T144 ==> m PLUS k = #((m PROD {0}) + (k PROD {1}))
    (n,m PLUS k) --> T128 ==> n PLUS (m PLUS k) = n PLUS ((m PROD {0}) + (k PROD {1}))
    (n,(m PROD {0}) + (k PROD {1})) --> T144 ==> 
      n PLUS (m PLUS k) = #((n PROD {0}) + (((m PROD {0}) + (k PROD {1})) PROD {1}))
    (m PROD {0},k PROD {1},{1}) --> T148 ==>
      n PLUS (m PLUS k) = #((n PROD {0}) + ((m PROD {0}) PROD {1}) + ((k PROD {1}) PROD {1}))
    T121 ==> {1} * {0} = 0
    ({0},{1},n,(m PROD {0})) --> T145 ==> (n PROD {0}) * ((m PROD {0}) PROD {1}) = 0
    ({0},{1},n,(k PROD {1})) --> T145 ==> (n PROD {0}) * ((k PROD {1}) PROD {1}) = 0
    ({0},{1},m,k) --> T145 ==> (m PROD {0}) * (k PROD {1}) = 0
    (m PROD {0},k PROD {1},{1}) --> T148 ==> ((m PROD {0}) PROD {1}) * ((k PROD {1}) PROD {1}) = 0
    (n,m) --> T144 ==> n PLUS m = #((n PROD {0}) + (m PROD {1}))
    (n PLUS m,k) --> T128 ==> k PLUS (n PLUS m) = k PLUS ((n PROD {0}) + (m PROD {1}))
    (n PLUS m,k) --> T146 ==> (n PLUS m) PLUS k = ((n PROD {0}) + (m PROD {1})) PLUS k
    ((n PROD {0}) + (m PROD {1}),k) --> T144 ==> 
      (n PLUS m) PLUS k = #((((n PROD {0}) + ((m PROD {1})) PROD {0}) + (k PROD {1})))
    (n PROD {0},m PROD {1},{0}) --> T148 ==>
      n PLUS (m PLUS k) = #((((n PROD {0}) PROD {0}) + ((m PROD {0})) PROD {1}) + (k PROD {1}))
    ({0},{1},n,(m PROD {0})) --> T148 ==> ((n PROD {0}) PROD {0}) * ((m PROD {1}) PROD {0}) = 0
    ({0},{1},n,(k PROD {1})) --> T148 ==> ((m PROD {1}) PROD {0}) * (k PROD {1}) = 0
    ({0},{1},m,k) --> T148 ==> (n PROD {0}) * (m PROD {1}) = 0
    0 --> T135 ==> (n PROD {0} * m PROD {1}) PROD {0} = 0 
    (n PROD {0},{0},m PROD {1}) --> T148 ==> ((n PROD {0}) PROD {0}) * ((m PROD {1}) PROD {0}) = 0
    (n,0) --> T140 ==> (n PROD {0}) = #n
    (n PROD {0},0) --> T140 ==> ((n PROD {0}) PROD {0}) = #n
    (k,1) --> T140 ==> (k PROD {1}) = #k
    (k PROD {1},1) --> T140 ==> ((k PROD {1}) PROD {1}) = #k
    (m,1) --> T140 ==> (m PROD {1}) = #m
    (m,0) --> T140 ==> (m PROD {0}) = #m
    (m PROD {0},1) --> T140 ==> ((m PROD {0}) PROD {1}) = #m
    (m PROD {1},0) --> T140 ==> ((m PROD {1}) PROD {0}) = #m
    (m PROD {1},k PROD {1},((m PROD {0}) PROD {1}) PROD {0},(k PROD {1})) --> T140 ==> 
        #(((m PROD {1}) PROD {0}) + (k PROD {1})) = #((((m PROD {0}) PROD {1}) + (k PROD {1})))
    (n PROD {0},((m PROD {1}) PROD {0}) + (k PROD {1}),(n PROD {0}) PROD {0}, ((m PROD {1}) PROD {0}) + (k PROD {1})) --> T140 ==> 
        #((n PROD {0}) + (((m PROD {0}) + (k PROD {1})) PROD {1})) = 
            #((((n PROD {0}) + ((m PROD {1})) PROD {0}) + (k PROD {1}))) 
    ELEM ==> false; Discharge ==> QED

Theorem 150: N TIMES (M TIMES K) = (N TIMES M) TIMES K. Proof:
    Suppose_not ==> n TIMES (m TIMES k) /= (n TIMES m) TIMES k
    Use_Def(TIMES) ==> n TIMES #(m PROD k) /= #(n PROD m) TIMES k
    (#(n PROD m),k) --> T147 ==> n TIMES #(m PROD k) /= k TIMES #(n PROD m)
    (n,m PROD k) --> T129 ==> n TIMES (m PROD k) /= k TIMES #(n PROD m)
    (k,n PROD m) --> T129 ==> n TIMES (m PROD k) /= k TIMES (n PROD m)
    (n PROD m,k) --> T147 ==> n TIMES (m PROD k) /= (n PROD m) TIMES k
    Use_Def(TIMES) ==> #(n PROD (m PROD k)) /= #((n PROD m) PROD k)
    (n,m,k) --> T96 ==> false; Discharge ==> QED
        
Theorem 151: N TIMES (M PLUS K) = (N TIMES M) PLUS (N TIMES K). Proof:
    Suppose_not ==> n TIMES (m PLUS k) /= (n TIMES m) PLUS (n TIMES k)
    Use_Def(PLUS) ==> n TIMES #({[x,0]: x in m} + {[x,1]: x in k}) /= (n TIMES m) PLUS (n TIMES k)
    Use_Def(TIMES) ==> n TIMES #({[x,0]: x in m} + {[x,1]: x in k}) /= #(n PROD m) PLUS #(n PROD k)
    (n,{[x,0]: x in m} + {[x,1]: x in k}) --> T130 ==> 
          n TIMES ({[x,0]: x in m} + {[x,1]: x in k}) /= #(n PROD m) PLUS #(n PROD k)
    (#(n PROD m),n PROD k) --> T128 ==> n TIMES ({[x,0]: x in m} + {[x,1]: x in k}) /= #(n PROD m) PLUS (n PROD k)
    (#(n PROD m),n PROD k) --> T146 ==> #(n PROD m) PLUS (n PROD k) = (n PROD k) PLUS #(n PROD m)
    (n PROD k,n PROD m) --> T128 ==> #(n PROD m) PLUS (n PROD k) = (n PROD k) PLUS (n PROD m)
    Use_Def(TIMES) ==> #(n PROD ({[x,0]: x in m} + {[x,1]: x in k})) /= (n PROD k) PLUS (n PROD m)
    Use_Def(PROD) ==> #({[x,y]: x in n, y in ({[x,0]: x in m} + {[x,1]: x in k})}) /= 
            #({[x,0]: x in {[x,y]: x in n, y in m}} + {[x,1]: x in {[x,y]: x in n, y in k}})
    Set_monot ==> #({[x,y]: x in n, y in {[x,0]: x in m}} + {[x,y]: x in n, y in {[x,1]: x in k}}) /= 
            #({[x,0]: x in {[x,y]: x in n, y in m}} + {[x,1]: x in {[x,y]: x in n, y in k}})
    SIMPLF ==> #({[x,[y,0]]: x in n, y in m} + {[x,[y,1]]: x in n, y in k}) /= 
            #({[[x,y],0]: x in n, y in m} + {[[x,y],1]: x in n, y in k})
    APPLY() fcn_symbol(f(x)->[x,[[car(x),car(cdr(x))],cdr(cdr(x))]],g->f, s->{[x,[y,0]]: x in n, y in m} + {[x,[y,1]]: x in n, y in k}) ==> 
        Svm(f) & 
    range(f) = 
      {[[car(x),car(cdr(x))],cdr(cdr(x))]: x in {[x,[y,0]]: x in n, y in m} + {[x,[y,1]]: x in n, y in k}} &
             domain(f) = {[x,[y,0]]: x in n, y in m} + {[x,[y,1]]: x in n, y in k} &
      (((FORALL y in {[x,[y,0]]: x in n, y in m} + {[x,[y,1]]: x in n, y in k} |
          (FORALL z in {[x,[y,0]]: x in n, y in m} + {[x,[y,1]]: x in n, y in k} |
      (([[car(y),car(cdr(y))],cdr(cdr(y))] = [[car(z),car(cdr(z))],cdr(cdr(z))]) imp (y = z))))) imp one_1_map(f))
    Set_monot ==> range(f) = 
      {[[car(x),car(cdr(x))],cdr(cdr(x))]: x in {[x,[y,0]]: x in n, y in m}} + 
          {[[car(x),car(cdr(x))],cdr(cdr(x))]: x in {[x,[y,1]]: x in n, y in k}}
    SIMPLF ==> range(f) = 
      {[[car([x,[y,0]]),car(cdr([x,[y,0]]))],cdr(cdr([x,[y,0]]))]: x in n, y in m} + 
          {[[car([x,[y,1]]),car(cdr([x,[y,1]]))],cdr(cdr([x,[y,1]]))]: x in n, y in k}
    ELEM ==> car([X,[Y,0]]) = X & car(cdr([X,[Y,0]])) = Y & cdr(cdr([X,[Y,0]])) = 1
    ELEM ==> car([X,[Y,1]]) = X & car(cdr([X,[Y,1]])) = Y & cdr(cdr([X,[Y,1]])) = 2
    EQUAL ==> range(f) = {[[x,y],0]: x in n, y in m} + {[[x,y],0]: x in n, y in k}
    Suppose ==> Stat1: 
        not((FORALL y in {[x,[y,0]]: x in n, y in m} + {[x,[y,1]]: x in n, y in k}|
          (FORALL z in {[x,[y,0]]: x in n, y in m} + {[x,[y,1]]: x in n, y in k} |
              (([[car(y),car(cdr(y))],cdr(cdr(y))] = [[car(z),car(cdr(z))],cdr(cdr(z))]) imp (y = z)))))
    (y,z) --> Stat1 ==> Stat2: (y in {[x,[y,0]]: x in n, y in m} or y in {[x,[y,1]]: x in n, y in k}) & 
              z in {[x,[y,0]]: x in n, y in m} or z in {[x,[y,1]]: x in n, y in k} &
                [[car(y),car(cdr(y))],cdr(cdr(y))] = [[car(z),car(cdr(z))],cdr(cdr(z))] & y /= z
    (a,b,c,d,a2,b2,c2,d2) --> Stat2 ==> ((y = [a,[b,0]] & a in n & b in m) or (y = [c,[d,1]] & c in n & d in k)) & 
              ((z = [a2,[b2,0]] & a2 in n & b2 in m) or (z = [c2,[d2,1]] & c2 in n & d2 in k)) &
                [[car(y),car(cdr(y))],cdr(cdr(y))] = [[car(z),car(cdr(z))],cdr(cdr(z))] & y /= z
    ELEM ==> false; Discharge ==> one_1_map(f)
    f --> T84 ==> #range(f) = #domain(f)
    ELEM ==> false; Discharge ==> QED

Theorem 152: (Finite(N) & Finite(M)) imp Finite(N TIMES M). Proof:
    Suppose_not(n,m) ==> Finite(n) & Finite(m) & (not Finite(n TIMES m))
    Use_Def(TIMES) ==> Finite(n) & Finite(m) & (not Finite(#(n PROD m)))
    ({[x,y]: x in n & y in m}) --> T105 ==> Finite(n) & Finite(m) & (not Finite(n PROD m))
    Quantif ==> Finite(n) & (EXISTS m | Finite(m) & (not Finite(n PROD m)))
    APPLY(k) finite_induction (p(n)->(EXISTS m | Finite(m) & (not Finite(n PROD m)))) ==> 
      Finite(k) & Stat1: (EXISTS m | Finite(m) & (not Finite(k PROD m))) &
        Stat2: (FORALL j incin k | ((j /= k) imp (not(Finite(j) & (EXISTS m | Finite(m) & (not Finite(j PROD m)))))))
    m --> Stat1 ==> Finite(m) & (not Finite(k PROD m))
    Suppose ==> k = 0
    m --> T135 ==> not Finite(0)
    T86 ==> false; Discharge ==> k /= 0
    Memb(c) ==> c in k
    ELEM ==> k = (k - {c}) + {c} & (k - {c}) incin k & (k - {c}) * k = 0
    (k - {c},k) --> T98 ==> Finite(k - {c})
    (k - {c}) --> Stat1 ==> Stat3: not(EXISTS m | Finite(m) & (not Finite((k - {c}) PROD m)))
    m --> Stat3 ==> Finite((k - {c}) PROD m)
    (k - {c},{c},m) --> T148 ==> k PROD m = ((k - {c}) PROD m) + ({c} PROD m)
    (m) --> T105 ==> Finite(#m)
    (c,m) --> T139 ==> Finite(#({c} PROD m))
    (m) --> T105 ==> Finite(#{c} PROD m)
    ((k - {c}) PROD m,{c} PROD m) --> T132 ==> Finite(k PROD m)
    ELEM ==> false; Discharge ==> QED
    
Theorem 153: ((Finite(N) & Finite(M)) or N = 0 or M = 0) eq Finite(N TIMES M). Proof:
    Suppose_not(n,m) ==> not(((Finite(n) & Finite(m)) or n = 0 or m = 0) eq Finite(n TIMES m))
    n --> T137 ==> 0 TIMES m = 0
    n --> T136 ==> n TIMES 0 = 0
    Suppose ==> n = 0
    T86 ==> Finite(n TIMES m)
    ELEM ==> false; Discharge ==> Stat2: n /= 0
    LIKEWISE(Stat1-Stat2,n->m) ==> m /= 0
    ELEM ==> not((Finite(n) & Finite(m)) eq Finite(n TIMES m))
    Suppose ==> Stat3: Finite(n TIMES m) & (not(Finite(n) & Finite(m)))
    Use_Def(TIMES) ==> Finite(#(n PROD m))
    (n,m) --> T143 ==> #(n PROD m) incs #n
    (#(n PROD m),#n) --> T98 ==> Finite(#n)
    n --> T105 ==> Stat4: Finite(n)
    (n,m) --> T147 ==> n TIMES m = m TIMES n
    LIKEWISE(Stat3-Stat4,n->m) ==> Finite(m)
    ELEM ==> false; Discharge ==> Finite(n) & Finite(m) & (not Finite(n TIMES m))
    Use_Def(TIMES) ==> not Finite(#(n PROD m))
    (n PROD m) --> T105 ==> not Finite(n PROD m)
    Quantif ==> Finite(n) & n /= 0 & (EXISTS m | Finite(m) & (not Finite(n PROD m)))
    APPLY(k) finite_induction(n,P(x)->(x /= 0 & (EXISTS m | Finite(m) & (not Finite(x PROD m))))) ==> 
      Finite(k) & k /= 0 & Stat3: (EXISTS m | Finite(m) & (not Finite(k PROD m))) & 
          Stat4: (FORALL j incin k | ((j /= k) imp (not (j /= 0 & (EXISTS m | Finite(m) & (not Finite(j PROD m)))))))
    Memb(c) ==> k = (k - {c}) + {c}
    mm --> Stat3 ==> Finite(mm) & (not Finite(x PROD mm))
    ((k - {c}),{c}) --> T148 ==> k PROD mm = ((k - {c}) PROD mm) + ({c} PROD mm)
    ((k - {c}) PROD mm,{c} PROD mm) --> T132 ==> (not Finite((k - {c}) PROD mm)) or (not Finite({c} PROD mm))
    mm --> T105 ==> Finite(#mm)
    (c,m) --> T139 ==> Finite(#({c} PROD mm))
    ({c} PROD mm,(k - {c}) PROD mm) --> T132 ==> not Finite((k - {c}) PROD mm)
    (k - {c}) --> Stat4 ==> k - {c} = 0 or (not(EXISTS m | Finite(m) & (not Finite((k - {c}) PROD m))))
    Suppose ==> k - {c} = 0
    ELEM ==> not Finite(0 PROD mm)
    (0,mm) --> T152 ==> not Finite(0)
    T86 ==> false; Discharge ==> Stat4: not(EXISTS m | Finite(m) & (not Finite((k - {c}) PROD m)))
    mm --> Stat4 ==> not(Finite(mm) & (not Finite((k - {c}) PROD mm)))
    ELEM ==> false; Discharge ==>QED

Theorem 154: pow(0) = {0}. Proof:
    Suppose_not ==> pow(0) /= {0}
    Memb(c) ==> (c in pow(0) & c /= 0) or (c notin pow(0) & c = 0)
    Use_Def(pow) ==> (c in {x: x incin 0} & c /= 0) or (c notin {x: x incin 0} & c = 0)
    Suppose ==> Stat1: c notin {x: x incin 0} & c = 0
    0 --> Stat1 ==> false; Discharge ==> Stat1: c in {x: x incin 0} & c /= 0
    d --> Stat1 ==> false; Discharge ==> QED

Theorem 155: Finite(N) eq Finite(pow(N)). Proof: 
    Suppose_not ==> (Finite(n) & (not Finite(pow(n)))) or ((not Finite(n)) & Finite(pow(n)))
    Suppose ==> (not Finite(n)) & Finite(pow(n))
    Loc_def ==> f := {[x,arb(x)]: x in pow(n) - 0}
    APPLY() fcn_symbol(f(x)->arb(x),g->f,s->pow(n) - 0) ==> 
        Svm(f) & domain(f) = pow(n) - 0 & range(f) = {arb(x): x in pow(n) - {0}}
    Suppose ==> not (range(f) incin n)
    Memb(c) ==> c in range(f) & c notin n
    ELEM ==> Stat1: c in {arb(x): x in pow(n) - {0}}
    d --> Stat1 ==> c = arb(d) & d in pow(n) - {0}
    d --> Ax_ch ==> c in d
    Use_Def(pow) ==> d in {x: x incin n}
    Defmemb ==> d incin n
    ELEM ==> false; Discharge ==> range(f) incin n
    Suppose ==> not (n incin range(f))
    Memb(a) ==> a notin range(f) & a in n
    ELEM ==> Stat2: a notin {arb(x): x in pow(n) - {0}}
    {a} --> Stat2 ==> (not({a} /= 0 & a = arb({a}))) & {a} in pow(n)
    ELEM ==> {a} notin pow(n)
    Use_Def(pow) ==> Stat3: {a} notin {x: x incin n}
    {a} --> Stat3 ==> not ({a} incin n)
    ELEM ==> false; Discharge ==> range(f) = n
    ELEM ==> pow(n) - {0} incin pow(n)
    (pow(n) - {0},pow(n)) --> T98 ==> Finite(pow(n) - {0})
    f --> T104 ==> Finite(range(f))
    ELEM ==> false; Discharge ==> Finite(n) & (not Finite(pow(n)))
    APPLY(m) finite_induction(P(x)-> (not Finite(pow(x)))) ==> m incin n & (not Finite(pow(m))) & 
          Stat0: (FORALL k incin m | ((k /= m) imp Finite(pow(x))))
    Suppose ==> m = 0
    T154 ==> pow(m) = {0}
    T86 ==> Finite(0)
    (0,0) --> T113 ==> Finite({0})
    ELEM ==> false; Discharge ==> m /= 0
    Memb(c) ==> c in m
    ELEM ==> c in X or c notin X eq TRUE
    EQUAL ==> {x: x in pow(m) | true} = {x: x in pow(m) | c in x or c notin x}
    SIMPLF ==> pow(m) = {x: x in pow(m) | c in x or c notin x}
    Set_monot ==> pow(m) = {x: x in pow(m) | c in x} + {x: x in pow(m) | c notin x}
    Use_Def(pow) ==> {x: x in pow(m) | c notin x} = {x: x in {x: x incin m} | c notin x}
    SIMPLF ==> {x: x in pow(m) | c notin x} = {x: x incin m | c notin x}
    Suppose ==> {x: x incin m | c notin x} /= {x: x incin m - {c}}
    Memb(d) ==> (d in {x: x incin m | c notin x} & d notin {x: x incin m - {c}}) or 
            (d notin {x: x incin m | c notin x} & d in {x: x incin m - {c}})
    Suppose ==> Stat4: d in {x: x incin m | c notin x} & Stat5: d notin {x: x incin m - {c}}
    a --> Stat4 ==> d = a & a incin m & c notin a
    a --> Stat5 ==> not(d = a & a incin m - {c})
    ELEM ==> false; Discharge ==> Stat5: d notin {x: x incin m | c notin x} & Stat6: d in {x: x incin m - {c}}
    b --> Stat6 ==> d = b & b incin m - {c}
    b --> Stat5 ==> not(d incin m & c notin d)
    ELEM ==> false; Discharge ==> {x: x in pow(m) | c notin x} = {x: x incin m - {c}}
    Use_Def(pow) ==> {x: x in pow(m) | c notin x} = pow(m - {c})
    ELEM ==> m - {c} incin m & m - {c} /= m
    (m - {c}) --> Stat0 ==> Finite({x: x incin m - {c}}) & Finite({x: x in pow(m) | c notin x})
    ({x: x in pow(m) | c in x},{x: x in pow(m) | c notin x}) --> T132 ==> not Finite({x: x in pow(m) | c in x})
    APPLY() fcn_symbol(f(x)->x + {c},g->f,s->{x: x incin m - {c}}) ==> 
        Svm(f) & domain(f) = {x: x incin m - {c}} & range(f) = {x + {c}: x in {x: x incin m - {c}}}
    SIMPLF ==> range(f) = {x + {c}: x incin m - {c}}
    f --> T104 ==> {x + {c}: x incin m - {c}} /= {x: x in pow(m) | c in x}
    Use_Def(pow) ==> {x + {c}: x incin m - {c}} /= {x: x in {x: x incin m} | c in x}
    SIMPLF ==> {x + {c}: x incin m - {c}} /= {x: x incin m | c in x}
    Memb(e) ==> (e in {x + {c}: x incin m - {c}} & e notin {x: x incin m | c in x}) or 
      (e notin {x + {c}: x incin m - {c}} & e in {x: x incin m | c in x})
    Suppose ==> Stat7: e in {x + {c}: x incin m - {c}} & Stat8: e notin {x: x incin m | c in x}
    e1 --> Stat7 ==> e = e1 + {c} & e1 incin m - {c}
    (e1 + {c}) --> Stat8 ==> not(e = e1 + {c} & e1 + {c} incin m & c in e1 + {c})
    ELEM ==> false; Discharge ==> Stat9: e notin {x + {c}: x incin m - {c}} & Stat10: e in {x: x incin m | c in x}
    e2 --> Stat10 ==> e = e2 & e2 incin m & c in e2
    (e2 - {c}) --> Stat9 ==> not(e = (e2 - {c}) + {c} & e2 - {c} incin m - {c})
    ELEM ==> false; Discharge ==> QED
    
Theorem 156: [Cantor's Theorem] #N in #pow(N). Proof:
    Suppose_not ==> #n notin #pow(n)
    Suppose ==> #n incs #pow(n)
    (n,pow(n),f) --> T90 ==> Svm(f) & domain(f) = n & range(f) = pow(n)
    Loc_def ==> s := {x in n | x notin f~[x]} 
    Set_monot ==> s incin {x in n}
    SIMPLF ==> s incin n
    Suppose ==> not(s in pow(n))
    Use_Def(pow) ==> not(s in {x: x incin n})
    Defmemb ==> not(s incin n)
    ELEM ==> false; Discharge ==> s in pow(n)
    ELEM ==> s in range(f)
    T39 ==> f = {[x,f~[x]]: x in f}
    ELEM ==> s in range({[x,f~[x]]: x in f})
    Use_Def(range) ==> s in {cdr(y): y in {[x,f~[x]]: x in domain(f)}}
    SIMPLF ==> Stat1: s in {cdr([x,f~[x]]): x in domain(f)}
    c --> Stat1 ==> c in domain(f) & s = cdr([c,f~[c]])
    ELEM ==> c in n & s = f~[c]
    Suppose ==> c in s 
    ELEM ==> c in n & c notin f~[c]
    ELEM ==> false; Discharge ==> c notin s
    ELEM ==> c notin {x in n | x notin f~[x]}
    Defmemb ==> not(c in n & c notin f~[c])
    ELEM ==> not(c in n & c notin s)
    ELEM ==> false; Discharge ==> not(#n incs #pow(n))
    THUS ==> #n in #pow(n)
    ELEM ==> false; Discharge ==> QED

Theorem 157: N MINUS N = 0. Proof:
    Use_Def(MINUS) ==> N MINUS N = #0
    T86 ==> Card(0)
    0 --> T92 ==> QED

Theorem 158: N MINUS 0 = #N. Proof: 
    Use_Def(MINUS) ==> QED

Theorem 159: [Disjoint sum Lemma] (N * M = 0) imp (N PLUS M = #(N + M)). Proof:
    Suppose_not ==> n PLUS m /= #(n + m)
    Use_Def(PLUS) ==> n PLUS m = #({[x,0]: x in n} + {[x,1]: x in m})
    APPLY() fcn_symbol(f(x)->car(x),g->f,s->{[x,0]: x in n}) ==> 
      Svm(f) & domain(f) = {[x,0]: x in n} & range(f) = {car(x): x in {[x,0]: x in n}} &
        (((FORALL x in {[x,0]: x in n} | (FORALL y in {[y,0]: y in n} | ((car(x) = car(y)) imp (y = z))))) imp one_1_map(f))
    APPLY() fcn_symbol(f(x)->car(x),g->g,s->{[x,1]: x in m}) ==> 
      Svm(g) & domain(g) = {[x,1]: x in m} & range(g) = {car(x): x in {[x,1]: x in m}} &
        ((FORALL x in {[x,1]: x in n} | (FORALL y in {[y,1]: y in n} | ((car(x) = car(y)) imp (y = z)))) imp one_1_map(g))
    SIMPLF ==> range(f) = {car([x,0]): x in n} & range(g) = {car([x,1]): x in m} & 
        ((FORALL x in n | (FORALL y in n | ((car([x,0]) = car([y,0])) imp (x = y)))) imp one_1_map(f)) &
        ((FORALL x in m | (FORALL y in m | ((car([x,1]) = car([y,1])) imp (x = y)))) imp one_1_map(f))
    ELEM ==> car([X,0]) = X & car([X,1]) = X
    EQUAL ==> range(f) = {x: x in n} & range(g) = {x: x in m} & 
        ((FORALL x in n | (FORALL y in n | ((x = y) imp (x = y))) imp one_1_map(f))) &
        ((FORALL x in m | (FORALL y in m | ((x = y) imp (x = y))) imp one_1_map(g)))
    SIMPLF ==> range(f) = n & range(g) = m
    Suppose ==> Stat1: not((FORALL x in n | (FORALL y in n | ((x = y) imp (x = y)))) or (FORALL x in m | (FORALL y in m | ((x = y) imp (x = y)))))
    (a,b,c,d) --> Stat1 ==> false; Discharge ==> one_1_map(f) & one_1_map(g)
    (n,m) --> T122 ==> {[x,0]: x in n} * {[x,1]: x in m} = 0
    (f,g) --> T52 ==> one_1_map(f + g)
    (f,g) --> T43 ==> range(f + g) = range(f) + range(g)
    (f,g) --> T42 ==> domain(f + g) = domain(f) + domain(g)
    (f + g) --> T84 ==> #domain(f + g) = #range(f + g)
    ELEM ==> false; Discharge ==> QED

Theorem 160: (N * M = 0 & N2 * M2 = 0 & #N = #N2 & #M = #M2) imp (#(N + M) = #(N2 + M2)). Proof:
    Suppose_not(n,m,n2,m2) ==> n * m = 0 & n2 * m2 = 0 & #n = #n2 & #m = #m2 & #(n + m) /= #(n2 + m2)
    (n,n2,f) --> T80 ==> one_1_map(f) & domain(f) = n & range(f) = n2
    (m,m2,g) --> T80 ==> one_1_map(g) & domain(g) = m & range(g) = m2
    THUS ==> one_1_map(f + g) & range(f + g) = range(f) + range(g) & domain(f + g) = domain(f) + domain(g)
    THUS ==> #domain(f + g) = #range(f + g)
    ELEM ==> false; Discharge ==> QED
    
Theorem 161: [Subtraction Lemma] (M incin N) imp (#N = #M PLUS (N MINUS M)). Proof:
    Suppose_not(m,n) ==> m incin n & #n /= #m PLUS (n MINUS m)
    ELEM ==> n = m + n - m & m * (n - m) = 0
    (n,0,m,(n - m)) --> T160 ==> #n = #m PLUS #(n - m)
    Use_Def(MINUS) ==> false; Discharge ==> QED
    
Theorem 162: [Subtraction Lemma] (#M in #N or #M = #N) imp (#N = #M PLUS (#N MINUS #M)). Proof:
    Suppose_not(m,n) ==> (#m in #n or #m = #n) & #n /= #m PLUS (#n MINUS #m)
    THUS ==> #m incin #n
    (#m,#n) --> T161 ==> ##n = ##m PLUS (#n MINUS #m)
    N --> T93 ==> ##n = #n
    M --> T93 ==> false; Discharge ==> QED

Theorem 163: [Union set as an upper bound] (FORALL x in S | x incin Un(S)) & ((FORALL x in S | x incin T) imp (Un(S) incin T)). Proof:
		Suppose_not(s,t) ==> (not(FORALL x in s | x incin Un(s))) or ((FORALL x in s | x incin t) & (not (Un(s) incin t)))
    Suppose ==> Stat1: not(FORALL x in s | x incin Un(s))
    x --> Stat1 ==> x in s & (not(x incin Un(s)))
    Memb(c) ==> c in x & c notin Un(s)
    Use_Def(Un) ==> Stat2: c notin {z: y in s, z in y}
    (x,c) --> Stat2 ==> false; Discharge ==> Stat3: (FORALL x in s | x incin t) & (not (Un(s) incin t))
    Memb(d) ==> d in Un(s) & d notin t
    Use_Def(Un) ==> Stat4: d in {z: y in s, z in y}
    (a,b) --> Stat4 ==> d = a & b in s & a in b
    b --> Stat3 ==> false; Discharge ==> QED

Theorem 164: [The union of a set of ordinals is an ordinal] (FORALL x in S | Ord(x)) imp Ord(Un(S)). Proof:
    Suppose_not(s) ==> Stat0: (FORALL x in s | Ord(x)) & (not(Ord(Un(s))))
    Use_Def(Ord) ==> 
      (not((FORALL x in Un(s) | x incin Un(s))) & (FORALL x in Un(s) | (FORALL y in Un(s) | x in y or y in x or x = y)))
    Use_Def(Un) ==> 
      (not((FORALL x in {z: y in s, z in y} | x incin {z: y in s, z in y}))) or 
        (not((FORALL x in {z: y in s, z in y} | (FORALL y in {z: y in s, z in y} | x in y or y in x or x = y))))
    Suppose ==> Stat1: not (FORALL x in {z: y in s, z in y} | x incin {z: y in s, z in y})
    x --> Stat1 ==> Stat1: x in {z: y in s, z in y} & (not(x incin {z: y in s, z in y}))
    (a,b) --> Stat2 ==> x = b & a in s & b in a & (not(x incin {z: y in s, z in y}))
    Memb(c) ==> c in b & Stat2: (not(c in {z: y in s, z in y}))
    a --> Stat0 ==> Ord(a)
    Use_Def(Ord) ==> Stat4: (FORALL x in a | x incin a)
    b --> Stat4 ==> c in a
    (a,c) --> Stat2 ==> false; Discharge ==> 
        Stat5: not((FORALL x in {z: y in s, z in y} | (FORALL y in {z: y in s, z in y} | x in y or y in x or x = y)))
    (u,v) --> Stat5 ==> Stat6: u in {z: y in s, z in y} & v in {z: y in s, z in y} & (not(u in v or v in u or u = v))
    (au,bu,av,bv) --> Stat6 ==> au in s & u in au & av in s & v in av & (not(u in v or v in u or u = v))
    au --> Stat0 ==> Ord(au)
    av --> Stat0 ==> Ord(av)
    (au,u) --> T12 ==> Ord(u)
    (av,v) --> T12 ==> Ord(v)
    (u,v) --> T11 ==> false; Discharge ==> QED

Theorem 165: (M /= 0) imp (N OVER M incin N). Proof:
    Suppose_not(n,m) ==> m /= 0 & (not(n OVER m incin n))
    Memb(a) ==> a in m
    ELEM ==> m = (m - {a}) + {a}
    Use_Def(OVER) ==> not(Un({k in Z | k TIMES m incin n}) incin n)
    Memb(c) ==> c notin n & c in Un({k in Z | k TIMES m incin n})
    Use_Def(Un) ==> c in {x: y in {k in Z | k TIMES n incin n}, x in y}
    SIMPLF ==> Stat1: c in {x: k in Z, x in k | k TIMES m incin n}
    (k,x) --> Stat1 ==> k in Z & c in k & k TIMES m incin n
    (k,m - {a},{a}) --> T148 ==> k PROD m = (k PROD (m - {a})) + (k PROD {a})
    ELEM ==> k PROD m incs k PROD {a}
    (k PROD m,k PROD {a}) --> T83 ==> #(k PROD m) incs #(k PROD {a})
    (m,k) --> T140 ==> #(k PROD m) incs #k
    Use_Def(TIMES) ==> k TIMES m incs #k
    k --> T118 ==> Card(k)
    k --> T92 ==> k TIMES m incs k
    ELEM ==> false; Discharge ==> QED

Theorem 166: (M /= 0 & N in Z) imp (N OVER M in Z & N OVER M incin N). Proof:
    Suppose_not(n,m) ==> n in Z & m /= 0 & (n OVER m notin Z or (not(n OVER m incin n)))
    (n,m) --> T165 ==> n OVER m notin Z
    Use_Def(OVER) ==> n OVER m = Un({k in Z | k TIMES m incin n})
    Elem_Props ==> Ord(Z)
    Suppose ==> Stat3: not(FORALL x in {k in Z | k TIMES m incin n} | Ord(x))
    x2 --> Stat3 ==> x2 in Z & (not Ord(x2))
    x2 --> T118 ==> Card(x2)
    Use_Def(Card) ==> false; Discharge ==> (FORALL x in {k in Z | k TIMES m incin n} | Ord(x))
    {k in Z | k TIMES n incin m} --> T164 ==> Ord(n OVER m)
    n --> T118 ==> Finite(n)
    (m,n) --> T165 ==> n OVER m incin n
    (m,n) --> T98 ==> Finite(n OVER m)
    (m OVER n) --> T117 ==> Card(n OVER m)
    (m OVER n) --> T118 ==> false; Discharge ==> QED
 
Theorem 167: (N in Z & M in Z) imp (N PLUS M in Z & N TIMES M in Z & N MINUS M in Z). Proof:
    Suppose_not(n,m) ==> n in Z & m in Z & (not(n PLUS m in Z & n TIMES m in Z & n MINUS m in Z))
    Use_Def(PLUS) ==> n PLUS m = #({[x,0]: x in n} + {[x,1]: x in m})
    Use_Def(TIMES) ==> n TIMES m = #(n PROD m)
    Use_Def(MINUS) ==> n MINUS m = #(n - m)
    n --> T118 ==> Finite(n)
    m --> T118 ==> Finite(m)
    (n,m) --> T134 ==> Finite(n PLUS m)
    (n,m) --> T152 ==> Finite(n TIMES m)
    ELEM ==> n - m incin n
    (n,n - m) --> T98 ==> Finite(n - m)
    (n - m) --> T105 ==> Finite(n MINUS m)
    ({[x,0]: x in n} + {[x,1]: x in m}) --> T80 ==> Card(n PLUS m)
    (n PROD m) --> T80 ==> Card(n TIMES m)
    (n - m) --> T80 ==> Card(n MINUS m)
    (n PLUS m) --> T118 ==> n PLUS m in Z
    (n TIMES m) --> T118 ==> n TIMES m in Z
    (n MINUS m) --> T118 ==> QED

Theorem 169: [Strict monotonicity of addition] (M in Z & N in Z & N /= 0) imp (M in M PLUS N). Proof:
    Suppose_not(n,m) ==> m in Z & n in Z & n /= 0 & m notin m PLUS n
    Memb(e) ==> e in n
    Use_Def(PLUS) ==> m PLUS n = #({[x,0]: x in m} + {[x,1]: x in n})
    (m,n) --> T122 ==> {[x,0]: x in m} * {[x,1]: x in n} = 0
    Suppose ==> Stat2: [e,1] notin {[x,1]: x in n}
    e --> Stat2 ==> false; Discharge ==> {[x,1]: x in n} /= 0
    ELEM ==> {[x,0]: x in m} incin {[x,0]: x in m} + {[x,1]: x in n} & 
      {[x,0]: x in m} /= {[x,0]: x in m} + {[x,1]: x in n}
    ({[x,0]: x in m},{[x,0]: x in m} + {[x,1]: x in n}) --> T106 ==> #{[x,0]: x in m} in m PLUS m
    (m,any_g) --> T126 ==> #{[x,0]: x in m} = #m
    m --> T118 ==> Card(m)
    m --> T92 ==> #m = m
    ELEM ==> false; Discharge ==> QED

Theorem 170: [Strict monotonicity of addition] (M in Z & N in Z & K in N) imp (M PLUS K in M PLUS N). Proof:
    Suppose_not(n,m,k) ==> m in Z & n in Z & k in n & (m PLUS k) notin (m PLUS n)
    Elem_Props ==> Ord(n) & Ord(Z)
    Use_Def(Ord) ==> (FORALL n in Z | n incin Z) & (FORALL k in n | k incin n)
    (n,Z) --> Stat1 ==> (n incin Z) & (k incin n) & k /= n
    THUS ==> n = #n
    ELEM ==> n = (n - k) + k & (n - k) * k = 0 & n incs (n - k)
    THUS ==> (#n incs #(n - k) & #(n - k) in #n) or (#(n - k) = #n & k = #k)
    ELEM ==> #(n - k) in Z
    (n,0,n - k,k) --> T160 ==> #n = (#(n - k) PLUS #k)
    ELEM ==> Card(k)
    ELEM ==> n = (#(n - k) PLUS k)
    ELEM ==> (m PLUS k) notin (m PLUS (#(n - k) PLUS k))
    ALGEBRA ==> (m PLUS (#(n - k) PLUS k)) = ((m PLUS k) PLUS #(n - k)) & (m PLUS k) in Z
    ELEM ==> (m PLUS k) notin ((m PLUS k) PLUS #(n - k))
    (m PLUS k,#(n - k))--> T99999 ==> false; Discharge ==> QED

Theorem 171: [Cancellation] (M in Z & N in Z & K in Z & M PLUS K = N PLUS K) imp (M = N). Proof:
    Suppose_not(n,m,k) ==> m in Z & n in Z & k in n & m PLUS k = n PLUS k & n /= m
    Elem_Props ==> Ord(n) & Ord(m)
    (n,m) --> T11 ==> n in m or n = m or m in n
    Suppose ==> n in m
    (n,m,k) --> T170 ==> false; Discharge ==> n = m or m in n
    Suppose ==> m in n
    (m,n,k) --> T170 ==> false; Discharge ==> QED

Theorem 172: [Monotonicity of Addition] (M incin N) imp (M PLUS K incin N PLUS K). Proof:
    Suppose_not(n,m,k) ==> m incin n & (not (m PLUS k incin n PLUS k))
    Use_Def(PLUS) ==> not (#({[x,0]: x in m} + {[x,1]: x in k}) incin #({[x,0]: x in n} + {[x,1]: x in k}))
    Set_monot ==> {[x,0]: x in m} incin {[x,0]: x in n}
    ELEM ==> {[x,0]: x in m} + {[x,1]: x in k} incin {[x,0]: x in n} + {[x,1]: x in k}
    ({[x,0]: x in m} + {[x,1]: x in k},{[x,0]: x in n} + {[x,1]: x in k}) --> T83 ==> false; Discharge ==> QED

Theorem 173: [Monotonicity of Multiplication] (M incin N) imp (M TIMES K incin N TIMES K). Proof:
    Suppose_not(n,m,k) ==> m incin n & (not m TIMES k incin n TIMES k)
    Use_Def(TIMES) ==> not (#({[x,y]: x in m, y in k} incin #({[x,y]: x in n, y in k})))
    Set_monot ==> {[x,y]: x in m, y in k} incin {[x,y]: x in n, y in k}
    ({[x,y]: x in m, y in k},{[x,y]: x in n, y in k}) --> T83 ==> false; Discharge ==> QED

Theorem 174: [Monotonicity of Addition] (M in Z & N in Z & K in Z) imp (M PLUS K incin N PLUS K eq M incin N). Proof:
    Suppose_not(n,m,k) ==> m in Z & n in Z & k in n & (not(m PLUS k incin n PLUS k eq m incin n))
    ALGEBRA ==> m PLUS k in Z & n PLUS k in Z
    Elem_Props ==> Ord(m PLUS k) & Ord(n PLUS k) & Ord(m) & Ord(n)
    (m,n,k) --> T172 ==> m PLUS k incin n PLUS k & (not(m incin n))
    THUS ==> n in m
    (n,m,k) --> T170 ==> false; Discharge ==> QED
    
Theorem 175: [Strict monotonicity of subtraction] (N in Z & K in N & M incs N) imp (M MINUS N in M MINUS K). Proof: 
		Suppose_not(n,m,k) ==> m in Z & n in Z & k in n & m incs n & m MINUS n notin m MINUS k
    Use_Def(MINUS) ==> #(m - n) notin #(m - k)
    THUS ==> k incin n & k /= n
    ELEM ==> (m - n) incin (m - k) & (m - n) /= (m - k)
    (m - n,m - k) ==> false; Discharge ==> QED

Theorem 176: (M in Z & N in Z & K in Z & N incs M & N MINUS M incs K) imp 
                (N incs M PLUS K & N MINUS (M PLUS K) = (N MINUS M) MINUS K). Proof:
    Suppose_not(n,m,k) ==> m in Z & n in Z & k in Z & n incs m & n MINUS m incs k & 
                    (not(n incs m PLUS k) or n MINUS (m PLUS k) /= (n MINUS m) MINUS k)
    (n,m) --> T167 ==> n MINUS m in Z
    (n MINUS m,k) --> T167 ==> (n MINUS m) MINUS k in Z
    THUS ==> Card(n) & Card(m) & Card(n MINUS m) & n = #n & m = #m & k = #k
    (n MINUS m) --> T92 ==> n MINUS m = #(n MINUS m)
    (n,m) --> T161 ==> n = m PLUS (n MINUS m)
    ALGEBRA ==> n = (n MINUS m) PLUS m 
    (n MINUS m,k) --> T161 ==> (n MINUS m) = k PLUS ((n MINUS m) MINUS k)
    ALGEBRA ==> (n MINUS m) = ((n MINUS m) MINUS k) PLUS k 
    ELEM ==> n = (((n MINUS m) MINUS k) PLUS k) PLUS m
    ALGEBRA ==> n = ((n MINUS m) MINUS k) PLUS (k PLUS m)
    ELEM ==> ((n MINUS m) MINUS k) incs 0
    ((n MINUS m) MINUS k,0,(k PLUS m)) --> T174 ==> n incs k PLUS m
    ALGEBRA ==> m PLUS k = k PLUS m
    ELEM ==> n incs m PLUS k
    (n,m PLUS k) --> T161 ==> n = (m PLUS k) PLUS (n MINUS (m PLUS k))
    ALGEBRA ==> n = (n MINUS (m PLUS k)) PLUS (m PLUS k) 
    (n MINUS (m PLUS k),(n MINUS m) MINUS k,m PLUS k) --> T171 ==> QED

Theorem 177: (M in Z & N in Z) imp ((M PLUS N) MINUS N = M). Proof:
    Suppose_not(n,m) ==> m IN Z & n IN Z & (m PLUS n) MINUS n /= m
    ALGEBRA ==> m PLUS n in Z
    (m PLUS n,n) --> T167 ==> (m PLUS n) MINUS n in Z
    Elem_Props ==> Card(n) & Card(m) & Card(m PLUS n)
    n --> T92 ==> n = #n
    (0,m,n) --> T172 ==> (0 PLUS n) incin (m PLUS n)
    (m PLUS n,n) --> T167 ==> ((m PLUS n) MINUS n) in Z
    ALGEBRA ==> 0 PLUS n = n
    ELEM ==> n incin (m PLUS n)
    (m PLUS n,n) --> T161 ==> m PLUS n = n PLUS ((m PLUS n) MINUS n)
    ALGEBRA ==> m PLUS n = ((m PLUS n) MINUS n) PLUS n 
    (m,(m PLUS n) MINUS n,n) --> T171 ==> false; Discharge ==> QED

Theorem 178: [Integer Division with Remainder] (M in Z & N in Z & N /= 0) imp 
            (M OVER N in Z & M incs ((M OVER N) TIMES N) & M MOD N in N). Proof:
    Suppose_not(n,m) ==> m IN Z & n IN Z & n /= 0 & 
            (not(m OVER n IN Z & m incs ((m OVER n) TIMES n) & m MOD n in n))
    T119 ==> 1 IN Z
    Use_Def(1) ==> 1 = {0}
    Loc_def ==> r := arb({m MINUS (p TIMES n): p in Z | m incs (p TIMES n)})
    Suppose ==> {m MINUS (p TIMES n): p in Z | m incs (p TIMES n)} = 0
    ELEM ==> Stat1: m notin {m MINUS (p TIMES n): p in Z | m incs (p TIMES n)}
    0 --> Stat1 ==> not(m = n MINUS (0 TIMES n) & 0 in Z & m incs (0 TIMES n))
    Elem_Props ==> Card(n)
    n --> T92 ==> n = #n
    n --> T137 ==> 0 TIMES n = 0
    Use_Def(MINUS) ==> n MINUS 0 = n
    ELEM ==> false; Discharge ==> {m MINUS (p TIMES n): p in Z | m incs (p TIMES n)} /= 0
    {m MINUS (q TIMES n): q in Z | m incs (q TIMES n)} --> Ax_ch ==> 
      Stat1: r in {m MINUS (p TIMES n): p in Z | m incs (p TIMES n)} & 
        r * {m MINUS (p TIMES n): p in Z | m incs (p TIMES n)} = 0
    q --> Stat1 ==> r = m MINUS (q TIMES n) & q in Z & m incs (q TIMES n)
    (r,m) --> T167 ==> r in Z
    r --> T118 ==> Card(n) & Card(r) & Card(q)
    Use_Def(Card) ==> Ord(n) & Ord(r)
    r --> T92 ==> r = #r
    q --> T92 ==> q = #q
    Suppose ==> r incs n
    (r,n) --> T161 ==> r = (r MINUS n) PLUS n
    ALGEBRA ==> r = ((m MINUS (q TIMES n)) MINUS (1 TIMES n)) PLUS n
    (m,(q TIMES n),(1 TIMES n)) --> T176 ==> 
        r = (m MINUS ((q TIMES n) PLUS (1 TIMES n))) PLUS n & m incs ((q TIMES n) PLUS (1 TIMES n))
    ALGEBRA ==> (q TIMES n) PLUS (1 TIMES n) = (q PLUS 1) TIMES n & q PLUS 1 in Z
    Suppose ==> Stat2: m MINUS ((q PLUS 1) TIMES n) notin {m MINUS (p TIMES n): p in Z | m incs (p TIMES n)}
    (q PLUS 1) --> Stat2 ==> 
      not(m MINUS ((q PLUS 1) TIMES n) = m MINUS ((q PLUS 1) TIMES n) & m incs ((q PLUS 1) TIMES n))
    ELEM ==> false 
    Discharge ==> m MINUS ((q PLUS 1) TIMES n) in {m MINUS (p TIMES n): p in Z | m incs (p TIMES n)} 
    (q,q PLUS 1,n) --> T169 ==> q TIMES n in (q TIMES n) PLUS n
    ALGEBRA ==> (q TIMES n) PLUS n = (q PLUS 1) TIMES n
    (m,q TIMES n,(q PLUS 1) TIMES n) --> T175 ==> m MINUS ((q PLUS 1) TIMES n) in r
    ELEM ==> false; Discharge ==> not(r incs n)
    THUS ==> r in n & r = m MINUS (q TIMES n) & q in Z & m incs (q TIMES n)
    ELEM ==> r = m MINUS (q TIMES n) & r in n & q in Z & (q TIMES n) incin m
    Suppose ==> Stat3: not (q in {k in Z | k TIMES n incin m})
    q --> Stat3 ==> false; Discharge ==> q in {k in Z | k TIMES n incin m}
    Use_Def(OVER) ==> m OVER n = Un({k in Z | k TIMES n incin m})
    {k in Z | k TIMES n incin m} --> T163 ==> Stat4: (FORALL x in {k in Z | k TIMES n incin m} | x incin m OVER n)
    q --> Stat3 ==> q incin m OVER n
    (m,n) --> T166 ==> m OVER n in Z 
    THUS ==> q in m OVER n or m OVER n = q
    Suppose ==> q in Un({k in Z | k TIMES n incin m})
    Use_Def(Un) ==> q in {y: x in {x in Z | x TIMES n incin m}, y in x}
    SIMPLF ==> Stat4: q in {y: x in Z, y in x | x TIMES n incin m}
    (x,y) --> Stat4 ==> x in Z & q in x & x TIMES n incin m
    THUS ==> Ord(x) & Ord(q) & Card(x) & q + {q} incin x  
    x --> T92 ==> x = #x
    ELEM ==> x = x - (q + {q}) + (q + {q}) & q * {q} = 0
    (x - (q + {q}),q + {q}) --> T148 ==> (q + {q}) TIMES n incin m
    (q + {q},n) --> T147 ==> (q + {q}) TIMES n = n TIMES (q + {q})
    (n,q + {q}) --> T130 ==> (q + {q}) TIMES n = n TIMES #(q + {q})
    (q,{q}) --> T159 ==> (q + {q}) TIMES n = n TIMES (q PLUS {q})
    (q,{q}) --> T128 ==> (q + {q}) TIMES n = n TIMES (q PLUS #{q})
    (q) --> T177 ==> #{q} = 1
    ELEM ==> (q PLUS 1) TIMES n incin m
    ALGEBRA ==> n PLUS (q TIMES n) incin m
    Use_Def(MINUS) ==> (n PLUS (q TIMES n)) MINUS (q TIMES n) = #((n PLUS (q TIMES n)) - (q TIMES n)) &
                m MINUS (q TIMES n) = #(m - (q TIMES n))
    ELEM ==> (n PLUS (q TIMES n)) - (q TIMES n) incin m - (q TIMES n)
    ((n PLUS (q TIMES n)) - (q TIMES n),r) --> T83 ==> #((n PLUS (q TIMES n)) - (q TIMES n)) incin r
    (n,q TIMES n) --> T177 ==> n incin r
    ELEM ==> false; Discharge ==> QED
    
Theorem 179: #{S} = {{}}. Proof:
    Suppose_not(s) ==> #{s} /= {0}
    T86 ==> Card(0)
    Use_Def(next) ==> next(0) = {0}
    Use_Def(1) ==> 1 = {0}
    T119 ==> Card(1)
    0 --> T92 ==> #{0} = {0}
    COMPUTE ==> one_1_map({[{s},{0}]}) & domain({[{s},{0}]}) = {s} & range({[{s},{0}]}) = {0}
    Suppose ==> Stat1: not(EXISTS f in OM | one_1_map(f) & domain(f) = {s} & range(f) = {0})
    {[{s},{0}]} --> Stat1 ==> not(one_1_map({[{s},{0}]}) & domain({[{s},{0}]}) = {s}) & range({[{s},{0}]}) = {0}
    ELEM ==> false; Discharge ==> (EXISTS f in OM | one_1_map(f) & domain(f) = {s} & range(f) = {0})
    f --> T84 ==> #{s} = #{0}
    ELEM ==> false; Discharge ==> QED
    
Theorem 180: (#N = 0) imp (N = 0). Proof:
    Suppose_not(n) ==> #n = 0 & n /= 0
    Memb(c) ==> (c in n & c notin 0) or (c notin n & c in 0)
    ELEM ==> {c} incin n
    T83 ==> #{c} incin #n
    T179 ==> {{}} incin 0
    ELEM ==> false; Discharge ==> QED
    
Theorem 181: #N TIMES #M = 0 eq N = 0 or M = 0. Proof:
    Suppose_not(n,m) ==> (#n TIMES #m = 0 & n /= 0 & m /= 0) or ((n = 0 or m = 0) & (not #n TIMES #m = 0))
    Suppose ==> #n TIMES #m = 0 & n /= 0 & m /= 0
    Memb(c) ==> {c} incin n
    Memb(d) ==> {d} incin m
    THUS ==> #{c} incin #m & #{d} incin #m
    {d} --> T180 ==> {0} incin #m
    {c} --> T180 ==> {0} incin #n
    Suppose ==> [0,0] notin #n PROD #m
    Use_Def(PROD) ==> Stat1: [0,0] notin {[x,y]: x in #n, y in #m}
    (0,0) --> Stat1 ==> not([0,0] = [0,0] & 0 in #n & 0 in #m)
    ELEM ==> false; Discharge ==> [0,0] in #n PROD #m
    ELEM ==> {[0,0]} incin #n PROD #m
    THUS ==> #{[0,0]} incin #(#n PROD #m) 
    {[0,0]} --> T180 ==> {0} incin #(#n PROD #m) 
    Use_Def(TIMES) ==> {0} incin #n TIMES #m
    ELEM ==> false; Discharge ==> (n = 0 or m = 0) & (not #n TIMES #m = 0)
    T86 ==> Card(0)
    0 --> T92 ==> #0 = 0
    Suppose ==> n = 0
    n --> T137 ==> #n = #0
    #n --> T137 ==> false; Discharge ==> m = 0
    m --> T137 ==> #m = #0
    #m --> T136 ==> false; Discharge ==> QED

Theorem 182: (N incs M) imp ((N MINUS K) incs (M MINUS K)). Proof:
    Suppose_not(n,m,k) ==> n incs m & (not((n MINUS k) incs (m MINUS k)))
    Use_Def(MINUS) ==> not(#(n - k) incs #(m - k))
    THUS ==> not(n - k incs m - k)
    ELEM ==> false; Discharge ==> QED

Theorem 183: (Finite(N) & N incs M) imp (#(N - M) = #(#N - #M)). Proof:
    Suppose_not(n,m) ==> Finite(n) & n incs m & #(n - m) /= #(#n - #m)
    THUS ==> #m in #n or #m = #n
    ELEM ==> #n incs #n - #m
    Use_Def(MINUS) ==> n MINUS m = #(n - m) & #n MINUS #m = #(#n - #m)
    ELEM ==> (n - m) + m = n & (n - m) * m = 0 & n incs (n - m)
    (n - m,m) --> T159 ==> (n MINUS m) PLUS #m = #n
    (#n,#m) --> T162 ==> #m PLUS (#n MINUS #m) = #n
    (#n,#m) --> T146 ==> (#n MINUS #m) PLUS #m = #n
    THUS ==> Finite(n - m) & Finite(#n) & Finite(n MINUS m) & Finite(#n - #m) & Finite(#(#n - #m))
    THUS ==> 
      Card(n MINUS m) & Card(#n MINUS #m) & Card(n MINUS m) & Ord(#n MINUS #m) & Ord(n MINUS m) & Card(#n) & Card(#m)
    THUS ==> n MINUS m in Z & #n MINUS #m in Z & n in Z & m in Z
    (#n MINUS #m,n MINUS m) --> T11 ==> #n MINUS #m in n MINUS m or n MINUS m in #n MINUS #m
    ALGEBRA ==> #m PLUS (#n MINUS #m) = (#n MINUS #m) PLUS #m & #m PLUS (n MINUS m) = (n MINUS m) PLUS #m
    Suppose ==> #n MINUS #m in n MINUS #m
    (#m,#n) --> T162 ==> #m PLUS (#n MINUS #m) in #m PLUS (n MINUS m)
    ELEM ==> false; Discharge ==> n MINUS m in #n MINUS #m
    (#m,n MINUS m,#n MINUS #m) --> T162 ==> #m PLUS (n MINUS m) in #m PLUS (#n MINUS #m)
    ELEM ==> false; Discharge ==> QED

Theorem 184: (N in Z & M in Z) imp ((N PLUS M) MINUS M = N). Proof:
    Suppose_not(n,m) ==> n in Z & m in Z & (n PLUS m) MINUS m /= n
    Elem_Props ==> Finite(n) & Finite(m) & Card(m)
    (n,m) --> T132 ==> Finite(n + m)
    Use_Def(PLUS) ==> Finite(#({[x,0]: x in n} + {[x,1]: x in m})) & #({[x,0]: x in n} + {[x,1]: x in m}) MINUS m /= n
    ({[x,0]: x in n} + {[x,1]: x in m}) --> T105 ==> Finite({[x,0]: x in n} + {[x,1]: x in m})
    Use_Def(MINUS) ==> #(#({[x,0]: x in n} + {[x,1]: x in m}) - m) /= n
    m --> T92 ==> m = #m
    ELEM ==> #(#({[x,0]: x in n} + {[x,1]: x in m}) - #m) /= n
    APPLY() fcn_symbol(f(x)->car(x),g->f,s->{[x,1]: x in m})) ==> 
        Svm(f) & domain(f) = {[x,1]: x in m} & range(f) = {car(x): x in {[x,1]: x in m}} &
          ((FORALL y in {[x,1]: x in m} | (FORALL z in {[x,1]: x in m} | ((car(y) = car(z)) imp (y = z)))) imp one_1_map(f))
    SIMPLF ==> range(f) = {car([x,1]): x in m}
    ELEM ==> car([X,1]) = X
    EQUAL ==> range(f) = {x: x in m}
    SIMPLF ==> range(f) = m
    Suppose ==> Stat1: not((FORALL y in {[x,1]: x in m} | (FORALL z in {[x,1]: x in m} | ((car(y) = car(z)) imp (y = z)))))
    (y,z) --> Stat1 ==> Stat2: y in {[x,1]: x in m} & z in {[x,1]: x in m} & car(y) = car(z) & y /= z
    (u,v) --> Stat2 ==> y = [u,1] & u in m & z = [v,1] & v in m & car(y) = car(z) & y /= z
    ELEM ==> false; Discharge ==> one_1_map(f)
    f --> T84 ==> #range(f) = #domain(f)
    ELEM ==> #(#({[x,0]: x in n} + {[x,1]: x in m}) - #{[x,1]: x in m}) /= n
    ({[x,0]: x in n} + {[x,1]: x in m},{[x,1]: x in m}) --> T183 ==> 
                #(({[x,0]: x in n} + {[x,1]: x in m}) - {[x,1]: x in m}) /= n
    T121 ==> 1 /= 0
    (n,m) --> T122 ==> {[x,0]: x in n} + {[x,1]: x in m} - {[x,1]: x in m} = {[x,0]: x in n}
    ELEM ==> #{[x,0]: x in n} /= n
    APPLY() fcn_symbol(f(x)->car(x),g->h,s->{[x,0]: x in n})) ==> 
        Svm(h) & domain(h) = {[x,0]: x in n} & range(h) = {car(x): x in {[x,0]: x in n}} &
          ((FORALL y in {[x,0]: x in n} | (FORALL z in {[x,0]: x in n} | ((car(y) = car(z)) imp (y = z))) imp one_1_map(h)))
    SIMPLF ==> range(h) = {car([x,0]): x in n}
    ELEM ==> car([X,0]) = X
    EQUAL ==> range(h) = {x: x in n}
    SIMPLF ==> range(h) = n
    Suppose ==> Stat1: not((FORALL y in {[x,0]: x in n} | (FORALL z in {[x,0]: x in n} | ((car(y) = car(z)) imp (y = z)))))
    (y2,z2) --> Stat1 ==> Stat2: y2 in {[x,0]: x in n} & z2 in {[x,0]: x in n} & car(y2) = car(z2) & y /= z2
    (u2,v2) --> Stat2 ==> y = [u2,0] & u2 in m & z = [v2,0] & v2 in n & car(y2) = car(z2) & y2 /= z2
    ELEM ==> false; Discharge ==> one_1_map(h)
    h --> T84 ==> #range(h) = #domain(h)
    ELEM ==> false; Discharge ==> QED

Theorem 185: (N in Z & M in Z & K in Z) imp ((N incs M) eq ((N PLUS K) incs (M PLUS K))). Proof:
    Suppose_not(n,m,k) ==> n in Z & m in Z & k in Z & (not((n incs m) eq ((n PLUS k) incs (m PLUS k))))
    Suppose ==> n incs m & (not((n PLUS k) incs (m PLUS k)))
    Use_Def(PLUS) ==> not(#({[x,0]: x in n} + {[x,1]: x in k}) incs #({[x,0]: x in m} + {[x,1]: x in k}))
    ({[x,0]: x in n} + {[x,1]: x in k},{[x,0]: x in m} + {[x,1]: x in k}) --> T83 ==> 
            not(({[x,0]: x in n} + {[x,1]: x in k}) incs ({[x,0]: x in m} + {[x,1]: x in k}))
    Set_monot ==> {[x,0]: x in n} incs {[x,1]: x in n}
    ELEM ==> false; Discharge ==> not(n incs m) & (n PLUS k) incs (m PLUS k)
    (n,m,k) --> T182 ==> (n PLUS k) MINUS k incs (m PLUS k) MINUS k
    (n,k) --> T177 ==> n incs (m PLUS k) MINUS k
    (m,k) --> T177 ==> false; Discharge ==> QED
    
Theorem 186: (N incs M) imp (#N = #M PLUS #(N - M)). Proof:
    ELEM ==> N = M + (N - M) & M * (N - M) = 0
    (M,N - M) --> T162 ==> #N = #M PLUS #(N MINUS M)
    Use_Def(MINUS) ==> QED
    
Theorem 187: (N in Z & M in Z & K in Z & N incs M) imp ((N PLUS K) MINUS (M PLUS K) = N MINUS M). Proof:
    Suppose_not(n,m,k) ==> n in Z & m in Z & k in Z & n incs m & (n PLUS k) MINUS (m PLUS k) /= n MINUS m
    Elem_Props ==> Card(n) & Card(m)
    n --> T92 ==> n = #n
    m --> T92 ==> m = #m
    (n,m,k) --> T172 ==> n PLUS k incs m PLUS k
    ALGEBRA ==> n PLUS k in Z & m PLUS k in Z
    (n PLUS k,m PLUS k) --> T167 ==> (n PLUS k) MINUS (m PLUS k) in Z
    (n,m) --> T167 ==> n MINUS m in Z
    Elem_Props ==> Card(n PLUS k) & Card(m PLUS k)
    (n PLUS k) --> T92 ==> #(n PLUS k) = n PLUS k
    (m PLUS k) --> T92 ==> #(m PLUS k) = m PLUS k
    (m PLUS k,(n PLUS k)) --> T184 ==> (m PLUS k) PLUS ((n PLUS k) MINUS (m PLUS k)) = n PLUS k
    ALGEBRA ==> (n MINUS m) PLUS (m PLUS k) = (m PLUS (n MINUS m)) PLUS k
    (m,n) --> T161 ==> (n MINUS m) PLUS (m PLUS k) = n PLUS k
    ALGEBRA ==> ((n PLUS k) MINUS (m PLUS k)) PLUS (m PLUS k) = (m PLUS k) PLUS ((n PLUS k) MINUS (m PLUS k))
    ELEM ==> ((n PLUS k) MINUS (m PLUS k)) PLUS (m PLUS k) = (n MINUS m) PLUS (m PLUS k)
    ((n PLUS k) MINUS (m PLUS k),n MINUS m,m PLUS k) --> T171 ==> QED

Theorem 188: (N in Z & M in Z) imp (N = M PLUS (N MINUS M) or N = M MINUS (M MINUS N)). Proof:
    Suppose_not(n,m) ==> n in Z & m in Z & (not(n = m PLUS (n MINUS m) or n = m MINUS (m MINUS n)))
    Elem_Props ==> Ord(n) & Ord(m) & Card(n) & Card(m)
    n --> T92 ==> n = #n
    m --> T92 ==> m = #m
    (n,m) --> T10 ==> n incin m or m incin n
    Suppose ==> n incin m
    (n,n - m) --> T161 ==> false; Discharge ==> m incin n
    (m,m - n) --> T161 ==> false; Discharge ==> QED

THEORY ordval_fcn(s,f);                 [Elementary functions of ordinal-valued functions]
    s /= 0 & (FORALL x in s | Ord(f(x)))
==>
END ordval_fcn;

ENTER_THEORY ordval_fcn

Def 00: [Points at which f attains its minimum] rng := {x: x in s | f(x) = arb({f(u): u in s})}   
    
Theorem: [An ordinal-valued function attains its minimum]
    rng = {x: x in s | f(x) = arb({f(y): y in s})} & rng /= 0 & (FORALL x in rng | (FORALL y in s | f(x) incin f(y))). Proof:
    Suppose_not ==> 
      rng /= {x: x in s | f(x) = arb({f(y): y in s})} or rng = 0 or (not(FORALL x in rng | (FORALL y in s | f(x) incin f(y))))
    Use_Def(rng) ==> rng = 0 or (not(FORALL x in rng | (FORALL y in s | f(x) incin f(y))))
    Suppose ==> Stat1: not(FORALL x in rng | (FORALL y in s | f(x) incin f(y)))
    (x,y) --> Stat1 ==> Stat2: x in {x: x in s | f(x) = arb({f(u): u in s})} & y in s & (not(f(x) incin f(y)))
    a --> Stat2 ==> x in s & f(x) = arb({f(u): u in s})
    Suppose ==> Stat3: f(x) notin {f(u): u in s}
    x --> Stat3 ==> false; Discharge ==> {f(u): u in s} /= 0
    {f(y): y in s} --> Ax_ch ==> f(x) in {f(u): u in s} & f(x) * {f(u): u in s} = 0
    x --> Assump ==> Ord(f(x))
    y --> Assump ==> Ord(f(y))
    THUS ==> f(y) in f(x)
    Suppose ==> Stat4: f(y) notin {f(y): y in s}
    x --> Stat4 ==> false; Discharge ==> f(y) in {f(y): y in s}
    ELEM ==> false; Discharge ==> {x: x in s | f(x) = arb({f(u): u in s})} = 0
    Memb(c) ==> c in s
    Suppose ==> Stat5: f(c) notin {f(u): u in s}
    x --> Stat5 ==> false; Discharge ==> {f(u): u in s} /= 0
    {f(y): y in s} --> Ax_ch ==> Stat6: arb({f(y): y in s}) in {f(u): u in s}
    d --> Stat6 ==> arb({f(y): y in s}) = f(d) & d in s
    ELEM ==> Stat7: d notin {x: x in s | f(x) = arb({f(u): u in s})}
    d --> Stat7 ==> not(d in s & f(d) = arb({f(u): u in s}))
    ELEM ==> false; Discharge ==> QED

Theorem: rng incin s. Proof:
    ordval_fcn.1 ==> rng = {x: x in s | f(x) = arb({f(y): y in s})}
    Set_monot ==> rng incin {x: x in s}
    SIMPLF ==> QED
    
ENTER_THEORY set_theory

DISPLAY ordval_fcn

THEORY ordval_fcn(s,f);               [Elementary functions of ordinal-valued functions]
    s /= 0 & (FORALL x in s | Ord(f(x)))
==>(rng)
    rng = {x: x in s | f(x) = arb({f(y): y in s})} & rng /= 0 & (FORALL x in rng | (FORALL y in s | f(x) incin f(y)))
    rng incin s
END ordval_fcn;

THEORY well_ordered_set(s,Ordrel);
    (FORALL x in s | (FORALL y in s | ((Ordrel(x,y) or Ordrel(y,x) or x = y) & (not Ordrel(x,x))))) & 
      (FORALL x in s | (FORALL y in s | (FORALL z in s | ((Ordrel(x,y) & Ordrel(y,z)) imp Ordrel(x,z))))) &
        (FORALL t incin s | ((t /= 0) imp (EXISTS x in t | (FORALL y in t | Ordrel(x,y) or x = y))))
==>
END well_ordered_set;

ENTER_THEORY well_ordered_set

Theorem well_ordered_set.1: (FORALL t incin s | (EXISTS x | ((t /= 0) imp (x in t & (FORALL y in t | Ordrel(x,y) or x = y))))). Proof:
    Assump ==> (FORALL t incin s | ((t /= 0) imp (EXISTS x in t | (FORALL y in t | (Ordrel(x,y) or x = y)))))
    Quantif ==> QED

Minrel --> well_ordered_set.1 ==> 
      (FORALL t incin s | ((t /= 0) imp (Minrel(t) in t & (FORALL y in t | Ordrel(Minrel(t),y) or Minrel(t) = y)))). 

Def 00: orden(x) := if s incin {orden(y): y in x} then s else Minrel(s - {orden(y): y in x}) end if

Theorem well_ordered_set.2: s incin {orden(y): y in X} eq orden(X) = s. Proof: 
    Suppose_not(x) ==> not(s incin {orden(y): y in x} eq orden(x) = s)
    Suppose_not ==> s incin {orden(y): y in x} & orden(x) /= s
    Use_Def(orden) ==> false; Discharge ==> (not(s incin {orden(y): y in x})) & orden(x) = s
    Use_Def(orden) ==> s = Minrel(s - {orden(y): y in x})
    ELEM ==> s - {orden(y): y in x} /= 0 & s - {orden(y): y in x} incin s
    Use_Def(Minrel) ==> 
      Stat1: (FORALL t incin s | ((t /= 0) imp (Minrel(t) in t & (FORALL y in t | (Ordrel(Minrel(t),y) or Minrel(t) = y)))))
    (s - {orden(y): y in x}) --> Stat1 ==> Minrel(s - {orden(y): y in x}) in s - {orden(y): y in x}
    ELEM ==> false; Discharge ==> QED

Theorem well_ordered_set.3: (orden(X) /= s) imp (orden(X) in s). Proof:
    Suppose_not(x) ==> orden(x) /= s & orden(x) notin s
    Use_Def(orden) ==> orden(x) = if s incin {orden(y): y in x} then s else Minrel(s - {orden(y): y in x}) end if
    ELEM ==> (not (s incin {orden(y): y in x}) & s - {orden(y): y in x} /= 0) & s - {orden(y): y in x} incin s
    Use_Def(Minrel) ==> 
      Stat1: (FORALL t incin s | ((t /= 0) imp (Minrel(t) in t & (FORALL y in t | (Ordrel(Minrel(t),y) or Minrel(t) = y)))))
    (s - {orden(y): y in x}) --> Stat1 ==> Minrel(s - {orden(y): y in x}) in s - {orden(y): y in x}
    ELEM ==> false; Discharge ==> QED

Theorem well_ordered_set.4: [Monotonicity of Minrel] 
    (R incin s & T incin R & T /= 0) imp (Minrel(R) = Minrel(T) or Ordrel(Minrel(R),Minrel(T))). Proof: 
    Suppose_not(r,t) ==> r incin s & t incin r & t /= 0 & Minrel(r) /= Minrel(t) & (not Ordrel(Minrel(r),Minrel(t)))
    t --> Assump ==> Minrel(t) in t
    ELEM ==> r /= 0 & Minrel(t) in r
    r --> Assump ==> Minrel(r) in r & Stat1: (FORALL y in r | Ordrel(Minrel(r),y) or Minrel(r) = y)
    Minrel(t) --> Stat1 ==> Ordrel(Minrel(r),Minrel(t)) or Minrel(r) = Minrel(t)
    ELEM ==> false; Discharge ==> QED

Theorem well_ordered_set.5: [Well-ordering is isomorphic to ordinal enumeration] 
 (Ord(U) & Ord(V) & orden(U) /= s & orden(V) /= s) imp (Ordrel(orden(U),orden(V)) eq U in V). Proof: 
    Suppose_not(o1,o2) ==> 
      Ord(o1) & Ord(o2) & orden(o1) /= s & orden(o2) /= s & (not(Ordrel(orden(o1),orden(o2)) eq o1 in o2))
    o1 --> well_ordered_set.2 ==> (not(s incin {orden(y): y in o1})) & s - {orden(y): y in o1} /= 0
    o2 --> well_ordered_set.2 ==> (not(s incin {orden(y): y in o2})) & s - {orden(y): y in o2} /= 0
    Use_Def(orden) ==> orden(o1) = Minrel(s - {orden(y): y in o1}) & orden(o2) = Minrel(s - {orden(y): y in o2})
    Use_Def(Minrel) ==> 
      Stat1: (FORALL t incin s | ((t /= 0) imp (Minrel(t) in t & (FORALL y in t | (Ordrel(Minrel(t),y) or Minrel(t) = y)))))
    (s - {orden(y): y in o1}) --> Stat1 ==> orden(o1) in s - {orden(y): y in o1}
    (s - {orden(y): y in o2}) --> Stat1 ==> orden(o2) in s - {orden(y): y in o2}
    (o1,o2) --> T11 ==> o1 in o2 or o2 in o1 or o1 = o2
    (orden(o1),orden(o2)) --> Assump ==> (not (Ordrel(orden(o1),orden(o1)))) & 
            (Ordrel(orden(o1),orden(o2)) or Ordrel(orden(o2),orden(o1)) or orden(o2) = orden(o1))
    Suppose ==> o1 = o2
    ELEM ==> o1 notin o2
    ELEM ==> false; Discharge ==> o1 in o2 or o2 in o1
    Suppose ==> o1 in o2
    Suppose ==> Stat2: orden(o1) notin {orden(y): y in o2}
    o1 --> Stat2 ==> false; Discharge ==> orden(o1) in {orden(y): y in o2}
    ELEM ==> orden(o1) /= orden(o2)
    (o1,o2) --> T16 ==> o1 incin o2
    ELEM ==> s - {orden(y): y in o2} incin s - {orden(y): y in o2} & s - {orden(y): y in o2} incin s
    (s - {orden(y): y in o2},s - {orden(y): y in o2})-->well_ordered_set.4 ==> Ordrel(orden(o1),orden(o2))
    ELEM ==> Stat3: false; Discharge ==> o2 in o1
    LIKEWISE(Stat2-Stat3,o1->o2,o2->o1) ==> false; Discharge ==> QED
    
Theorem well_ordered_set.6: (Ord(V) & orden(V) /= s) imp ({u: u in s |  Ordrel(u,orden(V))} = {orden(x): x in V}). Proof:
    Suppose_not(o1) ==> Ord(o1) & orden(o1) /= s & {u: u in s |  Ordrel(u,orden(o1))} /= {orden(u): u in o1}
    APPLY() transfinite_induction(p(x)->Ord(x) & orden(x) /= s & {u: u in s |  Ordrel(u,orden(x))} /= {orden(u): u in x}) ==>
      Ord(o) & orden(o) /= s & {u: u in s |  Ordrel(u,orden(o))} /= {orden(u): u in o} &
              (FORALL x in o | Ord(x) & orden(x) /= s & {u: u in s |  Ordrel(u,orden(x))} /= {orden(u): u in x})
    o --> well_ordered_set.2 ==> (not(s incin {orden(y): y in o})) & s - {orden(y): y in o} /= 0
    Use_Def(orden) ==> orden(o) = Minrel(s - {orden(y): y in o})
    ELEM ==> (s - {orden(y): y in o}) incin s
    Use_Def(Minrel) ==> 
      Stat1: (FORALL t incin s | ((t /= 0) imp (Minrel(t) in t & (FORALL y in t | (Ordrel(Minrel(t),y) or Minrel(t) = y)))))
    (s - {orden(y): y in o}) --> Stat1 ==> orden(o) in s - {orden(y): y in o} & 
          Stat0: (FORALL y in s - {orden(y): y in o} | Ordrel(orden(o),y) or orden(o) = y)
    Suppose ==> not ({u: u in s |  Ordrel(u,orden(o))} incs {orden(u): u in o})
    Memb(c) ==> Stat2: c in {orden(u): u in o} & Stat3: c notin {u: u in s |  Ordrel(u,orden(o))}
    u --> Stat2 ==> c = orden(u) & u in o
    THUS ==> Ord(u) & u incin o
    ELEM ==> (not(s incin {orden(y): y in o})) & s - {orden(y): y in u} /= 0
    Use_Def(orden) ==> orden(u) = Minrel(s - {orden(y): y in u})
    Use_Def(Minrel) ==> orden(u) in s
    orden(u) --> Stat3 ==> not(Ordrel(orden(u),orden(o)))
    (o,u) --> well_ordered_set.5 ==> false; Discharge ==> not ({u: u in s |  Ordrel(u,orden(o))} incin {orden(u): u in o})
    Memb(b) ==> Stat4: b in {u: u in s |  Ordrel(u,orden(o))} & b notin {orden(u): u in o}
    a --> Stat4 ==> b in s & Ordrel(b,orden(o)) & b in s - {orden(u): u in o}
    b --> Stat0 ==> Ordrel(orden(o),b) or orden(o) = b
    (orden(o),b,orden(o),b,orden(o)) --> Assump ==> (not (Ordrel(orden(o),orden(o)))) & 
      (Ordrel(orden(o),b) & Ordrel(b,orden(o))) imp Ordrel(orden(o),orden(o))
    ELEM ==> false; Discharge ==> QED

Theorem well_ordered_set.7: [Well-ordering is initially 1-1] 
              (Ord(U) & Ord(V) & orden(U) /= s & orden(V) /= s & U /= V) imp (orden(U) /= orden(V)). Proof: 
    Suppose_not(o1,o2) ==> 
      Ord(o1) & Ord(o2) & orden(o1) /= s & orden(o2) /= s & o1 /= o2 & orden(o1) = orden(o2)
    o1 --> well_ordered_set.2 ==> s - {orden(y): y in o1} /= 0
    o2 --> well_ordered_set.2 ==> s - {orden(y): y in o2} /= 0
    Use_Def(orden) ==> orden(o1) = Minrel(s - {orden(y): y in o1}) & orden(o2) = Minrel(s - {orden(y): y in o2})
    Use_Def(Minrel) ==> orden(o1) in s - {orden(y): y in o1} & orden(o2) in s - {orden(y): y in o2}
    (o1,o2) --> T11 ==> o1 in o2 or o2 in o1
    Suppose ==> o1 in o2
    Suppose ==> Stat1: orden(o1) notin {orden(y): y in o2}
    o1 --> Stat1 ==> false; Discharge ==> orden(o1) in {orden(y): y in o2}
    ELEM ==> false; Discharge ==> o2 in o1
    Suppose ==> Stat2: orden(o2) notin {orden(y): y in o1}
    o1 --> Stat2 ==> false; Discharge ==> orden(o2) in {orden(y): y in o1}
    ELEM ==> false; Discharge ==> QED
      
Theorem well_ordered_set.8: 
    (EXISTS o | Ord(o) & s = {orden(x): x in o} & (FORALL x in o | orden(x) /= s) & one_1_map({[x,orden(x)]: x in o})). Proof:
    Suppose_not ==> 
    Stat0: (not(EXISTS o | Ord(o) & s = {orden(x): x in o}) & (FORALL x in o | orden(x) /= s) & one_1_map({[x,orden(x)]: x in o}))
    Suppose ==> Stat1: not(EXISTS o | Ord(o) & orden(o) = s)
    s --> T156 ==> #s in #pow(s)
    (pow(s)) --> T80 ==> Card(#pow(s))
    Elem_Props ==> Ord(#pow(s))
    (#pow(s)) --> Stat1 ==> orden(#pow(s)) /= s
    s --> well_ordered_set.2 ==> s - {orden(y): y in #pow(s)} /= 0
    Suppose ==> not ({orden(o): o in #pow(s)} incin s)
    Memb(a) ==> Stat2: a in {orden(o): o in #pow(s)} & (not a in s)
    b --> Stat2 ==> b in #pow(s) & orden(b) notin s
    THUS ==> Ord(b) & b incin #pow(s)
    Use_Def(orden) ==> orden(b) = Minrel(s - {orden(y): y in #pow(s)})
    Use_Def(Minrel) ==> orden(b) in s
    ELEM ==> false; Discharge ==> {orden(o): o in #pow(s)} incin s
    APPLY() fcn_symbol(f(x)->orden(x),g->f,s->#pow(s)) ==> 
      Svm(f) & domain(f) = #pow(s) & range(f) = {orden(x): x in #pow(s)} & 
          (((FORALL x in #pow(s) | (FORALL y in #pow(s) | ((orden(x) = orden(x)) imp (x = y))))) imp one_1_map(f))
      Suppose ==> Stat4: not (FORALL o1 in #pow(s) | (FORALL o2 in #pow(s) | ((orden(o1) = orden(o2)) imp (o1 = o2))))
    (d1,d2) --> Stat4 ==> d1 in #pow(s) & d2 in #pow(s) & orden(d1) = orden(d2) & d1 /= d2
    THUS ==> Ord(d1) & Ord(d2) & d1 incin #pow(s) & d2 incin #pow(s)
    ELEM ==> not (s incin {orden(y): y in d1}) & (not (s incin {orden(y): y in d2}))
    d1 --> well_ordered_set.3 ==> orden(d1) /= s
    d2 --> well_ordered_set.3 ==> orden(d2) /= s
    (d1,d2) --> well_ordered_set.7 ==> false; Discharge ==> one_1_map(f)
    f --> T84 ==> #pow(s) incin #s
    s --> T156 ==> #s incin #pow(s)
    ELEM ==> false; Discharge ==> Stat5: (EXISTS o | Ord(o) & orden(o) = s)
    o1 --> Stat5 ==> Ord(o1) & orden(o1) = s
    APPLY(o) transfinite_induction(p(x)->Ord(x) & orden(x) = s) ==>
      Ord(o) & orden(o) = s & Stat6: (FORALL x in o | not(Ord(x) & orden(x) = s))
    o --> Stat0 ==> s /= {orden(x): x in o} or (not(FORALL x in o | orden(x) /= s))
    Suppose ==> Stat7: not (FORALL x in o | orden(x) /= s)
    x --> Stat7 ==> x in o & orden(x) = s
    (o,x) --> T12 ==> Ord(o)
    x --> Stat6 ==> false; Discharge ==> s /= {orden(x): x in o}
    o --> well_ordered_set.2 ==> Stat8: (FORALL x in o | orden(x) /= s) & (not(s incs {orden(y): y in o}))
    Memb(c) ==> Stat9: c in {orden(y): y in o} & c notin s
    y --> Stat9 ==> y in o & orden(y) notin s
    y --> Stat8 ==> orden(y) /= s
    y --> well_ordered_set.3 ==> false; Discharge ==> not one_1_map({[x,orden(x)]: x in o})
    APPLY() fcn_symbol(f(x)->orden(x),g->f,s->o) ==> 
      f = {[x,orden(x)]: x in o} & Svm(f) & domain(f) = o & range(f) = {orden(x): x in o} & 
          ((FORALL x in o | FORALL y in o | ((orden(x) = orden(x)) imp (x = y))) imp one_1_map(f))
    Suppose ==> Stat10: not(FORALL x in o | (FORALL y in o | ((orden(x) = orden(x)) imp (x = y))))
    (u,v) --> Stat10 ==> u in o & v in o & orden(u) = orden(v) & u /= v
    (u,o) --> T12 ==> Ord(u)
    (v,o) --> T12 ==> Ord(v)
    (u,v) --> well_ordered_set.7 ==> false; Discharge ==> QED

Theorem well_ordered_set.9: ((Ord(V) & orden(V) /= s) imp one_1_map({[x,orden(x)]: x in V})) & 
          domain({[x,orden(x)]: x in V}) = V & range({[x,orden(x)]: x in V}) = {u: u in s |  Ordrel(u,orden(V))} &
      {u: u in s |  Ordrel(u,orden(V))} = {orden(x): x in V}. Proof:
    Suppose_not(v) ==> Ord(v) & orden(v) /= s & (not(one_1_map({[x,orden(x)]: x in v})) & 
          domain({[x,orden(x)]: x in v}) = v & range({[x,orden(x)]: x in V}) = {u: u in s |  Ordrel(u,orden(v))})
    APPLY() fcn_symbol(f(x)->orden(x),g->g,->v) ==> 
      Svm(g) & range(g) = {orden(x): x in v} & domain(g) = {x: x in v} &
          ((FORALL x in v | (FORALL y in v | ((orden(x) = orden(y)) imp (x = y)))) imp one_1_map(g))
    SIMPLF ==> {x: x in v} = v & domain(g) = v
    Suppose ==> Stat1: not (FORALL x in v | (FORALL y in v | ((orden(x) = orden(y)) imp (x = y))))
    (x,y) --> Stat1 ==> x in v & y in v & orden(x) = orden(y) & x /= y
    THUS ==> Ord(x) & Ord(y) & x incin v & y incin v
    v --> well_ordered_set.2 ==> not(s incin {orden(u): u in v})
    ELEM ==> (not (s incin {orden(u): u in x})) & (not (s incin {orden(u): u in y}))
    x --> well_ordered_set.2 ==> orden(x) /= s
    y --> well_ordered_set.2 ==> orden(y) /= s
    (x,y) --> well_ordered_set.7 ==> false; Discharge ==> one_1_map(g)
    v --> well_ordered_set.6 ==> false; Discharge ==> QED
    
ENTER_THEORY set_theory

DISPLAY well_ordered_set

THEORY well_ordered_set(s,Ordrel);
    (FORALL x in s | (FORALL y in s | (Ordrel(x,y) or Ordrel(y,x) or x = y) & (not Ordrel(x,x)))) & 
      (FORALL x in s | (FORALL y in s | (FORALL z in s | ((Ordrel(x,y) & Ordrel(y,z)) imp Ordrel(x,z))))) &
        (FORALL t incin s | ((t /= 0) imp (EXISTS x in t | (FORALL y in t | Ordrel(x,y) or x = y))))
==>(orden)
    s incin {orden(y): y in X} eq orden(X) = s 
    (orden(X) /= s) imp (orden(X) in s)
            [Well-ordering is isomorphic to ordinal enumeration] 
    (Ord(U) & Ord(V) & orden(U) /= s & orden(V) /= s) imp (Ordrel(orden(U),orden(V)) eq (U in V)) 
    (Ord(U) & orden(U) /= s) imp (orden(U) = {orden(x): x in U})
    (Ord(U) & Ord(V) & orden(U) /= s & orden(V) /= s & U /= V) imp (orden(U) /= orden(V))
    (EXISTS o | Ord(o) & s = {orden(x): x in o} & (FORALL x in o | orden(x) /= s) & one_1_map({[x,orden(x)]: x in o}))
    (Ord(V) & orden(V) /= s) imp (one_1_map({[x,orden(x)]: x in V}) & 
          domain({[x,orden(x)]: x in V} = V) & range({[x,orden(x)]: x in V}) = {u: u in s |  Ordrel(u,orden(V))})
END well_ordered_set;

THEORY product_order(o1,o2)
    Ord(o1) & Ord(o2)
==>
END product_order;

ENTER_THEORY product_order

Def 00: Ord1p2(X,Y) :eq car(X) + cdr(X) in car(Y) + cdr(Y) or 
             (car(X) + cdr(X) = car(Y) + cdr(Y) & car(X) in car(Y)) or 
             (car(X) + cdr(X) = car(Y) + cdr(Y) & car(X) = car(Y) & cdr(X) in cdr(Y))

Theorem product_order.1: (FORALL x in o1 PROD o2 | Ord(car(x))). Proof:
    Suppose_not(x) ==> x in o1 PROD o2 & (not Ord(car(x)))
    Use_Def(PROD) ==> Stat1: x in {[x,y]: x in o1, y in o2}
    (a,b) --> Stat1 ==> x = [a,b] & a in o1 & b in o2
    THUS ==> false; Discharge ==> QED

Theorem product_order.2: (FORALL x in o1 PROD o2 | Ord(cdr(x))). Proof:
    Suppose_not(x) ==> x in o1 PROD o2 & (not Ord(cdr(x)))
    Use_Def(PROD) ==> Stat1: x in {[x,y]: x in o1, y in o2}
    (a,b) --> Stat1 ==> x = [a,b] & a in o1 & b in o2
    THUS ==> false; Discharge ==> QED

Theorem product_order.3: (FORALL x in o1 PROD o2 | Ord(car(x) + cdr(x))). Proof:
    Suppose_not(x) ==> x in o1 PROD o2 & (not Ord(car(x) + cdr(x)))
    Use_Def(PROD) ==> Stat1: x in {[x,y]: x in o1, y in o2}
    (a,b) --> Stat1 ==> x = [a,b] & a in o1 & b in o2
    THUS ==> Ord(a) & Ord(b) & Ord(a + b)
    ELEM ==> false; Discharge ==> QED

Theorem product_order.4: (FORALL x in o1 PROD o2 | (FORALL y in o1 PROD o2 |
          ((Ord1p2(x,y) or Ord1p2(y,x) or x = y) & (not Ord1p2(x,x))))). Proof:
    Suppose_not ==> Stat1: not(FORALL x in o1 PROD o2 | (FORALL y in o1 PROD o2 |
          ((Ord1p2(x,y) or Ord1p2(y,x)) & ((Ord1p2(x,y) & Ord1p2(y,x)) eq x = y))))
    (x,y) --> Stat1 ==> x in o1 PROD o2 & y in o1 PROD o2 & 
      (not(Ord1p2(x,y) or Ord1p2(y,x) or x = y) or Ord1p2(x,x))
    Use_Def(PROD) ==> Stat1: x in {[x,y]: x in o1, y in o2} & y in {[x,y]: x in o1, y in o2}
    (a,b,c,d) --> Stat1 ==> x = [a,b] & a in o1 & b in o2 & y = [c,d] & c in o1 & d in o2
    THUS ==> Ord(a) & Ord(b) & Ord(c) & Ord(d) & (a in c or a = c or c in a) & (b in d or b = d or d in b)
    Use_Def(Ord1p2) ==> ((not(a in c or (a = c & b in d) or [a,b] = [c,d]) & 
                (not(c in a or (c = a & d in b) or [c,d] = [b,a]))) or 
                    (not((Ord1p2(x,y) & Ord1p2(y,x)) eq x = y)))
    ELEM ==> not((Ord1p2(x,y) & Ord1p2(y,x)) eq x = y)
    Use_Def(Ord1p2) ==> 
      (not(((a in b or (a = b & c in d) or [a,b] = [c,d])) & (b in a or (b = a & d in c) or [c,d] = [a,b])) 
                                                eq [a,b] = [c,d])
    ELEM ==> false; Discharge ==> QED
    
Theorem product_order.5: (FORALL x in o1 PROD o2 | (FORALL y in o1 PROD o2 | (FORALL z in o1 PROD o2 |
                      ((Ord1p2(x,y) & Ord1p2(y,z)) imp Ord1p2(x,z))))). Proof:
    Suppose_not ==> Stat1: not(FORALL x in o1 PROD o2 | (FORALL y in o1 PROD o2 | (FORALL z in o1 PROD o2 |
                            ((Ord1p2(x,y) & Ord1p2(y,z)) imp Ord1p2(x,z)))))
    (x,y,z) --> Stat1 ==> x in o1 PROD o2 & y in o1 PROD o2 & z in o1 PROD o2 & Ord1p2(x,y) & Ord1p2(y,z) &
                  (not(Ord1p2(x,z)))
    Use_Def(PROD) ==> 
      Stat1: x in {[x,y]: x in o1, y in o2} & y in {[x,y]: x in o1, y in o2} & z in {[x,y]: x in o1, y in o2}
    (a,b,c,d,e,f) --> Stat1 ==> 
      x = [a,b] & a in o1 & b in o2 & y = [c,d] & c in o1 & d in o2 & z = [e,f] & e in o1 & f in o2
    THUS ==> (a incin b or b incin a) & (c incin d or d incin c) & (e incin f or f incin e) &
            (a in e or e in a or a = e) & (b in f or f in b or b = f) & 
                Ord(a) & Ord(b) & Ord(c) & Ord(d) & Ord(e) & Ord(f)
    ELEM ==> Ord(a + b) & Ord(c + d) & Ord(e + f)
    (a + b,c + d) --> T16 ==> (a + b in c + d) imp (a + b incin c + d)
    (c + d,e + f) --> T16 ==> (c + d in e + f) imp (c + d incin e + f)
    Use_Def(Ord1p2) ==> ((a + b in c + d or (a + b = c + d & a in c)) or (a + b = c + d & a = c & b in d)) &
             (c + d in e + f or (c + d = e + f & c in e) or (c + d = e + f & c = e & d in f)) &
             (not(a + b in e + f or (a + b = e + f & a in e) or (a + b = e + f & a = e & b in f)))
    ELEM ==> a + b incin e + f & a + b incin c + d & c + d incin e + f
    (a + b,e + f) --> T16 ==> a + b = e + f & (a notin e or b notin f)
    ELEM ==> a + b = c + d & c + d = e + f & (a in c or a = c & b in d) & (c in e or c = e & d in f)
    (a,e) --> T16 ==> a incs e
    (c,a) --> T16 ==> c incs a
    (e,c) --> T16 ==> e incs c
    ELEM ==> a = c & c = e & b in d & d in f & b notin f
    (e,c) --> T16 ==> f incs d
    ELEM ==> false; Discharge ==> QED
    
Theorem product_order.6: (T incin o1 PROD o2 & T /= 0) imp (EXISTS x in T | (FORALL y in t | (Ord1p2(x,y) or (x = y)))). Proof:
    Suppose_not(t) ==> t incin o1 PROD o2 & t /= 0 & Stat0: (not(EXISTS x in t | (FORALL y in t | (Ord1p2(x,y) or (x = y)))))
    Suppose ==> Stat1: not(FORALL x in t | (Ord(car(x) + cdr(x))))
    a --> Stat1 ==> a in t & (not Ord(car(a) + cdr(a)))
    ELEM ==> a in o1 PROD o2
    Use_Def(PROD) ==> Stat2: a in {[x,y]: x in o1, y in o2}
    (b,c) --> Stat2 ==> a = [b,c] & b in o1 & c in o2 & (not Ord(b + c)) 
    THUS ==> b incin c or c incin b
    ELEM ==> false; Discharge ==> (FORALL x in t | Ord(car(x) + cdr(x)))
    APPLY(rel_1) ordval_fcn(s->t,f(x)->car(x) + cdr(x)) ==>
      rel_1 /= 0 & rel_1 incin t & Stat2: (FORALL x in rel_1 | (FORALL y in t | car(x) + cdr(x) incin car(y) + cdr(y)))
    Suppose ==> Stat3: not(FORALL x in rel_1 | Ord(car(x)))
    d --> Stat3 ==> d in rel_1 & (not Ord(car(d)))
    ELEM ==> d in o1 PROD o2
    Use_Def(PROD) ==> Stat4: d in {[x,y]: x in o1, y in o2}
    (b2,c2) --> Stat4 ==> d = [b2,c2] & b2 in o1 & (not Ord(b2))
    THUS ==> false; Discharge ==> (FORALL x in rel_1 | Ord(car(x)))
    APPLY(rel_2) ordval_fcn(rel_1,f(x)->) ==> 
      rel_2 /= 0 & rel_2 incin rel_1 & Stat5: (FORALL x in rel_2 | (FORALL y in rel_1 | car(x) incin car(y)))
    Suppose ==> Stat6: not(FORALL x in rel_2 | Ord(cdr(x)))
    e --> Stat6 ==> e in rel_2 & (not Ord(car(e)))
    ELEM ==> e in o1 PROD o2
    Use_Def(PROD) ==> Stat7: e in {[x,y]: x in o1, y in o2}
    (b3,c3) --> Stat7 ==> e = [b3,c3] & b3 in o1 & (not Ord(b3))
    THUS ==> false; Discharge ==> (FORALL x in rel_2 | Ord(cdr(x)))
    APPLY(rel_3) ordval_fcn(rel_2,f) ==> 
      rel_3 /= 0 & rel_3 incin rel_2 & Stat8: (FORALL x in rel_3 | (FORALL y in rel_2 | car(x) incin car(y)))
    Memb(x) ==> x in rel_3 & x in rel_2 & x in rel_1
    (x,y) --> Stat0 ==> y in t & (not(Ord1p2(x,y) or x = y))
    ELEM ==> x in o1 PROD o2 & y in o1 PROD o2
    Use_Def(PROD) ==> Stat9: x in {[u,v]: u in o1, v in o2} & y in {[u,v]: u in o1, v in o2}
    (u1,v1,u2,v2) --> Stat9 ==> x = [u1,v1] & u1 in o1 & v1 in o2 & y = [u2,v2] & u2 in o1 & v2 in o2
    THUS ==> Ord(car(x)) & Ord(cdr(x)) & Ord(car(y)) & Ord(cdr(y)) & 
          (car(x) incin cdr(x) or cdr(x) incin car(x)) & (car(y) incin cdr(y) or cdr(y) incin car(y))
    ELEM ==> Ord(car(x) + cdr(x)) & Ord(car(y) + cdr(y))
    Suppose ==> not(car(x) + cdr(x) in car(y) + cdr(y) or 
             (car(x) + cdr(x) = car(y) + cdr(y) & car(x) in car(y)) or 
             (car(x) + cdr(x) = car(y) + cdr(y) & car(x) = car(y) & cdr(x) in cdr(y)) or x = y)
    (x,y) --> Stat2 ==> car(x) + cdr(x) incin car(y) + cdr(y)
    THUS ==> car(x) + cdr(x) = car(y) + cdr(y)
    (x,y) --> Stat5 ==> car(x) incin cdr(y)
    THUS ==> car(x) = car(y)
    (x,y) --> Stat8 ==> car(x) incin cdr(y)
    THUS ==> cdr(x) = cdr(y) & x = y
    ELEM ==> false; Discharge ==> car(x) + cdr(x) in car(y) + cdr(y) or 
             (car(x) + cdr(x) = car(y) + cdr(y) & car(x) in car(y)) or 
             (car(x) + cdr(x) = car(y) + cdr(y) & car(x) = car(y) & cdr(x) in cdr(y)) or x = y
    Use_Def(Ord1p2) ==> Ord1p2(x,y) or x = y
    ELEM ==> false; Discharge ==> QED

ENTER_THEORY set_theory

DISPLAY product_order

THEORY product_order(o1,o2)         [The product-ordering of two ordinals is a well-ordering]
    Ord(o1) & Ord(o2)
==>(Ord1p2)
    (FORALL x in o1 PROD o2 | Ord(car(x))) 
    (FORALL x in o1 PROD o2 | Ord(cdr(x))) 
    (FORALL x in o1 PROD o2 | Ord(car(x) + cdr(x)))
    Ord1p2(X,Y) eq car(X) + cdr(X) in car(Y) + cdr(Y) or 
            (car(X) + cdr(X) = car(Y) + cdr(Y) & car(X) in car(Y)) or 
            (car(X) + cdr(X) = car(Y) + cdr(Y) & car(X) = car(Y) & cdr(X) in cdr(Y))
    (FORALL x in o1 PROD o2 | (FORALL y in o1 PROD o2 | (Ord1p2(x,y) or Ord1p2(y,x) or x = y) & (not Ord1p2(x,x))))
    (FORALL x in o1 PROD o2 | (FORALL y in o1 PROD o2 | (FORALL z in o1 PROD o2 | ((Ord1p2(x,y) & Ord1p2(y,z)) imp Ord1p2(x,z)))))
    (T incin o1 PROD o2 & T /= 0) imp (EXISTS x in T | (FORALL y in t | (Ord1p2(x,y) or x = y)))
END product_order;

Theorem 189: [One-more Lemma] (not Finite(S)) imp (#S = #(S + {C})). Proof:
    Suppose_not(s,c) ==> (not Finite(s)) & #s /= #(s + {c})
    ELEM ==> {c} * s = 0
    (s,f) --> T107 ==> Svm(f) & range(f) = s & domain(f) incin s & (not(s incin domain(f)))
    Memb(b) ==> {b} incin s & {b} * domain(f) = 0
    APPLY() fcn_symbol(f(x)->c,g->g,s->{b}) ==> 
      Svm({[x,c]: x in {b}}) & range({[x,c]: x in {b}}) = {c: x in {b}} & domain({[x,c]: x in {b}}) = {x: x in {b}}
    SIMPLF ==> {[x,c]: x in {b}} = {[b,c]}
    SIMPLF ==> {x: x in {b}} = {b}
    SIMPLF ==> {c: x in {b}} = {c}
    ELEM ==> Svm({[b,c]}) & range({[b,c]}) = {c} & domain({[b,c]}) = {b}
    (f,{[b,c]}) --> T46 ==> Svm(f + {[b,c]})
    (f,{[b,c]}) --> T42 ==> domain(f + {[b,c]}) incin s
    (f,{[b,c]}) --> T43 ==> range(f + {[b,c]}) = s + {c}
    THUS ==> #domain(f + {[b,c]}) incin #s
    (f + {[b,c]}) --> T85 ==> #(s + {c}) incin #s
    ELEM ==> (s + {c}) incin s
    ((s + {c}),s) --> T83 ==> false; Discharge ==> QED

Theorem 190: [Division-by-2 Lemma] (not Finite(S)) imp (EXISTS T | (#(T PROD {0,1}) = #S)). Proof:
    Suppose_not(s) ==> (not Finite(s)) & Stat0: (not(EXISTS T | (#(T PROD {0,1}) = #s)))
    s --> Stat0 ==> #(s PROD {0,1}) /= #s
    ELEM ==> s PROD {0,1} = s PROD ({0} + {1})
    (s,{0},{1}) --> T148 ==> s PROD {0,1} incs s PROD {0}
    THUS ==> #(s PROD {0,1}) incs #(s PROD {0})
    (s,0) --> T140 ==> #(s PROD {0,1}) incs #s
    (s PROD {0,1}) --> T80 ==> Card(#(s PROD {0,1}))
    T119 ==> 2 in Z
    Use_Def(2) ==> {0,1} in Z
    Elem_Props ==> Card({0,1}) & Ord({0,1}) & Ord(#s) & Ord(#(s PROD {0,1})) & Finite({0,1})
    ({0,1}) --> T92 ==> #{0,1} = {0,1}
    Use_Def(TIMES) ==> #(s PROD {0,1}) = s TIMES {0,1}
    (s,s) --> T129 ==> s TIMES {0,1} = #s TIMES #{0,1}
    Use_Def(TIMES) ==> #(s PROD {0,1}) = #(#s PROD {0,1})
    THUS ==> #s in #(s PROD {0,1})
    APPLY(p_ord) product_order(o1->#s,o2->{0,1}) ==> 
      Stat00: p_ord(X,Y) eq car(X) + cdr(X) in car(Y) + cdr(Y) or 
            (car(X) + cdr(X) = car(Y) + cdr(Y) & car(X) in car(Y)) or 
            (car(X) + cdr(X) = car(Y) + cdr(Y) & car(X) = car(Y) & cdr(X) in cdr(Y))
      (FORALL x in #s PROD {0,1} | (FORALL y in #s PROD {0,1} | (p_ord(x,y) or p_ord(y,x) or x = y) & (not p_ord(x,x))))
      (FORALL x in #s PROD {0,1} | (FORALL y in #s PROD {0,1} | (FORALL z in o1 PROD o2 | ((p_ord(x,y) & p_ord(y,z)) imp p_ord(x,z)))))
      (T incin #s PROD {0,1} & T /= 0) imp (EXISTS x in T | (FORALL y in t | (p_ord(x,y) or (x = y))))
    APPLY(orden) well_ordered_set(s->#s PROD {0,1},Ordrel->p_ord) ==> 
      (#s PROD {0,1} incin {orden(y): y in X} eq orden(X) = #s PROD {0,1}) & 
                Stat0: ((orden(X) /= #s PROD {0,1}) imp (orden(X) in #s PROD {0,1})) & 
    ((Ord(U) & Ord(V) & orden(U) /= #s PROD {0,1} & orden(V) /= #s PROD {0,1}) imp (p_ord(orden(U),orden(V)) eq (U in V))) & 
          ((Ord(U) & orden(U) /= #s PROD {0,1}) imp (orden(U) = {orden(x): x in U})) & 
    ((Ord(U) & Ord(V) & orden(U) /= #s PROD {0,1} & orden(V) /= #s PROD {0,1} & U /= V) imp (orden(U) /= orden(V))) & 
        Stat1: (EXISTS o | Ord(o) & #s PROD {0,1} = {orden(x): x in o}) & (FORALL x in o | orden(x) /= #s PROD {0,1})
          & one_1_map({[x,orden(x)]: x in o}) & 
      Stat2: ((Ord(V) & orden(V) /= #s PROD {0,1}) imp one_1_map({[x,orden(x)]: x in V})) & 
        domain({[x,orden(x)]: x in V}) = V & range({[x,orden(x)]: x in V}) = {u in #s PROD {0,1} | p_ord(u,orden(V))}
    o --> Stat1 ==> Ord(o) & #s PROD {0,1} = {orden(x): x in o} & Stat3: (FORALL x in o | orden(x) /= #s PROD {0,1}) & 
                            one_1_map({[x,orden(x)]: x in o})
    APPLY() fcn_symbol(f(x)->orden(x),g->g,s->o) ==> 
      g = {[x,orden(x)]: x in o} & Svm(g) & range(g) = #s PROD {0,1} & domain(g) = o
    g --> T85 ==> #(#s PROD {0,1}) incin #o
    ELEM ==> #s in #o
    #s --> Stat3 ==> Ord(#s) & orden(#s) /= #s PROD {0,1}
    #s --> Stat2 ==> one_1_map({[x,orden(x)]: x in #s}) & 
      domain({[x,orden(x)]: x in #s} = #s) & range({[x,orden(x)]: x in #s}) = {u in #s PROD {0,1} | p_ord(u,orden(#s))}
    #s --> Stat00 ==> orden(#s) in #s PROD {0,1}
    Use_Def(PROD) ==> Stat4: orden(#s) in {[x,y]: x in #s, y in {0,1}}
    (a,b) --> Stat4 ==> orden(#s) = [a,b] & a in #s & b in {0,1}
    THUS ==> a incin #s & #s * a = a
    ELEM ==> b = 0 or b = 1
    T119 ==> b in Z
    THUS ==> Ord(b) & Finite(b) & Ord(a) & ((a incin b) or (b incin a))
    ELEM ==> Ord(a + b)
    Use_Def(PROD) ==> 
      {u in #s PROD {0,1} | p_ord(u,orden(#s))} = {u in {[x,y]: x in #s, y in {0,1}} | p_ord(u,orden(#s))}
    SIMPLF ==> {u in #s PROD {0,1} | p_ord(u,orden(#s))} = {[x,y]: x in #s, y in {0,1} | p_ord([x,y],[a,b])}
    ([X,Y],[a,b]) --> Stat00 ==> 
      p_ord([X,Y],[a,b]) eq X + Y in a + b or (X + Y = a + b & X in a) or (X + Y = a + b & X = a & Y in b)
    EQUAL ==> {u in #s PROD {0,1} | p_ord(u,orden(#s))} = 
      {[x,y]: x in #s, y in {0,1} | x + y in a + b or (x + y = a + b & x in a) or (x + y = a + b & x = a & y in b)}
    Suppose ==> not (
      {[x,y]: x in #s, y in {0,1} | x + y in a + b or (x + y = a + b & x in a) or (x + y = a + b & x = a & y in b)}
        incin
      {[x,y]: x in (a + b) + {a + b}, y in {0,1}})
    Memb(d) ==> Stat4: d notin {[x,y]: x in (a + b) + {a + b}, y in {0,1}} & Stat5: d in 
      {[x,y]: x in #s, y in {0,1} | x + y in a + b or (x + y = a + b & x in a) or (x + y = a + b & x = a & y in b)}
    (x1,y1) --> Stat5 ==> d = [x1,y1] & x1 in #s & y1 in {0,1} & 
                (x1 + y1 in a + b or (x1 + y1 = a + b & x1 in a) or (x1 + y1 = a + b & x1 = a & y1 in b))
    ELEM ==> x1 incin a + b
    THUS ==> Ord(x1) & (x1 in a + b or x1 = a + b)
    (x1,y1) --> Stat4 ==> x1 notin (a + b) + {a + b}
    ELEM ==> false; Discharge ==> {u in #s PROD {0,1} | p_ord(u,orden(#s))} incin {[x,y]: x in next(a), y in {0,1}}
    Suppose ==> Finite(a)
    (a,b) --> T132 ==> Finite(a + b)
    (a + b) --> T113 ==> Finite((a + b) + {a + b})
    Use_Def(PROD) ==> {u in #s PROD {0,1} | p_ord(u,orden(#s))} incin ((a + b) + {a + b}) PROD {0,1}
    ({u in #s PROD {0,1} | p_ord(u,orden(#s))},((a + b) + {a + b}) PROD {0,1}) --> T98 ==> 
                      Finite(range({[x,orden(x)]: x in #s}))
    ({[x,orden(x)]: x in o}) --> T103 ==> Finite(#s)
    s --> T105 ==> false; Discharge ==> not Finite(a)
    (a,b) --> T109 ==> {0,1} in a
    THUS ==> {0,1} incin a & b incin a
    ELEM ==> {u in #s PROD {0,1} | p_ord(u,orden(#s))} = 
      {[x,y]: x in #s, y in {0,1} | x + y in a or (x + y = a & x in a) or (x + y = a & x = a & y in b)}
    SIMPLF ==> {[x,y]: x in #s, y in {0,1} | x + y in a or ((x + y = a & x in a) or (x + y = a & x = a & y in b))} = 
            {[x,y]: x in #s, y in {0,1} | 
              x in #s & y in {0,1} & (x + y in a or (x + y = a & x in a) or (x + y = a & x = a & y in b))}
    Suppose ==> Stat6:
      (not(FORALL x | (FORALL y | (x in #s & y in {0,1} & (x + y in a or (x + y = a & x in a) or (x + y = a & x = a & y in b)))))
        eq (x in #s & y in {0,1} & (x in a or (x = a & y in b))))
    (x,y) --> Stat6 ==> (not((x in #s & y in {0,1} & (x + y in a or (x + y = a & x in a) or (x + y = a & x = a & y in b))))
        eq (x in #s & y in {0,1} & (x in a or (x = a & y in b))))
    ELEM ==> x in #s & y in {0,1} & (not((x + y in a or (x + y = a & x in a) or (x + y = a & x = a & y in b)))
        eq (x in a or (x = a & y in b)))
    THUS ==> (x incin y or y incin x) & y incin {0,1} & Ord(x) & Ord(y) & (x in a or a incin x)
    Suppose ==> y incin x
    ELEM ==> false; Discharge ==> x incin y
    ELEM ==> (not(a incin x)) & x in a
    ELEM ==> false; Discharge ==> 
      (FORALL x | (FORALL y | (x in #s & y in {0,1} & (x + y in a or (x + y = a & x in a) or (x + y = a & x = a & y in b)))
        eq (x in #s & y in {0,1} & (x in a or (x = a & y in b)))))
    EQUAL ==> range({[x,orden(x)]: x in #s}) = 
            {[x,y]: x in #s, y in {0,1} | x in #s & y in {0,1} & (x in a or (x = a & y in b))}
    SIMPLF ==> range({[x,orden(x)]: x in #s}) = {[x,y]: x in #s, y in {0,1} | x in a or (x = a & y in b)}
    ELEM ==> #range({[x,orden(x)]: x in #s}) = #s
    ELEM ==> #s = #{[x,y]: x in #s, y in {0,1} | x in a or (x = a & y in b)}
    Suppose ==> b = 0
    ELEM ==> X in a or (X = a & Y in b) eq X in a
    EQUAL ==> #s = #{[x,y]: x in #s, y in {0,1} | x in a}
    SIMPLF ==> #s = #{[x,y]: x in #s * a, y in {0,1}}
    ELEM ==> #s = #{[x,y]: x in a, y in {0,1}}
    Use_Def(PROD) ==> #s = #(a PROD {0,1})
    a --> Stat0 ==> false; Discharge ==> b = 1
    Use_Def(1) ==> b = {0}
    Set_monot ==> #s = #({[x,y]: x in #s, y in {0,1} | x in a} + 
                          {[x,y]: x in #s, y in {0,1} | x = a & y in {0}})
    SIMPLF ==> #s = #({[x,y]: x in #s, y in {0,1} | x in a} + {[a,0]})
    Use_Def(PROD) ==> #s = #(a PROD {0,1} + {[a,0]})
    Suppose ==> Finite(a PROD {0,1})
    THUS ==> false; Discharge ==> not Finite(a PROD {0,1})
    (a PROD {0,1},[a,0]) --> T189 ==> #s = #(a PROD {0,1})
    a --> Stat0 ==> false; Discharge ==> QED
    
Theorem 191: [Cardinal Doubling Theorem] (Card(S) & (not Finite(S))) imp (#(S PROD {0,1}) = #S). Proof:
    Suppose_not(s1) ==> Card(s1) & (not Finite(s1)) & #(s1 PROD {0,1}) /= #s1
    APPLY(s) transfinite_induction(p(x)->Card(x) & (not Finite(x)) & #(x PROD {0,1}) /= #x) ==>
      Card(s) & (not Finite(s)) & #(s PROD {0,1}) /= #s & 
            Stat0: (FORALL x in s | not(Card(x) & (not Finite(x)) & #(x PROD {0,1}) /= #x))
    s --> T92 ==> s = #s
    (s,t) --> T190 ==> #(t PROD {0,1}) = s
    Use_Def(TIMES) ==> t TIMES {0,1} = s
    ALGEBRA ==> t TIMES {0,1} = {0,1} TIMES t
    ({0,1},t) --> T130 ==> s = {0,1} TIMES #t
    ELEM ==> #({0,1} PROD #t) = s & {0,1} = {0} + {1}
    t --> T80 ==> Card(#t)
    ({0},{1},T) --> T148 ==> #t PROD {0,1} = #t PROD ({0} + {1})
    ELEM ==> #t PROD {0,1} incs #t PROD {0}
    THUS ==> #(#t PROD {0,1}) incs #(#t PROD {0})
    ({0},#t) --> T140 ==> s incs #t
    THUS ==> Ord(s) & Ord(#t) & (#t in s or #t = s)
    Suppose ==> #t in s
    #t --> Stat0 ==> Finite(#t) or s = ##t
    t --> T93 ==> Finite(#t)
    Use_Def(2) ==> {0,1} = 2
    T119 ==> {0,1} in Z
    Elem_Props ==> Finite({0,1})
    (t,{0,1}) --> T152 ==> Finite(s)
    ELEM ==> false; Discharge ==> QED

Theorem 192: (not Finite(S)) imp (S PLUS T = #S + #T & #(S + T) = #S + #T). Proof:
    Suppose_not(s,t) ==> (not Finite(s)) & (s PLUS t /= #s + #t or #(s + t) = #s + #t)
    Suppose ==> s PLUS t /= #s + #t
    (s,t) --> T127 ==> #s PLUS #t /= #s + #t
    Elem_Props ==> Ord(#s) & Ord(#t)
    (#s,#t) --> T10 ==> #s incin #t or #t incin #s
    Set_monot ==> {[x,0]: x in #s} incin {[x,0]: x in #t}
    Suppose ==> #s incin #t
    (#s,#t) --> T98 ==> not Finite(#t)
    ELEM ==> #s PLUS #t /= #t & {[x,0]: x in #s} + {[x,1]: x in #t} incin {[x,0]: x in #t} + {[x,1]: x in #t}
    SIMPLF ==> {[x,0]: x in #t} + {[x,1]: x in #t} = {[x,y]: x in #t, y in {0,1}}
    Use_Def(PROD) ==> {[x,0]: x in #s} + {[x,1]: x in #t} incin #t PROD {0,1}
    ({[x,0]: x in #s} + {[x,1]: x in #t},#t PROD {0,1}) --> T83 ==> 
                #({[x,0]: x in #s} + {[x,1]: x in #t}) incin #(#t PROD {0,1})
    Use_Def(PLUS) ==> #s PLUS #t incin #(#t PROD {0,1})
    #t --> T140 ==> #s PLUS #t incin ##t
    #t --> T92 ==> #s PLUS #t incin #t
    (0,#s,#t) --> T172 ==> 0 PLUS #t incin #s PLUS #t 
    ALGEBRA ==> 0 PLUS #t = #t
    ELEM ==> false; Discharge ==> #t incin #s
    ELEM ==> #s PLUS #t /= #t & {[x,0]: x in #s} + {[x,1]: x in #t} incin {[x,0]: x in #s} + {[x,1]: x in #s}
    SIMPLF ==> {[x,0]: x in #s} + {[x,1]: x in #s} = {[x,y]: x in #s, y in {0,1}}
    Use_Def(PROD) ==> {[x,0]: x in #s} + {[x,1]: x in #t} incin #s PROD {0,1}
    ({[x,0]: x in #s} + {[x,1]: x in #t},#s PROD {0,1}) --> T83 ==> 
                  #({[x,0]: x in #s} + {[x,1]: x in #t}) incin #(#s PROD {0,1})
    Use_Def(PLUS) ==> #s PLUS #t incin #(#s PROD {0,1})
    #t --> T140 ==> #s PLUS #t incin ##s
    #t --> T92 ==> #s PLUS #t incin #s
    (0,#s,#t) --> T172 ==> 0 PLUS #s incin #s PLUS #t 
    ALGEBRA ==> 0 PLUS #s = #s
    ELEM ==> false; Discharge ==> s PLUS t = #s + #t & #(s + t) /= #s + #t
    ELEM ==> s + t = s + (t - s) & s * (t - s) = 0 & s incin s + t & t incin s + t
    (s - t,s) --> T83 ==> #(t - s) incin #t
    (s + t,s) --> T83 ==> #s incin #(s + t)
    (s + t,t) --> T83 ==> #t incin #(s + t)
    (s,t - s) --> T159 ==> #(s + t) = #s PLUS #(t - s)
    (s,t - s,t) --> T172 ==> #(s + t) = #s PLUS #t
    ELEM ==> false; Discharge ==> QED
    
Theorem 193: [Cardinal Square-root Lemma] (not Finite(S)) imp (EXISTS T | #(T PROD T) = #S). Proof:
    Suppose_not(s) ==> (not Finite(s)) & Stat0: (not(EXISTS T | #(T PROD T) = #s))
    s --> Stat0 ==> #(s PROD s) /= #s
    T86 ==> s /= 0
    Memb(c) ==> {c} incin s & s = (s - {c}) + {c}
    ELEM ==> s PROD s = s PROD ((s - {c}) + {c})
    (s,s - {c},{c}) --> T148 ==> s PROD s incs s PROD {c}
    THUS ==> #(s PROD s) incs #(s PROD {c})
    (s,c) --> T140 ==> #(s PROD s) incs #s
    Use_Def(TIMES) ==> #(s PROD s) = s TIMES s
    (s,s) --> T129 ==> s TIMES s = #s TIMES #s
    Use_Def(TIMES) ==> #(s PROD s) = #(#s PROD #s)
    THUS ==> Card(#(s PROD s)) & Card(#s) & Ord(#(s PROD s)) & Ord(#s) & #s in #(s PROD s)
    APPLY(p_ord) product_order(o1->#s,o2->#s) ==> 
      p_ord(X,Y) eq car(X) + cdr(X) in car(Y) + cdr(Y) or 
            (car(X) + cdr(X) = car(Y) + cdr(Y) & car(X) in car(Y)) or 
            (car(X) + cdr(X) = car(Y) + cdr(Y) & car(X) = car(Y) & cdr(X) in cdr(Y))
      (FORALL x in #s PROD #s | (FORALL y in #s PROD #s | (p_ord(x,y) or p_ord(y,x) or x = y) & (not p_ord(x,x))))
      (FORALL x in #s PROD #s | (FORALL y in #s PROD #s | (FORALL z in o1 PROD o2 | (p_ord(x,y) & p_ord(y,z)) imp p_ord(x,z))))
      ((T incin #s PROD #s & T /= 0) imp (EXISTS x in T | (FORALL y in t | (p_ord(x,y) or x = y))))
    APPLY(orden) well_ordered_set(s->#s PROD #s,Ordrel->p_ord) ==> 
      #s PROD #s incin {orden(y): y in X} eq orden(X) = #s PROD #s & 
        ((orden(X) /= #s PROD #s) imp (orden(X) in #s PROD #s)) & 
    ((Ord(U) & Ord(V) & orden(U) /= #s PROD #s & orden(V) /= #s PROD #s) imp (p_ord(orden(U),orden(V)) eq (U in V))) & 
          Stat00: ((Ord(U) & orden(U) /= #s PROD #s) imp (orden(U) = {orden(x): x in U})) & 
    ((Ord(U) & Ord(V) & orden(U) /= #s PROD #s & orden(V) /= #s PROD #s & U /= V) imp (orden(U) /= orden(V))) & 
        Stat1: (EXISTS o | Ord(o) & #s PROD #s = {orden(x): x in o} & (FORALL x in o | orden(x) /= #s PROD #s)
          & one_1_map({[x,orden(x)]: x in o})) & 
      Stat2: ((Ord(V) & orden(V) /= #s PROD #s) imp one_1_map({[x,orden(x)]: x in V})) & 
          domain({[x,orden(x)]: x in V}) = V & range({[x,orden(x)]: x in V}) = {u in #s PROD #s | p_ord(u,orden(V))}
    o --> Stat1 ==> Ord(o) & #s PROD #s = {orden(x): x in o} & Stat3: (FORALL x in o | orden(x) /= #s PROD #s) & 
                            one_1_map({[x,orden(x)]: x in o})
    APPLY() fcn_symbol(f(x)->orden(x),g->g,s->o) ==> 
      g = {[x,orden(x)]: x in o} & Svm(g) & range(g) = #s PROD #s & domain(g) = o
    g --> T85 ==> #(#s PROD #s) incin o
    ELEM ==> #s in o
    #s --> Stat3 ==> Ord(#s) & orden(#s) /= #s PROD #s
    #s --> Stat2 ==> one_1_map({[x,orden(x)]: x in #s}) & 
      domain({[x,orden(x)]: x in #s} = #s) & range({[x,orden(x)]: x in #s}) = {u in #s PROD #s | p_ord(u,orden(#s))}
    #s --> Stat00 ==> orden(#s) in #s PROD #s
    Use_Def(PROD) ==> Stat4: orden(#s) in {[x,y]: x in #s, y in #s}
    (a,b) --> Stat4 ==> orden(#s) = [a,b] & a in #s & b in #s & {a} * #s = {a}
    THUS ==> a incin #s & #s * a = a & #s * b = b & ##s = #{u in #s PROD #s | p_ord(u,orden(#s))}
    s --> T93 ==> #s = #{u in #s PROD #s | p_ord(u,orden(#s))}
    THUS ==> Ord(b) & Ord(a) & a incin b or b incin a
    ELEM ==> Ord(a + b) & (a + b = a or a + b = b) & a + b in s & #s * (a + b) = a + b & #s * a = a
    Use_Def(PROD) ==> 
      {u in #s PROD #s | p_ord(u,orden(#s))} = {u in {[x,y]: x in #s, y in #s} | p_ord(u,orden(#s))}
    SIMPLF ==> {u in #s PROD {0,1} | p_ord(u,orden(#s))} = {[x,y]: x in #s, y in #s | p_ord([x,y],[a,b])}
    ([X,Y],[a,b]) --> Stat00 ==> 
      p_ord([X,Y],[a,b]) eq X + Y in a + b or (X + Y = a + b & X in a) or (X + Y = a + b & X = a & Y in b)
    EQUAL ==> {u in #s PROD #s | p_ord(u,orden(#s))} = 
      {[x,y]: x in #s, y in #s | x + y in a + b or (x + y = a + b & x in a) or (x + y = a + b & x = a & y in b)}
    Set_monot ==> ({u in #s PROD #s | p_ord(u,orden(#s))} = {[x,y]: x in #s, y in #s | x + y in a + b} +
      {[x,y]: x in #s, y in #s | x + y = a + b & x in a}) + {[x,y]: x in #s, y in #s | x + y = a + b & x = a & y in b}
    Suppose ==> Stat4: not(FORALL x in #s | (FORALL y in #s | x + y eq x in a + b & y in a + b))
    (x1,y1) --> Stat4 ==> x1 in #s & y1 in #s & (not(x1 + y1 in a + b eq x1 in a + b & y1 in a + b))
    THUS ==> (x1 in a + b or a + b in x1 or x1 = a + b) & (y1 in a + b or a + b in y1 or y1 = a + b) &
            (x1 incin y1 or y1 incin x1)
    ELEM ==> false; Discharge ==> (FORALL x in #s | (FORALL y in #s | x + y eq x in a + b & y in a + b))
    EQUAL ==> {[x,y]: x in #s, y in #s | x + y in a + b} = {[x,y]: x in #s, y in #s | x in a + b & y in a + b}
    SIMPLF ==> {[x,y]: x in #s, y in #s | x + y in a + b} = {[x,y]: x in #s * (a + b), y in #s * (a + b)}
    ELEM ==> {[x,y]: x in #s, y in #s | x + y in a + b} = {[x,y]: x in a + b, y in a + b}
    Use_Def(PROD) ==> {u in #s PROD #s | p_ord(u,orden(#s))} = (((a + b) PROD (a + b) + 
      {[x,y]: x in #s, y in #s | x + y = a + b & x in a}) + {[x,y]: x in #s, y in #s | x + y = a + b & x = a & y in b})
    Suppose ==> Stat5: (not(FORALL x in #s | (FORALL y in #s | (x + y = a + b & x in a)) eq (y = a + b & x in a)))
    (x2,y2) --> Stat5 ==> x2 in #s & y2 in #s & (not((x2 + y2 = a + b & x2 in a) eq (y2 = a + b & x2 in a)))
    ELEM ==> x2 in #s & y2 in #s & x2 in a & (not(x2 + y2 = a + b eq y2 = a + b))
    THUS ==> (x2 incin y2 or y2 incin x2)
    ELEM ==> false; Discharge ==> (FORALL x in #s | (FORALL y in #s | (x + y = a + b & x in a) eq (y = a + b & x in a)))
    EQUAL ==> {[x,y]: x in #s, y in #s | x + y = a + b & x in a} = {[x,y]: x in #s, y in #s | y = a + b & x in a}
    SIMPLF ==> {[x,y]: x in #s, y in #s | y = a + b & x in a} = {[x,y]: x in #s * a, y in {a + b}}
    ELEM ==> {[x,y]: x in #s, y in #s | x + y = a + b & x in a} = {[x,y]: x in a, y in {a + b}}
    Use_Def(PROD) ==> {u in #s PROD #s | p_ord(u,orden(#s))} = (((a + b) PROD (a + b)) + (a PROD {a + b})) + 
                {[x,y]: x in #s, y in #s | x + y = a + b & x = a & y in b}
    Suppose ==> Stat6: (not(FORALL x in #s | (FORALL y in #s | (x + y = a + b & x = a & y in b)) eq (a = a + b & x = a & y in b)))
    (x3,y3) --> Stat5 ==> x3 in #s & y3 in #s & x3 = a & (not((x3 + y3 = a + b & y3 in b)) eq (a = a + b & y3 in b))
    THUS ==> (x3 incin y3 or y3 incin x3)
    ELEM ==> false 
    Discharge ==> (FORALL x in #s | (FORALL y in #s | (x + y = a + b & x = a & y in b) eq (a = a + b & x = a & y in b)))
    EQUAL ==> {[x,y]: x in #s, y in #s | x + y = a + b & x = a & y in b} = 
            {[x,y]: x in #s, y in #s | a = a + b & x = a & y in b}
    SIMPLF ==> {[x,y]: x in #s, y in #s | x + y = a + b & x = a & y in b} = 
            if a /= a + b then 0 else {[x,y]: x in {a}, y in b} end if
    SIMPLF ==> {[x,y]: x in #s, y in #s | x + y = a + b & x = a & y in b} = 
                            if a /= a + b then 0 else {a} PROD b end if
    ELEM ==> {u in #s PROD #s | p_ord(u,orden(#s))} = 
          (((a + b) PROD (a + b)) + (a PROD {a + b})) + if a /= a + b then 0 else {a} PROD b end if
    ELEM ==> #s = #((((a + b) PROD (a + b)) + (a PROD {a + b})) + if a /= a + b then 0 else {a} PROD b end if)
    Suppose ==> Finite(a + b)
    ELEM ==> a incin a + b & b incin a + b
    THUS ==> Finite(a) & Finite(b) & Finite(#a) & Finite(#b)
    (a + b,a + b) --> T152 ==> Finite((a + b) TIMES (a + b))
    Use_Def(TIMES) ==> Finite(#((a + b) PROD (a + b)))
    ((a + b) PROD (a + b)) --> T105 ==> Finite((a + b) PROD (a + b))
    (a,{a + b}) --> T140 ==> Finite(#(a PROD {a + b}))
    (a PROD {a + b}) --> T105 ==> Finite(a PROD {a + b})
    Suppose ==> not Finite(if a /= a + b then 0 else {a} PROD b end if)
    Suppose ==> a /= a + b
    ELEM ==> not Finite(0)
    T86 ==> false; Discharge ==> not Finite({a} PROD b)
    ({a},b) --> T138 ==> Finite(#({a} PROD b))
    (a PROD {a + b}) --> T105 ==> false; Discharge ==> Finite(if a /= a + b then 0 else {a} PROD b end if)
    ((a + b) PROD (a + b),a PROD {a + b}) --> T132 ==> Finite(((a + b) PROD (a + b)) + (a PROD {a + b}))
    ((((a + b) PROD (a + b)) + (a PROD {a + b})),if a /= a + b then 0 else {a} PROD b end if) --> T105 ==> 
      Finite((((a + b) PROD (a + b)) + (a PROD {a + b})) + if a /= a + b then 0 else {a} PROD b end if)
    ((((a + b) PROD (a + b)) + (a PROD {a + b})) + if a /= a + b then 0 else {a} PROD b end if) --> T105 ==> Finite(#s)
    s --> T105 ==> false; Discharge ==> not Finite(a + b)
    (a + b) --> T105 ==> not Finite(#(a + b))
    T86 ==> a + b /= 0
    Memb(d) ==> a + b = ((a + b) - {d}) + {d} 
    ((a + b) - {d},a + b,{d}) --> T148 ==> (a + b) PROD (a + b) incs (a + b) PROD {d}
    ((a + b) PROD (a + b),(a + b) PROD {d}) --> T83 ==> #((a + b) PROD (a + b)) incs #((a + b) PROD {d})
    (a + b,{d}) --> T140 ==> #((a + b) PROD (a + b)) incs #(a + b)
    (#((a + b) PROD (a + b)),#(a + b)) --> T98 ==> not Finite(#((a + b) PROD (a + b)))
    ((a + b) PROD (a + b)) --> T83 ==> not Finite((a + b) PROD (a + b))
    ELEM ==> ((a + b) PROD (a + b)) + (a PROD {a + b}) incs ((a + b) PROD (a + b))
    (((a + b) PROD (a + b)) + (a PROD {a + b}),(a + b) PROD (a + b)) --> T98 ==> 
                            not Finite((a + b) PROD (a + b) + (a PROD {a + b}))
    (a + b,b) --> T83 ==> #((a + b) PROD (a + b)) incs #b
    (a + b,a) --> T83 ==> #((a + b) PROD (a + b)) incs #a
    (a,{a + b}) --> T140 ==> #((a + b) PROD (a + b)) incs #(a PROD {a + b})
    ((a + b) PROD (a + b),#(a PROD {a + b})) --> T192 ==> 
        #(((a + b) PROD (a + b)) + (a PROD {a + b})) = #((a + b) PROD (a + b))
    Suppose ==> not (#(a + b) incs #if a /= a + b then 0 else {a} PROD b end if)
    Suppose ==> a /= a + b
    ELEM ==> not (#(a + b) incs #0)
    T86 ==> Card(0)
    0 --> T92 ==> false; Discharge ==> not (#(a + b) incs #({a} PROD b))
    ({a},b) --> T139 ==> not (#(a + b) incs #b)
    (a + b,b) --> T83 ==> false; Discharge ==> #(a + b) incs #if a /= a + b then 0 else {a} PROD b end if
    (((a + b) PROD (a + b)) + (a PROD {a + b}),if a /= a + b then 0 else {a} PROD b end if) --> T192 ==> 
        #((((a + b) PROD (a + b)) + (a PROD {a + b})) + if a /= a + b then 0 else {a} PROD b end if) 
                            = #((a + b) PROD (a + b))
    ELEM ==> #s = #((a + b) PROD (a + b))
    (a + b) --> Stat0 ==> false; Discharge ==> QED

Theorem 194: [Cardinal Square Theorem] (not Finite(S)) imp (#(S PROD S) = #S). Proof:
    Suppose_not(s1) ==> Card(s1) & (not Finite(s1)) & #(s1 PROD s1) /= #s1
    APPLY(s) transfinite_induction (p(x)->Card(x) & (not Finite(x)) & #(x PROD x) /= #x) ==>
      Card(s) & (not Finite(s)) & #(s PROD s) /= #s & 
            Stat0: (FORALL x in s | not(Card(x) & (not Finite(x)) & #(x PROD x) /= #x))
    s --> T92 ==> s = #s
    (s,t) --> T193 ==> #(t PROD t) = s
    Suppose ==> t = 0
    t --> T135 ==> t PROD t = 0
    (t PROD t) --> T86 ==> Card(t PROD t) & Finite(0)
    (t PROD t) --> T92 ==> false; Discharge ==> t /= 0
    Memb(c) ==> t = t - {c} + {c}
    (t - {c},{c}) --> T148 ==> t PROD t = ((t - {c}) PROD t) + ({c} PROD t)
    ELEM ==> t PROD t incs {c} PROD t
    t --> T80 ==> Card(#t)
    ({0,1} PROD #t,{0} PROD #t) --> T83 ==> #(t PROD t) incs #({c} PROD #t)
    ({0},#t) --> T139 ==> s incs ##t
    t --> T93 ==> s incs #t
    THUS ==> (Ord(s) & Ord(#t) & #t in s) or #t = s
    Suppose ==> #t in s
    #t --> Stat0 ==> Finite(#t) or s = ##t
    t --> T93 ==> Finite(#t)
    t --> T105==> Finite(t)
    (t,t) --> T152 ==> Finite(t TIMES t)
    Use_Def(TIMES) ==> false; Discharge ==> QED

Theorem 195: (T in S & Card(S) & (not Finite(S))) imp (S TIMES T = S). Proof:
    Suppose_not(s,t) ==> t in s & Card(s) & (not Finite(s)) & s TIMES t /= s
    Elem_Props ==> Ord(s) & Ord(t)
    (s,t) --> T10 ==> s incin t or t incin s
    Set_monot ==> {[x,0]: x in s} incin {[x,0]: x in t}
    Suppose ==> s incin t
    (s,t) --> T98 ==> not Finite(t)
    ELEM ==> s PLUS t /= t & {[x,0]: x in s} + {[x,1]: x in t} incin {[x,0]: x in t} + {[x,1]: x in t}
    SIMPLF ==> {[x,0]: x in t} + {[x,1]: x in t} = {[x,y]: x in t, y in {0,1}}
    Use_Def(PROD) ==> {[x,0]: x in s} + {[x,1]: x in t} incin t PROD {0,1}
    ({[x,0]: x in s} + {[x,1]: x in t},t PROD {0,1}) --> T83 ==> #({[x,0]: x in s} + {[x,1]: x in t}) incin #(t PROD {0,1})
    Use_Def(PLUS) ==> s PLUS t incin #(t PROD {0,1})
    t --> T191 ==> s PLUS t incin #t
    t --> T92 ==> s PLUS t incin t
    (0,s,t) --> T172 ==> 0 PLUS t incin s PLUS t 
    ALGEBRA ==> 0 PLUS t = t
    ELEM ==> false; Discharge ==> t incin s
    ELEM ==> s PLUS t /= t & {[x,0]: x in s} + {[x,1]: x in t} incin {[x,0]: x in s} + {[x,1]: x in s}
    SIMPLF ==> {[x,0]: x in s} + {[x,1]: x in s} = {[x,y]: x in s, y in {0,1}}
    Use_Def(PROD) ==> {[x,0]: x in s} + {[x,1]: x in t} incin s PROD {0,1}
    ({[x,0]: x in s} + {[x,1]: x in t},s PROD {0,1}) --> T83 ==> #({[x,0]: x in s} + {[x,1]: x in t}) incin #(s PROD {0,1})
    Use_Def(PLUS) ==> s PLUS t incin #(s PROD {0,1})
    t --> T191 ==> s PLUS t incin #s
    t --> T92 ==> s PLUS t incin s
    (0,s,t) --> T172 ==> 0 PLUS s incin s PLUS t 
    ALGEBRA ==> 0 PLUS s = s
    ELEM ==> false; Discharge ==> QED
    
Def 26: [Signed Integers] Si := {[x,y]: x in Z, y in Z | x = 0 or y = 0}
Def 27: [Signed Integer Reduction to Normal Form] 
    Red(P) := [car(P) MINUS (car(P) * cdr(P)),cdr(P) MINUS (car(P) * cdr(P))]
Def 28: [Signed Sum] 
    Def(MM S_PLUS NN) := Red([car(MM) PLUS car(NN),cdr(MM) PLUS cdr(NN)])
Def 28a: [Absolute value] S_ABS(M) := car(M) + cdr(M)
Def 28b: [Negative] S_Rev(M) := [cdr(M),car(M)]
Def 29: [Signed Product] Def(MM S_TIMES NN) := 
      Red([(car(M) TIMES car(N)) PLUS (cdr(M) TIMES cdr(N)),(car(M) TIMES cdr(N)) PLUS (car(N) TIMES cdr(M))])
Def 32: [Signed Difference] Def(N S_MINUS M) := Red([cdr(M) PLUS car(N),car(M) PLUS cdr(N)])
Def 33: [Sign of a signed integer] is_nonneg(x) := car(x) incs cdr(x)

Theorem 196: (M in Z & N in Z) imp (Red([M,N]) in Si & M * N in Z). Proof:
    Suppose_not(n,m) ==> m in Z & n in Z & (not(Red([m,n]) in Si) & m * n in Z)
    (m,m * n) --> T167 ==> m MINUS m * n in Z
    (n,m * n) --> T167 ==> m MINUS m * n in Z
    Elem_Props ==> Ord(m) & Ord(n) & Finite(n) & Finite(m)
    (m,n) --> T10 ==> m incin n or n incin m
    ELEM ==> (m * n = m or m * n = n) & (not(Red([m,n]) in Si))
    Use_Def(Red) ==> not([m MINUS m * n,n MINUS m * n] in Si)
    Use_Def(Red) ==> m MINUS m * n /= 0 & n MINUS m * n /= 0
    Suppose ==> m * n = m
    m --> T157 ==> false; Discharge ==> m * n = n
    m --> T157 ==> false; Discharge ==> QED

Theorem 197: (N in Si) imp (N = [car(N),cdr(N)] & (car(N) = 0 or cdr(N) = 0) & car(N) in Z & cdr(N) in Z & 
                        Red(N) = N & car(N) * cdr(N) in Z). Proof:
    Suppose_not(n) ==> 
      n in Si & (not(n = [car(n),cdr(n)]) & (car(n) = 0 or cdr(n) = 0) & car(n) in Z & cdr(n) in Z & 
                                      Red(n) = n & car(n) * cdr(n) in Z)
    Use_Def(Si) ==> n in {[x,y]: x in Z, y in Z | x = 0 or y = 0}
    (i,j) --> Stat1 ==> n = [i,j] & i in Z & j in Z & (i = 0 or j = 0)
    i --> T92 ==> i = #i
    j --> T92 ==> j = #j
    Elem_Props ==> Card(i) & Card(j) & Ord(i) & Ord(j)
    (i,j) --> T10 ==> i incin j or j incin i
    ELEM ==> i * j = i or i * j = j
    ELEM ==> i * j in Z
    Use_Def(Red) ==> Red([i,j]) = [i MINUS i * j,j MINUS i * j]
    i --> T158 ==> i MINUS 0 = #i
    j --> T158 ==> j MINUS 0 = #j
    ELEM ==> false; Discharge ==> QED
    
Theorem 199: (N in Si & M in Si) imp (N S_PLUS M in Si & N S_TIMES M in Si). Proof:
    N --> T197 ==> car(N) in Z & cdr(N) in Z
    M --> T197 ==> car(M) in Z & cdr(M) in Z
    Use_Def(S_PLUS) ==> N S_PLUS M = Red([car(N) PLUS car(M),cdr(N) PLUS cdr(M)])
    ALGEBRA ==> car(N) PLUS car(M) in Z & cdr(N) PLUS cdr(M) in Z
    (car(N) PLUS car(M),cdr(N) PLUS cdr(M)) --> T196 ==> N S_PLUS M in Si
    Use_Def(S_TIMES ) ==> N S_TIMES M = 
      Red([(car(N) TIMES car(M)) PLUS (cdr(N) TIMES cdr(M)),(car(N) TIMES cdr(M)) PLUS (car(M) TIMES cdr(N))])
    ALGEBRA ==> (car(N) TIMES car(M)) PLUS (cdr(N) TIMES cdr(M)) in Z & 
            (car(N) TIMES cdr(M)) PLUS (car(M) TIMES cdr(N)) in Z
    ((car(N) TIMES car(M)) PLUS (cdr(N) TIMES cdr(M)),(car(N) TIMES cdr(M)) PLUS (car(M) TIMES cdr(N))) --> T196 ==> QED
    
Theorem 200: (N in Z) imp (Red([N,N]) = [0,0]). Proof:
    Use_Def(Red) ==> Red([N,N]) = [N MINUS (N * N),N MINUS (N * N)]
    n --> T157 ==> QED

Theorem 201: (J in Z & K in Z & M in Z) imp (Red([J PLUS M,K PLUS M]) = Red([J,K])). Proof:
    Suppose_not(j,k,m) ==> j in Z & k in Z & m in Z & Red([j PLUS m,k PLUS m]) /= Red([j,k])
    Use_Def(Red) ==> Red([j PLUS m,k PLUS m]) = 
              [(j PLUS m) MINUS ((j PLUS m) * (k PLUS m)),
                (k PLUS m) MINUS ((j PLUS m) * (k PLUS m))]
    Use_Def(Red) ==> Red([j,k]) = [j MINUS (j * k),k MINUS (j * k)]
    Elem_Props ==> Ord(j) & Ord(k)
    (j,k) --> T10 ==> j incin k or k incin j
    Suppose ==> j incin k
    (j,k,m) --> T172 ==> j PLUS m incin k PLUS m
    ELEM ==> Red([j,k]) = [j MINUS j,k MINUS j]
    j --> T157 ==> Red([j,k]) = [0,k MINUS j]
    ELEM ==> Red([j PLUS m,k PLUS m]) = 
          [(j PLUS m) MINUS (j PLUS m),(k PLUS m) MINUS (j PLUS m)]
    j --> T157 ==> Red([j PLUS m,k PLUS m]) = [0,(k PLUS m) MINUS (j PLUS m)]
    (j,k,m) --> T187 ==> false; Discharge ==> k incin j
    (k,j,m) --> T172 ==> k PLUS m incin j PLUS m
    ELEM ==> Red([j,k]) = [j MINUS k,k MINUS k]
    j --> T157 ==> Red(n) = [j MINUS k,0]
    ELEM ==> Red([j PLUS m,k PLUS m]) = 
          [(j PLUS m) MINUS (k PLUS m),(k PLUS m) MINUS (k PLUS m)]
    j --> T157 ==> Red([j PLUS m,k PLUS m]) = [(j PLUS m) MINUS (k PLUS m),0]
    (k,j,m) --> T187 ==> false; Discharge ==> QED

Theorem 202: (J in Z & K in Z & N in Z & M in Z) imp ([J,K] S_PLUS [N,M] = [J,K] S_PLUS Red([N,M])). Proof:
    Suppose_not(j,k,n,m) ==> j in Z & k in Z & n in Z & m in Z & [j,k] S_PLUS [n,m] /= [j,k] S_PLUS Red([n,m])
    Elem_Props ==> Ord(n) & Ord(m) & Card(n) & Card(m)
    (n,m) --> T10 ==> n incin m or m incin n
    ELEM ==> n * m in Z & (n * m = n or n * m = m)
    (n,m) --> T167 ==> n MINUS n * m in Z
    (m,n) --> T167 ==> m MINUS n * m in Z
    n --> T92 ==> n = #n
    m --> T92 ==> m = #m
    ELEM ==> #(n * m) = n * m
    Use_Def(S_PLUS) ==> 
      Red([j PLUS n,k PLUS m]) /= Red([j PLUS car(Red([n,m])),k PLUS cdr(Red([n,m]))])
    Use_Def(Red) ==> Red([n,m]) = [n MINUS n * m,m MINUS n * m]
    ELEM ==> n incs n * m & m incs n * m & car(Red([n,m])) = n MINUS (n * m) & cdr(Red([n,m])) = m MINUS (n * m)
    (n,n * m) --> T161 ==> (n * m) PLUS car(Red([n,m])) = n
    (m,n * m) --> T161 ==> (n * m) PLUS cdr(Red([n,m])) = m
    ALGEBRA ==> car(Red([n,m])) PLUS (n * m) = n & cdr(Red([n,m])) PLUS (n * m) = m
    (j PLUS car(Red([n,m])),k PLUS cdr(Red([n,m])),n * m) --> T201 ==> 
      Red([j PLUS car(Red([n,m])),k PLUS cdr(Red([n,m]))]) = 
        Red([(j PLUS car(Red([n,m]))) PLUS (n * m),(k PLUS cdr(Red([n,m]))) PLUS (n * m)])
    ALGEBRA ==> Red([j PLUS car(Red([n,m])),k PLUS cdr(Red([n,m]))]) = 
        Red([j PLUS (car(Red([n,m])) PLUS (n * m)),(k PLUS cdr(Red([n,m])) PLUS (n * m))])
    ELEM ==> Red([j PLUS car(Red([n,m])),k PLUS cdr(Red([n,m]))]) = Red([j PLUS n,k PLUS m])
    ELEM ==> false; Discharge ==> QED

Theorem 203: (K in Si & N in Z & M in Z) imp (K S_PLUS [N,M] = K S_PLUS Red([N,M])). Proof:
    K --> T197 ==> K = [car(K),cdr(K)] & (car(K) = 0 or cdr(K) = 0) & car(K) in Z & cdr(K) in Z & Red(K) = K
    (car(K),cdr(K),N,M) --> T202 ==> QED

Theorem 204: (K in Si & N in Z & M in Z) imp (K S_TIMES [N,M] = K S_TIMES Red([N,M])). Proof:
    Suppose_not(k,n,m) ==> k in Si & n in Z & m in Z & k S_TIMES [n,m] /= k S_TIMES Red([n,m])
    k --> T197 ==> k = [car(k),cdr(k)] & (car(k) = 0 or cdr(k) = 0) & car(k) in Z & cdr(k) in Z & Red(k) = k
    THUS ==> Ord(n) & Ord(m) & (n incin m or m incin n)
    ELEM ==> n * m in Z
    THUS ==> n MINUS n * m in Z & m MINUS n * m in Z
    Use_Def(S_TIMES ) ==> 
      Red([(car(k) TIMES n) PLUS (cdr(k) TIMES m),(car(k) TIMES m) PLUS (n TIMES cdr(k))]) /= 
          Red([(car(k) TIMES car(Red([n,m]))) PLUS (cdr(k) TIMES cdr(Red([n,m]))),
                    (car(k) TIMES cdr(Red([n,m]))) PLUS (car(Red([n,m])) TIMES cdr(k))])
    Use_Def(Red) ==> Red([n,m]) = [n MINUS n * m,m MINUS n * m]
    ELEM ==> n incs n * m & m incs n * m & car(Red([n,m])) = n MINUS (n * m) & cdr(Red([n,m])) = m MINUS (n * m)
    ELEM ==> Red([(car(k) TIMES n) PLUS (cdr(k) TIMES m),(car(k) TIMES m) PLUS (n TIMES cdr(k))]) /= 
          Red([(car(k) TIMES (n MINUS (n * m))) PLUS (cdr(k) TIMES (m MINUS (n * m))),
    				(car(k) TIMES (m MINUS (n * m))) PLUS ((n MINUS (n * m)) TIMES cdr(k))])
     ((car(k) TIMES (n MINUS (n * m))) PLUS (cdr(k) TIMES (m MINUS (n * m))),    
      (car(k) TIMES (m MINUS (n * m))) PLUS ((n MINUS (n * m)) TIMES cdr(k)),    
        (car(k) TIMES (n * m)) PLUS (cdr(k) TIMES (n * m))) --> T201 ==> 
          Red([(car(k) TIMES (n MINUS (n * m))) PLUS (cdr(k) TIMES (m MINUS (n * m))),
                    (car(k) TIMES (m MINUS (n * m))) PLUS ((n MINUS (n * m)) TIMES cdr(k))]) =     
      Red([((car(k) TIMES (n MINUS (n * m))) PLUS (cdr(k) TIMES (m MINUS (n * m)))) 
        PLUS (car(k) TIMES (n * m)) PLUS (cdr(k) TIMES (n * m)),
              (car(k) TIMES (m MINUS (n * m))) PLUS ((n MINUS (n * m)) TIMES cdr(k))
                PLUS (car(k) TIMES (n * m)) PLUS (cdr(k) TIMES (n * m))])    
    ALGEBRA ==> Red([(car(k) TIMES (n MINUS (n * m))) PLUS (cdr(k) TIMES (m MINUS (n * m))),
                    (car(k) TIMES (m MINUS (n * m))) PLUS ((n MINUS (n * m)) TIMES cdr(k))]) = 
          Red([(car(k) TIMES n) PLUS (cdr(k) TIMES m),(car(k) TIMES m) PLUS (n TIMES cdr(k))])
    ELEM ==> false; Discharge ==> QED

Theorem 205: [Commutativity Lemma] (K in Si & N in Z & M in Z) imp (K S_PLUS [N,M] = [N,M] S_PLUS K). Proof:
    K --> T197 ==> K = [car(K),cdr(K)] & (car(K) = 0 or cdr(K) = 0) & car(K) in Z & cdr(K) in Z
    ALGEBRA ==> car(K) PLUS N = N PLUS car(K) & cdr(K) PLUS M = M PLUS cdr(K)
    ELEM ==> [car(K) PLUS N,cdr(K) PLUS M] = [N PLUS car(K),M PLUS cdr(K)] 
    Use_Def(S_PLUS) ==> QED

Theorem 206: [Commutativity Lemma] (J in Z & K in Z & N in Z & M in Z) imp ([J,K] S_PLUS [N,M] = [N,M] S_PLUS [J,K]). Proof:
    ALGEBRA ==> J PLUS N = N PLUS J & K PLUS M = M PLUS K
    ELEM ==> [J PLUS N,K PLUS M] = [N PLUS J,M PLUS K] 
    Use_Def(S_PLUS) ==> QED
    
Theorem 207: [Commutative Law for Addition] (N in Si & M in Si) imp (N S_PLUS M = M S_PLUS N). Proof:
    M --> T197 ==> M = [car(M),cdr(M)] & (car(M) = 0 or cdr(M) = 0) & car(N) in Z & cdr(M) in Z
    (N,car(M),cdr(M)) --> T206 ==> QED
    
Theorem 208: (J in Z & K in Z & N in Z & M in Z) imp ([J,K] S_PLUS [N,M] = Red([J,K]) S_PLUS Red([N,M])). Proof:
    (J,K) --> T196 ==> Red([J,K]) in Si
    (Red([J,K]),N,M) --> T202 ==> Red([J,K]) S_PLUS [N,M] = Red([J,K]) S_PLUS Red([N,M])
    (Red([J,K]),N,M) --> T205 ==> Red([J,K]) S_PLUS [N,M] = [N,M] S_PLUS Red([J,K])
    (N,M,J,K) --> T202 ==> [N,M] S_PLUS Red([J,K]) = [N,M] S_PLUS [J,K]
    Use_Def(S_PLUS) ==> [N,M] S_PLUS [J,K] = Red([N PLUS J,M PLUS K])
    Use_Def(S_PLUS) ==> [J,K] S_PLUS [N,M] = Red([J PLUS N,K PLUS M])
    (N,M,J,K) --> T206 ==> [N,M] S_PLUS [J,K] = [J,K] S_PLUS [N,M]
    ELEM ==> QED

Theorem 209: [Commutative Law for Multiplication] (N in Si & M in Si) imp (N S_TIMES M = M S_TIMES N). Proof:
    N --> T197 ==> N = [car(N),cdr(N)] & (car(N) = 0 or cdr(N) = 0) & car(N) in Z & cdr(N) in Z
    M --> T197 ==> M = [car(M),cdr(M)] & (car(M) = 0 or cdr(M) = 0) & car(N) in Z & cdr(M) in Z
    ALGEBRA ==> (car(M) TIMES car(N)) PLUS (cdr(M) PLUS cdr(N)) = (car(N) TIMES cdr(M)) PLUS (cdr(N) PLUS cdr(M)) &
      (car(N) TIMES cdr(M)) PLUS (car(M) PLUS cdr(N)) = (car(M) TIMES cdr(N)) PLUS (car(N) PLUS cdr(M))
    Use_Def(S_TIMES ) ==> QED

Theorem 210: [Associative Law] (K in Si & N in Si & M in Si) imp (N S_PLUS (M S_PLUS K) = (N S_PLUS M) S_PLUS K). Proof:
    N --> T197 ==> N = [car(N),cdr(N)] & (car(N) = 0 or cdr(N) = 0) & car(N) in Z & cdr(N) in Z
    M --> T197 ==> M = [car(M),cdr(M)] & (car(M) = 0 or cdr(M) = 0) & car(M) in Z & cdr(M) in Z
    K --> T197 ==> K = [car(K),cdr(K)] & (car(K) = 0 or cdr(K) = 0) & car(K) in Z & cdr(K) in Z
    (N,M) --> T199 ==> N S_PLUS M in Si
    (K,N S_PLUS M) --> T207 ==> (N S_PLUS M) S_PLUS K = K S_PLUS(N S_PLUS M)
    Use_Def(S_PLUS) ==> N S_PLUS (M S_PLUS K) = (N S_PLUS Red([car(M) PLUS car(K),cdr(M) PLUS cdr(K)]))
    Use_Def(S_PLUS) ==> K S_PLUS (n S_PLUS M) = K S_PLUS (Red([car(N) PLUS car(M),cdr(N) PLUS cdr(M)]))
    (N,car(M) PLUS car(K),cdr(M) PLUS cdr(K)) --> T203 ==> 
      (N S_PLUS Red([car(M) PLUS car(K),cdr(M) PLUS cdr(K)])) = N S_PLUS [car(M) PLUS car(K),cdr(M) PLUS cdr(K)]
    (K,car(N) PLUS car(M),cdr(N) PLUS cdr(M)) --> T203 ==> 
      (K S_PLUS Red([car(N) PLUS car(M),cdr(N) PLUS cdr(M)])) = K S_PLUS [car(N) PLUS car(M),cdr(N) PLUS cdr(M)]
    Use_Def(S_PLUS) ==> 
      N S_PLUS [car(M) PLUS car(K),cdr(M) PLUS cdr(K)] = 
            Red([car(N) PLUS (car(M) PLUS car(K)),cdr(N) PLUS (cdr(M) PLUS cdr(K))])
    Use_Def(S_PLUS) ==> 
      K S_PLUS [car(N) PLUS car(M),cdr(N) PLUS cdr(M)] = 
            Red([car(K) PLUS (car(N) PLUS car(M)),cdr(K) PLUS (cdr(N) PLUS cdr(M))])
    ALGEBRA ==> car(N) PLUS (car(M) PLUS car(K)) = car(K) PLUS (car(N) PLUS car(M))
          or cdr(N) PLUS (cdr(M) PLUS cdr(K)) = cdr(K) PLUS (cdr(N) PLUS cdr(M))
    ELEM ==> QED

Theorem 211: [Distributive Law] 
    (K in Si & N in Si & M in Si) imp (N S_TIMES (M S_PLUS K) = (N S_TIMES M) S_PLUS (N S_TIMES K)). Proof:
    N --> T197 ==> N = [car(N),cdr(N)] & (car(N) = 0 or cdr(N) = 0) & car(N) in Z & cdr(N) in Z
    M --> T197 ==> M = [car(M),cdr(M)] & (car(M) = 0 or cdr(M) = 0) & car(M) in Z & cdr(M) in Z
    K --> T197 ==> K = [car(K),cdr(K)] & (car(K) = 0 or cdr(K) = 0) & car(K) in Z & cdr(K) in Z
    (M,K) --> T199 ==> M S_PLUS K in Si
    (N,M) --> T199 ==> N S_TIMES M in Si
    (N,K) --> T199 ==> N S_TIMES K in Si
    ALGEBRA ==> car(M) PLUS car(K) in Z & cdr(M) PLUS cdr(K) in Z
    Use_Def(S_PLUS) ==> N S_TIMES (M S_PLUS K) = N S_TIMES Red([car(M) PLUS car(K),cdr(M) PLUS cdr(K)])
    (N,car(M) PLUS car(K),cdr(M) PLUS cdr(K)) --> T204 ==> 
      N S_TIMES (M S_PLUS K) = N S_TIMES [car(M) PLUS car(K),cdr(M) PLUS cdr(K)]
    Use_Def(S_TIMES ) ==> N S_TIMES (M S_PLUS K) = 
      Red([(car(N) TIMES (car(M) PLUS car(K))) PLUS (cdr(N) TIMES (cdr(M) PLUS cdr(K))), 
          (car(N) TIMES (cdr(M) PLUS cdr(K))) PLUS ((car(M) PLUS car(K)) TIMES cdr(N))])
    Use_Def(S_TIMES ) ==> (N S_TIMES M) S_PLUS (N S_TIMES K) = 
    Red([(car(N) TIMES car(M)) PLUS (cdr(N) TIMES cdr(M)),(car(N) TIMES cdr(M)) PLUS (car(M) TIMES cdr(N))]) S_PLUS 
        Red([(car(N) TIMES car(K)) PLUS (cdr(N) TIMES cdr(K)),(car(N) TIMES cdr(K)) PLUS (car(K) TIMES cdr(N))])
    ((car(N) TIMES car(M)) PLUS (cdr(N) TIMES cdr(M)),(car(N) TIMES cdr(M)) PLUS (car(M) TIMES cdr(N)),  
      (car(N) TIMES car(K)) PLUS (cdr(N) TIMES cdr(K)),(car(N) TIMES cdr(K)) PLUS (car(K) TIMES cdr(N))) --> T202 ==>
    (N S_TIMES M) S_PLUS (N S_TIMES K) = 
      ([(car(N) TIMES car(M)) PLUS (cdr(N) TIMES cdr(M)),(car(N) TIMES cdr(M)) PLUS (car(M) TIMES cdr(N))]) S_PLUS 
          ([(car(N) TIMES car(K)) PLUS (cdr(N) TIMES cdr(K)),(car(N) TIMES cdr(K)) PLUS (car(K) TIMES cdr(N))])
    Use_Def(S_PLUS) ==> (N S_TIMES M) S_PLUS (N S_TIMES K) = 
      [((car(N) TIMES car(M)) PLUS (cdr(N) TIMES cdr(M))) PLUS ((car(N) TIMES car(K)) PLUS (cdr(N) TIMES cdr(K))),
    ((car(N) TIMES cdr(M)) PLUS (car(M) TIMES cdr(N))) PLUS ((car(N) TIMES cdr(K)) PLUS (car(K) TIMES cdr(N)))]
    ALGEBRA ==> (N S_TIMES M) S_PLUS (N S_TIMES K) = 
      Red([(car(N) TIMES (car(M) PLUS car(K))) PLUS (cdr(N) TIMES (cdr(M) PLUS cdr(K))),
          (car(N) TIMES (cdr(M) PLUS cdr(K))) PLUS ((car(M) PLUS car(K)) TIMES cdr(N))])
    ELEM ==> QED

Theorem 212: (N in Z) imp (Red([N,0]) = [N,0]). Proof:
    Use_Def(Red) ==> Red([N,0]) = [N MINUS (N * 0),0 MINUS (N * 0)]
    ELEM ==> Red([N,0]) = [N MINUS 0,0 MINUS 0]
    N --> T158 ==> Red([N,0]) = [N,0 MINUS 0]
    0 --> T158 ==> QED

Theorem 213: [Embedding of Integers in Signed Integers]
     (N in Z & M in Z) imp ([N PLUS M,0] = [N,0] S_PLUS [M,0] & [N TIMES M,0] = [N,0] S_TIMES [M,0] & 
                              (N incs M) imp ([N,0] S_MINUS [M,0] = [N MINUS M,0])). Proof:
    Suppose_not(n,m) ==> 
      n in Z & m in Z & (not([n PLUS m,0] = [n,0] S_PLUS [m,0]) & [n TIMES m,0] = [n,0] S_TIMES [m,0]) & 
                              (not(n incs m) imp ([n,0] S_MINUS [m,0] = [n MINUS m,0]))
    Use_Def(S_PLUS) ==> [n,0] S_PLUS [m,0] = Red([n PLUS m,0 PLUS 0])
    ALGEBRA ==> [n,0] S_PLUS [m,0] = Red([n PLUS m,0]) & n PLUS m in Z
    (n PLUS m) --> T212 ==> [n,0] S_PLUS [m,0] = [n PLUS m,0]
    Use_Def(S_TIMES ) ==> [n,0] S_TIMES [m,0] = Red([(n TIMES m) PLUS (0 TIMES 0),(n TIMES 0) PLUS (m TIMES 0)])
    ALGEBRA ==> (n TIMES m) PLUS (0 TIMES 0) = n TIMES m & (n TIMES 0) PLUS (m TIMES 0) = 0 & n TIMES m in Z
    ELEM ==> [n,0] S_TIMES [m,0] = Red([n TIMES m,0])
    (n PLUS m) --> T212 ==> [n TIMES m,0] = [n,0] S_TIMES [m,0]
    ELEM ==> n incs m & [n,0] S_MINUS [m,0] /= [n MINUS m,0] 
    Use_Def(S_MINUS) ==> [n,0] S_MINUS [m,0] = Red([0 PLUS n,m PLUS 0])
    ALGEBRA ==> 0 PLUS n = n & m PLUS 0 = m
    ELEM ==> [n MINUS m,0] /= Red([n,m])
    Use_Def(Red) ==> [n MINUS m,0] /= [n MINUS (n * m),m MINUS (n * m)]
    ELEM ==> m MINUS m /= 0
    m --> T157 ==> false; Discharge ==> QED

Theorem 214: (N in Z & M in Z) imp (S_Rev(Red([M,N])) = Red([N,M])). Proof:
    Suppose_not(n,m) ==> n in Z & m in Z & S_Rev(Red([m,n])) /= Red([n,m])
    Use_Def(Red) ==> S_Rev([m MINUS m * n,n MINUS m * n]) /= Red([n MINUS m * n,m MINUS m * n])
    Use_Def(S_Rev) ==> false; Discharge ==> QED

Theorem 215: (N in Si & M in Si) imp (N S_TIMES S_Rev(M) = S_Rev(N S_TIMES M)). Proof:
    Suppose_not(n,m) ==> 
      n in Si & m in Si & (n S_TIMES S_Rev(m)) /= S_Rev(n S_TIMES m)
    n --> T197 ==> n = [car(n),cdr(n)] & car(n) in Z & cdr(n) in Z
    m --> T197 ==> m = [car(m),cdr(m)] & car(m) in Z & cdr(m) in Z
    Use_Def(S_TIMES ) ==> n S_TIMES S_Rev(m) = Red([(car(n) TIMES car(S_Rev(m))) PLUS (cdr(n) TIMES cdr(S_Rev(m))),
                            (car(n) TIMES cdr(S_Rev(m))) PLUS (car(S_Rev(m)) TIMES cdr(n))])
    Use_Def(S_Rev) ==> S_Rev(m) = [cdr(m),car(m)]
    ELEM ==> car(S_Rev(m)) = cdr(m) & cdr(S_Rev(m)) = car(m)
    ELEM ==> n S_TIMES S_Rev(m) = Red([(car(n) TIMES cdr(m)) PLUS (cdr(n) TIMES car(m)),
                            (car(n) TIMES car(m)) PLUS (cdr(m) TIMES cdr(n))])
    Use_Def(S_TIMES ) ==> S_Rev(n S_TIMES m) = S_Rev(Red([(car(n) TIMES car(m)) PLUS (cdr(n) TIMES cdr(m)),
                            (car(n) TIMES cdr(m)) PLUS (car(m) TIMES cdr(n))]))
    ALGEBRA ==> (car(n) TIMES car(m)) PLUS (cdr(n) TIMES cdr(m)) in Z &
                            (car(n) TIMES cdr(m)) PLUS (car(m) TIMES cdr(n)) in Z
    ((car(n) TIMES car(m)) PLUS (cdr(n) TIMES cdr(m)),(car(n) TIMES cdr(m)) PLUS (car(m) TIMES cdr(n))) --> T214 ==> 
        S_Rev(n S_TIMES m) = Red([(car(n) TIMES cdr(m)) PLUS (car(m) TIMES cdr(n)),
                            (car(n) TIMES car(m)) PLUS (cdr(n) TIMES cdr(m))])
    ALGEBRA ==> false; Discharge ==> QED

Theorem 216: [Inversion Lemma] (N in Si & M in Si) imp 
          (S_Rev(N S_TIMES M) = S_Rev(N) S_TIMES M & S_Rev(N S_TIMES M) = N S_TIMES S_Rev(M)). Proof:
    Suppose_not(n,m) ==> n in Si & m in Si & 
        (S_Rev(n S_TIMES m) /= S_Rev(n) S_TIMES m or S_Rev(n S_TIMES m) /= n S_TIMES S_Rev(m))
    (n,m) --> T215 ==> S_Rev(n S_TIMES m) /= n S_TIMES S_Rev(m)
    (m,n) --> T215 ==> S_Rev(m S_TIMES n) = m S_TIMES S_Rev(n)
    (m,n) --> T215 ==> S_Rev(n S_TIMES m) = n S_TIMES S_Rev(m)
    (m,S_Rev(n)) --> T209 ==> false; Discharge ==> QED

Theorem 217: [Double inversion] (K in Si) imp (S_Rev(S_Rev(K)) = K). Proof:
    K --> T197 ==> K = [car(K),cdr(K)]
    Use_Def(S_Rev) ==> S_Rev(K) = [cdr(K),car(K)]
    Use_Def(S_Rev) ==> QED
    
Theorem 218: (N in Si) imp (S_Rev(N) in Si & S_Rev(N) S_PLUS N = [0,0] & S_Rev(S_Rev(N)) = N). Proof:
    Suppose_not(n) ==> n in Si & S_Rev(n) in Si & S_Rev(n) S_PLUS N = [0,0] & S_Rev(S_Rev(n)) /= n
    n --> T197 ==> n = [car(n),cdr(n)] & (car(n) = 0 or cdr(n) = 0) & car(n) in Z & cdr(n) in Z
    Use_Def(S_Rev) ==> S_Rev(n) = [cdr(n),car(n)]
    Use_Def(Si) ==> S_Rev(n) in Si
    ELEM ==> S_Rev(n) in Si & S_Rev(S_Rev(n)) = N
    Use_Def(S_PLUS) ==> S_Rev(n) S_PLUS N = Red([car(n) PLUS car(S_Rev(n)),cdr(n) PLUS cdr(S_Rev(n))]) 
    ELEM ==> S_Rev(n) S_PLUS N = Red([car(n) PLUS cdr(n),cdr(n) PLUS car(n)])
    ALGEBRA ==> car(n) PLUS cdr(n) in Z
    (car(n) PLUS cdr(n)) --> T200 ==> false; Discharge ==> QED

Theorem 219: [Associativity Lemma] 
    (N in Si) imp (S_Rev(N) in Si & S_Rev(N) S_PLUS N = [0,0] & S_Rev(S_Rev(N)) = N). Proof:
    Suppose_not(k,n,m) ==> [n,0] S_TIMES ([m,0] S_TIMES [k,0]) = ([n,0] S_TIMES [m,0]) S_TIMES [k,0]
    (m,k) --> T213 ==> [m,0] S_TIMES [k,0] = [m TIMES k,0]
    (n,m) --> T213 ==> [n,0] S_TIMES [m,0] = [n TIMES m,0]
    ALGEBRA ==> m TIMES k in z & n TIMES m in z
    ELEM ==> [n,0] S_TIMES ([m,0] S_TIMES [k,0]) = [n,0] S_TIMES [m TIMES k,0] & 
            ([n,0] S_TIMES [m,0]) S_TIMES [k,0] = [n TIMES m,0] S_TIMES [k,0]
    (m,k) --> T213 ==> [n,0] S_TIMES ([m,0] S_TIMES [k,0]) = [(n TIMES m) TIMES k,0]
    (n,m) --> T213 ==> [n,0] S_TIMES ([m,0] S_TIMES [k,0]) = [n TIMES (m TIMES k),0]
    ALGEBRA ==> n TIMES (m TIMES k) = (n TIMES m) TIMES k
    ELEM ==> false; Discharge ==> QED
    
Theorem 220: [Associativity Lemma] 
    (K in Si & N in Z & M in Z) imp ([N,0] S_TIMES ([M,0] S_TIMES K) = ([N,0] S_TIMES [M,0]) S_TIMES K). Proof:
    Suppose_not(k,n,m) ==> 
      k in Si & n in Z & m in Z & [n,0] S_TIMES ([m,0] S_TIMES k) /= ([n,0] S_TIMES [m,0]) S_TIMES k
    k --> T197 ==> (k = [car(k),0] or k = [0,cdr(k)]) & car(k) in Z & cdr(k) in Z
    Suppose ==> k = [car(k),0]
    (n,m,car(k)) --> T219 ==> false; Discharge ==> k = [0,cdr(k)]
    Use_Def(S_Rev) ==> S_Rev(k) = [cdr(k),0]
    Use_Def(Si) ==> S_Rev(k) in Si & [n,0] in Si & [m,0] in Si
    ([n,0],[m,0]) --> T199 ==> [n,0] S_TIMES [m,0] in Si
    ([m,0],k) --> T199 ==> [m,0] S_TIMES k in Si
    (n,m,cdr(k)) --> T218 ==> [N,0] S_TIMES ([m,0] S_TIMES S_Rev(k)) = ([n,0] S_TIMES [m,0]) S_TIMES S_Rev(k)
    ([n,0] S_TIMES [m,0],k) --> T216 ==> 
      ([n,0] S_TIMES [m,0]) S_TIMES S_Rev(k) = S_Rev(([n,0] S_TIMES [m,0]) S_TIMES k)
    ([m,0],k) --> T216 ==> ([m,0] S_TIMES S_Rev(k)) = S_Rev([m,0] S_TIMES k)
    (n,[m,0] S_TIMES k) --> T216 ==> [n,0] S_TIMES S_Rev([m,0] S_TIMES k) = S_Rev([n,0] S_TIMES ([m,0] S_TIMES k))
    ELEM ==> S_Rev(S_Rev([n,0] S_TIMES ([m,0] S_TIMES k))) = S_Rev(S_Rev(([n,0] S_TIMES [m,0]) S_TIMES k))
    ([n,0],[m,0] S_TIMES k) --> T199 ==> [n,0] S_TIMES ([m,0] S_TIMES k) in Si
    ([n,0] S_TIMES [m,0],k) --> T199 ==> ([n,0] S_TIMES [m,0]) S_TIMES k in Si
    ([n,0] S_TIMES ([m,0] S_TIMES k)) --> T218 ==> 
      S_Rev(S_Rev([n,0] S_TIMES ([m,0] S_TIMES k))) = [n,0] S_TIMES ([m,0] S_TIMES k)
    (([n,0] S_TIMES [m,0]) S_TIMES k) --> T218 ==> false; Discharge ==> QED.

Theorem 221: [Associativity Lemma] 
    (K in Si & N in Z & M in Si) imp ([N,0] S_TIMES (M S_TIMES K) = ([N,0] S_TIMES M)). Proof:
    Suppose_not(k,n,m) ==> 
      k in Si & n in Z & m in Si & [n,0] S_TIMES (m S_TIMES k) /= ([n,0] S_TIMES m) S_TIMES k
    m --> T197 ==> (m = [car(m),0] or m = [0,cdr(m)]) & car(m) in Z & cdr(m) in Z
    Suppose ==> m = [car(m),0]
    (n,car(m),k) --> T220 ==> false; Discharge ==> m = [0,cdr(m)]
    Use_Def(S_Rev) ==> S_Rev(m) = [cdr(m),0]
    Use_Def(Si) ==> S_Rev(m) in Si & [n,0] in Si
    ([n,0],m) --> T199 ==> [n,0] S_TIMES m in Si
    (m,k) --> T199 ==> m S_TIMES k in Si
    (n,cdr(m),k) --> T216 ==> [N,0] S_TIMES (S_Rev(m) S_TIMES k) = ([n,0] S_TIMES S_Rev(m)) S_TIMES k
    ([n,0],m) --> T216 ==> [n,0] S_TIMES S_Rev(m) = S_Rev([n,0] S_TIMES m)
    (m,k) --> T218 ==> S_Rev(m) S_TIMES k = S_Rev(m S_TIMES k)
    ELEM ==> S_Rev([n,0] S_TIMES m) S_TIMES k = [n,0] S_TIMES S_Rev(m S_TIMES k)
    ([n,0] S_TIMES m,k) --> T216 ==> S_Rev([n,0] S_TIMES m) S_TIMES k = S_Rev(([n,0] S_TIMES m) S_TIMES k)
    ([n,0],m S_TIMES k) --> T216 ==> [n,0] S_TIMES S_Rev(m S_TIMES k) = S_Rev([n,0] S_TIMES (m S_TIMES k))
    ELEM ==> S_Rev(S_Rev([n,0] S_TIMES (m S_TIMES k))) = S_Rev(S_Rev(([n,0] S_TIMES m) S_TIMES k))
    ([n,0],m S_TIMES k) --> T199 ==> [n,0] S_TIMES (m S_TIMES k) in Si
    ([n,0] S_TIMES m,k) --> T199 ==> ([n,0] S_TIMES m) S_TIMES k in Si
    ([n,0] S_TIMES (m S_TIMES k)) --> T218 ==> 
      S_Rev(S_Rev([n,0] S_TIMES (m S_TIMES k))) = [n,0] S_TIMES (m S_TIMES k)
    (([n,0] S_TIMES m) S_TIMES k) --> T218 ==> false; Discharge ==> QED.

Theorem 222: [Associative Law] (K in Si & N in Si & M in Si) imp (N S_TIMES (M S_TIMES K) = (N S_TIMES M) S_TIMES K). Proof:
		Suppose_not(k,n,m) ==> 
      k in Si & n in Z & m in Si & n S_TIMES (m S_TIMES k) /= (n S_TIMES m) S_TIMES k
    n --> T197 ==> (n = [car(n),0] or n = [0,cdr(n)]) & car(n) in Z & cdr(n) in Z
    Suppose ==> n = [car(n),0]
    (car(n),m,k) --> T221 ==> false; Discharge ==> n = [0,cdr(n)]
    Use_Def(S_Rev) ==> S_Rev(n) = [cdr(n),0]
    Use_Def(Si) ==> S_Rev(n) in Si 
    (n,m) --> T199 ==> n S_TIMES m in Si
    (m,k) --> T199 ==> m S_TIMES k in Si
    (cdr(n),m,k) --> T216 ==> S_Rev(n) S_TIMES (m S_TIMES k) = (S_Rev(n) S_TIMES m) S_TIMES k
    (S_Rev(n),m S_TIMES k) --> T216 ==> S_Rev(n) S_TIMES (m S_TIMES k) = S_Rev(n S_TIMES (m S_TIMES k))
    (n,m) --> T216 ==> S_Rev(n) S_TIMES m = S_Rev(n S_TIMES m)
    ELEM ==> S_Rev(n S_TIMES m) S_TIMES k = n S_TIMES S_Rev(m S_TIMES k)
    (n S_TIMES m,k) --> T216 ==> S_Rev(n S_TIMES m) S_TIMES k = S_Rev((n S_TIMES m) S_TIMES k)
    (n,m S_TIMES k) --> T216 ==> n S_TIMES S_Rev(m S_TIMES k) = S_Rev(n S_TIMES (m S_TIMES k))
    ELEM ==> S_Rev(S_Rev(n S_TIMES (m S_TIMES k))) = S_Rev(S_Rev((n S_TIMES m) S_TIMES k))
    (n,m S_TIMES k) --> T199 ==> n S_TIMES (m S_TIMES k) in Si
    (n S_TIMES m,k) --> T199 ==> (n S_TIMES m) S_TIMES k in Si
    (n S_TIMES (m S_TIMES k)) --> T218 ==> 
      S_Rev(S_Rev(n S_TIMES (m S_TIMES k))) = n S_TIMES (m S_TIMES k)
    ((n S_TIMES m) S_TIMES k) --> T218 ==> false; Discharge ==> QED.

Theorem 223: (N in Si & M in Si) imp (N S_MINUS M = N S_PLUS S_Rev(M)). Proof:
    Suppose_not(n,m) ==> n in Si & m in Si & n S_MINUS n /= n S_PLUS S_Rev(m)
    Use_Def(Si) ==> m = [car(m),cdr(m)] & car(m) in Z & cdr(m) in Z & car(n) in Z & cdr(n) in Z
    Use_Def(S_MINUS) ==> n S_MINUS m = Red([cdr(m) PLUS car(n),car(m) PLUS cdr(n)])
    Use_Def(S_Rev) ==> S_Rev(m) = [cdr(m),car(m)]
    Use_Def(S_PLUS) ==> n S_PLUS S_Rev(m) = Red([car(n) PLUS cdr(m),cdr(n) PLUS car(m)])
    ALGEBRA ==> cdr(m) PLUS car(n) = car(n) PLUS cdr(m) & car(m) PLUS cdr(n) = cdr(n) PLUS car(m)
    ELEM ==> false; Discharge ==> QED
    
Theorem 224: (N in Si & M in Si) imp (N = M S_PLUS (N S_MINUS M)). Proof:
    Suppose_not(n,m) ==> n in Si & m in Si & n /= m S_PLUS (n S_MINUS m)
    n --> T197 ==> n = [car(n),cdr(n)] & (car(n) = 0 or cdr(n) = 0) & car(n) in Z & cdr(n) in Z
    m --> T197 ==> m = [car(m),cdr(m)] & (car(m) = 0 or cdr(m) = 0) & car(m) in Z & cdr(m) in Z
    Use_Def(S_MINUS) ==> n /= m S_PLUS Red([cdr(m) PLUS car(n),car(m) PLUS cdr(n)]) 
    ALGEBRA ==> cdr(m) PLUS car(n) in Z & car(m) PLUS cdr(n) in Z
    Use_Def(S_PLUS) ==> n /= Red([car(m) PLUS (cdr(m) PLUS car(n)),cdr(m) PLUS (car(m) PLUS cdr(n))])
    ALGEBRA ==> car(m) PLUS (cdr(m) PLUS car(n)) = car(n) PLUS (car(m) PLUS cdr(m)) & 
            cdr(m) PLUS (car(m) PLUS cdr(n)) = cdr(n) PLUS (car(m) PLUS cdr(m))
    ELEM ==> n /= Red([car(n) PLUS (car(m) PLUS cdr(m)),cdr(n) PLUS (car(m) PLUS cdr(m))])
    (car(m) PLUS cdr(m),car(n),cdr(n)) --> T201 ==> false; Discharge ==> QED
    
Theorem 225: (N in Si & M in Si) imp (S_Rev(N S_PLUS M) = S_Rev(N) S_PLUS S_Rev(M)). Proof:
    Suppose_not(n,m) ==> n in Si & m in Si & S_Rev(n S_PLUS m) /= S_Rev(n) S_PLUS S_Rev(m)
    Use_Def(Si) ==> n = [car(n),cdr(n)] & (car(n) = 0 or cdr(n) = 0) & car(n) in Z & cdr(n) in Z &
              m = [car(m),cdr(m)] & (car(m) = 0 or cdr(m) = 0) & car(m) in Z & cdr(m) in Z
    Use_Def(S_Rev) ==> S_Rev(n) = Red([cdr(n),car(n)]) & S_Rev(m) = Red([cdr(m),car(m)])
    Use_Def(S_PLUS) ==> n S_PLUS m = Red([car(n) PLUS cdr(n),cdr(n) PLUS cdr(n)])
    Use_Def(S_PLUS) ==> S_Rev(n) S_PLUS S_Rev(m) = S_Rev(n) S_PLUS Red([cdr(n),car(n)])
    n --> T218 ==> S_Rev(n) in Si
    (S_Rev(n),cdr(n),car(n)) --> T203 ==> S_Rev(n) S_PLUS S_Rev(m) = S_Rev(n) S_PLUS [cdr(n),car(n)]
    (cdr(n),car(n)) --> T196 ==> Red([cdr(n),car(n)]) in Si
    ELEM ==> S_Rev(n) S_PLUS S_Rev(m) = Red([cdr(n),car(n)]) S_PLUS [cdr(n),car(n)]
    ([cdr(n),car(n)],Red([cdr(n),car(n)])) --> T206 ==> 
            S_Rev(n) S_PLUS S_Rev(m) = [cdr(n),car(n)] S_PLUS Red([cdr(n),car(n)]) 
    ([cdr(n),car(n)],cdr(n),car(n)) --> T203 ==> S_Rev(n) S_PLUS S_Rev(m) = [cdr(n),car(n)] S_PLUS [cdr(n),car(n)] 
    Use_Def(S_PLUS) ==> Red([cdr(n) PLUS cdr(n),car(n) PLUS car(n)])
    ELEM ==> S_Rev(n S_PLUS m) = S_Rev(Red([car(n) PLUS cdr(n),cdr(n) PLUS cdr(n)]))
    ALGEBRA ==> car(n) PLUS cdr(n) in Z & cdr(n) PLUS cdr(n) in Z
    (car(n) PLUS cdr(n),cdr(n) PLUS cdr(n)) --> T214 ==> S_Rev(n S_PLUS m) = Red([cdr(n) PLUS cdr(n),car(n) PLUS cdr(n)])
    ELEM ==> false; Discharge ==> QED

Theorem 226: [0,1] S_TIMES [0,1] = [1,0]. Proof:
    Use_Def(S_TIMES ) ==> [0,1] S_TIMES [0,1] = Red([(1 TIMES 1) PLUS (0 TIMES 0),(1 TIMES 0) PLUS (0 TIMES 1)])
    ALGEBRA ==> [0,1] S_TIMES [0,1] = Red([1,0]) & 1 in Z & 0 in Z
    THUS ==> 1 = #1 & 0 = #0
    Use_Def(Red) ==> [0,1] S_TIMES [0,1] = [1 MINUS 1 * 0,0 MINUS 1 * 0]
    ELEM ==> [0,1] S_TIMES [0,1] = [1 MINUS 0,0 MINUS 0]
    1 --> T158 ==> [0,1] S_TIMES [0,1] = [1,0 MINUS 0]
    0 --> T158 ==> QED

Theorem 227: (K in Si) imp (K S_TIMES [1,0] = K). Proof:
    Suppose_not(k) ==> k in Si & k S_TIMES [1,0] /= k
    k --> T197 ==> k = [car(k),cdr(k)] & car(k) in Z & cdr(k) in Z & (car(k) = 0 or cdr(k) = 0)
    Use_Def(S_TIMES ) ==> 
      k S_TIMES [1,0] = Red([(car(k) TIMES 1) PLUS (cdr(k) TIMES 0),(cdr(k) TIMES 1) PLUS (car(k) TIMES 0)])
    ALGEBRA ==> k S_TIMES [1,0] = Red([car(k),cdr(k)])
    Use_Def(Red) ==> k S_TIMES [0,1] = [car(k) MINUS car(k) * cdr(k), MINUS car(k) * cdr(k)]
    ELEM ==> k S_TIMES [0,1] = [car(k) MINUS 0,cdr(k) MINUS 0]
    1 --> T158 ==> k S_TIMES [0,1] = [car(k),cdr(k) MINUS 0]
    0 --> T158 ==> QED

Theorem 228: (K in Si & M in Si) imp (K S_MINUS M = K S_PLUS (M S_TIMES [0,1])). Proof:
    Suppose_not(k) ==> k in Si & m in Si & k S_MINUS m /= k S_PLUS (m S_TIMES [0,1])
    k --> T197 ==> k = [car(k),cdr(k)] & car(k) in Z & cdr(k) in Z & (car(k) = 0 or cdr(k) = 0) & Red(k) = k
    m --> T197 ==> m = [car(m),cdr(m)] & car(m) in Z & cdr(m) in Z & (car(m) = 0 or cdr(m) = 0) & Red(m) = m
    Use_Def(S_TIMES ) ==>
       m S_TIMES [0,1] = Red([(car(m) TIMES 0) PLUS (cdr(m) TIMES 1),(cdr(m) TIMES 0) PLUS (car(m) TIMES 1)])
    ALGEBRA ==> m S_TIMES [0,1] = Red([cdr(m),car(m)])
    Use_Def(S_MINUS) ==> k S_MINUS m = Red([cdr(m) PLUS car(k),car(m) PLUS cdr(k)])
    ELEM ==> k S_PLUS (m S_TIMES [0,1]) = k S_PLUS Red([cdr(m),car(m)])
    (k,cdr(m),car(m)) --> T203 ==> k S_PLUS (m S_TIMES [0,1]) = k S_PLUS [cdr(m),car(m)]
    Use_Def(S_PLUS) ==> k S_PLUS (m S_TIMES [0,1]) = Red([car(k) PLUS cdr(m),cdr(k) PLUS car(m)])
    ALGEBRA ==> cdr(m) PLUS car(k) = car(k) PLUS cdr(m) & car(m) PLUS cdr(k) = cdr(k) PLUS car(m)
    ELEM ==> false; Discharge ==> QED
    
Theorem 229: (K in Si) imp (K S_MINUS K = [0,0]). Proof:
    Suppose_not(k) ==> k in Si & k S_MINUS k /= [0,0]
    k --> T197 ==> k = [car(k),cdr(k)] & car(k) in Z & cdr(k) in Z & (car(k) = 0 or cdr(k) = 0) & Red(k) = k
    Use_Def(S_MINUS) ==> k S_MINUS k = Red([cdr(k) PLUS car(k),car(k) PLUS cdr(k)]) 
    ALGEBRA ==> Red([car(k) PLUS cdr(k),car(k) PLUS cdr(k)]) /= [0,0]
    (car(k) PLUS cdr(k)) --> T200 ==> false; Discharge ==> QED

Theorem 230: (K in Si) imp (K S_PLUS [0,0] = K). Proof:
    Suppose_not(k) ==> k in Si & k S_PLUS [0,0] /= k
    k --> T197 ==> k = [car(k),cdr(k)] & car(k) in Z & cdr(k) in Z & Red(k) = k
    Use_Def(S_PLUS) ==> k S_PLUS [0,0] = Red([car(k) PLUS 0,cdr(k) PLUS 0])
    ALGEBRA ==> car(k) PLUS 0 = car(k)
    ALGEBRA ==> cdr(k) MINUS 0 = cdr(k)
    ELEM ==> false; Discharge ==> QED

Theorem 231: (K in Si) imp ([0,0] S_PLUS K = K). Proof:
    Suppose_not(k) ==> k in Si & [0,0] S_PLUS k /= k
    ([0,0],car(k),cdr(k)) --> T206 ==> [0,0] S_PLUS k = k S_PLUS [0,0]
    K --> T230 ==> k S_PLUS [0,0] = k
    ELEM ==> QED

Theorem 232: [Si is an Integral Domain] 
        (FORALL n in Si | (FORALL m in Si | (m S_TIMES n = [0,0]) imp (m = [0,0] or n = [0,0]))). Proof:
    Suppose_not(n,m) ==> n in Si & m in Si & m S_TIMES n = [0,0] & (m /= [0,0] or n /= [0,0])
    n --> T197 ==> (n = [car(n),0] or n = [0,car(n)]) & car(n) in Z & cdr(n) in Z
    m --> T197 ==> (m = [car(m),0] or m = [0,car(m)]) & car(m) in Z & cdr(m) in Z
    THUS ==> 
    Use_Def(S_TIMES ) ==> 
      [if car(m) = car(n) or cdr(m) = 0 or cdr(n) = 0 then 0 else 1 end if,cdr(m) TIMES cdr(n)] = [0,0]
    ELEM ==> cdr(m) TIMES cdr(n) = 0
    (cdr(m),cdr(n)) --> T181 ==> cdr(m) = 0 or cdr(n) = 0
    Suppose ==> cdr(m) = 0
    Use_Def(Si) ==> [car(m),cdr(m)] in ({[0,x]: x in Z} + {[1,x]: x in Z | x /= 0})
    ELEM ==> Stat1: [car(m),cdr(m)] in {[0,x]: x in Z} or [car(n),cdr(n)] in {[1,x]: x in Z | x /= 0}
    (c,d) --> Stat1 ==> ([car(n),cdr(n)] = [0,c] & c in Z) or ([car(n),cdr(n)] = [0,d] & d in Z & d /= 0)
    ELEM ==> false; Discharge ==> cdr(n) = 0
    Use_Def(Si) ==> [car(n),cdr(n)] in ({[0,x]: x in Z} + {[1,x]: x in Z | x /= 0})
    ELEM ==> Stat1: [car(n),cdr(n)] in {[0,x]: x in Z} or [car(n),cdr(n)] in {[1,x]: x in Z | x /= 0}
    (c,d) --> Stat1 ==> ([car(n),cdr(n)] = [0,c] & c in Z) or ([car(n),cdr(n)] = [0,d] & d in Z & d /= 0)
    ELEM ==> false; Discharge ==> QED

Theorem 233: [Distributivity of Subtraction] 
    (FORALL n in Si | (FORALL m in Si | (FORALL k in Si | (m S_TIMES n) S_MINUS (k S_TIMES n) = (m S_MINUS k) S_TIMES n))). Proof:
    Suppose_not(n,m,k) ==> n in Si & m in Si & k in Si & (m S_TIMES n) S_MINUS (k S_TIMES n) /= (m S_MINUS k) S_TIMES n
    (m S_TIMES n,k S_TIMES n) --> T223 ==> (m S_TIMES n) S_MINUS (k S_TIMES n) = (m S_TIMES n) S_PLUS S_Rev(k S_TIMES n)
    (m,k) --> T223 ==> m S_MINUS k = m S_PLUS S_Rev(k)
    (k,n) --> T216 ==> S_Rev(k S_TIMES n) = S_Rev(k) S_TIMES n
    ELEM ==> (m S_TIMES n) S_PLUS (S_Rev(k) S_TIMES n) /= (m S_PLUS S_Rev(k)) S_TIMES n
    k --> T218 ==> S_Rev(k) in Si
    ALGEBRA ==> false; Discharge ==> QED
    
Theorem 234: [Si Cancellation] 
        (FORALL n in Si | (FORALL m in Si | (FORALL k in Si | ((m S_TIMES n = k S_TIMES n & n /= [0,0]) imp (m = k))))). Proof:
    Suppose_not(n,m,k) ==> n in Si & m in Si & k in Si & m S_TIMES n = k S_TIMES n & n /= [0,0] & m /= k
    ELEM ==> (m S_TIMES n) S_MINUS (k S_TIMES n) = (k S_TIMES n) S_MINUS (k S_TIMES n)
    (k S_TIMES n) --> T229 ==> (m S_TIMES n) S_MINUS (k S_TIMES n) = [0,0]
    (m S_TIMES n,k S_TIMES n) --> T233 ==> (m S_MINUS k) S_TIMES n = [0,0]
    (m S_MINUS k,n) --> T232 ==> m S_MINUS k = [0,0]
    ELEM ==> k S_PLUS (m S_MINUS k) = k S_PLUS [0,0]
    (k,m) --> T224 ==> m = k S_PLUS [0,0]
    ALGEBRA ==> false; Discharge ==> QED

Theorem 235: [Multiplication by -1] (FORALL n in Si | S_Rev(n) = [0,1] S_TIMES n). Proof:
    Suppose_not(n) ==> n in Si & S_Rev(n) /= [0,1] S_TIMES n
    Use_Def(S_TIMES ) ==> S_Rev(n) /= Red([(0 TIMES car(n)) PLUS (1 TIMES cdr(n)),(car(n) TIMES 1) PLUS (1 TIMES cdr(n))])
    ALGEBRA ==> (0 TIMES car(n)) PLUS (1 TIMES cdr(n)) = cdr(n) & (car(n) TIMES 1) PLUS (1 TIMES cdr(n)) = car(n)
    ELEM ==> S_Rev(n) /= Red([cdr(n),car(n)])
    Use_Def(S_Rev) ==> false; Discharge ==> QED
    
THEORY ordinal_induction(o,P)
    Ord(o) & P(o)
==>
END ordinal_induction;

ENTER_THEORY ordinal_induction
    
Def 00: t := arb({x incin s | Ord(x) & P(x)})
    
Theorem: Ord(t) & P(t) & t incin o & (FORALL x in t | not P(x)). Proof:
    Suppose ==> Stat1: {x incin o | Ord(x) & P(x)} = 0
    ELEM ==> s notin {x incin o | Ord(x) & P(x)}
    Defmemb ==> not(Ord(o) & P(o))
    ELEM ==> false; Discharge ==> {x incin o | Ord(x) & P(x)} /= 0
    {x incin o | Ord(x) & P(x)} --> Ax_ch ==> 
          t in {x incin o | Ord(x) & P(x)} & t * {x incin o | Ord(x) & P(x)} = 0
    Defmemb ==> Ord(t) & P(t) & t incin o
    Suppose ==> Stat1: not(FORALL x in t | not P(x))
    c --> Stat1 ==> c in t & P(x)
    THUS ==> c incin t
    ELEM ==> c incin o
    Defmemb ==> c in {x incin o | Ord(x) & P(x)}
    ELEM ==> false; Discharge ==> QED

ENTER_THEORY set_theory

DISPLAY ordinal_induction

THEORY ordinal_induction(o,P)
    Ord(o) & P(o)
==>(t)
    Ord(t) & P(t) & t incin o & (FORALL x in t | not P(x))
END ordinal_induction;

Def 35a: [Transitive membership closure of s] Ult_membs(s) := s + {y: u in {Ult_membs(x): x in s},y in u}  

Theorem 236: S incin Ult_membs(S). Proof:
    Use_Def(Ult_membs) ==> Ult_membs(S) = S + {y: u in {Ult_membs(x): x in S},y in u}
    ELEM ==> QED

Theorem 237: Ult_membs(S) = S + {y: x in S, y in Ult_membs(x)}. Proof:
    Suppose_not(x) ==> Ult_membs(s) = s + {y: x in s, y in Ult_membs(x)}
    Use_Def(Ult_membs) ==> Ult_membs(s) = s + {y: u in {Ult_membs(x): x in s},y in u}
    SIMPLF ==> false; Discharge ==> QED

Theorem 238: (X in S & Y in X) imp (Y in Ult_membs(S)). Proof:
    Suppose_not(x,s,y) ==> x in s & y in x & y notin Ult_membs(s)
    s --> T237 ==> Stat1: y notin {v: x in s, v in Ult_membs(x)}
    (x,y) --> Stat1 ==> y notin Ult_membs(x)
    x --> T237 ==> y notin x
    ELEM ==> false; Discharge ==> QED

Theorem 239: (Ord(S)) imp (Ult_membs(S) = S). Proof:
    Suppose_not(s) ==> Ord(s) & (Ult_membs(s) /= s)
    Use_Def(Ult_membs) ==> Ult_membs(s) incs s
    ELEM ==> Ord(s) & (not(Ult_membs(s) incin s))
    APPLY(t) ordinal_induction(s,P(x)->not(Ult_membs(x) incin x)) ==> 
      Ord(t) & (not(Ult_membs(t) incin t)) & Stat1: (FORALL x in t | Ult_membs(x) incin x)
    Memb(c) ==> c in Ult_membs(t) & c notin t
    x --> T237 ==> Stat2: c in {y: x in t, y in Ult_membs(x)}
    (y,x) --> Stat2 ==> x in t & c in Ult_membs(x)
    x --> Stat1 ==> Ult_membs(x) incin x & c in x
    THUS ==> x incin t
    ELEM ==> false; Discharge ==> QED

Theorem 240: Ult_membs({S}) = {S} + Ult_membs(S). Proof:
    Use_Def(Ult_membs) ==> Ult_membs({S}) = {S} + {y: u in {Ult_membs(x): x in {S}}, y in u}
    SIMPLF ==> {y: x in {S}, y in Ult_membs(x)} = {y: y in Ult_membs(S)}
    SIMPLF ==> {y: y in Ult_membs(S)} = Ult_membs(S)
    EQUAL ==> QED
    
Theorem 241: Ord(S) imp (Ult_membs({S}) = S + {S}). Proof:
    Suppose_not(s) ==> Ord(s) & Ult_membs({s}) /= s + {s}
    s --> T240 ==> Ult_membs({s}) = {s} + Ult_membs(s)
    s --> T239 ==> false; Discharge ==> QED

Theorem 242: (Y in Ult_membs(S)) imp (Ult_membs(Y) incin Ult_membs(S)). Proof:
    Suppose_not(y,s) ==> y in Ult_membs(s) & (not(Ult_membs(y) incin Ult_membs(s)))
    Quantif ==> (EXISTS y | y in Ult_membs(s) & (not(Ult_membs(y) incin Ult_membs(s))))
    APPLY(t) transfinite_induction(p(x)->(EXISTS y | y in Ult_membs(x) & (not(Ult_membs(y) incin Ult_membs(s))))) ==>
      Stat0: (EXISTS y | y in Ult_membs(t) & (not(Ult_membs(y) incin Ult_membs(t)))) & 
              Stat1: (FORALL x in t | (not(EXISTS y | y in Ult_membs(x) & (not(Ult_membs(y) incin Ult_membs(x))))))
    y --> Stat0 ==> y in Ult_membs(t) & (not(Ult_membs(y) incin Ult_membs(t)))
    t --> T237 ==> Ult_membs(t) = t + {v: u in t, v in Ult_membs(u)}
    Memb(c) ==> c in Ult_membs(y) & c notin Ult_membs(t) & Stat2: c notin {v: u in t, v in Ult_membs(u)}
    Suppose ==> y in t
    (y,c) --> Stat2 ==> c notin Ult_membs(y)
    ELEM ==> false; Discharge ==> Stat3: y in {v: u in t, v in Ult_membs(u)}
    (u,a) --> Stat3 ==> u in t & y in Ult_membs(u)
    (u,y) --> Stat1 ==> Ult_membs(y) incin Ult_membs(u)
    ELEM ==> not(Ult_membs(u) incin Ult_membs(t))
    Memb(d) ==> d in Ult_membs(u) & Stat4: d notin {v: w in t, v in Ult_membs(w)}
    (u,d) --> Stat3 ==> not(u in t & d in Ult_membs(u))
    ELEM ==> false; Discharge ==> QED

Theorem 243: (Y in Ult_membs(S)) imp (Y incin Ult_membs(S)). Proof:
    Suppose_not(y,s) ==> y in Ult_membs(s) & (not (y incin Ult_membs(s)))
    (y,s) --> T241 ==> Ult_membs(y) incin Ult_membs(s)
    y --> T237 ==> QED

THEORY transfinite_member_induction(n,P)
    P(n)
==>
END transfinite_member_induction;

ENTER_THEORY transfinite_member_induction

Def 00: m := arb({k in Ult_membs({n}) | P(k)})

Theorem: P(m) & m in Ult_membs({n}) & (FORALL k in m | not P(k)). Proof:
    Suppose ==> {k in Ult_membs({n}) | P(k)} = 0
    {n} --> T99999 ==> Ult_membs({n}) incs {n}
    Set_monot ==> {k in Ult_membs({n}) | P(k)} incs {k in {n} | P(k)}
    Suppose ==> Stat1: n notin {k in {n} | P(k)}
    n --> Stat1 ==> not(n in {n} & P(n))
    ELEM ==> false; Discharge ==> {k in Ult_membs({n}) | P(k)} /= 0
    {k in Ult_membs({n}) | P(k)} --> Ax_ch ==> 
       Stat0: m in {k in Ult_membs({n | P(n)})} & m * {k in Ult_membs({n}) | P(k)} = 0
    m --> Stat0 ==> m in Ult_membs({n}) & P(m)
    Suppose ==> Stat3: not(FORALL k in m | not P(k))
    k --> Stat3 ==> k in m & P(k)
    (m,{n}) --> T242 ==> k in Ult_membs({n})
    Suppose ==> Stat4: k notin {k in Ult_membs({n}) | P(k)}
    Defmemb ==> not(k in Ult_membs({n}) & P(k))
    ELEM ==> false; Discharge ==> k in {k in Ult_membs({n}) | P(k)}
    ELEM ==> false; Discharge ==> QED

ENTER_THEORY set_theory

DISPLAY transfinite_member_induction  
    
THEORY transfinite_member_induction(n,P)
    P(n)
==>(m)
    P(m) & m in Ult_membs({n}) & (FORALL k in m | not P(k))
END transfinite_member_induction;

THEORY mathematical_induction(P)
    n in Z & P(n)
==>
END mathematical_induction;

ENTER_THEORY mathematical_induction

Theorem: m in Z & P(m) & (FORALL n in m | not P(n)). Proof:
    APPLY(m) transfinite_induction(n->n,P->P) ==> P(m) & (FORALL n in m | not P(n))
    ELEM ==> QED

DISPLAY mathematical_induction 

THEORY mathematical_induction(P)
    (EXISTS n in Z | P(n))
==>(m)
    P(m) & (FORALL n in m | not P(n))
END mathematical_induction;

THEORY double_transfinite_induction(o,R)
    (EXISTS n in o | (EXISTS k in o | R(n,k)))
==>
END double_transfinite_induction;

ENTER_THEORY double_transfinite_induction

Theorem: R(m,j) & (FORALL k in m | (FORALL j in o | not R(k,j)) & (FORALL i in j | not R(m,i))). Proof:
    ELEM ==> (EXISTS n in o | ((EXISTS k in o | R(n,k))))
    APPLY(m) mathematical_induction(P(x) -> (EXISTS k in o | R(x,k))) ==> 
            (EXISTS k in o | R(m,k)) & (FORALL k in m | (not(EXISTS j in o | R(k,j))))
    SIMPLF ==> (EXISTS j in o | R(m,j)) & (FORALL k in m | (FORALL j in o | not R(k,j)))
    APPLY(j) mathematical_induction(P(x) -> R(m,x)) ==> 
      R(m,j) & (FORALL i in j | not R(m,i))
    ELEM ==> QED

ENTER_THEORY set_theory

THEORY double_induction(o,R)
    (EXISTS n in Z | (EXISTS k in o | R(n,k)))
==>
END double_induction;

ENTER_THEORY double_induction

Theorem: R(m,j) & (FORALL k in m | (FORALL j in Z | not R(k,j))) & (FORALL i in j | not R(m,i)). Proof:
    APPLY(m,j) transfinite_induction(o->Z,P->P) ==> QED

DISPLAY double_induction

THEORY double_induction(R);
    (EXISTS n in Z | (EXISTS k in Z | R(n,k)))
==>(m,j)
    P(m,j) & (FORALL n in m | not R(n,L)) & (FORALL i in j | not R(m,i))
END double_induction;

THEORY finite_recursive_definition(f,g,P);
==>
END finite_recursive_definition;

ENTER_THEORY finite_recursive_definition

Theorem: (FORALL n in Z | (EXISTS h | (FORALL s | (FORALL x | ((#x incin n) imp (h(x,s) = f({g2(h(y,s),s): y incin x | y /= x & P(x,y,s)},x,s))))))). Proof: 
		Suppose_not(n) ==> 
      n in Z & 
        (not(EXISTS h | (FORALL s | (FORALL z | ((#z incin n) imp (h(z,s) = f({g4(h(y,s),x,y,s): y incin z | y /= z & P(z,y,s)},x,s)))))))
    APPLY (m) mathematical_induction(P(x)->	
      not(EXISTS h | (FORALL s | (FORALL z | ((#z incin x) imp (h(z,s) = f({g4(h(y,s),x,y,s): y incin z | y /= z & P(z,y,s)},x,s))))))) ==> 
    m in Z & Stat1: 
      (not(EXISTS h | (FORALL s | (FORALL z | ((#z incin m) imp (h(z,s) = f({g4(h(y,s),x,y,s): y incin z | y /= z & P(z,y,s)},x,s))))))) &
    Stat2: 
    (FORALL k in m | (EXISTS h | (FORALL s | (FORALL z | ((#z incin m) imp (h(z,s) = f({g4(h(y,s),x,y,s): y incin z | y /= z & P(z,y,s)},x,s)))))))
    TO_BE_CONTINUED ==> QED

Skolem_def: (FORALL s | (FORALL x | ((#x incin n) imp (h(x,s) = f({g2(h(y,s),s): y incin x | y /= x & P(x,y,s)},x,s)))))
    
Theorem: 
    (EXISTS h | (FORALL n in Z | (FORALL s | (FORALL x | ((#x incin n) imp (h(x,s) = f({g4(h(y,s),x,y,s): y incin x | y /= x & P(x,y,s)},x,s))))))). 

Skolem_def: (FORALL n in Z | (FORALL s | (FORALL x | ((#x incin n) imp (h(x,s) = f({g4(h(y,s),x,y,s): y incin x | y /= x & P(x,y,s)},x,s))))))

Theorem: Finite(X) imp (h(X,S) = f({g4(h(y,S),X,y,S): y incin X | y /= X & P(X,y,S)},X,S)). Proof:
    Suppose_not(x) ==> Finite(x) & h(x,S) = f({g4(h(y,S),x,y,S): y incin x | y /= x & P(X,y,S)},x,S)
    THUS ==> Finite(#x) & Card(#x)
    Elem_Props ==> #x in Z
    Use_Def(h) ==> Stat1:
      (FORALL n in Z | (FORALL s | (FORALL x | ((#x incin n) imp (h(x,s) = f({g4(h(y,s),x,y,s): y incin x | y /= x & P(x,y,s)},x,s))))))
    (#x,s,x) --> Stat1 ==> false; Discharge ==> QED

ENTER_THEORY set_theory

DISPLAY finite_recursive_definition

THEORY finite_recursive_definition(f,g,P);
==>(h)
    Finite(X) imp (h(X,S) = f({g(h(y,S),y,S): y incin X | y /= X & P(X,y,S)},X,S))
END finite_recursive_definition;

THEORY finite_recursive_definition2(f0,g0)
==>
END finite_recursive_definition2;

ENTER_THEORY finite_recursive_definition2

APPLY finite_recursive_definition(h1)(f,g,P(x,y,s)->(x /= 0 & y = x - {arb(x)})) ==>
    Stat0: Finite(X) imp (h1(x,s) = if x = 0 then f0(s) else g0(h(X - {arb(X)},s),x) end if)

ENTER_THEORY set_theory

DISPLAY finite_recursive_definition2

THEORY finite_recursive_definition2(f0,g0)
==>(h)
    Finite(X) imp (h(X,S) = if X = 0 then f0(S) else g0(h(X - {arb(X)},S),X,S) end if)
END finite_recursive_definition2;

THEORY finite_recursive_definition3(f1,g1)
==>
END finite_recursive_definition3;

ENTER_THEORY finite_recursive_definition3

APPLY finite_recursive_definition2(h1)(f0(S)->f1,g0(y,x,s)->g1(y,x)) ==>
    Stat0: Finite(X) imp (h1(X,S) = if X = 0 then f1 else g2(h(X - {arb(X)},S),x) end if)

Def 00: h(X) := h1(X,0)

Theorem: h1(X) = if x = 0 then f1 else g2(h(X - {arb(X)}),X) end if. Proof:
    0 --> Stat0 ==> QED

ENTER_THEORY set_theory

DISPLAY finite_recursive_definition3

THEORY finite_recursive_definition3(f,g)
==>(h)
    Finite(X) imp (h(X) = if x = 0 then f else g2(h(X - {arb(X)}),X) end if)
END finite_recursive_definition3;

THEORY sigma_theory(s,PLUZ,e) 
    e in s;
    (FORALL x in s | x PLUZ e = x)
    (FORALL x in s | (FORALL y in s | x PLUZ y = y PLUZ x))
    (FORALL x in s | (FORALL y in s | (FORALL z in s | (x PLUZ y) PLUZ z = x PLUZ (y PLUZ z))))
==>
END sigma_theory;

ENTER_THEORY sigma_theory        

APPLY finite_recursive_definition3(sigma)(f->e,g2(y,x)->y PLUZ cdr(arb(x))) ==> 
    sigma(X) = if X = 0 then e else sigma(X - {arb(X)}) PLUZ cdr(arb(X)) end if

Theorem: sigma(0) = e. Proof:
    Use_Def(sigma) ==> QED

Theorem: (FORALL x | ((cdr(x) in s) imp (sigma({x}) = cdr(x)))). Proof:
    Suppose_not(x) ==> cdr(x) in s & sigma({x}) /= cdr(x)
    x --> T1 ==> arb({x}) = x
    Use_Def(sigma) ==> sigma({x}) = sigma(0) PLUZ cdr(x)
    sigma_theory.1 ==> sigma({x}) = e PLUZ cdr(x)
    ALGEBRA ==> false; Discharge ==> QED

Theorem: (Finite(F) & range(F) incin s) imp (sigma(F) in s). Proof: 
    Suppose_not(f1) ==> Finite(f1) & range(f1) incin s & sigma(f1) notin s
    APPLY(f) finite_induction(n->f,P(x)->range(x) incin s & sigma(x) notin s) ==> 
       Finite(f) & range(f) incin s & sigma(f) notin s & 
            Stat1: (FORALL g incin f | ((g /= f) imp (not(range(g) incin s & sigma(g) notin s))))
    sigma_theory.1 ==> f /= 0
    f --> Ax_ch ==> f incs f - {arb(f)} & f - {arb(f)} /= f & arb(f) in f
    (f - {arb(f)}) --> Stat1 ==> not(range(f - {arb(f)}) incin s & sigma(f - {arb(f)}) notin s)
    Use_Def(range) ==> range(f - {arb(f)}) = {cdr(x): x in f - {arb(f)}} & range(f) = {cdr(x): x in f}
    Set_monot ==> sigma(f - {arb(f)}) in s
    Use_Def(sigma) ==> sigma(f) = sigma(f - {arb(f)}) PLUZ cdr(arb(f))
    Suppose ==> Stat2: cdr(arb(f)) notin {cdr(x): x in f}
    arb(f) --> Stat2 ==> false; Discharge ==> cdr(arb(f)) in s
    ALGEBRA ==> false; Discharge ==> QED
    
Theorem: (Finite(F) & range(F) incin s & C in F) imp (sigma(F) = sigma(F - {C}) PLUZ cdr(C)). Proof:
      Suppose_not(f1,c) ==> Finite(f1) & range(f1) incin s & c in f1 & sigma(f1) /= sigma(f1 - {c}) PLUZ cdr(c)
      Quantif ==> Finite(f1) & range(f1) incin s & (EXISTS c in f1 | sigma(f1) /= sigma(f1 - {c}) PLUZ cdr(c))
    APPLY(f) finite_induction (n->f,P(x)->range(x) incin s & (EXISTS c in x | sigma(x) = sigma(x - {c}) PLUZ cdr(c))) ==>
      Finite(f) & range(f) incin s & Stat1: (EXISTS c in f | sigma(f) /= sigma(f - {c}) PLUZ cdr(c)) & 
Stat2: (FORALL g incin f | ((g /= f) imp ((not (range(g) incin s)) or (not(EXISTS c in g | sigma(g) /= sigma(g - {c}) PLUZ cdr(c))))))
    c --> Stat1 ==> c in f & sigma(f) /= sigma(f - {c}) PLUZ cdr(c)
    Suppose ==> f - {c} = 0
    Use_Def(range) ==> range(f) = {cdr(x): x in f}
    Suppose ==> Stat3: cdr(c) notin {cdr(x): x in f}
    c --> Stat3 ==> false; Discharge ==> cdr(c) in s
    sigma_theory.1 ==> sigma(c) /= e PLUZ cdr(c)
    sigma_theory.2 ==> cdr(c) /= e PLUZ cdr(c)
    ALGEBRA ==> false; Discharge ==> f - {c} /= 0
    ELEM ==> f /= 0
    f --> Ax_ch ==> arb(f) in f
    Use_Def(sigma) ==> sigma(f) = sigma(f - {arb(f)}) PLUZ cdr(arb(f))
    Suppose ==> arb(f) = c
    ELEM ==> false; Discharge ==> arb(f) /= c
    ELEM ==> f - {arb(f)} incin f & f - {arb(f)} /= f & c in f - {arb(f)}
    (f - {arb(f)},f) --> T243 ==> range(f - {arb(f)}) incin s
    (f - {arb(f)},f) --> Stat2 ==> 
        Stat4: not(EXISTS c in f - {arb(f)} | sigma(f - {arb(f)}) /= sigma(f - {arb(f)} - {c}) PLUZ cdr(c))
    c --> Stat4 ==> sigma(f - {arb(f)}) = sigma(f - {arb(f)} - {c}) PLUZ cdr(c)
    ELEM ==> f - {c} incin f & f - {c} /= f & arb(f) in f - {c}
    (f - {c},f) --> T243 ==> range(f - {c}) incin s
    (f - {c},f) --> Stat2 ==> 
        Stat5: not(EXISTS d in f - {c} | sigma(f - {c}) /= sigma(f - {c} - {d}) PLUZ cdr(d))
    arb(f) --> Stat5 ==> sigma(f - {c}) = sigma(f - {arb(f)} - {c}) PLUZ cdr(arb(f))
    THUS ==> cdr(c) in s & cdr(arb(f)) in s
    ALGEBRA ==> sigma(f - {c}) PLUZ cdr(c) = (sigma(f - {arb(f)} - {c}) PLUZ cdr(c)) PLUZ cdr(arb(f))
    ALGEBRA ==> sigma(f - {c}) PLUZ cdr(c) = sigma(f)
    ELEM ==> false; Discharge ==> QED
    
Theorem: (Finite(F) & is_map(F) & range(F) incin s) imp 
      (FORALL t | (sigma(F) = sigma(F ON (domain(F) * t)) PLUZ sigma(F ON (domain(F) - t)))). Proof:
    Suppose_not(f1) ==> Finite(f1) & is_map(f1) & range(f1) incin s & 
                  (not(FORALL t | sigma(f1) = sigma(f1 ON (domain(f1) * t)) PLUZ sigma(f1 ON (domain(f) - t))))
    APPLY(f) finite_induction (n->f,P(x)->range(x) incin s & is_map(x) &    
                  (not(FORALL t | sigma(x) = sigma(x ON (domain(x) * t)) PLUZ sigma(x ON (domain(x) - t))))) ==> 
       Finite(f) & range(f) incin s & is_map(f) & 
            Stat1: (not(FORALL t | sigma(f) = sigma(f ON (domain(f) * t)) PLUZ sigma(f ON (domain(f) - t)))) &
         Stat2: (FORALL g incin f | ((g /= f) imp ((not (range(g) incin s)) or (not is_map(g)) or 
            (FORALL t | sigma(g) = sigma(g ON (domain(g) * t)) PLUZ sigma(g ON (domain(g) - t))))))
    t --> Stat1 ==> sigma(f) /= sigma(f ON (domain(f) * t)) PLUZ sigma(f ON (domain(f) - t))
    (f,domain(f) * t,domain(f) - t) --> T34 ==> f ON domain(f) = f ON (domain(f) * t) + f ON (domain(f) - t)
    f --> T37 ==> f = f ON (domain(f) * t) + f ON (domain(f) - t)
    Suppose ==> f ON (domain(f) * t) = 0
    ELEM ==> f = f ON (domain(f) - t)
    sigma_theory.1 ==> sigma(f) /= e PLUZ sigma(f ON (domain(f) - t))
    ALGEBRA ==> false; Discharge ==> f ON (domain(f) * t) /= 0
    Memb(c) ==> {c} incin f ON (domain(f) * t) & {c} incin f & c in f ON (domain(f) * t) & f - {c} incin f
    Use_Def(ON) ==> Stat3: c in {[car(x),cdr(x)]: x in f | car(x) in domain(f) * t}
    a --> Stat3 ==> car(c) in domain(f) * t
    (f - {c},f) --> T243 ==> domain(f - {c}) - t incin domain(f) - t
    Suppose ==> not (domain(f - {c}) - t incs domain(f) - t)
    Memb(b) ==> Stat4: b in {car(x): x in f} - t & Stat5: b notin {car(x): x in f - {c}}
    b1 --> Stat4 ==> b = car(b1) & b1 in f & b notin t
    b1 --> Stat5 ==> b1 notin f - {c}
    ELEM ==> b1 = c & car(b1) notin t
    ELEM ==> false; Discharge ==> domain(f - {c}) - t = domain(f) - t
    Use_Def(ON) ==> f ON (domain(f) - t) = {x in f | car(x) in domain(f) - t} & 
                (f - {c}) ON (domain(f) - t) = {x in (f - {c}) | car(x) in domain(f) - t}
    Set_monot ==> f ON (domain(f) - t) incs (f - {c}) ON (domain(f) - t)
    Suppose ==> not (f ON (domain(f) - t) incin (f - {c}) ON (domain(f) - t))
    Memb(d) ==> Stat6: d in {x in f | car(x) in domain(f) - t} & 
                      Stat7: d notin {x in f - {c} | car(x) in domain(f) - t}
    d1 --> Stat6 ==> d in f & car(d) in domain(f) - t
    d --> Stat7 ==> d notin f - {c}
    ELEM ==> false; Discharge ==> f ON (domain(f) - t) = (f - {c}) ON (domain(f - {c}) - t)
    ELEM ==> f - {c} incin f & f - {c} /= f
    (f - {c},f) --> T27 ==> is_map(f - {c})
    (f - {c},f) --> T243 ==> range(f - {c}) incin s
    (f - {c},t) --> Stat2 ==> 
      (sigma(f - {c}) = sigma((f - {c}) ON (domain(f - {c}) * t)) PLUZ sigma(f ON domain(f) - t))
      
    
      
Theorem: [Rearrangement-of-sums Theorem] 
    ((FORALL f in OM | (FORALL g | ((Finite(f) & Finite(g) & Svm(f) & Svm(g) & domain(f) = domain(g)) imp 
        sigma(f) = sigma({[y,sigma(f INV_IM {y})]: y in range(g)}))))). Proof:

Theorem: [Sum Permutation Theorem] 
    (FORALL f in OM | (FORALL g | ((Finite(f) & Finite(g) & Svm(f) & one_1_map(g) & domain(f) = domain(g)) imp 
        sigma(f) = sigma({[y,sigma(f INV_IM {y})]: y in range(g)})))). 


DISPLAY sigma_theory  [After the theory of sigma has been developed]

THEORY sigma_theory(s,PLUZ,e)  [Contains some elementary lemmas about single-valued functions]
    (FORALL x in s | (x PLUZ e = x))
    (FORALL x in s | (FORALL y in s | (x PLUZ y = y PLUZ x)))
    (FORALL x in s | (FORALL y in s| (FORALL z in s | ((x PLUZ y) PLUZ z = x PLUZ (y PLUZ z)))))
==> (sigma)
    (FORALL f in OM | (Finite(f) & Svm(f) & range(f) incin s) imp (sigma(f) in s)) & sigma({}) = e & 
      (FORALL x | sigma({x}) = cdr({x}) & (FORALL t | sigma(f ON (domain(f) * t)) PLUZ sigma(f ON (domain(f) - t)))) &
    (FORALL f in OM | (FORALL g | ((Finite(f) & Finite(g) & Svm(f) & Svm(g) & domain(f) = domain(g)) imp 
        (sigma(f) = sigma({[y,sigma(f INV_IM {y})]: y in range(g)})))))
END sigma_theory;

ENTER_THEORY set_theory

THEORY equivalence_classes(P,s) [Theory of equivalence classes]
    (FORALL x in s | (FORALL y in s | (P(x,y) eq P(y,x)) & P(x,x)))
    (FORALL x in s | (FORALL y in s | (FORALL z in s | ((P(x,y) & P(y,z)) imp P(x,z)))))
==> 
END equivalence_classes;

ENTER_THEORY equivalence_classes

    Loc_def ==> f(x) := {z in s | P(x,z)}
    Loc_def ==> Eqc := {f(x): x in s} 

Theorem: (FORALL x in s | (FORALL y in s | P(x,y) eq f(x) = f(y))). Proof:
    Suppose_not(x,y) ==> x in s & y in s & (not(P(x,y) eq f(x) = f(y)))
    Suppose ==> P(x,y) & f(x) /= f(y)
    Use_Def(f) ==> {z in s | P(x,z)} /= {z in s | P(y,z)}
    Memb(c) ==> not(c in {z in s | P(x,z)} eq c in {z in s | P(y,z)})
    Defmemb ==> not ((c in s & P(x,c)) eq (c in s & P(y,c)))
    ELEM ==> (c in s & (P(x,c) & (not P(y,c)))) or ((not P(x,c)) & P(y,c))
    Suppose ==> P(x,c) & (not P(y,c))
    (x,y) --> Assump.1 ==> P(y,x)
    (x,y,c) --> Assump.2 ==> false; Discharge ==> (not P(x,c)) & P(y,c)
    (x,y,c) --> Assump.2 ==> false; Discharge ==> (not P(x,y)) & f(x) = f(y)
    Use_Def(f) ==> {z in s | P(x,z)} = {z in s | P(y,z)}
    Suppose ==> y notin {z in s | P(y,z)}
    Defmemb ==> false; Discharge ==> y in {z in s | P(x,z)}
    Defmemb ==> false; Discharge ==> QED

Theorem: (FORALL x in s | f(x) in Eqc) & (FORALL y in Eqc | g1(y) in s & f(arb(y)) = y). Proof: 
    Suppose_not(x,y) ==> (x in s & f(x) notin Eqc) or (y in Eqc & (arb(y) notin s or f(g1(y)) /= y))
    Use_Def(Eqc) ==> 
      (x in s & f(x) notin {f(x): x in s}) or (y in {f(x): x in s} & (arb(y) notin s or f(arb(y)) /= y))
    Suppose ==> x in s & f(x) notin {f(x): x in s}
    Defmemb ==> false; Discharge ==> Stat1: y in {f(x): x in s} & (arb(y) notin s or f(arb(y)) /= y)
    c --> Stat1 ==> y = f(c) & c in s
    Suppose ==> c notin f(c)
    Use_Def(f) ==> c notin {z in s | P(c,z)} & f(c) = {z in s | P(c,z)}
    Defmemb ==> not P(c,z)
    (c,c) --> Assump.1 ==> false; Discharge ==> c in f(c)
    ELEM ==> f(c) /= 0
    f(c) --> Ax_ch ==> arb(f(c)) in f(c)
    ELEM ==> arb(y) in {z in s | P(c,z)}
    ELEM ==> arb(y) in s & P(c,arb(y))
    Defmemb ==> f(arb(y)) /= {z in s | P(c,z)}
    Use_Def(f) ==> {z in s | P(arb(y),z)} /= {z in s | P(c,z)}
    Memb(c) ==> not(d in {z in s | P(arb(y),z)} eq d in {z in s | P(c,z)})
    Defmemb ==> not ((d in s & P(arb(y),d)) eq (d in s & P(c,d)))
    ELEM ==> d in s & ((P(arb(y),d) & (not P(c,d))) or ((not P(arb(y),d)) & P(c,d)))
    Suppose ==> P(arb(y),d) & (not P(c,d))
    (arb(y),c) --> Assump.1 ==> P(arb(y),c)
    (arb(y),c,d) --> Assump.2 ==> false; Discharge ==> (not P(arb(y),d)) & P(c,d)
    (arb(y),c,d) --> Assump.2 ==> false; Discharge ==> QED

Theorem: (FORALL x in s | P(x,arb(f(x)))). Proof: 
    Suppose_not(x) ==> x in s & (not P(x,arb(f(x))))
    (x,f(x)) --> T99999 ==> f(x) in Eqc & arb(f(x)) in s & f(arb(f(x))) = f(x)
    (x,arb(f(x))) --> T99999 ==> P(x,arb(f(x)))
    ELEM ==> false; Discharge ==> QED
    
ENTER_THEORY set_theory
    
DISPLAY equivalence_classes 

THEORY equivalence_classes(P,s) [Theory of equivalence classes]
    (FORALL x in s | (FORALL y in s | (P(x,y) eq P(y,x)) & P(x,x)))
    (FORALL x in s | (FORALL y in s | (FORALL z in s | ((P(x,y) & P(y,z)) imp P(x,z)))))
==>(Eqc,f)
    (FORALL x in s | f(x) in Eqc) & (FORALL y in Eqc | arb(y) in s & f(arb(y)) = y) 
    (FORALL x in s | (FORALL y in s | P(x,y) eq f(x) = f(y)))
    (FORALL x in s | P(x,arb(f(x))))
END equivalence_classes;

Def 35: Fr := {[x,y]: x in Si, y in Si | y /= [0,0]}
Def 36: Same_frac(P,Q) := car(P) S_TIMES cdr(Q) = cdr(P) S_TIMES car(Q)

Theorem 245: (FORALL x in Fr | (FORALL y in Fr | (Same_frac(x,y) eq Same_frac(y,x)) & Same_frac(x,x))). Proof: 
    Suppose_not(x,y) ==> x in Fr & y in Fr & (not(Same_frac(x,y) eq Same_frac(y,x)) or (not Same_frac(x,x)))
    Use_Def(Fr) ==> Stat1: x in {[x,y]: x in Si, y in Si | y /= [0,0]} & y in {[x,y]: x in Si, y in Si | y /= [0,0]}
    (a,b,c,d) --> Stat1 ==> x = [a,b] & a in Si & b in Si & y = [c,d] & d in Si & d in Si
    Suppose ==> not Same_frac(x,x)
    Use_Def(Same_frac) ==> false; Discharge ==> not(Same_frac(x,y) eq Same_frac(y,x))
    Suppose ==> Same_frac(x,y) & (not Same_frac(y,x))
    Use_Def(Same_frac) ==> a S_TIMES c = b S_TIMES d & c S_TIMES a /= d S_TIMES b
    ALGEBRA ==> false; Discharge ==> Same_frac(x,y) & (not Same_frac(y,x))
    Use_Def(Same_frac) ==> c S_TIMES a = d S_TIMES b & a S_TIMES c /= b S_TIMES d
    ALGEBRA ==> false; Discharge ==> QED
    
Theorem 246: (FORALL x in Fr | (FORALL y in Fr | (FORALL z in Fr | 
            ((Same_frac(x,y) & Same_frac(y,z)) imp Same_frac(x,z))))). Proof: 
    Suppose_not(x,y,z) ==> x in Fr & y in Fr & z in Fr & Same_frac(x,y) & Same_frac(y,z) & (not Same_frac(x,z))
    Use_Def(Fr) ==> x in {[x,y]: x in Si, y in Si | y /= [0,0]} & 
                y in {[x,y]: x in Si, y in Si | y /= [0,0]} & z in {[x,y]: x in Si, y in Si | y /= [0,0]}
    Use_Def(PROD) ==> 
      Stat1: x in {[x,y]: x in Si, y in Si} & y in {[x,y]: x in Si, y in Si} & z in {[x,y]: x in Si, y in Si}
    (a,b,c,d,e,f) --> Stat1 ==> 
        x = [a,b] & a in Si & b in Si & y = [c,d] & d in Si & d in Si & z = [e,f] & e in Si & f in Si & d /= [0,0]
    Use_Def(Same_frac) ==> a S_TIMES d = b S_TIMES c & c S_TIMES f = d S_TIMES e & a S_TIMES f /= b S_TIMES e
    ELEM ==> (a S_TIMES d) S_TIMES f = (b S_TIMES c) S_TIMES f
    ALGEBRA ==> (a S_TIMES d) S_TIMES f = (a S_TIMES f) S_TIMES d & (b S_TIMES c) S_TIMES f = b S_TIMES (c S_TIMES f) 
    ELEM ==> (a S_TIMES f) S_TIMES d = b S_TIMES (d S_TIMES e) 
    ALGEBRA ==> b S_TIMES (d S_TIMES e) = (b S_TIMES e) S_TIMES d
    ELEM ==> (a S_TIMES f) S_TIMES d = (b S_TIMES e) S_TIMES d 
    (a S_TIMES f,d,b S_TIMES e) --> T234 ==> false; Discharge ==> QED

APPLY(Ra,Fr_to_Ra) equivalence_classes(P(x,y)->Same_frac(x,y),s->Fr) ==>
    (FORALL x in Fr | Fr_to_Ra(x) in Ra) & 
    (FORALL x in Ra | arb(x) in Fr & Fr_to_Ra(arb(x)) = x) &
    (FORALL x in Fr | (FORALL y in Fr | (Same_frac(x,y) eq (Fr_to_Ra(x) = Fr_to_Ra(y))))) &
    (FORALL x in Fr | Same_frac(x,arb(Fr_to_Ra(x)))) 

                      [Note: Ra is the set of rational numbers.]

Theorem 247: (FORALL y in Ra | arb(y) in Fr & Fr_to_Ra(arb(y)) = y) & (FORALL x in Fr | Fr_to_Ra(x) in Ra) & 
                (FORALL x in Fr | (FORALL y in Fr | Same_frac(x,y) eq Fr_to_Ra(x) = Fr_to_Ra(y))) &
                  (FORALL x in Fr | Same_frac(x,arb(Fr_to_Ra(x))))

Def 37: Ra_0 := Fr_to_Ra([[0,0],[1,0]])
Def 37a: Ra_1 := Fr_to_Ra([[1,0],[1,0]])
Def 38: [Rational Sum] Def(x Ra_PLUS y) := 
    Fr_to_Ra([(car(arb(x)) S_TIMES cdr(arb(y))) S_PLUS (car(arb(y)) S_TIMES cdr(arb(x))),
                                  cdr(arb(x)) S_TIMES cdr(arb(y))])
Def 38: [Rational product] 
    Def(x Ra_TIMES y) := Fr_to_Ra([car(arb(x)) S_TIMES car(arb(y)),cdr(arb(x)) S_TIMES cdr(arb(y))])
Def 40: [Reciprocal] Recip(x) := Fr_to_Ra([cdr(arb(x)),car(arb(x))])
Def 41: [Rational quotient] Def(x Ra_OVER y) := x Ra_TIMES Recip(y)
Def 42: [Rational negative] 
    Ra_Rev(x) := Fr_to_Ra([S_Rev(car(arb(x))),cdr(arb(x))])
Def 43: [Nonnegative Rational] Ra_is_nonneg(X) := is_nonneg(car(arb(X)) S_TIMES cdr(arb(X)))
Def 44: [Rational Subtraction] Def(x Ra_MINUS y) := x Ra_PLUS Ra_Rev(y)

Def 45: [Rational Comparison] Def(X Ra_GT Y) := Ra_is_nonneg(X Ra_MINUS Y) & X /= Y   
    
THEORY Ordered_add(g,e,pluz,minz,rvz,nneg);
    e in g & (FORALL x in g | (x pluz e = x & x pluz rvz(x) = e & rvz(x) in g)) 
    (FORALL x in g | (FORALL y in g | (x pluz y in g & x pluz y = y pluz x & x pluz rvz(y) = x minz y)))
    (FORALL x in g | (FORALL y in g | (FORALL z in g | ((x pluz y) pluz z = x pluz (y pluz z)))))
    (FORALL x in g | (FORALL y in g | ((nneg(x) & nneg(y)) imp (nneg(x pluz y)))))
    (FORALL x in g | (nneg(x) or nneg(rvz(x))) & nneg(x) & nneg(rvz(x)) imp (x = e))
==>
END Ordered_add;

ENTER_THEORY Ordered_add    [Note that no theorems need to be proved since a decision algorithm is available]
    Loc_def ==> Def(X g_GE Y) := nneg(X pluz rvz(Y))
    Loc_def ==> Def(X g_LE Y) := Y g_GE X
    Loc_def ==> Def(X g_GT Y) := X g_GE Y & X /= Y
    Loc_def ==> Def(X g_LT Y) := Y g_GT X
              
ENTER_THEORY Set_theory

DISPLAY Ordered_add

THEORY Ordered_add(g,e,pluz,minz,rvz,nneg);
    e in g & (FORALL x in g | (x pluz e = x & x pluz rvz(x) = e & rvz(x) in g))
    (FORALL x in g | (FORALL y in g | (x pluz y in g & x pluz y = y pluz x & x pluz rvz(y) = x minz y)))
    (FORALL x in g | (FORALL y in g | (FORALL z in g | ((x pluz y) pluz z = x pluz (y pluz z)))))
    (FORALL x in g | (FORALL y in g | ((nneg(x) & nneg(y)) imp (nneg(x pluz y)))))
    (FORALL x in g | (((nneg(x) or nneg(rvz(x))) & ((nneg(x) & nneg(rvz(x))))) imp (x = e)))
==>(g_GE,g_LE,g_GT,g_LT)
    X g_GE Y eq nneg(X pluz rvz(Y))
    X g_LE Y eq Y g_GE X
    X g_GT Y eq X g_GE Y & X /= Y
    X g_LT Y eq Y g_GT X
END Ordered_add;

Theorem 248: (X in Si) imp ((is_nonneg(X) or is_nonneg(S_Rev(X))) & ((is_nonneg(X) & is_nonneg(S_Rev(X))) imp (X = [0,0]))). Proof: 
		Suppose_not(x) ==> x in Si & 
      (not ((is_nonneg(x) or is_nonneg(S_Rev(x)))) & ((is_nonneg(x) & is_nonneg(S_Rev(x))) imp (x = [0,0])))
    x --> T197 ==> x = [car(x),cdr(x)] & (car(x) = 0 or cdr(x) = 0) & car(x) in Z & cdr(x) in Z
    Use_Def(is_nonneg) ==> is_nonneg(x) eq car(x) incs cdr(x) & is_nonneg(S_Rev(x)) eq car(S_Rev(x)) incs cdr(S_Rev(x))
    x --> T197 ==> x = Red(x)
    ([car(x),cdr(x)]) --> T214 ==> S_Rev(x) = Red([cdr(x),car(x)])
    ([car(x),cdr(x)]) --> T197 ==> [cdr(x),car(x)] in Si
    x --> T197 ==> S_Rev(x) = [cdr(x),car(x)]
    Suppose ==> is_nonneg(x) & is_nonneg(S_Rev(x))
    ELEM ==> x = [0,0] & (not(is_nonneg(x) or is_nonneg(S_Rev(x))))
    THUS ==> car(x) incs cdr(x) or cdr(x) incs car(x)
    ELEM ==> false; Discharge ==> QED

Theorem 249: ((X in Si & Y in Si & is_nonneg(X) & is_nonneg(Y))) imp (is_nonneg(X S_PLUS Y) & is_nonneg(X S_TIMES Y)). Proof: 
		Suppose_not(x,y) ==> x in Si & y in Si & is_nonneg(x) & is_nonneg(y) & 
                          (not(is_nonneg(x S_PLUS y) & is_nonneg(x S_TIMES y)))
    x --> T197 ==> x = [car(x),cdr(x)] & (car(x) = 0 or cdr(x) = 0) & car(x) in Z & cdr(x) in Z
    y --> T197 ==> y = [car(y),cdr(y)] & (car(y) = 0 or cdr(y) = 0) & car(y) in Z & cdr(y) in Z
    Use_Def(is_nonneg) ==> car(x) incs cdr(x) & car(y) incs cdr(y)
    ELEM ==> x = [car(x),0] & y = [car(y),0]
    Use_Def(S_PLUS) ==> x S_PLUS y = Red([car(x) PLUS car(y),0 PLUS 0])
    ALGEBRA ==> x S_PLUS y = Red([car(x) PLUS car(y),0]) & car(x) PLUS car(y) in Z & 0 in Z
    ([car(x) PLUS car(y),0]) --> T197 ==> [car(x) PLUS car(y),0] in Si
    x --> T197 ==> x S_PLUS y = [car(x) PLUS car(y),0]
    Use_Def(is_nonneg) ==> is_nonneg(x S_PLUS y)
    Use_Def(S_TIMES ) ==> 
      x S_TIMES y = Red([(car(x) TIMES car(y)) PLUS (0 TIMES 0),(car(x) TIMES 0) PLUS (car(y) TIMES 0)])
    ALGEBRA ==> x S_TIMES y = Red([car(x) TIMES car(y),0]) & car(x) TIMES car(y) in Z
    ([car(x) TIMES car(y),0]) --> T197 ==> [car(x) TIMES car(y),0] in Si
    x --> T197 ==> x S_TIMES y = [car(x) TIMES car(y),0]
    Use_Def(is_nonneg) ==> is_nonneg(x S_TIMES y)
    ELEM ==> false; Discharge ==> QED

APPLY(S_GE,S_LE,S_GT,S_LT) Ordered_add(g->Si,e->[0,0],pluz->S_PLUS,rvz->S_Rev,nneg->is_nonneg) ==>
Theorem 249a: (X S_GE Y eq nneg(X pluz S_Rev(Y))) & (X S_LE Y eq Y S_GE X) & 
          (X S_GT Y eq X S_GE Y & X /= Y) & (X S_LT Y eq Y S_GT X). Proof:

Theorem 250: (X in Si) imp is_nonneg(X S_TIMES X). Proof:
    Suppose_not(x) ==> x in Si & (not is_nonneg(x S_TIMES x))
    Suppose ==> is_nonneg(x)
    (x,x) --> T249 ==> false; Discharge ==> not is_nonneg(x)
    x --> T248 ==> is_nonneg(S_Rev(x))
    (S_Rev(x),S_Rev(x)) --> T249 ==> is_nonneg(S_Rev(x) S_TIMES S_Rev(x))
    ALGEBRA ==> S_Rev(x) S_TIMES S_Rev(x) = x S_TIMES x
    ELEM ==> false; Discharge ==> QED

Theorem 251: (X in Si & Y in Si & X /= [0,0] & is_nonneg(X)) imp (is_nonneg(X S_TIMES Y) eq is_nonneg(Y)). Proof:
    Suppose_not(x) ==> x in Si & y in Si & x /= [0,0] & is_nonneg(x) & (not (is_nonneg(x S_TIMES y) eq is_nonneg(x)))
    Suppose ==> is_nonneg(y)
    (x,y) --> T249 ==> false; Discharge ==> not (is_nonneg(y) & is_nonneg(x S_TIMES y))
    y --> T248 ==> is_nonneg(S_rev(y))
    (x,S_Rev(x)) --> T249 ==> is_nonneg(x S_TIMES S_Rev(y))
    ALGEBRA ==> is_nonneg(S_Rev(x S_TIMES y))
    (x S_TIMES y) --> T248 ==> x S_TIMES y = [0,0]
    (x,y) --> T234 ==> y = [0,0]
    Use_Def(is_nonneg) ==> false; Discharge ==> QED

Theorem 252: X in Fr eq (X = [car(X),cdr(X)] & car(X) in Si & cdr(X) in Si & cdr(X) /= [0,0]). Proof:
    Suppose_not(x) ==> not(x in Fr eq (x = [car(x),cdr(x)] & car(x) in Si & cdr(x) in Si))
    Suppose_not ==> x in Fr & (not(x = [car(x),cdr(x)] & car(x) in Si & cdr(x) in Si))
    Use_Def(Fr) ==> Stat1: x in {[u,y]: u in Si, y in Si | y /= [0,0]}
    (u,y) --> Stat1 ==> x = [u,y] & u in Si & y in Si & y /= [0,0]
    ELEM ==> false; Discharge ==> x = [car(x),cdr(x)] & car(x) in Si & cdr(x) in Si & cdr(x) /= [0,0] & (not(x in Fr))
    Use_Def(Fr) ==> Stat2: x notin {[u,y]: u in Si, y in Si | y /= [0,0]}
    (car(x),car(x)) --> Stat2 ==> not(x = [car(x),cdr(x)] & car(x) in Si & cdr(x) in Si & cdr(x) /= [0,0])
    ELEM ==> false; Discharge ==> QED

Theorem 253: (N in Ra) imp (arb(N) in Fr & arb(N) = [car(arb(N)),cdr(arb(N))] & car(arb(N)) in Si & 
                                cdr(arb(N)) in Si & cdr(arb(N)) /= [0,0]). Proof:
    Suppose_not(n) ==> 
      n in Ra & (not(arb(n) in Fr) & arb(n) = [car(arb(n)),cdr(arb(n))] & car(arb(n)) in Si & cdr(arb(n)) in Si)
    n --> T247 ==> arb(n) in Fr & Fr_to_Ra(arb(n)) = n
    (arb(n)) --> T252 ==> false; Discharge ==> QED

Theorem 254: (X in Fr & Y in Fr & Same_frac(X,Y) & W in Fr & Z in Fr & Same_frac(W,Z)) imp 
    Same_frac([(car(X) S_TIMES cdr(W)) S_PLUS (car(W) S_TIMES cdr(X)),cdr(X) S_TIMES cdr(W)],
      [(car(Y) S_TIMES cdr(Z)) S_PLUS (car(Z) S_TIMES cdr(Y)),cdr(Y) S_TIMES cdr(Z)]). Proof: 
		Suppose_not(x,y,w,z) ==> x in Fr & y in Fr & Same_frac(x,y) & w in Fr & z in Fr & Same_frac(w,z) & 
      (not Same_frac([(car(x) S_TIMES cdr(w)) S_PLUS (car(w) S_TIMES cdr(x)),cdr(x) S_TIMES cdr(w)],
                [(car(y) S_TIMES cdr(z)) S_PLUS (car(z) S_TIMES cdr(y)),cdr(y) S_TIMES cdr(z)])) 
    x --> T252 ==> x = [car(x),cdr(x)] & car(x) in Si & cdr(x) in Si
    y --> T252 ==> y = [car(y),cdr(y)] & car(y) in Si & cdr(y) in Si
    w --> T252 ==> w = [car(w),cdr(w)] & car(w) in Si & cdr(w) in Si
    z --> T252 ==> z = [car(z),cdr(z)] & car(z) in Si & cdr(z) in Si
    Use_Def(Same_frac) ==> 
      (car(x) S_TIMES cdr(y) = cdr(x) S_TIMES car(y)) & (car(w) S_TIMES cdr(z) = cdr(w) S_TIMES car(z))
         & ((car(x) S_TIMES cdr(w)) S_PLUS (car(w) S_TIMES cdr(x))) S_TIMES (cdr(y) S_TIMES cdr(z)) /= 
            ((car(y) S_TIMES cdr(z)) S_PLUS (car(z) S_TIMES cdr(y))) S_TIMES (cdr(x) S_TIMES cdr(w))
    ALGEBRA ==> ((car(x) S_TIMES cdr(w)) S_PLUS (car(w) S_TIMES cdr(x))) S_TIMES (cdr(y) S_TIMES cdr(z)) = 
            ((car(x) S_TIMES cdr(y)) S_TIMES (cdr(w) S_TIMES cdr(z))) S_PLUS 
                  ((car(w) S_TIMES cdr(z)) S_TIMES (cdr(y) S_TIMES cdr(x)))
    ALGEBRA ==> ((car(y) S_TIMES cdr(z)) S_PLUS (car(z) S_TIMES cdr(y))) S_TIMES (cdr(x) S_TIMES cdr(w)) =
            ((car(y) S_TIMES cdr(x)) S_TIMES (cdr(w) S_TIMES cdr(z))) S_PLUS 
                  ((car(z) S_TIMES cdr(w)) S_TIMES (cdr(y) S_TIMES cdr(x)))
    ELEM ==> false; Discharge ==> QED
    
Theorem 255: (X in Fr & Y in Fr & Same_frac(X,Y) & W in Fr & Z in Fr & Same_frac(W,Z)) imp 
    Same_frac([car(X) S_TIMES car(W),cdr(X) S_TIMES cdr(W)],[car(Y) S_TIMES car(Z),cdr(Y) S_TIMES cdr(Z)]). Proof:
    Suppose_not(x,y,w,z) ==> x in Fr & y in Fr & Same_frac(x,y) & w in Fr & z in Fr & Same_frac(w,z) & 
      (not Same_frac([car(x) S_TIMES car(w),cdr(x) S_TIMES cdr(w)],[car(y) S_TIMES car(z),cdr(y) S_TIMES cdr(z)])) 
    x --> T252 ==> x = [car(x),cdr(x)] & car(x) in Si & cdr(x) in Si
    y --> T252 ==> y = [car(y),cdr(y)] & car(y) in Si & cdr(y) in Si
    w --> T252 ==> w = [car(w),cdr(w)] & car(w) in Si & cdr(w) in Si
    z --> T252 ==> z = [car(z),cdr(z)] & car(z) in Si & cdr(z) in Si
    Use_Def(Same_frac) ==> 
      (car(x) S_TIMES cdr(y) = cdr(x) S_TIMES car(y)) & (car(w) S_TIMES cdr(z) = cdr(w) S_TIMES car(z))
         & (car(x) S_TIMES car(w)) S_TIMES (cdr(y) S_TIMES cdr(z)) /= 
                            (car(y) S_TIMES car(z)) S_TIMES (cdr(x) S_TIMES cdr(w))
    ALGEBRA ==> (car(x) S_TIMES car(w)) S_TIMES (cdr(y) S_TIMES cdr(z)) = 
                      (car(x) S_TIMES cdr(y)) S_TIMES (car(w) S_TIMES cdr(z))
    ALGEBRA ==> (car(y) S_TIMES car(z)) S_TIMES (cdr(x) S_TIMES cdr(w)) = 
                      (car(x) S_TIMES cdr(y)) S_TIMES (car(w) S_TIMES cdr(z))
    ELEM ==> false; Discharge ==> QED
    
Theorem 256: (X in Ra & Y in Si & Z in Si & Z /= [0,0]) imp (X Ra_PLUS Fr_to_Ra([Y,Z]) = 
    Fr_to_Ra([(car(arb(X)) S_TIMES Z) S_PLUS (cdr(arb(X)) S_TIMES Y),(cdr(arb(X)) S_TIMES Z)])). Proof:
    Suppose_not(x,y,z) ==> x in Ra & y in Si & z in Si & z /= [0,0] & x Ra_PLUS Fr_to_Ra([y,z]) /= 
            Fr_to_Ra([(car(arb(x)) S_TIMES z) S_PLUS (cdr(arb(x)) S_TIMES y),cdr(arb(x)) S_TIMES z])
    x --> T252 ==> arb(x) = [car(arb(x)),cdr(arb(x))] & car(arb(x)) in Si & cdr(arb(x)) in Si & cdr(arb(x)) /= [0,0]  
    (car([y,z]),cdr([y,z])) --> T252 ==> [y,z] in Fr
    T247 ==> Stat1: (FORALL x in Fr | (FORALL y in Fr | Same_frac(x,y) eq Fr_to_Ra(x) = Fr_to_Ra(y)))
    ([y,z]) --> Stat1 ==> Same_frac([y,z],arb(Fr_to_Ra([y,z])))
    (x,x) --> T245 ==> Same_frac(x,x)
    Use_Def(Ra_PLUS) ==> x Ra_PLUS Fr_to_Ra([y,z]) = 
      Fr_to_Ra([(car(arb(x)) S_TIMES cdr(arb(Fr_to_Ra([y,z])))) S_PLUS (car(arb(Fr_to_Ra([y,z]))) S_TIMES cdr(arb(x))),
                                  cdr(arb(x)) S_TIMES cdr(arb(Fr_to_Ra([y,z])))])
    ([y,z],arb(Fr_to_Ra([y,z])),x,x) --> T254 ==> x Ra_PLUS Fr_to_Ra([y,z]) = 
      Fr_to_Ra([(car(arb(x)) S_TIMES z) S_PLUS (y S_TIMES cdr(arb(x))), cdr(arb(x)) S_TIMES z])
    ALGEBRA ==> false; Discharge ==> QED
    
Theorem 257: (X in Ra & Y in Si & Z in Si & Z /= [0,0]) imp (X Ra_TIMES Fr_to_Ra([Y,Z]) = 
                        Fr_to_Ra([car(arb(X)) S_TIMES Y,cdr(arb(X)) S_TIMES Z])). Proof:
    Suppose_not(x,y,z) ==> x in Ra & y in Si & z in Si & z /= [0,0] & x Ra_PLUS Ra_TIMES([y,z]) /= 
            Fr_to_Ra([car(arb(x)) S_TIMES y,cdr(arb(x)) S_TIMES z])
    x --> T253 ==> arb(x) = [car(arb(x)),cdr(arb(x))] & car(arb(x)) in Si & cdr(arb(x)) in Si & cdr(arb(x)) /= [0,0]  
    ([y,z]) --> T252 ==> [y,z] in Fr
    T247 ==> Stat1: (FORALL x in Fr | (FORALL y in Fr | Same_frac(x,y) eq Fr_to_Ra(x) = Fr_to_Ra(y)))
    ([y,z]) --> Stat1 ==> Same_frac([y,z],arb(Fr_to_Ra([y,z])))
    (x,x) --> T245 ==> Same_frac(x,x)
    Use_Def(Ra_TIMES) ==> x Ra_TIMES Fr_to_Ra([y,z]) = 
      Fr_to_Ra([car(arb(x)) S_TIMES car(arb(Fr_to_Ra([y,z]))), cdr(arb(x)) S_TIMES cdr(arb(Fr_to_Ra([y,z])))])
    ([y,z],arb(Fr_to_Ra([y,z])),x,x) --> T255 ==> x Ra_TIMES Fr_to_Ra([y,z]) = 
                          Fr_to_Ra([car(arb(x)) S_TIMES y, cdr(arb(x)) S_TIMES z])
    ELEM ==> false; Discharge ==> QED
    
Theorem 258: (X in Fr) imp Same_frac(X,[Si_Rev(car(X)),Si_Rev(cdr(X))]). Proof: 
    Suppose_not(x) ==> x in Fr & (not Same_frac(x,[Si_Rev(car(x)),Si_Rev(cdr(x))]))
    x --> T252 ==> x = [car(x),cdr(x)] & car(x) in Si & cdr(x) in Si & cdr(x) /= [0,0] 
    Use_Def(Same_frac) ==> car(x) S_TIMES Si_Rev(cdr(x)) /= cdr(x) S_TIMES Si_Rev(car(x))
    ALGEBRA ==> false; Discharge ==> QED

Theorem 259: (X in Fr & Y in Fr & Same_frac(X,Y) & is_nonneg(cdr(X)) & is_nonneg(cdr(Y))) imp 
              ((is_nonneg(car(X)) or car(X) = [0,0]) eq (is_nonneg(car(Y)) or car(Y) = [0,0])). Proof: 
    Suppose_not(x,y) ==> x in Fr & y in Fr & Same_frac(x,y) & is_nonneg(cdr(x)) & is_nonneg(cdr(y)) & 
              (not ((is_nonneg(car(x)) or car(x) = [0,0]) eq (is_nonneg(car(y)) or car(y) = [0,0])))
    x --> T252 ==> x = [car(x),cdr(x)] & car(x) in Si & cdr(x) in Si & cdr(x) /= [0,0] 
    y --> T252 ==> y = [car(y),cdr(y)] & car(y) in Si & cdr(y) in Si & cdr(y) /= [0,0] 
    Use_Def(Same_frac) ==> car(x) S_TIMES cdr(y) = cdr(x) S_TIMES car(y)
    Suppose ==> Stat1: car(x) = [0,0]
    ALGEBRA ==> cdr(x) S_TIMES car(y) = [0,0]
    (cdr(x)) --> T234 ==> car(y) = [0,0]
    ELEM ==> false; Discharge ==> Stat2: car(x) /= [0,0]
    LIKEWISE(Stat2-Stat2,x->y,y->x) ==> car(y) /= [0,0]
    ELEM ==> not (is_nonneg(car(x)) eq is_nonneg(car(y)))
    Use_Def(Same_frac) ==> car(x) S_TIMES cdr(y) = cdr(x) S_TIMES car(y)
    ALGEBRA ==> car(x) S_TIMES car(y) in Si
    Suppose ==> Stat1: is_nonneg(car(x))
    ELEM ==> not is_nonneg(car(y))
    (car(x),cdr(y)) --> T249 ==> is_nonneg(car(x) S_TIMES cdr(y))
    (car(y)) --> T248 ==> is_nonneg(S_Rev(car(y)))
    (cdr(x),S_Rev(car(y))) --> T249 ==> is_nonneg(cdr(x) S_TIMES S_Rev(car(y)))
    ALGEBRA ==> is_nonneg(S_Rev(cdr(x) S_TIMES car(y)))
    ELEM ==> is_nonneg(S_Rev(car(x) S_TIMES cdr(y)))
    (car(x) S_TIMES car(y)) --> T248 ==> car(x) S_TIMES car(y) = [0,0]
    ELEM ==> false; Discharge ==> Stat2: not is_nonneg(car(y)) & is_nonneg(car(y))
    LIKEWISE(Stat1-Stat2,x->y,y->x) ==> false; Discharge ==> QED

Theorem 261: 
    (X in Fr & Y in Fr & Same_frac(X,Y)) imp (is_nonneg(car(X) S_TIMES cdr(X)) eq is_nonneg(car(Y) S_TIMES cdr(Y))).   Proof: 
		Suppose_not(x,y) ==> x in Fr & y in Fr & Same_frac(x,y) & 
              (not (is_nonneg(car(x) S_TIMES cdr(x)) eq is_nonneg(car(y) S_TIMES cdr(y))))
    x --> T252 ==> x = [car(x),cdr(x)] & car(x) in Si & cdr(x) in Si & cdr(x) /= [0,0]
    y --> T252 ==> y = [car(y),cdr(y)] & car(y) in Si & cdr(y) in Si & cdr(y) /= [0,0]
    Loc_def ==> ax := car(x)
    Loc_def ==> dx := cdr(x)
    Loc_def ==> ay := car(y)
    Loc_def ==> dy := cdr(y)
    Use_Def(Same_frac) ==> ax S_TIMES dy = ay S_TIMES dx
    ELEM ==> (ax S_TIMES dy) S_TIMES (dx S_TIMES dy) = ay S_TIMES dx S_TIMES (dx S_TIMES dy)
    ALGEBRA ==> (dy S_TIMES dy) S_TIMES (ax S_TIMES dx) = (dx S_TIMES dx) S_TIMES (ay S_TIMES dy)
    dx --> T250 ==> is_nonneg(dx S_TIMES dx)
    dy --> T250 ==> is_nonneg(dy S_TIMES dy)
    (dy S_TIMES dy,ax S_TIMES dx) --> T251 ==> 
      is_nonneg((dy S_TIMES dy) S_TIMES (ax S_TIMES dx)) eq is_nonneg(ax S_TIMES dx)
    (dx S_TIMES dx,ay S_TIMES dy) --> T251 ==> 
      is_nonneg((dx S_TIMES dx) S_TIMES (ay S_TIMES dy)) eq is_nonneg(ay S_TIMES dy)
    ELEM ==> false; Discharge ==> QED

Theorem 262: (X in Fr) imp (Ra_is_nonneg(X) eq Ra_is_nonneg([S_Rev(car(X)),S_Rev(cdr(X))])). Proof: 
    Suppose_not(n) ==> n in Fr & (not(Ra_is_nonneg(n) eq Ra_is_nonneg([S_Rev(car(n)),S_Rev(cdr(n))])))
    n --> T252 ==> n = [car(n),cdr(n)] & car(n) in Si & cdr(n) in Si & cdr(n) /= [0,0]     
    (car(n)) --> T197 ==> (car(n) = [car(car(n)),0] or car(n) = [0,cdr(car(n))]) & car(car(n)) in Z & cdr(car(n)) in Z
    (cdr(n)) --> T197 ==> (cdr(n) = [car(cdr(n)),0] or cdr(n) = [0,cdr(cdr(n))]) & car(cdr(n)) in Z & cdr(cdr(n)) in Z
    Use_Def(Ra_is_nonneg) ==> Stat1: Ra_is_nonneg(n) eq ((is_nonneg(car(n)) eq is_nonneg(cdr(n))) or car(n) = [0,0])
    Suppose ==> car(n) = 0
    Use_Def(S_sgn) ==> S_sgn(car(n)) = if car(n) = [car(car(n)),0] then 1 else 0 end if & 
                S_sgn(cdr(n)) = if cdr(n) = [car(cdr(n)),0] then 1 else 0 end if
    Use_Def(S_Rev) ==> S_Rev(car(n)) = [cdr(car(n)),car(car(n))] & S_Rev(cdr(n)) = [cdr(cdr(n)),car(cdr(n))]
    Suppose ==> car(n) = [car(car(n)),0]
    ELEM ==> S_sgn(car(n)) = 1 & S_Rev(car(n)) = [0,car(car(n))]
    Suppose ==> cdr(n) = [car(cdr(n)),0]
    ELEM ==> S_Rev(cdr(n)) = [0,car(cdr(n))] & TO_BE_CONTINUED

Theorem 263: (X in Fr & Y in Fr & Same_frac(X,Y)) imp (Ra_is_nonneg(X) eq Ra_is_nonneg(Y)). Proof: 
    Suppose_not(n,m) ==> n in Fr & m in Fr & Same_frac(n,m) & (not(Ra_is_nonneg(n) eq Ra_is_nonneg(m)))
    n --> T252 ==> n = [car(n),cdr(n)] & car(n) in Si & cdr(n) in Si & cdr(n) /= 0     
    m --> T252 ==> m = [car(m),cdr(m)] & car(m) in Si & cdr(m) in Si & cdr(m) /= 0 
    (car(n)) --> T197 ==> (car(n) = [car(car(n)),0] or car(n) = [0,cdr(car(n))]) & car(car(n)) in Z & cdr(car(n)) in Z
    (car(m)) --> T197 ==> (car(m) = [car(car(m)),0] or car(n) = [0,cdr(car(m))]) & car(car(m)) in Z & cdr(car(m)) in Z
    (cdr(n)) --> T197 ==> (cdr(n) = [car(cdr(n)),0] or cdr(n) = [0,cdr(cdr(n))]) & car(cdr(n)) in Z & cdr(cdr(n)) in Z
    (cdr(m)) --> T197 ==> (cdr(m) = [car(cdr(m)),0] or cdr(m) = [0,cdr(cdr(m))]) & car(cdr(m)) in Z & cdr(cdr(m)) in Z
    Loc_def ==> an := car(car(n))
    Loc_def ==> am := car(car(m))
    Loc_def ==> dn := cdr(car(n))
    Loc_def ==> dm := cdr(car(m))
    Use_Def(Ra_is_nonneg) ==> (not (is_nonneg(an S_TIMES dn) eq is_nonneg(am S_TIMES dm))) & is_nonneg([0,0])
    Use_Def(Same_frac) ==> an S_TIMES dm = am S_TIMES dn
    ALGEBRA ==> [0,0] S_TIMES dm = [0,0] & [0,0] S_TIMES dn = [0,0]
    Suppose ==> an = [0,0] or am =[0,0]
    ELEM ==> false; Discharge ==> an /= [0,0] or am /= [0,0]
    (an,dn) --> T232 ==> an S_TIMES dn /= [0,0]
    (am,dm) --> T232 ==> am S_TIMES dm /= [0,0]
    dn --> T250 ==> is_nonneg(dn S_TIMES dn)
    dm --> T250 ==> is_nonneg(dm S_TIMES dm)
    Suppose ==> is_nonneg((an S_TIMES dn) S_TIMES (am S_TIMES dm))
    Suppose ==> is_nonneg(an S_TIMES dn)
    ELEM ==> not is_nonneg(am S_TIMES dm)
    (am S_TIMES dm) --> T248 ==> is_nonneg(S_Rev(am S_TIMES dm))
    (S_Rev(am S_TIMES dm),an S_TIMES dn) --> T250 ==> is_nonneg(S_Rev(am S_TIMES dm) S_TIMES (an S_TIMES dn))
    ALGEBRA ==> is_nonneg(S_Rev((an S_TIMES dn) S_TIMES (am S_TIMES dm)))
    ((an S_TIMES dn) S_TIMES (am S_TIMES dm)) --> T248 ==> (an S_TIMES dn) S_TIMES (am S_TIMES dm) = [0,0]
    ALGEBRA ==> false; Discharge ==> not is_nonneg(an S_TIMES dn)
    ELEM ==> is_nonneg(am S_TIMES dm) 
    (an S_TIMES dn) --> T248 ==> is_nonneg(S_Rev(an S_TIMES dn))
    (S_Rev(an S_TIMES dn),am S_TIMES dm) --> T250 ==> is_nonneg(S_Rev(an S_TIMES dn) S_TIMES (am S_TIMES dm))
    ALGEBRA ==> is_nonneg(S_Rev((an S_TIMES dn) S_TIMES (am S_TIMES dm)))
    ((an S_TIMES dn) S_TIMES (am S_TIMES dm)) --> T248 ==> (an S_TIMES dn) S_TIMES (am S_TIMES dm) = [0,0]
    ALGEBRA ==> false; Discharge ==> not is_nonneg((an S_TIMES dn) S_TIMES (am S_TIMES dm))
    ALGEBRA ==> not is_nonneg((an S_TIMES dm) S_TIMES (an S_TIMES dm))
    (an S_TIMES dm) --> T250 ==> false; Discharge ==> QED

Theorem 264: [Commutativity of Addition] (N in Ra & M in Ra) imp (N Ra_PLUS M = M Ra_PLUS N). Proof: 
    Suppose_not(n,m) ==> n in Ra & m in Ra & n Ra_PLUS m /= m Ra_PLUS n
    n --> T247 ==> arb(n) in Fr & Fr_to_Ra(arb(n)) = n
    m --> T247 ==> arb(m) in Fr & Fr_to_Ra(arb(m)) = m
    (arb(n)) --> T252 ==> 
      arb(n) = [car(arb(n)),cdr(arb(n))] & car(arb(n)) in Si & cdr(arb(n)) in Si & cdr(arb(n)) /= [0,0]     
    (arb(m)) --> T252 ==> 
      arb(m) = [car(arb(m)),cdr(arb(m))] & car(arb(m)) in Si & cdr(arb(m)) in Si & cdr(arb(m)) /= [0,0]     
    Use_Def(Ra_PLUS) ==> Fr_to_Ra([(car(arb(m)) S_TIMES cdr(arb(n))) S_PLUS (car(arb(n)) S_TIMES cdr(arb(m))),
                                  cdr(arb(m)) S_TIMES cdr(arb(n))]) /= 
          Fr_to_Ra([(car(arb(n)) S_TIMES cdr(arb(m))) S_PLUS (car(arb(m)) S_TIMES cdr(arb(n))),
                                  cdr(arb(n)) S_TIMES cdr(arb(m))])
    ELEM ==> (car(arb(m)) S_TIMES cdr(arb(n))) S_PLUS (car(arb(n)) S_TIMES cdr(arb(m))) /=                         
              (car(arb(n)) S_TIMES cdr(arb(m))) S_PLUS (car(arb(m)) S_TIMES cdr(arb(n))) or 
                cdr(arb(n)) S_TIMES cdr(arb(m)) /= cdr(arb(m)) S_TIMES cdr(arb(n))
    ALGEBRA ==> false; Discharge ==> QED
    
Theorem 265: (X in Ra & Y in Si & Z in Si & Z /= [0,0]) imp (Fr_to_Ra([Y,Z]) Ra_PLUS X = 
    Fr_to_Ra([(car(arb(X)) S_TIMES Z) S_PLUS (cdr(arb(X)) S_TIMES Y),(cdr(arb(X)) S_TIMES Z)])). Proof:
    Suppose_not(x,y,z) ==> x in Ra & y in Si & z in Si & z /= [0,0] & Fr_to_Ra([y,z]) Ra_PLUS x /= 
            Fr_to_Ra([(car(arb(x)) S_TIMES z) S_PLUS (cdr(arb(x)) S_TIMES y),cdr(arb(x)) S_TIMES z])
    (x,y,z) --> T256 ==> Fr_to_Ra([y,z]) Ra_PLUS x /= x Ra_PLUS Fr_to_Ra([y,z])
    (y,z) --> T252 ==> [y,z] in Fr
    (zz,[y,z]) --> T247 ==> Fr_to_Ra([y,z]) in Ra
    (x,Fr_to_Ra([y,z])) --> T264 ==> false; Discharge ==> QED
    
Theorem 266: (X in Ra & Y in Si & Z in Si & Z /= [0,0]) imp (Fr_to_Ra([Y,Z]) Ra_PLUS X = 
    Fr_to_Ra([(car(arb(X)) S_TIMES Z) S_PLUS (cdr(arb(X)) S_TIMES Y),(cdr(arb(X)) S_TIMES Z)])). Proof:
    Suppose_not(x,y,z) ==> x in Ra & y in Si & z in Si & z /= [0,0] & 
        Fr_to_Ra([y,z]) Ra_PLUS X /= Fr_to_Ra([(car(arb(x)) S_TIMES z) S_PLUS (cdr(arb(x)) S_TIMES y),(cdr(arb(x)) S_TIMES z)])
    ([x,y]) --> T252 ==> [x,y] in Fr
    T247 ==> Stat1: (FORALL x in Fr | Fr_to_Ra(x) in Ra) & Stat2: (FORALL x in Fr | Same_frac(x,arb(Fr_to_Ra(x))))
    ([x,y]) --> Stat1 ==> Fr_to_Ra([x,y]) in Ra
    (x,y) --> Stat2 ==> Same_frac([x,y],arb(Fr_to_Ra([x,y])))
    (Fr_to_Ra([x,y]),z,w) --> T256 ==> Fr_to_Ra([x,y]) Ra_PLUS Fr_to_Ra([z,w]) = 
        Fr_to_Ra([(car(abs(Fr_to_Ra([x,y])) S_TIMES w)) S_PLUS (z S_TIMES cdr(arb(Fr_to_Ra([x,y])))),
                                cdr(arb(Fr_to_Ra([x,y]))) S_TIMES w])
    ([x,y],abs(Fr_to_Ra([x,y]))) --> T254 ==> Fr_to_Ra([x,y]) Ra_PLUS Fr_to_Ra([z,w]) = 
        Fr_to_Ra([(x S_TIMES w) S_PLUS (z S_TIMES y),y S_TIMES w])
    ELEM ==> false; Discharge ==> QED

Theorem 267: [Commutativity of Multiplication] (N in Ra & M in Ra) imp (N Ra_TIMES M = M Ra_TIMES N). Proof: 
    Suppose_not(n,m) ==> n in Ra & m in Ra & (n Ra_PLUS m /= m Ra_PLUS n)
    n --> T247 ==> arb(n) in Fr & Fr_to_Ra(arb(n)) = n
    m --> T247 ==> arb(m) in Fr & Fr_to_Ra(arb(m)) = m
    (arb(n)) --> T252 ==> 
      arb(n) = [car(arb(n)),cdr(arb(n))] & car(arb(n)) in Si & cdr(arb(n)) in Si & cdr(arb(n)) /= [0,0]     
    (arb(m)) --> T252 ==> 
      arb(m) = [car(arb(m)),cdr(arb(m))] & car(arb(m)) in Si & cdr(arb(m)) in Si & cdr(arb(m)) /= [0,0]     
    Use_Def(Ra_TIMES) ==> Fr_to_Ra([car(arb(m)) S_TIMES car(arb(n)),cdr(arb(m)) S_TIMES cdr(arb(n))]) /= 
                Fr_to_Ra([car(arb(n)) S_TIMES car(arb(m)),cdr(arb(n)) S_TIMES cdr(arb(m))])
    ELEM ==> car(arb(m)) S_TIMES car(arb(n)) /= car(arb(n)) S_TIMES car(arb(m)) or 
                cdr(arb(n)) S_TIMES cdr(arb(m)) /= cdr(arb(m)) S_TIMES cdr(arb(n))
    ALGEBRA ==> false; Discharge ==> QED
    
Theorem 268: (X in Ra & Y in Si & Z in Si & Z /= [0,0]) imp (Fr_to_Ra([Y,Z]) Ra_TIMES X = 
                        Fr_to_Ra([car(arb(X)) S_TIMES Y,cdr(arb(X)) S_TIMES Z])). Proof:
    Suppose_not(x,y,z) ==> x in Ra & y in Si & z in Si & z /= [0,0] & Fr_to_Ra([y,z]) Ra_TIMES x /= 
            Fr_to_Ra([car(arb(x)) S_TIMES y,cdr(arb(x)) S_TIMES z])
    (x,y,z) --> T257 ==> Fr_to_Ra([y,z]) Ra_TIMES x /= x Ra_TIMES ([y,z])
    ([y,z]) --> T252 ==> [y,z] in Fr
    (zz,[y,z]) --> T247 ==> Fr_to_Ra([y,z]) in Ra
    (x,Fr_to_Ra([y,z])) --> T267 ==> false; Discharge ==> QED

Theorem 269: (K in Ra & N in Ra & M in Ra) imp (N Ra_PLUS (M Ra_PLUS K) = (N Ra_PLUS M) Ra_PLUS K). Proof: 
    Suppose_not(k,n,m) ==> n in Ra & n in Ra & m in Ra & n Ra_PLUS (m Ra_PLUS k) /= (n Ra_PLUS m) Ra_PLUS k
    n --> T247 ==> arb(n) in Fr & Fr_to_Ra(arb(n)) = n
    m --> T247 ==> arb(m) in Fr & Fr_to_Ra(arb(m)) = m
    k --> T247 ==> arb(k) in Fr & Fr_to_Ra(arb(k)) = m
    Use_Def(Ra_PLUS) ==> 
      n Ra_PLUS Fr_to_Ra([(car(arb(m)) S_TIMES cdr(arb(k))) S_PLUS (car(arb(k)) S_TIMES cdr(arb(m))),
                            cdr(arb(m)) S_TIMES cdr(arb(k))]) /= 
        Fr_to_Ra([(car(arb(n)) S_TIMES cdr(arb(m))) S_PLUS (car(arb(m)) S_TIMES cdr(arb(n))),
                            cdr(arb(n)) S_TIMES cdr(arb(m))]) Ra_PLUS k
    (arb(n)) --> T252 ==> 
      arb(n) = [car(arb(n)),cdr(arb(n))] & car(arb(n)) in Si & cdr(arb(n)) in Si & cdr(arb(n)) /= [0,0]     
    (arb(m)) --> T252 ==> 
      arb(m) = [car(arb(m)),cdr(arb(m))] & car(arb(m)) in Si & cdr(arb(m)) in Si & cdr(arb(m)) /= [0,0]     
    (arb(n)) --> T252 ==> 
      arb(k) = [car(arb(k)),cdr(arb(k))] & car(arb(k)) in Si & cdr(arb(k)) in Si & cdr(arb(k)) /= [0,0]
    Loc_def ==> an := car(arb(n))
    Loc_def ==> am := car(arb(m))
    Loc_def ==> ak := car(arb(k))
    Loc_def ==> dn := cdr(arb(n))
    Loc_def ==> dm := cdr(arb(m))
    Loc_def ==> dk := cdr(arb(k))
    (dm,dk) --> T232 ==> dm S_TIMES dk /= [0,0]
    (dn,dm) --> T232 ==> dn S_TIMES dm /= [0,0]
    ALGEBRA ==> (am S_TIMES dk) S_PLUS (ak S_TIMES dm) in Si & dm S_TIMES dk in Si &
              (an S_TIMES dm) S_PLUS (am S_TIMES dn) in Si & dn S_TIMES dm in Si
    (n,(am S_TIMES dk) S_PLUS (ak S_TIMES dm),dm S_TIMES dk) --> T256 ==> 
      Fr_to_Ra([(an S_TIMES (dm S_TIMES dk)) S_PLUS 
        ((am S_TIMES dk) S_PLUS (ak S_TIMES dm)) S_TIMES dn, dn S_TIMES (dk S_TIMES dm)])
                          /= (n Ra_PLUS m) Ra_PLUS k
    ((an S_TIMES dm) S_PLUS (am S_TIMES dn),dn S_TIMES dm,k) --> T256 ==> 
      Fr_to_Ra([(an S_TIMES (dm S_TIMES dk)) S_PLUS ((am S_TIMES dk) S_PLUS (ak S_TIMES dm)) S_TIMES dn,
             dn S_TIMES (dk S_TIMES dm)]) /= 
      Fr_to_Ra([(((an S_TIMES dm) S_PLUS (am S_TIMES dn)) S_TIMES dk) S_PLUS (ak S_TIMES (dn S_TIMES dm)), 
            (dn S_TIMES dm) S_TIMES dk])
    ELEM ==> (an S_TIMES (dm S_TIMES dk)) S_PLUS (((am S_TIMES dk) S_PLUS (ak S_TIMES dm)) S_TIMES dn) /=
          (((an S_TIMES dm) S_PLUS (am S_TIMES dn)) S_TIMES dk) S_PLUS (ak S_TIMES (dn S_TIMES dm)) or 
          dn S_TIMES (dk S_TIMES dm) /= (dn S_TIMES am) S_TIMES dk
    ALGEBRA ==> false; Discharge ==> QED

Theorem 270: (M in Ra) imp (M = M Ra_PLUS Ra_0). Proof: 
    Suppose_not(m) ==> m in Ra & m in Ra & m /= m Ra_PLUS R_0
    m --> T247 ==> arb(m) in Fr & Fr_to_Ra(arb(m)) = m
    (arb(m)) --> T252 ==> arb(m) = [car(arb(m)),cdr(arb(m))]
    Use_Def(R_0) ==> m /= m Ra_PLUS Fr_to_Ra([[0,0],[1,0]])
    Use_Def(Ra_PLUS) ==> m /= 
        Fr_to_Ra([(car(arb(m)) S_TIMES cdr(arb(Fr_to_Ra([[0,0],[1,0]])))) S_PLUS 
                        (car(arb(Fr_to_Ra([[0,0],[1,0]]))) S_TIMES cdr(arb(m))),
                                  cdr(arb(m)) S_TIMES cdr(arb(Fr_to_Ra([[0,0],[1,0]])))])
    T247 ==> Stat1: (FORALL x in Fr | Same_frac(x,arb(Fr_to_Ra(x))))
    COMPUTE ==> [[0,0],[1,0]] in Fr
    [[0,0],[1,0]] --> Stat1 ==> Same_frac([[0,0],[1,0]],arb(Fr_to_Ra([[0,0],[1,0]])))
    (arb(m)) --> T245 ==> Same_frac(arb(m),arb(m))
    ([[0,0],[1,0]],arb(Fr_to_Ra(arb(Fr_to_Ra([[0,0],[1,0]])))),arb(m),arb(m)) --> T254 ==> 
       m /= Fr_to_Ra([(car(arb(m)) S_TIMES [1,0]) S_PLUS ([0,0] S_TIMES cdr(arb(m))), cdr(arb(m)) S_TIMES [1,0]])
    ALGEBRA ==> m /= Fr_to_Ra([car(arb(m)),cdr(arb(m))])
    ELEM ==> false; Discharge ==> QED

Theorem 271: (M in Ra) imp (M Ra_PLUS Ra_Rev(M) = Ra_0). Proof: 
    Suppose_not(m) ==> m in Ra & m in Ra & m Ra_PLUS Ra_Rev(m) /= Ra_0
    m --> T247 ==> arb(m) in Fr & Fr_to_Ra(arb(m)) = m
    (arb(m)) --> T252 ==> 
      arb(m) = [car(arb(m)),cdr(arb(m))] & car(arb(m)) in Si & cdr(arb(m)) in Si & cdr(arb(m)) /= [0,0]
    Loc_def ==> am := car(arb(m))
    Loc_def ==> dm := cdr(arb(m))
    Use_Def(Ra_Rev) ==> m Ra_PLUS Fr_to_Ra([S_Rev(am),dm]) /= Ra_0
    (m,S_Rev(am),dm) --> T256 ==> Ra_0 /= Fr_to_Ra([(am S_TIMES dm) S_PLUS (dm S_TIMES S_Rev(am)),dm S_TIMES dm])
    ALGEBRA ==> Ra_0 /= Fr_to_Ra([[0,0],dm S_TIMES dm])
    Use_Def(Ra_0) ==> Fr_to_Ra([[0,0],[1,0]]) /= Fr_to_Ra([[0,0],dm S_TIMES dm])
    T247 ==> Stat1: (FORALL x in Fr | (FORALL y in Fr | Same_frac(x,y) eq Fr_to_Ra(x) = Fr_to_Ra(y)))
    COMPUTE ==> [[0,0],[1,0]] in Fr
    ALGEBRA ==> [0,0] in Si & dm S_TIMES dm in Si
    (dm,dm) --> T232 ==> dm S_TIMES dm /= [0,0]
    ([0,0],cdr(arb(m)) S_TIMES dm) --> T252 ==> [[0,0],dm S_TIMES dm] in Fr
    ([[0,0],[1,0]],[[0,0],dm S_TIMES dm]) ==> 
          not(Same_frac([[0,0],[1,0]],[[0,0],dm S_TIMES dm]))
    Use_Def(Same_frac) ==> [0,0] S_TIMES (dm S_TIMES dm) /= [1,0] S_TIMES [0,0]
    ALGEBRA ==> false; Discharge ==> QED
    
Theorem 272: (N in Ra & M in Ra) imp (N = M Ra_PLUS (N Ra_MINUS M)). Proof: 
    Suppose_not(n,m) ==> n in Ra & m in Ra & n /= m Ra_PLUS (n Ra_MINUS m)
    Use_Def(Ra_MINUS) ==> n /= m Ra_PLUS (n Ra_PLUS Ra_Rev(m))
    ALGEBRA ==> n /= (m Ra_PLUS Ra_Rev(m)) Ra_PLUS n
    m --> T271 ==> n /= Ra_0 Ra_PLUS n
    ALGEBRA ==> false; Discharge ==> QED

Theorem 273: (K in Ra & N in Ra & M in Ra) imp (N Ra_TIMES (M Ra_TIMES K) = (N Ra_TIMES M) Ra_TIMES K). Proof: 
    Suppose_not(k,n,m) ==> k in Ra & n in Ra & m in Ra & n Ra_TIMES (m Ra_TIMES k) /= (n Ra_TIMES m) Ra_TIMES k
    (n Ra_TIMES m,k) --> T267 ==> n Ra_TIMES (m Ra_TIMES k) /= k Ra_TIMES (n Ra_TIMES m)
    n --> T247 ==> arb(n) in Fr & Fr_to_Ra(arb(n)) = n
    m --> T247 ==> arb(m) in Fr & Fr_to_Ra(arb(m)) = m
    k --> T247 ==> arb(k) in Fr & Fr_to_Ra(arb(k)) = m
    (arb(n)) --> T252 ==> 
      arb(n) = [car(arb(n)),cdr(arb(n))] & car(arb(n)) in Si & cdr(arb(n)) in Si & cdr(arb(n)) /= [0,0]     
    (arb(m)) --> T252 ==> 
      arb(m) = [car(arb(m)),cdr(arb(m))] & car(arb(m)) in Si & cdr(arb(m)) in Si & cdr(arb(m)) /= [0,0]     
    (arb(n)) --> T252 ==> 
      arb(k) = [car(arb(k)),cdr(arb(k))] & car(arb(k)) in Si & cdr(arb(k)) in Si & cdr(arb(k)) /= [0,0]
    Loc_def ==> an := car(arb(n))
    Loc_def ==> am := car(arb(m))
    Loc_def ==> ak := car(arb(k))
    Loc_def ==> dn := cdr(arb(n))
    Loc_def ==> dm := cdr(arb(m))
    Loc_def ==> dk := cdr(arb(k))
    Use_Def(Ra_TIMES) ==> 
      n Ra_TIMES Fr_to_Ra([am S_TIMES ak,dm S_TIMES dk]) /= k Ra_TIMES Fr_to_Ra([an S_TIMES am,dn S_TIMES dm])
    (dm,dk) --> T232 ==> dm S_TIMES dk /= [0,0]
    (dn,dm) --> T232 ==> dn S_TIMES dm /= [0,0]
    ALGEBRA ==> an S_TIMES am in Si & dn S_TIMES dm in Si & am S_TIMES ak in Si & dm S_TIMES dk in Si 
    (am S_TIMES ak,dm S_TIMES dk) --> T252 ==> [am S_TIMES ak,dm S_TIMES dk] in Fr
    (an S_TIMES am,dn S_TIMES dm) --> T252 ==> [an S_TIMES am,dn S_TIMES dm] in Fr
    (n,am S_TIMES ak,dm S_TIMES dk) --> T256 ==> n Ra_TIMES Fr_to_Ra([am S_TIMES ak,dm S_TIMES dk]) = 
                  Fr_to_Ra([an S_TIMES (am S_TIMES ak),dn S_TIMES dm S_TIMES dk])
    (k,an S_TIMES am,dn S_TIMES dm) --> T256 ==> k Ra_TIMES Fr_to_Ra([an S_TIMES am,dn S_TIMES dm]) = 
                  Fr_to_Ra([ak S_TIMES (an S_TIMES am),dk S_TIMES dn S_TIMES dm])
    ALGEBRA ==> false; Discharge ==> QED

Theorem 274: 
    (K in Si & N in Si & M in Si & K /= [0,0] & M /= [0,0]) imp (Fr_to_Ra([N,M]) = Fr_to_Ra([K S_TIMES N,K S_TIMES M])).  Proof:
		Suppose_not(k,n,m) ==> k in Si & n in Si & m in Si & k /= [0,0] & m /= [0,0] & 
                        Fr_to_Ra([n,m]) /= Fr_to_Ra([k S_TIMES n,k S_TIMES m])
    (n,m) --> T252 ==> [n,m] in Fr
    ALGEBRA ==> k S_TIMES n in Si & k S_TIMES m in Si
    (k,m) --> T256 ==> k S_TIMES m /= [0,0]
    (k S_TIMES n,k S_TIMES m) --> T252 ==> [k S_TIMES n,k S_TIMES m] in Fr
    T247 ==> Stat1: (FORALL x in Fr | (FORALL y in Fr | Same_frac(x,y) eq Fr_to_Ra(x) = Fr_to_Ra(y)))
    ([n,m],[k S_TIMES n,k S_TIMES m]) --> Stat1 ==> not Same_frac([n,m],[k S_TIMES n,k S_TIMES m])
    Use_Def(Same_frac) ==> n S_TIMES (k S_TIMES m) /= m S_TIMES (k S_TIMES n)
    ALGEBRA ==> false; Discharge ==> QED
    
Theorem 275: (K in Ra & N in Ra & M in Ra) imp (N Ra_TIMES (M Ra_PLUS K) = (N Ra_TIMES M) Ra_PLUS (N Ra_TIMES K)). Proof: 
    Suppose_not(k,n,m) ==> k in Ra & n in Ra & m in Ra & n Ra_TIMES (m Ra_PLUS k) /= (n Ra_TIMES m) Ra_PLUS (n Ra_TIMES k)
    n --> T247 ==> arb(n) in Fr & Fr_to_Ra(arb(n)) = n
    m --> T247 ==> arb(m) in Fr & Fr_to_Ra(arb(m)) = m
    k --> T247 ==> arb(k) in Fr & Fr_to_Ra(arb(k)) = m
    (arb(n)) --> T252 ==> 
      arb(n) = [car(arb(n)),cdr(arb(n))] & car(arb(n)) in Si & cdr(arb(n)) in Si & cdr(arb(n)) /= [0,0]     
    (arb(m)) --> T252 ==> 
      arb(m) = [car(arb(m)),cdr(arb(m))] & car(arb(m)) in Si & cdr(arb(m)) in Si & cdr(arb(m)) /= [0,0]     
    (arb(k)) --> T252 ==> 
      arb(k) = [car(arb(k)),cdr(arb(k))] & car(arb(k)) in Si & cdr(arb(k)) in Si & cdr(arb(k)) /= [0,0]
    Loc_def ==> an := car(arb(n))
    Loc_def ==> am := car(arb(m))
    Loc_def ==> ak := car(arb(k))
    Loc_def ==> dn := cdr(arb(n))
    Loc_def ==> dm := cdr(arb(m))
    Loc_def ==> dk := cdr(arb(k))
    ALGEBRA ==> an S_TIMES am in Si & an S_TIMES ak in Si & (am S_TIMES dk) S_PLUS (ak S_TIMES dm) in Si 
            & dn S_TIMES dm in Si & dn S_TIMES dk in Si & dm S_TIMES dk in Si
    (dn,dm) --> T256 ==> dn S_TIMES dm /= [0,0]
    (dn,dk) --> T256 ==> dn S_TIMES dk /= [0,0]
    (dm,dk) --> T256 ==> dm S_TIMES dk /= [0,0]
    Use_Def(Ra_PLUS) ==> m Ra_PLUS k = Fr_to_Ra([(am S_TIMES dk) S_PLUS (ak S_TIMES dm),dm S_TIMES dk])
    (n,(am S_TIMES dk) S_PLUS (ak S_TIMES dm),dm S_TIMES dk) --> T256 ==> n Ra_TIMES (m Ra_PLUS k) = 
          Fr_to_Ra([an S_TIMES ((am S_TIMES dk) S_PLUS (ak S_TIMES dm)),dn S_TIMES (dm S_TIMES dk)])
    Use_Def(Ra_TIMES) ==> n Ra_TIMES m = Fr_to_Ra([an S_TIMES am,dn S_TIMES dm])
    Use_Def(Ra_TIMES) ==> n Ra_TIMES k = Fr_to_Ra([an S_TIMES ak,dn S_TIMES dk])
    (an S_TIMES am,dn S_TIMES dm,an S_TIMES ak,dn S_TIMES dk) --> T266 ==> (n Ra_TIMES m) Ra_PLUS (n Ra_TIMES k) = 
      Fr_to_Ra([((an S_TIMES am) S_TIMES (dn S_TIMES dk)) S_PLUS ((an S_TIMES ak) S_TIMES (dn S_TIMES dm)),
                ((dn S_TIMES dm) S_TIMES (dn S_TIMES dk))])
    ALGEBRA ==> (n Ra_TIMES m) Ra_PLUS (n Ra_TIMES k) =
      Fr_to_Ra([dn S_TIMES (an S_TIMES ((am S_TIMES dk) S_PLUS (ak S_TIMES dm))), 
                              dn S_TIMES (dn S_TIMES (dm S_TIMES dk))])
    Loc_def ==> aa := (an S_TIMES ((am S_TIMES dk) S_PLUS (ak S_TIMES dm)))
    Loc_def ==> dd := (dn S_TIMES (dm S_TIMES dk))
    ELEM ==> (n Ra_TIMES m) Ra_PLUS (n Ra_TIMES k) = Fr_to_Ra([dn S_TIMES aa, dn S_TIMES dd]) 
            & n Ra_TIMES (m Ra_PLUS k) = Fr_to_Ra([aa,dd])
    Use_Def(Same_frac) ==> Same_frac([dn S_TIMES aa, dn S_TIMES dd],[aa,dd]) eq
          (dn S_TIMES aa) S_TIMES dd = (dn S_TIMES dd) S_TIMES aa
    ALGEBRA ==> Same_frac([dn S_TIMES aa, dn S_TIMES dd],[aa,dd])
    T247 ==> Stat1: (FORALL x in Fr | (FORALL y in Fr | Same_frac(x,y) eq Fr_to_Ra(x) = Fr_to_Ra(y)))
    ([dn S_TIMES aa, dn S_TIMES dd],[aa,dd]) ==> false; Discharge ==> QED

Theorem 276: (X in Si & Y in Si & Y /= [0,0]) imp (Ra_is_nonneg(Fr_to_Ra([X,Y])) eq is_nonneg(X S_TIMES Y)). Proof:
    Suppose_not(n,m) ==> n in Si & m in Si & m /= [0,0] & (not(Ra_is_nonneg(Fr_to_Ra([n,m])) eq is_nonneg(n S_TIMES n)))
    (n,m) --> T252 ==> [n,m] in Fr
    T247 ==> Stat1: (FORALL x in Fr | Same_frac(x,arb(Fr_to_Ra(x))))
    ([n,m]) --> Stat1 ==> Same_frac([n,m],arb(Fr_to_Ra([n,m])))
    ([n,m],arb(Fr_to_Ra([n,m]))) --> T261 ==> 
      is_nonneg(car(arb(Fr_to_Ra([n,m]))) S_TIMES car(arb(Fr_to_Ra([n,m])))) eq is_nonneg(n S_TIMES n)
    Use_Def(Ra_is_nonneg) ==> 
      Ra_is_nonneg(Fr_to_Ra([n,m])) = is_nonneg(car(arb(Fr_to_Ra([n,m]))) S_TIMES car(arb(Fr_to_Ra([n,m]))))
    ELEM ==> false; Discharge ==> QED

Theorem 277: (M in Ra) imp (M = M Ra_TIMES Ra_1) . Proof:
    Suppose_not(m) ==> m in Ra & m /= m Ra_TIMES Ra_1
    m --> T247 ==> arb(m) in Fr & Fr_to_Ra(arb(m)) = m
    (arb(m)) --> T252 ==> 
      arb(m) = [car(arb(m)),cdr(arb(m))] & car(arb(m)) in Si & cdr(arb(m)) in Si & cdr(arb(m)) /= [0,0]     
    Loc_def ==> am := car(arb(m))
    Loc_def ==> dm := cdr(arb(m))
    Use_Def(Ra_1) ==> m /= m Ra_TIMES Fr_to_Ra([[1,0],[1,0]])
    ALGEBRA ==> [1,0] in Si & [1,0] /= [0,0]
    (m,[1,0],[1,0]) --> T257 ==> m /= Fr_to_Ra(am S_TIMES [1,0],dm S_TIMES [1,0])
    ALGEBRA ==> m /= Fr_to_Ra(am,dm)
    ELEM ==> false; Discharge ==> QED

Theorem 278: (M in Ra & M /= Ra_0) imp (Recip(M) in Ra & M Ra_TIMES Recip(M) = Ra_1). Proof:
    Suppose_not(m) ==> m in Ra & m /= Ra_0 & (Recip(m) notin Ra or m Ra_TIMES Recip(m) /= Ra_1)
    m --> T247 ==> arb(m) in Fr & Fr_to_Ra(arb(m)) = m
    (arb(m)) --> T252 ==> 
      arb(m) = [car(arb(m)),cdr(arb(m))] & car(arb(m)) in Si & cdr(arb(m)) in Si & cdr(arb(m)) /= [0,0]     
    Loc_def ==> am := car(arb(m))
    Loc_def ==> dm := cdr(arb(m))
    ALGEBRA ==> [1,0] in Si & [0,0] in Si & [1,0] /= [0,0]
    ([0,0],[1,0]) --> T252 ==> [[0,0],[1,0]] in Fr
    Suppose ==> am = [0,0]
    Use_Def(Same_frac) ==> Same_frac([dm,am],[[0,0],[1,0]])
    ALGEBRA ==> am S_TIMES [1,0] = dm S_TIMES [0,0]
    T247 ==> Stat1: (FORALL x in Fr | (FORALL y in Fr | Same_frac(x,y) eq Fr_to_Ra(x) = Fr_to_Ra(y)))
    ([dm,am],[[0,0],[1,0]]) --> Stat1 ==> m = Fr_to_Ra([[0,0],[1,0]])
    Use_Def(Ra_0) ==> false; Discharge ==> am = [0,0]
    Use_Def(Recip) ==> Recip(m) = Fr_to_Ra([am,dm])
    (am,dm) --> T247 ==> Recip(m) in Ra & m Ra_TIMES Fr_to_Ra([am,dm]) /= Ra_1
    (m,am,dm) --> T257 ==> Fr_to_Ra([am S_TIMES dm,am S_TIMES dm]) /= Ra_1
    Use_Def(Ra_1) ==> Fr_to_Ra([am S_TIMES dm,am S_TIMES dm]) /= Fr_to_Ra([[1,0],[1,0]])
    ([am S_TIMES dm,am S_TIMES dm],[[1,0],[1,0]]) --> Stat1 ==> not Same_frac([am S_TIMES dm,dm S_TIMES am],[[1,0],[1,0]])
    Use_Def(Same_frac) ==> (am S_TIMES dm) S_TIMES [1,0] /= (am S_TIMES dm) S_TIMES [1,0]
    ALGEBRA ==> false; Discharge ==> QED

Theorem 279: (N in Ra & M in Ra & M /= Ra_0) imp (N = M Ra_TIMES (N Ra_OVER M)). Proof:
    Suppose_not(n,m) ==> n in Ra & m in Ra & m /= Ra_0 & n /= m Ra_TIMES (n Ra_OVER m)
    m --> T278 ==> Recip(m) in Ra
    Use_Def(Ra_OVER) ==> m Ra_TIMES (n Ra_TIMES Recip(m))
    ALGEBRA ==> n /= n Ra_TIMES (m Ra_OVER Recip(m))
    mm --> T278 ==> n /= n Ra_TIMES Ra_1
    ALGEBRA ==> false; Discharge ==> QED

Theorem 280: Ra_is_nonneg(Ra_0) & Ra_is_nonneg(Ra_1). Proof:
    ALGEBRA ==> [0,0] in Si & [1,0] in Si & [1,0] /= [0,0]
    Use_Def(Ra_is_nonneg) ==> Ra_is_nonneg([[0,0],[1,0]]) eq is_nonneg([0,0] S_TIMES [1,0]) & 
                  Ra_is_nonneg([[1,0],[1,0]]) eq is_nonneg([1,0] S_TIMES [1,0])
    ALGEBRA ==> Ra_is_nonneg([[0,0],[1,0]]) eq is_nonneg([0,0])
    ALGEBRA ==> Ra_is_nonneg([[1,0],[1,0]]) eq is_nonneg([1,0])
    Use_Def(is_nonneg) ==> QED
        
Theorem 281: 
 (X in Ra) imp ((Ra_is_nonneg(X) or Ra_is_nonneg(Ra_Rev(X))) & ((Ra_is_nonneg(X) & Ra_is_nonneg(Ra_Rev(X))) imp (X = Ra_0))). Proof:
		Suppose_not(n) ==> n in Ra & 
      (not ((Ra_is_nonneg(n) or Ra_is_nonneg(Ra_Rev(n))))) & ((Ra_is_nonneg(n) & Ra_is_nonneg(Ra_Rev(n)) imp (n = Ra_0)))
    n --> T247 ==> arb(n) in Fr & Fr_to_Ra(arb(n)) = n
    (arb(n)) --> T252 ==> 
      arb(n) = [car(arb(n)),cdr(arb(n))] & car(arb(n)) in Si & cdr(arb(n)) in Si & cdr(arb(n)) /= [0,0]     
    Loc_def ==> an := car(arb(n))
    Loc_def ==> dn := cdr(arb(n))
    Loc_def ==> av := car(arb(Ra_Rev(n)))
    Loc_def ==> dv := cdr(arb(Ra_Rev(n)))
    Use_Def(Ra_Rev) ==> Ra_Rev(n) = Fr_to_Ra([S_Rev(an),dn])
    (S_Rev(an),dn) --> T276 ==> Ra_is_nonneg(Ra_Rev(n)) eq is_nonneg(S_Rev(an) S_TIMES dn)
    (S_Rev(an),dn) --> T276 ==> Ra_is_nonneg(n) eq is_nonneg(an S_TIMES dn)
    ALGEBRA ==> Ra_is_nonneg(Ra_Rev(n)) eq is_nonneg(S_Rev(an S_TIMES dn))
    (an S_TIMES dn) --> T248 ==> (is_nonneg(an S_TIMES dn) or is_nonneg(an S_TIMES dn)) & 
                ((is_nonneg(an S_TIMES dn) & is_nonneg(an S_TIMES dn)) imp (an S_TIMES dn = [0,0]))
    ELEM ==> an S_TIMES dn = [0,0]
    (an,dn) --> T232 ==> n = Fr_to_Ra([[0,0],dn])
    Suppose ==> not(Same_frac([[0,0],dn],[[0,0],[1,0]]))
    Use_Def(Same_frac) ==> [0,0] S_TIMES dn /= [0,0] S_TIMES [1,0]
    ALGEBRA ==> false; Discharge ==> Same_frac([[0,0],dn],[[0,0],[1,0]])
    T247 ==> Stat1: (FORALL x in Fr | (FORALL y in Fr | Same_frac(x,y) eq Fr_to_Ra(x) = Fr_to_Ra(y)))
    ([[0,0],dn],[[0,0],[1,0]]) --> Stat1 ==> n = Fr_to_Ra([[0,0],[1,0]])
    Use_Def(Ra_0) ==> QED

APPLY(Ra_GE,Ra_LE,Ra_GT,Ra_LT) Ordered_add(g->Ra,e->Ra_0,pluz->Ra_PLUS,minzvRa_PLUS,rvz->Ra_Rev,nneg->Ra_is_nonneg) ==>
Theorem 281a: (X Ra_GE Y eq nneg(X pluz Ra_Rev(Y))) & (X S_LE Y eq Y Ra_GE X) & (X Ra_GT Y eq X Ra_GE Y & X /= Y) & 
                                  (X Ra_LT Y eq Y Ra_GT X)

Theorem 282: (X in Ra) imp (X = X Ra_TIMES Ra_1). Proof:
    Suppose_not(n) ==> n in Ra & n /= n Ra_TIMES Ra_1
    n --> T247 ==> arb(n) in Fr & Fr_to_Ra(arb(n)) = n
    (arb(n)) --> T252 ==> 
      arb(n) = [car(arb(n)),cdr(arb(n))] & car(arb(n)) in Si & cdr(arb(n)) in Si & cdr(arb(n)) /= [0,0] 
    Loc_def ==> an := car(arb(n))
    Loc_def ==> dn := cdr(arb(n))
    Use_Def(Ra_1) ==> n /= n Ra_TIMES Fr_to_Ra([[1,0],[1,0]])
    Use_Def(Ra_TIMES) ==> 
      n /= Fr_to_Ra(an S_TIMES car(arb(Fr_to_Ra([[1,0],[1,0]]))),dn S_TIMES cdr(arb(Fr_to_Ra([[1,0],[1,0]]))))
    ALGEBRA ==> [0,0] in Si & [1,0] in Si & [1,0] /= [0,0]
    ([[1,0],[1,0]]) --> T252 ==> [[1,0],[1,0]] in Fr
    ([an,dn]) --> T245 ==> Same_frac([an,dn],[an,dn])
    T247 ==> Stat1: (FORALL x in Fr | Same_frac(x,arb(Fr_to_Ra(x)))) & 
              Stat2: (FORALL y in Ra | arb(y) in Fr & Fr_to_Ra(arb(y)) = y)
    ([[1,0],[1,0]]) --> Stat1 ==> Same_frac([[1,0],[1,0]],arb(Fr_to_Ra([[1,0],[1,0]])))
    ([[0,0],[1,0]],arb(Fr_to_Ra([[0,0],[1,0]]))) --> T255 ==> n /= Fr_to_Ra([an S_TIMES [1,0],dn S_TIMES [1,0]])
    ALGEBRA ==> n /= Fr_to_Ra(an,dn)
    n --> Stat2 ==> false; Discharge ==> QED
    
Theorem 283: (X in Ra) imp (X = Ra_0 eq car(arb(X)) = [0,0]). Proof:
    Suppose_not(n) ==> n in Ra & (not(n = Ra_0 eq car(arb(n)) = [0,0]))
    n --> T247 ==> arb(n) in Fr & Fr_to_Ra(arb(n)) = n
    (arb(n)) --> T252 ==> 
      arb(n) = [car(arb(n)),cdr(arb(n))] & car(arb(n)) in Si & cdr(arb(n)) in Si & cdr(arb(n)) /= [0,0]     
    Loc_def ==> an := car(arb(n))
    Loc_def ==> dn := cdr(arb(n))
    Use_Def(Ra_0) ==> Ra_0 = Fr_to_Ra([[0,0],[1,0]])
    T247 ==> Stat1: (FORALL x in Fr | Same_frac(x,arb(Fr_to_Ra(x)))) & 
          Stat2: (FORALL x in Fr | (FORALL y in Fr | Same_frac(x,y) eq Fr_to_Ra(x) = Fr_to_Ra(y)))
    Suppose ==> n = Ra_0
    ELEM ==> an = car(arb(Fr_to_Ra([[0,0],[1,0]]))) & dn = cdr(arb(Fr_to_Ra([[0,0],[1,0]])))
    ([[0,0],[1,0]]) --> Stat1 ==> Same_frac([[0,0],[1,0]],[an,dn])
    Use_Def(Same_frac) ==> [0,0] S_TIMES dn = an S_TIMES [1,0]
    ALGEBRA ==> false; Discharge ==> an = 0 & n /= Ra_0
    ALGEBRA ==> [0,0] S_TIMES dn = an S_TIMES [1,0]
    Use_Def(Same_frac) ==> Same_frac([[0,0],[1,0]],[an,dn])
    ([[0,0],[1,0]],[an,dn]) --> Stat2 ==> Fr_to_Ra([[0,0],[1,0]]) = n
    ELEM ==> QED

Theorem 284: (X in Ra & Y in Ra & Ra_is_nonneg(X) & Ra_is_nonneg(Y)) imp 
          (Ra_is_nonneg(X Ra_PLUS Y) & Ra_is_nonneg(X Ra_TIMES Y)). Proof: 
    Suppose_not(n,m) ==> n in Ra & m in Ra & Ra_is_nonneg(n) & Ra_is_nonneg(m) & 
            (not(Ra_is_nonneg(n Ra_PLUS m) & Ra_is_nonneg(n Ra_TIMES m)))
    n --> T247 ==> arb(n) in Fr & Fr_to_Ra(arb(n)) = n
    m --> T247 ==> arb(m) in Fr & Fr_to_Ra(arb(m)) = m
    (arb(n)) --> T252 ==> 
      arb(n) = [car(arb(n)),cdr(arb(n))] & car(arb(n)) in Si & cdr(arb(n)) in Si & cdr(arb(n)) /= [0,0]     
    (arb(m)) --> T252 ==> 
      arb(m) = [car(arb(m)),cdr(arb(m))] & car(arb(m)) in Si & cdr(arb(m)) in Si & cdr(arb(m)) /= [0,0]     
    Loc_def ==> an := car(arb(n))
    Loc_def ==> dn := cdr(arb(n))
    Loc_def ==> am := car(arb(m))
    Loc_def ==> dm := cdr(arb(m))
    Use_Def(Ra_is_nonneg) ==> is_nonneg(an S_TIMES dn) & is_nonneg(am S_TIMES dm)
    Suppose ==> not Ra_is_nonneg(n Ra_TIMES m)
    Use_Def(Ra_TIMES) ==> not Ra_is_nonneg(Fr_to_Ra([an S_TIMES am, dn S_TIMES dm]))
    (an S_TIMES am, dn S_TIMES dm) --> T276 ==> not is_nonneg((an S_TIMES am) S_TIMES (dn S_TIMES dm))
    ALGEBRA ==> not is_nonneg((an S_TIMES dn) S_TIMES (am S_TIMES dm))
    (an S_TIMES dn,am S_TIMES dm) --> T249 ==> false; Discharge ==> not Ra_is_nonneg(n Ra_PLUS m)
    Use_Def(Ra_PLUS) ==> not Ra_is_nonneg(Fr_to_Ra([(an S_TIMES dm) S_PLUS (am S_TIMES dn), dn S_TIMES dm]))
    ((an S_TIMES dm) S_TIMES (am S_PLUS dn), dn S_TIMES dm) --> T276 ==> 
              not is_nonneg(((an S_TIMES dm) S_PLUS (am S_TIMES dn)) S_TIMES (dn S_TIMES dm))
    ALGEBRA ==> not is_nonneg(((an S_TIMES dn) S_TIMES (dm S_TIMES dm)) S_PLUS ((am S_TIMES dm) S_TIMES (dn S_TIMES dn)))
    dn --> T250 ==> is_nonneg(dn S_TIMES dn)
    dm --> T250 ==> is_nonneg(dm S_TIMES dm)
    (an S_TIMES dn,dm S_TIMES dm) --> T249 ==> is_nonneg((an S_TIMES dn) S_TIMES (dm S_TIMES dm))
    (am S_TIMES dm,dn S_TIMES dn) --> T249 ==> is_nonneg((am S_TIMES dm) S_TIMES (dn S_TIMES dn))
    ((an S_TIMES dn) S_TIMES (dm S_TIMES dm),((am S_TIMES dm) S_TIMES (dn S_TIMES dn))) --> T249 ==> 
      is_nonneg(((an S_TIMES dn) S_TIMES (dm S_TIMES dm)) S_PLUS ((am S_TIMES dm) S_TIMES (dn S_TIMES dn)))
    ELEM ==> false; Discharge ==> QED

Theorem 291: (X in Ra & Y in Ra & X1 in Ra & X Ra_GT Y & X1 Ra_GT Ra_0) imp (X Ra_TIMES X1 Ra_GT Y Ra_TIMES X1). Proof:
    Suppose_not(m,n,k) ==> 
      m in Ra & n in Ra & k in Ra & m Ra_GT n & k Ra_GT Ra_0 & (not(m Ra_TIMES k Ra_GT n Ra_TIMES k))
    ALGEBRA ==> (m Ra_TIMES k) Ra_MINUS (n Ra_TIMES k) = (m Ra_MINUS n) Ra_TIMES k
    T281a ==> Ra_is_nonneg(m Ra_MINUS n) & m /= n & Ra_is_nonneg(k Ra_MINUS Ra_0)
              (not Ra_is_nonneg((m Ra_MINUS n) Ra_TIMES k) or m Ra_TIMES k = n Ra_TIMES k)
    ALGEBRA ==> Ra_is_nonneg(k)
    (m Ra_MINUS n,k) --> T284 ==> m Ra_TIMES k = n Ra_TIMES k
    ALGEBRA ==> m = n 
    ELEM ==> false; Discharge ==> QED

Theorem 292: Ra_1 Ra_GT Ra_0. Proof:
    T281a ==> Ra_1 Ra_GT Ra_0 eq Ra_is_nonneg(Ra_1 Ra_MINUS Ra_0) & Ra_1 /= Ra_0
    ALGEBRA ==> (Ra_1 Ra_GT Ra_0 eq (Ra_is_nonneg(Ra_1) & Ra_1 /= Ra_0)) & Ra_1 = Ra_1 R_TIMES Ra_1
    T280 ==> Ra_is_nonneg(Ra_1)
    Suppose ==> Ra_1 = Ra_0
    Use_Def(Ra_1) ==> Fr_to_Ra([[1,0],[1,0]]) = Ra_0
    Use_Def(Ra_0) ==> Fr_to_Ra([[1,0],[1,0]]) = Fr_to_Ra([[0,0],[1,0]])
    ALGEBRA ==> [0,0] in Si & [1,0] in Si & [1,0] = [0,0]
    ([1,0],[1,0]) --> T252 ==> [[1,0],[1,0]] in Fr
    ([0,0],[1,0]) --> T252 ==> [[0,0],[1,0]] in Fr
    T247 ==> Stat1: (FORALL x in Fr | (FORALL y in Fr | Same_frac(x,y) eq Fr_to_Ra(x) = Fr_to_Ra(y)))
    ([[1,0],[1,0]],[[0,0],[1,0]]) --> Stat1 ==> Same_frac([[1,0],[1,0]],[[0,0],[1,0]])
    Use_Def(Same_frac) ==> [1,0] S_TIMES [1,0] = [0,0] S_TIMES [1,0]
    ELEM ==> false; Discharge ==> Ra_1 /= Ra_0
    ELEM ==> QED

Theorem 293: (X in Ra & X Ra_GT Ra_0) imp (Recip(X) Ra_GT Ra_0). Proof:
    Suppose_not(m) ==> m in Ra & m Ra_GT Ra_0 & (not Recip(m) Ra_GT Ra_0)
    T281a ==> Ra_is_nonneg(m Ra_MINUS Ra_0) & m /= Ra_0 & 
                  (not Ra_is_nonneg(Recip(m) Ra_MINUS Ra_0) or Recip(m) = Ra_0)
    ALGEBRA ==> Ra_is_nonneg(m) & m /= Ra_0 & (not Ra_is_nonneg(Recip(m)) or Recip(m) = Ra_0) & 
              m Ra_TIMES Ra_0 = Ra_0 & Ra_1 /= Ra_0 & Recip(m) in Ra
    m --> T278 ==> m Ra_TIMES Recip(m) = Ra_1
    Suppose ==> Recip(m) = Ra_0
    ALGEBRA ==> false; Discharge ==> not Ra_is_nonneg(Recip(m))
    (Recip(m)) --> T281 ==> Ra_is_nonneg(Ra_Rev(Recip(m)))
    (m,Recip(m)) --> T284 ==> Ra_is_nonneg(m Ra_TIMES Ra_Rev(Recip(m)))
    ALGEBRA ==> Ra_is_nonneg(Ra_Rev(Ra_1))
    T280 ==> Ra_is_nonneg(Ra_1)
    Ra_1 --> T281 ==> Ra_1 = Ra_0
    ALGEBRA ==> false; Discharge ==> QED 
    
Theorem 294: (X in Ra & Y in Ra & X Ra_GT Y) imp 
      (X Ra_GT (X Ra_PLUS Y) Ra_OVER (Ra_1 + Ra_1) & (X Ra_PLUS Y) Ra_OVER (Ra_1 + Ra_1) Ra_GT Y). Proof:
    Suppose_not(m,n) ==> m in Ra & n in Ra & m Ra_GT n & 
        (not (m Ra_GT (m Ra_PLUS n) Ra_OVER (Ra_1 + Ra_1)) & (m Ra_PLUS n) Ra_OVER (Ra_1 + Ra_1) Ra_GT n)
    Ordered_add ==> m Ra_PLUS n Ra_GT n Ra_PLUS n & m Ra_PLUS m Ra_GT n Ra_PLUS m
    ALGEBRA ==> m Ra_PLUS n Ra_GT n Ra_TIMES (Ra_1 Ra_PLUS Ra_1)
    ALGEBRA ==> m Ra_TIMES (Ra_1 Ra_PLUS Ra_1) Ra_GT m Ra_PLUS n 
    ALGEBRA ==> Ra_1 in Ra & Ra_0 in Ra & Ra_1 + Ra_1 in Ra 
    T292 ==> Ra_1 Ra_GT Ra_0
    Ordered_add ==> Ra_1 Ra_PLUS Ra_1 Ra_GT Ra_0 Ra_PLUS Ra_0
    ALGEBRA ==> Ra_1 Ra_PLUS Ra_1 Ra_GT Ra_0
    (Ra_1 Ra_PLUS Ra_1) --> T293 ==> Recip(Ra_1 Ra_PLUS Ra_1) Ra_GT Ra_0
    (m Ra_PLUS n,n Ra_TIMES (Ra_1 Ra_PLUS Ra_1),Recip(Ra_1 Ra_PLUS Ra_1)) --> T291 ==> 
      (m Ra_PLUS n) Ra_TIMES Recip(Ra_1 Ra_PLUS Ra_1) Ra_GT 
              (n Ra_TIMES (Ra_1 Ra_PLUS Ra_1)) Ra_TIMES Recip(Ra_1 Ra_PLUS Ra_1)
    ALGEBRA ==> (m Ra_PLUS n) Ra_TIMES Recip(Ra_1 Ra_PLUS Ra_1) Ra_GT n
    (m Ra_TIMES (Ra_1 Ra_PLUS Ra_1),m Ra_PLUS n,Recip(Ra_1 Ra_PLUS Ra_1)) --> T291 ==> 
      (m Ra_TIMES (Ra_1 Ra_PLUS Ra_1)) Ra_TIMES Recip(Ra_1 Ra_PLUS Ra_1) Ra_GT 
              (m Ra_PLUS n) Ra_TIMES Recip(Ra_1 Ra_PLUS Ra_1)
    ALGEBRA ==> m Ra_GT (m Ra_PLUS n) Ra_TIMES Recip(Ra_1 Ra_PLUS Ra_1)
    Use_Def(Ra_OVER) ==> false; Discharge ==> QED 

Def 46: [The Real numbers as the set of Dedekind cuts]
    Re := {s: s incin Ra | (s /= 0 & s /= Ra &
      (FORALL x in s | (EXISTS y in s | y Ra_GT x)) & (FORALL x in s | (FORALL y in Ra | ((x Ra_GT y) imp (y in s)))))}
Def 47: [Real 0 and 1] R_0 := {x in Ra | Ra_0 Ra_GT x} 
Def 47a: [Real 0 and 1] R_1 := {x in Ra | Ra_1 Ra_GT x}
Def 48: [Real Sum] Def(X R_PLUS Y) := {u Ra_PLUS v: u in X and v in Y}
Def 49: [Real Negative] R_Rev(X) := {Ra_Rev(u) Ra_PLUS v: u in Ra - u, v in R_0}
Def 50: [Real Subtraction] Def(X R_MINUS Y) := X R_PLUS R_Rev(Y)
Def 51: [Absolute value,i.e. the larger of X and R_Rev(X); note here and below that '+' designates the set union] abs(X) := X + R_Rev(X)  
Def 52: [Real Multiplication of Absolute Values] 
    Def(X R_TIMES_ABS Y) := 
      {u Ra_TIMES v: u in abs(X) and v in abs(Y) | not(Ra_0 Ra_GT u or Ra_0 Ra_GT v)} + R_0
Def 53: [Real Multiplication] Def(X R_TIMES Y) := if X incs R_0 eq Y incs R_0 then X R_TIMES_ABS Y 
                            else R_Rev(X R_TIMES_ABS Y) end if
Def 54: [Real Absolute Reciprocal] 
    R_ABS_Recip(X) := Un({y: y in Re | abs(X) R_TIMES y incin ({r in Ra | Fr_to_Ra([1,1]) Ra_GT r})})
Def 55: [Real Reciprocal] 
    R_Recip(X) := if X incs R_0 then R_ABS_Recip(X) else R_Rev(R_ABS_Recip(X)) end if
Def 56: [Real Quotient] Def(X R_OVER Y) := X R_TIMES R_Recip(Y)
Def 56a: [Non-negative Real] R_is_nonneg(X) := R_0 incin X 
Def 56b: [Real Comparison] Def(X R_GT Y) := R_is_nonneg(X R_MINUS Y) & (not X = Y)
Def 56c: [Real Comparison] Def(X R_GE Y) := R_is_nonneg(X R_MINUS Y)
Def 57: [Real square root] sqrt(x) := Un({y: y in Re | (y R_TIMES y) incin x})

Theorem 295: (X in Ra) imp ({y: y in Ra | X Ra_GT y} in Re). Proof:
    Suppose_not(n) ==> n in Ra & {y: y in Ra | n Ra_GT y} notin Re
    Suppose ==> not ({y: y in Ra | n Ra_GT y} incin Ra)
    Set_monot ==> not ({y: y in Ra} incin Ra)
    SIMPLF ==> false; Discharge ==> {y: y in Ra | n Ra_GT y} incin Ra
    Suppose ==> Stat0: n in {y: y in Ra | n Ra_GT y}
    aa --> Stat0 ==> n Ra_GT n
    T281a ==> false; Discharge ==> {y: y in Ra | n Ra_GT y} /= Ra
    Suppose ==> Stat00: (n Ra_MINUS Ra_1) notin {y: y in Ra | n Ra_GT y}
    (n Ra_MINUS 1) --> Stat00 ==> n Ra_MINUS Ra_1 notin Ra or (not n Ra_GT n Ra_MINUS Ra_1)
    ALGEBRA ==> an Ra_MINUS Ra_1 in Ra
    ELEM ==> not (n Ra_GT n Ra_MINUS Ra_1)
    T281a ==> (not (Ra_is_nonneg(n Ra_MINUS (n Ra_MINUS Ra_1)))) & n /= (n Ra_MINUS Ra_1) 
    ALGEBRA ==> n /= (n Ra_MINUS Ra_1)
    ELEM ==> not Ra_is_nonneg(n Ra_MINUS (n Ra_MINUS Ra_1))
    ELEM ==> not Ra_is_nonneg(Ra_1)
    T99999 ==> false; Discharge ==> {y: y in Ra | n Ra_GT y} /= 0
    Use_Def(Re) ==> Stat1: {y: y in Ra | n Ra_GT y} notin {s: s incin Ra | s /= 0 & s /= Ra} &
      (FORALL x in s | (EXISTS y in s | y Ra_GT x)) & (FORALL x in s | (FORALL y in Ra | ((x Ra_GT y) imp (y in s))))
    ({y: y in Ra | n Ra_GT y}) --> Stat1 ==>
          (not(FORALL x in {y: y in Ra | n Ra_GT y} | (EXISTS y in {y: y in Ra | n Ra_GT y} | y Ra_GT x))) &
              (not(FORALL x in {y: y in Ra | n Ra_GT y} | (FORALL y in Ra | ((x Ra_GT y) imp (y in {y: y in Ra | n Ra_GT y})))))
    SIMPLF ==> (not(FORALL x in Ra | (EXISTS y in Ra | ((n Ra_GT x) imp (n Ra_GT y & y Ra_GT x))))) &
                  (not(FORALL x in Ra | (FORALL y in Ra | (((n Ra_GT x) imp (x Ra_GT y)) imp (y in {y: y in Ra | n Ra_GT y})))))
    Suppose ==> Stat2: not(FORALL x in Ra | (FORALL y in Ra | (((n Ra_GT x) imp (x Ra_GT y)) imp (y in {y: y in Ra | n Ra_GT y}))))
    (b,c) --> Stat2 ==> b in Ra & c in Ra & n Ra_GT b & b Ra_GT c & Stat3: c notin {y: y in Ra | n Ra_GT y}
    c --> Stat2 ==> not n Ra_GT c
    (n,b,c) --> T99999 ==> false; Discharge ==> Stat3: not(FORALL x in Ra | (EXISTS y in Ra | ((n Ra_GT x) imp (n Ra_GT y & y Ra_GT x))))
    x --> Stat3 ==> Stat4: not(EXISTS y in Ra | ((n Ra_GT x) imp (n Ra_GT y & y Ra_GT x)))
    (n,x) --> T99999 ==> n Ra_GT ((n Ra_PLUS x) Ra_OVER (Ra_1 Ra_PLUS Ra_1)) & 
                ((n Ra_PLUS x) Ra_OVER (Ra_1 Ra_PLUS Ra_1)) Ra_GT x
    ((n Ra_PLUS x) Ra_OVER (Ra_1 Ra_PLUS Ra_1)) --> Stat4 ==> false; Discharge ==> QED
    
Theorem 296: R_0 in Re & R_1 in Re & R_is_nonneg(R_0) & R_is_nonneg(R_1) & R_1 R_GT R_0. Proof:
    Use_Def(R_0) ==> R_0 = {x: x in Ra | Ra_0 Ra_GT x}
    Use_Def(R_1) ==> R_1 = {x: x in Ra | Ra_1 Ra_GT x}
    ALGEBRA ==> Ra_0 in Ra & Ra_1 in Ra
    Ra_0 --> T99999 ==> R_0 in Re
    Ra_1 --> T99999 ==> R_1 in Re
    T99999 ==> Ra_1 Ra_GT Ra_0
    T281a ==> not (Ra_0 Ra_GT Ra_0)
    Suppose ==> Stat1: Ra_0 notin {x: x in Ra | Ra_1 Ra_GT x}
    Ra_0 --> Stat1 ==> not (Ra_1 Ra_GT Ra_0)
    T99999 ==> false; Discharge ==> Ra_0 in R1
    Suppose ==> Stat2: Ra_0 in {x: x in Ra | Ra_0 Ra_GT x}
    Ra_0 --> Stat2 ==> Ra_0 Ra_GT Ra_0
    T281a ==> false; Discharge ==> Ra_0 notin R_0
    ELEM ==> R_0 /= R1 & (not (R_1 incin R_0))
    (Ra_0,Ra_1) --> T99999 ==> R_0 incin R_1
    Use_Def(R_GT) ==> R_1 R_GT R_0
    Use_Def(R_is_nonneg) ==> R_is_nonneg(R_0) & R_is_nonneg(R_1) 
    ELEM ==> QED

--PAUSE HERE ------------

To make some meaningless comment, and then restart the sequence of theorems and definition

--BEGIN HERE ------------

Theorem 297: (N in Re) imp (N incin Ra). Proof:
    Suppose_not(n) ==> n in Re & (not n incin Ra)
    Use_Def(Re) ==> Stat0: n in {s: s incin Ra | s /= 0 & s /= Ra} &
      (FORALL x in s | (EXISTS y in s | y Ra_GT x)) & (FORALL x in s | (FORALL y in Ra | ((x Ra_GT y) imp (y in s))))
    a --> Stat0 ==> QED

Theorem 298: (N in Re) imp (EXISTS m in Ra | (FORALL x in N | (m Ra_GT x))). Proof:
    Suppose_not(n) ==> n in Re & Stat1: (not (EXISTS M in Ra | (FORALL x in n | M Ra_GT x)))
    Use_Def(Re) ==> Stat2: n in {s: s incin Ra | s /= 0 & s /= Ra} &
      (FORALL x in s | (EXISTS y in s | y Ra_GT x)) & (FORALL x in s | (FORALL y in Ra | ((x Ra_GT y) imp (y in s))))
    a --> Stat2 ==> n incin Ra & n /= 0 & n /= Ra & Stat0: (FORALL x in n | (FORALL y in Ra | ((x Ra_GT y) imp (y in s))))
    Memb(c) ==> c in Ra & c notin n
    c --> Stat1 ==> Stat3: not (FORALL x in n | c Ra_GT x)
    b --> Stat3 ==> b in n & (not (c Ra_GT b))
    (b,c) --> T99999 ==> b Ra_GT c
    (b,c) --> Stat0 ==> false; Discharge ==> QED
    
Theorem 299: (N in Re & M in Re) imp (N R_PLUS M in Re). Proof:
    Suppose_not(n,m) ==> n in Re & m in Re & n R_PLUS m notin Re
    THUS ==> n incin Ra & m incin Ra
    Use_Def(R_PLUS) ==> {u Ra_PLUS v: u in n, v in m} notin Re
    Suppose ==> not ({u Ra_PLUS v: u in n, v in m} incin Ra)
    Memb(c) ==> Stat1: c in {u Ra_PLUS v: u in n, v in m} & c notin Ra
    (a,b) --> Stat1 ==> c in a Ra_PLUS b & a in Ra & b in Ra
    ELEM ==> false; Discharge ==> {u Ra_PLUS v: u in n, v in m} incin Ra
    Use_Def(Re) ==> Stat2: n in {s: s incin Ra | s /= 0 & s /= Ra} & 
              (FORALL x in s | (EXISTS y in s | y Ra_GT x)) & (FORALL x in s | (FORALL y in Ra | ((x Ra_GT y) imp (y in s)))) & 
      m in {s: s incin Ra | s /= 0 & s /= Ra} & 
            (FORALL x in s | (EXISTS y in s | y Ra_GT x)) & (FORALL x in s | (FORALL y in Ra | ((x Ra_GT y) imp (y in s)))) &
      Stat3: {u Ra_PLUS v: u in n, v in m} notin {s: s incin Ra | s /= 0} & s /= Ra & 
            (FORALL x in s | (EXISTS y in s | y Ra_GT x)) & (FORALL x in s | (FORALL y in Ra | ((x Ra_GT y) imp (y in s))))
    (a1,b1) --> Stat2 ==> m /= 0 & n /= 0 & Stat5: (FORALL x in m | (EXISTS y in m | y Ra_GT x)) &
                          Stat6: (FORALL x in m | (FORALL y in Ra | ((x Ra_GT y) imp (y in m)))) & 
                        Stat8: (FORALL x in n | (EXISTS y in n | y Ra_GT x)) &
                          Stat9: (FORALL x in n | (FORALL y in Ra | ((x Ra_GT y) imp (y in n)))) 
    ({u Ra_PLUS v: u in n, v in m}) --> Stat3 ==> {u Ra_PLUS v: u in n, v in m} = 0 or
      (not(EXISTS u in Ra | (FORALL x in {u Ra_PLUS v: u in n, v in m} | u Ra_GT x))) or 
          (not(FORALL x in {u Ra_PLUS v: u in n, v in m} | (EXISTS y in {u Ra_PLUS v: u in n, v in m} | y Ra_GT x))) &
      (not(FORALL x in {u Ra_PLUS v: u in n, v in m} | (FORALL y in Ra | ((x Ra_GT y) imp (y in {u Ra_PLUS v: u in n, v in m}))))) 
    SIMPLF ==> {u Ra_PLUS v: u in n, v in m} = 0 or
      (not(EXISTS u in Ra | (FORALL v in n | (FORALL w in m | u Ra_GT v Ra_PLUS w)))) or 
          (not(FORALL v in n | (FORALL w in m | (EXISTS y in n | (EXISTS z in m | y Ra_PLUS z Ra_GT v Ra_PLUS w))))) &
      (not(FORALL u in n | (FORALL v in m | (FORALL y in Ra | ((u Ra_PLUS v Ra_GT y) imp (y in {u Ra_PLUS v: u in n, v in m}))))))
    Memb(cm) ==> cm in m
    Memb(cn) ==> cn in n
    Suppose ==> {u Ra_PLUS v: u in n, v in m} = 0 
    ELEM ==> Stat0: cm Ra_PLUS cm notin {u Ra_PLUS v: u in n, v in m}
    (cm,cm) --> Stat0 ==> false; Discharge ==> {u Ra_PLUS v: u in n, v in m} /= 0
    Suppose ==> 
      Stat10: not(FORALL u in n | (FORALL v in m | (FORALL y in Ra | ((u Ra_PLUS v Ra_GT y) imp (y in {u Ra_PLUS v: u in n, v in m})))))
    (u1,v1,y1) --> Stat10 ==> 
        u1 in n & v1 in m & y1 in Ra & u1 Ra_PLUS v1 Ra_GT y1 & Stat11: y1 notin {u Ra_PLUS v: u in n, v in m}
    THUS ==> u1 Ra_PLUS v1 in Ra
    (u1,v1,y1) --> T99999 ==> (u1 Ra_PLUS v1) Ra_MINUS v1 Ra_GT y1 Ra_MINUS v1
    ALGEBRA ==> u1 Ra_GT y1 Ra_MINUS v1
    (y1 Ra_MINUS v1,v1) --> Stat11 ==> y1 /= (u Ra_PLUS v) or y1 Ra_MINUS v1 notin n or v1 notin m
    ELEM ==> y1 Ra_MINUS v1 notin n
    (u1,y1 Ra_MINUS v1) --> Stat6 ==> false
    Discharge ==> (FORALL u in n | (FORALL v in m | (FORALL y in Ra | ((u Ra_PLUS v Ra_GT y) imp (y in {u Ra_PLUS v: u in n, v in m})))))
    Suppose ==> Stat12: not(FORALL v in n | (FORALL w in m | (EXISTS y in n | (EXISTS z in m | v Ra_PLUS w Ra_GT y Ra_PLUS z))))
    (v2,w2) --> Stat12 ==> v2 in n & w2 in m & Stat13: (not(EXISTS y in n | (EXISTS z in m | y Ra_PLUS z Ra_GT v2 Ra_PLUS w2)))
    (w2,z2) --> Stat5 ==> z2 in m & z2 Ra_GT w2
    (v2,y2) --> Stat8 ==> y2 in n & y2 Ra_GT v2
    (v2,w2,y2,z2) --> T99999 ==> y2 Ra_PLUS z2 Ra_GT v2 Ra_PLUS w2
    (y2,z2) --> Stat13 ==>false; Discharge ==> Stat13: not(EXISTS u in Ra | (FORALL v in n | (FORALL w in m | u Ra_GT v Ra_PLUS w)))
    m --> T99999 ==> Stat4: (EXISTS u in Ra | (FORALL x in m | u Ra_GT x))
    n --> T99999 ==> Stat7: (EXISTS u in Ra | (FORALL x in n | u Ra_GT x))
    u3 --> Stat4 ==> u3 in Ra & Stat14: (FORALL x in m | u3 Ra_GT x)
    v3 --> Stat7 ==> v3 in Ra & Stat15: (FORALL x in n | v3 Ra_GT x)
    ALGEBRA ==> u3 Ra_PLUS v3 in Ra
    (u3 R_PLUS v3,y3,z3) --> Stat13 ==> y3 in m & z3 in n & (not(u3 Ra_PLUS v3 Ra_GT y3 Ra_PLUS z3))
    (u3,y3) --> Stat14 ==> u3 Ra_GT y3
    (v3,z3) --> Stat14 ==> v3 Ra_GT z3
    (u3,v3,y3,z3) --> T99999 ==> false; Discharge ==> QED
    
Theorem 300: (N in Re & M in Re) imp (N R_PLUS M = M R_PLUS N). Proof:
    Suppose_not(n,m) ==> n in Re & m in Re & n R_PLUS m /= m R_PLUS n
    THUS ==> n incin Ra & m incin Ra
    Use_Def(R_PLUS) ==> {u Ra_PLUS v: u in n, v in m} /= {u Ra_PLUS v: u in m, v in n}
    ELEM ==> {v Ra_PLUS u: u in m, v in n} /= {u Ra_PLUS v: u in m, v in n}
    Suppose ==> not(FORALL u in m | (FORALL v in n | v Ra_PLUS u = u Ra_PLUS v))
    Pred_monot ==> Stat1: not(FORALL u in Ra | (FORALL v in Ra | v Ra_PLUS u = u Ra_PLUS v))
    (u,v) --> Stat1 ==> u in Ra & v in Ra & v Ra_PLUS u /= u Ra_PLUS v
    ALGEBRA ==> false; Discharge ==> (FORALL u in m | (FORALL v in n | v Ra_PLUS u = u Ra_PLUS v))
    EQUAL ==> false; Discharge ==> QED


Theorem 301: (N in Re) imp (N = N R_PLUS R_0). Proof:
    Suppose_not(n) ==> n in Re & n = n R_PLUS R_0
    Use_Def(Re) ==> Stat0: n in {s: s incin Ra | s /= 0 & s /= Ra &
      (FORALL x in s | (EXISTS y in s | y Ra_GT x)) & (FORALL x in s | (FORALL y in Ra | ((x Ra_GT y) imp (y in s))))}
    z --> Stat0 ==> 
      n incin Ra & Stat3: (FORALL x in n | (EXISTS y in n | y Ra_GT x)) & Stat2: (FORALL x in n | (FORALL y in Ra | ((x Ra_GT y) imp (y in n))))
    Use_Def(R_PLUS) ==> n /= {u Ra_PLUS v: u in n, v in R_0}
    Use_Def(R_0) ==> n /= {u Ra_PLUS v: u in n, v in {x in Ra | Ra_0 Ra_GT x}}
    SIMPLF ==> n /= {u Ra_PLUS v: u in n, v in Ra | Ra_0 Ra_GT v}
    Memb(c) ==> (c in n & c notin {u Ra_PLUS v: u in n, v in Ra | Ra_0 Ra_GT v}) or 
            (c notin n & c in {u Ra_PLUS v: u in n, v in Ra | Ra_0 Ra_GT v})
    Suppose ==> c notin n & Stat3: c in {u Ra_PLUS v: u in n, v in Ra | Ra_0 Ra_GT v}
    (a,b) --> Stat3 ==> c notin n & c = a Ra_PLUS b & a in n & b in Ra & Ra_0 Ra_GT b
    ELEM ==> a in Ra
    (a,a,Ra_0,b) --> T99999 ==> a Ra_PLUS Ra_0 Ra_GT a Ra_PLUS b 
    ALGEBRA ==> a Ra_GT a Ra_PLUS b & a Ra_PLUS b in Ra
    (a,a Ra_PLUS b) --> Stat2 ==> false; Discharge ==> c in n & Stat2: c notin {u Ra_PLUS v: u in n, v in Ra | Ra_0 Ra_GT v}
    (c,d) --> Stat3 ==> d in n & d Ra_GT c
    (d,c) --> T99999 ==> d Ra_MINUS d Ra_GT c Ra_MINUS d
    ALGEBRA ==> Ra_0 Ra_GT c Ra_MINUS d & c = d + c Ra_MINUS d
    (d,c Ra_MINUS d) --> Stat2 ==> false; Discharge ==> QED
    
    
Theorem 302: (N in Re) imp (R_Rev(N) in Re). Proof:
    Suppose_not(n) ==> n in Re & (not(R_Rev(n) in Re & R_Rev(R_Rev(n)) = n))
    ALGEBRA ==> R_0 in Re
    Use_Def(Re) ==> Stat1: n in {s: s incin Ra | s /= 0 & s /= Ra &
      (FORALL x in s | (EXISTS y in s | y Ra_GT x)) & (FORALL x in s | (FORALL y in Ra | ((x Ra_GT y) imp (y in s))))}
      & R_0 in {s: s incin Ra | s /= 0 & s /= Ra &
      (FORALL x in s | (EXISTS y in s | y Ra_GT x)) & (FORALL x in s | (FORALL y in Ra | ((x Ra_GT y) imp (y in s))))}
    (z,w) --> Stat1 ==> n incin Ra & n /= 0 & n /= Ra & Stat9: (FORALL x in n | (EXISTS y in n | y Ra_GT x)) &
        Stat11: (FORALL x in n | (FORALL y in Ra | ((x Ra_GT y) imp (y in n)))) & 
          R_0 /= 0 & Stat11: (FORALL x in R_0 | (EXISTS y in R_0 | y Ra_GT x)) & 
            Stat12: (FORALL x in R_0 | (FORALL y in Ra | ((x Ra_GT y) imp (y in R_0))))
    Suppose ==> R_Rev(n) notin Re
    Use_Def(R_Rev) ==> R_Rev(n) = {Ra_Rev(u) Ra_PLUS v: u in Ra - n, v in R_0}
    Set_monot ==> R_Rev(n) incin {u Ra_PLUS v: u in Ra, v in Ra}
    Suppose ==> not {u Ra_PLUS v: u in Ra, v in Ra} incin Ra
    Memb(c) ==> Stat1: c in {u Ra_PLUS v: u in Ra, v in Ra} & c notin Ra
    (a,b) --> Stat1 ==> c = a Ra_PLUS b & a in Ra & b in Ra & c notin Ra
    ALGEBRA ==> false; Discharge ==> R_Rev(n) incin Ra
    ELEM ==> Ra - n /= 0
    Memb(c) ==> c in Ra - n
    Memb(d) ==> d in R_0
    Suppose ==> Stat2: Ra_Rev(c) Ra_PLUS d notin {Ra_Rev(u) Ra_PLUS v: u in Ra - n, v in R_0}
    (c,d) --> Stat2 ==> false; Discharge ==> R_Rev(n) /= 0
    Memb(e) ==> e in n
    Suppose ==> Stat3: Ra_Rev(e) in {Ra_Rev(u) Ra_PLUS v: u in Ra - n, v in R_0}
    (a1,b1) --> Stat3 ==> Ra_Rev(e) = Ra_Rev(a1) Ra_PLUS b1 & a1 in Ra & a1 notin n & b1 in R_0
    THUS ==> e in Ra & b1 in Ra
    ALGEBRA ==> Ra_Rev(e) in Ra
    (e,a1) --> S_b ==> not e Ra_GT a1
    (e,a1) --> T99999 ==> a1 Ra_GT e or a1 = e
    (e,a1) --> T99999 ==> Ra_Rev(e) Ra_GT Ra_Rev(a1) or Ra_Rev(e) = Ra_Rev(a1)
    Use_Def(R_0) ==> Stat4: b1 in {x in Ra | Ra_0 Ra_GT x}
    z1 --> Stat4 ==> b1 in Ra & Ra_0 Ra_GT b1
    (Ra_Rev(a1),Ra_0,Ra_Rev(a1),b1) --> T99999 ==> Ra_Rev(a1) Ra_GT Ra_Rev(e)
    (Ra_Rev(a1),Ra_Rev(e)) --> T99999 ==> Ra_Rev(Ra_Rev(e)) Ra_GT Ra_Rev(Ra_Rev(a1))
    ALGEBRA ==> e Ra_GT a1
    (e,a1) --> T99999 ==> false; Discharge ==> R_Rev(n) /= Ra
    Suppose ==> not(FORALL x in R_Rev(n) | (EXISTS y in R_Rev(n) | y Ra_GT x))
    Use_Def(R_Rev) ==> not(FORALL x in {Ra_Rev(u) Ra_PLUS v: u in Ra - n, v in R_0} | (EXISTS y in R_Rev(n) | y Ra_GT x))
    SIMPLF ==> Stat5: not(FORALL u in Ra - n | (FORALL v in R_0 | (EXISTS y in R_Rev(n) | y Ra_GT Ra_Rev(u) Ra_PLUS v)))
    (a2,b2) --> Stat5 ==> a2 in Ra - n & b2 in R_0 & Stat6: (not(EXISTS y in R_Rev(n) | y Ra_GT Ra_Rev(a2) Ra_PLUS b2))
    c2 --> Stat_aa ==> c2 in R_0 & c2 Ra_GT b2
    (c2,Ra_Rev(a2),b2,Ra_Rev(a2),b1) --> T99999 ==> Ra_Rev(a2) Ra_PLUS c2 Ra_GT Ra_Rev(a2) Ra_PLUS b2
    (Ra_Rev(a2) Ra_PLUS c2) --> Stat6 ==> Stat6: Ra_Rev(a2) Ra_PLUS c2 notin {Ra_Rev(u) Ra_PLUS v: u in Ra - n, v in R_0}
    (a2,b2) --> Stat6 ==> false; Discharge ==> (FORALL x in R_Rev(n) | (EXISTS y in R_Rev(n) | y Ra_GT x))
    Suppose ==> not(FORALL x in R_Rev(n) | (FORALL y in Ra | ((x Ra_GT y) imp (y in n))))
    Use_Def(R_Rev) ==> not(FORALL x in {Ra_Rev(u) Ra_PLUS v: u in Ra - n, v in R_0} | (FORALL y in Ra | ((x Ra_GT y) imp (y in n))))
    SIMPLF ==> Stat7: not(FORALL u in Ra - n | (FORALL v in R_0 | (FORALL y in Ra | (((Ra_Rev(u) Ra_PLUS v) Ra_GT y) imp (y in R_Rev(n))))))
    (a3,b3,c3) --> Stat7 ==> a3 in Ra - n & b3 in R_0 & c3 in Ra & Ra_Rev(a3) Ra_PLUS b3 Ra_GT c3 & c3 notin R_Rev(n)
    THUS ==> a3 in Ra & b3 in Ra
    ALGEBRA ==> c3 = Ra_Rev(Ra_Rev(c3) Ra_PLUS b3) Ra_PLUS b3 & Ra_Rev(c3) Ra_PLUS b3 in Ra & Ra_Rev(c3) in Ra
    ELEM ==> Stat8: c3 notin {Ra_Rev(u) Ra_PLUS v: u in Ra - n, v in R_0}
    (Ra_Rev(a3) Ra_PLUS b3,Ra_Rev(c3) Ra_PLUS a3,c3,Ra_Rev(c3) Ra_PLUS a3) --> T99999 ==> 
      (Ra_Rev(a3) Ra_PLUS b3) Ra_PLUS (Ra_Rev(c3) Ra_PLUS a3) Ra_GT c3 Ra_PLUS (Ra_Rev(c3) Ra_PLUS a3)
    ALGEBRA ==> Ra_Rev(c3) Ra_PLUS b3 Ra_GT a3
    (Ra_Rev(c3) Ra_PLUS b3,b3) --> Stat8 ==> Ra_Rev(c3) Ra_PLUS b3 notin Ra - n
    ELEM ==> Ra_Rev(c3) Ra_PLUS b3 in n
    (Ra_Rev(c3) Ra_PLUS b3,a3) --> Stat_b ==> a3 in n
    ELEM ==> false; Discharge ==> (FORALL x in R_Rev(n) | (FORALL y in Ra | ((x Ra_GT y) imp (y in n))))
    Suppose ==> R_Rev(n) notin Re
    Use_Def(Re) ==> Stat8: R_Rev(n) notin {s: s incin Ra | s /= 0 & s /= Ra &
      (FORALL x in s | (EXISTS y in s | y Ra_GT x)) & (FORALL x in s | (FORALL y in Ra | ((x Ra_GT y) imp (y in s))))}
    R_Rev(n) --> Stat8 ==> false; Discharge ==> QED

Theorem: (N in Si & M in Si & M /= [0,0] & is_nonneg(M)) imp 
      (EXISTS k in Si | is_nonneg(N S_MINUS (k S_TIMES M)) & is_nonneg(((k S_PLUS [1,0])S_TIMES M)) S_MINUS N). Proof: 
    Suppose_not(n,m) ==> n in Si & m in Si & m /= [0,0] & is_nonneg(m) & 
      (not(EXISTS k in Si | is_nonneg(n S_MINUS (k S_TIMES m)) & is_nonneg(((k S_PLUS [1,0]) S_TIMES m)) S_MINUS n))

Theorem: (N in Re) imp (N = N R_PLUS R_Rev(N) = R_0). Proof:
    Suppose_not(n) ==> n in Re & n = n R_PLUS R_Rev(n) /= R_0
    n --> T99999 ==> n incin Ra 
    Use_Def(R_Rev) ==> n R_PLUS {Ra_Rev(u) Ra_PLUS v: u in Ra - n, v in R_0} /= R_0
    Use_Def(R_PLUS) ==> 
      {x Ra_PLUS y: x in n & y in {Ra_Rev(u) Ra_PLUS v: u in Ra - n, v in R_0}} /= R_0
    SIMPLF ==> {x Ra_PLUS (Ra_Rev(u) Ra_PLUS v): x in n, u in Ra - n, v in R_0} /= R_0
    Suppose ==> not {x Ra_PLUS (Ra_Rev(u) Ra_PLUS v): x in n, u in Ra - n, v in R_0} incin R_0
    Memb(c) ==> Stat1: c in {x Ra_PLUS (Ra_Rev(u) Ra_PLUS v): x in n, u in Ra - n, v in R_0} & c notin R_0
    (a1,b1,c1) --> Stat1 ==> c = a1 Ra_PLUS (Ra_Rev(b1) Ra_PLUS c1) & a1 in n & b1 in Ra - n & c1 in R_0
    THUS ==> a1 in Ra & b1 in Ra & c1 in Ra
    ALGEBRA ==> Ra_Rev(b1) in Ra
    THUS ==> false; Discharge ==> not({x Ra_PLUS (Ra_Rev(u) Ra_PLUS v): x in n, u in Ra - n, v in R_0} incs R_0)
     Memb(d) ==> Stat1: d in R_0 & d notin {x Ra_PLUS (Ra_Rev(u) Ra_PLUS v): x in n, u in Ra - n, v in R_0}
    THUS ==> false; Discharge ==> QED
    
Theorem: (N in Re & M in Re) imp (N incin M or M incin N). Proof:
    Suppose_not(n) ==> n in Re & m in Re & (not(n incin m)) & (not(m incin n)) 
    Use_Def(Re) ==> Stat1: n in {s: s incin Ra | s /= 0 & s /= Ra &
      (FORALL x in s | (EXISTS y in s | y Ra_GT x)) & (FORALL x in s | (FORALL y in Ra | ((x Ra_GT y) imp (y in s))))} &
        m in {s: s incin Ra | s /= 0 & s /= Ra &
      (FORALL x in s | (EXISTS y in s | y Ra_GT x)) & (FORALL x in s | (FORALL y in Ra | ((x Ra_GT y) imp (y in s))))} 
    (a,b) --> Stat1 ==> n incin Ra & Stat2: (FORALL x in n | (FORALL n in Ra | ((x Ra_GT y) imp (y in n)))) &
              m incin Ra & m /= 0 & Stat3: (FORALL x in m | (FORALL y in Ra | ((x Ra_GT y) imp (y in m))))
    Memb(c) ==> (c in n & c notin m)
    Memb(d) ==> (d in m & d notin n)
    ELEM ==> c /= d & c in Ra & d in Ra
    Suppose ==> c Ra_GT d
    (c,d) --> Stat2 ==> false; Discharge ==> not(c Ra_GT d)
    Suppose ==> d Ra_GT c
    (d,c) --> Stat2 ==> false; Discharge ==> not(d Ra_GT c)
    T281a ==> (not Ra_is_nonneg(c Ra_MINUS d)) & (not Ra_is_nonneg(d Ra_MINUS c))
    ALGEBRA ==> (not Ra_is_nonneg(c Ra_MINUS d)) & (not Ra_is_nonneg(Ra_rev(c Ra_MINUS d)))
    (c,d) --> T99999 ==> false; Discharge ==> QED
              
Theorem: (N in Re & M in Re) imp (N + M in Re). Proof:
    Suppose_not(n,m) ==> n in Re & m in Re & n + m notin Re
    (n,m) --> T99999 ==> n incin m or m incin n
    ELEM ==> false; Discharge ==> QED
    
Theorem: (N in Re) imp (abs(N) in Re & N incin abs(N)). Proof:
    Suppose_not(n) ==> n in Re & (abs(n) notin Re or not n incin abs(n))
    Use_Def(abs) ==> abs(n) = n + R_Rev(n)
    ELEM ==> n + R_Rev(n) notin R
    n --> T99999 ==> R_Rev(n) in R
    (n,R_Rev(n)) --> T99999 ==> false; Discharge ==> QED
    
Theorem: (N in Re & M in Re) imp (N = M R_PLUS (N R_MINUS M)). Proof:
    Suppose_not(n,m) ==> n in Re & m in Re & n /= m R_PLUS (n R_MINUS m)
    Use_Def(R_MINUS) ==> n /= m R_PLUS (n R_PLUS R_Rev(m))
    ALGEBRA ==> n /= n R_PLUS (m R_PLUS R_Rev(m))
    m --> T99999 ==> n /= n R_PLUS R_0
    n --> T99999 ==> false; Discharge ==> QED

Theorem: (N in Re & M in Re) imp (N R_TIMES_ABS M = M R_TIMES_ABS N). Proof:
    Suppose_not(n,m) ==> n in Re & m in Re & n R_TIMES_ABS m = m R_TIMES_ABS n
    Use_Def(R_TIMES_ABS) ==> {u Ra_TIMES v: u in abs(n) and v in abs(m) | not(Ra_0 Ra_GT u or Ra_0 Ra_GT v)} + R_0 /= 
          {u Ra_TIMES v: u in abs(m), v in abs(n) | not(Ra_0 Ra_GT u or Ra_0 Ra_GT v)} + R_0
    ELEM ==> {u Ra_TIMES v: u in abs(n), v in abs(m) | not(Ra_0 Ra_GT u or Ra_0 Ra_GT v)} /= 
          {v Ra_TIMES u: u in abs(n), v in abs(m) | not(Ra_0 Ra_GT v or Ra_0 Ra_GT u)}
    ELEM ==> (not(Ra_0 Ra_GT V or Ra_0 Ra_GT U)) eq (not(Ra_0 Ra_GT U or Ra_0 Ra_GT V))
    EQUAL ==> {u Ra_TIMES v: u in abs(n), v in abs(m) | not(Ra_0 Ra_GT u or Ra_0 Ra_GT v)} /= 
          {v Ra_TIMES u: u in abs(n), v in abs(m) | not(Ra_0 Ra_GT u or Ra_0 Ra_GT v)}
    n --> T99999 ==> abs(n) in R
    m --> T99999 ==> abs(m) in R
    THUS ==> abs(n) incin Ra & abs(m) incin Ra
    Suppose ==> Stat1: not(FORALL u in abs(n) | (FORALL v in abs(n) | u Ra_TIMES v = v Ra_TIMES u))
    Pred_monot ==> not(FORALL u in Ra | (FORALL v in Ra | u Ra_TIMES v = v Ra_TIMES u))
    (a,b) --> Stat1 ==> a in Ra & b in Ra & a Ra_TIMES b /= b Ra_TIMES a
    ALGEBRA ==> false; Discharge ==> (FORALL u in abs(n) | (FORALL v in abs(n) | u Ra_TIMES v = v Ra_TIMES u))
    EQUAL ==> false; Discharge ==> QED
    
Theorem: (N in Re & M in Re) imp (N R_TIMES M = M R_TIMES N). Proof:
    Suppose_not(n,m) ==> n in Re & m in Re & n R_TIMES m /= m R_TIMES n
    (n,m) --> T99999 ==> n R_TIMES_ABS n = m R_TIMES_ABS n 
    Use_Def(R_TIMES) ==> not((n incs R_0 eq m incs R_0) eq (m incs R_0 eq n incs R_0))
    ELEM ==> false; Discharge ==> QED

Theorem: (N in Re) imp (abs(N) = if R_is_nonneg(N) then N else R_Rev(N) end if). Proof:
    Suppose_not(n) ==> n in Re & abs(n) /= if R_is_nonneg(n) then n else R_Rev(n) end if
    Use_Def(abs) ==> abs(n) = n + R_Rev(n) 
    Use_Def(R_is_nonneg) ==> R_is_nonneg(n) eq R_0 incin n
    Suppose ==> R_is_nonneg(n)
    ELEM ==> R_0 incin n & (not(R_Rev(n) incin n))
    Memb(c) ==> c in R_Rev(n) & c notin n
    Use_Def(R_Rev) ==> Stat1: c in {Ra_Rev(u) Ra_PLUS v: u in Ra - n, v in R_0}
    (a,b) --> Stat1 ==> c = Ra_Rev(a) Ra_PLUS b & a in Ra & a notin n & b in R_0
    Use_Def(R_0) ==> R_0 = {x in Ra | Ra_0 Ra_GT x} & Stat2: b in {x in Ra | Ra_0 Ra_GT x}
    z --> Stat2 ==> b in Ra & Ra_0 Ra_GT b
    Suppose ==> Ra_0 Ra_GT a
    Suppose ==> Stat3: a notin {x in Ra | Ra_0 Ra_GT x}
    z2 --> Stat3 ==> false; Discharge ==> a in R_0
    ELEM ==> false; Discharge ==> not (Ra_0 Ra_GT a)
    a --> T99999 ==> a Ra_GT Ra_0 or a = Ra_0
    b --> T99999 ==> Ra_Rev(b) Ra_GT Ra_0
    (a,Ra_0,b,Ra_0) ==> a Ra_PLUS Ra_Rev(b) Ra_GT Ra_0 Ra_PLUS Ra_0
    ALGEBRA ==> a Ra_PLUS Ra_Rev(b) Ra_GT Ra_0
    (a,b) --> T99999 ==> Ra_0 Ra_GT Ra_Rev(a Ra_PLUS Ra_Rev(b))
    ALGEBRA ==> Ra_0 Ra_GT Ra_Rev(a) Ra_PLUS b
    Suppose ==> Stat4: Ra_Rev(a) Ra_PLUS b notin {x in Ra | Ra_0 Ra_GT x}
    z3 --> Stat3 ==> false; Discharge ==> Ra_Rev(a) Ra_PLUS b in R_0
    ELEM ==> false; Discharge ==> not R_is_nonneg(n)
    ELEM ==> (not(R_0 incin n)) & (not(n incin R_Rev(n)))
    Memb(d) ==> d in R_0 & d notin n
    Use_Def(R_0) ==> Stat10: d in {x in Ra | Ra_0 Ra_GT x}
    z5 --> Stat_a ==> Ra_0 Ra_GT d
    (Ra_0,d) --> T99999 ==> Ra_Rev(d) Ra_GT Ra_Rev(Ra_0)
    (Ra_Rev(d),Ra_0,d) --> T99999 ==> Ra_Rev(d) Ra_GT d
    Memb(e) ==> e in n & e notin R_Rev(n)
    Use_Def(R_Rev) ==> Stat5: e notin {Ra_Rev(u) Ra_PLUS v: u in Ra - n, v in R_0}
    Use_Def(Re) ==> Stat6: n in {s: s incin Ra | s /= 0 & s /= Ra &
      (FORALL x in s | (EXISTS y in s | y Ra_GT x)) & (FORALL x in s | (FORALL y in Ra | ((x Ra_GT y) imp (y in s))))}
    z4 --> Stat6 ==> Stat7: (FORALL x in n | (FORALL y in Ra | ((x Ra_GT y) imp (y in n))))
    (e,d) --> Stat7 ==> not e Ra_GT d
    (Ra_Rev(d),d) --> Stat7 ==> not Ra_Rev(d) in n
    THUS ==> d in Ra & e in Ra & Ra_Rev(d) in Ra & Ra_Rev(e) in Ra
    ELEM ==> not e = d
    (e,d) --> T99999 ==> d Ra_GT e
    (d,R_Rev(e),e,R_Rev(e)) --> T99999 ==> d Ra_PLUS Ra_Rev(d) Ra_GT e Ra_PLUS Ra_Rev(d)
    ALGEBRA ==> Ra_0 Ra_GT e R_PLUS Ra_Rev(d)
    Suppose ==> e R_PLUS Ra_Rev(d) notin R_0
    Use_Def(R_0) ==> Stat8: e R_PLUS Ra_Rev(d) notin {x in Ra | Ra_0 Ra_GT x}
    (e R_PLUS Ra_Rev(d)) --> Stat8 ==> false; Discharge ==> e R_PLUS Ra_Rev(d) in R_0
    (Ra_Rev(d), e R_PLUS Ra_Rev(d)) --> Stat5 ==> 
      e /= Ra_Rev(Ra_Rev(d)) Ra_PLUS (e R_PLUS Ra_Rev(d)) or Ra_Rev(d) notin Ra - n or e R_PLUS Ra_Rev(d) notin R_0
    ALGEBRA ==> false; Discharge ==> QED
    
Theorem: (N in Re) imp (abs(N) in Re & (abs(N) R_GT N or abs(N) = N) & (abs(N) R_GT R_0 or abs(N) = R_0) & R_is_nonneg(abs(N))). Proof:
    Suppose_not(n) ==> n in Re & (not(abs(n) in Re & (abs(n) R_GT n or abs(n) = n) & ((abs(n) R_GT R_0) or (abs(n) = R_0)) & R_is_nonneg(abs(n))))
    Suppose ==> R_is_nonneg(n)
    n --> T99999 ==> abs(n) = n
    ELEM ==> false; Discharge ==> not R_is_nonneg(n)
    n --> T99999 ==> abs(n) = R_Rev(n)
    n --> T99999 ==> R_is_nonneg(R_Rev(n))
    ELEM ==> not R_Rev(n) R_GT n & R_Rev(n) /= n
    Use_Def(R_GT) ==> not R_is_nonneg(R_Rev(n) R_MINUS n)
    ALGEBRA ==> not R_is_nonneg(R_Rev(n) R_MINUS R_Rev(n))
    n --> T99999 ==> R_is_nonneg(R_Rev(n))
    n --> T99999 ==> false; Discharge ==> QED

Theorem: (N in Re) imp (abs(N) = abs(R_Rev(N))). Proof:
    Suppose_not(n) ==> n in Re & (not(abs(n) = abs(R_Rev(n))))
    ALGEBRA ==> R_0 = R_Rev(R_0)
    T99999 ==> R_is_nonneg(R_0) & R_is_nonneg(R_Rev(R_0))
    Suppose ==> n = R_0
    R_0 --> T99999 ==> abs(n) = n
    (R_Rev(R_0)) --> T99999 ==> false; Discharge ==> n /= R_0
    Suppose ==> R_is_nonneg(n)
    n --> T99999 ==> not R_is_nonneg(R_Rev(n))
    n --> T99999 ==> abs(n) = n
    (R_Rev(n)) --> T99999 ==> R_Rev(R_Rev(n))
    ALGEBRA ==> false; Discharge ==> not R_is_nonneg(n)
    n --> T99999 ==> R_is_nonneg(R_Rev(n))
    n --> T99999 ==> abs(n) = R_Rev(n)
    (R_Rev(n)) --> T99999 ==> false; Discharge ==> QED

Theorem: (N in Re & M in Re & R_is_nonneg(R_Rev(M))) imp (N R_GT N R_PLUS M or N = N R_PLUS M). Proof:
    Suppose_not(n,m) ==> n in Re & m in Re & R_is_nonneg(R_Rev(m)) & (not (n R_GT n R_PLUS m)) & n /= n R_PLUS m
    Use_Def(R_GT) ==> R_Rev(n) R_GT R_0 or R_Rev(m) = R_0
    n --> T99999 ==> R_0 R_GT R_Rev(R_Rev(m)) or R_Rev(m) = R_0
    ALGEBRA ==> R_0 R_GT m or m = R_0
    (n,R_0,n,m) --> T99999 ==> n R_PLUS R_0 R_GT n R_PLUS m or n R_PLUS R_0 = n R_PLUS m
    ALGEBRA ==> false; Discharge ==> QED

Theorem: (N in Re & M in Re & R_is_nonneg(N) & (not R_is_nonneg(M))) imp 
    (N R_GT abs(N R_PLUS M) or N = abs(N R_PLUS M) or R_Rev(M) R_GT abs(N R_PLUS M) or R_Rev(M) = abs(N R_PLUS M)) . Proof: 
		Suppose_not(n,m) ==> n in Re & m in Re & R_is_nonneg(n) & (not (R_is_nonneg(m))) & 
      (not(n R_GT abs(n R_PLUS m) or n = abs(n R_PLUS m) or R_Rev(m) R_GT abs(n R_PLUS m) or R_Rev(m) = abs(n R_PLUS m)))
    m --> T99999 ==> R_is_nonneg(R_Rev(m))
    (n,m) --> T99999 ==> n R_GT n R_PLUS m or n = n R_PLUS m
    n --> T99999 ==> not R_is_nonneg(R_Rev(n)) or n = R_0
    (R_Rev(n),R_Rev(m)) --> T99999 ==> R_Rev(m) R_GT R_Rev(m) R_PLUS R_Rev(n) or R_Rev(m) = R_Rev(m) R_PLUS R_Rev(n)
    Suppose ==> R_is_nonneg(n R_PLUS m)
    (n R_PLUS m) --> T99999 ==> abs(n R_PLUS m) = n R_PLUS m
    ELEM ==> false; Discharge ==> not R_is_nonneg(n R_PLUS m)
    (n,m) --> T99999 ==> abs(n R_PLUS m) = R_Rev(n R_PLUS m)
    ALGEBRA ==> abs(n R_PLUS m) = R_Rev(m) R_PLUS R_Rev(n)
    ALGEBRA ==> false; Discharge ==> QED

Theorem: (N in Re & M in Re) imp (N R_PLUS abs(M) R_GT n or n R_PLUS abs(M) = n). Proof:
    Suppose_not(n,m) ==> n in Re & m in Re & (not(n R_PLUS abs(m) R_GT n or n R_PLUS abs(m) = n))
    m --> T99999 ==> R_is_nonneg(abs(m))
    Use_Def(R_GT) ==> abs(m) R_GT R_0 or abs(m) = R_0
    (n,n,abs(m),R_0) --> T99999 ==> n R_PLUS abs(m) R_GT n R_PLUS R_0 or n R_PLUS abs(m) = n R_PLUS R_0
    ALGEBRA ==> false; Discharge ==> QED

Theorem: (N in Re & M in Re) imp (abs(N) R_PLUS abs(M) R_GT abs(N R_PLUS M) or abs(N) R_PLUS abs(M) = abs(N R_PLUS M)). Proof: 
		Suppose_not(n,m) ==> n in Re & m in Re & 
        (not(abs(n) R_PLUS abs(m) R_GT abs(n R_PLUS m) or abs(n) R_PLUS abs(m) = abs(n R_PLUS m)))
    n --> T99999 ==> abs(n) = if R_is_nonneg(n) then n else R_Rev(n) end if
    m --> T99999 ==> abs(m) = if R_is_nonneg(m) then n else R_Rev(m) end if
    (n R_PLUS m) --> T99999 ==> abs(n R_PLUS m) = if R_is_nonneg(n R_PLUS m) then (n R_PLUS m) else R_Rev(n R_PLUS m) end if
    Suppose ==> R_is_nonneg(n) & R_is_nonneg(m)
    (n,m) --> T99999 ==> R_is_nonneg(n R_PLUS m)
    ELEM ==> false; Discharge ==> not(R_is_nonneg(n) & R_is_nonneg(m))
    Suppose ==> not R_is_nonneg(n) & (not R_is_nonneg(m))
    n --> T99999 ==> R_is_nonneg(R_Rev(n))
    m --> T99999 ==> R_is_nonneg(R_Rev(m))
    (R_Rev(n),R_Rev(m)) --> T99999 ==> R_is_nonneg(R_Rev(n) R_PLUS R_Rev(m))
    ALGEBRA ==> R_is_nonneg(R_Rev(n R_PLUS m))
    (R_Rev(n R_PLUS m)) --> T99999 ==> abs(R_Rev(n R_PLUS m)) = R_Rev(n R_PLUS m)
    (n R_PLUS m) --> T99999 ==> abs(n R_PLUS m) = R_Rev(n R_PLUS m)
    ALGEBRA ==> abs(n R_PLUS m) = R_Rev(n) R_PLUS R_Rev(m)
    n --> T99999 ==> abs(n) = R_Rev(n)
    m --> T99999 ==> abs(m) = R_Rev(m)
    ELEM ==> false; Discharge ==> R_is_nonneg(n) or R_is_nonneg(m)
    (abs(n),m) --> T99999 ==> abs(n) R_PLUS abs(m) R_GT abs(n) or abs(n) R_PLUS abs(m) = abs(n)
    (abs(m),n) --> T99999 ==> abs(m) R_PLUS abs(n) R_GT abs(m) or abs(m) R_PLUS abs(n) = abs(n)
    ALGEBRA ==> abs(n) R_PLUS abs(m) R_GT abs(m) or abs(n) R_PLUS abs(m) = abs(m)
    Suppose ==> Stat1: R_is_nonneg(n) & (not R_is_nonneg(m))
    n --> T99999 ==> abs(n) = n
    m --> T99999 ==> abs(m) = R_Rev(m)
    (n,m) --> T99999 ==> 
      n R_GT abs(n R_PLUS m) or n = abs(n R_PLUS m) or R_Rev(m) R_GT abs(n R_PLUS m) or R_Rev(m) = abs(n R_PLUS m)
    ELEM ==> 
    abs(n) R_GT abs(n R_PLUS m) or abs(n) = abs(n R_PLUS m) or abs(m) R_GT abs(n R_PLUS m) or abs(m) = abs(n R_PLUS m)
    (abs(n) R_PLUS abs(m),abs(n)) --> T99999 ==> 
      abs(n) R_PLUS abs(m) R_GT abs(n R_PLUS m) or abs(n) R_PLUS abs(m) = abs(n R_PLUS m) or 
        abs(m) R_GT abs(n R_PLUS m) or abs(m) = abs(n R_PLUS m)
    (abs(n) R_PLUS abs(m),abs(n)) --> T99999 ==> 
      abs(n) R_PLUS abs(m) R_GT abs(n R_PLUS m) or abs(n) R_PLUS abs(m) = abs(n R_PLUS m) or 
        abs(n) R_PLUS abs(m) R_GT abs(n R_PLUS m) or abs(n) R_PLUS abs(m) = abs(n R_PLUS m)
    ELEM ==> Stat2: false; Discharge ==> not R_is_nonneg(n) & R_is_nonneg(m)
    LIKEWISE(Stat1-Stat2,n->m,m->n) ==> false; Discharge ==> QED
        
Theorem: (N in Re & M in Re) imp (abs(N) R_PLUS abs(M) R_GT abs(N R_MINUS M) or abs(N) R_PLUS abs(M) = abs(N R_MINUS M)).   Proof: 
		Suppose_not(n,m) ==> n in Re & m in Re & 
      (not(abs(n) R_PLUS abs(m) R_GT abs(n R_MINUS m) or abs(n) R_PLUS abs(m) = abs(n R_MINUS m)))
    Use_Def(R_MINUS) ==> 
      not(abs(n) R_PLUS abs(m) R_GT abs(n R_MINUS R_Rev(m)) or abs(n) R_PLUS abs(m) = abs(n R_MINUS R_Rev(m)))
    m --> T99999 ==> 
      not(abs(n) R_PLUS abs(R_Rev(m)) R_GT abs(n R_MINUS R_Rev(m)) or abs(n) R_PLUS abs(m) = abs(n R_MINUS R_Rev(m)))
    (n,R_Rev(m)) --> T99999 ==> false; Discharge ==> QED
    
Theorem: (N in Re & M in Re) imp (abs(N) R_TIMES abs(M) = abs(N R_TIMES M)). Proof:
    Suppose_not(n,m) ==> n in Re & m in Re & abs(n) R_TIMES abs(m) /= abs(n R_TIMES m)
    n --> T99999 ==> abs(n) = if R_is_nonneg(n) then n else R_Rev(n) end if
    m --> T99999 ==> abs(m) = if R_is_nonneg(m) then n else R_Rev(m) end if
    Suppose ==> R_is_nonneg(n) & R_is_nonneg(m)
    ELEM ==> abs(n) R_TIMES abs(m) = n R_TIMES m 
    (n,m) --> T99999 ==> R_is_nonneg(n R_TIMES m)
    (n R_TIMES m) --> T99999 ==> false; Discharge ==> not(R_is_nonneg(n) & R_is_nonneg(m))
    Suppose ==> not R_is_nonneg(n) & (not R_is_nonneg(m))
    ELEM ==> abs(n) R_TIMES abs(m) = R_Rev(n) R_TIMES R_Rev(m) 
    n --> T99999 ==> R_is_nonneg(R_Rev(n))
    m --> T99999 ==> R_is_nonneg(R_Rev(m))
    (R_Rev(n),R_Rev(m)) --> T99999 ==> R_is_nonneg(R_Rev(n) R_TIMES R_Rev(m))
    ALGEBRA ==> R_is_nonneg(n R_TIMES m) & abs(n) R_TIMES abs(m) = n R_TIMES m
    (n R_TIMES m) --> T99999 ==> false; Discharge ==> not(not R_is_nonneg(n) & (not R_is_nonneg(m)))
    Suppose ==> not R_is_nonneg(n) & R_is_nonneg(m)
    ELEM ==> abs(n) R_TIMES abs(m) = R_Rev(n) R_TIMES m 
    n --> T99999 ==> R_is_nonneg(R_Rev(n))
    (n,m) --> T99999 ==> R_is_nonneg(R_Rev(n) R_TIMES m)
    ALGEBRA ==> R_is_nonneg(R_Rev(n R_TIMES m)) & abs(n) R_TIMES abs(m) = R_Rev(n R_TIMES m)
    (R_Rev(n R_TIMES m)) --> T99999 ==> false; Discharge ==> R_is_nonneg(n) & (not R_is_nonneg(m))
    ELEM ==> abs(n) R_TIMES abs(m) = n R_TIMES R_Rev(m) 
    m --> T99999 ==> R_is_nonneg(R_Rev(m))
    (n,m) --> T99999 ==> R_is_nonneg(n R_TIMES R_Rev(m))
    ALGEBRA ==> R_is_nonneg(n R_TIMES R_Rev(m)) & abs(n) R_TIMES abs(m) = n R_TIMES R_Rev(m)
    (n R_TIMES R_Rev(m)) --> T99999 ==> false; Discharge ==> QED
    
Theorem: (N in Re & M in Re & M /= R_0) imp (abs(N) R_OVER abs(M) = abs(N R_OVER M)). Proof:
    Suppose_not(n,m) ==> n in Re & m in Re & TO_BE_CONTINUED
     TO_BE_CONTINUED ==> QED

Theorem: (N in Re & M in Re) imp (N R_TIMES_ABS M in Re). Proof:
    Suppose_not(n,m) ==> n in Re & m in Re & n R_TIMES_ABS m notin Re
    Use_Def(R_TIMES_ABS) ==> 
      {u Ra_TIMES v: u in abs(X) and v in abs(Y) | not(Ra_0 Ra_GT u or Ra_0 Ra_GT v)} + R_0

Theorem: (N in Re & M in Re) imp (N R_TIMES M in Re). 

Theorem: (K in Re & n in Re & m in Re) imp (n R_PLUS (m R_PLUS K) = (n R_PLUS m) R_PLUS K). Proof:
    Suppose_not(k,n,m) ==> k in Re & n in Re & m in Re & (n R_PLUS (m R_PLUS k) = (n R_PLUS m) R_PLUS k)
    THUS ==> k incin Ra & n incin Ra & m incin Ra
    Use_Def(R_PLUS) ==> {u Ra_PLUS v: u in n, v in {u Ra_PLUS v: u in m, v in k}} /= 
                        {u Ra_PLUS v: u in {u Ra_PLUS v: u in n, v in m}, v in k}
    SIMPLF ==> {u Ra_PLUS (v Ra_PLUS w): u in n, v in m, w in k} /= {(u Ra_PLUS v) Ra_PLUS w: u in n, v in m, w in k}
    Suppose ==> not(FORALL u in m | (FORALL v in n | (FORALL w in k | u Ra_PLUS (v Ra_PLUS w) = (u Ra_PLUS v) Ra_PLUS w)))
    Pred_monot ==> Stat1: not(FORALL u in Ra | (FORALL v in Ra | (FORALL w in Ra | u Ra_PLUS (v Ra_PLUS w) = (u Ra_PLUS v) Ra_PLUS w)))
    (u,v,w) --> Stat1 ==> u in Ra & v in Ra & w in Ra & u Ra_PLUS (v Ra_PLUS w) /= (u Ra_PLUS v) Ra_PLUS w
    ALGEBRA ==> false; Discharge ==> (FORALL u in m | (FORALL v in n | (FORALL w in k | u Ra_PLUS (v Ra_PLUS w) = (u Ra_PLUS v) Ra_PLUS w)))
    EQUAL ==> false; Discharge ==> QED

Theorem: (N in Re) imp (R_Rev(R_Rev(N)) = N). Proof:
    Suppose_not(n) ==> n in Re & R_Rev(R_Rev(n)) /= n
    n --> T99999 ==> R_Rev(n) in Re
    n --> T99999 ==> R_Rev(n) R_PLUS n = R_0
    (R_Rev(n)) --> T99999 ==> R_Rev(R_Rev(n)) R_PLUS R_Rev(n) = R_0
    ELEM ==> (R_Rev(R_Rev(n)) R_PLUS R_Rev(n)) R_PLUS n = R_0 R_PLUS n
    (R_Rev(R_Rev(n)),R_Rev(n),n) --> T99999 ==> 
        (R_Rev(R_Rev(n)) R_PLUS R_Rev(n)) R_PLUS n = R_Rev(R_Rev(n)) R_PLUS (R_Rev(n) R_PLUS n)
    ELEM ==> R_0 R_PLUS n = R_Rev(R_Rev(n)) R_PLUS R_0
    (R_Rev(R_Rev(n))) --> T99999 ==> R_0 R_PLUS n = R_Rev(R_Rev(n))
    (R_0,n) --> T99999 ==> n R_PLUS R_0 = R_Rev(R_Rev(n))
    n --> T99999 ==> false; Discharge ==> QED

Theorem: (K in Re & n in Re & m in Re) imp (n R_TIMES (m R_TIMES K) = (n R_TIMES m) R_TIMES K). Proof:
    Suppose_not(k,n,m) ==> k in Re & n in Re & m in Re & TO_BE_CONTINUED
 
Theorem: (K in Re & n in Re & m in Re) imp (n R_TIMES (m R_PLUS K) = (n R_TIMES m) R_PLUS (n R_TIMES K)). Proof:
    Suppose_not(k,n,m) ==> k in Re & n in Re & m in Re & TO_BE_CONTINUED
 
Theorem: X in Re & Y in Re & R_is_nonneg(x) & R_is_nonneg(y) 
          imp (R_is_nonneg(x R_PLUS y) & R_is_nonneg(x R_TIMES y)). Proof:
    Suppose_not(n,m) ==> n in Re & m in Re & R_is_nonneg(n) & R_is_nonneg(m) & 
          (not(R_is_nonneg(m R_PLUS n) & R_is_nonneg(m R_TIMES n)))

Theorem: (M in Re) imp (M = M R_TIMES R_1). Proof: 
 
Theorem: (M in Re & M /= R_0) imp (Recip(M) in Re & M R_TIMES Recip(M) = R_1). 
 
Theorem: (N in Re & M in Re & M /= R_0) imp (N = M R_TIMES (N R_OVER M)). 


Theorem: 
 (X in Re) imp ((R_is_nonneg(X) or R_is_nonneg(R_Rev(X))) & ((R_is_nonneg(X) & R_is_nonneg(R_Rev(X))) imp (X = R_0))). 

Theorem: (X in Re) imp (X = X R_TIMES R_1). 

Theorem: (X in Re & Y in Re & R_is_nonneg(X) & R_is_nonneg(Y) & X R_PLUS Y = R_0) imp (X = R_0 & Y = R_0) . Proof: 
    Suppose_not(m,n) ==> m in Re & n in Re & R_is_nonneg(m) & R_is_nonneg(n) & 
                        m R_PLUS n = R_0 & (not (m = R_0 & n = R_0))
    ALGEBRA ==> m = R_Rev(n) & n = R_Rev(m)
    n --> T99999 ==> n = R_0
    m --> T99999 ==> false; Discharge ==> QED

Theorem: (X in Re & Y in Re & X1 in Re & X R_GT Y & X1 R_GT R_0) imp (X R_TIMES X1 R_GT Y R_TIMES X1). Proof: 
    Suppose_not(m,n,k) ==> 
      m in Re & n in Re & k in Re & m R_GT n & k R_GT R_0 & (not(m R_TIMES k R_GT n R_TIMES k))
    ALGEBRA ==> (m R_TIMES k) R_MINUS (n R_TIMES k) = (m R_MINUS n) R_TIMES k
    Use_Def(R_GT) ==> R_is_nonneg(m R_MINUS n) & m /= n & 
              (not R_is_nonneg((m R_MINUS n) R_TIMES k) or m R_TIMES k /= n R_TIMES k)
    (m R_MINUS n,k) --> T99999 ==> m R_TIMES k /= n R_TIMES k
    ALGEBRA ==> m R_MINUS n = 0 & (m R_MINUS n) R_TIMES k = 0
    (m R_MINUS n,k) --> T99999 ==> false; Discharge ==> QED
    
Theorem: (X in Re & X R_GT R_0) imp (Recip(X) R_GT R_0). Proof:
    Suppose_not(m) ==> m in Re & m R_GT R_0 & (not Recip(m) R_GT R_0)
    (Recip(m)) --> T99999 ==> R_Rev(Recip(m)) R_GT R_0 or R_Rev(Recip(m)) = R_0
    Suppose ==> R_Rev(Recip(m)) = R_0
    ELEM ==> R_Rev(Recip(m)) R_TIMES R_Rev(m) = R_0 R_TIMES R_Rev(m)
    ALGEBRA ==> R_1 = R_0
    ELEM ==> false; Discharge ==> R_Rev(Recip(m)) R_GT R_0
    (R_Rev(Recip(m)),m) --> T99999 ==> R_Rev(Recip(m)) R_TIMES m R_GT R_0
    ALGEBRA ==> R_Rev(R_1) R_GT R_0
    T99999 ==> R_1 R_GT R_0
    (R_Rev(R_1),R_0,R_1,R_0) --> T99999 ==> R_Rev(R_1) R_PLUS R_1 R_GT R_0 R_PLUS R_0
    ALGEBRA ==> R_0 R_GT R_0
    Use_Def(R_GT) ==> false; Discharge ==> QED 

Theorem: (X in Re & Y in Re & X R_GT Y) imp 
      (X R_GT (X R_PLUS Y) R_OVER (R_1 + R_1) & (X R_PLUS Y) R_OVER (R_1 + R_1) R_GT Y). Proof:
    Suppose_not(m,n) ==> m in Re & n in Re & m R_GT n & 
        (not (m R_GT (m R_PLUS n) R_OVER (R_1 + R_1) & (m R_PLUS n) R_OVER (R_1 + R_1) R_GT n))
    (m,n,n,n) --> T99999 ==> m R_PLUS n R_GT n R_PLUS n
    (m,n,m,m) --> T99999 ==> m R_PLUS m R_GT n R_PLUS m
    ALGEBRA ==> m R_PLUS n R_GT n R_TIMES (R_1 R_PLUS R_1)
    ALGEBRA ==> m R_TIMES (R_1 R_PLUS R_1) R_GT m R_PLUS n 
    ALGEBRA ==> R_1 in Ra & R_0 in Ra & R_1 + R_1 in Ra 
    (R_1,R_0,R_1,R_0) --> ==> R_1 R_PLUS R_1 R_GT R_0 R_PLUS R_0
    ALGEBRA ==> R_1 R_PLUS R_1 R_GT R_0
    (R_1 R_PLUS R_1) --> T99999 ==> Recip(R_1 R_PLUS R_1) R_GT R_0
    (m R_PLUS n,n R_TIMES (R_1 R_PLUS R_1),Recip(R_1 R_PLUS R_1)) --> T99999 ==> 
      (m R_PLUS n) R_TIMES Recip(R_1 R_PLUS R_1) R_GT 
              (n R_TIMES (R_1 R_PLUS R_1)) R_TIMES Recip(R_1 R_PLUS R_1)
    ALGEBRA ==> (m R_PLUS n) R_TIMES Recip(R_1 R_PLUS R_1) R_GT n
    (m R_TIMES (R_1 R_PLUS R_1),m R_PLUS n,Recip(R_1 R_PLUS R_1)) --> T99999 ==> 
      (n R_TIMES (R_1 R_PLUS R_1)) R_TIMES Recip(R_1 R_PLUS R_1) R_GT 
              m R_PLUS n R_TIMES Recip(R_1 R_PLUS R_1)
    ALGEBRA ==> n R_GT m R_PLUS n R_TIMES Recip(R_1 R_PLUS R_1)
    Use_Def(R_OVER) ==> false; Discharge ==> QED 

Theorem: [Least Upper Bound] (S /= 0 & S incin Re) imp (Un(S) in Re or Un(S) = Ra). Proof:
    Suppose_not(n,m) ==> s /= 0 & s incin Re & (not(Un(s) in Re) & Un(s) /= Ra)
    Use_Def(Un) ==> Un(s) = {y: x in s, y in x}
    Memb(r) ==> r in s & r in Re
    Use_Def(Re) ==> Stat1: r in {s: s incin Ra | s /= 0 & s /= Ra & 
      (FORALL x in s | (EXISTS y in s | (y Ra_GT x))) & (FORALL x in s | (FORALL y in Ra | ((x Ra_GT y) imp (y in s))))}
    a --> Stat1 ==> r incin Ra & r /= 0 & r /= Ra & (FORALL x in r | (EXISTS y in r | (y Ra_GT x))) &
                      (FORALL x in r | (FORALL y in Ra | ((x Ra_GT y) imp (y in r))))
    Memb(q) ==> q in r
    Suppose ==> Stat2: {y: x in s, y in x} = 0
    (r,q) --> Stat2 ==> false; Discharge ==> Un(s) /= 0
    Suppose ==> not {y: x in s, y in x} incin Ra
    Memb(c) ==> Stat3: c in {y: x in s, y in x} & c notin Ra
    (a1,b1) --> Stat3 ==> c in s & y in c
    ELEM ==> Stat4: c in r in {s: s incin Ra | s /= 0 & s /= Ra & 
      (FORALL x in s | (EXISTS y in s | y Ra_GT x)) & (FORALL x in s | (FORALL y in Ra | ((x Ra_GT y) imp (y in s))))}
    a2 --> Stat4 ==> c incin Ra & y in Ra
    ELEM ==> false; Discharge ==> Un(s) incin Ra
    ELEM ==> Stat5: Un(s) notin {s: s incin Ra | s /= 0 & s /= Ra & 
      (FORALL x in s | (EXISTS y in s | y Ra_GT x)) & (FORALL x in s | (FORALL y in Ra | ((x Ra_GT y) imp (y in s))))}
    ({y: x in s, y in x}) --> Stat5 ==>
        not (FORALL x in {y: x in s, y in x} | (EXISTS y in {y: x in s, y in x} | y Ra_GT x)) or
        not (FORALL x in {y: x in s, y in x} | (FORALL y in Ra | ((x Ra_GT y) imp (y in {y: x in s, y in x}))))
    SIMPLF ==> not (FORALL x in s | (FORALL u in x | (EXISTS v in s | (EXISTS w in v | w Ra_GT u)))) or
        not (FORALL x in s | (FORALL y in x | (FORALL u in Ra | ((y Ra_GT u) imp (u in {y: x in s, y in x})))))
    Suppose ==> Stat6: not (FORALL x in s | (FORALL y in x | (FORALL u in Ra | ((y Ra_GT u) imp (u in {y: x in s, y in x})))))
    (a3,b3,c3) --> Stat6 ==> a3 in s & b3 in a3 & c3 in Ra & b3 Ra_GT c3 & Stat7: c3 notin {y: x in s, y in x}
    (a3,c3) --> Stat7 ==> c3 notin a3
    ELEM ==> a3 in Re
    Use_Def(Re) ==> Stat8: a3 in {s: s incin Ra | s /= 0 & s /= Ra & 
      (FORALL x in s | (EXISTS y in s | y Ra_GT x)) & (FORALL x in s | (FORALL y in Ra | ((x Ra_GT y) imp (y in s))))}
    aa --> Stat8 ==> (FORALL x in a3 | (FORALL y in Ra | ((x Ra_GT y) imp (y in a3))))
    (a3,c3) --> Stat8 ==> false; Discharge ==> Stat9: not (FORALL x in s | (FORALL u in x | (EXISTS v in s | (EXISTS w in v | w Ra_GT u))))
    (a4,c4,a4) --> Stat9 ==> a4 in s & c4 in a4 & Stat10: (not(EXISTS w in a4 | w Ra_GT c4))
    ELEM ==> a4 in Re
    Use_Def(Re) ==> Stat11: a4 in {s: s incin Ra | s /= 0 & s /= Ra & 
      (FORALL x in s | (EXISTS y in s | y Ra_GT x)) & (FORALL x in s | (FORALL y in Ra | ((x Ra_GT y) imp (y in s))))}
    ab --> Stat8 ==> Stat12: (FORALL x in a4 | (EXISTS y in a4 | y Ra_GT x))
    ab --> Stat12 ==> false; Discharge ==> QED
    
Theorem: (X in Re & R_is_nonneg(X)) imp (sqrt(X) in Re & R_is_nonneg(sqrt(X)) & sqrt(X) R_TIMES sqrt(X) = X). Proof:
    Suppose_not(n) ==> n in Re & R_is_nonneg(n) & (not(sqrt(n) in Re & R_is_nonneg(sqrt(n)) & sqrt(n) R_TIMES sqrt(n) = n))
    Use_Def(sqrt) ==> sqrt(n) = Un({y: y in Re | (y R_TIMES y) incin x})
    Suppose ==> Stat1: R_0 notin {y: y in Re | (y R_TIMES y) incin n}
    R_0 --> Stat1 ==> R_0 notin Re or (not R_0 R_TIMES R_0 incin n)
    ALGEBRA ==> not R_0 incin n
    Use_Def(R_is_nonneg) ==> false; Discharge ==> R_0 in {y: y in Re | (y R_TIMES y) incin n}
    ELEM ==> {y: y in Re | (y R_TIMES y) incin n} /= 0
    Use_Def(Un) ==> Un({y: y in Re | (y R_TIMES y) incin n}) = {u: v in {y: y in Re | (y R_TIMES y) incin n}, u in v}
    SIMPLF ==> sqrt(n) = {u: y in Re, u in y | (y R_TIMES y) incin n}
    T99999 ==> R_is_nonneg(R_1)
    ALGEBRA ==> R_1 /= R_0
    Use_Def(R_GT) ==> R_1 R_GT R_0
    (n,R_1) --> T99999 ==> n R_PLUS R_1 R_GT R_0
    (n,R_1) --> T99999 ==> n R_PLUS R_1 R_GT n
    Suppose ==> Stat2: n R_PLUS R_1 incin {u: y in Re, u in y | y R_TIMES y incin n}
    (a,b) --> Stat2 ==> n R_PLUS R_1 incin a & a R_TIMES a incin n
    (n R_PLUS R_1,a) --> T99999 ==> a R_GE n R_PLUS R_1
    (a R_TIMES a,n) --> T99999 ==> n R_GE a R_TIMES a
    (n R_PLUS R_1,a,n R_PLUS R_1,a) --> T99999 ==> n R_GE (n R_PLUS R_1) R_TIMES (n R_PLUS R_1)
    ALGEBRA ==> n R_GE n R_PLUS ((n R_PLUS (n R_TIMES n)) R_PLUS R_1)
    n --> T99999 ==> n R_GE R_0
    (n,n) --> T99999 ==> n R_TIMES n R_GE R_0 R_TIMES R_0
    ALGEBRA ==> n R_TIMES n R_GE R_0
    (n,n R_TIMES n) --> T99999 ==> (n R_PLUS (n R_TIMES n)) R_GE (R_0 R_PLUS R_0)
    ALGEBRA ==> (n R_PLUS (n R_TIMES n)) R_GE R_0
    ((n R_PLUS (n R_TIMES n)),R_1) --> T99999 ==> 
      (n R_PLUS (n R_TIMES n)) R_PLUS R_1 R_GE R_0 R_PLUS R_1 
    ALGEBRA ==> (n R_PLUS (n R_TIMES n)) R_PLUS R_1 R_GE R_1
    (n,(n R_PLUS (n R_TIMES n)) R_PLUS R_1) --> T99999 ==> n R_PLUS ((n R_PLUS (n R_TIMES n)) R_PLUS R_1) R_GE n R_PLUS R_1
    (n,n R_PLUS ((n R_PLUS (n R_TIMES n)) R_PLUS R_1),n R_PLUS R_1) --> T99999 ==> n R_GE n R_PLUS R_1
    (n,n R_PLUS R_1) --> T99999 ==> false; Discharge ==> Un({y: y in Re | (y R_TIMES y) incin x}) /= Re
    {y: y in Re | (y R_TIMES y) incin n} --> T99999 ==> sqrt(n) in Re
    Suppose ==> not R_is_nonneg(sqrt(n))
    Use_Def(R_is_nonneg) ==> not R_0 incin sqrt(n)
    Memb(c) ==> c in R_0 & Stat3: c notin {u: v in {y: y in Re | (y R_TIMES y) incin n}, u in v}
    (R_0,c) --> Stat3 ==> not(R_0 in {y: y in Re | (y R_TIMES y) incin n} & c in R_0)
    ELEM ==> sqrt(n) R_TIMES sqrt(n) /= n
    Suppose ==> not sqrt(n) R_TIMES sqrt(n) incin n
    

Theorem: (X in Re & Y in Re & Y R_TIMES Y = X & R_is_nonneg(Y)) imp (Y = sqrt(X)). Proof: 
    Suppose_not(n,m) ==> n in Re & m in Re & m R_TIMES m = n & R_is_nonneg(m) & m /= sqrt(n)
    n --> T99999 ==> sqrt(n) in Re & sqrt(n) R_TIMES sqrt(n) = m R_TIMES m & R_is_nonneg(sqrt(n))
    ALGEBRA ==> (sqrt(n) R_MINUS m) R_TIMES (sqrt(n) R_PLUS m) = R_0
    (sqrt(n) R_MINUS m,sqrt(n) R_PLUS m) --> T99999 ==> sqrt(n) R_MINUS m = R_0 or sqrt(n) R_PLUS m = R_0
    Suppose ==> sqrt(n) R_MINUS m = R_0
    ALGEBRA ==> false; Discharge ==> sqrt(n) R_PLUS m = R_0
    ALGEBRA ==> sqrt(n) = R_Rev(m)
    m --> T99999 ==> m = R_0
    ALGEBRA ==> R_Rev(sqrt(n)) = m
    (sqrt(n)) --> T99999 ==> false; Discharge ==> QED

Theorem: (X in Re & R_is_nonneg(X) & Y in Re & R_is_nonneg(Y)) imp (sqrt(X R_TIMES Y) = sqrt(X) R_TIMES sqrt(Y)). Proof:
    Suppose_not(n) ==> n in Re & R_is_nonneg(n) & m in Re & R_is_nonneg(m) & sqrt(n R_TIMES m) /= sqrt(n) R_TIMES sqrt(m)
    ALGEBRA ==> n R_TIMES m in Re
    (n,m) --> T99999 ==> R_is_nonneg(n R_TIMES m)
    n --> T99999 ==> sqrt(n) in Re & sqrt(n) R_TIMES sqrt(n) = n & R_is_nonneg(sqrt(n))
    m --> T99999 ==> sqrt(m) in Re & sqrt(m) R_TIMES sqrt(m) = m & R_is_nonneg(sqrt(m))
    ELEM ==> (sqrt(n) R_TIMES sqrt(n)) R_TIMES (sqrt(m) R_TIMES sqrt(m)) = n R_TIMES m
    (n,m) --> T99999 ==> R_is_nonneg(sqrt(m) R_TIMES sqrt(m))
    (n R_TIMES m,sqrt(m) R_TIMES sqrt(m)) --> T99999 ==> false; Discharge ==> QED

Def 58: [Complex Numbers] Cm := Re PROD Re
Def 59: [Complex Sum] Def(X C_PLUS Y) := [car(X) R_PLUS car(Y),cdr(X) R_PLUS cdr(Y)] 
Def 60: [Complex Product] 
    Def(X C_TIMES Y) := [(car(X) R_TIMES car(Y)) R_MINUS (cdr(X) R_TIMES cdr(Y)),
              (car(X) R_TIMES cdr(Y)) R_PLUS (cdr(X) R_TIMES car(Y))] 
Def 61: [Complex Norm] C_abs(X) := sqrt((car(X) R_TIMES car(X)) R_PLUS (cdr(X) R_TIMES cdr(X))) 
Def 62: [Complex reciprocal] 
    C_Recip(x) := [car(x) R_OVER (C_abs(x) R_TIMES C_abs(x)),R_Rev(cdr(x) R_OVER (C_abs(x) R_TIMES C_abs(x)))]

Def 63: [Complex Quotient] Def(X C_OVER Y) := X C_TIMES C_Recip(Y)
Def 63a: C_Rev(X) := [R_Rev(car(X)),R_Rev(cdr(X))]
Def 63b: Def(N C_MINUS M) := N C_PLUS C_Rev(M)
Def 63x: C_0 := [R_0,R_0]
Def 63y: C_1 := [R_1,R_0]

Theorem: ((X in Re & Y in Re) imp ([X,Y] in Cm)) & ((m in Cm) imp (m = [car(m),cdr(m)] & car(m) in Re & cdr(m) in Re)). Proof:
    Suppose_not(x,y) ==> (x in Re & y in Re & [x,y] notin Cm) or 
          (m in Cm & (not(m = [car(m),cdr(m)] & car(m) in Re & cdr(m) in Re)))
    Use_Def(Cm) ==> [x,y] notin Re PROD Re & m in Re PROD Re
    Use_Def(PROD) ==> [x,y] notin {[x,y]: x in Re, y in Re} & Stat2: m in {[x,y]: x in Re, y in Re}
    Suppose ==> Stat1: [x,y] notin {[x,y]: x in Re, y in Re}
    (x,y) --> Stat1 ==> false; Discharge ==> Stat2: m in {[x,y]: x in Re, y in Re}
    (a,b) --> Stat2 ==> m = [a,b] & a in Re & b in Re
    ELEM ==> false; Discharge ==> QED

Theorem: (N in Cm & M in Cm) imp (N C_PLUS M in Cm). Proof:
    Suppose_not(n,m) ==> n in Cm & m in Cm & n C_PLUS m notin Cm
    THUS ==> car(n) in Re & cdr(n) in Re & car(m) in Re & cdr(m) in Re
    Use_Def(C_PLUS) ==> [car(n) R_PLUS car(m),cdr(n) R_PLUS cdr(m)] notin Cm
    ALGEBRA ==> car(n) R_PLUS car(m) in Re & cdr(n) R_PLUS cdr(m) in Re
    (car(n) R_PLUS car(m),cdr(n) R_PLUS cdr(m)) --> T99999 ==> false; Discharge ==> QED

Theorem: (N in Cm & M in Cm) imp (N C_PLUS M = M C_PLUS N). Proof:
    Suppose_not(n,m) ==> n in Cm & m in Cm & n C_PLUS m = m C_PLUS n
    THUS ==> car(n) in Re & cdr(n) in Re & car(m) in Re & cdr(m) in Re
    Use_Def(C_PLUS) ==> [car(n) R_PLUS car(m),cdr(n) R_PLUS cdr(m)] /= [car(m) R_PLUS car(n),cdr(m) R_PLUS cdr(n)]
    ALGEBRA ==> false; Discharge ==> QED
    
Theorem: (N in Cm) imp (N = N C_PLUS C_0). Proof:
    Suppose_not(n) ==> n in Cm & n /= n C_PLUS C_0
    THUS ==> car(n) in Re & cdr(n) in Re & n = [car(n),cdr(n)] 
    Use_Def(C_PLUS) ==> n /= [car(n) R_PLUS car(C_0),cdr(n) R_PLUS cdr(C_0)]
    Use_Def(C_0) ==> n /= [car(n) R_PLUS R_0,cdr(n) R_PLUS R_0]
    ALGEBRA ==> false; Discharge ==> QED

Theorem: (N in Cm) imp (C_Rev(N) in Cm & C_Rev(C_Rev(N)) = N). Proof:
    Suppose_not(n) ==> n in Cm & (C_Rev(N) notin Cm or C_Rev(C_Rev(n)) /= n)
    THUS ==> car(n) in Re & cdr(n) in Re & n = [car(n),cdr(n)] 
    Use_Def(C_Rev) ==> C_Rev(n) = [R_Rev(car(n)),R_Rev(cdr(n))]
    ALGEBRA ==> R_Rev(car(n)) in Re & R_Rev(cdr(n)) in Re
    (R_Rev(car(n)),R_Rev(cdr(n))) --> T99999 ==> C_Rev(n) in Cm 
    Use_Def(C_Rev) ==> C_Rev(C_Rev(n)) = [R_Rev(R_Rev(car(n))),R_Rev(R_Rev(cdr(n)))]
    ALGEBRA ==> R_Rev(R_Rev(car(n))) = car(n) & R_Rev(R_Rev(cdr(n))) = cdr(n)
    ELEM ==> false; Discharge ==> QED

Theorem: (N in Cm) imp (N C_PLUS C_Rev(N) = C_0). Proof:
    Suppose_not(n) ==> n in Cm & n C_PLUS C_Rev(n) /= C_0
    THUS ==> car(n) in Re & cdr(n) in Re & n = [car(n),cdr(n)] 
    Use_Def(C_PLUS) ==> C_0 /= [car(n) R_PLUS car(C_Rev(n)),cdr(n) R_PLUS cdr(C_Rev(n))]
    Use_Def(C_Rev) ==> C_Rev(n) = [R_Rev(car(n)),R_Rev(cdr(n))]
    ELEM ==> C_0 /= [car(n) R_PLUS R_Rev(car(n)),cdr(n) R_PLUS R_Rev(cdr(n))]
    ALGEBRA ==> C_0 /= [R_0,R_0]
    Use_Def(C_0) ==> false; Discharge ==> QED

Theorem: (N in Cm & M in Cm) imp (N = M C_PLUS (N C_MINUS M)). Proof:
    Suppose_not(n,m) ==> n in Cm & m in Cm & n /= m C_PLUS (n C_MINUS m)
    Use_Def(C_MINUS) ==> n /= m C_PLUS (n C_PLUS C_Rev(m))
    ALGEBRA ==> n /= n C_PLUS (m C_PLUS C_Rev(m)) 
    ALGEBRA ==> false; Discharge ==> QED

Theorem: (N in Cm & M in Cm) imp (N C_TIMES M = M C_TIMES N). Proof:
    Suppose_not(n,m) ==> n in Cm & m in Cm & n C_TIMES m = m C_TIMES n
    THUS ==> car(n) in Re & cdr(n) in Re & n = [car(n),cdr(n)] & car(m) in Re & cdr(m) in Re & m = [car(m),cdr(m)] 
    Use_Def(C_TIMES) ==> 
    [(car(n) R_TIMES car(m)) R_MINUS (cdr(n) R_TIMES cdr(m)),(car(n) R_TIMES cdr(m)) R_PLUS (car(m) R_TIMES cdr(n))] /= 
    [(car(m) R_TIMES car(n)) R_MINUS (cdr(m) R_TIMES cdr(n)),(car(m) R_TIMES cdr(n)) R_PLUS (car(n) R_TIMES cdr(m))]
    ALGEBRA ==> false; Discharge ==> QED

Theorem: (N in Cm) imp (C_abs(N) in Re & R_is_nonneg(C_abs(N))). Proof:
    Suppose_not(n) ==> n in Cm & (C_abs(N) notin Re or not R_is_nonneg(C_abs(n)))
    THUS ==> car(n) in Re & cdr(n) in Re & n = [car(n),cdr(n)] & car(m) in Re & cdr(m) in Re & m = [car(m),cdr(m)] 
    (car(n)) --> T99999 ==> R_is_nonneg(car(n) R_TIMES car(n)) 
    (cdr(n)) --> T99999 ==> R_is_nonneg(cdr(n) R_TIMES cdr(n)) 
    (car(n) R_TIMES car(n),cdr(n) R_TIMES cdr(n)) --> T99999 ==> R_is_nonneg((car(n) R_TIMES car(n)) R_PLUS (cdr(n) R_TIMES cdr(n)))
    Use_Def(C_abs) ==> C_abs(n) = sqrt(R_is_nonneg((car(n) R_TIMES car(n)) R_PLUS (cdr(n) R_TIMES cdr(n))))
    ((car(n) R_TIMES car(n)) R_PLUS (cdr(n) R_TIMES cdr(n))) --> T99999 ==> C_abs(n) in Re & R_is_nonneg(C_abs(n))
    ELEM ==> false; Discharge ==> QED
      
Theorem: (N in Cm) imp (C_abs(N) = C_abs(C_Rev(N))). Proof:
    Suppose_not(n) ==> n in Cm & C_abs(n) = C_abs(C_Rev(n))
    THUS ==> car(n) in Re & cdr(n) in Re & n = [car(n),cdr(n)] & car(m) in Re & cdr(m) in Re & m = [car(m),cdr(m)] 
    Use_Def(C_Rev) ==> C_Rev(n) = [R_Rev(car(n)),R_Rev(car(n))]
    Use_Def(C_abs) ==> C_abs(n) = sqrt((car(n) R_TIMES car(n)) R_PLUS (cdr(n) R_TIMES cdr(n))) &
        C_abs(C_Rev(n)) = sqrt((car(C_Rev(n)) R_TIMES car(C_Rev(n))) R_PLUS (cdr(C_Rev(n)) R_TIMES cdr(C_Rev(n)))) 
    ELEM ==> false; Discharge ==> QED
    
Theorem: (N in Cm & M in Cm) imp 
      ((C_abs(N) C_PLUS C_abs(M)) R_GT C_abs(N C_PLUS M) or (C_abs(N) C_PLUS C_abs(M) = C_abs(N C_PLUS M))). Proof:
    Suppose_not(n,m) ==> n in Cm & n in Cm & 
        (not(C_abs(n) C_PLUS C_abs(m) R_GT abs(n C_PLUS m) or C_abs(n) C_PLUS C_abs(m) = C_abs(n C_PLUS m)))
    THUS ==> car(n) in Re & cdr(n) in Re & n = [car(n),cdr(n)] & car(m) in Re & cdr(m) in Re & m = [car(m),cdr(m)] 
 
Theorem: (N in Cm & M in Cm) imp 
    ((C_abs(N) C_PLUS C_abs(M)) R_GT C_abs(N C_PLUS M) or C_abs(N) C_PLUS C_abs(M) = C_abs(N C_MINUS M)). Proof:
    Suppose_not(n,m) ==> n in Cm & n in Cm &
      (not((C_abs(n) C_PLUS C_abs(m)) R_GT C_abs(n C_PLUS m) or C_abs(n) C_PLUS C_abs(m) = C_abs(n C_MINUS m)))
    THUS ==> car(n) in Re & cdr(n) in Re & n = [car(n),cdr(n)] & car(m) in Re & cdr(m) in Re & m = [car(m),cdr(m)] 
 
Theorem: (N in Cm & M in Cm) imp (C_abs(N) C_TIMES C_abs(M) = C_abs(N C_TIMES M)). Proof:
    Suppose_not(n,m) ==> n in Cm & n in Cm & C_abs(n) C_TIMES C_abs(m) /= C_abs(n C_TIMES m)
    THUS ==> car(n) in Re & cdr(n) in Re & n = [car(n),cdr(n)] & car(m) in Re & cdr(m) in Re & m = [car(m),cdr(m)] 
    Use_Def(C_abs) ==> C_abs(n) = sqrt((car(n) R_TIMES car(n)) R_PLUS (cdr(n) R_TIMES cdr(n))) &
                C_abs(m) = sqrt((car(m) R_TIMES car(m)) R_PLUS (cdr(m) R_TIMES cdr(m))) &
C_abs(n C_TIMES m) = sqrt((car(n C_TIMES m) R_TIMES car(n C_TIMES m)) R_PLUS (cdr(n C_TIMES m) R_TIMES cdr(n C_TIMES m)))
    ((car(n) R_TIMES car(n)) R_PLUS (cdr(n) R_TIMES cdr(n))) --> T99999 ==> 
      (C_abs(n) R_TIMES C_abs(n) = car(n) R_TIMES car(n)) R_PLUS (cdr(n) R_TIMES cdr(n))
    ((car(m) R_TIMES car(m)) R_PLUS (cdr(m) R_TIMES cdr(m))) --> T99999 ==> 
      C_abs(m) R_TIMES C_abs(m) = (car(m) R_TIMES car(m)) R_PLUS (cdr(m) R_TIMES cdr(m))
    ((car(n C_TIMES m) R_TIMES car(n C_TIMES m)) R_PLUS (cdr(n C_TIMES m) R_TIMES cdr(n C_TIMES m))) --> T99999 ==> 
      C_abs(n C_TIMES m) R_TIMES C_abs(n C_TIMES m) = 
        (car(n C_TIMES m) R_TIMES car(n C_TIMES m)) R_PLUS (cdr(n C_TIMES m) R_TIMES cdr(n C_TIMES m))
    Use_Def(C_TIMES) ==> n C_TIMES m = [(car(n) R_TIMES car(m)) R_MINUS (cdr(n) R_TIMES cdr(m)),
                        (car(n) R_TIMES cdr(m)) R_PLUS (cdr(n) R_TIMES car(m))]
    ELEM ==> C_abs(n C_TIMES m) R_TIMES C_abs(n C_TIMES m) = 
        (((car(n) R_TIMES car(m)) R_MINUS (cdr(n) R_TIMES cdr(m))) R_TIMES 
          ((car(n) R_TIMES car(m)) R_MINUS (cdr(n) R_TIMES cdr(m)))) R_PLUS 
          (((car(n) R_TIMES cdr(m)) R_PLUS (cdr(n) R_TIMES car(m))) R_TIMES 
            ((car(n) R_TIMES cdr(m)) R_PLUS (cdr(n) R_TIMES car(m))))
    ELEM ==> (C_abs(n) R_TIMES C_abs(n)) R_TIMES (C_abs(m) R_TIMES C_abs(m)) = 
          ((car(n) R_TIMES car(n)) R_PLUS (cdr(n) R_TIMES cdr(n))) R_TIMES 
            ((car(m) R_TIMES car(m)) R_PLUS (cdr(m) R_TIMES cdr(m)))
    ALGEBRA ==> (C_abs(n) R_TIMES C_abs(m)) R_TIMES (C_abs(n) R_TIMES C_abs(m)) = 
                  C_abs(n C_TIMES m) R_TIMES C_abs(n C_TIMES m)
    ELEM ==> sqrt((C_abs(n) R_TIMES C_abs(m)) R_TIMES (C_abs(n) R_TIMES C_abs(m))) = 
            sqrt(C_abs(n C_TIMES m) R_TIMES C_abs(n C_TIMES m))
    ALGEBRA ==> n C_TIMES m in Cm

Theorem: (N in Cm & M in Cm & M /= C_0) imp (C_abs(N) R_OVER C_abs(M) = C_abs(N C_OVER M)). Proof:
    Suppose_not(n,m) ==> n in Cm & m in Cm & m /= C_0 & C_abs(n) R_OVER C_abs(m) = C_abs(n C_OVER m)
    THUS ==> car(n) in Re & cdr(n) in Re & n = [car(n),cdr(n)] & car(m) in Re & cdr(m) in Re & m = [car(m),cdr(m)] 

Theorem: (N in Cm & M in Cm) imp (N C_TIMES M in Cm). Proof:
    Suppose_not(n,m) ==> n in Cm & m in Cm & n C_TIMES m notin Cm
    Use_Def(C_TIMES) ==> [(car(n) R_TIMES car(m)) R_MINUS (cdr(n) R_TIMES cdr(m)),
                  (car(n) R_TIMES cdr(m)) R_PLUS (car(m) R_TIMES cdr(n))] notin Cm
    ALGEBRA ==> ((car(n) R_TIMES car(m)) R_MINUS (cdr(n) R_TIMES cdr(m))) in Re & 
            ((car(n) R_TIMES cdr(m)) R_PLUS (car(m) R_TIMES cdr(n))) in Re
 ((car(n) R_TIMES car(m)) R_MINUS (cdr(n) R_TIMES cdr(m)),(car(n) R_TIMES cdr(m)) R_PLUS (car(m) R_TIMES cdr(n))) --> T99999 ==> false
     Discharge ==> QED
    
Theorem: (K in Cm & n in Cm & m in Cm) imp (n C_PLUS (m C_PLUS K) = (n C_PLUS m) C_PLUS K). Proof:
    Suppose_not(k,n,m) ==> n in Cm & n in Cm & k in Cm & n C_PLUS (m C_PLUS k) /= (n C_PLUS m) C_PLUS k
    THUS ==> car(n) in Re & cdr(n) in Re & car(m) in Re & cdr(m) in Re & car(k) in Re & cdr(k) in Re 
    Use_Def(C_PLUS) ==> [car(n) R_PLUS (car(m) R_PLUS car(k)),cdr(n) R_PLUS (cdr(m) R_PLUS cdr(k))] /= 
                [(car(n) R_PLUS car(m)) R_PLUS car(k),(cdr(n) R_PLUS cdr(m)) R_PLUS cdr(k)]
    ALGEBRA ==> false; Discharge ==> QED

Theorem: (K in Cm & n in Cm & m in Cm) imp (n C_TIMES (m C_TIMES K) = (n C_TIMES m) C_TIMES K). Proof:
    Suppose_not(k,n,m) ==> n in Cm & n in Cm & k in Cm & n C_TIMES (m C_TIMES k) /= (n C_TIMES m) C_TIMES k
    Loc_def ==> an := car(n)
    Loc_def ==> dn := cdr(n)
    Loc_def ==> am := car(m)
    Loc_def ==> dm := cdr(m)
    Loc_def ==> ak := car(k)
    Loc_def ==> dk := cdr(kn)
    Use_Def(C_TIMES) ==> [(an R_TIMES ((am R_TIMES ak) R_MINUS (dm R_TIMES dk))) 
                   R_MINUS (dn R_TIMES ((am R_TIMES dk) R_PLUS (ak R_TIMES dm))),
                  (an R_TIMES ((am R_TIMES dk) R_PLUS (ak R_TIMES dm))) 
                     R_PLUS (((am R_TIMES ak) R_MINUS (dm R_TIMES dk)) R_TIMES dn)] /= 
              [(((an R_TIMES am) R_MINUS (dn R_TIMES dm)) R_TIMES ak) 
                 R_MINUS (((an R_TIMES dm) R_PLUS (am R_TIMES dn)) R_TIMES dk),
                  (((an R_TIMES am) R_MINUS (dn R_TIMES dm)) R_TIMES dk)
                     R_PLUS (ak R_TIMES ((an R_TIMES dm) R_PLUS (am R_TIMES dn)))]
    ALGEBRA ==> false; Discharge ==> QED
    
Theorem: (K in Cm & n in Cm & m in Cm) imp (n C_TIMES (m C_PLUS K) = (n C_TIMES m) C_PLUS (n C_TIMES K)). Proof:
    Suppose_not(k,n,m) ==> n in Cm & n in Cm & k in Cm & n C_TIMES (m C_PLUS k) /= (n C_TIMES m) C_PLUS (n C_TIMES k)
    
    
Theorem: (M in Cm) imp (M = M C_TIMES C_1) . Proof:
    Suppose_not(m) ==> m in Cm & m /= m C_TIMES C_1
    THUS ==> car(m) in Re & cdr(m) in Re & m = [car(m),cdr(m)]
    Use_Def(C_TIMES) ==> m /= [(car(n) R_TIMES car(C_1)) R_MINUS (cdr(n) R_TIMES cdr(C_1)),
                  (car(n) R_TIMES cdr(C_1)) R_PLUS (car(C_1) R_TIMES cdr(n))]
    Use_Def(C_1) ==> m /= 
        [(car(n) R_TIMES R_1) R_MINUS (cdr(n) R_TIMES R_0),(car(n) R_TIMES R_0) R_PLUS (R_1 R_TIMES cdr(n))]
    ALGEBRA ==> false; Discharge ==> QED
    
Theorem: (M in Cm & M /= C_0) imp (C_Recip(M) in Cm & M C_TIMES C_Recip(M) = C_1). Proof:
    Suppose_not(m) ==> m in Cm & m /= C_0 & (not(C_Recip(m) in Cm & m C_TIMES C_Recip(m) = C_1))
    THUS ==> car(m) in Re & cdr(m) in Re & m = [car(m),cdr(m)]
    Use_Def(C_0) ==> m /= [R_0,R_0]
    ELEM ==> not(car(m) = R_0 & cdr(m) = R_0) 
    Use_Def(C_abs) ==> C_abs(m) = sqrt((car(m) R_TIMES car(m)) R_PLUS (cdr(m) R_TIMES cdr(m)))
    Loc_def ==> nrm := (car(m) R_TIMES car(m)) R_PLUS (cdr(m) R_TIMES cdr(m))
    (car(m)) --> T99999 ==> R_is_nonneg(car(m) R_TIMES car(m))
    (car(m),car(m)) --> T99999 ==> (car(m) /= R0) imp ((car(m) R_TIMES car(m)) /= R0)
    (cdr(m)) --> T99999 ==> R_is_nonneg(cdr(m) R_TIMES cdr(m))
    (cdr(m),cdr(m)) --> T99999 ==> (cdr(m) /= R0) imp ((cdr(m) R_TIMES cdr(m)) /= R0)
    ELEM ==> not(car(m) R_TIMES car(m) = R_0 & cdr(m) R_TIMES cdr(m) = R_0) 
    (car(m) R_TIMES car(m),cdr(m) R_TIMES cdr(m)) --> T99999 ==> R_is_nonneg(nrm)
    (car(m) R_TIMES car(m),cdr(m) R_TIMES cdr(m)) --> T99999 ==> nrm /= 0
    nrm --> T99999 ==> C_abs(m) R_TIMES C_abs(m) = nrm
    Use_Def(C_Recip) ==> C_Recip(m) = [car(m) R_OVER nrm,R_Rev(cdr(x) R_OVER nrm)]
    Use_Def(C_TIMES) ==> M C_TIMES C_Recip(M) = 
      [(car(m) R_TIMES (car(m) R_OVER nrm)) R_MINUS (cdr(m) R_TIMES (R_Rev(cdr(m)) R_OVER nrm)),
            (car(m) R_TIMES (R_Rev(cdr(m)) R_OVER nrm)) R_PLUS (cdr(m) R_TIMES (car(m) R_OVER nrm))]
    ALGEBRA ==> M C_TIMES C_Recip(M) = [((car(m) R_TIMES car(m)) R_PLUS ((cdr(m) R_TIMES cdr(m)))) R_OVER nrm,R_0]
    ELEM ==> M C_TIMES C_Recip(M) = [nrm R_OVER nrm,R_0]
    Use_Def(R_OVER) ==> M C_TIMES C_Recip(M) = [nrm R_TIMES R_Recip(nrm),R_0]
    nrm --> T99999 ==> false; Discharge ==> QED
    
Theorem: (N in Cm & M in Cm & M /= C_0) imp (N = M C_TIMES (N C_OVER M)). Proof:
    Suppose_not(m) ==> n in Cm & m in Cm & m /= C_0 & n /= m C_TIMES (n C_OVER m)
    Use_Def(C_OVER) ==> n /= m C_TIMES (n C_TIMES C_Recip(m))
    ALGEBRA ==> false; Discharge ==> QED

Theorem: C_0 in Cm & C_1 in Cm. Proof:
    Use_Def(C_0) ==> C_0 = [R_0,R_0]
    Use_Def(C_1) ==> C_1 = [R_1,R_0]
    ALGEBRA ==> R_1 in Re & R_0 in Re
    (R_0,R_0) --> T99999 ==> C_0 in Cm
    (R_1,R_0) --> T99999 ==> QED

-- [Sums for Real Maps with finite domains]
APPLY(Sig) sigma_theory(s->Re,PLUZ->R_PLUS,e->R_0) ((Svm(f) & range(f) incin Re & Finite(f)) imp
      (Sig(f) in Re & (p in f) imp (Sig({p}) = f(cdr(p))) & 
        (FORALL a | (Sig(f) = (Sig(f ON (domain(f) * a)) R_PLUS Sig(f ON domain(f) - a))))))

Def 65: [Sums of absolutely convergent infinite series]
     Sig_inf(f) := Un({Sig(f ON s): s incin Domain(f) | Finite(s)})

Def 59: [Real functions of a real variable] 
    RF := {f incin (R PROD R) | Svm(f) & domain(f) = R} 

Def 66: [Sum of Real Functions] Def(f F_PLUS g) := {[x,f~[x] R_PLUS g~[x]]: x in R}
Def 67: [Product of Real Functions] Def(f F_TIMES g) := {[x,f~[x] R_TIMES g~[x]]: x in R}
Def 68: [LUB of a set of Real Functions] LUB(s) := {[x,Un({f~[x]: f in s})]: x in R}
Def 69: [Constant zero function] RF_0 := {[x,R_0]: x in R}

Theorem: (N in RF & m in RF) imp (N F_PLUS m = m F_PLUS N)
Theorem: (N in RF & m in RF) imp (N F_PLUS m = m F_PLUS N)
Theorem: (N in RF & m in RF) imp (N F_TIMES m = m F_TIMES N)
Theorem: (K in RF & n in RF & m in RF) imp (n F_PLUS (m F_PLUS K) = (n F_PLUS m) F_PLUS K)
Theorem: (K in RF & n in RF & m in RF) imp (n F_TIMES (m F_TIMES K) = (n F_TIMES m) F_TIMES K)
Theorem: (K in RF & n in RF & m in RF) imp (n F_TIMES (m F_PLUS K) = (n F_TIMES m) F_PLUS (n F_TIMES K))

-- [Sums for series of real functions] 

APPLY(FSig) sigma_theory(RF,F_PLUS,RF_0) ==> (Svm(ser) & range(ser) incin RF & Finite(ser) imp
      (FSig(ser) in RF & (p in ser) imp (Sig({p}) = ser(cdr(p)))) & 
(FORALL a | Sig(ser) = Sig(ser ON (domain(ser) * a)) R_PLUS Sig(ser ON domain(ser) - a)))

Def 71: [Sums of absolutely convergent infinite series of real functions] 
     FSig_inf(ser) := LUB({Sig(ser ON s): s incin domain(ser) | Finite(s)})

-- [Product of a nonempty family of sets; Note - this is also the real greatest lower bound]
Def 72: GLB(s) := {x in arb(s) | (FORALL y in s | x in y)}

Def 73: [Block function]  
    Bl_f(a,b,c) := {[x,if a incin x and x incin b then c else R_0 end if]: x in Re} 

Def 74: [Block function integral]  
      BFInt(f) := arb({c R_TIMES (b R_MINUS a): a in Re, b in Re, c in Re | Bl_f(a,b,c) = f})

Def 75: [Block functions] RBF := {Bl_f(a,b,c): a in Re, b in Re, c in Re} 

Def 76: [Comparison of real functions] Def(f RF_GT g) := f /= g & (FORALL x in Re | f~[x] incs g~[x]) 

Def 77: [Lebesgue Upper Integral of a Positive Function] 
    ULeInt(f) := 
      GLB({{[n,BFInt(ser~[n])]}: ser incin Z PROD RBF | Svm(ser) & (FSig_inf(ser) RF_GT f)})

Def 78: [Positive Part of real function]  
      Pos_part(f) := {[x, if f~[x] incs R_0 then f~[x] else R_0 end if]: x in Re}

Def 79: [Reverse of a real function] RF_Rev(f) := {[x, R_Rev(f~[x])]: x in Re}

Def 80: [Lebesgue Integral] Int(f) := ULeInt(Pos_part(f)) R_MINUS ULeInt(Pos_part(RF_Rev(f)))

Def 81: [Continuous function of a real variable] 
is_continuous_RF(f) := f incin (Re PROD Re) & Svm(f) & 
    (FORALL x in domain(f) | (FORALL ep in Re | (EXISTS delt in Re | (FORALL y in domain(f) | ((delt R_GT 0) & 
      (ep incs R_0 & ep /= R_0 & delt incs abs(x R_MINUS y)) imp (ep incs abs(f~[x] R_MINUS f~[y])))))))

Def 82: [Euclidean n-space] E(n) := {f incin (n PROD Re) | Svm(f) & domain(f) = n}

Def 83: [Euclidean norm] norm(f) := sqrt(FSig(f))

Def 84: [Difference of Real Functions] Def(f F_MINUS g) := {[x,f~[x] R_MINUS g~[x]]: x in domain(f)}

Def 85: [Continuous function on Euclidean n-space] 
is_continuous_REnF(f,n) := f incin (E(n) PROD E(n)) & Svm(f) &
    (FORALL x in domain(f) | (FORALL ep in Re | (EXISTS delt in Re | (FORALL y in domain(f) | 
      (delt incs R_0 & delt /= R_0 &
        (ep incs R_0 & ep /= R_0 & delt incs norm(x F_MINUS y)) imp (ep incs abs(f~[x] R_MINUS f~[y])))))))

Def 86: [Difference-and-diagonal trick]  
    DD(f,df) := {if x~[0] /= x~[1] then (f~[x~[0]] R_MINUS f~[x~[1]]) R_OVER (x~[0] R_MINUS x~[1]) 
                                  else df~[x~[0]] end if: x in E(2)}

Def 87: [Derivative of function of a real variable] 
    Der(f) := arb({df in RF | domain(f) = domain(df) & 
              is_continuous_REnF(DD(f,df) ON (domain(f) PROD domain(f)),2)})

Def 88: [Complex functions of a complex variable]  
      CF := {f incin (Cm PROD Cm) | Svm(f) & domain(f) = Cm}

Def 91: [Complex Euclidean n-space] CE(n) := {f incin (n PROD Cm) | Svm(f) & domain(f) = n}

Def 89: [Difference-and-diagonal trick, complex case]  
    CDD(f,df) := {if x~[0] /= x~[1] then (f~[x~[0]] C_MINUS f~[x~[1]]) C_OVER (x~[0] C_MINUS x~[1]) 
                                  else df~[x~[0]] end if: x in CE(2)}

Def 90: [Continuous function of a complex variable] 
is_continuous_CF(f) := f incin (Cm PROD Cm) & Svm(f) & 
    (FORALL x in domain(f) | (FORALL ep in Re | (EXISTS delt in Re | (FORALL y in domain(f) | 
      (delt incs R_0 & delt /= R_0 & 
      (ep incs R_0 & ep /= R_0 & delt incs norm(x C_MINUS y)) imp (ep incs norm(f~[x] C_MINUS f~[y])))))))

Def 92: [Complex Euclidean norm]  
    Cnorm(f) := sqrt(FSig({[m,C_abs(f~[m]) R_TIMES C_abs(f~[m])]: m in domain(f)}))

Def 93: [Difference of Complex Functions] Def(f CF_MINUS g) := {[x,f~[x] C_MINUS g~[x]]: x in Cm}

Def 94: [Continuous function on Complex Euclidean n-space] 
is_continuous_CEnF(f,n) := f incin (CE(n) PROD CE(n)) & Svm(f) &
 (FORALL x in domain(f) | (FORALL ep in Re | (EXISTS delt in Re | (FORALL y in domain(f) | 
    (delt incs R_0 & delt /= R_0 & 
     (ep incs R_0 & ep /= R_0 & delt incs Cnorm(x CF_MINUS y)) imp (ep incs Cnorm(f~[x] CF_MINUS f~[y])))))))

Def 95: [Derivative of function of a complex variable]  
    CDer(f) := arb({df in CF | domain(f) = domain(df) & 
              is_continuous_CEnF(CDD(f,df) ON (domain(f) PROD domain(f)),2)})

Def 97: [Open set in the complex plane]  
    is_open_C_set(s) := s incin Cm & 
              is_continuous_CF({[z,if z in s then [R_0,R_0] else [R_1,R_0] end if]: z in Cm})

Def 98: [Analytic function of a complex variable]  
    is_analytic_CF(f) := is_continuous_CF(f) & is_open_C_set(domain(f)) & CDer(f) /= 0

Def 99: [Complex exponential function]  
    C_exp_fcn := arb({f incin Cm PROD Cm: is_analytic_CF(f) & CDer(f) = f & f~[[R_0,R_0]] = [R_1,R_0]})
    
Def 100: [The constant pi]  
    pi := arb({x in Re | x incs R_0 & x /= R_0 & C_exp_fcn([R_0,x]) = [R_1,R_0] & 
                (FORALL y in Re | ((C_exp_fcn([R_0,y]) = [R_1,R_0]) imp (y = x or R_0 incs y)))})

Def 101: [Continuous complex function on the reals] 
is_continuous_CoRF(f) := f incin (Re PROD Cm) & Svm(f) & 
    (FORALL x in domain(f) | (FORALL ep in Re | (EXISTS delt in Re | (FORALL y in domain(f) | ((delt R_GT 0) & 
      (ep incs R_0 & ep /= R_0 & delt incs abs(x R_MINUS y)) imp (ep incs norm(f~[x] C_MINUS f~[y])))))))

Def 102: [Difference-and-diagonal trick, real-to-complex case]  
    CRDD(f,df) := {if x~[0] /= x~[1] then (f~[x~[0]] C_MINUS f~[x~[1]]) C_OVER (x~[0] C_MINUS x~[1]) 
                                  else df~[x~[0]] end if: x in E(2)}

Def 103: [Continuous complex function on E(n)]  
is_continuous_CREnF(f,n) := f incin (E(n) PROD Cm) & Svm(f) &
 (FORALL x in domain(f) | (FORALL ep in Re | (EXISTS delt in Re | (FORALL y in domain(f) | ((delt R_GT 0) & 
    (ep incs R_0 & ep /= R_0 & delt incs norm(x F_MINUS y)) imp (ep incs C_abs(f~[x] CF_MINUS f~[y])))))))

Def 104: [Derivative of complex function of a real variable]  
    CRDer(f) := arb({df in CF | domain(f) = domain(df) & 
              is_continuous_CREnF(CRDD(f,df) ON (domain(f) PROD domain(f)),2)})
      
Def 105: [Real Interval] Interval(a,b) := {x in Re | a incin x & x incin b}
      
Def 106: [Continuously differentiable curve in the complex plane]   
 is_CD_curv(f,a,b) := 
    is_continuous_CoRF(f) & domain(f) = Interval(a,b) & 0 /= CRDer(f) & is_continuous_CoRF(CRDer(f))
    
Def 107: [Complex line integral] Line_Int(f,crv,a,b) := 
    [Int({[x,if x notin Interval(a,b) then R_0 else car(f~[curv~[x]] C_TIMES CRDer(crv)~[x]) end if]: 
                                              x in Re}),
    Int({[x,if x notin Interval(a,b) then R_0 else cdr(f~[curv~[x]] C_TIMES CRDer(crv)~[x]) end if]: 
                                              x in Re})]
Theorem: [Cauchy integral theorem]
    is_analytic_CF(f) imp (EXISTS ep in Re | (ep incs R_0 & ep /= R_0 & 
       (FORALL crv1| (FORALL crv2| ((is_CD_curv(crv1,R_0,R_1) & is_CD_curv(crv1,R_0,R_1) 
        & crv1~[R_0] = crv1~[R_1] & crv2~[R_0] = crv2~[R_1] & 
         (FORALL x in Interval(R_0,R_1) | (ep incs C_abs(crv1~[x] C_MINUS crv2~[x])))
          imp Line_Int(f,crv1,R_0,R_1) = Line_Int(f,crv2,R_0,R_1)))))))

Theorem: [Cauchy integral formula] 
    (is_analytic_CF(f) & domain(f) incs {z in Cm: C_abs(z) incin R_1}) imp
      ((FORALL z in Cm | (((C_abs(z) incin R_1) and (C_abs(z) /= R_1)) imp 
 f~[z] = Line_Int({[x,f~[x] C_OVER (x C_MINUS z)]: x in Cm -{z}},
            {[x,C_exp_fcn([R_0,x])]: x in Re},R_0,pi R_PLUS pi) 
                            C_OVER ([R_0,pi R_PLUS pi]))))
--END HERE ------------

Beyond this point, the number of steps of definition needed to reach any concept, say, of classical functional analysis can be estimated by counting the number of definitions needed to reach the corresponding point in any standard reference on this subject, e.g. Dunford-Schwartz.
    
