

#include "macros.h"

#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif

#include <assert.h>

#include "db_common.h"
#include "db_export.h"
#include "db_records.h"

#define CHILD_SIZE 4
#define CUM_SIZE 5

#define GET_CHILD(buffer,i) (buffer+bnr_ch_start+((i)-1)*4-1)
#define GET_CUM(buffer,i) (buffer+bnr_cum_start+((i)-1)*5-1)

#define GET_CHILDREN(buffer) (buffer+bnr_ch_start-1)
#define GET_CUMS(buffer) (buffer+bnr_cum_start-1)

#define GET_NEXT_CHILD(r) (r+4)
#define GET_NEXT_CUM(r) (r+5)

#define GET_PREV_CHILD(r) (r-4)
#define GET_PREV_CUM(r) (r-5)

#define NEXT_CHILD(r) (r=r+4)
#define NEXT_CUM(r) (r=r+5)

#define PREV_CHILD(r) (r=r-4)
#define PREV_CUM(r) (r=r-5)

#define VOC(t,k) (str_to_rec(GET_CHILD((t),(k))))
#define SET_VOC(t,k,rec) rec_to_str(GET_CHILD((t),(k)),(rec))

static void split_node (int32 rec, int k);
static void share_right (int32 rec, int n);
static int pull_from_right (int32 rec, int k);
static int pull_from_left (int32 rec, int k);
static int join_with_left (int32 rec, int k);
static int join_with_right (int32 rec, int k);
static unsigned char tmp_buffer[REC_SIZE];


int32
bnr_create ()
{
  int32 rec;

  rec = new_rec ();
  set_type (rec, bigstr_node_ncr);
  return rec;

}

static void
share_right (int32 rec, int k)
{
  int32 ndk, ndkp1, new_r;
  int nchk, nchkp1, numleft, nummov;
  unsigned char *stg;
  unsigned char *buffer;

  buffer = rec_load (rec);

  ndk = VOC (buffer, k);
  ndkp1 = VOC (buffer, k + 1);
  nchk = NUM_CH (rec_load (ndk));
  nchkp1 = NUM_CH (rec_load (ndkp1));
  numleft = (nchk + nchkp1) / 2;

  if (rec_refcount (ndkp1) > 1)
    {
      new_r = rec_abs_copy (ndkp1);
      rec_incref (ndkp1, -1);
      rec_increfs (new_r, 1);
      ndkp1 = new_r;
      buffer = rec_load (rec);
      SET_VOC (buffer, k + 1, new_r);
      rec_dirtify (rec);
    }
  if (rec_refcount (ndk) > 1)
    {
      new_r = rec_abs_copy (ndk);
      rec_incref (ndk, -1);
      rec_increfs (new_r, 1);
      ndk = new_r;
      buffer = rec_load (rec);
      SET_VOC (buffer, k, new_r);
      rec_dirtify (rec);
    }

  if (numleft > nchk)
    {
      unsigned char *r, *s, *p, *q, *p1, *s1;
      int j, nch;
      long right_cum, moved_cum, total_moved;
      long tt;

      nummov = numleft - nchk;

      bcopy (rec_load (ndkp1), tmp_buffer, REC_SIZE);
      r = tmp_buffer;

      p = GET_CUM (r, nummov);

      /*
       * Get the cumulant of the last child of the right node that we are
       * moving left 
       */

      moved_cum = str_to_cum (p);

      q = rec_load (ndk);
      right_cum = 0;
      s = GET_CUMS (q);
      s1 = GET_CHILDREN (q);
      if (nchk > 0)
	{
	  s = GET_CUM (q, nchk);
	  right_cum = str_to_cum (s);
	  NEXT_CUM (s);
	  s1 = GET_CHILD (q, nchk + 1);
	}

      nch = NUM_CH (q);
      p = GET_CUMS (r);
      p1 = GET_CHILDREN (r);
      for (j = 1; j <= nummov; j++)
	{
	  cum_to_str (s, (str_to_cum (p) + right_cum));
	  rec_to_str (s1, (str_to_rec (p1)));
	  NEXT_CUM (s);
	  NEXT_CUM (p);

	  NEXT_CHILD (s1);
	  NEXT_CHILD (p1);

	}

      /*
       * Now move the recs and cums of the right node 
       */

      s = GET_CUMS (r);
      s1 = GET_CHILDREN (r);

      for (j = 1; j <= (nchkp1 - nummov); j++)
	{
	  cum_to_str (s, (str_to_cum (p) - moved_cum));
	  rec_to_str (s1, (str_to_rec (p1)));

	  NEXT_CUM (s);
	  NEXT_CUM (p);

	  NEXT_CHILD (s1);
	  NEXT_CHILD (p1);
	}

      SET_NUM_CH (q, (nch + nummov));
      rec_dirtify (ndk);

      rec_load (ndkp1);
      SET_NUM_CH (tmp_buffer, (nchkp1 - nummov));
      rec_setrecbuf (ndkp1, tmp_buffer, REC_SIZE);

      /*
       * update the cumulant for children k in rec 
       */

      buffer = rec_load (rec);
      p = GET_CUM (buffer, k);
      cum_to_str (p, (str_to_cum (p) + moved_cum));
      rec_dirtify (rec);

      return;
    }
  else
    {
      unsigned char *r, *s, *p, *q;
      int j, nch;
      long rem_left_cum, total_moved;
      long tt;

      nummov = nchk - numleft;

      bcopy (rec_load (ndk), tmp_buffer, REC_SIZE);
      r = tmp_buffer;

      p = GET_CUM (r, numleft);
      rem_left_cum = str_to_cum (p);

      q = GET_NEXT_CUM (p);
      for (j = numleft + 1; j <= nchk; j++)
	{
	  NEXT_CUM (p);
	  cum_to_str (p, (tt = (str_to_cum (p) - rem_left_cum)));

	}
      total_moved = str_to_cum (p);

      /*
       * Update ndk 
       */

      SET_NUM_CH (r, numleft);
      rec_setrecbuf (ndk, tmp_buffer, REC_SIZE);

      /*
       * Update rec 
       */

      buffer = rec_load (rec);
      p = GET_CUM (buffer, k);
      cum_to_str (p, (str_to_cum (p) - total_moved));
      rec_dirtify (rec);

      s = rec_load (ndkp1);

      /*
       * move the cums 
       */

      /*
       * p points to the last cum of the right child 
       */

      p = GET_CUM (s, nchkp1);

      /*
       * while we move the cums to make space for the left stuff, we can
       * update the values 
       */

      for (j = 1; j <= nchkp1; j++)
	{
	  cum_to_str (p + (CUM_SIZE * nummov), (str_to_cum (p) + total_moved));
	  PREV_CUM (p);
	}
      bcopy (q, GET_CUMS (s), nummov * CUM_SIZE);

      /*
       * Copy the children 
       */

      nch = NUM_CH (s);
      if (nch > 0)
	{
	  p = GET_CHILD (s, nch + 1) - 1;
	  /*
	   * * point to the last byte of the last ch * pointer  
	   */
	  r = p + CHILD_SIZE * nummov;
	  for (j = 1; j <= CHILD_SIZE * nch; j++)
	    {
	      *r-- = *p--;
	    }
	}

      p = GET_CHILDREN (s);
      r = GET_CHILD (tmp_buffer, numleft + 1);
      bcopy (r, p, nummov * CHILD_SIZE);
      SET_NUM_CH (s, nch + nummov);
      rec_dirtify (ndkp1);

    }

}

int32
bnr_comp_cum (int32 rec, long t, int flag, long *cum)
{
  unsigned char *buffer, *p;
  int j, n_ch;
  long l, the_cum, prev_cum, retcum;
  int32 recno;

  buffer = rec_load (rec);
  if (flag == 1)
    {
      j = NUM_CH (buffer);
      assert (j > 0);
      p = GET_CUM (buffer, j);
      the_cum = str_to_cum (p);
      prev_cum = 0;
      if (j > 1)
	prev_cum = str_to_cum (GET_PREV_CUM (p));
    }
  else
    {
      p = GET_CUMS (buffer);
      prev_cum = 0;
      n_ch = NUM_CH (buffer);
      j = 1;
      while ((j <= n_ch) && (t > (l = str_to_cum (p))))
	{
	  j++;
	  NEXT_CUM (p);
	  prev_cum = l;
	}
      if (j > n_ch)
	{
	  return EMPTY;
	}
      the_cum = l;
    }
  if (j == 1)
    prev_cum = 0;
  if (!is_compound (buffer))
    {
      *cum = the_cum;
      return str_to_rec (GET_CHILD (buffer, j));

    }
  else
    {
      recno = bnr_comp_cum (str_to_rec (GET_CHILD (buffer, j)),
			    (t - prev_cum), flag, &retcum);
      *cum = (retcum + prev_cum);
      return recno;
    }

}

static void
split_node (int32 rec, int k)
{
  unsigned char *buffer, *p;
  int nch, i, ic;
  int32 newrec;
  int32 first_ch;

  newrec = new_rec ();

  buffer = rec_load (rec);
  nch = NUM_CH (buffer);

  /*
   * Copy the previous cum 
   */

  p = GET_CUM (buffer, nch + 2) - 1;
  for (i = 1; i <= CUM_SIZE * (nch - k + 1); i++)
    {
      *p = *(GET_PREV_CUM (p));
      p--;
    }

  /*
   * Do the same for the child pointers 
   */

  p = GET_CHILD (buffer, nch + 2) - 1;
  for (i = 1; i <= CHILD_SIZE * (nch - k + 1); i++)
    {
      *p = *(GET_PREV_CHILD (p));
      p--;
    }
  p++;
  rec_to_str (p, newrec);

  p = GET_CHILDREN (buffer);
  first_ch = str_to_rec (p);

  SET_NUM_CH (buffer, nch + 1);
  rec_dirtify (rec);

  if (rec_is_compound (first_ch))
    set_type (newrec, bigstr_node_record);
  else
    set_type (newrec, bigstr_node_ncr);

  share_right (rec, k);

}

static int
pull_from_left (int32 rec, int k)
{
  unsigned char *buffer, *p;
  int32 newrec, child;
  if (k == 1)
    return FALSE;

  buffer = rec_load (rec);

  p = GET_CHILD (buffer, k - 1);
  child = str_to_rec (p);
  buffer = rec_load (child);

  if (NUM_CH (buffer) <= bnr_low_lim)
    return FALSE;

  share_right (rec, k - 1);
  return TRUE;
}

static int
pull_from_right (int32 rec, int k)
{
  unsigned char *buffer, *p;
  int32 newrec, child;

  buffer = rec_load (rec);

  if (k >= NUM_CH (buffer))
    return FALSE;

  p = GET_CHILD (buffer, k + 1);
  child = str_to_rec (p);
  buffer = rec_load (child);

  if (NUM_CH (buffer) <= bnr_low_lim)
    return FALSE;

  share_right (rec, k);
  return TRUE;
}

long
bnr_get_cum (int32 rec)
{
  unsigned char *buffer, *p;
  long the_cum;
  int nch;

  buffer = rec_load (rec);
  nch = NUM_CH (buffer);

  p = GET_CUM (buffer, nch);
  the_cum = str_to_cum (p);

  return the_cum;
}

static int
join_with_left (int32 rec, int k)
{
  unsigned char *buffer, *p, *q;
  int32 new_r, ndk, ndkm1;
  int nch, nchtocopy, i;
  long last_left_cum;

  if (k == 1)
    return FALSE;

  buffer = rec_load (rec);
  nch = NUM_CH (buffer);

  ndk = VOC (buffer, k);
  ndkm1 = VOC (buffer, k - 1);

  if (rec_refcount (ndkm1) > 1)
    {
      new_r = rec_abs_copy (ndkm1);
      rec_incref (ndkm1, -1);
      rec_increfs (new_r, 1);
      ndkm1 = new_r;
      buffer = rec_load (rec);
      SET_VOC (buffer, k - 1, new_r);
      rec_dirtify (rec);
    }

  p = GET_CUM (buffer, k - 1);
  /*
   * Points to cum k-1 
   */

  for (i = 1; i <= CUM_SIZE * (nch - k + 1); i++)
    {
      *p = *(GET_NEXT_CUM (p));
      p++;
    }

  SET_NUM_CH (buffer, nch - 1);
  rec_dirtify (rec);

  /*
   * Done with rec... 
   */

  bcopy (buffer = rec_load (ndk), tmp_buffer, REC_SIZE);
  nchtocopy = NUM_CH (buffer);
  SET_NUM_CH (buffer, 0);
  rec_dirtify (ndk);
  rec_incref (ndk, -1);

  buffer = rec_load (ndkm1);
  nch = NUM_CH (buffer);
  p = GET_CUM (buffer, nch);
  last_left_cum = str_to_cum (p);

  q = GET_CUMS (tmp_buffer);
  NEXT_CUM (p);
  for (i = 1; i <= nchtocopy; i++)
    {
      cum_to_str (p, (str_to_cum (q) + last_left_cum));
      NEXT_CUM (p);
      NEXT_CUM (q);
    }

  p = GET_CHILD (buffer, nch + 1);
  bcopy (GET_CHILDREN (tmp_buffer), p, nchtocopy * CHILD_SIZE);
  SET_NUM_CH (buffer, nch + nchtocopy);

  rec_dirtify (ndkm1);

  return TRUE;

}

static int
join_with_right (int32 rec, int k)
{
  unsigned char *buffer, *p, *q;
  int32 new_r, ndk, ndkp1;
  int nch, nchtocopy, i;
  long last_left_cum;

  buffer = rec_load (rec);

  if (k >= NUM_CH (buffer))
    return FALSE;

  buffer = rec_load (rec);
  nch = NUM_CH (buffer);

  ndk = VOC (buffer, k);
  ndkp1 = VOC (buffer, k + 1);

  if (rec_refcount (ndkp1) > 1)
    {
      new_r = rec_abs_copy (ndkp1);
      rec_incref (ndkp1, -1);
      rec_increfs (new_r, 1);
      ndkp1 = new_r;
      buffer = rec_load (rec);
      SET_VOC (buffer, k + 1, new_r);
      rec_dirtify (rec);
    }

  p = GET_CUM (buffer, k);
  /*
   * Points to cum k 
   */

  last_left_cum = str_to_cum (p);

  for (i = 1; i <= CUM_SIZE * (nch - k); i++)
    {
      *p = *(GET_NEXT_CUM (p));
      p++;
    }

  p = GET_CHILD (buffer, k);
  /*
   * Points to ch k 
   */

  for (i = 1; i <= CHILD_SIZE * (nch - k); i++)
    {
      *p = *(GET_NEXT_CHILD (p));
      p++;
    }

  SET_NUM_CH (buffer, nch - 1);
  rec_dirtify (rec);

  /*
   * Done with rec... 
   */

  bcopy (buffer = rec_load (ndk), tmp_buffer, REC_SIZE);
  nch = NUM_CH (buffer);
  SET_NUM_CH (buffer, 0);
  rec_dirtify (ndk);
  rec_incref (ndk, -1);

  buffer = rec_load (ndkp1);
  nchtocopy = NUM_CH (buffer);

  p = GET_CUMS (buffer);
  q = GET_CUM (tmp_buffer, nch + 1);

  for (i = 1; i <= nchtocopy; i++)
    {
      cum_to_str (q, (str_to_cum (p) + last_left_cum));
      NEXT_CUM (p);
      NEXT_CUM (q);
    }

  p = GET_CHILD (tmp_buffer, nch + 1);
  bcopy (GET_CHILDREN (buffer), p, nchtocopy * CHILD_SIZE);
  SET_NUM_CH (tmp_buffer, nch + nchtocopy);

  rec_setrecbuf (ndkp1, tmp_buffer, REC_SIZE);

  return TRUE;

}

static void
update_cums (int32 rec, int k, long cum)
{
  unsigned char *buffer, *p, *q, *r;
  int nch, ic, i;
  int32 ch;
  long tot_cum, child_cum;

  bcopy (rec_load (rec), tmp_buffer, REC_SIZE);
  nch = NUM_CH (tmp_buffer);
  ic = is_compound (tmp_buffer);
  tot_cum = 0;
  r = GET_CHILDREN (tmp_buffer);
  p = GET_CUMS (tmp_buffer);
  for (i = 1; i <= nch; i++)
    {
      buffer = rec_load (ch = str_to_rec (r));	/*
						 * load children i 
						 */
      if (ic)
	{
	  child_cum = str_to_cum (GET_CUM (buffer, NUM_CH (buffer)));
	}
      else
	{
	  child_cum = sr_length (ch);
	}
      tot_cum = tot_cum + child_cum;
      cum_to_str (p, tot_cum);
      NEXT_CUM (p);
      NEXT_CHILD (r);
    }

  buffer = rec_load (rec);
  rec_setrecbuf (rec, tmp_buffer, REC_SIZE);

}

int32
bnr_make_from_tuple (unsigned char *recs,
		     unsigned char *cums, int count)
{
  int32 rec;
  unsigned char *buffer, *p, *s, *q;
  long cum;
  int i, compound_now;
  int newcount;

  if (count <= bnr_hi_lim)
    {
      rec = new_rec ();
      buffer = rec_load (rec);
      set_type (rec, bigstr_node_ncr);
      bcopy (recs, GET_CHILDREN (buffer), count * CHILD_SIZE);

      /*
       * Now do the cums 
       */

      p = GET_CUMS (buffer);
      s = cums;
      cum = 0;
      for (i = 1; i <= count; i++)
	{
	  cum += str_to_cum (s);
	  cum_to_str (p, cum);
	  NEXT_CUM (s);
	  NEXT_CUM (p);
	}

      SET_NUM_CH (buffer, count);
      rec_dirtify (rec);
      return rec;

    }

  compound_now = FALSE;
  while (count > bnr_hi_lim)
    {
      int last;
      unsigned char *pcum;
      unsigned char *pch;

      p = recs;
      s = cums;
      pcum = cums;
      pch = recs;
      newcount = 0;
      last = FALSE;
      while (count > 0)
	{
	  int k;
	  int32 section;

	  if (((count - bnr_hi_lim) == 0) || (last) ||
	      ((count - bnr_hi_lim) >= bnr_low_lim))
	    {
	      if (last)
		k = count;
	      else
		k = bnr_hi_lim;
	    }
	  else
	    {
	      last = TRUE;
	      k = count / 2;
	    }
	  section = new_rec ();

	  if (compound_now)
	    set_type (section, bigstr_node_record);
	  else
	    set_type (section, bigstr_node_ncr);

	  buffer = rec_load (section);
	  bcopy (p, GET_CHILDREN (buffer), k * CHILD_SIZE);
	  p += k * CHILD_SIZE;

	  /*
	   * Now do the cums 
	   */

	  q = GET_CUMS (buffer);
	  cum = 0;
	  for (i = 1; i <= k; i++)
	    {
	      cum += str_to_cum (s);
	      cum_to_str (q, cum);
	      NEXT_CUM (s);
	      NEXT_CUM (q);
	    }

	  SET_NUM_CH (buffer, k);
	  rec_dirtify (section);

	  /*
	   * Now store record & cum for the next level 
	   */

	  cum_to_str (pcum, cum);
	  rec_to_str (pch, section);
	  NEXT_CUM (pcum);
	  NEXT_CHILD (pch);

	  newcount++;
	  count -= k;
	  if ((count<wo_hi_lim)&&(count>=wo_low_lim)) 
		last=TRUE;
	}
      count = newcount;
      compound_now = TRUE;

    }

  rec = new_rec ();
  buffer = rec_load (rec);
  set_type (rec, bigstr_node_record);
  bcopy (recs, GET_CHILDREN (buffer), count * CHILD_SIZE);

  /*
   * Now do the cums 
   */

  p = GET_CUMS (buffer);
  s = cums;
  cum = 0;
  for (i = 1; i <= count; i++)
    {
      cum += str_to_cum (s);
      cum_to_str (p, cum);
      NEXT_CUM (s);
      NEXT_CUM (p);
    }

  SET_NUM_CH (buffer, count);
  rec_dirtify (rec);
  return rec;

}

int32
bnr_set_comp (int32 rec, long t, int flag, int32 x)
{
  unsigned char *buffer, *p;
  int i, j, n_ch;
  long l, the_cum, prev_cum, old_cum;
  int ic;
  int32 the_ch, recno, new_r;

  if (rec_refcount (rec) > 1)
    {
      new_r = rec_abs_copy (rec);
      rec_increfs (new_r, 1);
      rec_incref (rec, -1);
      rec = new_r;
      rec_dirtify (rec);
    }

  buffer = rec_load (rec);
  ic = is_compound (buffer);
  if (flag == 1)
    {
      j = n_ch = NUM_CH (buffer);
      assert (j > 0);
      p = GET_CUM (buffer, j);
      the_cum = str_to_cum (p);
      t = the_cum;
      prev_cum = 0;
      if (j > 1)
	prev_cum = str_to_cum (GET_PREV_CUM (p));
    }
  else
    {
      p = GET_CUMS (buffer);
      prev_cum = 0;
      n_ch = NUM_CH (buffer);
      j = 1;
      while ((j <= n_ch) && (t > (l = str_to_cum (p))))
	{
	  j++;
	  NEXT_CUM (p);
	  prev_cum = l;
	}
      if (j > n_ch)
	{
#ifdef VERBOSE
	  printf ("Search index %ld out of range in rec %d \n", t, rec);
#endif
	  return EMPTY;

	}
      the_cum = l;
    }
  if (j == 1)
    prev_cum = 0;

  p = GET_CHILD (buffer, j);
  the_ch = str_to_rec (p);
  if (ic)
    old_cum = bnr_get_cum (the_ch);
  else
    old_cum = (long) sr_length (the_ch);

  buffer = rec_load (rec);
  p = GET_CHILD (buffer, j);

  /*
   * Deletion 
   */
  if (x == 0)
    {
      if (!(ic))
	{
	  rec_incref (the_ch, -1);
	  buffer = rec_load (rec);
	  for (i = 1; i <= CHILD_SIZE * (n_ch - j); i++)
	    {
	      *p = *(GET_NEXT_CHILD (p));
	      p++;
	    }
	  p = GET_CUM (buffer, j);
	  for (i = 1; i <= CUM_SIZE * (n_ch - j); i++)
	    {
	      *p = *(GET_NEXT_CUM (p));
	      p++;
	    }
	  SET_NUM_CH (buffer, n_ch - 1);
	  rec_dirtify (rec);
	  update_cums (rec, j, -prev_cum);

	}
      else
	{

	  long old_ch_leafsum;
	  long new_ch_leafsum;
	  int32 old_rec;

	  old_ch_leafsum = bnr_get_cum (the_ch);
	  the_ch = bnr_set_comp (the_ch, (t - prev_cum), 0, 0);
	  new_ch_leafsum = bnr_get_cum (the_ch);
	  buffer = rec_load (rec);
	  p = GET_CHILD (buffer, j);
	  rec_to_str (p, the_ch);
	  rec_dirtify (rec);
	  update_cums (rec, j, (new_ch_leafsum - old_ch_leafsum));

	  buffer = rec_load (the_ch);
	  if (NUM_CH (buffer) >= bnr_low_lim)
	    return rec;
	  if ((pull_from_left (rec, j)) || (pull_from_right (rec, j)))
	    return rec;
	  if ((!join_with_left (rec, j)) && (!join_with_right (rec, j)))
	    assert (FALSE);
	  buffer = rec_load (rec);

	  if (NUM_CH (buffer) > 1)
	    return rec;

	  old_rec = rec;
	  rec = VOC (buffer, 1);
	  rec_incref (rec, 1);
	  rec_incref (old_rec, -1);

	}
      return rec;
    }
  else
    {

      /*
       * Insertion 
       */
      if (!ic)
	{
	  int32 old_x;
	  long cum_change;

	  old_x = the_ch;
	  p = GET_CHILD (buffer, j);
	  rec_to_str (p, x);
	  rec_dirtify (rec);
	  rec_xfref (old_x, x);
	  cum_change = sr_length (x) - old_cum;
	  update_cums (rec, j, cum_change);
	  return rec;

	}
      else
	{
	  long cum_change;

	  the_ch = bnr_set_comp (the_ch, (t - prev_cum), 0, x);
	  cum_change = bnr_get_cum (the_ch) - old_cum;
	  buffer = rec_load (rec);
	  p = GET_CHILD (buffer, j);
	  rec_to_str (p, the_ch);
	  rec_dirtify (rec);
	  update_cums (rec, j, cum_change);
	  return rec;

	}

      return EMPTY;

    }
}

static void
split_in_two (int32 rec)
{
  unsigned char *buffer, *p, *q;
  unsigned char split_buffer[REC_SIZE];
  int32 newrec;
  unsigned char the_type;
  int nch, t, i;
  long cum, cum_last;

  bcopy (rec_load (rec), split_buffer, REC_SIZE);
  nch = NUM_CH (split_buffer);
  if (is_compound (split_buffer))
    the_type = bigstr_node_record;
  else
    the_type = bigstr_node_ncr;

  newrec = new_rec ();
  set_type (newrec, the_type);
  buffer = rec_load (newrec);
  t = nch / 2;
  p = GET_CUM (split_buffer, t);
  cum_last = str_to_cum (p);
  bcopy (GET_CUMS (split_buffer), GET_CUMS (buffer), CUM_SIZE * t);
  bcopy (GET_CHILDREN (split_buffer), GET_CHILDREN (buffer), CHILD_SIZE * t);
  SET_NUM_CH (buffer, t);
  rec_dirtify (newrec);

  cum_to_str (GET_CUMS (split_buffer), cum_last);
  rec_to_str (GET_CHILDREN (split_buffer), newrec);

  nch = nch - t;
  newrec = new_rec ();
  set_type (newrec, the_type);
  buffer = rec_load (newrec);
  bcopy (GET_CUM (split_buffer, t + 1),
	 GET_CUMS (buffer),
	 CUM_SIZE * nch);
  bcopy (GET_CHILD (split_buffer, t + 1),
	 GET_CHILDREN (buffer),
	 CHILD_SIZE * nch);

  p = GET_CUMS (buffer);
  for (i = 1; i <= nch; i++)
    {
      cum = str_to_cum (p);
      cum_to_str (p, cum - cum_last);
      NEXT_CUM (p);
    }
  SET_NUM_CH (buffer, nch);
  rec_dirtify (newrec);

  cum_to_str (GET_CUM (split_buffer, 2), cum);
  rec_to_str (GET_CHILD (split_buffer, 2), newrec);

  SET_NUM_CH (split_buffer, 2);
  rec_setrecbuf (rec, split_buffer, REC_SIZE);
  set_is_compound (rec, TRUE);
  rec_dirtify (rec);

}

int32
bnr_insert (int32 rec, long t, int flag, int32 x)
{
  unsigned char *buffer, *p;
  int i, j, n_ch;
  long l, the_cum, prev_cum, last_cum, x_cum;
  int ic;
  int32 the_ch, recno, new_r;

  if (rec_refcount (rec) > 1)
    {
      new_r = rec_abs_copy (rec);
      rec_increfs (new_r, 1);
      rec_incref (rec, -1);
      rec = new_r;
      rec_dirtify (rec);
    }

  x_cum = sr_length (x);

  buffer = rec_load (rec);
  last_cum = bnr_get_cum (rec);
  ic = is_compound (buffer);

  if (!ic)
    rec_incref (x, 1);

  buffer = rec_load (rec);

  if (flag == 1)
    {
      n_ch = NUM_CH (buffer);
      j = 0;
      the_cum = prev_cum = 0;
    }
  else
    {
      p = GET_CUMS (buffer);
      prev_cum = 0;
      n_ch = NUM_CH (buffer);
      j = 1;
      while ((j <= n_ch) && (t > (l = str_to_cum (p))))
	{
	  j++;
	  NEXT_CUM (p);
	  prev_cum = l;
	}
      if (j > n_ch)
	{
	  j = 0;
	}
      else
	{
	  the_cum = l;
	}
    }

  if (j == 0)
    {
      if (!ic)
	{
	  p = GET_CHILD (buffer, n_ch + 1);
	  rec_to_str (p, x);
	  p = GET_CUM (buffer, n_ch + 1);
	  cum_to_str (p, last_cum + x_cum);
	  n_ch++;
	  SET_NUM_CH (buffer, n_ch);
	  rec_dirtify (rec);
	  if (n_ch > bnr_hi_lim)
	    {
	      split_in_two (rec);
	    }
	  return rec;

	}
      else
	{			/*
				 * is compound 
				 */
	  int32 last_child;

	  p = GET_CHILD (buffer, n_ch);
	  last_child = str_to_rec (p);
	  last_child = bnr_insert (last_child, 0, 1, x);
	  buffer = rec_load (rec);
	  p = GET_CHILD (buffer, n_ch);
	  rec_to_str (p, last_child);
	  p = GET_CUM (buffer, n_ch);

	  cum_to_str (p, last_cum + x_cum);
	  rec_dirtify (rec);

	  p = rec_load (last_child);
	  if (NUM_CH (p) <= (bnr_hi_lim - 1))
	    return rec;

	  split_node (rec, n_ch);
	  buffer = rec_load (rec);
	  if (NUM_CH (buffer) <= bnr_hi_lim)
	    return rec;

	  split_in_two (rec);
	  return rec;

	}

    }
  if (!ic)
    {

      p = GET_CUM (buffer, n_ch + 2) - 1;
      for (i = 1; i <= CUM_SIZE * (n_ch - j + 1); i++)
	{
	  *p = *(GET_PREV_CUM (p));
	  p--;
	}
      p = GET_CUM (buffer, j);

      /*
       * Points to cum j 
       */

      if (j == 1)
	cum_to_str (p, 0);
      else
	cum_to_str (p, str_to_cum (GET_PREV_CUM (p)));

      p = GET_CHILD (buffer, n_ch + 2) - 1;

      for (i = 1; i <= CHILD_SIZE * (n_ch - j + 1); i++)
	{
	  *p = *(GET_PREV_CHILD (p));
	  p--;
	}

      p = GET_CHILD (buffer, j);
      /*
       * Points to ch j 
       */

      rec_to_str (p, x);

      n_ch++;
      SET_NUM_CH (buffer, n_ch);
      rec_dirtify (rec);
      update_cums (rec, j, x_cum);
      buffer = rec_load (rec);

      if (n_ch > bnr_hi_lim)
	{
	  split_in_two (rec);
	}
      return rec;

    }
  else
    {				/*
				 * is compound 
				 */
      int32 child;

      p = GET_CHILD (buffer, j);
      child = str_to_rec (p);
      child = bnr_insert (child, (t - prev_cum), 0, x);

      buffer = rec_load (rec);
      p = GET_CHILD (buffer, j);
      rec_to_str (p, child);
      rec_dirtify (rec);
      update_cums (rec, j, x_cum);

      p = rec_load (child);
      if (NUM_CH (p) <= (bnr_hi_lim - 1))
	return rec;

      split_node (rec, j);
      buffer = rec_load (rec);
      if (NUM_CH (buffer) <= bnr_hi_lim)
	return rec;

      split_in_two (rec);
      return rec;

    }

}
